/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.filters.plugin.attribute;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.gephi.filters.plugin.attribute.AttributeEqualBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class EqualStringPanel
extends JPanel
implements ActionListener {
    private AttributeEqualBuilder.EqualStringFilter filter;
    private JLabel labelPattern;
    private JButton okButton;
    private JCheckBox regexCheckbox;
    private JTextField textField;

    public EqualStringPanel() {
        this.initComponents();
        this.okButton.addActionListener(this);
    }

    public static ValidationPanel createValidationPanel(final EqualStringPanel innerPanel) {
        final ValidationPanel validationPanel = new ValidationPanel();
        validationPanel.setInnerComponent((Component)innerPanel);
        ValidationGroup group = validationPanel.getValidationGroup();
        validationPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                innerPanel.okButton.setEnabled(!validationPanel.isProblem());
            }
        });
        group.add((JTextComponent)innerPanel.textField, new Validator[]{new RegexValidator(innerPanel)});
        return validationPanel;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        FilterProperty pattern = this.filter.getProperties()[1];
        FilterProperty useRegex = this.filter.getProperties()[2];
        try {
            if (pattern.getValue() == null || !pattern.getValue().equals(this.textField.getText())) {
                pattern.setValue((Object)this.textField.getText());
            }
            if (useRegex.getValue() == null || !useRegex.getValue().equals(this.regexCheckbox.isSelected())) {
                useRegex.setValue((Object)this.regexCheckbox.isSelected());
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public void setup(AttributeEqualBuilder.EqualStringFilter filter) {
        this.filter = filter;
        this.setToolTipText(filter.getName() + " '" + filter.getColumn().getTitle() + "'");
        FilterProperty pattern = filter.getProperties()[1];
        FilterProperty useRegex = filter.getProperties()[2];
        try {
            this.textField.setText((String)pattern.getValue());
            this.regexCheckbox.setSelected((Boolean)useRegex.getValue());
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private void initComponents() {
        this.labelPattern = new JLabel();
        this.textField = new JTextField();
        this.regexCheckbox = new JCheckBox();
        this.okButton = new JButton();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.labelPattern.setText(NbBundle.getMessage(EqualStringPanel.class, (String)"EqualStringPanel.labelPattern.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.add((Component)this.labelPattern, gridBagConstraints);
        this.textField.setText(NbBundle.getMessage(EqualStringPanel.class, (String)"EqualStringPanel.textField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.textField, gridBagConstraints);
        this.regexCheckbox.setText(NbBundle.getMessage(EqualStringPanel.class, (String)"EqualStringPanel.regexCheckbox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.regexCheckbox, gridBagConstraints);
        this.okButton.setText(NbBundle.getMessage(EqualStringPanel.class, (String)"EqualStringPanel.okButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.add((Component)this.okButton, gridBagConstraints);
    }

    private static class RegexValidator
    implements Validator<String> {
        private final EqualStringPanel panel;

        public RegexValidator(EqualStringPanel panel) {
            this.panel = panel;
        }

        public boolean validate(Problems problems, String compName, String model) {
            boolean result = true;
            if (this.panel.regexCheckbox.isSelected()) {
                try {
                    Pattern pattern = Pattern.compile(model);
                }
                catch (Exception e) {
                    result = false;
                }
                if (!result) {
                    String message = "Invalid regex";
                    problems.add(message);
                }
            }
            return result;
        }
    }
}

