/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout;

import org.gephi.layout.LayoutModelImpl;
import org.gephi.layout.api.LayoutController;
import org.gephi.layout.api.LayoutModel;
import org.gephi.layout.spi.Layout;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LayoutControllerImpl
implements LayoutController {
    private LayoutModelImpl model;
    private LayoutRun layoutRun;

    public LayoutControllerImpl() {
        ((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
                if (workspace.getLookup().lookup(LayoutModelImpl.class) == null) {
                    workspace.add((Object)new LayoutModelImpl(workspace));
                }
            }

            public void select(Workspace workspace) {
                LayoutControllerImpl.this.model = (LayoutModelImpl)workspace.getLookup().lookup(LayoutModelImpl.class);
                if (LayoutControllerImpl.this.model == null) {
                    LayoutControllerImpl.this.model = new LayoutModelImpl(workspace);
                }
                workspace.add((Object)LayoutControllerImpl.this.model);
            }

            public void unselect(Workspace workspace) {
                if (LayoutControllerImpl.this.model != null && LayoutControllerImpl.this.model.getSelectedLayout() != null) {
                    LayoutControllerImpl.this.model.saveProperties(LayoutControllerImpl.this.model.getSelectedLayout());
                }
            }

            public void close(Workspace workspace) {
                LayoutModelImpl layoutModel = (LayoutModelImpl)workspace.getLookup().lookup(LayoutModelImpl.class);
                if (layoutModel != null) {
                    layoutModel.getExecutor().cancel();
                }
            }

            public void disable() {
                LayoutControllerImpl.this.model = null;
            }
        });
        ProjectController projectController = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        if (projectController.getCurrentWorkspace() != null) {
            this.model = (LayoutModelImpl)projectController.getCurrentWorkspace().getLookup().lookup(LayoutModelImpl.class);
            if (this.model == null) {
                this.model = new LayoutModelImpl(projectController.getCurrentWorkspace());
            }
            projectController.getCurrentWorkspace().add((Object)this.model);
        }
    }

    @Override
    public LayoutModel getModel() {
        return this.model;
    }

    @Override
    public void setLayout(Layout layout) {
        this.model.setSelectedLayout(layout);
    }

    @Override
    public void executeLayout() {
        if (this.model.getSelectedLayout() != null) {
            this.layoutRun = new LayoutRun(this.model.getSelectedLayout());
            this.model.getExecutor().execute((LongTask)this.layoutRun, (Runnable)this.layoutRun);
            this.model.setRunning(true);
        }
    }

    @Override
    public void executeLayout(int numIterations) {
        if (this.model.getSelectedLayout() != null) {
            this.layoutRun = new LayoutRun(this.model.getSelectedLayout(), numIterations);
            this.model.getExecutor().execute((LongTask)this.layoutRun, (Runnable)this.layoutRun);
            this.model.setRunning(true);
        }
    }

    @Override
    public boolean canExecute() {
        return this.model.getSelectedLayout() != null && !this.model.isRunning();
    }

    @Override
    public boolean canStop() {
        return this.model.isRunning();
    }

    @Override
    public void stopLayout() {
        this.model.getExecutor().cancel();
    }

    private static class LayoutRun
    implements LongTask,
    Runnable {
        private final Layout layout;
        private final Integer iterations;
        private boolean stopRun = false;
        private ProgressTicket progressTicket;

        public LayoutRun(Layout layout) {
            this.layout = layout;
            this.iterations = null;
        }

        public LayoutRun(Layout layout, int numIterations) {
            this.layout = layout;
            this.iterations = numIterations;
        }

        @Override
        public void run() {
            Progress.setDisplayName((ProgressTicket)this.progressTicket, (String)this.layout.getBuilder().getName());
            Progress.start((ProgressTicket)this.progressTicket);
            this.layout.initAlgo();
            long i = 0L;
            while (this.layout.canAlgo() && !this.stopRun) {
                this.layout.goAlgo();
                if (this.iterations == null || this.iterations.longValue() != ++i) continue;
            }
            this.layout.endAlgo();
            if (i > 1L) {
                Progress.finish((ProgressTicket)this.progressTicket, (String)NbBundle.getMessage(LayoutControllerImpl.class, (String)"LayoutRun.end", (Object)this.layout.getBuilder().getName(), (Object)i));
            } else {
                Progress.finish((ProgressTicket)this.progressTicket);
            }
        }

        public boolean cancel() {
            this.stopRun = true;
            if (this.layout instanceof LongTask) {
                return ((LongTask)this.layout).cancel();
            }
            return false;
        }

        public void setProgressTicket(ProgressTicket progressTicket) {
            this.progressTicket = progressTicket;
            if (this.layout instanceof LongTask) {
                ((LongTask)this.layout).setProgressTicket(progressTicket);
            }
        }
    }
}

