/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.File;
import java.io.FilePermission;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.PropertyPermission;
import org.freeplane.core.util.Compat;
import org.freeplane.plugin.script.ScriptClassLoader;

class ScriptingPolicy
extends Policy {
    private static final AllPermission ALL_PERMISSION = new AllPermission();
    private final Policy defaultPolicy;
    private final Permissions permissions;
    private final Permissions permissionBlackList;
    private final CodeSource userLibCodeSource;

    public ScriptingPolicy(Policy policy) {
        CodeSource userLibCodeSource;
        this.defaultPolicy = policy;
        this.permissions = new Permissions();
        this.permissionBlackList = new Permissions();
        this.permissionBlackList.add(new PropertyPermission("org.freeplane.basedirectory", "write"));
        this.permissionBlackList.add(new PropertyPermission("org.freeplane.userfpdir", "write"));
        try {
            String userLibDirectory = Compat.getApplicationUserDirectory() + "/lib/-";
            URL userLibUrl = Compat.fileToUrl((File)new File(userLibDirectory));
            userLibCodeSource = new CodeSource(userLibUrl, (Certificate[])null);
            this.permissionBlackList.add(new FilePermission(userLibDirectory, "write,delete"));
            String applicationDirectory = new File(System.getProperty("org.freeplane.basedirectory")).getCanonicalPath();
            this.permissionBlackList.add(new FilePermission(applicationDirectory + "/-", "write,delete"));
        }
        catch (Exception e) {
            userLibCodeSource = new CodeSource(null, (Certificate[])null);
        }
        this.userLibCodeSource = userLibCodeSource;
        this.permissions.add(new FilePermission(Compat.getApplicationUserDirectory() + "/resources/-", "read"));
        this.permissions.add(new FilePermission(Compat.getApplicationUserDirectory() + "/icons/-", "read"));
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        Permission requiredPermission;
        if (this.defaultPolicy.implies(domain, permission) || this.userLibCodeSource.implies(domain.getCodeSource())) {
            return true;
        }
        Permission permission2 = requiredPermission = this.permissionBlackList.implies(permission) ? ALL_PERMISSION : permission;
        if (this.permissions.implies(requiredPermission)) {
            return true;
        }
        for (ClassLoader classLoader = domain.getClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            if (!(classLoader instanceof ScriptClassLoader)) continue;
            return ((ScriptClassLoader)((Object)classLoader)).implies(requiredPermission);
        }
        return false;
    }

    public static void installRestrictingPolicy() {
        ScriptClassLoader.class.getClassLoader();
        Policy.setPolicy(new ScriptingPolicy(Policy.getPolicy()));
    }
}

