/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.ConfigurationUtils;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.MenuUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.plugin.script.FreeplaneScriptBaseClass;
import org.freeplane.plugin.script.ScriptResources;
import org.freeplane.plugin.script.addons.ScriptAddOnProperties;

class ScriptingConfiguration {
    private static Map<String, Object> staticProperties = ScriptingConfiguration.createStaticProperties();
    private static final FilenameFilter JAR_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };

    ScriptingConfiguration() {
        ArrayList<String> classpath = this.buildClasspath();
        ScriptResources.setClasspath(classpath);
        this.addPluginDefaults();
    }

    private void addPluginDefaults() {
        URL defaults = this.getClass().getResource("defaults.properties");
        if (defaults == null) {
            throw new RuntimeException("cannot open defaults.properties");
        }
        Controller.getCurrentController().getResourceController().addDefaults(defaults);
    }

    private List<ScriptAddOnProperties> getInstalledScriptAddOns() {
        ArrayList<ScriptAddOnProperties> installedAddOns = new ArrayList<ScriptAddOnProperties>();
        for (AddOnProperties addOnProperties : AddOnsController.getController().getInstalledAddOns()) {
            if (addOnProperties.getAddOnType() != AddOnProperties.AddOnType.SCRIPT) continue;
            installedAddOns.add((ScriptAddOnProperties)addOnProperties);
        }
        return installedAddOns;
    }

    private File getPrivateAddOnDirectory(AddOnProperties addOnProperties) {
        return new File(AddOnsController.getController().getAddOnsDir(), addOnProperties.getName());
    }

    private File createFile(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(ResourceController.getResourceController().getFreeplaneUserDirectory(), path);
        }
        return file;
    }

    private ArrayList<String> buildClasspath() {
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(ScriptResources.getPrecompiledScriptsDir().getAbsolutePath());
        this.addClasspathForAddOns(classpath);
        this.addClasspathForConfiguredEntries(classpath);
        return classpath;
    }

    private void addClasspathForAddOns(ArrayList<String> classpath) {
        List<ScriptAddOnProperties> installedScriptAddOns = this.getInstalledScriptAddOns();
        for (ScriptAddOnProperties scriptAddOnProperties : installedScriptAddOns) {
            List<String> lib = scriptAddOnProperties.getLib();
            if (lib == null) continue;
            for (String libEntry : lib) {
                File dir = new File(this.getPrivateAddOnDirectory(scriptAddOnProperties), "lib");
                classpath.add(new File(dir, libEntry).getAbsolutePath());
            }
        }
    }

    private void addClasspathForConfiguredEntries(ArrayList<String> classpath) {
        for (File classpathElement : this.uniqueClassPathElements(ResourceController.getResourceController())) {
            this.addClasspathElement(classpath, classpathElement);
        }
    }

    private Set<File> uniqueClassPathElements(ResourceController resourceController) {
        String classpathString = resourceController.getProperty("script_classpath");
        LinkedHashSet<File> classpathElements = new LinkedHashSet<File>();
        if (classpathString != null) {
            for (String string : ConfigurationUtils.decodeListValue((String)classpathString, (boolean)false)) {
                classpathElements.add(this.createFile(string));
            }
        }
        classpathElements.add(ScriptResources.getUserLibDir());
        return classpathElements;
    }

    private void addClasspathElement(ArrayList<String> classpath, File classpathElement) {
        File file = classpathElement;
        if (!file.exists()) {
            LogUtils.warn((String)("classpath entry '" + classpathElement + "' doesn't exist. (Use " + File.pathSeparator + " to separate entries.)"));
        } else if (file.isDirectory()) {
            classpath.add(file.getAbsolutePath());
            for (File jar : file.listFiles(JAR_FILE_FILTER)) {
                classpath.add(jar.getAbsolutePath());
            }
        } else {
            classpath.add(file.getAbsolutePath());
        }
    }

    List<String> getClasspath() {
        return ScriptResources.getClasspath();
    }

    public static Map<String, Object> getStaticProperties() {
        return staticProperties;
    }

    private static Map<String, Object> createStaticProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("logger", new LogUtils());
        properties.put("ui", new UITools());
        properties.put("htmlUtils", HtmlUtils.getInstance());
        properties.put("textUtils", new TextUtils());
        properties.put("menuUtils", new MenuUtils());
        properties.put("config", new FreeplaneScriptBaseClass.ConfigProperties());
        return properties;
    }
}

