/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import groovy.lang.Binding;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.freeplane.api.ControllerRO;
import org.freeplane.api.NodeRO;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.ScannerController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.Convertible;
import org.freeplane.plugin.script.proxy.Proxy;
import org.freeplane.plugin.script.proxy.ProxyFactory;

public abstract class FreeplaneScriptBaseClass
extends Script {
    private final Pattern nodeIdPattern = Pattern.compile("ID_\\d+");
    private final MetaClass nodeMetaClass = InvokerHelper.getMetaClass(NodeRO.class);
    private Object script;
    private Map<Object, Object> boundVariables;
    private NodeRO node;
    private ControllerRO controller;

    public FreeplaneScriptBaseClass() {
    }

    public FreeplaneScriptBaseClass(Binding binding) {
        this();
        this.setBinding(binding);
    }

    public void setBinding(Binding binding) {
        super.setBinding(binding);
        if (binding.hasVariable("node") && binding.hasVariable("c")) {
            Object nodeProxy = binding.getVariable("node");
            Object controllerProxy = binding.getVariable("c");
            this.boundVariables = binding.getVariables();
            if (nodeProxy instanceof NodeRO || nodeProxy == null) {
                this.node = (NodeRO)nodeProxy;
            }
            if (controllerProxy instanceof ControllerRO || controllerProxy == null) {
                this.controller = (ControllerRO)controllerProxy;
            }
        }
    }

    void setScript(Object script) {
        this.script = script;
    }

    FreeplaneScriptBaseClass withBinding(NodeModel node, ScriptContext scriptContext) {
        try {
            FreeplaneScriptBaseClass instance = this.boundVariables != null ? (FreeplaneScriptBaseClass)((Object)((Object)((Object)this)).getClass().newInstance()) : this;
            instance.script = this.script;
            Proxy.Controller controllerProxy = ProxyFactory.createController(scriptContext);
            Proxy.Node nodeProxy = ProxyFactory.createNode(node, scriptContext);
            Binding binding = this.createBinding(nodeProxy, controllerProxy);
            instance.setBinding(binding);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    protected Binding createBinding(NodeRO nodeProxy, ControllerRO controllerProxy) {
        Binding binding = new Binding(new LinkedHashMap(this.getBinding().getVariables()));
        binding.setVariable("c", (Object)controllerProxy);
        binding.setVariable("node", (Object)nodeProxy);
        return binding;
    }

    public Object getProperty(String property) {
        if (property.equals("node")) {
            return this.node;
        }
        if (property.equals("c")) {
            return this.controller;
        }
        if (this.nodeIdPattern.matcher(property).matches()) {
            return this.N(property);
        }
        Object boundValue = this.boundVariables.get(property);
        if (boundValue != null) {
            return boundValue;
        }
        if (this.node != null) {
            try {
                return this.nodeMetaClass.getProperty((Object)this.node, property);
            }
            catch (MissingPropertyException missingPropertyException) {
                // empty catch block
            }
        }
        return super.getProperty(property);
    }

    public Object invokeMethod(String methodName, Object args) {
        try {
            return super.invokeMethod(methodName, args);
        }
        catch (MissingMethodException mme) {
            return this.nodeMetaClass.invokeMethod((Object)this.node, methodName, args);
        }
    }

    public NodeRO N(String id) {
        NodeRO node = (NodeRO)this.getBinding().getVariable("node");
        return node.getMindMap().node(id);
    }

    public String T(String id) {
        NodeRO n = this.N(id);
        return n == null ? null : n.getText();
    }

    public Object V(String id) {
        NodeRO n = this.N(id);
        try {
            return n == null ? null : n.getValue();
        }
        catch (ExecuteScriptException e) {
            return null;
        }
    }

    public Object ifNull(Object value, Object valueIfNull) {
        return value == null ? valueIfNull : value;
    }

    public Long round(Double d) {
        if (d == null) {
            return null;
        }
        return Math.round(d);
    }

    public Double round(Double d, int precision) {
        if (d == null) {
            return d;
        }
        double factor = 1.0;
        for (int i = 0; i < precision; ++i) {
            factor *= 10.0;
        }
        return (double)Math.round(d * factor) / factor;
    }

    public Object parse(String text) {
        return ScannerController.getController().parse(text);
    }

    public Object format(Object object, String formatString) {
        return FormatController.format((Object)object, (String)formatString);
    }

    public Object format(Object object) {
        return FormatController.formatUsingDefault((Object)object);
    }

    public Object formatDate(Date date) {
        String format = FormatController.getController().getDefaultDateFormat().toPattern();
        return FormatController.format((Object)date, (String)format);
    }

    public String toString(Object o) {
        return Convertible.toString(o);
    }

    public void loadUri(URI uri) {
        NodeModel delegate = (NodeModel)((AbstractProxy)this.node).getDelegate();
        LinkController.getController().loadURI(delegate, new Hyperlink(uri));
    }

    public void loadUri(String link) {
        try {
            NodeModel delegate = (NodeModel)((AbstractProxy)this.node).getDelegate();
            LinkController.getController().loadURI(delegate, LinkController.createHyperlink((String)link));
        }
        catch (URISyntaxException e) {
            LogUtils.warn((Throwable)e);
        }
    }

    public String toString() {
        return "Script [" + this.script + "]";
    }

    public static class ConfigProperties {
        public boolean getBooleanProperty(String name) {
            return ResourceController.getResourceController().getBooleanProperty(name);
        }

        public double getDoubleProperty(String name, double defaultValue) {
            return ResourceController.getResourceController().getDoubleProperty(name, defaultValue);
        }

        public int getIntProperty(String name) {
            return ResourceController.getResourceController().getIntProperty(name);
        }

        public int getIntProperty(String name, int defaultValue) {
            return ResourceController.getResourceController().getIntProperty(name, defaultValue);
        }

        public long getLongProperty(String name, int defaultValue) {
            return ResourceController.getResourceController().getLongProperty(name, (long)defaultValue);
        }

        public String getProperty(String name) {
            return ResourceController.getResourceController().getProperty(name);
        }

        public String getProperty(String name, String defaultValue) {
            return ResourceController.getResourceController().getProperty(name, defaultValue);
        }

        public Properties getProperties() {
            return ResourceController.getResourceController().getProperties();
        }

        public String getAt(String name) {
            return this.getProperty(name);
        }

        public ResourceBundle getResources() {
            return ResourceController.getResourceController().getResources();
        }

        public String getFreeplaneUserDirectory() {
            return ResourceController.getResourceController().getFreeplaneUserDirectory();
        }
    }
}

