/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.script.CachedResult;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.NodeScript;
import org.freeplane.plugin.script.dependencies.RelatedElements;

public class FormulaCache
implements IExtension {
    private final HashMap<String, LinkedHashMap<String, CachedResult>> cache = new HashMap();
    static final boolean ENABLE_CACHING = !Controller.getCurrentController().getResourceController().getBooleanProperty("formula_disable_caching");

    static void removeFromCache(ArrayList<NodeModel> dependencies) {
        if (ENABLE_CACHING) {
            for (NodeModel nodeModel : dependencies) {
                FormulaCache.of(nodeModel.getMap()).remove(nodeModel);
            }
        }
    }

    Object getOrThrowCachedResult(NodeScript nodeScript) {
        LinkedHashMap<String, CachedResult> cacheEntry = this.cache.get(nodeScript.node.getID());
        if (cacheEntry == null) {
            return null;
        }
        CachedResult cachedResult = cacheEntry.get(nodeScript.script);
        if (cachedResult == null) {
            return null;
        }
        return this.getOrThrowCachedResult(cachedResult.returnedValue);
    }

    private Object getOrThrowCachedResult(Object object) {
        if (object instanceof ExecuteScriptException) {
            throw (ExecuteScriptException)object;
        }
        return object;
    }

    void put(NodeScript nodeScript, CachedResult result) {
        this.getOrAdd(nodeScript.node).put(nodeScript.script, result);
    }

    private LinkedHashMap<String, CachedResult> getOrAdd(NodeModel node) {
        LinkedHashMap<String, CachedResult> cacheEntry = this.cache.get(node.getID());
        if (cacheEntry == null) {
            cacheEntry = new LinkedHashMap(8);
            this.cache.put(node.getID(), cacheEntry);
        }
        return cacheEntry;
    }

    void remove(NodeModel node) {
        LinkedHashMap<String, CachedResult> entry = this.cache.get(node.getID());
        if (entry != null) {
            entry.clear();
        }
    }

    static FormulaCache of(MapModel map) {
        FormulaCache formulaCache = (FormulaCache)map.getExtension(FormulaCache.class);
        if (formulaCache == null) {
            formulaCache = new FormulaCache();
            map.addExtension((IExtension)formulaCache);
        }
        return formulaCache;
    }

    static void removeFrom(MapModel map) {
        map.removeExtension(FormulaCache.class);
    }

    RelatedElements getAccessedValues(NodeModel node, String script) {
        if (ENABLE_CACHING) {
            LinkedHashMap<String, CachedResult> cacheEntry = this.cache.get(node.getID());
            if (cacheEntry == null) {
                return null;
            }
            CachedResult cachedResult = cacheEntry.get(script);
            if (cachedResult != null) {
                return cachedResult.relatedElements;
            }
        }
        return null;
    }
}

