/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.net.protocol.data;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

final class Messages {
    private static final Map<Locale, ResourceBundle> BUNDLES = new HashMap<Locale, ResourceBundle>();
    static final DataURLConnection_ dataURLConnection = new DataURLConnection_();
    static final Handler_ handler = new Handler_();
    static final MediaType_ mediaType = new MediaType_();

    private Messages() {
        throw new IllegalStateException("cannot create instances of " + this.getClass().getName());
    }

    private static synchronized ResourceBundle getResourceBundle(Locale locale) {
        Locale l = Messages.nonNull(locale);
        ResourceBundle bundle = BUNDLES.get(l);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("com.github.robtimus.net.protocol.data.data-url", l);
            BUNDLES.put(l, bundle);
        }
        return bundle;
    }

    private static String getString(Locale locale, String key) {
        ResourceBundle bundle = Messages.getResourceBundle(locale);
        return bundle.getString(key);
    }

    private static Locale nonNull(Locale locale) {
        return locale != null ? locale : Locale.getDefault(Locale.Category.FORMAT);
    }

    static final class MediaType_ {
        final InvalidMimeType_ invalidMimeType = new InvalidMimeType_();

        private MediaType_() {
        }

        static final class InvalidMimeType_ {
            private InvalidMimeType_() {
            }

            String get(Object arg) {
                return this.get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = Messages.nonNull(locale);
                String s = Messages.getString(l, "mediaType.invalidMimeType");
                return String.format(l, s, arg);
            }
        }
    }

    static final class Handler_ {
        final InvalidProtocol_ invalidProtocol = new InvalidProtocol_();
        final MissingComma_ missingComma = new MissingComma_();

        private Handler_() {
        }

        static final class MissingComma_ {
            private MissingComma_() {
            }

            String get(Object arg) {
                return this.get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = Messages.nonNull(locale);
                String s = Messages.getString(l, "handler.missingComma");
                return String.format(l, s, arg);
            }
        }

        static final class InvalidProtocol_ {
            private InvalidProtocol_() {
            }

            String get(Object arg1, Object arg2) {
                return this.get(null, arg1, arg2);
            }

            String get(Locale locale, Object arg1, Object arg2) {
                Locale l = Messages.nonNull(locale);
                String s = Messages.getString(l, "handler.invalidProtocol");
                return String.format(l, s, arg1, arg2);
            }
        }
    }

    static final class DataURLConnection_ {
        final GetInputStream_ getInputStream = new GetInputStream_();

        private DataURLConnection_() {
        }

        static final class GetInputStream_ {
            final FalseDoInput_ falseDoInput = new FalseDoInput_();

            private GetInputStream_() {
            }

            static final class FalseDoInput_ {
                private FalseDoInput_() {
                }

                String get() {
                    return this.get(null);
                }

                String get(Locale locale) {
                    Locale l = Messages.nonNull(locale);
                    return Messages.getString(l, "dataURLConnection.getInputStream.falseDoInput");
                }
            }
        }
    }
}

