/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.net.protocol.data;

import com.github.robtimus.net.protocol.data.DataURLConnection;
import com.github.robtimus.net.protocol.data.MediaType;
import com.github.robtimus.net.protocol.data.Messages;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class Handler
extends URLStreamHandler {
    public static final String PROTOCOL = "data";
    static final String BASE64_POSTFIX = ";base64";
    private static final int BASE64_POSTFIX_LENGTH = ";base64".length();

    @Override
    protected DataURLConnection openConnection(URL u) {
        this.validateProtocol(u);
        String spec = u.toExternalForm();
        int start = PROTOCOL.length() + 1;
        int limit = spec.length();
        int indexOfComma = this.validateCommaPresent(spec, start, limit);
        MediaType mediaType = this.getMediaType(spec, start, indexOfComma);
        boolean base64Data = this.isBase64Data(spec, indexOfComma);
        byte[] data = this.getData(spec, indexOfComma, limit, mediaType, base64Data);
        return new DataURLConnection(u, mediaType, data);
    }

    @Override
    protected DataURLConnection openConnection(URL u, Proxy p) {
        return this.openConnection(u);
    }

    @Override
    protected void parseURL(URL u, String spec, int start, int limit) {
        this.validateProtocol(u);
        int indexOfComma = this.validateCommaPresent(spec, start, limit);
        MediaType mediaType = this.getMediaType(spec, start, indexOfComma);
        boolean base64Data = this.isBase64Data(spec, indexOfComma);
        this.getData(spec, indexOfComma, limit, mediaType, base64Data);
        String path = spec.substring(start, limit);
        this.setURL(u, u.getProtocol(), null, -1, null, null, path, null, null);
    }

    private void validateProtocol(URL u) {
        if (!PROTOCOL.equals(u.getProtocol())) {
            throw new IllegalArgumentException(Messages.handler.invalidProtocol.get(PROTOCOL, u.getProtocol()));
        }
    }

    private int validateCommaPresent(String spec, int start, int limit) {
        int indexOfComma = spec.indexOf(44, start);
        if (indexOfComma == -1 || indexOfComma > limit) {
            throw new IllegalArgumentException(Messages.handler.missingComma.get(spec));
        }
        return indexOfComma;
    }

    private MediaType getMediaType(String spec, int start, int indexOfComma) {
        int end = indexOfComma;
        if (this.isBase64Data(spec, indexOfComma)) {
            end -= BASE64_POSTFIX_LENGTH;
        }
        return start == end ? MediaType.DEFAULT : MediaType.parse(spec, start, end);
    }

    private boolean isBase64Data(String spec, int indexOfComma) {
        return spec.regionMatches(indexOfComma - BASE64_POSTFIX_LENGTH, BASE64_POSTFIX, 0, BASE64_POSTFIX_LENGTH);
    }

    private byte[] getData(String spec, int indexOfComma, int limit, MediaType mediaType, boolean base64Data) {
        String dataPart = spec.substring(indexOfComma + 1, limit);
        if (base64Data) {
            String s = dataPart.replaceAll("\\s+", "");
            return Base64.getDecoder().decode(s);
        }
        try {
            Charset charset = Handler.getCharset(mediaType);
            String s = URLDecoder.decode(dataPart, charset.name());
            return s.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    static Charset getCharset(MediaType mediaType) {
        String encoding = mediaType == null ? null : mediaType.getCharset();
        return encoding == null ? StandardCharsets.US_ASCII : Charset.forName(encoding);
    }
}

