/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.SHTMLHelpBroker;
import com.lightdev.app.shtm.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

class DialogShell
extends JDialog
implements ActionListener {
    protected JPanel buttonPanel;
    protected AbstractButton okButton;
    protected AbstractButton cancelButton;
    protected AbstractButton helpButton;
    private int result;
    public static int RESULT_CANCEL = 1;
    public static int RESULT_OK = 0;
    protected String helpTopicId = null;
    private KeyListener completionKeyListener = null;

    public DialogShell(Window parent, String title) {
        this(parent, title, (String)null);
    }

    public DialogShell(Window parent, String title, String helpTopicId) {
        super(parent, title);
        this.helpTopicId = helpTopicId;
        this.buildDialog();
    }

    private void buildDialog() {
        this.enableEvents(64L);
        this.okButton = new JButton(Util.getResourceString("okBtnName"));
        this.cancelButton = new JButton(Util.getResourceString("cancelBtnName"));
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.buttonPanel = new JPanel(new FlowLayout());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        if (this.helpTopicId != null) {
            try {
                this.helpButton = SHTMLHelpBroker.createHelpButton(this.helpTopicId);
                this.helpButton.setText(Util.getResourceString("helpLabel"));
                this.buttonPanel.add(this.helpButton);
            }
            catch (NoClassDefFoundError e) {
                this.helpTopicId = null;
            }
        }
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.add((Component)this.buttonPanel, "South");
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    protected void cancel() {
        this.result = RESULT_CANCEL;
        this.dispose();
    }

    protected void confirm() {
        this.result = RESULT_OK;
        this.dispose();
    }

    public int getResult() {
        return this.result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.cancelButton) {
            this.cancel();
        } else if (src == this.okButton) {
            this.confirm();
        }
    }

    protected KeyListener getCompletionKeyListener() {
        if (this.completionKeyListener == null) {
            this.completionKeyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        e.consume();
                        DialogShell.this.cancel();
                    } else if (e.getKeyCode() == 10) {
                        e.consume();
                        DialogShell.this.confirm();
                    }
                }
            };
        }
        return this.completionKeyListener;
    }
}

