/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.EventQueue;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.view.swing.map.MapView;

class MapViewChangeObserverCompound {
    private final HashSet<IMapSelectionListener> mapListeners = new LinkedHashSet<IMapSelectionListener>();
    private final HashSet<IMapViewChangeListener> viewListeners = new LinkedHashSet<IMapViewChangeListener>();

    MapViewChangeObserverCompound() {
    }

    void addListener(IMapSelectionListener listener) {
        this.mapListeners.add(listener);
    }

    void addListener(IMapViewChangeListener listener) {
        this.viewListeners.add(listener);
    }

    void afterMapViewChange(MapView oldMap, MapView newMap) {
        MapModel newModel;
        MapModel oldModel = this.getModel(oldMap);
        if (oldModel != (newModel = this.getModel(newMap)) || newModel == null) {
            for (IMapSelectionListener iMapSelectionListener : this.mapListeners.toArray(new IMapSelectionListener[0])) {
                iMapSelectionListener.afterMapChange(oldModel, newModel);
            }
        }
        for (IMapViewChangeListener iMapViewChangeListener : this.viewListeners.toArray(new IMapViewChangeListener[0])) {
            iMapViewChangeListener.afterViewChange(oldMap, newMap);
        }
    }

    void afterMapViewClose(MapView pOldMap) {
        for (IMapViewChangeListener observer : this.viewListeners.toArray(new IMapViewChangeListener[0])) {
            observer.afterViewClose(pOldMap);
        }
    }

    void beforeMapViewChange(MapView oldMap, MapView newMap) {
        MapModel newModel;
        MapModel oldModel = this.getModel(oldMap);
        if (oldModel != (newModel = this.getModel(newMap))) {
            for (IMapSelectionListener iMapSelectionListener : this.mapListeners.toArray(new IMapSelectionListener[0])) {
                iMapSelectionListener.beforeMapChange(this.getModel(oldMap), this.getModel(newMap));
            }
        }
        for (IMapViewChangeListener iMapViewChangeListener : this.viewListeners.toArray(new IMapViewChangeListener[0])) {
            iMapViewChangeListener.beforeViewChange(oldMap, newMap);
        }
    }

    private MapModel getModel(MapView view) {
        return view == null ? null : view.getModel();
    }

    void mapViewCreated(MapView previousMapView, MapView createdMapView) {
        if (!createdMapView.isShowing()) {
            this.fireMapViewCreatedAfterItIsDisplayed(previousMapView, createdMapView);
        } else if (!createdMapView.isLayoutCompleted()) {
            this.fireMapViewCreatedLater(previousMapView, createdMapView);
        } else {
            this.fireMapViewCreated(previousMapView, createdMapView);
        }
    }

    private void fireMapViewCreatedLater(final MapView previousView, final MapView createdMapView) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapViewChangeObserverCompound.this.mapViewCreated(previousView, createdMapView);
            }
        });
    }

    private void fireMapViewCreatedAfterItIsDisplayed(final MapView previousView, final MapView createdMapView) {
        HierarchyListener retryEventListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (createdMapView.isShowing()) {
                    createdMapView.removeHierarchyListener(this);
                    MapViewChangeObserverCompound.this.mapViewCreated(previousView, createdMapView);
                }
            }
        };
        createdMapView.addHierarchyListener(retryEventListener);
    }

    private void fireMapViewCreated(MapView previousMapView, MapView createdMapView) {
        for (IMapViewChangeListener observer : this.viewListeners.toArray(new IMapViewChangeListener[0])) {
            observer.afterViewCreated(previousMapView, createdMapView);
        }
    }

    void removeListener(IMapSelectionListener listener) {
        this.mapListeners.remove(listener);
    }

    void removeListener(IMapViewChangeListener listener) {
        this.viewListeners.remove(listener);
    }
}

