/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import org.freeplane.features.map.MapController;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.view.swing.map.FoldingMark;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MouseArea;
import org.freeplane.view.swing.map.NodeView;

abstract class MainViewPainter {
    MainView mainView;

    MainViewPainter(MainView mainView) {
        this.mainView = mainView;
    }

    int getMainViewHeightWithFoldingMark() {
        return this.mainView.getHeight();
    }

    int getMainViewWidthWithFoldingMark() {
        int width = this.mainView.getWidth();
        NodeView nodeView = this.mainView.getNodeView();
        if (nodeView.isFolded()) {
            width += this.mainView.getZoomedFoldingSymbolHalfWidth() * 3;
        }
        return width;
    }

    int getSingleChildShift() {
        return 0;
    }

    Point getConnectorPoint(Point relativeLocation) {
        NodeView nodeView = this.mainView.getNodeView();
        if (relativeLocation.x > this.mainView.getWidth()) {
            Point rightPoint = this.getRightPoint();
            return rightPoint;
        }
        if (relativeLocation.x < 0) {
            Point leftPoint = this.getLeftPoint();
            return leftPoint;
        }
        if (relativeLocation.y > this.mainView.getHeight()) {
            Point bottomPoint = this.mainView.getBottomPoint();
            bottomPoint.y = nodeView.getContent().getHeight();
            return bottomPoint;
        }
        if (relativeLocation.y < 0) {
            return this.mainView.getTopPoint();
        }
        return this.getCenterPoint();
    }

    Point getCenterPoint() {
        return new Point(this.mainView.getWidth() / 2, this.mainView.getHeight() / 2);
    }

    abstract Point getLeftPoint();

    abstract Point getRightPoint();

    abstract NodeGeometryModel getShapeConfiguration();

    abstract void paintBackground(Graphics2D var1, Color var2);

    void paintComponent(Graphics graphics) {
        this.mainView.paintComponentDefault(graphics);
    }

    void paintDecoration(NodeView nodeView, Graphics2D g) {
        boolean shouldPaintCloneMarker;
        this.mainView.drawModificationRect(g);
        this.mainView.paintDragRectangle(g);
        this.paintFoldingMark(nodeView, g);
        boolean isMinimized = this.mainView.isShortened();
        boolean bl = shouldPaintCloneMarker = nodeView.getModel().isCloneNode() && this.mainView.shouldPaintCloneMarker(nodeView);
        if (isMinimized) {
            FoldingMark.SHORTENED.draw(g, nodeView, this.mainView.decorationMarkBounds(nodeView, shouldPaintCloneMarker ? 0.6 : 0.0, 2.3333333333333335, 1.6666666666666667));
        }
        if (shouldPaintCloneMarker) {
            if (nodeView.getModel().isCloneTreeRoot()) {
                FoldingMark.CLONE.draw(g, nodeView, this.mainView.decorationMarkBounds(nodeView, isMinimized ? -0.6 : 0.0, 2.0, 2.5));
            } else if (nodeView.getModel().isCloneTreeNode()) {
                FoldingMark.CLONE.draw(g, nodeView, this.mainView.decorationMarkBounds(nodeView, isMinimized ? -0.6 : 0.0, 1.5, 2.5));
            }
        }
    }

    void paintFoldingMark(NodeView nodeView, Graphics2D g) {
        boolean drawsControls;
        if (!this.mainView.hasChildren()) {
            return;
        }
        MapView map = this.mainView.getMap();
        MapController mapController = map.getModeController().getMapController();
        FoldingMark markType = this.mainView.foldingMarkType(mapController, nodeView);
        boolean bl = drawsControls = this.mainView.getMouseArea() != MouseArea.OUT && !map.isPrinting();
        if (markType == FoldingMark.FOLDING_CIRCLE_UNFOLDED && !drawsControls) {
            return;
        }
        Point p = this.mainView.getNodeView().isLeft() ? this.getLeftPoint() : this.getRightPoint();
        int width = drawsControls ? Math.max(16, this.mainView.getZoomedFoldingSymbolHalfWidth() * 2) : this.mainView.getZoomedFoldingSymbolHalfWidth() * 2;
        int halfWidth = width / 2;
        p.x = p.x <= 0 ? (p.x -= halfWidth) : (p.x += halfWidth);
        (drawsControls || markType != FoldingMark.FOLDING_CIRCLE_FOLDED ? markType : FoldingMark.FOLDING_CIRCLE_UNFOLDED).draw(g, nodeView, new Rectangle(p.x - halfWidth, p.y - halfWidth, halfWidth * 2, halfWidth * 2));
    }

    boolean areInsetsFixed() {
        return true;
    }

    Insets getZoomedInsets() {
        return this.mainView.getDefaultZoomedInsets();
    }

    Insets getInsets() {
        return this.mainView.getDefaultInsets();
    }

    Insets getInsets(Insets insets) {
        return this.mainView.getDefaultInsets(insets);
    }

    Dimension getPreferredSize() {
        return this.mainView.getDefaultPreferredSize();
    }

    void setBounds(int x, int y, int width, int height) {
        this.mainView.setBoundsDefault(x, y, width, height);
    }
}

