/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.MultipleImage;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.DashVariant;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.EdgeStyle;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodestyle.NodeCss;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.text.HighlightedTransformedObject;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.FoldingMark;
import org.freeplane.view.swing.map.FreeplaneTooltip;
import org.freeplane.view.swing.map.MainViewPainter;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MouseArea;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.PaintingMode;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.map.ZoomableLabelUI;

public class MainView
extends ZoomableLabel {
    static final int FOLDING_CIRCLE_WIDTH = 16;
    static final String USE_COMMON_OUT_POINT_FOR_ROOT_NODE_STRING = "use_common_out_point_for_root_node";
    public static boolean USE_COMMON_OUT_POINT_FOR_ROOT_NODE = ResourceController.getResourceController().getBooleanProperty("use_common_out_point_for_root_node");
    static Dimension maximumSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    static Dimension minimumSize = new Dimension(0, 0);
    private static final long serialVersionUID = 1L;
    protected int isDraggedOver = 0;
    private boolean isShortened;
    private TextModificationState textModified = TextModificationState.NONE;
    private MouseArea mouseArea = MouseArea.OUT;
    static final Stroke DEF_STROKE = new BasicStroke();
    private static final int DRAG_OVAL_WIDTH = 10;
    private float unzoomedBorderWidth = 1.0f;
    private DashVariant dash = DashVariant.DEFAULT;
    private Color borderColor = EdgeController.STANDARD_EDGE_COLOR;
    private Boolean borderColorMatchesEdgeColor = true;
    private MainViewPainter painter;
    private Color unselectedForeground = null;
    private static boolean ERROR_LOGGED = false;

    boolean isShortened() {
        return this.isShortened;
    }

    MainView() {
        this.setAlignmentX(0.5f);
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
        this.setHorizontalTextPosition(11);
        this.setVerticalTextPosition(1);
    }

    protected void convertPointFromMap(Point p) {
        UITools.convertPointFromAncestor(this.getMap(), p, this);
    }

    protected void convertPointToMap(Point p) {
        UITools.convertPointToAncestor((Component)this, p, this.getMap());
    }

    public boolean dropAsSibling(double xCoord) {
        if (this.getNodeView().isRoot()) {
            return false;
        }
        if (this.dropLeft(xCoord)) {
            return !this.isInVerticalRegion(xCoord, 0.6666666666666666);
        }
        return this.isInVerticalRegion(xCoord, 0.3333333333333333);
    }

    public boolean dropLeft(double xCoord) {
        NodeView nodeView = this.getNodeView();
        if (this.getNodeView().isRoot()) {
            return xCoord < (double)(this.getSize().width * 1 / 2);
        }
        return nodeView.isLeft();
    }

    public int getDeltaX() {
        NodeView nodeView = this.getNodeView();
        if (nodeView.isFolded() && nodeView.isLeft()) {
            return this.getZoomedFoldingSymbolHalfWidth() * 3;
        }
        return 0;
    }

    public int getDeltaY() {
        return 0;
    }

    public int getDraggedOver() {
        return this.isDraggedOver;
    }

    @Override
    public Dimension getMaximumSize() {
        return maximumSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return minimumSize;
    }

    int getZoomedFoldingSymbolHalfWidth() {
        return this.getNodeView().getZoomedFoldingSymbolHalfWidth();
    }

    public boolean isClickableLink(double xCoord) {
        NodeView nodeView = this.getNodeView();
        NodeModel model = nodeView.getModel();
        if (NodeLinks.getValidLink(model) == null) {
            return false;
        }
        return this.isInIconRegion(xCoord);
    }

    public boolean isInIconRegion(double xCoord) {
        Rectangle iconR = this.getIconRectangle();
        return xCoord >= (double)iconR.x && xCoord < (double)(iconR.x + iconR.width);
    }

    private Rectangle getIconRectangle() {
        ZoomableLabelUI zoomableLabelUI = (ZoomableLabelUI)this.getUI();
        Rectangle iconR = zoomableLabelUI.getIconR(this);
        return iconR;
    }

    public boolean isInVerticalRegion(double xCoord, double p) {
        return xCoord < (double)this.getSize().width * p;
    }

    @Override
    public final void paint(Graphics g) {
        PaintingMode paintingMode = this.getMap().getPaintingMode();
        if (!PaintingMode.SELECTED_NODES.equals((Object)paintingMode) && !PaintingMode.NODES.equals((Object)paintingMode)) {
            return;
        }
        NodeView nodeView = this.getNodeView();
        boolean selected = nodeView.isSelected();
        if (paintingMode.equals((Object)PaintingMode.SELECTED_NODES) == selected) {
            super.paint(g);
        }
    }

    public void paintDragOver(Graphics2D graphics) {
        if (this.isDraggedOver == 1 || this.isDraggedOver == 3) {
            this.paintDragOverSon(graphics);
        }
        if (this.isDraggedOver == 2) {
            this.paintDragOverSibling(graphics);
        }
    }

    private void paintDragOverSibling(Graphics2D graphics) {
        graphics.setPaint(new GradientPaint(0.0f, this.getHeight() * 3 / 5, this.getMap().getBackground(), 0.0f, this.getHeight() / 5, NodeView.dragColor));
        graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    private void paintDragOverSon(Graphics2D graphics) {
        if (this.getNodeView().isLeft() || this.isDraggedOver == 3) {
            graphics.setPaint(new GradientPaint(this.getWidth() * 3 / 4, 0.0f, this.getMap().getBackground(), this.getWidth() / 4, 0.0f, NodeView.dragColor));
            graphics.fillRect(0, 0, this.getWidth() * 3 / 4, this.getHeight() - 1);
        } else {
            graphics.setPaint(new GradientPaint(this.getWidth() / 4, 0.0f, this.getMap().getBackground(), this.getWidth() * 3 / 4, 0.0f, NodeView.dragColor));
            graphics.fillRect(this.getWidth() / 4, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    public FoldingMark foldingMarkType(MapController mapController, NodeView nodeView) {
        if (nodeView.isFolded() || nodeView.hasHiddenChildren()) {
            return FoldingMark.FOLDING_CIRCLE_FOLDED;
        }
        Filter filter = nodeView.getMap().getFilter();
        for (NodeView childView : nodeView.getChildrenViews()) {
            if (childView.getModel().hasVisibleContent(filter) || FoldingMark.FOLDING_CIRCLE_UNFOLDED.equals(this.foldingMarkType(mapController, childView))) continue;
            return FoldingMark.FOLDING_CIRCLE_FOLDED;
        }
        if (nodeView.getModel().isRoot()) {
            return FoldingMark.INVISIBLE;
        }
        return FoldingMark.FOLDING_CIRCLE_UNFOLDED;
    }

    boolean shouldPaintCloneMarker(NodeView nodeView) {
        ResourceController resourceController = ResourceController.getResourceController();
        return resourceController.getBooleanProperty("markClones") || nodeView.isSelected() && resourceController.getBooleanProperty("markSelectedClones");
    }

    Rectangle decorationMarkBounds(NodeView nodeView, double shiftYFactor, double widthFactor, double heightFactor) {
        int size = nodeView.getZoomedStateSymbolHalfWidth();
        int width = (int)((double)size * widthFactor);
        int x = nodeView.isLeft() ? this.getWidth() : 0 - width;
        int height = (int)((double)size * heightFactor);
        int y = (this.getHeight() - height) / 2 + (int)((double)height * shiftYFactor);
        Rectangle decorationMarkBounds = new Rectangle(x, y, width, height);
        return decorationMarkBounds;
    }

    void paintDragRectangle(Graphics g) {
        if (!MouseArea.MOTION.equals((Object)this.mouseArea)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Object renderingHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        MapView parent = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, this);
        parent.getModeController().getController().getMapViewManager().setEdgesRenderingHint(g2);
        Color color = g2.getColor();
        NodeView movedView = this.getNodeView();
        Rectangle r = this.getDragRectangle();
        if (movedView.isFree()) {
            g2.setColor(Color.BLUE);
            g.fillOval(r.x, r.y, r.width - 1, r.height - 1);
        } else if (LocationModel.getModel((NodeModel)movedView.getModel()).getHGap().value <= 0.0) {
            g2.setColor(Color.RED);
            g.fillOval(r.x, r.y, r.width - 1, r.height - 1);
        }
        g2.setColor(Color.BLACK);
        g.drawOval(r.x, r.y, r.width - 1, r.height - 1);
        g2.setColor(color);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
    }

    public Rectangle getDragRectangle() {
        int size = this.getDraggingWidth();
        Rectangle r = this.getNodeView().isLeft() ? new Rectangle(this.getWidth(), -size, size, this.getHeight() + size * 2) : new Rectangle(-size, -size, size, this.getHeight() + size * 2);
        return r;
    }

    void drawModificationRect(Graphics g) {
        Color color = g.getColor();
        if (TextModificationState.FAILURE.equals((Object)this.textModified)) {
            g.setColor(HighlightedTransformedObject.FAILURE_COLOR);
        } else if (MapView.isElementHighlighted(this, this.getNodeView().getModel())) {
            g.setColor(FilterController.HIGHLIGHT_COLOR);
        } else if (TextModificationState.HIGHLIGHT.equals((Object)this.textModified)) {
            boolean markTransformedText = TextController.isMarkTransformedTextSet();
            if (!markTransformedText) {
                return;
            }
            g.setColor(HighlightedTransformedObject.OK_COLOR);
        } else {
            return;
        }
        g.drawRect(-1, -1, this.getWidth() + 2, this.getHeight() + 2);
        g.setColor(color);
    }

    protected void paintBackgound(Graphics2D g) {
        Color color = this.getPaintedBackground();
        this.painter.paintBackground(g, color);
    }

    @Override
    public Color getUnselectedForeground() {
        return this.unselectedForeground;
    }

    public Color getPaintedBackground() {
        return this.getNodeView().getTextBackground();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (super.processKeyBinding(ks, e, condition, pressed)) {
            return true;
        }
        MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, this);
        FreeplaneMenuBar freeplaneMenuBar = mapView.getModeController().getController().getViewController().getFreeplaneMenuBar();
        return !freeplaneMenuBar.isVisible() && freeplaneMenuBar.processKeyBinding(ks, e, 2, pressed);
    }

    public void setDraggedOver(int draggedOver) {
        this.isDraggedOver = draggedOver;
    }

    public void setDraggedOver(Point p) {
        int draggedOver = this.getNodeView().isRoot() ? (this.dropLeft(p.getX()) ? 3 : 1) : (this.dropAsSibling(p.getX()) ? 2 : 1);
        this.setDraggedOver(draggedOver);
    }

    public void updateFont(NodeView node) {
        Font font = NodeStyleController.getController(node.getMap().getModeController()).getFont(node.getModel(), node.getStyleOption());
        this.setFont(UITools.scale(font));
    }

    void updateIcons(NodeView node) {
        MultipleImage iconImages = new MultipleImage();
        NodeModel model = node.getModel();
        if (node.getMap().showsIcons()) {
            LogicalStyleController.StyleOption styleOption = node.getStyleOption();
            Quantity<LengthUnit> iconHeight = IconController.getController().getIconSize(model, styleOption);
            for (UIIcon icon : IconController.getController().getStateIcons(model)) {
                iconImages.addIcon(icon, iconHeight);
            }
            ModeController modeController = this.getNodeView().getMap().getModeController();
            Collection<NamedIcon> icons = IconController.getController(modeController).getIcons(model, styleOption);
            for (NamedIcon myIcon : icons) {
                iconImages.addIcon(myIcon, iconHeight);
            }
        }
        this.addOwnIcons(iconImages, model, this.getNodeView().getStyleOption());
        this.setIcon(iconImages.getImageCount() > 0 ? iconImages : null);
    }

    private void addOwnIcons(MultipleImage iconImages, NodeModel model, LogicalStyleController.StyleOption option) {
        this.getNodeView().getMap().getModeController().getExtension(LinkController.class).addLinkDecorationIcons(iconImages, model, option);
    }

    void updateTextColor(NodeView node) {
        NodeStyleController styleController = NodeStyleController.getController(node.getMap().getModeController());
        Color newForeground = styleController.getColor(node.getModel(), node.getStyleOption());
        Color color = this.unselectedForeground = node.isSelected() ? styleController.getColor(node.getModel(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE) : newForeground;
        if (!Objects.equals(this.getForeground(), newForeground)) {
            this.setForeground(newForeground);
            this.revalidate();
        }
    }

    void updateCss(NodeView node) {
        NodeStyleController styleController = NodeStyleController.getController(node.getMap().getModeController());
        NodeCss newCss = styleController.getStyleSheet(node.getModel(), node.getStyleOption());
        this.setStyleSheet(newCss.css, newCss.getStyleSheet());
    }

    void updateHorizontalTextAlignment(NodeView node) {
        NodeStyleModel.HorizontalTextAlignment textAlignment = NodeStyleController.getController(node.getMap().getModeController()).getHorizontalTextAlignment(node.getModel(), node.getStyleOption());
        boolean isCenteredByDefault = textAlignment == NodeStyleModel.HorizontalTextAlignment.DEFAULT && node.getModel().isRoot();
        this.setHorizontalAlignment(isCenteredByDefault ? NodeStyleModel.HorizontalTextAlignment.CENTER.swingConstant : textAlignment.swingConstant);
    }

    public void updateText(NodeModel nodeModel) {
        String text;
        NodeView nodeView = this.getNodeView();
        if (nodeView == null) {
            return;
        }
        ModeController modeController = nodeView.getMap().getModeController();
        TextController textController = TextController.getController(modeController);
        this.isShortened = textController.isMinimized(nodeModel);
        Object userObject = nodeModel.getUserObject();
        try {
            Object transformedContent = textController.getTransformedObject(nodeModel);
            if (nodeView.isSelected()) {
                nodeView.getMap().getModeController().getController().getViewController().addObjectTypeInfo(transformedContent);
            }
            Icon icon = textController.getIcon(transformedContent);
            this.setTextRenderingIcon(icon);
            text = icon == null ? transformedContent.toString() : "";
            this.textModified = transformedContent instanceof HighlightedTransformedObject ? TextModificationState.HIGHLIGHT : TextModificationState.NONE;
        }
        catch (Throwable e) {
            LogUtils.warn(e.getMessage());
            text = TextUtils.format("MainView.errorUpdateText", String.valueOf(userObject), e.getLocalizedMessage());
            this.textModified = TextModificationState.FAILURE;
        }
        if (this.isShortened) {
            text = textController.getShortText(text);
        }
        text = this.convertTextToHtmlLink(text, nodeModel);
        this.updateText(text);
    }

    private String convertTextToHtmlLink(String text, NodeModel node) {
        Hyperlink link = NodeLinks.getLink(node);
        if (link == null || "menuitem".equals(link.getScheme()) || !LinkController.getController().formatNodeAsHyperlink(node)) {
            return text;
        }
        if (HtmlUtils.isHtml(text)) {
            text = HtmlUtils.htmlToPlain(text);
        }
        StringBuilder sb = new StringBuilder("<html><body><a href=\"");
        sb.append(link.toString());
        sb.append("\">");
        String xmlEscapedText = HtmlUtils.toHTMLEscapedText(text);
        sb.append(xmlEscapedText);
        sb.append("</a></body></html>");
        return sb.toString();
    }

    @Override
    public JToolTip createToolTip() {
        FreeplaneTooltip tip = new FreeplaneTooltip(this.getGraphicsConfiguration(), "text/html");
        tip.setComponent(this);
        URL url = this.getMap().getModel().getURL();
        if (url != null) {
            tip.setBase(url);
        } else {
            try {
                tip.setBase(new URL("file: "));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return tip;
    }

    @Override
    public void setBorder(Border border) {
    }

    public ConnectorLocation getConnectorLocation(Point relativeLocation) {
        if (relativeLocation.x > this.getWidth()) {
            return ConnectorLocation.RIGHT;
        }
        if (relativeLocation.x < 0) {
            return ConnectorLocation.LEFT;
        }
        if (relativeLocation.y > this.getHeight()) {
            return ConnectorLocation.BOTTOM;
        }
        if (relativeLocation.y < 0) {
            return ConnectorLocation.TOP;
        }
        return ConnectorLocation.CENTER;
    }

    public Point getTopPoint() {
        return new Point(this.getWidth() / 2, 0);
    }

    public Point getBottomPoint() {
        return new Point(this.getWidth() / 2, this.getHeight());
    }

    @Override
    public String getToolTipText() {
        String toolTipText = super.getToolTipText();
        if (toolTipText != null) {
            return toolTipText;
        }
        return this.createToolTipText();
    }

    private String createToolTipText() {
        NodeView nodeView = this.getNodeView();
        if (nodeView == null) {
            return "";
        }
        ModeController modeController = nodeView.getMap().getModeController();
        NodeModel node = nodeView.getModel();
        return modeController.createToolTip(node, this);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String toolTipText = super.getToolTipText(event);
        if (toolTipText != null) {
            return toolTipText;
        }
        return this.createToolTipText();
    }

    @Override
    public boolean contains(int x, int y) {
        Point p = new Point(x, y);
        return this.isInFoldingRegion(p) || this.isInDragRegion(p) || super.contains(x, y);
    }

    public boolean isInDragRegion(Point p) {
        if (p.y >= 0 && p.y < this.getHeight()) {
            NodeView nodeView = this.getNodeView();
            if (nodeView.isRoot()) {
                return false;
            }
            NodeModel node = nodeView.getModel();
            if (node.getParentNode() == null) {
                if (!ERROR_LOGGED) {
                    ERROR_LOGGED = true;
                    LogUtils.severe("Node" + node + " has lost parent", new IllegalStateException());
                }
                return false;
            }
            if (MapViewLayout.OUTLINE.equals((Object)nodeView.getMap().getLayoutType())) {
                return false;
            }
            int draggingWidth = this.getDraggingWidth();
            if (nodeView.isLeft()) {
                int width = this.getWidth();
                return p.x >= width && p.x < width + draggingWidth;
            }
            return p.x >= -draggingWidth && p.x < 0;
        }
        return false;
    }

    boolean hasChildren() {
        NodeView nodeView = this.getNodeView();
        NodeModel node = nodeView.getModel();
        return node.hasChildren();
    }

    public boolean isInFoldingRegion(Point p) {
        if (this.hasChildren() && p.y >= 0 && p.y < this.getHeight()) {
            boolean isLeft = this.getNodeView().isLeft();
            int width = Math.max(16, this.getZoomedFoldingSymbolHalfWidth() * 2);
            if (isLeft) {
                boolean maxX = false;
                return p.x >= -width && p.x < 0;
            }
            int minX = this.getWidth();
            return p.x >= minX && p.x < this.getWidth() + width;
        }
        return false;
    }

    public MouseArea getMouseArea() {
        return this.mouseArea;
    }

    public void setMouseArea(MouseArea mouseArea) {
        if (mouseArea.equals((Object)this.mouseArea)) {
            return;
        }
        boolean repaintDraggingRectangle = this.isVisible() && (mouseArea.equals((Object)MouseArea.MOTION) || this.mouseArea.equals((Object)MouseArea.MOTION));
        boolean repaintFoldingRectangle = this.isVisible() && (mouseArea.equals((Object)MouseArea.OUT) || mouseArea.equals((Object)MouseArea.FOLDING) || this.mouseArea.equals((Object)MouseArea.OUT) || this.mouseArea.equals((Object)MouseArea.FOLDING));
        this.mouseArea = mouseArea;
        if (repaintDraggingRectangle) {
            this.paintDraggingRectangleImmediately();
        }
        if (repaintFoldingRectangle) {
            this.paintFoldingRectangleImmediately();
        }
    }

    private void paintFoldingRectangleImmediately() {
        int y;
        int height;
        int zoomedFoldingSymbolHalfWidth = this.getZoomedFoldingSymbolHalfWidth();
        int width = Math.max(16, zoomedFoldingSymbolHalfWidth * 2);
        NodeView nodeView = this.getNodeView();
        int x = nodeView.isLeft() ? -width : this.getWidth();
        if (16 >= this.getHeight()) {
            height = 16;
            y = this.getHeight() - 16;
        } else {
            height = this.getHeight();
            y = 0;
        }
        Rectangle foldingRectangle = new Rectangle(x - 4, y - 4, width + 8, (height += width / 2) + 8);
        MapView map = nodeView.getMap();
        UITools.convertRectangleToAncestor(this, foldingRectangle, map);
        map.paintImmediately(foldingRectangle);
    }

    private void paintDraggingRectangleImmediately() {
        Rectangle dragRectangle = this.getDragRectangle();
        this.paintDecorationImmediately(dragRectangle);
    }

    private void paintDecorationImmediately(Rectangle rectangle) {
        MapView map = this.getMap();
        UITools.convertRectangleToAncestor(this, rectangle, map);
        map.paintImmediately(rectangle);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.setMouseArea(MouseArea.OUT);
        }
    }

    private int getDraggingWidth() {
        return this.getNodeView().getZoomed(10);
    }

    public NamedIcon getUIIconAt(Point coordinate) {
        Icon icon = this.getIcon();
        if (icon instanceof MultipleImage) {
            Rectangle iconRectangle = this.getIconRectangle();
            Point transformedToIconCoordinate = new Point(coordinate);
            transformedToIconCoordinate.translate(-iconRectangle.x, -iconRectangle.y);
            return ((MultipleImage)icon).getUIIconAt(transformedToIconCoordinate);
        }
        return null;
    }

    public float getUnzoomedEdgeWidth() {
        NodeView nodeView = this.getNodeView();
        int edgeWidth = nodeView.getEdgeWidth();
        EdgeStyle style = nodeView.getEdgeStyle();
        float nodeLineWidth = style.getNodeLineWidth(edgeWidth);
        return nodeLineWidth;
    }

    public float getPaintedBorderWidth() {
        float zoomedLineWidth = this.getNodeView().getMap().getZoom() * this.unzoomedBorderWidth;
        return Math.max(zoomedLineWidth, 1.0f);
    }

    public float getUnzoomedBorderWidth() {
        return Math.max(this.unzoomedBorderWidth, 1.0f);
    }

    public DashVariant getDash() {
        return this.dash;
    }

    public Color getBorderColor() {
        return this.borderColorMatchesEdgeColor != false ? this.getNodeView().getEdgeColor() : this.borderColor;
    }

    public Color getFoldingCircleBorderColor() {
        Color borderColor = this.getBorderColor();
        if (borderColor.getAlpha() == 255) {
            return borderColor;
        }
        return new Color(borderColor.getRed(), borderColor.getGreen(), borderColor.getGreen(), 255);
    }

    public Color getFoldingCircleFillColor() {
        Color fillColor = this.getNodeView().getTextBackground();
        Color foldingCircleBorderColor = this.getFoldingCircleBorderColor();
        if (foldingCircleBorderColor.equals(fillColor)) {
            Color color = fillColor;
            fillColor = UITools.isLighter(color, 96) ? fillColor.darker() : fillColor.brighter().brighter();
        }
        return fillColor;
    }

    public void updateBorder(NodeView nodeView) {
        LogicalStyleController.StyleOption styleOption;
        NodeModel node;
        NodeStyleController controller = NodeStyleController.getController(nodeView.getMap().getModeController());
        Boolean borderWidthMatchesEdgeWidth = controller.getBorderWidthMatchesEdgeWidth(node = nodeView.getModel(), styleOption = nodeView.getStyleOption());
        this.unzoomedBorderWidth = borderWidthMatchesEdgeWidth != false ? this.getUnzoomedEdgeWidth() : (float)controller.getBorderWidth(node, styleOption).toBaseUnits();
        Boolean borderDashMatchesEdgeDash = controller.getBorderDashMatchesEdgeDash(node, styleOption);
        this.dash = borderDashMatchesEdgeDash != false ? nodeView.getEdgeDash() : controller.getBorderDash(node, styleOption);
        this.borderColorMatchesEdgeColor = controller.getBorderColorMatchesEdgeColor(node, styleOption);
        this.borderColor = this.borderColorMatchesEdgeColor != false ? null : controller.getBorderColor(node, styleOption);
    }

    void paintComponentDefault(Graphics graphics) {
        super.paintComponent(graphics);
    }

    public Insets getDefaultZoomedInsets() {
        return super.getZoomedInsets();
    }

    public Insets getDefaultInsets() {
        return super.getInsets();
    }

    public Insets getDefaultInsets(Insets insets) {
        return super.getInsets(insets);
    }

    public Dimension getDefaultPreferredSize() {
        return super.getPreferredSize();
    }

    public void setBoundsDefault(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    public Point getConnectorPoint(Point relativeLocation) {
        return this.painter.getConnectorPoint(relativeLocation);
    }

    public Point getLeftPoint() {
        return this.painter.getLeftPoint();
    }

    public Point getRightPoint() {
        return this.painter.getRightPoint();
    }

    public NodeGeometryModel getShapeConfiguration() {
        return this.painter.getShapeConfiguration();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.painter.paintComponent(graphics);
    }

    @Override
    public Insets getZoomedInsets() {
        return this.painter.getZoomedInsets();
    }

    @Override
    public Insets getInsets() {
        return this.painter.getInsets();
    }

    @Override
    public Insets getInsets(Insets insets) {
        return this.painter.getInsets(insets);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.painter.getPreferredSize();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.painter.setBounds(x, y, width, height);
    }

    public int getMainViewWidthWithFoldingMark() {
        return this.painter.getMainViewWidthWithFoldingMark();
    }

    public int getMainViewHeightWithFoldingMark() {
        return this.painter.getMainViewHeightWithFoldingMark();
    }

    public int getSingleChildShift() {
        return this.painter.getSingleChildShift();
    }

    public void paintDecoration(NodeView nodeView, Graphics2D g) {
        this.painter.paintDecoration(nodeView, g);
    }

    public void setPainter(MainViewPainter shape) {
        if (this.painter != shape) {
            this.painter = shape;
            this.revalidate();
            this.repaint();
        }
    }

    static enum TextModificationState {
        NONE,
        HIGHLIGHT,
        FAILURE;

    }

    public static enum ConnectorLocation {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        CENTER;

    }
}

