/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IElementContentHandler;
import org.freeplane.core.io.IElementDOMHandler;
import org.freeplane.core.io.IElementHandler;
import org.freeplane.core.io.IExtensionElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.map.IMapLifeCycleListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.LogicalStyleKeys;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.styles.StyleExchange;
import org.freeplane.features.styles.StyleFactory;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.features.url.mindmapmode.TemplateManager;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.view.swing.features.filepreview.MindMapPreviewWithOptions;

@NodeHookDescriptor(hookName="MapStyle")
public class MapStyle
extends PersistentNodeHook
implements IExtension,
IMapLifeCycleListener {
    public static final String ALLOW_COMPACT_LAYOUT = "allow_compact_layout";
    private static final String NODE_CONDITIONAL_STYLES = "NodeConditionalStyles";
    public static final String RESOURCES_BACKGROUND_COLOR = "standardbackgroundcolor";
    public static final String RESOURCES_BACKGROUND_IMAGE = "backgroundImageURI";
    public static final String MAP_STYLES = "MAP_STYLES";
    public static final String FIT_TO_VIEWPORT = "fit_to_viewport";
    private static final ThreadLocal<Boolean> followedStyleUpdateActive = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public static void install(boolean persistent) {
        new MapStyle(persistent);
    }

    protected MapStyle(boolean persistent) {
        MapController mapController;
        ModeController modeController = Controller.getCurrentModeController();
        if (persistent) {
            mapController = modeController.getMapController();
            mapController.getWriteManager().addExtensionElementWriter(this.getExtensionClass(), new XmlWriter());
            mapController.getReadManager().addElementHandler("conditional_styles", new IElementDOMHandler(){

                @Override
                public Object createElement(Object parent, String tag, XMLElement attributes) {
                    return parent;
                }

                @Override
                public void endElement(Object parent, String tag, Object element, XMLElement dom) {
                    NodeModel node = (NodeModel)parent;
                    MapStyleModel mapStyleModel = MapStyleModel.getExtensionOrNull(node);
                    if (mapStyleModel != null) {
                        MapStyle.this.loadConditionalStyles(mapStyleModel.getConditionalStyleModel(), dom);
                    }
                }
            });
            mapController.getWriteManager().addExtensionElementWriter(ConditionalStyleModel.class, new IExtensionElementWriter(){

                @Override
                public void writeContent(ITreeWriter writer, Object element, IExtension extension) throws IOException {
                    ConditionalStyleModel conditionalStyleModel = (ConditionalStyleModel)extension;
                    if (conditionalStyleModel.getStyleCount() == 0) {
                        return;
                    }
                    XMLElement hook = new XMLElement("hook");
                    hook.setAttribute("NAME", MapStyle.NODE_CONDITIONAL_STYLES);
                    MapStyle.this.saveConditionalStyles(conditionalStyleModel, hook, false);
                    writer.addElement(null, hook);
                }
            });
            mapController.getReadManager().addElementHandler("hook", new IElementDOMHandler(){

                @Override
                public Object createElement(Object parent, String tag, XMLElement attributes) {
                    if (attributes == null || !MapStyle.NODE_CONDITIONAL_STYLES.equals(attributes.getAttribute("NAME", null))) {
                        return null;
                    }
                    ConditionalStyleModel conditionalStyleModel = new ConditionalStyleModel();
                    ((NodeModel)parent).addExtension(conditionalStyleModel);
                    return conditionalStyleModel;
                }

                @Override
                public void endElement(Object parent, String tag, Object element, XMLElement dom) {
                    MapStyle.this.loadConditionalStyles((ConditionalStyleModel)element, dom);
                }
            });
            mapController.getReadManager().addElementHandler("map_styles", new IElementContentHandler(){

                @Override
                public Object createElement(Object parent, String tag, XMLElement attributes) {
                    return parent;
                }

                @Override
                public void endElement(Object parent, String tag, Object userObject, XMLElement attributes, String content) {
                    if (this.isContentEmpty(content)) {
                        return;
                    }
                    NodeModel node = (NodeModel)userObject;
                    MapStyleModel mapStyleModel = MapStyleModel.getExtensionOrNull(node);
                    if (mapStyleModel == null) {
                        return;
                    }
                    MapModel map = node.getMap();
                    mapStyleModel.createStyleMap(map, content);
                    map.getIconRegistry().addIcons(mapStyleModel.getStyleMap());
                }

                private boolean isContentEmpty(String content) {
                    return content.indexOf(60) == -1;
                }

                @Override
                public boolean containsXml(XMLElement element) {
                    return true;
                }
            });
        }
        mapController = modeController.getMapController();
        mapController.addMapLifeCycleListener(this);
    }

    @Override
    protected XmlWriter createXmlWriter() {
        return null;
    }

    @Override
    protected IElementHandler createXmlReader() {
        return new MyXmlReader();
    }

    @Override
    protected IExtension createExtension(NodeModel node, XMLElement element) {
        MapStyleModel model = new MapStyleModel();
        String colorString = element.getAttribute("background", null);
        String alphaString = element.getAttribute("background_alpha", null);
        Color bgColor = colorString != null ? ColorUtils.stringToColor(colorString) : null;
        if (alphaString != null) {
            bgColor = ColorUtils.makeNonTransparent(ColorUtils.alphaToColor(alphaString, bgColor));
        }
        model.setBackgroundColor(bgColor);
        String zoomString = element.getAttribute("zoom", null);
        if (zoomString != null) {
            float zoom = Float.valueOf(zoomString).floatValue();
            model.setZoom(zoom);
        }
        String layoutString = element.getAttribute("layout", null);
        try {
            if (layoutString != null) {
                MapViewLayout layout = MapViewLayout.valueOf(layoutString);
                model.setMapViewLayout(layout);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return model;
    }

    private void loadConditionalStyles(ConditionalStyleModel conditionalStyleModel, XMLElement conditionalStylesRoot) {
        ConditionFactory conditionFactory = FilterController.getCurrentFilterController().getConditionFactory();
        Vector<XMLElement> styleElements = conditionalStylesRoot.getChildrenNamed("conditional_style");
        for (XMLElement styleElement : styleElements) {
            ASelectableCondition condition;
            IStyle style;
            boolean isLast;
            boolean isActive;
            block4: {
                isActive = Boolean.valueOf(styleElement.getAttribute("ACTIVE", "false"));
                isLast = Boolean.valueOf(styleElement.getAttribute("LAST", "false"));
                String styleText = styleElement.getAttribute("LOCALIZED_STYLE_REF", null);
                style = styleText != null ? StyleFactory.create(TranslatedObject.format(styleText)) : StyleFactory.create(styleElement.getAttribute("STYLE_REF", null));
                if (styleElement.getChildrenCount() == 1) {
                    XMLElement conditionElement = styleElement.getChildAtIndex(0);
                    try {
                        condition = conditionFactory.loadCondition(conditionElement);
                        break block4;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                condition = null;
            }
            conditionalStyleModel.addCondition(isActive, condition, style, isLast);
        }
    }

    private void saveConditionalStyles(ConditionalStyleModel conditionalStyleModel, XMLElement parent, boolean createRoot) {
        XMLElement conditionalStylesRoot;
        int styleCount = conditionalStyleModel.getStyleCount();
        if (styleCount == 0) {
            return;
        }
        if (createRoot) {
            conditionalStylesRoot = parent.createElement("conditional_styles");
            parent.addChild(conditionalStylesRoot);
        } else {
            conditionalStylesRoot = parent;
        }
        for (ConditionalStyleModel.Item item : conditionalStyleModel) {
            item.toXml(conditionalStylesRoot);
        }
    }

    public Color getBackground(MapModel map) {
        Color backgroundColor;
        MapStyleModel styleModel = MapStyleModel.getExtension(map);
        Color color = backgroundColor = styleModel != null ? styleModel.getBackgroundColor() : null;
        if (backgroundColor != null) {
            return backgroundColor;
        }
        String stdcolor = ResourceController.getResourceController().getProperty(RESOURCES_BACKGROUND_COLOR);
        Color standardMapBackgroundColor = ColorUtils.stringToColor(stdcolor);
        return standardMapBackgroundColor;
    }

    public URI getBackgroundImage(MapModel map) {
        MapStyleModel styleModel = MapStyleModel.getExtension(map);
        String uriString = styleModel.getProperty(RESOURCES_BACKGROUND_IMAGE);
        if (uriString != null) {
            try {
                return UrlManager.getAbsoluteUri(map, new URI(uriString));
            }
            catch (URISyntaxException e) {
                LogUtils.severe(e);
            }
            catch (MalformedURLException e) {
                LogUtils.severe(e);
            }
        }
        return null;
    }

    public boolean allowsCompactLayout(MapModel map) {
        MapStyleModel styleModel = MapStyleModel.getExtension(map);
        String allowsCompactLayout = styleModel.getProperty(ALLOW_COMPACT_LAYOUT);
        return Boolean.parseBoolean(allowsCompactLayout);
    }

    protected Class<MapStyleModel> getExtensionClass() {
        return MapStyleModel.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCreate(MapModel map) {
        NodeModel rootNode = map.getRootNode();
        MapStyleModel mapStyleModel = MapStyleModel.getExtensionOrNull(rootNode);
        if (mapStyleModel != null && mapStyleModel.getStyleMap() != null) {
            if (!followedStyleUpdateActive.get().booleanValue()) {
                followedStyleUpdateActive.set(Boolean.TRUE);
                try {
                    this.copyMapStylesNoUndoNoRefresh(map);
                }
                finally {
                    followedStyleUpdateActive.set(Boolean.FALSE);
                }
            }
        } else {
            this.createDefaultStyleMap(map);
        }
    }

    private void createDefaultStyleMap(MapModel map) {
        MapModel styleMapContainer;
        UrlManager loader = UrlManager.getController();
        File file = loader.defaultTemplateFile();
        if (file != null) {
            try {
                styleMapContainer = new MapModel(map.getNodeDuplicator());
                loader.load(Compat.fileToUrl(file), styleMapContainer);
                if (null != MapStyleModel.getExtension(styleMapContainer)) {
                    new StyleExchange(styleMapContainer, map).moveStyle(false);
                    return;
                }
            }
            catch (Exception e) {
                LogUtils.warn(e);
                UITools.errorMessage(TextUtils.format("error_in_template", file));
            }
        }
        styleMapContainer = new MapModel(map.getNodeDuplicator());
        try {
            loader.load(ResourceController.getResourceController().getResource("/styles/viewer_standard.mm"), styleMapContainer);
            new StyleExchange(styleMapContainer, map).moveStyle(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected PersistentNodeHook.HookAction createHookAction() {
        return null;
    }

    private Optional<MapModel> loadStyleMapContainer(URL source) {
        MapModel styleMapContainer;
        ModeController modeController = Controller.getCurrentModeController();
        UrlManager urlManager = modeController.getExtension(UrlManager.class);
        if (urlManager.loadCatchExceptions(source, styleMapContainer = new MapModel(modeController.getMapController().duplicator()))) {
            return Optional.of(styleMapContainer);
        }
        return Optional.empty();
    }

    public void replaceStyles(File file, MapModel targetMap, boolean shouldFollow, boolean shouldAssociate) throws MalformedURLException {
        URI uri = file.toURI();
        this.replaceStyles(uri, targetMap, shouldFollow, shouldAssociate);
    }

    public void replaceStyles(URI uri, MapModel targetMap, boolean shouldFollow, boolean shouldAssociate) throws MalformedURLException {
        URL url = uri.toURL();
        this.loadStyleMapContainer(url).ifPresent(styleMapContainer -> {
            new StyleExchange((MapModel)styleMapContainer, targetMap).replaceMapStylesAndAutomaticStyle();
            this.updateFollowProperties(targetMap, uri, shouldFollow, shouldAssociate);
        });
    }

    private void undoableCopyStyleToAssociatedExternalTemplate(MapModel map, IStyle styleKey) {
        File target;
        TemplateManager templateManager = TemplateManager.INSTANCE;
        String templateLocationPropertyValue = this.getProperty(map, "associatedTemplateLocation");
        URI source = templateManager.expandExistingTemplateLocation(templateLocationPropertyValue);
        if (source == null) {
            MindMapPreviewWithOptions previewWithOptions = MindMapPreviewWithOptions.createFileOpenDialogAndOptions(TextUtils.getText("select_associated_template"));
            JFileChooser fileChooser = previewWithOptions.getFileChooser();
            int returnVal = fileChooser.showOpenDialog(UITools.getCurrentFrame());
            if (returnVal != 0) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            if (!file.exists()) {
                return;
            }
            source = file.toURI();
            templateLocationPropertyValue = TemplateManager.INSTANCE.normalizeTemplateLocation(source).toString();
            MapStyle.getController().setProperty(map, "associatedTemplateLocation", templateLocationPropertyValue);
        }
        if ((target = templateManager.writeableTemplateFile(templateLocationPropertyValue)) != null && (!target.isDirectory() && target.canWrite() || !target.exists())) {
            if (MapStyle.areDifferent(map.getFile(), target)) {
                try {
                    this.undoableCopyStyleToExternalMap(map, styleKey, source, target);
                }
                catch (MalformedURLException e) {
                    LogUtils.severe(e);
                }
            }
        } else {
            UITools.errorMessage(TextUtils.format("file_not_accessible", String.valueOf(templateLocationPropertyValue)));
        }
    }

    private void undoableCopyStyleToExternalMap(MapModel map, IStyle styleKey, URI sourceLocation, File targetFile) throws MalformedURLException {
        MapStyleModel sourceStyles = MapStyleModel.getExtension(map);
        NodeModel copiedStyleNode = sourceStyles.getStyleNode(styleKey);
        Objects.requireNonNull(copiedStyleNode);
        File mapFile = map.getFile();
        if (mapFile == null || !sourceLocation.equals(mapFile.toURI())) {
            URL url = sourceLocation.toURL();
            this.loadStyleMapContainer(url).ifPresent(styleMapTarget -> {
                this.undoableCopyStyleToTargetFile(map, styleKey, copiedStyleNode, (MapModel)styleMapTarget, targetFile);
                this.undoableCopyStyleToLoadedMap(styleKey, copiedStyleNode, url);
            });
        }
    }

    private void undoableCopyStyleToLoadedMap(IStyle styleKey, NodeModel copiedStyleNode, URL url) {
        ModeController modeController = Controller.getCurrentModeController();
        MapModel loadedMap = modeController.getMapController().getMap(url);
        if (loadedMap != null) {
            this.undoableCopyStyle(styleKey, copiedStyleNode, loadedMap);
        }
    }

    public void undoableCopyStyle(final IStyle styleKey, final NodeModel copiedStyleNode, final MapModel targetMap) {
        final ModeController modeController = Controller.getCurrentModeController();
        final MapStyleModel targetStyles = MapStyleModel.getExtension(targetMap);
        final Optional<NodeModel> oldNode = Optional.ofNullable(targetStyles.getStyleNode(styleKey)).map(node -> node.duplicate(false));
        oldNode.ifPresent(node -> node.setMap(null));
        IActor actor = new IActor(){

            @Override
            public void act() {
                this.copy(Optional.of(copiedStyleNode));
            }

            @Override
            public String getDescription() {
                return "copyStyleToLoadedMap";
            }

            @Override
            public void undo() {
                this.copy(oldNode);
            }

            private void copy(Optional<NodeModel> sourceNode) {
                if (sourceNode.isPresent()) {
                    targetStyles.copyStyle(sourceNode.get(), styleKey);
                } else {
                    NodeModel targetNode = targetStyles.getStyleNode(styleKey);
                    targetNode.getParentNode().remove(targetNode.getIndex());
                    targetStyles.removeStyleNode(targetNode);
                }
                modeController.getMapController().fireMapChanged(new MapChangeEvent(this, targetMap, MapStyle.MAP_STYLES, null, null));
                targetMap.updateLastKnownFileModificationTime();
            }
        };
        modeController.execute(actor, targetMap);
    }

    private void undoableCopyStyleToTargetFile(MapModel map, final IStyle styleKey, final NodeModel copiedStyleNode, final MapModel styleMapTarget, final File targetFile) {
        final ModeController modeController = Controller.getCurrentModeController();
        final MapStyleModel targetStyles = MapStyleModel.getExtension(styleMapTarget);
        final Optional<NodeModel> oldNode = Optional.ofNullable(targetStyles.getStyleNode(styleKey)).map(node -> node.duplicate(false));
        oldNode.ifPresent(node -> node.setMap(null));
        IActor actor = new IActor(){

            @Override
            public void act() {
                this.copy(Optional.of(copiedStyleNode));
            }

            @Override
            public String getDescription() {
                return "copyStyleToExternalMap";
            }

            @Override
            public void undo() {
                this.copy(oldNode);
            }

            private void copy(Optional<NodeModel> sourceNode) {
                if (sourceNode.isPresent()) {
                    targetStyles.copyStyle(sourceNode.get(), styleKey);
                } else {
                    NodeModel targetNode = targetStyles.getStyleNode(styleKey);
                    targetNode.getParentNode().remove(targetNode.getIndex());
                    targetStyles.removeStyleNode(targetNode);
                }
                try {
                    MFileManager.getController((ModeController)modeController).writeToFile(styleMapTarget, targetFile);
                }
                catch (IOException e) {
                    LogUtils.warn(e);
                }
            }
        };
        modeController.execute(actor, map);
    }

    private void updateFollowProperties(MapModel map, URI uri, boolean shouldFollow, boolean shouldAssociate) {
        String normalizedLocation = TemplateManager.INSTANCE.normalizeTemplateLocation(uri).toString();
        if (shouldFollow) {
            this.setProperty(map, "followedTemplateLocation", normalizedLocation);
            this.updateLastModificationTime(map, uri);
        } else {
            String followedMapUri = this.getProperty(map, "followedTemplateLocation");
            if (followedMapUri != null && normalizedLocation.equals(followedMapUri)) {
                this.updateLastModificationTime(map, uri);
            }
        }
        if (shouldAssociate) {
            this.setProperty(map, "associatedTemplateLocation", normalizedLocation);
        }
    }

    public void updateLastModificationTime(MapModel map, URI uri) {
        String lastModified = "file".equalsIgnoreCase(uri.getScheme()) ? Long.toString(Paths.get(uri).toFile().lastModified()) : null;
        this.setProperty(map, "followedMapLastTime", lastModified);
    }

    public void copyStyles(URI uri, MapModel targetMap, boolean shouldFollow, boolean shouldAssociate) throws MalformedURLException {
        URL url = uri.toURL();
        this.loadStyleMapContainer(url).ifPresent(styleMapContainer -> {
            new StyleExchange((MapModel)styleMapContainer, targetMap).copyMapStyles();
            this.updateFollowProperties(targetMap, uri, shouldFollow, shouldAssociate);
        });
    }

    public void copyStyles(File file, MapModel targetMap, boolean shouldFollow, boolean shouldAssociate) throws MalformedURLException {
        URI uri = file.toURI();
        this.copyStyles(uri, targetMap, shouldFollow, shouldAssociate);
    }

    private void copyMapStylesNoUndoNoRefresh(MapModel targetMap) {
        long lastUpdateTime;
        MapStyleModel mapStyleModel = MapStyleModel.getExtension(targetMap);
        String followedTemplate = this.followedTemplate(mapStyleModel);
        String lastUpdateTimeString = mapStyleModel.getProperty("followedMapLastTime");
        long l = lastUpdateTime = lastUpdateTimeString != null ? Long.parseLong(lastUpdateTimeString) : 0L;
        if (followedTemplate != null) {
            try {
                String followedMapPath;
                boolean shouldUpdate;
                long sourceLastModificationTime;
                URI source = TemplateManager.INSTANCE.expandTemplateLocation(new URI(followedTemplate));
                if (source.getScheme().equalsIgnoreCase("file")) {
                    File file = Paths.get(source).toFile();
                    if (!MapStyle.areDifferent(targetMap.getFile(), file)) {
                        return;
                    }
                    sourceLastModificationTime = file.lastModified();
                    shouldUpdate = sourceLastModificationTime > lastUpdateTime;
                    followedMapPath = file.getAbsolutePath();
                } else {
                    sourceLastModificationTime = lastUpdateTime;
                    shouldUpdate = true;
                    followedMapPath = followedTemplate;
                }
                if (shouldUpdate) {
                    this.loadStyleMapContainer(source.toURL()).ifPresent(styleMapContainer -> {
                        new StyleExchange((MapModel)styleMapContainer, targetMap).copyMapStylesNoUndoNoRefresh();
                        UITools.showMessage(TextUtils.format("stylesUpdated", targetMap.getTitle(), followedMapPath), 1);
                        SwingUtilities.invokeLater(() -> targetMap.setSaved(false));
                    });
                }
                if (sourceLastModificationTime != lastUpdateTime) {
                    MapStyleModel.getExtension(targetMap).setProperty("followedMapLastTime", Long.toString(sourceLastModificationTime));
                }
            }
            catch (MalformedURLException | URISyntaxException e) {
                LogUtils.severe(e);
            }
        }
    }

    private static boolean areDifferent(File x, File y) {
        try {
            return x == null || y == null || !x.getCanonicalPath().equals(y.getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    private String followedTemplate(MapStyleModel mapStyleModel) {
        if (Compat.isApplet()) {
            return null;
        }
        this.normalizeOldFormatTemplateLocation(mapStyleModel);
        return mapStyleModel.getProperty("followedTemplateLocation");
    }

    private void normalizeOldFormatTemplateLocation(MapStyleModel mapStyleModel) {
        TemplateManager templateManager = TemplateManager.INSTANCE;
        String oldPropertyLocation = mapStyleModel.getProperty("followedMapLocation");
        if (oldPropertyLocation != null) {
            mapStyleModel.setProperty("followedMapLocation", null);
            try {
                mapStyleModel.setProperty("followedTemplateLocation", templateManager.normalizeTemplateLocation(new URI(oldPropertyLocation)).toString());
            }
            catch (URISyntaxException e) {
                LogUtils.severe(e);
            }
        }
    }

    @Override
    protected void saveExtension(IExtension extension, XMLElement element) {
        MapViewLayout layout;
        float zoom;
        MapStyleModel mapStyleModel = (MapStyleModel)extension;
        super.saveExtension(extension, element);
        Color backgroundColor = mapStyleModel.getBackgroundColor();
        if (backgroundColor != null) {
            element.setAttribute("background", ColorUtils.colorToString(backgroundColor));
        }
        if ((zoom = mapStyleModel.getZoom()) != 1.0f) {
            element.setAttribute("zoom", Float.toString(zoom));
        }
        if (!(layout = mapStyleModel.getMapViewLayout()).equals((Object)MapViewLayout.MAP)) {
            element.setAttribute("layout", layout.toString());
        }
        this.saveConditionalStyles(mapStyleModel.getConditionalStyleModel(), element, true);
        this.saveProperties(mapStyleModel.getProperties(), element);
    }

    private void saveProperties(Map<String, String> properties, XMLElement element) {
        if (properties.isEmpty()) {
            return;
        }
        XMLElement xmlElement = new XMLElement("properties");
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            xmlElement.setAttribute(entry.getKey(), entry.getValue());
        }
        element.addChild(xmlElement);
    }

    public void setZoom(MapModel map, float zoom) {
        MapStyleModel mapStyleModel = MapStyleModel.getExtension(map);
        if (zoom == mapStyleModel.getZoom()) {
            return;
        }
        mapStyleModel.setZoom(zoom);
        Controller.getCurrentModeController().getMapController().setSaved(map, false);
    }

    public float getZoom(MapModel map) {
        MapStyleModel mapStyleModel = MapStyleModel.getExtension(map);
        return mapStyleModel.getZoom();
    }

    public void setMapViewLayout(MapModel map, MapViewLayout layout) {
        MapStyleModel mapStyleModel = MapStyleModel.getExtension(map);
        if (layout.equals((Object)mapStyleModel.getMapViewLayout())) {
            return;
        }
        mapStyleModel.setMapViewLayout(layout);
        Controller.getCurrentModeController().getMapController().setSaved(map, false);
    }

    public void setBackgroundColor(final MapStyleModel model, Color color) {
        Color oldColor;
        final Color actionColor = ColorUtils.makeNonTransparent(color);
        if (actionColor == (oldColor = model.getBackgroundColor()) || actionColor != null && actionColor.equals(oldColor)) {
            return;
        }
        IActor actor = new IActor(){

            @Override
            public void act() {
                model.setBackgroundColor(actionColor);
                Controller.getCurrentModeController().getMapController().fireMapChanged(new MapChangeEvent(MapStyle.this, Controller.getCurrentController().getMap(), MapStyle.RESOURCES_BACKGROUND_COLOR, oldColor, actionColor));
            }

            @Override
            public String getDescription() {
                return "MapStyle.setBackgroundColor";
            }

            @Override
            public void undo() {
                model.setBackgroundColor(oldColor);
                Controller.getCurrentModeController().getMapController().fireMapChanged(new MapChangeEvent(MapStyle.this, Controller.getCurrentController().getMap(), MapStyle.RESOURCES_BACKGROUND_COLOR, actionColor, oldColor));
            }
        };
        Controller.getCurrentModeController().execute(actor, Controller.getCurrentController().getMap());
    }

    public static MapStyle getController(ModeController modeController) {
        return modeController.getExtension(MapStyle.class);
    }

    public static MapStyle getController() {
        return MapStyle.getController(Controller.getCurrentModeController());
    }

    public void setProperty(final MapModel model, final String key, final String newValue) {
        final MapStyleModel styleModel = MapStyleModel.getExtension(model);
        final String oldValue = styleModel.getProperty(key);
        if (oldValue == newValue || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        IActor actor = new IActor(){

            @Override
            public void undo() {
                this.setPropertyWithoutUndo(model, key, oldValue);
            }

            @Override
            public String getDescription() {
                return "set map style property";
            }

            @Override
            public void act() {
                this.setPropertyWithoutUndo(model, key, newValue);
            }

            private void setPropertyWithoutUndo(MapModel model2, String key2, String newValue2) {
                styleModel.setProperty(key2, newValue2);
                Controller.getCurrentModeController().getMapController().fireMapChanged(new MapChangeEvent(MapStyle.this, model2, key2, oldValue, newValue2));
            }
        };
        Controller.getCurrentModeController().execute(actor, model);
    }

    public String getPropertySetDefault(MapModel model, String key) {
        MapStyleModel styleModel = MapStyleModel.getExtension(model);
        String oldValue = styleModel.getProperty(key);
        if (oldValue != null) {
            return oldValue;
        }
        String value = ResourceController.getResourceController().getProperty(key);
        styleModel.setProperty(key, value);
        return value;
    }

    public String getProperty(MapModel model, String key) {
        return MapStyleModel.getExtension(model).getProperty(key);
    }

    public Map<String, String> getPropertiesReadOnly(MapModel model) {
        return Collections.unmodifiableMap(MapStyleModel.getExtension(model).getProperties());
    }

    public void redefineStyle(NodeModel node, boolean copyToExternalTemplate) {
        IStyle style = LogicalStyleController.getController().getFirstStyle(node);
        MapModel map = node.getMap();
        MapStyleModel extension = MapStyleModel.getExtension(map);
        NodeModel styleNode = extension.getStyleNode(style);
        if (styleNode == null) {
            return;
        }
        styleNode.getMap().putExtension(IUndoHandler.class, map.getExtension(IUndoHandler.class));
        Controller.getCurrentModeController().undoableCopyExtensions((Object)LogicalStyleKeys.NODE_STYLE, node, styleNode);
        Controller.getCurrentModeController().undoableRemoveExtensions((Object)LogicalStyleKeys.NODE_STYLE, node, node);
        LogicalStyleController.getController().refreshMap(map);
        if (copyToExternalTemplate) {
            this.undoableCopyStyleToAssociatedExternalTemplate(map, style);
        }
    }

    protected class XmlWriter
    implements IExtensionElementWriter {
        protected XmlWriter() {
        }

        @Override
        public void writeContent(ITreeWriter writer, Object object, IExtension extension) throws IOException {
            MapStyleModel mapStyleModel = (MapStyleModel)extension;
            MapModel styleMap = mapStyleModel.getStyleMap();
            if (styleMap == null) {
                return;
            }
            MapWriter mapWriter = Controller.getCurrentModeController().getMapController().getMapWriter();
            StringWriter sw = new StringWriter();
            String el = System.getProperty("line.separator");
            sw.append(el);
            sw.append("<map_styles>");
            sw.append(el);
            NodeModel rootNode = styleMap.getRootNode();
            boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
            try {
                mapWriter.writeNodeAsXml(sw, rootNode, MapWriter.Mode.STYLE, true, true, forceFormatting);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            sw.append("</map_styles>");
            sw.append(el);
            XMLElement element = new XMLElement("hook");
            MapStyle.this.saveExtension(extension, element);
            writer.addElement((Object)sw.toString(), element);
        }
    }

    protected class MyXmlReader
    extends PersistentNodeHook.XmlReader {
        protected MyXmlReader() {
        }

        @Override
        public Object createElement(Object parent, String tag, XMLElement attributes) {
            if (null == super.createElement(parent, tag, attributes)) {
                return null;
            }
            super.endElement(parent, tag, parent, attributes);
            return parent;
        }

        @Override
        public void endElement(Object parent, String tag, Object userObject, XMLElement xml) {
            XMLElement parentNodeElement = xml.getParent().getParent();
            if (parentNodeElement == null || !parentNodeElement.getName().equals("map")) {
                return;
            }
            NodeModel node = (NodeModel)userObject;
            MapStyleModel mapStyleModel = MapStyleModel.getExtensionOrNull(node);
            Objects.requireNonNull(mapStyleModel);
            this.loadMapStyleProperties(mapStyleModel, xml);
        }

        private void loadMapStyleProperties(MapStyleModel model, XMLElement xml) {
            Vector<XMLElement> propertyXml = xml.getChildrenNamed("properties");
            if (propertyXml != null && propertyXml.size() >= 1) {
                Map<String, String> properties = model.getProperties();
                Properties attributes = propertyXml.get(0).getAttributes();
                for (Map.Entry<Object, Object> attribute : attributes.entrySet()) {
                    String key = attribute.getKey().toString();
                    if (key.equals(".addon.mm")) continue;
                    properties.put(key, attribute.getValue().toString());
                }
            }
        }
    }
}

