/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.freeplane.features.map.NodeModel;

public class NodeIterator
implements Iterator<NodeModel> {
    private NodeModel node;
    private Algorithm algorithm;
    private Iterator<NodeModel> children;
    private Iterator<NodeModel> subtree;
    boolean nodeReturned;

    public static NodeIterator of(NodeModel node) {
        return new NodeIterator(node, Algorithm.TOP_DOWN);
    }

    public static NodeIterator bottomUpOf(NodeModel node) {
        return new NodeIterator(node, Algorithm.BOTTOM_UP);
    }

    private NodeIterator(NodeModel node, Algorithm algorithm) {
        this.node = node;
        this.algorithm = algorithm;
        this.children = node.getChildren().iterator();
        this.subtree = Collections.emptyIterator();
        this.nodeReturned = false;
    }

    @Override
    public boolean hasNext() {
        return !this.nodeReturned || this.children.hasNext() || this.subtree.hasNext();
    }

    @Override
    public NodeModel next() {
        if (this.algorithm == Algorithm.TOP_DOWN && !this.nodeReturned) {
            this.nodeReturned = true;
            return this.node;
        }
        if (this.subtree.hasNext()) {
            return this.subtree.next();
        }
        if (this.children.hasNext()) {
            this.subtree = new NodeIterator(this.children.next(), this.algorithm);
            return this.subtree.next();
        }
        if (this.nodeReturned) {
            throw new NoSuchElementException();
        }
        this.nodeReturned = true;
        return this.node;
    }

    public static enum Algorithm {
        BOTTOM_UP,
        TOP_DOWN;

    }
}

