/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.AMultipleNodeAction;
import org.freeplane.core.ui.IMouseWheelEventHandler;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.map.AlwaysUnfoldedNode;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class FoldingController
implements IMouseWheelEventHandler,
IExtension {
    protected static Insets nullInsets = new Insets(0, 0, 0, 0);

    public static void install(FoldingController foldingController) {
        Controller.getCurrentModeController().addExtension(FoldingController.class, foldingController);
    }

    public FoldingController() {
        if (!GraphicsEnvironment.isHeadless()) {
            ModeController modeController = Controller.getCurrentModeController();
            IUserInputListenerFactory userInputListenerFactory = modeController.getUserInputListenerFactory();
            userInputListenerFactory.addMouseWheelEventHandler(this);
            for (AFreeplaneAction aFreeplaneAction : this.getAnnotatedActions()) {
                modeController.addAction(aFreeplaneAction);
            }
        }
    }

    private List<AMultipleNodeAction> getAnnotatedActions() {
        ArrayList<AMultipleNodeAction> result = new ArrayList<AMultipleNodeAction>();
        result.add(new UnfoldAllAction());
        result.add(new FoldAllAction());
        result.add(new UnfoldOneLevelAction());
        result.add(new FoldOneLevelAction());
        return result;
    }

    protected void foldAll(NodeModel node) {
        this.setFolded(node, true);
        for (NodeModel child : node.getChildren()) {
            this.foldAll(child);
        }
    }

    public void foldLastBranches(NodeModel node) {
        boolean nodeHasChildWhichIsLeave = false;
        for (NodeModel child : node.getChildren()) {
            if (child.getChildCount() != 0) continue;
            nodeHasChildWhichIsLeave = true;
        }
        this.setFolded(node, nodeHasChildWhichIsLeave);
        for (NodeModel child : node.getChildren()) {
            this.foldLastBranches(child);
        }
    }

    protected void foldOneStage(NodeModel node) {
        this.foldStageN(node, this.getMaxDepth(node) - 1);
    }

    private void foldStageN(NodeModel node, int stage) {
        int k = this.depth(node);
        if (k < stage) {
            this.setFolded(node, false);
            for (NodeModel child : node.getChildren()) {
                this.foldStageN(child, stage);
            }
        } else {
            this.foldAll(node);
        }
    }

    private int getMaxDepth(NodeModel node) {
        MapController mapController = Controller.getCurrentModeController().getMapController();
        if (mapController.isFolded(node) || !node.hasChildren()) {
            return this.depth(node);
        }
        int maxDepth = 0;
        for (NodeModel child : node.getChildren()) {
            int childMaxDepth = this.getMaxDepth(child);
            if (childMaxDepth <= maxDepth) continue;
            maxDepth = childMaxDepth;
        }
        return maxDepth;
    }

    private int getMinDepth(NodeModel node) {
        EncryptionModel encryptionModel = EncryptionModel.getModel(node);
        if (encryptionModel != null && !encryptionModel.isAccessible()) {
            return Integer.MAX_VALUE;
        }
        MapController mapController = Controller.getCurrentModeController().getMapController();
        Filter filter = Controller.getCurrentController().getSelection().getFilter();
        if (!node.hasChildren()) {
            return Integer.MAX_VALUE;
        }
        if (node.hasVisibleContent(filter)) {
            if (mapController.isFolded(node)) {
                return this.depth(node);
            }
            if (AlwaysUnfoldedNode.isAlwaysUnfolded(node)) {
                return Integer.MAX_VALUE;
            }
        }
        int minDepth = Integer.MAX_VALUE;
        for (NodeModel child : node.getChildren()) {
            int childMinDepth = this.getMinDepth(child);
            if (childMinDepth >= minDepth) continue;
            minDepth = childMinDepth;
        }
        return minDepth;
    }

    @Override
    public boolean handleMouseWheelEvent(MouseWheelEvent e) {
        if ((e.getModifiers() & 8) != 0) {
            Controller controller = Controller.getCurrentController();
            IMapSelection selection = controller.getSelection();
            NodeModel node = selection.getSelected();
            if (e.getWheelRotation() > 0) {
                this.unfoldOneStage(node);
            } else {
                this.foldOneStage(node);
            }
            return true;
        }
        return false;
    }

    private void setFolded(NodeModel node, boolean state) {
        if (!node.isRoot()) {
            MapController mapController = Controller.getCurrentModeController().getMapController();
            Filter filter = Controller.getCurrentController().getSelection().getFilter();
            mapController.setFolded(node, state, filter);
        }
    }

    public void unfoldAll(NodeModel node) {
        this.setFolded(node, false);
        for (NodeModel child : node.getChildren()) {
            this.unfoldAll(child);
        }
    }

    protected void unfoldOneStage(NodeModel node) {
        int minDepth = this.getMinDepth(node);
        if (minDepth < Integer.MAX_VALUE) {
            ++minDepth;
        }
        this.unfoldStageN(node, minDepth);
    }

    private void unfoldStageN(NodeModel node, int stage) {
        int k = this.depth(node);
        if (k < stage) {
            this.setFolded(node, false);
            for (NodeModel child : node.getChildren()) {
                this.unfoldStageN(child, stage);
            }
        } else {
            this.foldAll(node);
        }
    }

    private int depth(NodeModel node) {
        if (node.isRoot()) {
            return 0;
        }
        int parentDepth = this.depth(node.getParentNode());
        Filter filter = Controller.getCurrentController().getSelection().getFilter();
        if (!node.hasVisibleContent(filter) || AlwaysUnfoldedNode.isAlwaysUnfolded(node)) {
            return parentDepth;
        }
        return parentDepth + 1;
    }

    public JPopupMenu createFoldingPopupMenu(NodeModel node) {
        return new FoldingPopupMenu(node);
    }

    private class UnfoldAllAction
    extends AMultipleNodeAction {
        public UnfoldAllAction() {
            super("UnfoldAllAction");
        }

        @Override
        public void actionPerformed(ActionEvent e, NodeModel node) {
            FoldingController.this.unfoldAll(node);
        }
    }

    private class FoldAllAction
    extends AMultipleNodeAction {
        public FoldAllAction() {
            super("FoldAllAction");
        }

        @Override
        public void actionPerformed(ActionEvent e, NodeModel node) {
            FoldingController.this.foldAll(node);
        }
    }

    private class UnfoldOneLevelAction
    extends AMultipleNodeAction {
        public UnfoldOneLevelAction() {
            super("UnfoldOneLevelAction");
        }

        @Override
        public void actionPerformed(ActionEvent e, NodeModel node) {
            FoldingController.this.unfoldOneStage(node);
        }
    }

    private class FoldOneLevelAction
    extends AMultipleNodeAction {
        public FoldOneLevelAction() {
            super("FoldOneLevelAction");
        }

        @Override
        public void actionPerformed(ActionEvent e, NodeModel node) {
            FoldingController.this.foldOneStage(node);
        }
    }

    private class FoldingPopupMenu
    extends JPopupMenu {
        private final NodeModel node;

        FoldingPopupMenu(NodeModel node) {
            this.node = node;
            this.addAction(new UnfoldOneLevelPopupAction());
            this.addAction(new FoldOneLevelPopupAction());
            this.addAction(new UnfoldAllPopupAction());
            this.addAction(new FoldAllPopupAction());
        }

        private JButton addAction(Action a) {
            JButton menuItem = new JButton(a);
            menuItem.setToolTipText(menuItem.getText());
            menuItem.setText(null);
            this.add(menuItem);
            menuItem.setMargin(nullInsets);
            return menuItem;
        }

        private class UnfoldOneLevelPopupAction
        extends UnfoldOneLevelAction {
            private UnfoldOneLevelPopupAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.actionPerformed(e, FoldingPopupMenu.this.node);
            }
        }

        private class FoldOneLevelPopupAction
        extends FoldOneLevelAction {
            private FoldOneLevelPopupAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.actionPerformed(e, FoldingPopupMenu.this.node);
            }
        }

        private class UnfoldAllPopupAction
        extends UnfoldAllAction {
            private UnfoldAllPopupAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.actionPerformed(e, FoldingPopupMenu.this.node);
            }
        }

        private class FoldAllPopupAction
        extends FoldAllAction {
            private FoldAllPopupAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.actionPerformed(e, FoldingPopupMenu.this.node);
            }
        }
    }
}

