/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.awt.Color;
import java.awt.Point;
import java.util.Optional;
import org.freeplane.features.link.ConnectorArrows;
import org.freeplane.features.link.ConnectorShape;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.MapStyleModel;

class ConnectorProperties {
    private IStyle style;
    private Optional<Color> color;
    private Optional<Integer> alpha;
    private Optional<int[]> dash;
    private Optional<ConnectorArrows> arrows;
    private Optional<Integer> width;
    private Optional<ConnectorShape> shape;
    private Optional<String> labelFontFamily;
    private Optional<Integer> labelFontSize;
    private Point startInclination;
    private Point endInclination;
    private Optional<String> sourceLabel;
    private Optional<String> middleLabel;
    private Optional<String> targetLabel;

    public ConnectorProperties() {
        this.style = MapStyleModel.DEFAULT_STYLE;
        this.arrows = Optional.empty();
        this.dash = Optional.empty();
        this.color = Optional.empty();
        this.alpha = Optional.empty();
        this.width = Optional.empty();
        this.shape = Optional.empty();
        this.labelFontFamily = Optional.empty();
        this.labelFontSize = Optional.empty();
        this.sourceLabel = Optional.empty();
        this.middleLabel = Optional.empty();
        this.targetLabel = Optional.empty();
    }

    public ConnectorProperties(ConnectorArrows connectorEnds, int[] dash, Color color, int alpha, ConnectorShape shape, int width, String labelFontFamily, int labelFontSize) {
        assert (color != null);
        assert (shape != null);
        assert (connectorEnds != null);
        this.arrows = Optional.of(connectorEnds);
        this.dash = Optional.of(dash);
        this.color = Optional.of(color);
        this.alpha = Optional.of(alpha);
        this.width = Optional.of(width);
        this.shape = Optional.of(shape);
        this.labelFontFamily = Optional.of(labelFontFamily);
        this.labelFontSize = Optional.of(labelFontSize);
        this.style = MapStyleModel.DEFAULT_STYLE;
        this.sourceLabel = Optional.empty();
        this.middleLabel = Optional.empty();
        this.targetLabel = Optional.empty();
    }

    public IStyle getStyle() {
        return this.style;
    }

    public void setStyle(IStyle style) {
        this.style = style;
    }

    public Optional<ConnectorArrows> getArrows() {
        return this.arrows;
    }

    public void setArrows(Optional<ConnectorArrows> arrows) {
        this.arrows = arrows;
    }

    public Optional<ConnectorShape> getShape() {
        return this.shape;
    }

    public void setShape(Optional<ConnectorShape> shape) {
        this.shape = shape;
    }

    public Optional<int[]> getDash() {
        return this.dash;
    }

    public void setDash(Optional<int[]> dash) {
        this.dash = dash;
    }

    public Optional<Color> getColor() {
        return this.color;
    }

    public Point getEndInclination() {
        if (this.endInclination == null) {
            return null;
        }
        return new Point(this.endInclination);
    }

    public Optional<String> getMiddleLabel() {
        return this.middleLabel;
    }

    public Optional<String> getSourceLabel() {
        return this.sourceLabel;
    }

    public Optional<String> getTargetLabel() {
        return this.targetLabel;
    }

    public Point getStartInclination() {
        if (this.startInclination == null) {
            return null;
        }
        return new Point(this.startInclination);
    }

    public Optional<Integer> getWidth() {
        return this.width;
    }

    public void setColor(Optional<Color> color) {
        this.color = color;
    }

    public void setEndInclination(Point endInclination) {
        assert (endInclination != null);
        this.endInclination = endInclination;
    }

    public void setMiddleLabel(String middleLabel) {
        this.middleLabel = this.emptyString2emptyOptional(middleLabel);
    }

    public void setSourceLabel(String label) {
        this.sourceLabel = this.emptyString2emptyOptional(label);
    }

    public void setStartInclination(Point startInclination) {
        this.startInclination = startInclination;
    }

    public void setTargetLabel(String targetLabel) {
        this.targetLabel = this.emptyString2emptyOptional(targetLabel);
    }

    public void setWidth(Optional<Integer> width) {
        this.width = width;
    }

    public void setAlpha(Optional<Integer> alpha) {
        this.alpha = alpha;
    }

    public Optional<Integer> getAlpha() {
        return this.alpha;
    }

    public Optional<String> getLabelFontFamily() {
        return this.labelFontFamily;
    }

    public void setLabelFontFamily(Optional<String> labelFontFamily) {
        this.labelFontFamily = labelFontFamily;
    }

    public Optional<Integer> getLabelFontSize() {
        return this.labelFontSize;
    }

    public void setLabelFontSize(Optional<Integer> labelFontSize) {
        this.labelFontSize = labelFontSize;
    }

    private Optional<String> emptyString2emptyOptional(String label) {
        return "".equals(label) ? Optional.empty() : Optional.of(label);
    }

    public void changeInclination(int deltaX, int deltaY, NodeModel selectionRoot, NodeModel linkedNodeView, Point changedInclination) {
        double k;
        if (linkedNodeView.isLeft(selectionRoot)) {
            deltaX = -deltaX;
        }
        changedInclination.translate(deltaX, deltaY);
        if (changedInclination.x != 0 && Math.abs((double)changedInclination.y / (double)changedInclination.x) < 0.015) {
            changedInclination.y = 0;
        }
        if ((k = changedInclination.distance(0.0, 0.0)) < 10.0) {
            if (k > 0.0) {
                changedInclination.x = (int)((double)(changedInclination.x * 10) / k);
                changedInclination.y = (int)((double)(changedInclination.y * 10) / k);
            } else {
                changedInclination.x = 10;
            }
        }
    }
}

