/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.PriorityCompareCondition;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.n3.nanoxml.XMLElement;

class PriorityConditionController
implements IElementaryConditionController {
    static final String FILTER_PRIORITY = "filter_priority";
    private static final IconStore STORE = IconStoreFactory.ICON_STORE;

    @Override
    public boolean canEditValues(Object property, TranslatedObject simpleCond) {
        return false;
    }

    @Override
    public boolean canHandle(Object selectedItem) {
        if (!(selectedItem instanceof TranslatedObject)) {
            return false;
        }
        TranslatedObject namedObject = (TranslatedObject)selectedItem;
        return namedObject.objectEquals(FILTER_PRIORITY);
    }

    @Override
    public boolean canSelectValues(Object property, TranslatedObject simpleCond) {
        return true;
    }

    @Override
    public ASelectableCondition createCondition(Object selectedItem, TranslatedObject simpleCondition, Object valueObj, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        String value = ((MindIcon)valueObj).getName().substring(5, 6);
        if (simpleCondition.objectEquals("filter_is_equal_to")) {
            return new PriorityCompareCondition(value, 0, true);
        }
        if (simpleCondition.objectEquals("filter_is_not_equal_to")) {
            return new PriorityCompareCondition(value, 0, false);
        }
        if (simpleCondition.objectEquals(">")) {
            return new PriorityCompareCondition(value, 1, true);
        }
        if (simpleCondition.objectEquals(">=")) {
            return new PriorityCompareCondition(value, -1, false);
        }
        if (simpleCondition.objectEquals("<")) {
            return new PriorityCompareCondition(value, -1, true);
        }
        if (simpleCondition.objectEquals("<=")) {
            return new PriorityCompareCondition(value, 1, false);
        }
        return null;
    }

    @Override
    public ComboBoxModel getConditionsForProperty(Object selectedItem) {
        return new DefaultComboBoxModel<TranslatedObject>(new TranslatedObject[]{TextUtils.createTranslatedString("filter_is_equal_to"), TextUtils.createTranslatedString("filter_is_not_equal_to"), TranslatedObject.literal(">"), TranslatedObject.literal(">="), TranslatedObject.literal("<="), TranslatedObject.literal("<")});
    }

    @Override
    public ListModel getFilteredProperties() {
        DefaultListModel<TranslatedObject> list = new DefaultListModel<TranslatedObject>();
        list.addElement(TextUtils.createTranslatedString(FILTER_PRIORITY));
        return list;
    }

    @Override
    public ComboBoxEditor getValueEditor(Object selectedProperty, TranslatedObject selectedCondition) {
        return null;
    }

    @Override
    public ComboBoxModel getValuesForProperty(Object property, TranslatedObject simpleCond) {
        Object[] items = new Object[10];
        for (int i = 1; i < 10; ++i) {
            items[i - 1] = STORE.getMindIcon("full-" + Integer.toString(i));
        }
        DefaultComboBoxModel<Object> box = new DefaultComboBoxModel<Object>(items);
        return box;
    }

    @Override
    public boolean isCaseDependent(Object property, TranslatedObject simpleCond) {
        return false;
    }

    @Override
    public boolean supportsApproximateMatching(Object property, TranslatedObject simpleCond) {
        return false;
    }

    @Override
    public ASelectableCondition loadCondition(XMLElement element) {
        if (element.getName().equalsIgnoreCase("priority_compare_condition")) {
            return PriorityCompareCondition.load(element);
        }
        return null;
    }

    @Override
    public ListCellRenderer getValueRenderer(Object selectedProperty, TranslatedObject selectedCondition) {
        return null;
    }
}

