/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.util.Date;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.TypeReference;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.filter.condition.StringConditionAdapter;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.format.FormattedNumber;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.n3.nanoxml.XMLElement;

public abstract class CompareConditionAdapter
extends StringConditionAdapter {
    public static final String OBJECT = "OBJECT";
    public static final String VALUE = "VALUE";
    private Comparable<?> conditionValue;
    final StringMatchingStrategy stringMatchingStrategy;
    private int comparisonResult;
    private boolean error;

    public abstract boolean isEqualityCondition();

    protected CompareConditionAdapter(Object value, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        super(matchCase, matchApproximately, ignoreDiacritics);
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
        ResourceController resourceController = ResourceController.getResourceController();
        if (value instanceof String && resourceController.getBooleanProperty("compare_as_number") && TextUtils.isNumber((String)value)) {
            Number number = TextUtils.toNumber((String)value);
            if (number instanceof Comparable) {
                this.conditionValue = (Comparable)((Object)number);
            }
            return;
        }
        if (value instanceof FormattedNumber) {
            this.conditionValue = (FormattedNumber)value;
            return;
        }
        if (value instanceof FormattedDate) {
            FormattedDate date = (FormattedDate)value;
            if (date.containsTime() || date.getHours() == 0 && date.getMinutes() == 0 && date.getSeconds() == 0) {
                this.conditionValue = date;
            } else {
                Date reducedDate = new Date(date.getYear(), date.getMonth(), date.getDate());
                this.conditionValue = new FormattedDate(reducedDate.getTime(), date.getDateFormat());
            }
            return;
        }
        this.conditionValue = value.toString();
    }

    protected CompareConditionAdapter(Double value) {
        super(false, false, false);
        this.conditionValue = value;
        this.stringMatchingStrategy = this.matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    protected CompareConditionAdapter(Long value) {
        super(false, false, false);
        this.conditionValue = value;
        this.stringMatchingStrategy = this.matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        if (this.conditionValue instanceof IFormattedObject) {
            child.setAttribute(OBJECT, TypeReference.toSpec(this.conditionValue));
        } else {
            child.setAttribute(VALUE, this.conditionValue.toString());
        }
    }

    protected void compareTo(Object transformedContent) {
        this.error = false;
        this.comparisonResult = Integer.signum(this.compareToData(transformedContent));
    }

    private int compareToData(Object transformedContent) {
        if (this.conditionValue instanceof FormattedNumber && transformedContent instanceof Number) {
            return -((FormattedNumber)this.conditionValue).compareTo((Number)transformedContent);
        }
        if (this.conditionValue instanceof Number && transformedContent instanceof String) {
            try {
                Number number = TextUtils.toNumber((String)transformedContent);
                if (this.conditionValue instanceof FormattedNumber) {
                    return -((FormattedNumber)this.conditionValue).compareTo(number);
                }
                if (number instanceof Long) {
                    return this.compareTo((Long)number);
                }
                if (number instanceof Double) {
                    return this.compareTo((Double)number);
                }
            }
            catch (NumberFormatException number) {
                // empty catch block
            }
            this.error = true;
            return 0;
        }
        if (this.conditionValue instanceof FormattedDate) {
            if (transformedContent instanceof Date) {
                return this.compareTo((Date)transformedContent);
            }
            this.error = true;
            return 0;
        }
        String normalizedValue = this.normalizedValue();
        String text = this.normalize(transformedContent);
        if (this.isEqualityCondition()) {
            return this.stringMatchingStrategy.matches(normalizedValue, text, false) ? 0 : -1;
        }
        return text.compareTo(normalizedValue);
    }

    protected int getComparisonResult() {
        return this.comparisonResult;
    }

    protected boolean isComparisonOK() {
        return !this.error;
    }

    private int compareTo(Double value) {
        return value.compareTo(((Number)((Object)this.conditionValue)).doubleValue());
    }

    protected int compareTo(Long value) {
        return value.compareTo((Long)this.conditionValue);
    }

    private int compareTo(Date value) {
        if (((FormattedDate)this.conditionValue).containsTime() || value.getHours() == 0 && value.getMinutes() == 0 && value.getSeconds() == 0) {
            return value.compareTo((Date)this.conditionValue);
        }
        return new Date(value.getYear(), value.getMonth(), value.getDate()).compareTo((Date)this.conditionValue);
    }

    public String createDescription(String attribute, int comparationResult, boolean succeed) {
        String simpleCondition;
        switch (comparationResult) {
            case -1: {
                simpleCondition = succeed ? "<" : ">=";
                break;
            }
            case 0: {
                simpleCondition = TextUtils.getText(succeed ? "filter_is_equal_to" : "filter_is_not_equal_to");
                break;
            }
            case 1: {
                simpleCondition = succeed ? ">" : "<=";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this.createDescription(attribute, simpleCondition, this.valueDescription());
    }

    private String valueDescription() {
        return this.conditionValue.toString();
    }

    @Override
    public Comparable<?> conditionValue() {
        return this.conditionValue;
    }
}

