/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.freeplane.core.ui.components.DashIconFactory;
import org.freeplane.core.ui.components.RenderedContent;
import org.freeplane.core.ui.components.RenderedContentSupplier;
import org.freeplane.core.ui.components.UITools;

public enum DashVariant implements RenderedContentSupplier<DashVariant>
{
    SOLID(new int[0]),
    CLOSE_DOTS(new int[]{3, 3}),
    DASHES(new int[]{7, 7}),
    DISTANT_DOTS(new int[]{2, 7}),
    DOTS_AND_DASHES(new int[]{2, 7, 7, 7});

    public static DashVariant DEFAULT;
    public final int[] variant;
    public final Icon icon;

    public static Optional<DashVariant> of(int[] variant) {
        return Stream.of(DashVariant.values()).filter(self -> Arrays.equals(self.variant, variant)).findAny();
    }

    private DashVariant(int[] variant) {
        this.variant = variant;
        int LINE_WIDTH = 2;
        int ICON_HEIGHT = Math.round(12.0f * UITools.FONT_SCALE_FACTOR);
        int ICON_WIDTH = ICON_HEIGHT * 5;
        this.icon = DashIconFactory.createIcon(ICON_WIDTH, ICON_HEIGHT, 2, variant);
    }

    @Override
    public RenderedContent<DashVariant> createRenderedContent() {
        return new RenderedContent<DashVariant>(this, null, this.icon);
    }

    static {
        DEFAULT = SOLID;
    }
}

