/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.mode.Controller;

public class FileUtils {
    private static final Map<String, String> cachedResources = new HashMap<String, String>();

    public static void copyFromURL(URL resource, File destinationDirectory) {
        String path = resource.getPath();
        int index = path.lastIndexOf(47);
        String fileName = URLDecoder.decode(index > -1 ? path.substring(index + 1) : path);
        try (InputStream in = resource.openStream();
             FileOutputStream out = new FileOutputStream(new File(destinationDirectory, fileName));){
            FileUtils.copyStream(in, out);
        }
        catch (Exception e) {
            LogUtils.severe("File not found or could not be copied. Was searching for " + path + " and should go to " + destinationDirectory.getAbsolutePath());
        }
    }

    public static void copyFromResource(String path, String fileName, File destinationDirectory) {
        String pathToResource = path + fileName;
        try {
            URL resource = pathToResource.startsWith("file:") ? new URL(pathToResource) : ResourceController.getResourceController().getResource(pathToResource);
            if (resource == null) {
                LogUtils.severe("Cannot find resource: " + pathToResource);
                return;
            }
            try (BufferedInputStream in = new BufferedInputStream(resource.openStream());
                 FileOutputStream out = new FileOutputStream(new File(destinationDirectory, fileName));){
                FileUtils.copyStream(in, out);
            }
        }
        catch (Exception e) {
            LogUtils.severe("File not found or could not be copied. Was searching for " + pathToResource + " and should go to " + destinationDirectory.getAbsolutePath());
        }
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    public static void dumpStringToFile(String string, File outFile, String encoding) throws IOException {
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), encoding);){
            out.write(string);
        }
    }

    public static boolean createDirectory(String directoryName) {
        File dir = new File(directoryName);
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        return true;
    }

    public static Properties loadProperties(String classpathRessource) {
        Properties props = new Properties();
        try (InputStream in = FileUtils.class.getResource(classpathRessource).openStream();){
            props.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return props;
    }

    private static String slurp(Reader reader) throws IOException {
        int len;
        StringBuilder builder = new StringBuilder();
        char[] buf = new char[1024];
        while ((len = reader.read(buf)) > 0) {
            builder.append(buf, 0, len);
        }
        String result = builder.toString();
        return result;
    }

    public static String slurpResource(URL resource) throws IOException {
        try (InputStream instream = resource.openStream();){
            BufferedReader input = new BufferedReader(new InputStreamReader(instream, StandardCharsets.UTF_8));
            String string = FileUtils.slurp(input);
            return string;
        }
    }

    public static String slurpResource(String fileName) throws IOException {
        if (cachedResources.containsKey(fileName)) {
            return cachedResources.get(fileName);
        }
        URL resource = ResourceController.getResourceController().getResource(fileName);
        if (resource == null) {
            LogUtils.severe("Cannot find resource: " + fileName);
            return "";
        }
        String slurpedResource = FileUtils.slurpResource(resource);
        cachedResources.put(fileName, slurpedResource);
        return slurpedResource;
    }

    public static String slurpFile(File file) throws IOException {
        try (FileReader in = new FileReader(file);){
            String string = FileUtils.slurp(in);
            return string;
        }
    }

    public static String slurpFile(String fileName) throws IOException {
        return FileUtils.slurpFile(new File(fileName));
    }

    public static Charset defaultCharset() {
        try {
            String defaultCharsetName = ResourceController.getResourceController().getProperty("default_charset");
            if (defaultCharsetName.equals("JVMdefault")) {
                return Charset.defaultCharset();
            }
            return Charset.forName(defaultCharsetName);
        }
        catch (Exception e) {
            return Charset.defaultCharset();
        }
    }

    public static String getExtension(File f) {
        return FileUtils.getExtension(f.toString());
    }

    public static String getExtension(String s) {
        if (s == null) {
            return null;
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (c == File.separatorChar || c == '/') {
                return "";
            }
            if (c != '.') continue;
            return s.substring(i + 1).trim().toLowerCase();
        }
        return "";
    }

    public static boolean isAbsolutePath(String path) {
        String osNameStart = System.getProperty("os.name").substring(0, 3);
        String fileSeparator = System.getProperty("file.separator");
        if (osNameStart.equals("Win")) {
            return path.length() > 1 && path.substring(1, 2).equals(":") || path.startsWith(fileSeparator);
        }
        if (osNameStart.equals("Mac")) {
            return path.startsWith(fileSeparator);
        }
        return path.startsWith(fileSeparator);
    }

    public static String readFile(File pInputFile) {
        StringBuilder lines = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(pInputFile));){
            String line;
            String endLine = System.getProperty("line.separator");
            while ((line = bufferedReader.readLine()) != null) {
                lines.append(line).append(endLine);
            }
        }
        catch (Exception e) {
            LogUtils.severe(e);
            return null;
        }
        return lines.toString();
    }

    public static String removeExtension(String s) {
        int i = s.lastIndexOf(46);
        return i > 0 && i < s.length() - 1 ? s.substring(0, i) : s;
    }

    public static void setHidden(File file, boolean hidden, boolean synchronously) {
        String osNameStart = System.getProperty("os.name").substring(0, 3);
        if (osNameStart.equals("Win")) {
            try {
                Controller.exec("attrib " + (hidden ? "+" : "-") + "H \"" + file.getAbsolutePath() + "\"");
                if (!synchronously) {
                    return;
                }
                for (int timeOut = 10; file.isHidden() != hidden && timeOut > 0; --timeOut) {
                    Thread.sleep(10L);
                }
            }
            catch (Exception e) {
                LogUtils.severe(e);
            }
        }
    }

    public static void copyFile(File in, File out) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(in);
             FileOutputStream fileOutputStream = new FileOutputStream(out);
             FileChannel inChannel = fileInputStream.getChannel();
             FileChannel outChannel = fileOutputStream.getChannel();){
            int maxCount = 67076096;
            long size = inChannel.size();
            for (long position = 0L; position < size; position += inChannel.transferTo(position, maxCount, outChannel)) {
            }
        }
    }

    public static String validFileNameOf(String proposal) {
        return proposal.replaceAll("[&:/\\\\\u0000%$#~\\?\\*]+", "");
    }

    public static File getAbsoluteFile(String baseDir, String file) {
        if (FileUtils.isAbsolutePath(file)) {
            return new File(file);
        }
        return new File(baseDir, file);
    }
}

