/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.action;

import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryPopupListener;
import org.freeplane.core.ui.menubuilders.generic.UserRole;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class ActionStatusUpdater
implements EntryPopupListener {
    @Override
    public void childEntriesWillBecomeVisible(Entry submenu) {
        UserRole userRole = this.currentUserRole();
        this.childEntriesWillBecomeVisible(submenu, userRole);
    }

    UserRole currentUserRole() {
        Controller currentController = Controller.getCurrentController();
        if (currentController == null) {
            return UserRole.NO_MAP;
        }
        ModeController currentModeController = Controller.getCurrentModeController();
        if (currentModeController == null) {
            return UserRole.NO_MAP;
        }
        MapModel map = currentController.getMap();
        UserRole userRole = currentModeController.userRole(map);
        return userRole;
    }

    void childEntriesWillBecomeVisible(Entry submenu, UserRole userRole) {
        for (Entry target : submenu.children()) {
            AFreeplaneAction action = new EntryAccessor().getAction(target);
            if (action == null) continue;
            if (action.checkEnabledOnPopup()) {
                action.setEnabled(userRole);
            }
            if (!action.checkSelectionOnPopup() || !action.isEnabled()) continue;
            action.setSelected();
        }
    }

    @Override
    public void childEntriesHidden(Entry target) {
    }
}

