/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components.html;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.StringReader;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.freeplane.core.ui.components.html.ScaledEditorKit;
import org.freeplane.core.ui.components.html.SynchronousScaledEditorKit;
import org.freeplane.core.util.HtmlUtils;

public class ScaledHTML
extends BasicHTML {
    static final String styleChanges = "p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }";

    static Renderer createHTMLView(JLabel c, String html) {
        ScaledEditorKit kit = SynchronousScaledEditorKit.create();
        Document doc = kit.createDefaultDocument(c);
        Object base = c.getClientProperty("html.base");
        if (base instanceof URL) {
            ((HTMLDocument)doc).setBase((URL)base);
        }
        StringReader r = new StringReader(html);
        try {
            kit.read(r, doc, 0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ViewFactory f = kit.getViewFactory();
        View hview = f.create(doc.getDefaultRootElement());
        Renderer v = new Renderer(c, f, hview);
        return v;
    }

    public static void updateRendererOnForegroundChange(JLabel c, String text) {
        Object newRenderer;
        Renderer oldRenderer = (Renderer)c.getClientProperty("html");
        ScaledHTML.updateRenderer(c, text);
        if (oldRenderer != null && (newRenderer = c.getClientProperty("html")) instanceof Renderer) {
            ((Renderer)newRenderer).setSize(oldRenderer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRenderer(JLabel c, String text) {
        Renderer value = null;
        try {
            View oldValue = (View)c.getClientProperty("html");
            if (ScaledHTML.isHTMLString(text)) {
                value = ScaledHTML.createHTMLView(c, text);
            } else if (c.getClientProperty(StyleSheet.class) != null) {
                value = ScaledHTML.createHTMLView(c, HtmlUtils.plainToHTML(text));
            }
            if (value != oldValue && oldValue != null) {
                for (int i = 0; i < oldValue.getViewCount(); ++i) {
                    oldValue.getView(i).setParent(null);
                }
            }
        }
        catch (Throwable throwable) {
            c.putClientProperty("html", value);
            throw throwable;
        }
        c.putClientProperty("html", value);
    }

    public static class Renderer
    extends View {
        private static final int NOT_INITIALIZED = -1;
        private int width;
        private int height;
        private View view;
        private ViewFactory factory;
        private JComponent host;
        private boolean setSizeRunning = true;
        private float initialWidth = -1.0f;
        private float initialHeight = -1.0f;

        Renderer(JComponent c, ViewFactory f, View v) {
            super(null);
            this.host = c;
            this.factory = f;
            this.view = v;
            this.view.setParent(this);
        }

        private void setSize(Renderer oldRenderer) {
            this.initialWidth = oldRenderer.initialWidth;
            if (this.initialWidth != -1.0f) {
                this.initialHeight = oldRenderer.initialHeight;
                this.setSize(oldRenderer.width, oldRenderer.height);
            }
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public float getPreferredSpan(int axis) {
            this.initialize();
            if (axis == 0) {
                return this.width;
            }
            return this.view.getPreferredSpan(axis);
        }

        private void initialize() {
            if (this.initialWidth == -1.0f) {
                this.initialWidth = this.view.getPreferredSpan(0);
                this.initialHeight = this.view.getPreferredSpan(1);
                this.setSize(this.initialWidth, this.initialHeight);
            }
        }

        @Override
        public float getMinimumSpan(int axis) {
            this.initialize();
            return this.view.getMinimumSpan(axis);
        }

        @Override
        public float getMaximumSpan(int axis) {
            return 2.1474836E9f;
        }

        @Override
        public void preferenceChanged(View child, boolean width, boolean height) {
            if (!this.setSizeRunning) {
                this.host.revalidate();
                this.host.repaint();
            }
        }

        @Override
        public float getAlignment(int axis) {
            return this.view.getAlignment(axis);
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
            Rectangle alloc = allocation.getBounds();
            this.view.setSize(alloc.width, alloc.height);
            this.view.paint(g, allocation);
        }

        @Override
        public void setParent(View parent) {
            throw new Error("Can't set parent on root view");
        }

        @Override
        public int getViewCount() {
            return 1;
        }

        @Override
        public View getView(int n) {
            return this.view;
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            return this.view.modelToView(pos, a, b);
        }

        @Override
        public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
            return this.view.modelToView(p0, b0, p1, b1, a);
        }

        @Override
        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            return this.view.viewToModel(x, y, a, bias);
        }

        @Override
        public Document getDocument() {
            return this.view.getDocument();
        }

        @Override
        public int getStartOffset() {
            return this.view.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.view.getEndOffset();
        }

        @Override
        public Element getElement() {
            return this.view.getElement();
        }

        @Override
        public void setSize(float width, float height) {
            this.setSizeRunning = true;
            try {
                this.width = (int)width;
                this.height = (int)height;
                this.view.setSize(width, height);
            }
            finally {
                this.setSizeRunning = false;
            }
        }

        public void resetWidth() {
            this.initialize();
            this.setSize(this.initialWidth, this.initialHeight);
        }

        @Override
        public Container getContainer() {
            return this.host;
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.factory;
        }

        public float getPreferredWidth() {
            this.initialize();
            return this.initialWidth;
        }

        public int getWidth() {
            this.initialize();
            return this.width;
        }

        public void setWidth(int width) {
            this.initialize();
            this.setSize(width, this.initialHeight);
        }
    }
}

