/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.OptionalDontShowMeAgainDialog;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewManager;

public class ExternalMapChangeMonitor
implements IMapSelectionListener {
    private static final String MONITOR_EXTERNAL_MIND_MAP_FILE_CHANGES_PROPERTY = "monitor_external_mind_map_file_changes";
    private static final int FIRST_CHECK_DELAY_MILLIS = 1000;
    private static final int CHECK_INTERVAL_MILLIS = 5000;
    private static final ExternalMapChangeMonitor INSTANCE = new ExternalMapChangeMonitor();
    private Timer timer = new Timer(5000, this::checkCurrentMapForExternalChange);

    public static void install(IMapViewManager viewManager) {
        viewManager.addMapSelectionListener((IMapSelectionListener)INSTANCE);
    }

    private ExternalMapChangeMonitor() {
        this.timer.setInitialDelay(1000);
        this.timer.start();
    }

    public void afterMapChange(MapModel oldMap, MapModel newMap) {
        this.timer.restart();
    }

    private void checkCurrentMapForExternalChange(ActionEvent event) {
        MapModel map = Controller.getCurrentController().getMap();
        this.checkForExternalChange(map);
    }

    public void checkForExternalChange(MapModel map) {
        if (map == null) {
            return;
        }
        Controller controller = Controller.getCurrentController();
        if (controller.getMap() != map) {
            return;
        }
        boolean reloadsMapAfterExternalChange = ResourceController.getResourceController().getBooleanProperty(MONITOR_EXTERNAL_MIND_MAP_FILE_CHANGES_PROPERTY, true);
        if (!reloadsMapAfterExternalChange) {
            return;
        }
        Window focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (focusedWindow == null) {
            return;
        }
        JComponent mapViewComponent = controller.getMapViewManager().getMapViewComponent();
        if (mapViewComponent == null) {
            return;
        }
        if (!SwingUtilities.isDescendingFrom(mapViewComponent, focusedWindow)) {
            return;
        }
        if (!map.hasExternalFileChanged()) {
            return;
        }
        int shouldReload = OptionalDontShowMeAgainDialog.show((String)"reload_mindmap_after_external_change", (String)MONITOR_EXTERNAL_MIND_MAP_FILE_CHANGES_PROPERTY, (OptionalDontShowMeAgainDialog.MessageType)OptionalDontShowMeAgainDialog.MessageType.ONLY_CANCEL_SELECTION_IS_STORED);
        if (shouldReload != 0) {
            map.updateLastKnownFileModificationTime();
        } else {
            this.reloadMap(map);
        }
    }

    private void reloadMap(MapModel map) {
        Controller controller = Controller.getCurrentController();
        if (controller.getMap() != map) {
            return;
        }
        MMapController mapController = (MMapController)controller.getModeController().getMapController();
        try {
            mapController.restoreCurrentMapIgnoreAlternatives();
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
        }
    }
}

