/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text.mindmapmode;

import com.lightdev.app.shtm.SHTMLWriter;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;

public class SplitNode
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public SplitNode() {
        super("SplitNode");
    }

    public void actionPerformed(ActionEvent e) {
        List list = Controller.getCurrentModeController().getMapController().getSelectedNodes();
        for (NodeModel next : list) {
            this.splitNode(next);
        }
    }

    private Element getParentElement(HTMLDocument doc) {
        Element htmlRoot = doc.getDefaultRootElement();
        Element parentCandidate = htmlRoot.getElement(htmlRoot.getElementCount() - 1);
        do {
            if (parentCandidate.getElementCount() <= 1) continue;
            return parentCandidate;
        } while (!(parentCandidate = parentCandidate.getElement(0)).isLeaf() && !parentCandidate.getName().equalsIgnoreCase("p-implied"));
        return null;
    }

    private void splitNode(NodeModel node) {
        if (node.isRoot()) {
            return;
        }
        String text = node.getText();
        String[] parts = this.splitNode(text);
        if (parts == null || parts.length == 1) {
            return;
        }
        ModeController c = Controller.getCurrentModeController();
        int firstPartNumber = 0;
        while (parts[firstPartNumber] == null) {
            ++firstPartNumber;
        }
        ((MTextController)TextController.getController()).setNodeText(node, parts[firstPartNumber]);
        NodeModel parent = node.getParentNode();
        int nodePosition = parent.getIndex(node) + 1;
        for (int i = parts.length - 1; i > firstPartNumber; --i) {
            MMapController mapController = (MMapController)c.getMapController();
            String part = parts[i];
            if (part == null) continue;
            NodeModel lowerNode = mapController.addNewNode(parent, nodePosition, node.getSide());
            ((MTextController)TextController.getController()).setNodeText(lowerNode, part);
            MLogicalStyleController.getController().setStyle(lowerNode, LogicalStyleModel.getStyle((NodeModel)node));
            MNodeStyleController nodeStyleController = (MNodeStyleController)NodeStyleController.getController();
            nodeStyleController.copyStyle(node, lowerNode);
            mapController.setFolded(lowerNode, !lowerNode.isFolded(), Controller.getCurrentController().getSelection().getFilter());
        }
    }

    private String[] splitNode(String text) {
        if (text.startsWith("<html>")) {
            String[] parts = null;
            HTMLEditorKit kit = new HTMLEditorKit();
            HTMLDocument doc = new HTMLDocument();
            StringReader buf = new StringReader(text);
            try {
                kit.read(buf, (Document)doc, 0);
                Element parent = this.getParentElement(doc);
                if (parent == null) {
                    return null;
                }
                int elementCount = parent.getElementCount();
                int notEmptyElementCount = 0;
                parts = new String[elementCount];
                int start = parent.getStartOffset();
                for (int i = 0; i < elementCount; ++i) {
                    Element current = parent.getElement(i);
                    if (current.isLeaf() && !current.getName().equals(HTML.Tag.BR.toString()) && i < elementCount - 1) continue;
                    int end = current.getEndOffset();
                    String newFragment = this.getFragment(doc, start, end);
                    if (newFragment != null) {
                        parts[i] = newFragment;
                        ++notEmptyElementCount;
                    }
                    start = end;
                }
                if (notEmptyElementCount <= 1) {
                    return null;
                }
            }
            catch (IOException e) {
                LogUtils.severe((Throwable)e);
            }
            catch (BadLocationException e) {
                LogUtils.severe((Throwable)e);
            }
            return parts;
        }
        return text.split("\n");
    }

    private String getFragment(HTMLDocument doc, int start, int end) throws BadLocationException, IOException {
        String paragraphText = doc.getText(start, end - start).trim();
        if (paragraphText.length() > 0) {
            StringWriter out = new StringWriter();
            new SHTMLWriter((Writer)out, doc, start, end - start).write();
            String fragment = out.toString();
            if (!fragment.equals("")) {
                return fragment;
            }
        }
        return null;
    }
}

