/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.terminal;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.editors.sql.terminal.SQLTerminalMessages;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class SQLTerminalPreferencesPage
extends TargetPrefPage {
    private static final Log log = Log.getLog(SQLTerminalPreferencesPage.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sqleditor.terminalview";
    private Button showTerminalViewByDefault;
    private Button showQueryText;
    private Button showServerOutput;

    protected boolean hasDataSourceSpecificOptions(@NotNull DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("SQLEditor.ConsoleView.showConsoleViewByDefault") || store.contains("SQLEditor.SQLTerminal.showQueryText") || store.contains("SQLEditor.SQLTerminal.showServerOutput");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Group commonGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_editor_group_common, (int)2, (int)770, (int)0);
        this.showTerminalViewByDefault = UIUtils.createCheckbox((Composite)commonGroup, (String)SQLTerminalMessages.pref_page_sql_temrinal_show_output_console_view_label, (String)SQLTerminalMessages.pref_page_sql_temrinal_show_output_console_view_tip, (boolean)false, (int)2);
        this.showQueryText = UIUtils.createCheckbox((Composite)commonGroup, (String)SQLTerminalMessages.pref_page_sql_temrinal_show_query_text_label, null, (boolean)false, (int)2);
        this.showServerOutput = UIUtils.createCheckbox((Composite)commonGroup, (String)SQLTerminalMessages.pref_page_sql_temrinal_show_server_output_label, null, (boolean)false, (int)2);
        return composite;
    }

    protected void loadPreferences(@NotNull DBPPreferenceStore store) {
        try {
            this.showTerminalViewByDefault.setSelection(store.getBoolean("SQLEditor.ConsoleView.showConsoleViewByDefault"));
            this.showQueryText.setSelection(store.getBoolean("SQLEditor.SQLTerminal.showQueryText"));
            this.showServerOutput.setSelection(store.getBoolean("SQLEditor.SQLTerminal.showServerOutput"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(@NotNull DBPPreferenceStore store) {
        try {
            store.setValue("SQLEditor.ConsoleView.showConsoleViewByDefault", this.showTerminalViewByDefault.getSelection());
            store.setValue("SQLEditor.SQLTerminal.showQueryText", this.showQueryText.getSelection());
            store.setValue("SQLEditor.SQLTerminal.showServerOutput", this.showServerOutput.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(@NotNull DBPPreferenceStore store) {
        store.setToDefault("SQLEditor.ConsoleView.showConsoleViewByDefault");
        store.setToDefault("SQLEditor.SQLTerminal.showQueryText");
        store.setToDefault("SQLEditor.SQLTerminal.showServerOutput");
    }

    @NotNull
    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

