/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DataSourceVariableResolver;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.runtime.ui.UIServiceSecurity;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditor;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditorSite;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.VariablesHintLabel;
import org.jkiss.dbeaver.ui.dialogs.AcceptLicenseDialog;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public abstract class ConnectionPageAbstract
extends DialogPage
implements IDataSourceConnectionEditor {
    protected static final String GROUP_CONNECTION_MODE = "connectionMode";
    @NotNull
    protected final Map<String, List<Control>> propGroupMap = new HashMap<String, List<Control>>();
    protected IDataSourceConnectionEditorSite site;
    protected Text driverText;
    protected Text passwordText;
    protected Button savePasswordCheck;
    protected ToolBar userManagementToolbar;
    private VariablesHintLabel variablesHintLabel;
    @Nullable
    protected Button typeManualRadio;
    @Nullable
    protected Button typeURLRadio;
    private ImageDescriptor curImageDescriptor;
    private Button licenseButton;

    public IDataSourceConnectionEditorSite getSite() {
        return this.site;
    }

    public void dispose() {
        super.dispose();
    }

    public void setSite(IDataSourceConnectionEditorSite site) {
        this.site = site;
    }

    protected boolean isCustomURL() {
        return false;
    }

    public void loadSettings() {
        DBPDriver driver = this.site.getDriver();
        if (driver != null && this.driverText != null) {
            this.driverText.setText(CommonUtils.toString((Object)driver.getFullName()));
        }
        UIUtils.setControlVisible((Control)this.licenseButton, (driver != null && !CommonUtils.isEmpty((String)driver.getLicense()) ? 1 : 0) != 0);
        DataSourceDescriptor dataSource = (DataSourceDescriptor)this.getSite().getActiveDataSource();
        if (this.savePasswordCheck != null) {
            if (dataSource != null) {
                this.savePasswordCheck.setSelection(dataSource.isSavePassword());
            } else {
                this.savePasswordCheck.setSelection(true);
            }
        }
        if (this.variablesHintLabel != null) {
            if (dataSource != null) {
                this.variablesHintLabel.setResolver((IVariableResolver)new DataSourceVariableResolver((DBPDataSourceContainer)dataSource, dataSource.getConnectionConfiguration()));
            } else {
                this.variablesHintLabel.setResolver(null);
            }
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        this.saveConnectionURL(dataSource.getConnectionConfiguration());
        if (this.savePasswordCheck != null) {
            DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSource;
            descriptor.setSavePassword(this.savePasswordCheck.getSelection());
            if (!descriptor.isSavePassword()) {
                descriptor.resetPassword();
            }
        }
    }

    protected void saveConnectionURL(DBPConnectionConfiguration connectionInfo) {
        if (!this.isCustomURL()) {
            connectionInfo.setUrl(this.site.getDriver().getConnectionURL(connectionInfo));
        }
    }

    protected void createDriverPanel(Composite parent) {
        Composite panel = UIUtils.createComposite((Composite)parent, (int)5);
        GridData gd = new GridData(776);
        gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        panel.setLayoutData((Object)gd);
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("database.connect.processEnvVars")) {
            this.variablesHintLabel = new VariablesHintLabel(panel, UIConnectionMessages.dialog_connection_edit_connection_settings_variables_hint_label, UIConnectionMessages.dialog_connection_edit_connection_settings_variables_hint_label, DBPConnectionConfiguration.INTERNAL_CONNECT_VARIABLES, false);
            ((GridData)this.variablesHintLabel.getInfoLabel().getLayoutData()).horizontalSpan = this.site.isNew() ? 4 : 5;
        } else {
            UIUtils.createEmptyLabel((Composite)panel, (int)5, (int)1);
        }
        if (this.site.isNew()) {
            Button advSettingsButton = UIUtils.createDialogButton((Composite)panel, (String)UIConnectionMessages.dialog_connection_edit_wizard_conn_conf_general_link, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionPageAbstract.this.site.openSettingsPage("ConnectionPageGeneral");
                }
            });
            advSettingsButton.setLayoutData((Object)new GridData(128));
        }
        Label divLabel = new Label(panel, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 5;
        divLabel.setLayoutData((Object)gd);
        Composite driverInfoComp = UIUtils.createComposite((Composite)panel, (int)5);
        gd = new GridData(768);
        gd.horizontalSpan = 5;
        driverInfoComp.setLayoutData((Object)gd);
        Label driverLabel = new Label(driverInfoComp, 0);
        driverLabel.setText(UIConnectionMessages.dialog_connection_driver);
        driverLabel.setLayoutData((Object)new GridData(32));
        this.driverText = new Text(driverInfoComp, 8);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.driverText.setLayoutData((Object)gd);
        if (DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("driver-manager")) {
            Button driverButton = UIUtils.createDialogButton((Composite)driverInfoComp, (String)UIConnectionMessages.dialog_connection_edit_driver_button, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ConnectionPageAbstract.this.site.openDriverEditor()) {
                        ConnectionPageAbstract.this.updateDriverInfo(ConnectionPageAbstract.this.site.getDriver());
                    }
                }
            });
            driverButton.setLayoutData((Object)new GridData(128));
        } else {
            UIUtils.createEmptyLabel((Composite)driverInfoComp, (int)1, (int)1);
        }
        this.licenseButton = UIUtils.createDialogButton((Composite)driverInfoComp, (String)UIConnectionMessages.dialog_edit_driver_text_driver_license, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String driverLicense = ConnectionPageAbstract.this.site.getDriver().getLicense();
                if (CommonUtils.isEmpty((String)driverLicense)) {
                    driverLicense = "N/A";
                }
                AcceptLicenseDialog licenseDialog = new AcceptLicenseDialog(ConnectionPageAbstract.this.getShell(), ConnectionPageAbstract.this.site.getDriver().getFullName(), driverLicense);
                licenseDialog.setViewMode(true);
                licenseDialog.open();
            }
        });
        this.licenseButton.setLayoutData((Object)new GridData(128));
    }

    protected void updateDriverInfo(DBPDriver driver) {
    }

    public void setImageDescriptor(ImageDescriptor desc) {
        if (this.curImageDescriptor != desc) {
            super.setImageDescriptor(desc);
            this.curImageDescriptor = desc;
        }
    }

    protected Text createPasswordText(Composite parent, String label) {
        if (label != null) {
            UIUtils.createControlLabel((Composite)parent, (String)label);
        }
        Composite ph = UIUtils.createPlaceholder((Composite)parent, (int)1);
        ph.setLayoutData((Object)new GridData(768));
        this.passwordText = new Text(ph, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(768));
        return this.passwordText;
    }

    protected void createPasswordControls(Composite parent) {
        this.createPasswordControls(parent, 1);
    }

    protected void createPasswordControls(Composite parent, int hSpan) {
        final UIServiceSecurity serviceSecurity = (UIServiceSecurity)DBWorkbench.getService(UIServiceSecurity.class);
        boolean supportsPasswordView = serviceSecurity != null;
        Composite panel = UIUtils.createComposite((Composite)parent, (int)(supportsPasswordView ? 2 : 1));
        GridData gd = new GridData(32);
        if (hSpan > 1) {
            gd.horizontalSpan = hSpan;
        }
        panel.setLayoutData((Object)gd);
        DataSourceDescriptor dataSource = (DataSourceDescriptor)this.getSite().getActiveDataSource();
        this.savePasswordCheck = UIUtils.createCheckbox((Composite)panel, (String)UIConnectionMessages.dialog_connection_wizard_final_checkbox_save_password_locally, (dataSource == null || dataSource.isSavePassword() ? 1 : 0) != 0);
        this.savePasswordCheck.setToolTipText(UIConnectionMessages.dialog_connection_wizard_final_checkbox_save_password_locally);
        if (supportsPasswordView) {
            this.userManagementToolbar = new ToolBar(panel, 256);
            ToolItem showPasswordLabel = new ToolItem(this.userManagementToolbar, 0);
            showPasswordLabel.setToolTipText("Show password on screen");
            showPasswordLabel.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SHOW_ALL_DETAILS));
            showPasswordLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionPageAbstract.this.showPasswordText(serviceSecurity);
                }
            });
        }
    }

    private void showPasswordText(UIServiceSecurity serviceSecurity) {
        boolean passHidden;
        Composite passContainer = this.passwordText.getParent();
        boolean bl = passHidden = (this.passwordText.getStyle() & 0x400000) == 0x400000;
        if (passHidden && !serviceSecurity.validatePassword(this.site.getProject(), "Enter project password", "Enter project master password to unlock connection password view", true)) {
            return;
        }
        Object layoutData = this.passwordText.getLayoutData();
        String curValue = this.passwordText.getText();
        this.passwordText.dispose();
        this.passwordText = passHidden ? new Text(passContainer, 2048) : new Text(passContainer, 0x400800);
        this.passwordText.setLayoutData(layoutData);
        this.passwordText.setText(curValue);
        passContainer.layout(true, true);
    }

    protected Image createImage(String imageFilePath) {
        ImageDescriptor imageDescriptor = ResourceLocator.imageDescriptorFromBundle(((Object)((Object)this)).getClass(), (String)imageFilePath).orElse(null);
        return imageDescriptor == null ? null : imageDescriptor.createImage();
    }

    protected void createConnectionModeSwitcher(Composite parent, SelectionAdapter typeSwitcher) {
        Label cnnTypeLabel = UIUtils.createControlLabel((Composite)parent, (String)UIConnectionMessages.dialog_connection_mode_label);
        cnnTypeLabel.setLayoutData((Object)new GridData(128));
        Composite modeGroup = UIUtils.createComposite((Composite)parent, (int)3);
        this.typeManualRadio = UIUtils.createRadioButton((Composite)modeGroup, (String)UIConnectionMessages.dialog_connection_host_label, (Object)false, (SelectionListener)typeSwitcher);
        this.typeURLRadio = UIUtils.createRadioButton((Composite)modeGroup, (String)UIConnectionMessages.dialog_connection_url_label, (Object)true, (SelectionListener)typeSwitcher);
        modeGroup.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).create());
        this.addControlToGroup(GROUP_CONNECTION_MODE, (Control)cnnTypeLabel);
        this.addControlToGroup(GROUP_CONNECTION_MODE, (Control)modeGroup);
    }

    protected void setupConnectionModeSelection(@NotNull Text urlText, boolean useUrl, @NotNull Collection<String> nonUrlPropGroups) {
        if (this.typeURLRadio != null) {
            this.typeURLRadio.setSelection(useUrl);
        }
        if (this.typeManualRadio != null) {
            this.typeManualRadio.setSelection(!useUrl);
        }
        urlText.setEditable(useUrl);
        urlText.setEnabled(useUrl);
        boolean nonUrl = !useUrl;
        for (String groupName : nonUrlPropGroups) {
            List<Control> controls = this.propGroupMap.get(groupName);
            if (controls == null) continue;
            for (Control control : controls) {
                control.setEnabled(nonUrl);
                if (!(control instanceof Text)) continue;
                ((Text)control).setEditable(nonUrl);
            }
        }
    }

    protected void addControlToGroup(@NotNull String group, @NotNull Control control) {
        this.propGroupMap.computeIfAbsent(group, k -> new ArrayList()).add(control);
    }
}

