/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreBackupRestoreSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupSettings;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupWizard;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreToolWizardPageSettings;
import org.jkiss.dbeaver.tasks.nativetool.NativeToolUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

class PostgreBackupWizardPageSettings
extends PostgreToolWizardPageSettings<PostgreBackupWizard> {
    private Text outputFolderText;
    private Text outputFileText;
    private Combo formatCombo;
    private Combo compressCombo;
    private Combo encodingCombo;
    private Button useInsertsCheck;
    private Button noPrivilegesCheck;
    private Button noOwnerCheck;
    private Button dropObjects;
    private Button createDatabase;

    PostgreBackupWizardPageSettings(PostgreBackupWizard wizard) {
        super(wizard, PostgreMessages.wizard_backup_page_setting_title_setting);
        this.setTitle(PostgreMessages.wizard_backup_page_setting_title);
        this.setDescription(PostgreMessages.wizard_backup_page_setting_description);
    }

    protected boolean determinePageCompletion() {
        if (((PostgreDatabaseBackupSettings)((PostgreBackupWizard)this.wizard).getSettings()).getOutputFolderPattern() == null) {
            this.setErrorMessage("Output folder not specified");
            return false;
        }
        return super.determinePageCompletion();
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        SelectionAdapter changeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgreBackupWizardPageSettings.this.updateState();
            }
        };
        Group formatGroup = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.wizard_backup_page_setting_group_setting, (int)2, (int)768, (int)0);
        this.formatCombo = UIUtils.createLabelCombo((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_label_format, (int)12);
        this.formatCombo.setLayoutData((Object)new GridData(32));
        PostgreBackupRestoreSettings.ExportFormat[] exportFormatArray = PostgreBackupRestoreSettings.ExportFormat.values();
        int n = exportFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            PostgreBackupRestoreSettings.ExportFormat format = exportFormatArray[n2];
            this.formatCombo.add(format.getTitle());
            ++n2;
        }
        PostgreDatabaseBackupSettings settings = (PostgreDatabaseBackupSettings)((PostgreBackupWizard)this.wizard).getSettings();
        this.formatCombo.select(settings.getFormat().ordinal());
        this.formatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgreBackupWizardPageSettings.this.fixOutputFileExtension();
                PostgreBackupWizardPageSettings.this.updateState();
            }
        });
        this.compressCombo = UIUtils.createLabelCombo((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_label_compression, (int)12);
        this.compressCombo.setLayoutData((Object)new GridData(32));
        this.compressCombo.add("");
        int i = 0;
        while (i <= 9) {
            String compStr = String.valueOf(i);
            this.compressCombo.add(compStr);
            if (compStr.equals(settings.getCompression())) {
                this.compressCombo.select(i);
            }
            ++i;
        }
        if (this.compressCombo.getSelectionIndex() < 0) {
            this.compressCombo.select(0);
        }
        this.compressCombo.addSelectionListener((SelectionListener)changeListener);
        UIUtils.createControlLabel((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_label_encoding);
        this.encodingCombo = UIUtils.createEncodingCombo((Composite)formatGroup, null);
        this.encodingCombo.addSelectionListener((SelectionListener)changeListener);
        this.encodingCombo.setText(settings.getEncoding());
        this.useInsertsCheck = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_checkbox_use_insert, (String)PostgreMessages.wizard_backup_page_setting_checkbox_use_insert_tip, (boolean)settings.isUseInserts(), (int)2);
        this.useInsertsCheck.addSelectionListener((SelectionListener)changeListener);
        this.noPrivilegesCheck = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_checkbox_no_privileges, (String)PostgreMessages.wizard_backup_page_setting_checkbox_no_privileges_tip, (boolean)settings.isNoPrivileges(), (int)2);
        this.noPrivilegesCheck.addSelectionListener((SelectionListener)changeListener);
        this.noOwnerCheck = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_checkbox_no_owner, (String)PostgreMessages.wizard_backup_page_setting_checkbox_no_owner_tip, (boolean)settings.isNoOwner(), (int)2);
        this.noOwnerCheck.addSelectionListener((SelectionListener)changeListener);
        this.dropObjects = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_checkbox_drop_objects, (String)PostgreMessages.wizard_backup_page_setting_checkbox_drop_objects_tip, (boolean)settings.isDropObjects(), (int)2);
        this.dropObjects.addSelectionListener((SelectionListener)changeListener);
        this.createDatabase = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_checkbox_create_database, (String)PostgreMessages.wizard_backup_page_setting_checkbox_create_database_tip, (boolean)settings.isCreateDatabase(), (int)2);
        this.createDatabase.addSelectionListener((SelectionListener)changeListener);
        Group outputGroup = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.wizard_backup_page_setting_group_output, (int)2, (int)768, (int)0);
        this.outputFolderText = DialogUtils.createOutputFolderChooser((Composite)outputGroup, (String)PostgreMessages.wizard_backup_page_setting_label_output_folder_pattern, (String)(settings.getOutputFolderPattern() != null ? settings.getOutputFolderPattern() : null), e -> this.updateState());
        this.outputFileText = UIUtils.createLabelText((Composite)outputGroup, (String)PostgreMessages.wizard_backup_page_setting_label_file_name_pattern, (String)settings.getOutputFilePattern());
        UIUtils.setContentProposalToolTip((Control)this.outputFileText, (String)PostgreMessages.wizard_backup_page_setting_label_file_name_pattern_output, (String[])NativeToolUtils.ALL_VARIABLES);
        ContentAssistUtils.installContentProposal((Control)this.outputFileText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider((String[])Arrays.stream(NativeToolUtils.ALL_VARIABLES).map(GeneralUtils::variablePattern).toArray(String[]::new)));
        this.outputFileText.addModifyListener(e -> settings.setOutputFilePattern(this.outputFileText.getText()));
        UIUtils.setContentProposalToolTip((Control)this.outputFolderText, (String)PostgreMessages.wizard_backup_page_setting_label_file_name_pattern_output, (String[])NativeToolUtils.LIMITED_VARIABLES);
        ContentAssistUtils.installContentProposal((Control)this.outputFolderText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider((String[])Arrays.stream(NativeToolUtils.LIMITED_VARIABLES).map(GeneralUtils::variablePattern).toArray(String[]::new)));
        this.fixOutputFileExtension();
        this.createExtraArgsInput((Composite)outputGroup);
        Composite extraGroup = UIUtils.createComposite((Composite)composite, (int)2);
        this.createSecurityGroup(extraGroup);
        this.setControl((Control)composite);
    }

    private void fixOutputFileExtension() {
        boolean isDotWithEmptyExt;
        String ext;
        String name;
        String text = this.outputFileText.getText();
        int idxOfExtStart = text.lastIndexOf(46);
        if (idxOfExtStart > -1 && idxOfExtStart <= text.length()) {
            name = text.substring(0, idxOfExtStart);
            ext = text.substring(idxOfExtStart + 1);
        } else {
            name = text;
            ext = "";
        }
        String newExt = this.getChosenExportFormat().getExt();
        boolean bl = isDotWithEmptyExt = ext.isEmpty() && idxOfExtStart > -1;
        if (Objects.equals(ext, newExt) && !isDotWithEmptyExt) {
            return;
        }
        if (!newExt.isEmpty()) {
            newExt = "." + newExt;
        }
        text = String.valueOf(name) + newExt;
        this.outputFileText.setText(text);
    }

    protected void updateState() {
        this.saveState();
        this.updatePageCompletion();
        this.getContainer().updateButtons();
    }

    public void saveState() {
        super.saveState();
        PostgreDatabaseBackupSettings settings = (PostgreDatabaseBackupSettings)((PostgreBackupWizard)this.wizard).getSettings();
        String fileName = this.outputFolderText.getText();
        settings.setOutputFolderPattern(CommonUtils.isEmpty((String)fileName) ? null : fileName);
        settings.setOutputFilePattern(this.outputFileText.getText());
        settings.setFormat(this.getChosenExportFormat());
        settings.setCompression(this.compressCombo.getText());
        settings.setEncoding(this.encodingCombo.getText());
        settings.setUseInserts(this.useInsertsCheck.getSelection());
        settings.setNoPrivileges(this.noPrivilegesCheck.getSelection());
        settings.setNoOwner(this.noOwnerCheck.getSelection());
        settings.setDropObjects(this.dropObjects.getSelection());
        settings.setCreateDatabase(this.createDatabase.getSelection());
    }

    private PostgreBackupRestoreSettings.ExportFormat getChosenExportFormat() {
        return PostgreBackupRestoreSettings.ExportFormat.values()[this.formatCombo.getSelectionIndex()];
    }
}

