/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.ui.actions;

import org.eclipse.gef3.Disposable;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.commands.CommandStack;
import org.eclipse.gef3.ui.actions.UpdateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchPart;

public abstract class WorkbenchPartAction
extends Action
implements Disposable,
UpdateAction {
    private IWorkbenchPart workbenchPart;
    private boolean lazyEnablement = true;

    public WorkbenchPartAction(IWorkbenchPart part) {
        this.setWorkbenchPart(part);
        this.init();
    }

    public WorkbenchPartAction(IWorkbenchPart part, int style) {
        super(null, style);
        this.setWorkbenchPart(part);
        this.init();
    }

    protected abstract boolean calculateEnabled();

    @Override
    public void dispose() {
    }

    protected void execute(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        this.getCommandStack().execute(command);
    }

    protected CommandStack getCommandStack() {
        return (CommandStack)this.getWorkbenchPart().getAdapter(CommandStack.class);
    }

    protected IWorkbenchPart getWorkbenchPart() {
        return this.workbenchPart;
    }

    protected void init() {
    }

    public boolean isEnabled() {
        if (this.lazyEnablement) {
            this.setEnabled(this.calculateEnabled());
        }
        return super.isEnabled();
    }

    protected void refresh() {
        this.setEnabled(this.calculateEnabled());
    }

    public void setLazyEnablementCalculation(boolean value) {
        this.lazyEnablement = value;
    }

    protected void setWorkbenchPart(IWorkbenchPart part) {
        this.workbenchPart = part;
    }

    @Override
    public void update() {
        this.refresh();
    }
}

