/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.ui.actions;

import java.util.List;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.PrecisionDimension;
import org.eclipse.draw2dl.geometry.PrecisionRectangle;
import org.eclipse.draw2dl.geometry.Translatable;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.commands.CompoundCommand;
import org.eclipse.gef3.internal.GEFMessages;
import org.eclipse.gef3.internal.InternalImages;
import org.eclipse.gef3.requests.ChangeBoundsRequest;
import org.eclipse.gef3.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;

public class MatchSizeAction
extends SelectionAction {
    public MatchSizeAction(IWorkbenchPart part) {
        super(part);
        this.setText(GEFMessages.MatchSizeAction_Label);
        this.setImageDescriptor(InternalImages.DESC_MATCH_SIZE);
        this.setDisabledImageDescriptor(InternalImages.DESC_MATCH_SIZE_DIS);
        this.setToolTipText(GEFMessages.MatchSizeAction_Tooltip);
        this.setId("org.eclipse.gef3.match.size");
    }

    @Override
    protected boolean calculateEnabled() {
        Command cmd = this.createMatchSizeCommand(this.getSelectedObjects());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    private Command createMatchSizeCommand(List objects) {
        if (objects.isEmpty()) {
            return null;
        }
        if (!(objects.get(0) instanceof GraphicalEditPart)) {
            return null;
        }
        GraphicalEditPart primarySelection = this.getPrimarySelectionEditPart(this.getSelectedObjects());
        if (primarySelection == null) {
            return null;
        }
        GraphicalEditPart part = null;
        ChangeBoundsRequest request = null;
        PrecisionDimension preciseDimension = null;
        PrecisionRectangle precisePartBounds = null;
        Command cmd = null;
        CompoundCommand command = new CompoundCommand();
        PrecisionRectangle precisePrimaryBounds = new PrecisionRectangle(primarySelection.getFigure().getBounds().getCopy());
        primarySelection.getFigure().translateToAbsolute((Translatable)precisePrimaryBounds);
        int i = 0;
        while (i < objects.size()) {
            part = (GraphicalEditPart)objects.get(i);
            if (!part.equals(primarySelection)) {
                request = new ChangeBoundsRequest("resize");
                precisePartBounds = new PrecisionRectangle(part.getFigure().getBounds().getCopy());
                part.getFigure().translateToAbsolute((Translatable)precisePartBounds);
                preciseDimension = new PrecisionDimension();
                preciseDimension.setPreciseWidth(this.getPreciseWidthDelta(precisePartBounds, precisePrimaryBounds));
                preciseDimension.setPreciseHeight(this.getPreciseHeightDelta(precisePartBounds, precisePrimaryBounds));
                request.setSizeDelta((Dimension)preciseDimension);
                cmd = part.getCommand(request);
                if (cmd != null) {
                    command.add(cmd);
                }
            }
            ++i;
        }
        return command;
    }

    protected double getPreciseHeightDelta(PrecisionRectangle precisePartBounds, PrecisionRectangle precisePrimaryBounds) {
        return precisePrimaryBounds.preciseHeight() - precisePartBounds.preciseHeight();
    }

    private GraphicalEditPart getPrimarySelectionEditPart(List editParts) {
        GraphicalEditPart part = null;
        int i = 0;
        while (i < editParts.size()) {
            part = (GraphicalEditPart)editParts.get(i);
            if (part.getSelected() == 2) {
                return part;
            }
            ++i;
        }
        return null;
    }

    protected double getPreciseWidthDelta(PrecisionRectangle precisePartBounds, PrecisionRectangle precisePrimaryBounds) {
        return precisePrimaryBounds.preciseWidth() - precisePartBounds.preciseWidth();
    }

    public void run() {
        this.execute(this.createMatchSizeCommand(this.getSelectedObjects()));
    }
}

