/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.layout.impl;

import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.LayoutFactory;
import org.eclipse.birt.chart.model.layout.LayoutPackage;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.model.layout.impl.BlockImpl;
import org.eclipse.birt.chart.model.layout.impl.ClientAreaImpl;
import org.eclipse.birt.chart.model.layout.impl.LabelBlockImpl;
import org.eclipse.birt.chart.model.layout.impl.LegendImpl;
import org.eclipse.birt.chart.model.layout.impl.PlotImpl;
import org.eclipse.birt.chart.model.layout.impl.TitleBlockImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

public class LayoutFactoryImpl
extends EFactoryImpl
implements LayoutFactory {
    public static LayoutFactory init() {
        try {
            LayoutFactory theLayoutFactory = (LayoutFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.birt.eclipse.org/ChartModelLayout");
            if (theLayoutFactory != null) {
                return theLayoutFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new LayoutFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createBlock();
            }
            case 1: {
                return this.createClientArea();
            }
            case 2: {
                return this.createLabelBlock();
            }
            case 3: {
                return this.createLegend();
            }
            case 4: {
                return this.createPlot();
            }
            case 5: {
                return this.createTitleBlock();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createEllipsisTypeFromString(eDataType, initialValue);
            }
            case 7: {
                return this.createEllipsisTypeObjectFromString(eDataType, initialValue);
            }
            case 8: {
                return this.createTitlePercentTypeFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createTitlePercentTypeObjectFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertEllipsisTypeToString(eDataType, instanceValue);
            }
            case 7: {
                return this.convertEllipsisTypeObjectToString(eDataType, instanceValue);
            }
            case 8: {
                return this.convertTitlePercentTypeToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertTitlePercentTypeObjectToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Block createBlock() {
        BlockImpl block = new BlockImpl();
        return block;
    }

    @Override
    public ClientArea createClientArea() {
        ClientAreaImpl clientArea = new ClientAreaImpl();
        return clientArea;
    }

    @Override
    public LabelBlock createLabelBlock() {
        LabelBlockImpl labelBlock = new LabelBlockImpl();
        return labelBlock;
    }

    @Override
    public Legend createLegend() {
        LegendImpl legend = new LegendImpl();
        return legend;
    }

    @Override
    public Plot createPlot() {
        PlotImpl plot = new PlotImpl();
        return plot;
    }

    @Override
    public TitleBlock createTitleBlock() {
        TitleBlockImpl titleBlock = new TitleBlockImpl();
        return titleBlock;
    }

    public Integer createEllipsisTypeFromString(EDataType eDataType, String initialValue) {
        return (Integer)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.INT, initialValue);
    }

    public String convertEllipsisTypeToString(EDataType eDataType, Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.INT, instanceValue);
    }

    public Integer createEllipsisTypeObjectFromString(EDataType eDataType, String initialValue) {
        return this.createEllipsisTypeFromString(LayoutPackage.Literals.ELLIPSIS_TYPE, initialValue);
    }

    public String convertEllipsisTypeObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertEllipsisTypeToString(LayoutPackage.Literals.ELLIPSIS_TYPE, instanceValue);
    }

    public Double createTitlePercentTypeFromString(EDataType eDataType, String initialValue) {
        return (Double)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.DOUBLE, initialValue);
    }

    public String convertTitlePercentTypeToString(EDataType eDataType, Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.DOUBLE, instanceValue);
    }

    public Double createTitlePercentTypeObjectFromString(EDataType eDataType, String initialValue) {
        return this.createTitlePercentTypeFromString(LayoutPackage.Literals.TITLE_PERCENT_TYPE, initialValue);
    }

    public String convertTitlePercentTypeObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertTitlePercentTypeToString(LayoutPackage.Literals.TITLE_PERCENT_TYPE, instanceValue);
    }

    @Override
    public LayoutPackage getLayoutPackage() {
        return (LayoutPackage)this.getEPackage();
    }

    @Deprecated
    public static LayoutPackage getPackage() {
        return LayoutPackage.eINSTANCE;
    }
}

