/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.markers.internal.BookmarkFilter;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class DialogBookmarkFilter
extends DialogMarkerFilter {
    private DescriptionGroup descriptionGroup;

    public DialogBookmarkFilter(Shell parentShell, BookmarkFilter[] filters) {
        super(parentShell, filters);
    }

    @Override
    protected void createAttributesArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(5, false);
        layout.verticalSpacing = 7;
        composite.setLayout((Layout)layout);
        this.descriptionGroup = new DescriptionGroup(composite);
    }

    @Override
    protected void updateFilterFromUI(MarkerFilter filter) {
        super.updateFilterFromUI(filter);
        BookmarkFilter bookmark = (BookmarkFilter)filter;
        bookmark.setContains(this.descriptionGroup.getContains());
        bookmark.setDescription(this.descriptionGroup.getDescription().trim());
    }

    @Override
    protected void updateUIWithFilter(MarkerFilter filter) {
        super.updateUIWithFilter(filter);
        BookmarkFilter bookmark = (BookmarkFilter)filter;
        this.descriptionGroup.setContains(bookmark.getContains());
        this.descriptionGroup.setDescription(bookmark.getDescription());
    }

    @Override
    protected void updateEnabledState(boolean enabled) {
        super.updateEnabledState(enabled);
        this.descriptionGroup.updateEnablement(enabled);
    }

    @Override
    protected void resetPressed() {
        this.descriptionGroup.setContains(true);
        this.descriptionGroup.setDescription("");
        super.resetPressed();
    }

    @Override
    protected MarkerFilter newFilter(String newName) {
        return new BookmarkFilter(newName);
    }

    private class DescriptionGroup {
        private Label descriptionLabel;
        private Combo combo;
        private Text description;
        private String contains = MarkerMessages.filtersDialog_contains;
        private String doesNotContain = MarkerMessages.filtersDialog_doesNotContain;

        public DescriptionGroup(Composite parent) {
            this.descriptionLabel = new Label(parent, 0);
            this.descriptionLabel.setFont(parent.getFont());
            this.descriptionLabel.setText(MarkerMessages.filtersDialog_descriptionLabel);
            this.combo = new Combo(parent, 8);
            this.combo.setFont(parent.getFont());
            this.combo.add(this.contains);
            this.combo.add(this.doesNotContain);
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DialogBookmarkFilter.this.updateForSelection();
                }
            });
            this.combo.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2 || e.detail == 4) {
                        e.doit = false;
                    }
                }
            });
            this.description = new Text(parent, 2052);
            this.description.setFont(parent.getFont());
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            this.description.setLayoutData((Object)data);
            this.description.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DialogBookmarkFilter.this.markDirty();
                }
            });
        }

        public boolean getContains() {
            return this.combo.getSelectionIndex() == this.combo.indexOf(this.contains);
        }

        public void setContains(boolean value) {
            if (value) {
                this.combo.select(this.combo.indexOf(this.contains));
            } else {
                this.combo.select(this.combo.indexOf(this.doesNotContain));
            }
        }

        public void setDescription(String text) {
            if (text == null) {
                this.description.setText("");
            } else {
                this.description.setText(text);
            }
        }

        public String getDescription() {
            return this.description.getText();
        }

        public void updateEnablement(boolean enabled) {
            this.descriptionLabel.setEnabled(enabled);
            this.combo.setEnabled(enabled);
            this.description.setEnabled(enabled);
        }
    }
}

