#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cryptol
version:              2.13.0
visibility:           public
id:                   cryptol-2.13.0-IW2Tx0vnrg88EudTIbYr1Y
key:                  cryptol-2.13.0-IW2Tx0vnrg88EudTIbYr1Y
license:              BSD-3-Clause
copyright:            2013-2021 Galois Inc.
maintainer:           cryptol@galois.com
author:               Galois, Inc.
homepage:             http://www.cryptol.net/
synopsis:             Cryptol: The Language of Cryptography
description:
    Cryptol is a domain-specific language for specifying cryptographic algorithms. A Cryptol implementation of an algorithm resembles its mathematical specification more closely than an implementation in a general purpose language. For more, see <http://www.cryptol.net/>.

category:             Language
abi:                  869b7c7e560d4c329127e326d92e9607
exposed:              True
exposed-modules:
    Cryptol.AES Cryptol.Backend Cryptol.Backend.Arch
    Cryptol.Backend.Concrete Cryptol.Backend.FloatHelpers
    Cryptol.Backend.Monad Cryptol.Backend.SBV Cryptol.Backend.SeqMap
    Cryptol.Backend.What4 Cryptol.Backend.WordValue Cryptol.Eval
    Cryptol.Eval.Concrete Cryptol.Eval.Env Cryptol.Eval.Generic
    Cryptol.Eval.Prims Cryptol.Eval.Reference Cryptol.Eval.SBV
    Cryptol.Eval.Type Cryptol.Eval.Value Cryptol.Eval.What4 Cryptol.F2
    Cryptol.IR.FreeVars Cryptol.ModuleSystem Cryptol.ModuleSystem.Base
    Cryptol.ModuleSystem.Env Cryptol.ModuleSystem.Exports
    Cryptol.ModuleSystem.Fingerprint
    Cryptol.ModuleSystem.InstantiateModule
    Cryptol.ModuleSystem.Interface Cryptol.ModuleSystem.Monad
    Cryptol.ModuleSystem.Name Cryptol.ModuleSystem.NamingEnv
    Cryptol.ModuleSystem.Renamer Cryptol.ModuleSystem.Renamer.Error
    Cryptol.ModuleSystem.Renamer.Monad Cryptol.Parser
    Cryptol.Parser.AST Cryptol.Parser.Layout Cryptol.Parser.Lexer
    Cryptol.Parser.Name Cryptol.Parser.Names Cryptol.Parser.NoInclude
    Cryptol.Parser.NoPat Cryptol.Parser.Position
    Cryptol.Parser.Selector Cryptol.Parser.Token Cryptol.Parser.Unlit
    Cryptol.Parser.Utils Cryptol.PrimeEC Cryptol.REPL.Browse
    Cryptol.REPL.Command Cryptol.REPL.Monad Cryptol.REPL.Trie
    Cryptol.SHA Cryptol.Symbolic Cryptol.Symbolic.SBV
    Cryptol.Symbolic.What4 Cryptol.Testing.Random
    Cryptol.Transform.AddModParams Cryptol.Transform.MonoValues
    Cryptol.Transform.Specialize Cryptol.TypeCheck
    Cryptol.TypeCheck.AST Cryptol.TypeCheck.CheckModuleInstance
    Cryptol.TypeCheck.Default Cryptol.TypeCheck.Error
    Cryptol.TypeCheck.Infer Cryptol.TypeCheck.InferTypes
    Cryptol.TypeCheck.Instantiate Cryptol.TypeCheck.Interface
    Cryptol.TypeCheck.Kind Cryptol.TypeCheck.Monad Cryptol.TypeCheck.PP
    Cryptol.TypeCheck.Parseable Cryptol.TypeCheck.Sanity
    Cryptol.TypeCheck.SimpType Cryptol.TypeCheck.SimpleSolver
    Cryptol.TypeCheck.Solve Cryptol.TypeCheck.Solver.Class
    Cryptol.TypeCheck.Solver.Improve Cryptol.TypeCheck.Solver.InfNat
    Cryptol.TypeCheck.Solver.Numeric
    Cryptol.TypeCheck.Solver.Numeric.Fin
    Cryptol.TypeCheck.Solver.Numeric.Interval
    Cryptol.TypeCheck.Solver.SMT Cryptol.TypeCheck.Solver.Selector
    Cryptol.TypeCheck.Solver.Types Cryptol.TypeCheck.Solver.Utils
    Cryptol.TypeCheck.Subst Cryptol.TypeCheck.TCon
    Cryptol.TypeCheck.Type Cryptol.TypeCheck.TypeMap
    Cryptol.TypeCheck.TypeOf Cryptol.TypeCheck.TypePat
    Cryptol.TypeCheck.Unify Cryptol.Utils.Debug Cryptol.Utils.Fixity
    Cryptol.Utils.Ident Cryptol.Utils.Logger Cryptol.Utils.Misc
    Cryptol.Utils.PP Cryptol.Utils.Panic Cryptol.Utils.Patterns
    Cryptol.Utils.RecordMap Cryptol.Version

hidden-modules:
    Cryptol.Parser.LexerUtils Cryptol.Parser.ParserUtils
    Cryptol.Prelude GHC.Num.Compat Paths_cryptol GitRev

import-dirs:          /usr/lib/ghc-9.0.2/site-local/cryptol-2.13.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/cryptol-2.13.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/cryptol
hs-libraries:         HScryptol-2.13.0-IW2Tx0vnrg88EudTIbYr1Y
depends:
    GraphSCC-1.0.4-L501TucQ29l4TPS6ekdbOm
    MemoTrie-0.6.10-IWRPIHAWE1DCEGcLIJwISU
    arithmoi-0.12.0.2-2iiAjMiddwiEwPjKiOtKQH array-0.5.4.0
    async-2.2.4-9EoKZTgytm43s60GeTAIZR base-4.15.1.0
    base-compat-0.12.2-l1EqrM7Qwu6Pq9d4drKFu
    bv-sized-1.0.4-7rtuAEU65piKXRy5usB3fr bytestring-0.10.12.1
    containers-0.6.4.1
    cryptohash-sha1-0.11.101.0-JEtkXlImqJm2HHCf1KVLi1 deepseq-1.4.5.0
    directory-1.3.6.2 exceptions-0.10.4 filepath-1.4.2.1 ghc-bignum-1.1
    ghc-prim-0.7.0 gitrev-1.3.1-1rbGTqrAtYS9ErCWqXvHZK
    heredoc-0.2.0.0-Vg50v7MniO6qfzQgR2euT
    libBF-0.6.5.1-KueXYqkJqo9Ae0ncPeIFCk
    monad-control-1.0.3.1-21gUZpZbgH5KO3QvMCPaGC
    monadLib-3.10.1-A3o7k6g82F1K1bu0eunRsp mtl-2.2.2
    panic-0.4.0.1-2wjLiVfd2FlFLaw0kmLA9p
    parameterized-utils-2.1.5.0-CmlKiUF7QEHGJKHwPvS6eP
    prettyprinter-1.7.1-Kh082I8LQyjLFudtJnG2xP process-1.6.13.2
    sbv-9.0-C3tX1Nxj8ImHeMvf1bBAkS
    simple-smt-0.9.7-1XK6mespUdTBUDu58fk4Rr stm-2.5.0.0
    strict-0.4.0.1-2mY0lBYSyne2S4tzH93Ukt text-1.2.5.0
    tf-random-0.5-KtA6USPDHzeHM9k7conBq8 time-1.9.3
    transformers-base-0.4.6-2M49J28Ed0L2XQvH4AySxP
    what4-1.3-H44aCGr872O3wobbsgj10R

haddock-interfaces:   /usr/share/doc/cryptol/html/cryptol.haddock
haddock-html:         /usr/share/doc/cryptol/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

