#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 clash-ghc
version:              1.6.4
visibility:           public
id:                   clash-ghc-1.6.4-4xpK9AeIHuQ2oo06r7V8h5
key:                  clash-ghc-1.6.4-4xpK9AeIHuQ2oo06r7V8h5
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2017, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - GHC frontend

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * Clash Compiler binary using GHC/Haskell as a frontend


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  39814ca0cbffe3cefae8405ef701d4b9
exposed:              True
exposed-modules:
    Clash.GHC.Evaluator Clash.GHC.Evaluator.Primitive
    Clash.GHC.GenerateBindings Clash.GHC.LoadModules
    Clash.GHC.NetlistTypes Clash.GHC.PartialEval
    Clash.GHC.PartialEval.Eval Clash.GHC.PartialEval.Primitive
    Clash.GHC.PartialEval.Quote Clash.GHCi.Common Clash.Main

hidden-modules:
    Clash.GHCi.Leak Clash.GHCi.UI Clash.GHCi.UI.Info
    Clash.GHCi.UI.Monad Clash.GHCi.UI.Tags Clash.GHC.ClashFlags
    Clash.GHC.GHC2Core Clash.GHC.LoadInterfaceFiles Clash.GHC.Util
    Paths_clash_ghc Clash.GHCi.Util

import-dirs:          /usr/lib/ghc-9.0.2/site-local/clash-ghc-1.6.4
library-dirs:         /usr/lib/ghc-9.0.2/site-local/clash-ghc-1.6.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/clash-ghc
hs-libraries:         HSclash-ghc-1.6.4-4xpK9AeIHuQ2oo06r7V8h5
depends:
    Cabal-3.4.1.0 array-0.5.4.0 base-4.15.1.0 bytestring-0.10.12.1
    clash-lib-1.6.4-8Fn8uF8fA1sIsIYF5qKydu
    clash-prelude-1.6.4-BJJFSzO5uP13RmWNJeGbVN
    concurrent-supply-0.1.8-8KZUWJnJtBN5d4OKnaNBZ6 containers-0.6.4.1
    data-binary-ieee754-0.4.4-6nKeQnWkGoLJGejCHaRaWS deepseq-1.4.5.0
    directory-1.3.6.2 exceptions-0.10.4
    extra-1.7.12-DPTGYhuNp118MPDFhQYU8g filepath-1.4.2.1 ghc-9.0.2
    ghc-bignum-1.1 ghc-boot-9.0.2 ghc-prim-0.7.0
    ghc-typelits-extra-0.4.3-rbaCZPvErnGdMfv5Li0AR
    ghc-typelits-knownnat-0.7.6-AfmxZ7icSW8C0I1JlhXpwq
    ghc-typelits-natnormalise-0.7.6-7S3hyb6rglJI7G69cQCfzq ghci-9.0.2
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F haskeline-0.8.2
    lens-5.1.1-8cVW77ucFRGIbO4yMEfpoM mtl-2.2.2
    primitive-0.7.4.0-CfTIpXUHtu665Ilg6bT1BW process-1.6.13.2
    reflection-2.1.6-BJdzOLrQPM410aC3yfrNGl
    split-0.2.3.5-1ZFbiAR4sQhKaqqBevLjN8 template-haskell-2.17.0.0
    text-1.2.5.0 time-1.9.3 transformers-0.5.6.2
    uniplate-1.6.13-Bz3m6aJYQrB6IKo2ZbSAY5 unix-2.7.2.2
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    utf8-string-1.0.2-Fg3PN5UX3ZfnukMwwaDpj
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:   /usr/share/doc/clash-ghc/html/clash-ghc.haddock
haddock-html:         /usr/share/doc/clash-ghc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

