"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const electron_1 = require("electron");
const electron_better_ipc_1 = require("electron-better-ipc");
const config_1 = __importDefault(require("./config"));
const util_1 = require("./util");
const constants_1 = require("./constants");
const { TouchBarButton } = electron_1.TouchBar;
const MAX_VISIBLE_LENGTH = 25;
const privateModeTouchBarLabel = new TouchBarButton({
    label: 'Private mode enabled',
    icon: electron_1.nativeImage.createFromPath(constants_1.caprineIconPath),
    iconPosition: 'left',
});
function setTouchBar(items) {
    const touchBar = new electron_1.TouchBar({ items });
    const win = (0, util_1.getWindow)();
    win.setTouchBar(touchBar);
}
function createLabel(label) {
    if (label.length > MAX_VISIBLE_LENGTH) {
        // If the label is too long, we'll render a truncated one with "…" appended
        return `${label.slice(0, MAX_VISIBLE_LENGTH)}…`;
    }
    return label;
}
function createTouchBarButton({ label, selected, icon }, index) {
    return new TouchBarButton({
        label: createLabel(label),
        backgroundColor: selected ? '#0084ff' : undefined,
        icon: electron_1.nativeImage.createFromDataURL(icon),
        iconPosition: 'left',
        click() {
            (0, util_1.sendAction)('jump-to-conversation', index + 1);
        },
    });
}
electron_better_ipc_1.ipcMain.answerRenderer('conversations', (conversations) => {
    if (config_1.default.get('privateMode')) {
        setTouchBar([privateModeTouchBarLabel]);
    }
    else {
        setTouchBar(conversations.map((conversation, index) => createTouchBarButton(conversation, index)));
    }
});
