/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.expression;

import java.util.List;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.expression.ArrayAccess;
import org.checkerframework.errorprone.dataflow.expression.ArrayCreation;
import org.checkerframework.errorprone.dataflow.expression.BinaryOperation;
import org.checkerframework.errorprone.dataflow.expression.ClassName;
import org.checkerframework.errorprone.dataflow.expression.FieldAccess;
import org.checkerframework.errorprone.dataflow.expression.FormalParameter;
import org.checkerframework.errorprone.dataflow.expression.JavaExpression;
import org.checkerframework.errorprone.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.errorprone.dataflow.expression.LocalVariable;
import org.checkerframework.errorprone.dataflow.expression.MethodCall;
import org.checkerframework.errorprone.dataflow.expression.ThisReference;
import org.checkerframework.errorprone.dataflow.expression.UnaryOperation;
import org.checkerframework.errorprone.dataflow.expression.Unknown;
import org.checkerframework.errorprone.dataflow.expression.ValueLiteral;

public abstract class JavaExpressionScanner<P>
extends JavaExpressionVisitor<Void, P> {
    public void scan(JavaExpression javaExpression, P p) {
        this.visit(javaExpression, p);
    }

    public void scan(List<? extends @Nullable JavaExpression> expressions, P p) {
        for (JavaExpression javaExpression : expressions) {
            if (javaExpression == null) continue;
            this.visit(javaExpression, p);
        }
    }

    @Override
    protected Void visitArrayAccess(ArrayAccess arrayAccessExpr, P p) {
        this.visit(arrayAccessExpr.getArray(), p);
        this.visit(arrayAccessExpr.getIndex(), p);
        return null;
    }

    @Override
    protected Void visitArrayCreation(ArrayCreation arrayCreationExpr, P p) {
        this.scan(arrayCreationExpr.getDimensions(), p);
        this.scan(arrayCreationExpr.getInitializers(), p);
        return null;
    }

    @Override
    protected Void visitBinaryOperation(BinaryOperation binaryOpExpr, P p) {
        this.visit(binaryOpExpr.getLeft(), p);
        this.visit(binaryOpExpr.getRight(), p);
        return null;
    }

    @Override
    protected Void visitClassName(ClassName classNameExpr, P p) {
        return null;
    }

    @Override
    protected Void visitFormalParameter(FormalParameter parameterExpr, P p) {
        return null;
    }

    @Override
    protected Void visitFieldAccess(FieldAccess fieldAccessExpr, P p) {
        this.visit(fieldAccessExpr.getReceiver(), p);
        return null;
    }

    @Override
    protected Void visitLocalVariable(LocalVariable localVarExpr, P p) {
        return null;
    }

    @Override
    protected Void visitMethodCall(MethodCall methodCallExpr, P p) {
        this.visit(methodCallExpr.getReceiver(), p);
        this.scan(methodCallExpr.getArguments(), p);
        return null;
    }

    @Override
    protected Void visitThisReference(ThisReference thisExpr, P p) {
        return null;
    }

    @Override
    protected Void visitUnaryOperation(UnaryOperation unaryOpExpr, P p) {
        this.visit(unaryOpExpr.getOperand(), p);
        return null;
    }

    @Override
    protected Void visitUnknown(Unknown unknownExpr, P p) {
        return null;
    }

    @Override
    protected Void visitValueLiteral(ValueLiteral literalExpr, P p) {
        return null;
    }
}

