/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.Refaster;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public enum ImportPolicy {
    IMPORT_TOP_LEVEL{

        @Override
        public JCTree.JCExpression classReference(Inliner inliner, CharSequence topLevelClazz, CharSequence fullyQualifiedClazz) {
            if (Refaster.class.getName().contentEquals(fullyQualifiedClazz)) {
                return inliner.maker().Ident(inliner.asName("Refaster"));
            }
            List<String> allImports = this.getAllImports(inliner);
            Preconditions.checkArgument((topLevelClazz.length() > 0 && fullyQualifiedClazz.length() > 0 ? 1 : 0) != 0, (String)"either topLevelClass (%s) or fullyQualifiedClazz (%s) is null or empty", (Object)topLevelClazz, (Object)fullyQualifiedClazz);
            List topLevelPath = Splitter.on((char)'.').splitToList(topLevelClazz);
            String topClazz = (String)Iterables.getLast((Iterable)topLevelPath);
            List qualifiedPath = Splitter.on((char)'.').splitToList(fullyQualifiedClazz);
            boolean importTopLevelClazz = false;
            boolean conflictTopLevelClazz = false;
            for (String importName : allImports) {
                if (importName.contentEquals(fullyQualifiedClazz)) {
                    return this.makeSelectExpression(inliner, qualifiedPath, qualifiedPath.size() - 1);
                }
                if (importTopLevelClazz |= importName.contentEquals(topLevelClazz)) continue;
                conflictTopLevelClazz |= topClazz.equals(Iterables.getLast((Iterable)Splitter.on((char)'.').split((CharSequence)importName)));
            }
            if (importTopLevelClazz) {
                return this.makeSelectExpression(inliner, qualifiedPath, topLevelPath.size() - 1);
            }
            if (conflictTopLevelClazz) {
                return this.makeSelectExpression(inliner, qualifiedPath, 0);
            }
            String packge = Joiner.on((char)'.').join(topLevelPath.subList(0, topLevelPath.size() - 1));
            Symbol.PackageSymbol currentPackage = inliner.getContext().get(Symbol.PackageSymbol.class);
            if (currentPackage == null || !currentPackage.getQualifiedName().contentEquals(packge)) {
                inliner.addImport(topLevelClazz.toString());
            }
            return this.makeSelectExpression(inliner, qualifiedPath, topLevelPath.size() - 1);
        }

        @Override
        public JCTree.JCExpression staticReference(Inliner inliner, CharSequence topLevelClazz, CharSequence fullyQualifiedClazz, CharSequence member) {
            return inliner.maker().Select(this.classReference(inliner, topLevelClazz, fullyQualifiedClazz), inliner.asName(member));
        }

        private List<String> getAllImports(Inliner inliner) {
            ArrayList<String> allImports = new ArrayList<String>(inliner.getImportsToAdd());
            if (inliner.getContext() != null && inliner.getContext().get(JCTree.JCCompilationUnit.class) != null) {
                for (JCTree.JCImport jcImport : inliner.getContext().get(JCTree.JCCompilationUnit.class).getImports()) {
                    JCTree.JCFieldAccess qualified = (JCTree.JCFieldAccess)jcImport.getQualifiedIdentifier();
                    allImports.add(qualified.toString());
                }
            }
            return allImports;
        }

        private JCTree.JCExpression makeSelectExpression(Inliner inliner, List<String> qualifiedPath, int start) {
            ListIterator<String> selects = qualifiedPath.listIterator(start);
            TreeMaker maker = inliner.maker();
            JCTree.JCExpression select = maker.Ident(inliner.asName((CharSequence)selects.next()));
            while (selects.hasNext()) {
                select = maker.Select(select, inliner.asName((CharSequence)selects.next()));
            }
            return select;
        }
    }
    ,
    IMPORT_CLASS_DIRECTLY{

        @Override
        public JCTree.JCExpression classReference(Inliner inliner, CharSequence topLevelClazz, CharSequence fullyQualifiedClazz) {
            if (Refaster.class.getName().contentEquals(fullyQualifiedClazz)) {
                return inliner.maker().Ident(inliner.asName("Refaster"));
            }
            String packge = topLevelClazz.toString();
            int lastDot = packge.lastIndexOf(46);
            packge = lastDot >= 0 ? packge.substring(0, lastDot) : "";
            Symbol.PackageSymbol currentPackage = inliner.getContext().get(Symbol.PackageSymbol.class);
            if (currentPackage == null || !currentPackage.getQualifiedName().contentEquals(packge) || !topLevelClazz.toString().contentEquals(fullyQualifiedClazz)) {
                inliner.addImport(fullyQualifiedClazz.toString());
            }
            String simpleName = fullyQualifiedClazz.toString();
            simpleName = simpleName.substring(simpleName.lastIndexOf(46) + 1);
            return inliner.maker().Ident(inliner.asName(simpleName));
        }

        @Override
        public JCTree.JCExpression staticReference(Inliner inliner, CharSequence topLevelClazz, CharSequence fullyQualifiedClazz, CharSequence member) {
            if (Refaster.class.getName().contentEquals(topLevelClazz)) {
                return inliner.maker().Select((JCTree.JCExpression)inliner.maker().Ident(inliner.asName("Refaster")), inliner.asName(member));
            }
            return inliner.maker().Select(this.classReference(inliner, topLevelClazz, fullyQualifiedClazz), inliner.asName(member));
        }
    }
    ,
    STATIC_IMPORT_ALWAYS{

        @Override
        public JCTree.JCExpression classReference(Inliner inliner, CharSequence topLevelClazz, CharSequence fullyQualifiedClazz) {
            return IMPORT_TOP_LEVEL.classReference(inliner, topLevelClazz, fullyQualifiedClazz);
        }

        @Override
        public JCTree.JCExpression staticReference(Inliner inliner, CharSequence topLevelClazz, CharSequence fullyQualifiedClazz, CharSequence member) {
            if (Refaster.class.getName().contentEquals(topLevelClazz)) {
                return inliner.maker().Select((JCTree.JCExpression)inliner.maker().Ident(inliner.asName("Refaster")), inliner.asName(member));
            }
            if (member.toString().equals("class")) {
                return IMPORT_TOP_LEVEL.staticReference(inliner, topLevelClazz, fullyQualifiedClazz, member);
            }
            inliner.addStaticImport(fullyQualifiedClazz + "." + member);
            return inliner.maker().Ident(inliner.asName(member));
        }
    };


    public static void bind(Context context, ImportPolicy policy) {
        context.put(ImportPolicy.class, Preconditions.checkNotNull((Object)((Object)policy)));
    }

    public static ImportPolicy instance(Context context) {
        ImportPolicy result = context.get(ImportPolicy.class);
        Preconditions.checkState((result != null ? 1 : 0) != 0, (Object)"No ImportPolicy bound in this context");
        return result;
    }

    public abstract JCTree.JCExpression classReference(Inliner var1, CharSequence var2, CharSequence var3);

    public abstract JCTree.JCExpression staticReference(Inliner var1, CharSequence var2, CharSequence var3, CharSequence var4);
}

