/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.nullness.NullnessFixes;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import javax.lang.model.type.TypeKind;

@BugPattern(name="ReturnMissingNullable", summary="Method returns a definitely null value but is not annotated @Nullable", severity=BugPattern.SeverityLevel.SUGGESTION)
public class ReturnMissingNullable
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private final boolean beingConservative;

    public ReturnMissingNullable(ErrorProneFlags flags) {
        this.beingConservative = flags.getBoolean("ReturnMissingNullable:Conservative").orElse(true);
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState stateForCompilationUnit) {
        if (this.beingConservative && stateForCompilationUnit.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        final ImmutableSet.Builder definitelyNullVarsBuilder = ImmutableSet.builder();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitVariable(VariableTree tree, Void unused) {
                this.doVisitVariable(tree);
                return (Void)super.visitVariable(tree, unused);
            }

            void doVisitVariable(VariableTree tree) {
                Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
                if (!ASTHelpers.isConsideredFinal((Symbol)symbol)) {
                    return;
                }
                ExpressionTree initializer = tree.getInitializer();
                if (initializer == null) {
                    return;
                }
                if (initializer.getKind() != Tree.Kind.NULL_LITERAL) {
                    return;
                }
                definitelyNullVarsBuilder.add((Object)symbol);
            }
        }.scan(tree, null);
        final ImmutableSet definitelyNullVars = definitelyNullVarsBuilder.build();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitReturn(ReturnTree tree, Void unused) {
                this.doVisitReturn(tree);
                return (Void)super.visitReturn(tree, unused);
            }

            void doVisitReturn(ReturnTree returnTree) {
                VisitorState state = stateForCompilationUnit.withPath(this.getCurrentPath());
                ExpressionTree returnExpression = returnTree.getExpression();
                if (returnExpression == null) {
                    return;
                }
                MethodTree methodTree = ASTHelpers.findEnclosingMethod((VisitorState)state);
                if (methodTree == null) {
                    return;
                }
                List<? extends StatementTree> statements = methodTree.getBody().getStatements();
                if (ReturnMissingNullable.this.beingConservative && statements.size() == 1 && Iterables.getOnlyElement(statements) == returnTree && returnExpression.getKind() == Tree.Kind.NULL_LITERAL) {
                    return;
                }
                Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodTree)methodTree);
                Type returnType = method.getReturnType();
                if (ReturnMissingNullable.this.beingConservative && ReturnMissingNullable.isVoid(returnType, state)) {
                    return;
                }
                if (returnType.isPrimitive()) {
                    return;
                }
                if (ReturnMissingNullable.this.beingConservative && state.getTypes().isArray(returnType)) {
                    return;
                }
                if (ReturnMissingNullable.this.beingConservative && returnType.getKind() == TypeKind.TYPEVAR) {
                    return;
                }
                if (NullnessAnnotations.fromAnnotationsOn((Symbol)method).orElse(null) == Nullness.NULLABLE) {
                    return;
                }
                if (ReturnMissingNullable.hasDefinitelyNullBranch(returnExpression, (ImmutableSet<Symbol.VarSymbol>)definitelyNullVars, stateForCompilationUnit)) {
                    state.reportMatch(ReturnMissingNullable.this.describeMatch(returnTree, (Fix)NullnessFixes.makeFix(state.withPath(this.getCurrentPath()), methodTree)));
                }
            }
        }.scan(tree, null);
        return Description.NO_MATCH;
    }

    private static boolean hasDefinitelyNullBranch(ExpressionTree tree, final ImmutableSet<Symbol.VarSymbol> definitelyNullVars, final VisitorState stateForCompilationUnit) {
        return (Boolean)new SimpleTreeVisitor<Boolean, Void>(){

            @Override
            public Boolean visitAssignment(AssignmentTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), unused);
            }

            @Override
            public Boolean visitConditionalExpression(ConditionalExpressionTree tree, Void unused) {
                return (Boolean)this.visit(tree.getTrueExpression(), unused) != false || (Boolean)this.visit(tree.getFalseExpression(), unused) != false;
            }

            @Override
            public Boolean visitParenthesized(ParenthesizedTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), unused);
            }

            @Override
            public Boolean visitTypeCast(TypeCastTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), unused);
            }

            @Override
            protected Boolean defaultAction(Tree tree, Void unused) {
                return ReturnMissingNullable.isVoid(ASTHelpers.getType((Tree)tree), stateForCompilationUnit) || definitelyNullVars.contains((Object)ASTHelpers.getSymbol((Tree)tree));
            }
        }.visit(tree, null);
    }

    private static boolean isVoid(Type type, VisitorState state) {
        return type != null && state.getTypes().isSubtype(type, (Type)Suppliers.JAVA_LANG_VOID_TYPE.get(state));
    }
}

