﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/ScanResourceCriteria.h>
#include <aws/guardduty/model/EbsSnapshotPreservation.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{
  class AWS_GUARDDUTY_API GetMalwareScanSettingsResult
  {
  public:
    GetMalwareScanSettingsResult();
    GetMalwareScanSettingsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    GetMalwareScanSettingsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>Represents the criteria to be used in the filter for scanning resources.</p>
     */
    inline const ScanResourceCriteria& GetScanResourceCriteria() const{ return m_scanResourceCriteria; }

    /**
     * <p>Represents the criteria to be used in the filter for scanning resources.</p>
     */
    inline void SetScanResourceCriteria(const ScanResourceCriteria& value) { m_scanResourceCriteria = value; }

    /**
     * <p>Represents the criteria to be used in the filter for scanning resources.</p>
     */
    inline void SetScanResourceCriteria(ScanResourceCriteria&& value) { m_scanResourceCriteria = std::move(value); }

    /**
     * <p>Represents the criteria to be used in the filter for scanning resources.</p>
     */
    inline GetMalwareScanSettingsResult& WithScanResourceCriteria(const ScanResourceCriteria& value) { SetScanResourceCriteria(value); return *this;}

    /**
     * <p>Represents the criteria to be used in the filter for scanning resources.</p>
     */
    inline GetMalwareScanSettingsResult& WithScanResourceCriteria(ScanResourceCriteria&& value) { SetScanResourceCriteria(std::move(value)); return *this;}


    /**
     * <p>An enum value representing possible snapshot preservation settings.</p>
     */
    inline const EbsSnapshotPreservation& GetEbsSnapshotPreservation() const{ return m_ebsSnapshotPreservation; }

    /**
     * <p>An enum value representing possible snapshot preservation settings.</p>
     */
    inline void SetEbsSnapshotPreservation(const EbsSnapshotPreservation& value) { m_ebsSnapshotPreservation = value; }

    /**
     * <p>An enum value representing possible snapshot preservation settings.</p>
     */
    inline void SetEbsSnapshotPreservation(EbsSnapshotPreservation&& value) { m_ebsSnapshotPreservation = std::move(value); }

    /**
     * <p>An enum value representing possible snapshot preservation settings.</p>
     */
    inline GetMalwareScanSettingsResult& WithEbsSnapshotPreservation(const EbsSnapshotPreservation& value) { SetEbsSnapshotPreservation(value); return *this;}

    /**
     * <p>An enum value representing possible snapshot preservation settings.</p>
     */
    inline GetMalwareScanSettingsResult& WithEbsSnapshotPreservation(EbsSnapshotPreservation&& value) { SetEbsSnapshotPreservation(std::move(value)); return *this;}

  private:

    ScanResourceCriteria m_scanResourceCriteria;

    EbsSnapshotPreservation m_ebsSnapshotPreservation;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
