﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/model/Scan.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{
  class AWS_GUARDDUTY_API DescribeMalwareScansResult
  {
  public:
    DescribeMalwareScansResult();
    DescribeMalwareScansResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    DescribeMalwareScansResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>Contains information about malware scans.</p>
     */
    inline const Aws::Vector<Scan>& GetScans() const{ return m_scans; }

    /**
     * <p>Contains information about malware scans.</p>
     */
    inline void SetScans(const Aws::Vector<Scan>& value) { m_scans = value; }

    /**
     * <p>Contains information about malware scans.</p>
     */
    inline void SetScans(Aws::Vector<Scan>&& value) { m_scans = std::move(value); }

    /**
     * <p>Contains information about malware scans.</p>
     */
    inline DescribeMalwareScansResult& WithScans(const Aws::Vector<Scan>& value) { SetScans(value); return *this;}

    /**
     * <p>Contains information about malware scans.</p>
     */
    inline DescribeMalwareScansResult& WithScans(Aws::Vector<Scan>&& value) { SetScans(std::move(value)); return *this;}

    /**
     * <p>Contains information about malware scans.</p>
     */
    inline DescribeMalwareScansResult& AddScans(const Scan& value) { m_scans.push_back(value); return *this; }

    /**
     * <p>Contains information about malware scans.</p>
     */
    inline DescribeMalwareScansResult& AddScans(Scan&& value) { m_scans.push_back(std::move(value)); return *this; }


    /**
     * <p>The pagination parameter to be used on the next list operation to retrieve
     * more items.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p>The pagination parameter to be used on the next list operation to retrieve
     * more items.</p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }

    /**
     * <p>The pagination parameter to be used on the next list operation to retrieve
     * more items.</p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }

    /**
     * <p>The pagination parameter to be used on the next list operation to retrieve
     * more items.</p>
     */
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }

    /**
     * <p>The pagination parameter to be used on the next list operation to retrieve
     * more items.</p>
     */
    inline DescribeMalwareScansResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p>The pagination parameter to be used on the next list operation to retrieve
     * more items.</p>
     */
    inline DescribeMalwareScansResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p>The pagination parameter to be used on the next list operation to retrieve
     * more items.</p>
     */
    inline DescribeMalwareScansResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}

  private:

    Aws::Vector<Scan> m_scans;

    Aws::String m_nextToken;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
