/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.a11y.brlapi.ExitException;
import org.a11y.brlapi.KeywordMap;
import org.a11y.brlapi.Program;
import org.a11y.brlapi.ProgramException;
import org.a11y.brlapi.Strings;
import org.a11y.brlapi.SyntaxException;
import org.a11y.brlapi.clients.ApiErrorClient;
import org.a11y.brlapi.clients.ApiExceptionClient;
import org.a11y.brlapi.clients.BoundCommandsClient;
import org.a11y.brlapi.clients.ComputerBrailleClient;
import org.a11y.brlapi.clients.DriverKeysClient;
import org.a11y.brlapi.clients.EchoClient;
import org.a11y.brlapi.clients.GetDriverClient;
import org.a11y.brlapi.clients.GetModelClient;
import org.a11y.brlapi.clients.GetSizeClient;
import org.a11y.brlapi.clients.ListParametersClient;
import org.a11y.brlapi.clients.PauseClient;
import org.a11y.brlapi.clients.SetParameterClient;
import org.a11y.brlapi.clients.WriteArgumentsClient;
import org.a11y.brlapi.clients.WriteDotsClient;
import org.a11y.brlapi.clients.WriteTextClient;
import org.a11y.brlapi.programs.VersionProgram;

public class MainProgram
extends Program {
    private static final KeywordMap<Class<? extends Program>> knownPrograms = new KeywordMap();
    private String programName = null;
    private Class<? extends Program> programType = null;
    private String[] programArguments = null;

    private static void addProgram(Class<? extends Program> clazz) {
        String string = clazz.getSimpleName();
        string = MainProgram.isClient(clazz) ? Strings.replaceAll(string, "Client$", "") : Strings.replaceAll(string, "Program$", "");
        knownPrograms.put(MainProgram.toOperandName(Strings.wordify(string)), clazz);
    }

    public MainProgram(String ... stringArray) {
        super(stringArray);
        this.addRequiredParameters("program/client");
        this.addRepeatingParameter("argument");
    }

    @Override
    protected final void extendUsageSummary(StringBuilder stringBuilder) {
        super.extendUsageSummary(stringBuilder);
        if (knownPrograms.isEmpty()) {
            stringBuilder.append("\nNo programs or clients have been defined.");
        } else {
            stringBuilder.append("\nThese programs and clients have been defined:");
            for (String string : knownPrograms.getKeywords()) {
                stringBuilder.append("\n  ").append(string);
            }
        }
    }

    @Override
    protected final void processParameters(String[] stringArray) throws SyntaxException {
        int n = stringArray.length;
        if (n == 0) {
            throw new SyntaxException("missing program/client name", new Object[0]);
        }
        this.programName = stringArray[0];
        this.programType = knownPrograms.get(this.programName);
        if (this.programType == null) {
            throw new SyntaxException("unknown program/client: %s", this.programName);
        }
        this.programName = MainProgram.getProgramName(this.programType);
        this.programArguments = new String[--n];
        System.arraycopy(stringArray, 1, this.programArguments, 0, n);
    }

    @Override
    protected final void runProgram() throws ProgramException {
        String string = MainProgram.isClient(this.programType) ? "client" : "program";
        Program program = null;
        try {
            Constructor<? extends Program> constructor = this.programType.getConstructor(this.programArguments.getClass());
            program = constructor.newInstance(new Object[]{this.programArguments});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ProgramException("%s constructor not found: %s", string, this.programName);
        }
        catch (InstantiationException instantiationException) {
            throw new ProgramException("%s instantiation failed: %s: %s", string, this.programName, instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ProgramException("%s object access denied: %s: %s", string, this.programName, illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            Object object = String.format("%s construction failed: %s: %s", string, this.programName, throwable.getClass().getSimpleName());
            String string2 = throwable.getMessage();
            if (string2 != null) {
                object = (String)object + ": " + string2;
            }
            throw new ProgramException((String)object, new Object[0]);
        }
        program.run();
    }

    public static void main(String ... stringArray) {
        try {
            new MainProgram(stringArray).run();
        }
        catch (ExitException exitException) {
            System.exit(exitException.getExitCode());
        }
    }

    static {
        MainProgram.addProgram(ApiErrorClient.class);
        MainProgram.addProgram(ApiExceptionClient.class);
        MainProgram.addProgram(BoundCommandsClient.class);
        MainProgram.addProgram(ComputerBrailleClient.class);
        MainProgram.addProgram(DriverKeysClient.class);
        MainProgram.addProgram(EchoClient.class);
        MainProgram.addProgram(GetDriverClient.class);
        MainProgram.addProgram(GetModelClient.class);
        MainProgram.addProgram(GetSizeClient.class);
        MainProgram.addProgram(ListParametersClient.class);
        MainProgram.addProgram(PauseClient.class);
        MainProgram.addProgram(SetParameterClient.class);
        MainProgram.addProgram(VersionProgram.class);
        MainProgram.addProgram(WriteArgumentsClient.class);
        MainProgram.addProgram(WriteDotsClient.class);
        MainProgram.addProgram(WriteTextClient.class);
    }
}

