function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import AddButton from "../AddButton";
import IconButton from "../IconButton";
import React, { Component } from "react";
import includes from "core-js-pure/es/array/includes";
import * as types from "../../types";
import { getWidget, getDefaultFormState, getUiOptions, isMultiSelect, isFilesArray, isFixedItems, allowAdditionalItems, isCustomWidget, optionsList, retrieveSchema, toIdSchema, getDefaultRegistry } from "../../utils";
import { nanoid } from "nanoid";

function ArrayFieldTitle(_ref) {
  var TitleField = _ref.TitleField,
      idSchema = _ref.idSchema,
      title = _ref.title,
      required = _ref.required;

  if (!title) {
    return null;
  }

  var id = "".concat(idSchema.$id, "__title");
  return React.createElement(TitleField, {
    id: id,
    title: title,
    required: required
  });
}

function ArrayFieldDescription(_ref2) {
  var DescriptionField = _ref2.DescriptionField,
      idSchema = _ref2.idSchema,
      description = _ref2.description;

  if (!description) {
    return null;
  }

  var id = "".concat(idSchema.$id, "__description");
  return React.createElement(DescriptionField, {
    id: id,
    description: description
  });
} // Used in the two templates


function DefaultArrayItem(props) {
  var btnStyle = {
    flex: 1,
    paddingLeft: 6,
    paddingRight: 6,
    fontWeight: "bold"
  };
  return React.createElement("div", {
    key: props.key,
    className: props.className
  }, React.createElement("div", {
    className: props.hasToolbar ? "col-xs-9" : "col-xs-12"
  }, props.children), props.hasToolbar && React.createElement("div", {
    className: "col-xs-3 array-item-toolbox"
  }, React.createElement("div", {
    className: "btn-group",
    style: {
      display: "flex",
      justifyContent: "space-around"
    }
  }, (props.hasMoveUp || props.hasMoveDown) && React.createElement(IconButton, {
    icon: "arrow-up",
    "aria-label": "Move up",
    className: "array-item-move-up",
    tabIndex: "-1",
    style: btnStyle,
    disabled: props.disabled || props.readonly || !props.hasMoveUp,
    onClick: props.onReorderClick(props.index, props.index - 1)
  }), (props.hasMoveUp || props.hasMoveDown) && React.createElement(IconButton, {
    icon: "arrow-down",
    className: "array-item-move-down",
    "aria-label": "Move down",
    tabIndex: "-1",
    style: btnStyle,
    disabled: props.disabled || props.readonly || !props.hasMoveDown,
    onClick: props.onReorderClick(props.index, props.index + 1)
  }), props.hasRemove && React.createElement(IconButton, {
    type: "danger",
    icon: "remove",
    "aria-label": "Remove",
    className: "array-item-remove",
    tabIndex: "-1",
    style: btnStyle,
    disabled: props.disabled || props.readonly,
    onClick: props.onDropIndexClick(props.index)
  }))));
}

function DefaultFixedArrayFieldTemplate(props) {
  return React.createElement("fieldset", {
    className: props.className,
    id: props.idSchema.$id
  }, React.createElement(ArrayFieldTitle, {
    key: "array-field-title-".concat(props.idSchema.$id),
    TitleField: props.TitleField,
    idSchema: props.idSchema,
    title: props.uiSchema["ui:title"] || props.title,
    required: props.required
  }), (props.uiSchema["ui:description"] || props.schema.description) && React.createElement("div", {
    className: "field-description",
    key: "field-description-".concat(props.idSchema.$id)
  }, props.uiSchema["ui:description"] || props.schema.description), React.createElement("div", {
    className: "row array-item-list",
    key: "array-item-list-".concat(props.idSchema.$id)
  }, props.items && props.items.map(DefaultArrayItem)), props.canAdd && React.createElement(AddButton, {
    className: "array-item-add",
    onClick: props.onAddClick,
    disabled: props.disabled || props.readonly
  }));
}

function DefaultNormalArrayFieldTemplate(props) {
  return React.createElement("fieldset", {
    className: props.className,
    id: props.idSchema.$id
  }, React.createElement(ArrayFieldTitle, {
    key: "array-field-title-".concat(props.idSchema.$id),
    TitleField: props.TitleField,
    idSchema: props.idSchema,
    title: props.uiSchema["ui:title"] || props.title,
    required: props.required
  }), (props.uiSchema["ui:description"] || props.schema.description) && React.createElement(ArrayFieldDescription, {
    key: "array-field-description-".concat(props.idSchema.$id),
    DescriptionField: props.DescriptionField,
    idSchema: props.idSchema,
    description: props.uiSchema["ui:description"] || props.schema.description
  }), React.createElement("div", {
    className: "row array-item-list",
    key: "array-item-list-".concat(props.idSchema.$id)
  }, props.items && props.items.map(function (p) {
    return DefaultArrayItem(p);
  })), props.canAdd && React.createElement(AddButton, {
    className: "array-item-add",
    onClick: props.onAddClick,
    disabled: props.disabled || props.readonly
  }));
}

function generateRowId() {
  return nanoid();
}

function generateKeyedFormData(formData) {
  return !Array.isArray(formData) ? [] : formData.map(function (item) {
    return {
      key: generateRowId(),
      item: item
    };
  });
}

function keyedToPlainFormData(keyedFormData) {
  return keyedFormData.map(function (keyedItem) {
    return keyedItem.item;
  });
}

var ArrayField =
/*#__PURE__*/
function (_Component) {
  _inherits(ArrayField, _Component);

  function ArrayField(props) {
    var _this;

    _classCallCheck(this, ArrayField);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ArrayField).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "_getNewFormDataRow", function () {
      var _this$props = _this.props,
          schema = _this$props.schema,
          _this$props$registry = _this$props.registry,
          registry = _this$props$registry === void 0 ? getDefaultRegistry() : _this$props$registry;
      var rootSchema = registry.rootSchema;
      var itemSchema = schema.items;

      if (isFixedItems(schema) && allowAdditionalItems(schema)) {
        itemSchema = schema.additionalItems;
      }

      return getDefaultFormState(itemSchema, undefined, rootSchema);
    });

    _defineProperty(_assertThisInitialized(_this), "onAddClick", function (event) {
      if (event) {
        event.preventDefault();
      }

      var onChange = _this.props.onChange;
      var newKeyedFormDataRow = {
        key: generateRowId(),
        item: _this._getNewFormDataRow()
      };
      var newKeyedFormData = [].concat(_toConsumableArray(_this.state.keyedFormData), [newKeyedFormDataRow]);

      _this.setState({
        keyedFormData: newKeyedFormData,
        updatedKeyedFormData: true
      }, function () {
        return onChange(keyedToPlainFormData(newKeyedFormData));
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onAddIndexClick", function (index) {
      return function (event) {
        if (event) {
          event.preventDefault();
        }

        var onChange = _this.props.onChange;
        var newKeyedFormDataRow = {
          key: generateRowId(),
          item: _this._getNewFormDataRow()
        };

        var newKeyedFormData = _toConsumableArray(_this.state.keyedFormData);

        newKeyedFormData.splice(index, 0, newKeyedFormDataRow);

        _this.setState({
          keyedFormData: newKeyedFormData,
          updatedKeyedFormData: true
        }, function () {
          return onChange(keyedToPlainFormData(newKeyedFormData));
        });
      };
    });

    _defineProperty(_assertThisInitialized(_this), "onDropIndexClick", function (index) {
      return function (event) {
        if (event) {
          event.preventDefault();
        }

        var onChange = _this.props.onChange;
        var keyedFormData = _this.state.keyedFormData; // refs #195: revalidate to ensure properly reindexing errors

        var newErrorSchema;

        if (_this.props.errorSchema) {
          newErrorSchema = {};
          var errorSchema = _this.props.errorSchema;

          for (var i in errorSchema) {
            i = parseInt(i);

            if (i < index) {
              newErrorSchema[i] = errorSchema[i];
            } else if (i > index) {
              newErrorSchema[i - 1] = errorSchema[i];
            }
          }
        }

        var newKeyedFormData = keyedFormData.filter(function (_, i) {
          return i !== index;
        });

        _this.setState({
          keyedFormData: newKeyedFormData,
          updatedKeyedFormData: true
        }, function () {
          return onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema);
        });
      };
    });

    _defineProperty(_assertThisInitialized(_this), "onReorderClick", function (index, newIndex) {
      return function (event) {
        if (event) {
          event.preventDefault();
          event.target.blur();
        }

        var onChange = _this.props.onChange;
        var newErrorSchema;

        if (_this.props.errorSchema) {
          newErrorSchema = {};
          var errorSchema = _this.props.errorSchema;

          for (var i in errorSchema) {
            if (i == index) {
              newErrorSchema[newIndex] = errorSchema[index];
            } else if (i == newIndex) {
              newErrorSchema[index] = errorSchema[newIndex];
            } else {
              newErrorSchema[i] = errorSchema[i];
            }
          }
        }

        var keyedFormData = _this.state.keyedFormData;

        function reOrderArray() {
          // Copy item
          var _newKeyedFormData = keyedFormData.slice(); // Moves item from index to newIndex


          _newKeyedFormData.splice(index, 1);

          _newKeyedFormData.splice(newIndex, 0, keyedFormData[index]);

          return _newKeyedFormData;
        }

        var newKeyedFormData = reOrderArray();

        _this.setState({
          keyedFormData: newKeyedFormData
        }, function () {
          return onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema);
        });
      };
    });

    _defineProperty(_assertThisInitialized(_this), "onChangeForIndex", function (index) {
      return function (value, errorSchema) {
        var _this$props2 = _this.props,
            formData = _this$props2.formData,
            onChange = _this$props2.onChange;
        var newFormData = formData.map(function (item, i) {
          // We need to treat undefined items as nulls to have validation.
          // See https://github.com/tdegrunt/jsonschema/issues/206
          var jsonValue = typeof value === "undefined" ? null : value;
          return index === i ? jsonValue : item;
        });
        onChange(newFormData, errorSchema && _this.props.errorSchema && _objectSpread({}, _this.props.errorSchema, _defineProperty({}, index, errorSchema)));
      };
    });

    _defineProperty(_assertThisInitialized(_this), "onSelectChange", function (value) {
      _this.props.onChange(value);
    });

    var _formData = props.formData;

    var _keyedFormData = generateKeyedFormData(_formData);

    _this.state = {
      keyedFormData: _keyedFormData,
      updatedKeyedFormData: false
    };
    return _this;
  }

  _createClass(ArrayField, [{
    key: "isItemRequired",
    value: function isItemRequired(itemSchema) {
      if (Array.isArray(itemSchema.type)) {
        // While we don't yet support composite/nullable jsonschema types, it's
        // future-proof to check for requirement against these.
        return !includes(itemSchema.type, "null");
      } // All non-null array item types are inherently required by design


      return itemSchema.type !== "null";
    }
  }, {
    key: "canAddItem",
    value: function canAddItem(formItems) {
      var _this$props3 = this.props,
          schema = _this$props3.schema,
          uiSchema = _this$props3.uiSchema;

      var _getUiOptions = getUiOptions(uiSchema),
          addable = _getUiOptions.addable;

      if (addable !== false) {
        // if ui:options.addable was not explicitly set to false, we can add
        // another item if we have not exceeded maxItems yet
        if (schema.maxItems !== undefined) {
          addable = formItems.length < schema.maxItems;
        } else {
          addable = true;
        }
      }

      return addable;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props4 = this.props,
          schema = _this$props4.schema,
          uiSchema = _this$props4.uiSchema,
          idSchema = _this$props4.idSchema,
          _this$props4$registry = _this$props4.registry,
          registry = _this$props4$registry === void 0 ? getDefaultRegistry() : _this$props4$registry;
      var rootSchema = registry.rootSchema;

      if (!schema.hasOwnProperty("items")) {
        var fields = registry.fields;
        var UnsupportedField = fields.UnsupportedField;
        return React.createElement(UnsupportedField, {
          schema: schema,
          idSchema: idSchema,
          reason: "Missing items definition"
        });
      }

      if (isMultiSelect(schema, rootSchema)) {
        // If array has enum or uniqueItems set to true, call renderMultiSelect() to render the default multiselect widget or a custom widget, if specified.
        return this.renderMultiSelect();
      }

      if (isCustomWidget(uiSchema)) {
        return this.renderCustomWidget();
      }

      if (isFixedItems(schema)) {
        return this.renderFixedArray();
      }

      if (isFilesArray(schema, uiSchema, rootSchema)) {
        return this.renderFiles();
      }

      return this.renderNormalArray();
    }
  }, {
    key: "renderNormalArray",
    value: function renderNormalArray() {
      var _this2 = this;

      var _this$props5 = this.props,
          schema = _this$props5.schema,
          uiSchema = _this$props5.uiSchema,
          errorSchema = _this$props5.errorSchema,
          idSchema = _this$props5.idSchema,
          name = _this$props5.name,
          required = _this$props5.required,
          disabled = _this$props5.disabled,
          readonly = _this$props5.readonly,
          hideError = _this$props5.hideError,
          autofocus = _this$props5.autofocus,
          _this$props5$registry = _this$props5.registry,
          registry = _this$props5$registry === void 0 ? getDefaultRegistry() : _this$props5$registry,
          onBlur = _this$props5.onBlur,
          onFocus = _this$props5.onFocus,
          idPrefix = _this$props5.idPrefix,
          _this$props5$idSepara = _this$props5.idSeparator,
          idSeparator = _this$props5$idSepara === void 0 ? "_" : _this$props5$idSepara,
          rawErrors = _this$props5.rawErrors;
      var title = schema.title === undefined ? name : schema.title;
      var ArrayFieldTemplate = registry.ArrayFieldTemplate,
          rootSchema = registry.rootSchema,
          fields = registry.fields,
          formContext = registry.formContext;
      var TitleField = fields.TitleField,
          DescriptionField = fields.DescriptionField;
      var itemsSchema = retrieveSchema(schema.items, rootSchema);
      var formData = keyedToPlainFormData(this.state.keyedFormData);
      var arrayProps = {
        canAdd: this.canAddItem(formData),
        items: this.state.keyedFormData.map(function (keyedItem, index) {
          var key = keyedItem.key,
              item = keyedItem.item;
          var itemSchema = retrieveSchema(schema.items, rootSchema, item);
          var itemErrorSchema = errorSchema ? errorSchema[index] : undefined;
          var itemIdPrefix = idSchema.$id + idSeparator + index;
          var itemIdSchema = toIdSchema(itemSchema, itemIdPrefix, rootSchema, item, idPrefix, idSeparator);
          return _this2.renderArrayFieldItem({
            key: key,
            index: index,
            canMoveUp: index > 0,
            canMoveDown: index < formData.length - 1,
            itemSchema: itemSchema,
            itemIdSchema: itemIdSchema,
            itemErrorSchema: itemErrorSchema,
            itemData: item,
            itemUiSchema: uiSchema.items,
            autofocus: autofocus && index === 0,
            onBlur: onBlur,
            onFocus: onFocus
          });
        }),
        className: "field field-array field-array-of-".concat(itemsSchema.type),
        DescriptionField: DescriptionField,
        disabled: disabled,
        idSchema: idSchema,
        uiSchema: uiSchema,
        onAddClick: this.onAddClick,
        readonly: readonly,
        hideError: hideError,
        required: required,
        schema: schema,
        title: title,
        TitleField: TitleField,
        formContext: formContext,
        formData: formData,
        rawErrors: rawErrors,
        registry: registry
      }; // Check if a custom render function was passed in

      var Component = uiSchema["ui:ArrayFieldTemplate"] || ArrayFieldTemplate || DefaultNormalArrayFieldTemplate;
      return React.createElement(Component, arrayProps);
    }
  }, {
    key: "renderCustomWidget",
    value: function renderCustomWidget() {
      var _this$props6 = this.props,
          schema = _this$props6.schema,
          idSchema = _this$props6.idSchema,
          uiSchema = _this$props6.uiSchema,
          disabled = _this$props6.disabled,
          readonly = _this$props6.readonly,
          hideError = _this$props6.hideError,
          required = _this$props6.required,
          placeholder = _this$props6.placeholder,
          autofocus = _this$props6.autofocus,
          onBlur = _this$props6.onBlur,
          onFocus = _this$props6.onFocus,
          items = _this$props6.formData,
          _this$props6$registry = _this$props6.registry,
          registry = _this$props6$registry === void 0 ? getDefaultRegistry() : _this$props6$registry,
          rawErrors = _this$props6.rawErrors,
          name = _this$props6.name;
      var widgets = registry.widgets,
          formContext = registry.formContext;
      var title = schema.title || name;

      var _getUiOptions2 = _objectSpread({}, getUiOptions(uiSchema)),
          widget = _getUiOptions2.widget,
          options = _objectWithoutProperties(_getUiOptions2, ["widget"]);

      var Widget = getWidget(schema, widget, widgets);
      return React.createElement(Widget, {
        id: idSchema && idSchema.$id,
        multiple: true,
        onChange: this.onSelectChange,
        onBlur: onBlur,
        onFocus: onFocus,
        options: options,
        schema: schema,
        registry: registry,
        value: items,
        disabled: disabled,
        readonly: readonly,
        hideError: hideError,
        required: required,
        label: title,
        placeholder: placeholder,
        formContext: formContext,
        autofocus: autofocus,
        rawErrors: rawErrors
      });
    }
  }, {
    key: "renderMultiSelect",
    value: function renderMultiSelect() {
      var _this$props7 = this.props,
          schema = _this$props7.schema,
          idSchema = _this$props7.idSchema,
          uiSchema = _this$props7.uiSchema,
          formData = _this$props7.formData,
          disabled = _this$props7.disabled,
          readonly = _this$props7.readonly,
          required = _this$props7.required,
          placeholder = _this$props7.placeholder,
          autofocus = _this$props7.autofocus,
          onBlur = _this$props7.onBlur,
          onFocus = _this$props7.onFocus,
          _this$props7$registry = _this$props7.registry,
          registry = _this$props7$registry === void 0 ? getDefaultRegistry() : _this$props7$registry,
          rawErrors = _this$props7.rawErrors,
          name = _this$props7.name;
      var items = this.props.formData;
      var widgets = registry.widgets,
          rootSchema = registry.rootSchema,
          formContext = registry.formContext;
      var itemsSchema = retrieveSchema(schema.items, rootSchema, formData);
      var title = schema.title || name;
      var enumOptions = optionsList(itemsSchema);

      var _getUiOptions$enumOpt = _objectSpread({}, getUiOptions(uiSchema), {
        enumOptions: enumOptions
      }),
          _getUiOptions$enumOpt2 = _getUiOptions$enumOpt.widget,
          widget = _getUiOptions$enumOpt2 === void 0 ? "select" : _getUiOptions$enumOpt2,
          options = _objectWithoutProperties(_getUiOptions$enumOpt, ["widget"]);

      var Widget = getWidget(schema, widget, widgets);
      return React.createElement(Widget, {
        id: idSchema && idSchema.$id,
        multiple: true,
        onChange: this.onSelectChange,
        onBlur: onBlur,
        onFocus: onFocus,
        options: options,
        schema: schema,
        registry: registry,
        value: items,
        disabled: disabled,
        readonly: readonly,
        required: required,
        label: title,
        placeholder: placeholder,
        formContext: formContext,
        autofocus: autofocus,
        rawErrors: rawErrors
      });
    }
  }, {
    key: "renderFiles",
    value: function renderFiles() {
      var _this$props8 = this.props,
          schema = _this$props8.schema,
          uiSchema = _this$props8.uiSchema,
          idSchema = _this$props8.idSchema,
          name = _this$props8.name,
          disabled = _this$props8.disabled,
          readonly = _this$props8.readonly,
          autofocus = _this$props8.autofocus,
          onBlur = _this$props8.onBlur,
          onFocus = _this$props8.onFocus,
          _this$props8$registry = _this$props8.registry,
          registry = _this$props8$registry === void 0 ? getDefaultRegistry() : _this$props8$registry,
          rawErrors = _this$props8.rawErrors;
      var title = schema.title || name;
      var items = this.props.formData;
      var widgets = registry.widgets,
          formContext = registry.formContext;

      var _getUiOptions3 = getUiOptions(uiSchema),
          _getUiOptions3$widget = _getUiOptions3.widget,
          widget = _getUiOptions3$widget === void 0 ? "files" : _getUiOptions3$widget,
          options = _objectWithoutProperties(_getUiOptions3, ["widget"]);

      var Widget = getWidget(schema, widget, widgets);
      return React.createElement(Widget, {
        options: options,
        id: idSchema && idSchema.$id,
        multiple: true,
        onChange: this.onSelectChange,
        onBlur: onBlur,
        onFocus: onFocus,
        schema: schema,
        title: title,
        value: items,
        disabled: disabled,
        readonly: readonly,
        formContext: formContext,
        autofocus: autofocus,
        rawErrors: rawErrors
      });
    }
  }, {
    key: "renderFixedArray",
    value: function renderFixedArray() {
      var _this3 = this;

      var _this$props9 = this.props,
          schema = _this$props9.schema,
          uiSchema = _this$props9.uiSchema,
          formData = _this$props9.formData,
          errorSchema = _this$props9.errorSchema,
          idPrefix = _this$props9.idPrefix,
          _this$props9$idSepara = _this$props9.idSeparator,
          idSeparator = _this$props9$idSepara === void 0 ? "_" : _this$props9$idSepara,
          idSchema = _this$props9.idSchema,
          name = _this$props9.name,
          required = _this$props9.required,
          disabled = _this$props9.disabled,
          readonly = _this$props9.readonly,
          autofocus = _this$props9.autofocus,
          _this$props9$registry = _this$props9.registry,
          registry = _this$props9$registry === void 0 ? getDefaultRegistry() : _this$props9$registry,
          onBlur = _this$props9.onBlur,
          onFocus = _this$props9.onFocus,
          rawErrors = _this$props9.rawErrors;
      var title = schema.title || name;
      var items = this.props.formData;
      var ArrayFieldTemplate = registry.ArrayFieldTemplate,
          rootSchema = registry.rootSchema,
          fields = registry.fields,
          formContext = registry.formContext;
      var TitleField = fields.TitleField;
      var itemSchemas = schema.items.map(function (item, index) {
        return retrieveSchema(item, rootSchema, formData[index]);
      });
      var additionalSchema = allowAdditionalItems(schema) ? retrieveSchema(schema.additionalItems, rootSchema, formData) : null;

      if (!items || items.length < itemSchemas.length) {
        // to make sure at least all fixed items are generated
        items = items || [];
        items = items.concat(new Array(itemSchemas.length - items.length));
      } // These are the props passed into the render function


      var arrayProps = {
        canAdd: this.canAddItem(items) && additionalSchema,
        className: "field field-array field-array-fixed-items",
        disabled: disabled,
        idSchema: idSchema,
        formData: formData,
        items: this.state.keyedFormData.map(function (keyedItem, index) {
          var key = keyedItem.key,
              item = keyedItem.item;
          var additional = index >= itemSchemas.length;
          var itemSchema = additional ? retrieveSchema(schema.additionalItems, rootSchema, item) : itemSchemas[index];
          var itemIdPrefix = idSchema.$id + idSeparator + index;
          var itemIdSchema = toIdSchema(itemSchema, itemIdPrefix, rootSchema, item, idPrefix, idSeparator);
          var itemUiSchema = additional ? uiSchema.additionalItems || {} : Array.isArray(uiSchema.items) ? uiSchema.items[index] : uiSchema.items || {};
          var itemErrorSchema = errorSchema ? errorSchema[index] : undefined;
          return _this3.renderArrayFieldItem({
            key: key,
            index: index,
            canRemove: additional,
            canMoveUp: index >= itemSchemas.length + 1,
            canMoveDown: additional && index < items.length - 1,
            itemSchema: itemSchema,
            itemData: item,
            itemUiSchema: itemUiSchema,
            itemIdSchema: itemIdSchema,
            itemErrorSchema: itemErrorSchema,
            autofocus: autofocus && index === 0,
            onBlur: onBlur,
            onFocus: onFocus
          });
        }),
        onAddClick: this.onAddClick,
        readonly: readonly,
        required: required,
        schema: schema,
        uiSchema: uiSchema,
        title: title,
        TitleField: TitleField,
        formContext: formContext,
        rawErrors: rawErrors
      }; // Check if a custom template template was passed in

      var Template = uiSchema["ui:ArrayFieldTemplate"] || ArrayFieldTemplate || DefaultFixedArrayFieldTemplate;
      return React.createElement(Template, arrayProps);
    }
  }, {
    key: "renderArrayFieldItem",
    value: function renderArrayFieldItem(props) {
      var key = props.key,
          index = props.index,
          _props$canRemove = props.canRemove,
          canRemove = _props$canRemove === void 0 ? true : _props$canRemove,
          _props$canMoveUp = props.canMoveUp,
          canMoveUp = _props$canMoveUp === void 0 ? true : _props$canMoveUp,
          _props$canMoveDown = props.canMoveDown,
          canMoveDown = _props$canMoveDown === void 0 ? true : _props$canMoveDown,
          itemSchema = props.itemSchema,
          itemData = props.itemData,
          itemUiSchema = props.itemUiSchema,
          itemIdSchema = props.itemIdSchema,
          itemErrorSchema = props.itemErrorSchema,
          autofocus = props.autofocus,
          onBlur = props.onBlur,
          onFocus = props.onFocus,
          rawErrors = props.rawErrors;
      var _this$props10 = this.props,
          disabled = _this$props10.disabled,
          readonly = _this$props10.readonly,
          uiSchema = _this$props10.uiSchema,
          _this$props10$registr = _this$props10.registry,
          registry = _this$props10$registr === void 0 ? getDefaultRegistry() : _this$props10$registr;
      var SchemaField = registry.fields.SchemaField;

      var _getUiOptions4 = getUiOptions(uiSchema),
          _getUiOptions4$ordera = _getUiOptions4.orderable,
          orderable = _getUiOptions4$ordera === void 0 ? true : _getUiOptions4$ordera,
          _getUiOptions4$remova = _getUiOptions4.removable,
          removable = _getUiOptions4$remova === void 0 ? true : _getUiOptions4$remova;

      var has = {
        moveUp: orderable && canMoveUp,
        moveDown: orderable && canMoveDown,
        remove: removable && canRemove
      };
      has.toolbar = Object.keys(has).some(function (key) {
        return has[key];
      });
      return {
        children: React.createElement(SchemaField, {
          index: index,
          schema: itemSchema,
          uiSchema: itemUiSchema,
          formData: itemData,
          errorSchema: itemErrorSchema,
          idPrefix: this.props.idPrefix,
          idSeparator: this.props.idSeparator,
          idSchema: itemIdSchema,
          required: this.isItemRequired(itemSchema),
          onChange: this.onChangeForIndex(index),
          onBlur: onBlur,
          onFocus: onFocus,
          registry: this.props.registry,
          disabled: this.props.disabled,
          readonly: this.props.readonly,
          hideError: this.props.hideError,
          autofocus: autofocus,
          rawErrors: rawErrors
        }),
        className: "array-item",
        disabled: disabled,
        hasToolbar: has.toolbar,
        hasMoveUp: has.moveUp,
        hasMoveDown: has.moveDown,
        hasRemove: has.remove,
        index: index,
        key: key,
        onAddIndexClick: this.onAddIndexClick,
        onDropIndexClick: this.onDropIndexClick,
        onReorderClick: this.onReorderClick,
        readonly: readonly
      };
    }
  }, {
    key: "itemTitle",
    get: function get() {
      var schema = this.props.schema;
      return schema.items.title || schema.items.description || "Item";
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      // Don't call getDerivedStateFromProps if keyed formdata was just updated.
      if (prevState.updatedKeyedFormData) {
        return {
          updatedKeyedFormData: false
        };
      }

      var nextFormData = nextProps.formData || [];
      var previousKeyedFormData = prevState.keyedFormData || [];
      var newKeyedFormData = nextFormData.length === previousKeyedFormData.length ? previousKeyedFormData.map(function (previousKeyedFormDatum, index) {
        return {
          key: previousKeyedFormDatum.key,
          item: nextFormData[index]
        };
      }) : generateKeyedFormData(nextFormData);
      return {
        keyedFormData: newKeyedFormData
      };
    }
  }]);

  return ArrayField;
}(Component);

_defineProperty(ArrayField, "defaultProps", {
  uiSchema: {},
  formData: [],
  idSchema: {},
  required: false,
  disabled: false,
  readonly: false,
  autofocus: false
});

if (process.env.NODE_ENV !== "production") {
  ArrayField.propTypes = types.fieldProps;
}

export default ArrayField;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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