/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseListContent","./TableContentRenderer","sap/ui/integration/library","sap/m/Table","sap/m/Column","sap/m/ColumnListItem","sap/m/Text","sap/m/Link","sap/m/ProgressIndicator","sap/m/ObjectIdentifier","sap/m/ObjectStatus","sap/m/Avatar","sap/ui/core/library","sap/m/library","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/BindingHelper"],function(B,T,l,R,C,a,b,L,P,O,c,A,d,m,e,f){"use strict";var g=m.AvatarSize;var V=d.VerticalAlign;var h=m.ListSeparators;var i=m.ListType;var k=l.AreaType;var n=B.extend("sap.ui.integration.cards.TableContent",{renderer:T});n.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null;}};n.prototype._getTable=function(){if(this._bIsBeingDestroyed){return null;}var t=this.getAggregation("_content");if(!t){t=new R({id:this.getId()+"-Table",showSeparators:h.None});this.setAggregation("_content",t);}return t;};n.prototype.setConfiguration=function(o){B.prototype.setConfiguration.apply(this,arguments);if(!o){return this;}if(o.rows&&o.columns){this._setStaticColumns(o.rows,o.columns);return this;}if(o.row&&o.row.columns){this._setColumns(o.row);}return this;};n.prototype.onDataChanged=function(){this._checkHiddenNavigationItems(this.getConfiguration().row);};n.prototype._setColumns=function(r){var j=[],t=this._getTable(),o=r.columns;o.forEach(function(q){t.addColumn(new C({header:new b({text:q.title}),width:q.width,hAlign:q.hAlign,visible:q.visible}));j.push(this._createCell(q));}.bind(this));this._oItemTemplate=new a({cells:j,vAlign:V.Middle});this._oActions.setAreaType(k.ContentItem);this._oActions.attach(r,this);var p={template:this._oItemTemplate};this._filterHiddenNavigationItems(r,p);this._bindAggregation("items",t,p);};n.prototype._setStaticColumns=function(r,o){var t=this._getTable();o.forEach(function(j){t.addColumn(new C({header:new b({text:j.title}),width:j.width,hAlign:j.hAlign}));});r.forEach(function(p){var I=new a({vAlign:V.Middle});if(p.cells&&Array.isArray(p.cells)){for(var j=0;j<p.cells.length;j++){I.addCell(this._createCell(p.cells[j]));}}if(p.actions&&Array.isArray(p.actions)){var q=p.actions[0];if(q.type===i.Navigation){I.setType(i.Navigation);}if(q.url){I.attachPress(function(){window.open(q.url,q.target||"_blank");});}}t.addItem(I);}.bind(this));this.fireEvent("_actionContentReady");};n.prototype._createCell=function(o){if(o.url){return new L({text:o.value,href:o.url,target:o.target||"_blank"});}if(o.identifier){var t;if(o.identifier.url){t=f.formattedProperty(o.identifier.url,function(v){if(typeof v==="string"){return true;}return false;});}var I=new O({title:o.value,titleActive:t});if(o.identifier.url){I.attachTitlePress(function(E){var S=E.getSource(),j=S.getBindingContext(),M=S.getModel(),p,u,q;if(j){p=j.getPath();}u=e.resolveValue(o.identifier.url,M,p);q=e.resolveValue(o.identifier.target,M,p);if(u){window.open(u,q||"_blank");}});}return I;}if(o.state){return new c({text:o.value,state:o.state});}if(o.value){return new b({text:o.value});}if(o.icon){var s=f.formattedProperty(o.icon.src,function(v){return this._oIconFormatter.formatSrc(v,this._sAppId);}.bind(this));return new A({src:s,displayShape:o.icon.shape,displaySize:o.icon.size||g.XS,tooltip:o.icon.alt,initials:o.icon.text}).addStyleClass("sapFCardIcon");}if(o.progressIndicator){return new P({percentValue:o.progressIndicator.percent,displayValue:o.progressIndicator.text,state:o.progressIndicator.state});}};n.prototype.getInnerList=function(){return this._getTable();};return n;});
