/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Skeleton interface for Bison GLR parsers in C

   Copyright (C) 2002-2015, 2018-2021 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

#ifndef YY_YY_SRC_LIBEXPR_PARSER_TAB_HH_INCLUDED
# define YY_YY_SRC_LIBEXPR_PARSER_TAB_HH_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif
/* "%code requires" blocks.  */
#line 14 "src/libexpr/parser.y"


#ifndef BISON_HEADER
#define BISON_HEADER

#include <variant>

#include "util.hh"

#include "nixexpr.hh"
#include "eval.hh"
#include "globals.hh"

namespace nix {

    struct ParseData
    {
        EvalState & state;
        SymbolTable & symbols;
        Expr * result;
        Path basePath;
        PosTable::Origin origin;
        std::optional<ErrorInfo> error;
        ParseData(EvalState & state, PosTable::Origin origin)
            : state(state)
            , symbols(state.symbols)
            , origin(std::move(origin))
            { };
    };

    struct ParserFormals {
        std::vector<Formal> formals;
        bool ellipsis = false;
    };

}

// using C a struct allows us to avoid having to define the special
// members that using string_view here would implicitly delete.
struct StringToken {
  const char * p;
  size_t l;
  bool hasIndentation;
  operator std::string_view() const { return {p, l}; }
};

#define YY_DECL int yylex \
    (YYSTYPE * yylval_param, YYLTYPE * yylloc_param, yyscan_t yyscanner, nix::ParseData * data)

#endif


#line 97 "src/libexpr/parser-tab.hh"

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    ID = 258,                      /* ID  */
    ATTRPATH = 259,                /* ATTRPATH  */
    STR = 260,                     /* STR  */
    IND_STR = 261,                 /* IND_STR  */
    INT = 262,                     /* INT  */
    FLOAT = 263,                   /* FLOAT  */
    PATH = 264,                    /* PATH  */
    HPATH = 265,                   /* HPATH  */
    SPATH = 266,                   /* SPATH  */
    PATH_END = 267,                /* PATH_END  */
    URI = 268,                     /* URI  */
    IF = 269,                      /* IF  */
    THEN = 270,                    /* THEN  */
    ELSE = 271,                    /* ELSE  */
    ASSERT = 272,                  /* ASSERT  */
    WITH = 273,                    /* WITH  */
    LET = 274,                     /* LET  */
    IN = 275,                      /* IN  */
    REC = 276,                     /* REC  */
    INHERIT = 277,                 /* INHERIT  */
    EQ = 278,                      /* EQ  */
    NEQ = 279,                     /* NEQ  */
    AND = 280,                     /* AND  */
    OR = 281,                      /* OR  */
    IMPL = 282,                    /* IMPL  */
    OR_KW = 283,                   /* OR_KW  */
    DOLLAR_CURLY = 284,            /* DOLLAR_CURLY  */
    IND_STRING_OPEN = 285,         /* IND_STRING_OPEN  */
    IND_STRING_CLOSE = 286,        /* IND_STRING_CLOSE  */
    ELLIPSIS = 287,                /* ELLIPSIS  */
    LEQ = 288,                     /* LEQ  */
    GEQ = 289,                     /* GEQ  */
    UPDATE = 290,                  /* UPDATE  */
    NOT = 291,                     /* NOT  */
    CONCAT = 292,                  /* CONCAT  */
    NEGATE = 293                   /* NEGATE  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 309 "src/libexpr/parser.y"

  // !!! We're probably leaking stuff here.
  nix::Expr * e;
  nix::ExprList * list;
  nix::ExprAttrs * attrs;
  nix::ParserFormals * formals;
  nix::Formal * formal;
  nix::NixInt n;
  nix::NixFloat nf;
  StringToken id; // !!! -> Symbol
  StringToken path;
  StringToken uri;
  StringToken str;
  std::vector<nix::AttrName> * attrNames;
  std::vector<std::pair<nix::PosIdx, nix::Expr *>> * string_parts;
  std::vector<std::pair<nix::PosIdx, std::variant<nix::Expr *, StringToken>>> * ind_string_parts;

#line 170 "src/libexpr/parser-tab.hh"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif



int yyparse (void * scanner, nix::ParseData * data);

#endif /* !YY_YY_SRC_LIBEXPR_PARSER_TAB_HH_INCLUDED  */
