Railgun is a very powerful post exploitation feature exclusive to Windows Meterpreter. It allows you to have complete control of your target machine's Windows API, or you can use whatever DLL you find and do even more creative stuff with it. For example: say you have a meterpreter session on a Windows target. You have your eyes on a particular application that you believe stores the user's password, but it is encrypted and there are no tools out there for decryption. With Railgun, what you can do is you can either tap into the process and grep for any sensitive information found in memory, or you can look for the program's DLL that's responsible for the decryption, call it, and let it decrypt it for you. If you're a penetration tester, obviously post exploitation is an important skill to have, but if you don't know Railgun, you are missing out a lot.

### Defining a DLL and its functions

The Windows API is obviously quite large, so by default Railgun only comes with a handful of pre-defined DLLs and functions that are commonly used for building a Windows program. These built-in DLLs are: kernel32, ntdll, user32, ws2_32, iphlpapi, advapi32, shell32, netapi32, crypt32, wlanapi, wldap32, version. The same list of built-in DLLs can also be retrieved by using the ```known_dll_names``` method.

All DLL definitions are found in the "[def](https://github.com/rapid7/metasploit-framework/tree/master/lib/rex/post/meterpreter/extensions/stdapi/railgun/def)" directory, where they are defined as classes. The following template should demonstrate how a DLL is actually defined:

```ruby
# -*- coding: binary -*-
module Rex
module Post
module Meterpreter
module Extensions
module Stdapi
module Railgun
module Def

class Def_somedll

  def self.create_dll(dll_path = 'somedll')
    dll = DLL.new(dll_path, ApiConstants.manager)

    # 1st argument = Name of the function
    # 2nd argument = Return value's data type
    # 3rd argument = An array of parameters
    dll.add_function('SomeFunction', 'DWORD',[
      ["DWORD","hwnd","in"]
    ])

    return dll
  end

end

end; end; end; end; end; end; end
```

In function definitions, Railgun supports these datatypes: VOID, BOOL, DWORD, WORD, BYTE, LPVOID, HANDLE, PDWORD, PWCHAR, PCHAR, PBLOB.

There are four parameter/buffer directions: in, out, inout, and return. When you pass a value to an "in" parameter, Railgun handles the memory management. For example, ```MessageBoxA``` has a "in" parameter named ```lpText```, and is of type PCHAR. You can simply pass a Ruby string to it, and Railgun handles the rest, it's all pretty straight forward.

An "out" parameter will always be of a pointer datatype. Basically you tell Railgun how many bytes to allocate for the parameter, it allocates memory, provides a pointer to it when calling the function, and then it reads that region of memory that the function wrote, converts that to a Ruby object and adds it to the return hash.

An "inout" parameter serves as an input to the called function, but can be potentially modified by it. You can inspect the return hash for the modified value like an "out" parameter.

A quick way to define a new function at runtime can be done like the following example:

```ruby
client.railgun.add_function('user32', 'MessageBoxA', 'DWORD',[
	["DWORD","hWnd","in"],
	["PCHAR","lpText","in"],
	["PCHAR","lpCaption","in"],
	["DWORD","uType","in"]
 ])
```

However, if this function will most likely be used more than once, or it's part of the Windows API, then you should put it in the library.

### Usage

The best way to try Railgun is with irb in a Windows Meterpreter prompt. Here's an example of how to get there:

```
$ msfconsole -q
msf > use exploit/multi/handler
msf exploit(handler) > run

[*] Started reverse handler on 192.168.1.64:4444
[*] Starting the payload handler...
[*] Sending stage (769536 bytes) to 192.168.1.106
[*] Meterpreter session 1 opened (192.168.1.64:4444 -> 192.168.1.106:55148) at 2014-07-30 19:49:35 -0500

meterpreter > irb
[*] Starting IRB shell
[*] The 'client' variable holds the meterpreter client

>>
```

Note that when you're running a post module or in irb, you always have a ```client``` or ```session``` object to work with, both point to same thing, which in this case is ```Msf::Sessions::Meterpreter_x86_Win```. This Meterpreter session object gives you API access to the target machine, including the Railgun object ```Rex::Post::Meterpreter::Extensions::Stdapi::Railgun::Railgun```. Here's how you simply access it:

```ruby
session.railgun
```

If you run the above in irb, you will see that it returns information about all the DLLs, functions, constants, etc, except it's a little unfriendly to read because there's so much data. Fortunately, there are some handy tricks to help us to figure things out. For example, like we mentioned before, if you're not sure what DLLs are loaded, you can call the ```known_dll_names``` method:

```
>> session.railgun.known_dll_names
=> ["kernel32", "ntdll", "user32", "ws2_32", "iphlpapi", "advapi32", "shell32", "netapi32", "crypt32", "wlanapi", "wldap32", "version"]
```

Now, say we're interested in user32 and we want to find all the available functions (as well as return value's data type, parameters), another handy trick is this:

```ruby
session.railgun.user32.functions.each_pair {|n, v| puts "Function name: #{n}, Returns: #{v.return_type}, Params: #{v.params}"}
```

Note that if you happen to call an invalid or unsupported Windows function, a ```RuntimeError``` will raise, and the error message also shows a list of available functions.

To call a Windows API function, here's how:

```
>> session.railgun.user32.MessageBoxA(0, "hello, world", "hello", "MB_OK")
=> {"GetLastError"=>0, "ErrorMessage"=>"The operation completed successfully.", "return"=>1}
```

As you can see this API call returns a hash. One habit we have seen is that sometimes people don't like to check ```GetLastError```, ```ErrorMessage```, and/or the ```return``` value, they kind of just assume it works. This is a bad programming habit, and is not recommended. If you always assume something works, and execute the next API call, you risk having unexpected results (worst case scenario: losing the Meterpreter session).

### Memory Reading and Writing

The ```Railgun``` class also has two very useful methods that you will probably use: ```memread``` and ```memwrite```. The names are pretty self-explanatory: You read a block of memory, or you write to a region of memory. We'll demonstrate this with a new block of memory in the payload itself:

```
>> p = session.sys.process.open(session.sys.process.getpid, PROCESS_ALL_ACCESS)
=> #<#<Class:0x007fe2e051b740>:0x007fe2c5a258a0 @client=#<Session:meterpreter 192.168.1.106:55151 (192.168.1.106) "WIN-6NH0Q8CJQVM\sinn3r @ WIN-6NH0Q8CJQVM">, @handle=448, @channel=nil, @pid=2268, @aliases={"image"=>#<Rex::Post::Meterpreter::Extensions::Stdapi::Sys::ProcessSubsystem::Image:0x007fe2c5a25828 @process=#<#<Class:0x007fe2e051b740>:0x007fe2c5a258a0 ...>>, "io"=>#<Rex::Post::Meterpreter::Extensions::Stdapi::Sys::ProcessSubsystem::IO:0x007fe2c5a257b0 @process=#<#<Class:0x007fe2e051b740>:0x007fe2c5a258a0 ...>>, "memory"=>#<Rex::Post::Meterpreter::Extensions::Stdapi::Sys::ProcessSubsystem::Memory:0x007fe2c5a25738 @process=#<#<Class:0x007fe2e051b740>:0x007fe2c5a258a0 ...>>, "thread"=>#<Rex::Post::Meterpreter::Extensions::Stdapi::Sys::ProcessSubsystem::Thread:0x007fe2c5a256c0 @process=#<#<Class:0x007fe2e051b740>:0x007fe2c5a258a0 ...>>}>
>> p.memory.allocate(1024)
=> 5898240
```

As you can see, the new allocation is at address 5898240 (or 0x005A0000 in hex). Let's first write four bytes to it:

```
>> session.railgun.memwrite(5898240, "AAAA", 4)
=> true
```

```memwrite``` returns true, which means successful. Now let's read 4 bytes from 0x005A0000:

```
>> session.railgun.memread(5898240, 4)
=> "AAAA"
```

Be aware that if you supply a bad pointer, you can cause an access violation and crash Meterpreter.

### References:

- <https://www.youtube.com/watch?v=AniR-T0AnnI>
- <https://www.defcon.org/images/defcon-20/dc-20-presentations/Maloney/DEFCON-20-Maloney-Railgun.pdf>
- <https://github.com/rapid7/metasploit-framework/tree/master/lib/rex/post/meterpreter/extensions/stdapi/railgun>
- <http://msdn.microsoft.com/en-us/library/ms681381(VS.85).aspx>
- <http://msdn.microsoft.com/en-us/library/aa383749>
- <http://undocumented.ntinternals.net/>
- <http://source.winehq.org/WineAPI/>
