#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 glirc
version:              2.39.0.1
visibility:           public
id:                   glirc-2.39.0.1-6RHSLMaqd4bGwSrpWB1QVN
key:                  glirc-2.39.0.1-6RHSLMaqd4bGwSrpWB1QVN
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  86ad3c34816d4bea86e90e98bd6e8880
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Exec Client.Commands.Interpolation
    Client.Commands.Operator Client.Commands.Queries
    Client.Commands.Recognizer Client.Commands.TabCompletion
    Client.Commands.Toggles Client.Commands.Types
    Client.Commands.Window Client.Commands.WordCompletion
    Client.Commands.ZNC Client.Configuration
    Client.Configuration.Colors Client.Configuration.Macros
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.EventLoop Client.EventLoop.Actions Client.EventLoop.Errors
    Client.EventLoop.Network Client.Hook Client.Hook.DroneBLRelay
    Client.Hook.Matterbridge Client.Hook.Snotice
    Client.Hook.Znc.Buffextras Client.Hooks Client.Image
    Client.Image.Layout Client.Image.LineWrap Client.Image.Message
    Client.Image.MircFormatting Client.Image.PackedImage
    Client.Image.Palette Client.Image.StatusLine Client.Image.Textbox
    Client.Log Client.Mask Client.Message Client.Network.Async
    Client.Network.Connect Client.Options Client.State
    Client.State.Channel Client.State.EditBox
    Client.State.EditBox.Content Client.State.Extensions
    Client.State.Focus Client.State.Network Client.State.Window
    Client.UserHost Client.View Client.View.Cert
    Client.View.ChannelInfo Client.View.Digraphs Client.View.Help
    Client.View.IgnoreList Client.View.KeyMap Client.View.MaskList
    Client.View.Mentions Client.View.Messages Client.View.Palette
    Client.View.RtsStats Client.View.UrlSelection Client.View.UserList
    Client.View.Windows

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.0.2/site-local/glirc-2.39.0.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/glirc-2.39.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.39.0.1-6RHSLMaqd4bGwSrpWB1QVN
include-dirs:         /usr/lib/ghc-9.0.2/site-local/glirc-2.39.0.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.2-If7fyvdIN9P1gjVClOmlfi
    async-2.2.4-9EoKZTgytm43s60GeTAIZR
    attoparsec-0.14.4-9SQv4o2tq0k4n7CegIwza1 base-4.15.1.0
    base64-bytestring-1.2.1.0-iG6YBGhLkRJagBsFqRAI2
    bytestring-0.10.12.1 config-schema-1.3.0.0-2NmOBfhiE1j3I8nGyGOf3p
    config-value-0.8.3-3pmzeYU8Vb25WTAZFoPyxS containers-0.6.4.1
    curve25519-0.2.7-4yn5Vu6owORHgafhIuAhRN directory-1.3.6.2
    filepath-1.4.2.1 free-5.1.9-41zgDvzFzX17DfjTczd8jf
    githash-0.1.6.3-LUU4aE59lPW2hb8tAd17vZ
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    hookup-0.7-8CWQJ3CRD5141FxlWtNYBA
    irc-core-2.11-5I0oA4h2ES2G1z4Y2j8WFE
    kan-extensions-5.2.5-J7mEynbIWm1KZCOJtMi9bW
    lens-5.1.1-8cVW77ucFRGIbO4yMEfpoM
    network-3.1.2.7-2x6X3kWddA03AmOITnySLy process-1.6.13.2
    psqueues-0.2.7.3-GpEAuBz0vcj3EB40c6qlf1
    random-1.2.1.1-LHneN0qmdBg2HhYYKMDrs5
    regex-tdfa-1.3.2-tNtR2SpOBLAbbzDX5vBu9
    split-0.2.3.5-1ZFbiAR4sQhKaqqBevLjN8 stm-2.5.0.0
    template-haskell-2.17.0.0 text-1.2.5.0 time-1.9.3
    transformers-0.5.6.2 unix-2.7.2.2
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf
    vty-5.37-1rv9lU8B4Qi2YtOoZDnRw2

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

