var autoprefixer = (function () {
  'use strict';

  var global$1 = (typeof global !== "undefined" ? global :
    typeof self !== "undefined" ? self :
    typeof window !== "undefined" ? window : {});

  // shim for using process in browser
  // based off https://github.com/defunctzombie/node-process/blob/master/browser.js

  function defaultSetTimout() {
      throw new Error('setTimeout has not been defined');
  }
  function defaultClearTimeout () {
      throw new Error('clearTimeout has not been defined');
  }
  var cachedSetTimeout = defaultSetTimout;
  var cachedClearTimeout = defaultClearTimeout;
  if (typeof global$1.setTimeout === 'function') {
      cachedSetTimeout = setTimeout;
  }
  if (typeof global$1.clearTimeout === 'function') {
      cachedClearTimeout = clearTimeout;
  }

  function runTimeout(fun) {
      if (cachedSetTimeout === setTimeout) {
          //normal enviroments in sane situations
          return setTimeout(fun, 0);
      }
      // if setTimeout wasn't available but was latter defined
      if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
          cachedSetTimeout = setTimeout;
          return setTimeout(fun, 0);
      }
      try {
          // when when somebody has screwed with setTimeout but no I.E. maddness
          return cachedSetTimeout(fun, 0);
      } catch(e){
          try {
              // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
              return cachedSetTimeout.call(null, fun, 0);
          } catch(e){
              // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
              return cachedSetTimeout.call(this, fun, 0);
          }
      }


  }
  function runClearTimeout(marker) {
      if (cachedClearTimeout === clearTimeout) {
          //normal enviroments in sane situations
          return clearTimeout(marker);
      }
      // if clearTimeout wasn't available but was latter defined
      if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
          cachedClearTimeout = clearTimeout;
          return clearTimeout(marker);
      }
      try {
          // when when somebody has screwed with setTimeout but no I.E. maddness
          return cachedClearTimeout(marker);
      } catch (e){
          try {
              // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
              return cachedClearTimeout.call(null, marker);
          } catch (e){
              // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
              // Some versions of I.E. have different rules for clearTimeout vs setTimeout
              return cachedClearTimeout.call(this, marker);
          }
      }



  }
  var queue = [];
  var draining = false;
  var currentQueue;
  var queueIndex = -1;

  function cleanUpNextTick() {
      if (!draining || !currentQueue) {
          return;
      }
      draining = false;
      if (currentQueue.length) {
          queue = currentQueue.concat(queue);
      } else {
          queueIndex = -1;
      }
      if (queue.length) {
          drainQueue();
      }
  }

  function drainQueue() {
      if (draining) {
          return;
      }
      var timeout = runTimeout(cleanUpNextTick);
      draining = true;

      var len = queue.length;
      while(len) {
          currentQueue = queue;
          queue = [];
          while (++queueIndex < len) {
              if (currentQueue) {
                  currentQueue[queueIndex].run();
              }
          }
          queueIndex = -1;
          len = queue.length;
      }
      currentQueue = null;
      draining = false;
      runClearTimeout(timeout);
  }
  function nextTick(fun) {
      var args = new Array(arguments.length - 1);
      if (arguments.length > 1) {
          for (var i = 1; i < arguments.length; i++) {
              args[i - 1] = arguments[i];
          }
      }
      queue.push(new Item(fun, args));
      if (queue.length === 1 && !draining) {
          runTimeout(drainQueue);
      }
  }
  // v8 likes predictible objects
  function Item(fun, array) {
      this.fun = fun;
      this.array = array;
  }
  Item.prototype.run = function () {
      this.fun.apply(null, this.array);
  };
  var title = 'browser';
  var platform = 'browser';
  var browser = true;
  var env = {};
  var argv = [];
  var version = ''; // empty string to avoid regexp issues
  var versions = {};
  var release = {};
  var config = {};

  function noop() {}

  var on = noop;
  var addListener = noop;
  var once = noop;
  var off = noop;
  var removeListener = noop;
  var removeAllListeners = noop;
  var emit = noop;

  function binding(name) {
      throw new Error('process.binding is not supported');
  }

  function cwd () { return '/' }
  function chdir (dir) {
      throw new Error('process.chdir is not supported');
  }function umask() { return 0; }

  // from https://github.com/kumavis/browser-process-hrtime/blob/master/index.js
  var performance = global$1.performance || {};
  var performanceNow =
    performance.now        ||
    performance.mozNow     ||
    performance.msNow      ||
    performance.oNow       ||
    performance.webkitNow  ||
    function(){ return (new Date()).getTime() };

  // generate timestamp or delta
  // see http://nodejs.org/api/process.html#process_process_hrtime
  function hrtime(previousTimestamp){
    var clocktime = performanceNow.call(performance)*1e-3;
    var seconds = Math.floor(clocktime);
    var nanoseconds = Math.floor((clocktime%1)*1e9);
    if (previousTimestamp) {
      seconds = seconds - previousTimestamp[0];
      nanoseconds = nanoseconds - previousTimestamp[1];
      if (nanoseconds<0) {
        seconds--;
        nanoseconds += 1e9;
      }
    }
    return [seconds,nanoseconds]
  }

  var startTime = new Date();
  function uptime() {
    var currentTime = new Date();
    var dif = currentTime - startTime;
    return dif / 1000;
  }

  var browser$1 = {
    nextTick: nextTick,
    title: title,
    browser: browser,
    env: env,
    argv: argv,
    version: version,
    versions: versions,
    on: on,
    addListener: addListener,
    once: once,
    off: off,
    removeListener: removeListener,
    removeAllListeners: removeAllListeners,
    emit: emit,
    binding: binding,
    cwd: cwd,
    chdir: chdir,
    umask: umask,
    hrtime: hrtime,
    platform: platform,
    release: release,
    config: config,
    uptime: uptime
  };

  var _nodeResolve_empty = {};

  var _nodeResolve_empty$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    'default': _nodeResolve_empty
  });

  function getDefaultExportFromCjs (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  function getAugmentedNamespace(n) {
  	if (n.__esModule) return n;
  	var a = Object.defineProperty({}, '__esModule', {value: true});
  	Object.keys(n).forEach(function (k) {
  		var d = Object.getOwnPropertyDescriptor(n, k);
  		Object.defineProperty(a, k, d.get ? d : {
  			enumerable: true,
  			get: function () {
  				return n[k];
  			}
  		});
  	});
  	return a;
  }

  function createCommonjsModule(fn) {
    var module = { exports: {} };
  	return fn(module, module.exports), module.exports;
  }

  var colorette = /*@__PURE__*/getAugmentedNamespace(_nodeResolve_empty$1);

  let { red, bold, gray, options: colorette$1 } = colorette;



  class CssSyntaxError extends Error {
    constructor (message, line, column, source, file, plugin) {
      super(message);
      this.name = 'CssSyntaxError';
      this.reason = message;

      if (file) {
        this.file = file;
      }
      if (source) {
        this.source = source;
      }
      if (plugin) {
        this.plugin = plugin;
      }
      if (typeof line !== 'undefined' && typeof column !== 'undefined') {
        this.line = line;
        this.column = column;
      }

      this.setMessage();

      if (Error.captureStackTrace) {
        Error.captureStackTrace(this, CssSyntaxError);
      }
    }

    setMessage () {
      this.message = this.plugin ? this.plugin + ': ' : '';
      this.message += this.file ? this.file : '<css input>';
      if (typeof this.line !== 'undefined') {
        this.message += ':' + this.line + ':' + this.column;
      }
      this.message += ': ' + this.reason;
    }

    showSourceCode (color) {
      if (!this.source) return ''

      let css = this.source;
      if (color == null) color = null;
      if (colorette) {
        if (color) css = colorette(css);
      }

      let lines = css.split(/\r?\n/);
      let start = Math.max(this.line - 3, 0);
      let end = Math.min(this.line + 2, lines.length);

      let maxWidth = String(end).length;

      let mark, aside;
      if (color) {
        mark = text => bold(red(text));
        aside = text => gray(text);
      } else {
        mark = aside = str => str;
      }

      return lines
        .slice(start, end)
        .map((line, index) => {
          let number = start + 1 + index;
          let gutter = ' ' + (' ' + number).slice(-maxWidth) + ' | ';
          if (number === this.line) {
            let spacing =
              aside(gutter.replace(/\d/g, ' ')) +
              line.slice(0, this.column - 1).replace(/[^\t]/g, ' ');
            return mark('>') + aside(gutter) + line + '\n ' + spacing + mark('^')
          }
          return ' ' + aside(gutter) + line
        })
        .join('\n')
    }

    toString () {
      let code = this.showSourceCode();
      if (code) {
        code = '\n\n' + code + '\n';
      }
      return this.name + ': ' + this.message + code
    }
  }

  var cssSyntaxError = CssSyntaxError;
  CssSyntaxError.default = CssSyntaxError;

  const DEFAULT_RAW = {
    colon: ': ',
    indent: '    ',
    beforeDecl: '\n',
    beforeRule: '\n',
    beforeOpen: ' ',
    beforeClose: '\n',
    beforeComment: '\n',
    after: '\n',
    emptyBody: '',
    commentLeft: ' ',
    commentRight: ' ',
    semicolon: false
  };

  function capitalize (str) {
    return str[0].toUpperCase() + str.slice(1)
  }

  class Stringifier {
    constructor (builder) {
      this.builder = builder;
    }

    stringify (node, semicolon) {
      /* istanbul ignore if */
      if (!this[node.type]) {
        throw new Error(
          'Unknown AST node type ' +
            node.type +
            '. ' +
            'Maybe you need to change PostCSS stringifier.'
        )
      }
      this[node.type](node, semicolon);
    }

    root (node) {
      this.body(node);
      if (node.raws.after) this.builder(node.raws.after);
    }

    comment (node) {
      let left = this.raw(node, 'left', 'commentLeft');
      let right = this.raw(node, 'right', 'commentRight');
      this.builder('/*' + left + node.text + right + '*/', node);
    }

    decl (node, semicolon) {
      let between = this.raw(node, 'between', 'colon');
      let string = node.prop + between + this.rawValue(node, 'value');

      if (node.important) {
        string += node.raws.important || ' !important';
      }

      if (semicolon) string += ';';
      this.builder(string, node);
    }

    rule (node) {
      this.block(node, this.rawValue(node, 'selector'));
      if (node.raws.ownSemicolon) {
        this.builder(node.raws.ownSemicolon, node, 'end');
      }
    }

    atrule (node, semicolon) {
      let name = '@' + node.name;
      let params = node.params ? this.rawValue(node, 'params') : '';

      if (typeof node.raws.afterName !== 'undefined') {
        name += node.raws.afterName;
      } else if (params) {
        name += ' ';
      }

      if (node.nodes) {
        this.block(node, name + params);
      } else {
        let end = (node.raws.between || '') + (semicolon ? ';' : '');
        this.builder(name + params + end, node);
      }
    }

    body (node) {
      let last = node.nodes.length - 1;
      while (last > 0) {
        if (node.nodes[last].type !== 'comment') break
        last -= 1;
      }

      let semicolon = this.raw(node, 'semicolon');
      for (let i = 0; i < node.nodes.length; i++) {
        let child = node.nodes[i];
        let before = this.raw(child, 'before');
        if (before) this.builder(before);
        this.stringify(child, last !== i || semicolon);
      }
    }

    block (node, start) {
      let between = this.raw(node, 'between', 'beforeOpen');
      this.builder(start + between + '{', node, 'start');

      let after;
      if (node.nodes && node.nodes.length) {
        this.body(node);
        after = this.raw(node, 'after');
      } else {
        after = this.raw(node, 'after', 'emptyBody');
      }

      if (after) this.builder(after);
      this.builder('}', node, 'end');
    }

    raw (node, own, detect) {
      let value;
      if (!detect) detect = own;

      // Already had
      if (own) {
        value = node.raws[own];
        if (typeof value !== 'undefined') return value
      }

      let parent = node.parent;

      // Hack for first rule in CSS
      if (detect === 'before') {
        if (!parent || (parent.type === 'root' && parent.first === node)) {
          return ''
        }
      }

      // Floating child without parent
      if (!parent) return DEFAULT_RAW[detect]

      // Detect style by other nodes
      let root = node.root();
      if (!root.rawCache) root.rawCache = {};
      if (typeof root.rawCache[detect] !== 'undefined') {
        return root.rawCache[detect]
      }

      if (detect === 'before' || detect === 'after') {
        return this.beforeAfter(node, detect)
      } else {
        let method = 'raw' + capitalize(detect);
        if (this[method]) {
          value = this[method](root, node);
        } else {
          root.walk(i => {
            value = i.raws[own];
            if (typeof value !== 'undefined') return false
          });
        }
      }

      if (typeof value === 'undefined') value = DEFAULT_RAW[detect];

      root.rawCache[detect] = value;
      return value
    }

    rawSemicolon (root) {
      let value;
      root.walk(i => {
        if (i.nodes && i.nodes.length && i.last.type === 'decl') {
          value = i.raws.semicolon;
          if (typeof value !== 'undefined') return false
        }
      });
      return value
    }

    rawEmptyBody (root) {
      let value;
      root.walk(i => {
        if (i.nodes && i.nodes.length === 0) {
          value = i.raws.after;
          if (typeof value !== 'undefined') return false
        }
      });
      return value
    }

    rawIndent (root) {
      if (root.raws.indent) return root.raws.indent
      let value;
      root.walk(i => {
        let p = i.parent;
        if (p && p !== root && p.parent && p.parent === root) {
          if (typeof i.raws.before !== 'undefined') {
            let parts = i.raws.before.split('\n');
            value = parts[parts.length - 1];
            value = value.replace(/\S/g, '');
            return false
          }
        }
      });
      return value
    }

    rawBeforeComment (root, node) {
      let value;
      root.walkComments(i => {
        if (typeof i.raws.before !== 'undefined') {
          value = i.raws.before;
          if (value.includes('\n')) {
            value = value.replace(/[^\n]+$/, '');
          }
          return false
        }
      });
      if (typeof value === 'undefined') {
        value = this.raw(node, null, 'beforeDecl');
      } else if (value) {
        value = value.replace(/\S/g, '');
      }
      return value
    }

    rawBeforeDecl (root, node) {
      let value;
      root.walkDecls(i => {
        if (typeof i.raws.before !== 'undefined') {
          value = i.raws.before;
          if (value.includes('\n')) {
            value = value.replace(/[^\n]+$/, '');
          }
          return false
        }
      });
      if (typeof value === 'undefined') {
        value = this.raw(node, null, 'beforeRule');
      } else if (value) {
        value = value.replace(/\S/g, '');
      }
      return value
    }

    rawBeforeRule (root) {
      let value;
      root.walk(i => {
        if (i.nodes && (i.parent !== root || root.first !== i)) {
          if (typeof i.raws.before !== 'undefined') {
            value = i.raws.before;
            if (value.includes('\n')) {
              value = value.replace(/[^\n]+$/, '');
            }
            return false
          }
        }
      });
      if (value) value = value.replace(/\S/g, '');
      return value
    }

    rawBeforeClose (root) {
      let value;
      root.walk(i => {
        if (i.nodes && i.nodes.length > 0) {
          if (typeof i.raws.after !== 'undefined') {
            value = i.raws.after;
            if (value.includes('\n')) {
              value = value.replace(/[^\n]+$/, '');
            }
            return false
          }
        }
      });
      if (value) value = value.replace(/\S/g, '');
      return value
    }

    rawBeforeOpen (root) {
      let value;
      root.walk(i => {
        if (i.type !== 'decl') {
          value = i.raws.between;
          if (typeof value !== 'undefined') return false
        }
      });
      return value
    }

    rawColon (root) {
      let value;
      root.walkDecls(i => {
        if (typeof i.raws.between !== 'undefined') {
          value = i.raws.between.replace(/[^\s:]/g, '');
          return false
        }
      });
      return value
    }

    beforeAfter (node, detect) {
      let value;
      if (node.type === 'decl') {
        value = this.raw(node, null, 'beforeDecl');
      } else if (node.type === 'comment') {
        value = this.raw(node, null, 'beforeComment');
      } else if (detect === 'before') {
        value = this.raw(node, null, 'beforeRule');
      } else {
        value = this.raw(node, null, 'beforeClose');
      }

      let buf = node.parent;
      let depth = 0;
      while (buf && buf.type !== 'root') {
        depth += 1;
        buf = buf.parent;
      }

      if (value.includes('\n')) {
        let indent = this.raw(node, null, 'indent');
        if (indent.length) {
          for (let step = 0; step < depth; step++) value += indent;
        }
      }

      return value
    }

    rawValue (node, prop) {
      let value = node[prop];
      let raw = node.raws[prop];
      if (raw && raw.value === value) {
        return raw.raw
      }

      return value
    }
  }

  var stringifier = Stringifier;

  var isClean = Symbol('isClean');

  var symbols = {
  	isClean: isClean
  };

  function stringify (node, builder) {
    let str = new stringifier(builder);
    str.stringify(node);
  }

  var stringify_1 = stringify;
  stringify.default = stringify;

  let { isClean: isClean$1 } = symbols;


  function cloneNode (obj, parent) {
    let cloned = new obj.constructor();

    for (let i in obj) {
      if (!Object.prototype.hasOwnProperty.call(obj, i)) {
        // istanbul ignore next
        continue
      }
      if (i === 'proxyCache') continue
      let value = obj[i];
      let type = typeof value;

      if (i === 'parent' && type === 'object') {
        if (parent) cloned[i] = parent;
      } else if (i === 'source') {
        cloned[i] = value;
      } else if (Array.isArray(value)) {
        cloned[i] = value.map(j => cloneNode(j, cloned));
      } else {
        if (type === 'object' && value !== null) value = cloneNode(value);
        cloned[i] = value;
      }
    }

    return cloned
  }

  class Node {
    constructor (defaults = {}) {
      this.raws = {};
      this[isClean$1] = false;

      for (let name in defaults) {
        if (name === 'nodes') {
          this.nodes = [];
          for (let node of defaults[name]) {
            if (typeof node.clone === 'function') {
              this.append(node.clone());
            } else {
              this.append(node);
            }
          }
        } else {
          this[name] = defaults[name];
        }
      }
    }

    error (message, opts = {}) {
      if (this.source) {
        let pos = this.positionBy(opts);
        return this.source.input.error(message, pos.line, pos.column, opts)
      }
      return new cssSyntaxError(message)
    }

    warn (result, text, opts) {
      let data = { node: this };
      for (let i in opts) data[i] = opts[i];
      return result.warn(text, data)
    }

    remove () {
      if (this.parent) {
        this.parent.removeChild(this);
      }
      this.parent = undefined;
      return this
    }

    toString (stringifier = stringify_1) {
      if (stringifier.stringify) stringifier = stringifier.stringify;
      let result = '';
      stringifier(this, i => {
        result += i;
      });
      return result
    }

    clone (overrides = {}) {
      let cloned = cloneNode(this);
      for (let name in overrides) {
        cloned[name] = overrides[name];
      }
      return cloned
    }

    cloneBefore (overrides = {}) {
      let cloned = this.clone(overrides);
      this.parent.insertBefore(this, cloned);
      return cloned
    }

    cloneAfter (overrides = {}) {
      let cloned = this.clone(overrides);
      this.parent.insertAfter(this, cloned);
      return cloned
    }

    replaceWith (...nodes) {
      if (this.parent) {
        let bookmark = this;
        let foundSelf = false;
        for (let node of nodes) {
          if (node === this) {
            foundSelf = true;
          } else if (foundSelf) {
            this.parent.insertAfter(bookmark, node);
            bookmark = node;
          } else {
            this.parent.insertBefore(bookmark, node);
          }
        }

        if (!foundSelf) {
          this.remove();
        }
      }

      return this
    }

    next () {
      if (!this.parent) return undefined
      let index = this.parent.index(this);
      return this.parent.nodes[index + 1]
    }

    prev () {
      if (!this.parent) return undefined
      let index = this.parent.index(this);
      return this.parent.nodes[index - 1]
    }

    before (add) {
      this.parent.insertBefore(this, add);
      return this
    }

    after (add) {
      this.parent.insertAfter(this, add);
      return this
    }

    root () {
      let result = this;
      while (result.parent) result = result.parent;
      return result
    }

    raw (prop, defaultType) {
      let str = new stringifier();
      return str.raw(this, prop, defaultType)
    }

    cleanRaws (keepBetween) {
      delete this.raws.before;
      delete this.raws.after;
      if (!keepBetween) delete this.raws.between;
    }

    toJSON (_, inputs) {
      let fixed = {};
      let emitInputs = inputs == null;
      inputs = inputs || new Map();
      let inputsNextIndex = 0;

      for (let name in this) {
        if (!Object.prototype.hasOwnProperty.call(this, name)) {
          // istanbul ignore next
          continue
        }
        if (name === 'parent') continue
        let value = this[name];

        if (Array.isArray(value)) {
          fixed[name] = value.map(i => {
            if (typeof i === 'object' && i.toJSON) {
              return i.toJSON(null, inputs)
            } else {
              return i
            }
          });
        } else if (typeof value === 'object' && value.toJSON) {
          fixed[name] = value.toJSON(null, inputs);
        } else if (name === 'source') {
          let inputId = inputs.get(value.input);
          if (inputId == null) {
            inputId = inputsNextIndex;
            inputs.set(value.input, inputsNextIndex);
            inputsNextIndex++;
          }
          fixed[name] = {
            inputId,
            start: value.start,
            end: value.end
          };
        } else {
          fixed[name] = value;
        }
      }

      if (emitInputs) {
        fixed.inputs = [...inputs.keys()].map(input => input.toJSON());
      }

      return fixed
    }

    positionInside (index) {
      let string = this.toString();
      let column = this.source.start.column;
      let line = this.source.start.line;

      for (let i = 0; i < index; i++) {
        if (string[i] === '\n') {
          column = 1;
          line += 1;
        } else {
          column += 1;
        }
      }

      return { line, column }
    }

    positionBy (opts) {
      let pos = this.source.start;
      if (opts.index) {
        pos = this.positionInside(opts.index);
      } else if (opts.word) {
        let index = this.toString().indexOf(opts.word);
        if (index !== -1) pos = this.positionInside(index);
      }
      return pos
    }

    getProxyProcessor () {
      return {
        set (node, prop, value) {
          if (node[prop] === value) return true
          node[prop] = value;
          if (
            prop === 'prop' ||
            prop === 'value' ||
            prop === 'name' ||
            prop === 'params' ||
            prop === 'important' ||
            prop === 'text'
          ) {
            node.markDirty();
          }
          return true
        },

        get (node, prop) {
          if (prop === 'proxyOf') {
            return node
          } else if (prop === 'root') {
            return () => node.root().toProxy()
          } else {
            return node[prop]
          }
        }
      }
    }

    toProxy () {
      if (!this.proxyCache) {
        this.proxyCache = new Proxy(this, this.getProxyProcessor());
      }
      return this.proxyCache
    }

    addToError (error) {
      error.postcssNode = this;
      if (error.stack && this.source && /\n\s{4}at /.test(error.stack)) {
        let s = this.source;
        error.stack = error.stack.replace(
          /\n\s{4}at /,
          `$&${s.input.from}:${s.start.line}:${s.start.column}$&`
        );
      }
      return error
    }

    markDirty () {
      if (this[isClean$1]) {
        this[isClean$1] = false;
        let next = this;
        while ((next = next.parent)) {
          next[isClean$1] = false;
        }
      }
    }

    get proxyOf () {
      return this
    }
  }

  var node_1 = Node;
  Node.default = Node;

  class Declaration extends node_1 {
    constructor (defaults) {
      if (
        defaults &&
        typeof defaults.value !== 'undefined' &&
        typeof defaults.value !== 'string'
      ) {
        defaults = { ...defaults, value: String(defaults.value) };
      }
      super(defaults);
      this.type = 'decl';
    }

    get variable () {
      return this.prop.startsWith('--') || this.prop[0] === '$'
    }
  }

  var declaration = Declaration;
  Declaration.default = Declaration;

  var lookup = [];
  var revLookup = [];
  var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;
  var inited = false;
  function init () {
    inited = true;
    var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
    for (var i = 0, len = code.length; i < len; ++i) {
      lookup[i] = code[i];
      revLookup[code.charCodeAt(i)] = i;
    }

    revLookup['-'.charCodeAt(0)] = 62;
    revLookup['_'.charCodeAt(0)] = 63;
  }

  function toByteArray (b64) {
    if (!inited) {
      init();
    }
    var i, j, l, tmp, placeHolders, arr;
    var len = b64.length;

    if (len % 4 > 0) {
      throw new Error('Invalid string. Length must be a multiple of 4')
    }

    // the number of equal signs (place holders)
    // if there are two placeholders, than the two characters before it
    // represent one byte
    // if there is only one, then the three characters before it represent 2 bytes
    // this is just a cheap hack to not do indexOf twice
    placeHolders = b64[len - 2] === '=' ? 2 : b64[len - 1] === '=' ? 1 : 0;

    // base64 is 4/3 + up to two characters of the original data
    arr = new Arr(len * 3 / 4 - placeHolders);

    // if there are placeholders, only get up to the last complete 4 chars
    l = placeHolders > 0 ? len - 4 : len;

    var L = 0;

    for (i = 0, j = 0; i < l; i += 4, j += 3) {
      tmp = (revLookup[b64.charCodeAt(i)] << 18) | (revLookup[b64.charCodeAt(i + 1)] << 12) | (revLookup[b64.charCodeAt(i + 2)] << 6) | revLookup[b64.charCodeAt(i + 3)];
      arr[L++] = (tmp >> 16) & 0xFF;
      arr[L++] = (tmp >> 8) & 0xFF;
      arr[L++] = tmp & 0xFF;
    }

    if (placeHolders === 2) {
      tmp = (revLookup[b64.charCodeAt(i)] << 2) | (revLookup[b64.charCodeAt(i + 1)] >> 4);
      arr[L++] = tmp & 0xFF;
    } else if (placeHolders === 1) {
      tmp = (revLookup[b64.charCodeAt(i)] << 10) | (revLookup[b64.charCodeAt(i + 1)] << 4) | (revLookup[b64.charCodeAt(i + 2)] >> 2);
      arr[L++] = (tmp >> 8) & 0xFF;
      arr[L++] = tmp & 0xFF;
    }

    return arr
  }

  function tripletToBase64 (num) {
    return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F]
  }

  function encodeChunk (uint8, start, end) {
    var tmp;
    var output = [];
    for (var i = start; i < end; i += 3) {
      tmp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2]);
      output.push(tripletToBase64(tmp));
    }
    return output.join('')
  }

  function fromByteArray (uint8) {
    if (!inited) {
      init();
    }
    var tmp;
    var len = uint8.length;
    var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes
    var output = '';
    var parts = [];
    var maxChunkLength = 16383; // must be multiple of 3

    // go through the array every three bytes, we'll deal with trailing stuff later
    for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
      parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)));
    }

    // pad the end with zeros, but make sure to not forget the extra bytes
    if (extraBytes === 1) {
      tmp = uint8[len - 1];
      output += lookup[tmp >> 2];
      output += lookup[(tmp << 4) & 0x3F];
      output += '==';
    } else if (extraBytes === 2) {
      tmp = (uint8[len - 2] << 8) + (uint8[len - 1]);
      output += lookup[tmp >> 10];
      output += lookup[(tmp >> 4) & 0x3F];
      output += lookup[(tmp << 2) & 0x3F];
      output += '=';
    }

    parts.push(output);

    return parts.join('')
  }

  function read (buffer, offset, isLE, mLen, nBytes) {
    var e, m;
    var eLen = nBytes * 8 - mLen - 1;
    var eMax = (1 << eLen) - 1;
    var eBias = eMax >> 1;
    var nBits = -7;
    var i = isLE ? (nBytes - 1) : 0;
    var d = isLE ? -1 : 1;
    var s = buffer[offset + i];

    i += d;

    e = s & ((1 << (-nBits)) - 1);
    s >>= (-nBits);
    nBits += eLen;
    for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}

    m = e & ((1 << (-nBits)) - 1);
    e >>= (-nBits);
    nBits += mLen;
    for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}

    if (e === 0) {
      e = 1 - eBias;
    } else if (e === eMax) {
      return m ? NaN : ((s ? -1 : 1) * Infinity)
    } else {
      m = m + Math.pow(2, mLen);
      e = e - eBias;
    }
    return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
  }

  function write (buffer, value, offset, isLE, mLen, nBytes) {
    var e, m, c;
    var eLen = nBytes * 8 - mLen - 1;
    var eMax = (1 << eLen) - 1;
    var eBias = eMax >> 1;
    var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0);
    var i = isLE ? 0 : (nBytes - 1);
    var d = isLE ? 1 : -1;
    var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0;

    value = Math.abs(value);

    if (isNaN(value) || value === Infinity) {
      m = isNaN(value) ? 1 : 0;
      e = eMax;
    } else {
      e = Math.floor(Math.log(value) / Math.LN2);
      if (value * (c = Math.pow(2, -e)) < 1) {
        e--;
        c *= 2;
      }
      if (e + eBias >= 1) {
        value += rt / c;
      } else {
        value += rt * Math.pow(2, 1 - eBias);
      }
      if (value * c >= 2) {
        e++;
        c /= 2;
      }

      if (e + eBias >= eMax) {
        m = 0;
        e = eMax;
      } else if (e + eBias >= 1) {
        m = (value * c - 1) * Math.pow(2, mLen);
        e = e + eBias;
      } else {
        m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
        e = 0;
      }
    }

    for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

    e = (e << mLen) | m;
    eLen += mLen;
    for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

    buffer[offset + i - d] |= s * 128;
  }

  var toString = {}.toString;

  var isArray = Array.isArray || function (arr) {
    return toString.call(arr) == '[object Array]';
  };

  /*!
   * The buffer module from node.js, for the browser.
   *
   * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
   * @license  MIT
   */

  var INSPECT_MAX_BYTES = 50;

  /**
   * If `Buffer.TYPED_ARRAY_SUPPORT`:
   *   === true    Use Uint8Array implementation (fastest)
   *   === false   Use Object implementation (most compatible, even IE6)
   *
   * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
   * Opera 11.6+, iOS 4.2+.
   *
   * Due to various browser bugs, sometimes the Object implementation will be used even
   * when the browser supports typed arrays.
   *
   * Note:
   *
   *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
   *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
   *
   *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
   *
   *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
   *     incorrect length in some situations.

   * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
   * get the Object implementation, which is slower but behaves correctly.
   */
  Buffer.TYPED_ARRAY_SUPPORT = global$1.TYPED_ARRAY_SUPPORT !== undefined
    ? global$1.TYPED_ARRAY_SUPPORT
    : true;

  function kMaxLength () {
    return Buffer.TYPED_ARRAY_SUPPORT
      ? 0x7fffffff
      : 0x3fffffff
  }

  function createBuffer (that, length) {
    if (kMaxLength() < length) {
      throw new RangeError('Invalid typed array length')
    }
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      // Return an augmented `Uint8Array` instance, for best performance
      that = new Uint8Array(length);
      that.__proto__ = Buffer.prototype;
    } else {
      // Fallback: Return an object instance of the Buffer class
      if (that === null) {
        that = new Buffer(length);
      }
      that.length = length;
    }

    return that
  }

  /**
   * The Buffer constructor returns instances of `Uint8Array` that have their
   * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
   * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
   * and the `Uint8Array` methods. Square bracket notation works as expected -- it
   * returns a single octet.
   *
   * The `Uint8Array` prototype remains unmodified.
   */

  function Buffer (arg, encodingOrOffset, length) {
    if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
      return new Buffer(arg, encodingOrOffset, length)
    }

    // Common case.
    if (typeof arg === 'number') {
      if (typeof encodingOrOffset === 'string') {
        throw new Error(
          'If encoding is specified then the first argument must be a string'
        )
      }
      return allocUnsafe(this, arg)
    }
    return from(this, arg, encodingOrOffset, length)
  }

  Buffer.poolSize = 8192; // not used by this implementation

  // TODO: Legacy, not needed anymore. Remove in next major version.
  Buffer._augment = function (arr) {
    arr.__proto__ = Buffer.prototype;
    return arr
  };

  function from (that, value, encodingOrOffset, length) {
    if (typeof value === 'number') {
      throw new TypeError('"value" argument must not be a number')
    }

    if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
      return fromArrayBuffer(that, value, encodingOrOffset, length)
    }

    if (typeof value === 'string') {
      return fromString(that, value, encodingOrOffset)
    }

    return fromObject(that, value)
  }

  /**
   * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
   * if value is a number.
   * Buffer.from(str[, encoding])
   * Buffer.from(array)
   * Buffer.from(buffer)
   * Buffer.from(arrayBuffer[, byteOffset[, length]])
   **/
  Buffer.from = function (value, encodingOrOffset, length) {
    return from(null, value, encodingOrOffset, length)
  };

  if (Buffer.TYPED_ARRAY_SUPPORT) {
    Buffer.prototype.__proto__ = Uint8Array.prototype;
    Buffer.__proto__ = Uint8Array;
  }

  function assertSize (size) {
    if (typeof size !== 'number') {
      throw new TypeError('"size" argument must be a number')
    } else if (size < 0) {
      throw new RangeError('"size" argument must not be negative')
    }
  }

  function alloc (that, size, fill, encoding) {
    assertSize(size);
    if (size <= 0) {
      return createBuffer(that, size)
    }
    if (fill !== undefined) {
      // Only pay attention to encoding if it's a string. This
      // prevents accidentally sending in a number that would
      // be interpretted as a start offset.
      return typeof encoding === 'string'
        ? createBuffer(that, size).fill(fill, encoding)
        : createBuffer(that, size).fill(fill)
    }
    return createBuffer(that, size)
  }

  /**
   * Creates a new filled Buffer instance.
   * alloc(size[, fill[, encoding]])
   **/
  Buffer.alloc = function (size, fill, encoding) {
    return alloc(null, size, fill, encoding)
  };

  function allocUnsafe (that, size) {
    assertSize(size);
    that = createBuffer(that, size < 0 ? 0 : checked(size) | 0);
    if (!Buffer.TYPED_ARRAY_SUPPORT) {
      for (var i = 0; i < size; ++i) {
        that[i] = 0;
      }
    }
    return that
  }

  /**
   * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
   * */
  Buffer.allocUnsafe = function (size) {
    return allocUnsafe(null, size)
  };
  /**
   * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
   */
  Buffer.allocUnsafeSlow = function (size) {
    return allocUnsafe(null, size)
  };

  function fromString (that, string, encoding) {
    if (typeof encoding !== 'string' || encoding === '') {
      encoding = 'utf8';
    }

    if (!Buffer.isEncoding(encoding)) {
      throw new TypeError('"encoding" must be a valid string encoding')
    }

    var length = byteLength(string, encoding) | 0;
    that = createBuffer(that, length);

    var actual = that.write(string, encoding);

    if (actual !== length) {
      // Writing a hex string, for example, that contains invalid characters will
      // cause everything after the first invalid character to be ignored. (e.g.
      // 'abxxcd' will be treated as 'ab')
      that = that.slice(0, actual);
    }

    return that
  }

  function fromArrayLike (that, array) {
    var length = array.length < 0 ? 0 : checked(array.length) | 0;
    that = createBuffer(that, length);
    for (var i = 0; i < length; i += 1) {
      that[i] = array[i] & 255;
    }
    return that
  }

  function fromArrayBuffer (that, array, byteOffset, length) {
    array.byteLength; // this throws if `array` is not a valid ArrayBuffer

    if (byteOffset < 0 || array.byteLength < byteOffset) {
      throw new RangeError('\'offset\' is out of bounds')
    }

    if (array.byteLength < byteOffset + (length || 0)) {
      throw new RangeError('\'length\' is out of bounds')
    }

    if (byteOffset === undefined && length === undefined) {
      array = new Uint8Array(array);
    } else if (length === undefined) {
      array = new Uint8Array(array, byteOffset);
    } else {
      array = new Uint8Array(array, byteOffset, length);
    }

    if (Buffer.TYPED_ARRAY_SUPPORT) {
      // Return an augmented `Uint8Array` instance, for best performance
      that = array;
      that.__proto__ = Buffer.prototype;
    } else {
      // Fallback: Return an object instance of the Buffer class
      that = fromArrayLike(that, array);
    }
    return that
  }

  function fromObject (that, obj) {
    if (internalIsBuffer(obj)) {
      var len = checked(obj.length) | 0;
      that = createBuffer(that, len);

      if (that.length === 0) {
        return that
      }

      obj.copy(that, 0, 0, len);
      return that
    }

    if (obj) {
      if ((typeof ArrayBuffer !== 'undefined' &&
          obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
        if (typeof obj.length !== 'number' || isnan(obj.length)) {
          return createBuffer(that, 0)
        }
        return fromArrayLike(that, obj)
      }

      if (obj.type === 'Buffer' && isArray(obj.data)) {
        return fromArrayLike(that, obj.data)
      }
    }

    throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
  }

  function checked (length) {
    // Note: cannot use `length < kMaxLength()` here because that fails when
    // length is NaN (which is otherwise coerced to zero.)
    if (length >= kMaxLength()) {
      throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                           'size: 0x' + kMaxLength().toString(16) + ' bytes')
    }
    return length | 0
  }
  Buffer.isBuffer = isBuffer;
  function internalIsBuffer (b) {
    return !!(b != null && b._isBuffer)
  }

  Buffer.compare = function compare (a, b) {
    if (!internalIsBuffer(a) || !internalIsBuffer(b)) {
      throw new TypeError('Arguments must be Buffers')
    }

    if (a === b) return 0

    var x = a.length;
    var y = b.length;

    for (var i = 0, len = Math.min(x, y); i < len; ++i) {
      if (a[i] !== b[i]) {
        x = a[i];
        y = b[i];
        break
      }
    }

    if (x < y) return -1
    if (y < x) return 1
    return 0
  };

  Buffer.isEncoding = function isEncoding (encoding) {
    switch (String(encoding).toLowerCase()) {
      case 'hex':
      case 'utf8':
      case 'utf-8':
      case 'ascii':
      case 'latin1':
      case 'binary':
      case 'base64':
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return true
      default:
        return false
    }
  };

  Buffer.concat = function concat (list, length) {
    if (!isArray(list)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    }

    if (list.length === 0) {
      return Buffer.alloc(0)
    }

    var i;
    if (length === undefined) {
      length = 0;
      for (i = 0; i < list.length; ++i) {
        length += list[i].length;
      }
    }

    var buffer = Buffer.allocUnsafe(length);
    var pos = 0;
    for (i = 0; i < list.length; ++i) {
      var buf = list[i];
      if (!internalIsBuffer(buf)) {
        throw new TypeError('"list" argument must be an Array of Buffers')
      }
      buf.copy(buffer, pos);
      pos += buf.length;
    }
    return buffer
  };

  function byteLength (string, encoding) {
    if (internalIsBuffer(string)) {
      return string.length
    }
    if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
        (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
      return string.byteLength
    }
    if (typeof string !== 'string') {
      string = '' + string;
    }

    var len = string.length;
    if (len === 0) return 0

    // Use a for loop to avoid recursion
    var loweredCase = false;
    for (;;) {
      switch (encoding) {
        case 'ascii':
        case 'latin1':
        case 'binary':
          return len
        case 'utf8':
        case 'utf-8':
        case undefined:
          return utf8ToBytes(string).length
        case 'ucs2':
        case 'ucs-2':
        case 'utf16le':
        case 'utf-16le':
          return len * 2
        case 'hex':
          return len >>> 1
        case 'base64':
          return base64ToBytes(string).length
        default:
          if (loweredCase) return utf8ToBytes(string).length // assume utf8
          encoding = ('' + encoding).toLowerCase();
          loweredCase = true;
      }
    }
  }
  Buffer.byteLength = byteLength;

  function slowToString (encoding, start, end) {
    var loweredCase = false;

    // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
    // property of a typed array.

    // This behaves neither like String nor Uint8Array in that we set start/end
    // to their upper/lower bounds if the value passed is out of range.
    // undefined is handled specially as per ECMA-262 6th Edition,
    // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
    if (start === undefined || start < 0) {
      start = 0;
    }
    // Return early if start > this.length. Done here to prevent potential uint32
    // coercion fail below.
    if (start > this.length) {
      return ''
    }

    if (end === undefined || end > this.length) {
      end = this.length;
    }

    if (end <= 0) {
      return ''
    }

    // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
    end >>>= 0;
    start >>>= 0;

    if (end <= start) {
      return ''
    }

    if (!encoding) encoding = 'utf8';

    while (true) {
      switch (encoding) {
        case 'hex':
          return hexSlice(this, start, end)

        case 'utf8':
        case 'utf-8':
          return utf8Slice(this, start, end)

        case 'ascii':
          return asciiSlice(this, start, end)

        case 'latin1':
        case 'binary':
          return latin1Slice(this, start, end)

        case 'base64':
          return base64Slice(this, start, end)

        case 'ucs2':
        case 'ucs-2':
        case 'utf16le':
        case 'utf-16le':
          return utf16leSlice(this, start, end)

        default:
          if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
          encoding = (encoding + '').toLowerCase();
          loweredCase = true;
      }
    }
  }

  // The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
  // Buffer instances.
  Buffer.prototype._isBuffer = true;

  function swap (b, n, m) {
    var i = b[n];
    b[n] = b[m];
    b[m] = i;
  }

  Buffer.prototype.swap16 = function swap16 () {
    var len = this.length;
    if (len % 2 !== 0) {
      throw new RangeError('Buffer size must be a multiple of 16-bits')
    }
    for (var i = 0; i < len; i += 2) {
      swap(this, i, i + 1);
    }
    return this
  };

  Buffer.prototype.swap32 = function swap32 () {
    var len = this.length;
    if (len % 4 !== 0) {
      throw new RangeError('Buffer size must be a multiple of 32-bits')
    }
    for (var i = 0; i < len; i += 4) {
      swap(this, i, i + 3);
      swap(this, i + 1, i + 2);
    }
    return this
  };

  Buffer.prototype.swap64 = function swap64 () {
    var len = this.length;
    if (len % 8 !== 0) {
      throw new RangeError('Buffer size must be a multiple of 64-bits')
    }
    for (var i = 0; i < len; i += 8) {
      swap(this, i, i + 7);
      swap(this, i + 1, i + 6);
      swap(this, i + 2, i + 5);
      swap(this, i + 3, i + 4);
    }
    return this
  };

  Buffer.prototype.toString = function toString () {
    var length = this.length | 0;
    if (length === 0) return ''
    if (arguments.length === 0) return utf8Slice(this, 0, length)
    return slowToString.apply(this, arguments)
  };

  Buffer.prototype.equals = function equals (b) {
    if (!internalIsBuffer(b)) throw new TypeError('Argument must be a Buffer')
    if (this === b) return true
    return Buffer.compare(this, b) === 0
  };

  Buffer.prototype.inspect = function inspect () {
    var str = '';
    var max = INSPECT_MAX_BYTES;
    if (this.length > 0) {
      str = this.toString('hex', 0, max).match(/.{2}/g).join(' ');
      if (this.length > max) str += ' ... ';
    }
    return '<Buffer ' + str + '>'
  };

  Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
    if (!internalIsBuffer(target)) {
      throw new TypeError('Argument must be a Buffer')
    }

    if (start === undefined) {
      start = 0;
    }
    if (end === undefined) {
      end = target ? target.length : 0;
    }
    if (thisStart === undefined) {
      thisStart = 0;
    }
    if (thisEnd === undefined) {
      thisEnd = this.length;
    }

    if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
      throw new RangeError('out of range index')
    }

    if (thisStart >= thisEnd && start >= end) {
      return 0
    }
    if (thisStart >= thisEnd) {
      return -1
    }
    if (start >= end) {
      return 1
    }

    start >>>= 0;
    end >>>= 0;
    thisStart >>>= 0;
    thisEnd >>>= 0;

    if (this === target) return 0

    var x = thisEnd - thisStart;
    var y = end - start;
    var len = Math.min(x, y);

    var thisCopy = this.slice(thisStart, thisEnd);
    var targetCopy = target.slice(start, end);

    for (var i = 0; i < len; ++i) {
      if (thisCopy[i] !== targetCopy[i]) {
        x = thisCopy[i];
        y = targetCopy[i];
        break
      }
    }

    if (x < y) return -1
    if (y < x) return 1
    return 0
  };

  // Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
  // OR the last index of `val` in `buffer` at offset <= `byteOffset`.
  //
  // Arguments:
  // - buffer - a Buffer to search
  // - val - a string, Buffer, or number
  // - byteOffset - an index into `buffer`; will be clamped to an int32
  // - encoding - an optional encoding, relevant is val is a string
  // - dir - true for indexOf, false for lastIndexOf
  function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
    // Empty buffer means no match
    if (buffer.length === 0) return -1

    // Normalize byteOffset
    if (typeof byteOffset === 'string') {
      encoding = byteOffset;
      byteOffset = 0;
    } else if (byteOffset > 0x7fffffff) {
      byteOffset = 0x7fffffff;
    } else if (byteOffset < -0x80000000) {
      byteOffset = -0x80000000;
    }
    byteOffset = +byteOffset;  // Coerce to Number.
    if (isNaN(byteOffset)) {
      // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
      byteOffset = dir ? 0 : (buffer.length - 1);
    }

    // Normalize byteOffset: negative offsets start from the end of the buffer
    if (byteOffset < 0) byteOffset = buffer.length + byteOffset;
    if (byteOffset >= buffer.length) {
      if (dir) return -1
      else byteOffset = buffer.length - 1;
    } else if (byteOffset < 0) {
      if (dir) byteOffset = 0;
      else return -1
    }

    // Normalize val
    if (typeof val === 'string') {
      val = Buffer.from(val, encoding);
    }

    // Finally, search either indexOf (if dir is true) or lastIndexOf
    if (internalIsBuffer(val)) {
      // Special case: looking for empty string/buffer always fails
      if (val.length === 0) {
        return -1
      }
      return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
    } else if (typeof val === 'number') {
      val = val & 0xFF; // Search for a byte value [0-255]
      if (Buffer.TYPED_ARRAY_SUPPORT &&
          typeof Uint8Array.prototype.indexOf === 'function') {
        if (dir) {
          return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
        } else {
          return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
        }
      }
      return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
    }

    throw new TypeError('val must be string, number or Buffer')
  }

  function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
    var indexSize = 1;
    var arrLength = arr.length;
    var valLength = val.length;

    if (encoding !== undefined) {
      encoding = String(encoding).toLowerCase();
      if (encoding === 'ucs2' || encoding === 'ucs-2' ||
          encoding === 'utf16le' || encoding === 'utf-16le') {
        if (arr.length < 2 || val.length < 2) {
          return -1
        }
        indexSize = 2;
        arrLength /= 2;
        valLength /= 2;
        byteOffset /= 2;
      }
    }

    function read (buf, i) {
      if (indexSize === 1) {
        return buf[i]
      } else {
        return buf.readUInt16BE(i * indexSize)
      }
    }

    var i;
    if (dir) {
      var foundIndex = -1;
      for (i = byteOffset; i < arrLength; i++) {
        if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
          if (foundIndex === -1) foundIndex = i;
          if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
        } else {
          if (foundIndex !== -1) i -= i - foundIndex;
          foundIndex = -1;
        }
      }
    } else {
      if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
      for (i = byteOffset; i >= 0; i--) {
        var found = true;
        for (var j = 0; j < valLength; j++) {
          if (read(arr, i + j) !== read(val, j)) {
            found = false;
            break
          }
        }
        if (found) return i
      }
    }

    return -1
  }

  Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
    return this.indexOf(val, byteOffset, encoding) !== -1
  };

  Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
    return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
  };

  Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
    return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
  };

  function hexWrite (buf, string, offset, length) {
    offset = Number(offset) || 0;
    var remaining = buf.length - offset;
    if (!length) {
      length = remaining;
    } else {
      length = Number(length);
      if (length > remaining) {
        length = remaining;
      }
    }

    // must be an even number of digits
    var strLen = string.length;
    if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

    if (length > strLen / 2) {
      length = strLen / 2;
    }
    for (var i = 0; i < length; ++i) {
      var parsed = parseInt(string.substr(i * 2, 2), 16);
      if (isNaN(parsed)) return i
      buf[offset + i] = parsed;
    }
    return i
  }

  function utf8Write (buf, string, offset, length) {
    return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
  }

  function asciiWrite (buf, string, offset, length) {
    return blitBuffer(asciiToBytes(string), buf, offset, length)
  }

  function latin1Write (buf, string, offset, length) {
    return asciiWrite(buf, string, offset, length)
  }

  function base64Write (buf, string, offset, length) {
    return blitBuffer(base64ToBytes(string), buf, offset, length)
  }

  function ucs2Write (buf, string, offset, length) {
    return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
  }

  Buffer.prototype.write = function write (string, offset, length, encoding) {
    // Buffer#write(string)
    if (offset === undefined) {
      encoding = 'utf8';
      length = this.length;
      offset = 0;
    // Buffer#write(string, encoding)
    } else if (length === undefined && typeof offset === 'string') {
      encoding = offset;
      length = this.length;
      offset = 0;
    // Buffer#write(string, offset[, length][, encoding])
    } else if (isFinite(offset)) {
      offset = offset | 0;
      if (isFinite(length)) {
        length = length | 0;
        if (encoding === undefined) encoding = 'utf8';
      } else {
        encoding = length;
        length = undefined;
      }
    // legacy write(string, encoding, offset, length) - remove in v0.13
    } else {
      throw new Error(
        'Buffer.write(string, encoding, offset[, length]) is no longer supported'
      )
    }

    var remaining = this.length - offset;
    if (length === undefined || length > remaining) length = remaining;

    if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
      throw new RangeError('Attempt to write outside buffer bounds')
    }

    if (!encoding) encoding = 'utf8';

    var loweredCase = false;
    for (;;) {
      switch (encoding) {
        case 'hex':
          return hexWrite(this, string, offset, length)

        case 'utf8':
        case 'utf-8':
          return utf8Write(this, string, offset, length)

        case 'ascii':
          return asciiWrite(this, string, offset, length)

        case 'latin1':
        case 'binary':
          return latin1Write(this, string, offset, length)

        case 'base64':
          // Warning: maxLength not taken into account in base64Write
          return base64Write(this, string, offset, length)

        case 'ucs2':
        case 'ucs-2':
        case 'utf16le':
        case 'utf-16le':
          return ucs2Write(this, string, offset, length)

        default:
          if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
          encoding = ('' + encoding).toLowerCase();
          loweredCase = true;
      }
    }
  };

  Buffer.prototype.toJSON = function toJSON () {
    return {
      type: 'Buffer',
      data: Array.prototype.slice.call(this._arr || this, 0)
    }
  };

  function base64Slice (buf, start, end) {
    if (start === 0 && end === buf.length) {
      return fromByteArray(buf)
    } else {
      return fromByteArray(buf.slice(start, end))
    }
  }

  function utf8Slice (buf, start, end) {
    end = Math.min(buf.length, end);
    var res = [];

    var i = start;
    while (i < end) {
      var firstByte = buf[i];
      var codePoint = null;
      var bytesPerSequence = (firstByte > 0xEF) ? 4
        : (firstByte > 0xDF) ? 3
        : (firstByte > 0xBF) ? 2
        : 1;

      if (i + bytesPerSequence <= end) {
        var secondByte, thirdByte, fourthByte, tempCodePoint;

        switch (bytesPerSequence) {
          case 1:
            if (firstByte < 0x80) {
              codePoint = firstByte;
            }
            break
          case 2:
            secondByte = buf[i + 1];
            if ((secondByte & 0xC0) === 0x80) {
              tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F);
              if (tempCodePoint > 0x7F) {
                codePoint = tempCodePoint;
              }
            }
            break
          case 3:
            secondByte = buf[i + 1];
            thirdByte = buf[i + 2];
            if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
              tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F);
              if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
                codePoint = tempCodePoint;
              }
            }
            break
          case 4:
            secondByte = buf[i + 1];
            thirdByte = buf[i + 2];
            fourthByte = buf[i + 3];
            if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
              tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F);
              if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
                codePoint = tempCodePoint;
              }
            }
        }
      }

      if (codePoint === null) {
        // we did not generate a valid codePoint so insert a
        // replacement char (U+FFFD) and advance only 1 byte
        codePoint = 0xFFFD;
        bytesPerSequence = 1;
      } else if (codePoint > 0xFFFF) {
        // encode to utf16 (surrogate pair dance)
        codePoint -= 0x10000;
        res.push(codePoint >>> 10 & 0x3FF | 0xD800);
        codePoint = 0xDC00 | codePoint & 0x3FF;
      }

      res.push(codePoint);
      i += bytesPerSequence;
    }

    return decodeCodePointsArray(res)
  }

  // Based on http://stackoverflow.com/a/22747272/680742, the browser with
  // the lowest limit is Chrome, with 0x10000 args.
  // We go 1 magnitude less, for safety
  var MAX_ARGUMENTS_LENGTH = 0x1000;

  function decodeCodePointsArray (codePoints) {
    var len = codePoints.length;
    if (len <= MAX_ARGUMENTS_LENGTH) {
      return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
    }

    // Decode in chunks to avoid "call stack size exceeded".
    var res = '';
    var i = 0;
    while (i < len) {
      res += String.fromCharCode.apply(
        String,
        codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
      );
    }
    return res
  }

  function asciiSlice (buf, start, end) {
    var ret = '';
    end = Math.min(buf.length, end);

    for (var i = start; i < end; ++i) {
      ret += String.fromCharCode(buf[i] & 0x7F);
    }
    return ret
  }

  function latin1Slice (buf, start, end) {
    var ret = '';
    end = Math.min(buf.length, end);

    for (var i = start; i < end; ++i) {
      ret += String.fromCharCode(buf[i]);
    }
    return ret
  }

  function hexSlice (buf, start, end) {
    var len = buf.length;

    if (!start || start < 0) start = 0;
    if (!end || end < 0 || end > len) end = len;

    var out = '';
    for (var i = start; i < end; ++i) {
      out += toHex(buf[i]);
    }
    return out
  }

  function utf16leSlice (buf, start, end) {
    var bytes = buf.slice(start, end);
    var res = '';
    for (var i = 0; i < bytes.length; i += 2) {
      res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
    }
    return res
  }

  Buffer.prototype.slice = function slice (start, end) {
    var len = this.length;
    start = ~~start;
    end = end === undefined ? len : ~~end;

    if (start < 0) {
      start += len;
      if (start < 0) start = 0;
    } else if (start > len) {
      start = len;
    }

    if (end < 0) {
      end += len;
      if (end < 0) end = 0;
    } else if (end > len) {
      end = len;
    }

    if (end < start) end = start;

    var newBuf;
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      newBuf = this.subarray(start, end);
      newBuf.__proto__ = Buffer.prototype;
    } else {
      var sliceLen = end - start;
      newBuf = new Buffer(sliceLen, undefined);
      for (var i = 0; i < sliceLen; ++i) {
        newBuf[i] = this[i + start];
      }
    }

    return newBuf
  };

  /*
   * Need to make sure that buffer isn't trying to write out of bounds.
   */
  function checkOffset (offset, ext, length) {
    if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
    if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
  }

  Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
    offset = offset | 0;
    byteLength = byteLength | 0;
    if (!noAssert) checkOffset(offset, byteLength, this.length);

    var val = this[offset];
    var mul = 1;
    var i = 0;
    while (++i < byteLength && (mul *= 0x100)) {
      val += this[offset + i] * mul;
    }

    return val
  };

  Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
    offset = offset | 0;
    byteLength = byteLength | 0;
    if (!noAssert) {
      checkOffset(offset, byteLength, this.length);
    }

    var val = this[offset + --byteLength];
    var mul = 1;
    while (byteLength > 0 && (mul *= 0x100)) {
      val += this[offset + --byteLength] * mul;
    }

    return val
  };

  Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 1, this.length);
    return this[offset]
  };

  Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 2, this.length);
    return this[offset] | (this[offset + 1] << 8)
  };

  Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 2, this.length);
    return (this[offset] << 8) | this[offset + 1]
  };

  Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);

    return ((this[offset]) |
        (this[offset + 1] << 8) |
        (this[offset + 2] << 16)) +
        (this[offset + 3] * 0x1000000)
  };

  Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);

    return (this[offset] * 0x1000000) +
      ((this[offset + 1] << 16) |
      (this[offset + 2] << 8) |
      this[offset + 3])
  };

  Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
    offset = offset | 0;
    byteLength = byteLength | 0;
    if (!noAssert) checkOffset(offset, byteLength, this.length);

    var val = this[offset];
    var mul = 1;
    var i = 0;
    while (++i < byteLength && (mul *= 0x100)) {
      val += this[offset + i] * mul;
    }
    mul *= 0x80;

    if (val >= mul) val -= Math.pow(2, 8 * byteLength);

    return val
  };

  Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
    offset = offset | 0;
    byteLength = byteLength | 0;
    if (!noAssert) checkOffset(offset, byteLength, this.length);

    var i = byteLength;
    var mul = 1;
    var val = this[offset + --i];
    while (i > 0 && (mul *= 0x100)) {
      val += this[offset + --i] * mul;
    }
    mul *= 0x80;

    if (val >= mul) val -= Math.pow(2, 8 * byteLength);

    return val
  };

  Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 1, this.length);
    if (!(this[offset] & 0x80)) return (this[offset])
    return ((0xff - this[offset] + 1) * -1)
  };

  Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 2, this.length);
    var val = this[offset] | (this[offset + 1] << 8);
    return (val & 0x8000) ? val | 0xFFFF0000 : val
  };

  Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 2, this.length);
    var val = this[offset + 1] | (this[offset] << 8);
    return (val & 0x8000) ? val | 0xFFFF0000 : val
  };

  Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);

    return (this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16) |
      (this[offset + 3] << 24)
  };

  Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);

    return (this[offset] << 24) |
      (this[offset + 1] << 16) |
      (this[offset + 2] << 8) |
      (this[offset + 3])
  };

  Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);
    return read(this, offset, true, 23, 4)
  };

  Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);
    return read(this, offset, false, 23, 4)
  };

  Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 8, this.length);
    return read(this, offset, true, 52, 8)
  };

  Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 8, this.length);
    return read(this, offset, false, 52, 8)
  };

  function checkInt (buf, value, offset, ext, max, min) {
    if (!internalIsBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
    if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
    if (offset + ext > buf.length) throw new RangeError('Index out of range')
  }

  Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
    value = +value;
    offset = offset | 0;
    byteLength = byteLength | 0;
    if (!noAssert) {
      var maxBytes = Math.pow(2, 8 * byteLength) - 1;
      checkInt(this, value, offset, byteLength, maxBytes, 0);
    }

    var mul = 1;
    var i = 0;
    this[offset] = value & 0xFF;
    while (++i < byteLength && (mul *= 0x100)) {
      this[offset + i] = (value / mul) & 0xFF;
    }

    return offset + byteLength
  };

  Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
    value = +value;
    offset = offset | 0;
    byteLength = byteLength | 0;
    if (!noAssert) {
      var maxBytes = Math.pow(2, 8 * byteLength) - 1;
      checkInt(this, value, offset, byteLength, maxBytes, 0);
    }

    var i = byteLength - 1;
    var mul = 1;
    this[offset + i] = value & 0xFF;
    while (--i >= 0 && (mul *= 0x100)) {
      this[offset + i] = (value / mul) & 0xFF;
    }

    return offset + byteLength
  };

  Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0);
    if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
    this[offset] = (value & 0xff);
    return offset + 1
  };

  function objectWriteUInt16 (buf, value, offset, littleEndian) {
    if (value < 0) value = 0xffff + value + 1;
    for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
      buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
        (littleEndian ? i : 1 - i) * 8;
    }
  }

  Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = (value & 0xff);
      this[offset + 1] = (value >>> 8);
    } else {
      objectWriteUInt16(this, value, offset, true);
    }
    return offset + 2
  };

  Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = (value >>> 8);
      this[offset + 1] = (value & 0xff);
    } else {
      objectWriteUInt16(this, value, offset, false);
    }
    return offset + 2
  };

  function objectWriteUInt32 (buf, value, offset, littleEndian) {
    if (value < 0) value = 0xffffffff + value + 1;
    for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
      buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff;
    }
  }

  Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset + 3] = (value >>> 24);
      this[offset + 2] = (value >>> 16);
      this[offset + 1] = (value >>> 8);
      this[offset] = (value & 0xff);
    } else {
      objectWriteUInt32(this, value, offset, true);
    }
    return offset + 4
  };

  Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = (value >>> 24);
      this[offset + 1] = (value >>> 16);
      this[offset + 2] = (value >>> 8);
      this[offset + 3] = (value & 0xff);
    } else {
      objectWriteUInt32(this, value, offset, false);
    }
    return offset + 4
  };

  Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) {
      var limit = Math.pow(2, 8 * byteLength - 1);

      checkInt(this, value, offset, byteLength, limit - 1, -limit);
    }

    var i = 0;
    var mul = 1;
    var sub = 0;
    this[offset] = value & 0xFF;
    while (++i < byteLength && (mul *= 0x100)) {
      if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
        sub = 1;
      }
      this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
    }

    return offset + byteLength
  };

  Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) {
      var limit = Math.pow(2, 8 * byteLength - 1);

      checkInt(this, value, offset, byteLength, limit - 1, -limit);
    }

    var i = byteLength - 1;
    var mul = 1;
    var sub = 0;
    this[offset + i] = value & 0xFF;
    while (--i >= 0 && (mul *= 0x100)) {
      if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
        sub = 1;
      }
      this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
    }

    return offset + byteLength
  };

  Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80);
    if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
    if (value < 0) value = 0xff + value + 1;
    this[offset] = (value & 0xff);
    return offset + 1
  };

  Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = (value & 0xff);
      this[offset + 1] = (value >>> 8);
    } else {
      objectWriteUInt16(this, value, offset, true);
    }
    return offset + 2
  };

  Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = (value >>> 8);
      this[offset + 1] = (value & 0xff);
    } else {
      objectWriteUInt16(this, value, offset, false);
    }
    return offset + 2
  };

  Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = (value & 0xff);
      this[offset + 1] = (value >>> 8);
      this[offset + 2] = (value >>> 16);
      this[offset + 3] = (value >>> 24);
    } else {
      objectWriteUInt32(this, value, offset, true);
    }
    return offset + 4
  };

  Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
    if (value < 0) value = 0xffffffff + value + 1;
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = (value >>> 24);
      this[offset + 1] = (value >>> 16);
      this[offset + 2] = (value >>> 8);
      this[offset + 3] = (value & 0xff);
    } else {
      objectWriteUInt32(this, value, offset, false);
    }
    return offset + 4
  };

  function checkIEEE754 (buf, value, offset, ext, max, min) {
    if (offset + ext > buf.length) throw new RangeError('Index out of range')
    if (offset < 0) throw new RangeError('Index out of range')
  }

  function writeFloat (buf, value, offset, littleEndian, noAssert) {
    if (!noAssert) {
      checkIEEE754(buf, value, offset, 4);
    }
    write(buf, value, offset, littleEndian, 23, 4);
    return offset + 4
  }

  Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
    return writeFloat(this, value, offset, true, noAssert)
  };

  Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
    return writeFloat(this, value, offset, false, noAssert)
  };

  function writeDouble (buf, value, offset, littleEndian, noAssert) {
    if (!noAssert) {
      checkIEEE754(buf, value, offset, 8);
    }
    write(buf, value, offset, littleEndian, 52, 8);
    return offset + 8
  }

  Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
    return writeDouble(this, value, offset, true, noAssert)
  };

  Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
    return writeDouble(this, value, offset, false, noAssert)
  };

  // copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
  Buffer.prototype.copy = function copy (target, targetStart, start, end) {
    if (!start) start = 0;
    if (!end && end !== 0) end = this.length;
    if (targetStart >= target.length) targetStart = target.length;
    if (!targetStart) targetStart = 0;
    if (end > 0 && end < start) end = start;

    // Copy 0 bytes; we're done
    if (end === start) return 0
    if (target.length === 0 || this.length === 0) return 0

    // Fatal error conditions
    if (targetStart < 0) {
      throw new RangeError('targetStart out of bounds')
    }
    if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
    if (end < 0) throw new RangeError('sourceEnd out of bounds')

    // Are we oob?
    if (end > this.length) end = this.length;
    if (target.length - targetStart < end - start) {
      end = target.length - targetStart + start;
    }

    var len = end - start;
    var i;

    if (this === target && start < targetStart && targetStart < end) {
      // descending copy from end
      for (i = len - 1; i >= 0; --i) {
        target[i + targetStart] = this[i + start];
      }
    } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
      // ascending copy from start
      for (i = 0; i < len; ++i) {
        target[i + targetStart] = this[i + start];
      }
    } else {
      Uint8Array.prototype.set.call(
        target,
        this.subarray(start, start + len),
        targetStart
      );
    }

    return len
  };

  // Usage:
  //    buffer.fill(number[, offset[, end]])
  //    buffer.fill(buffer[, offset[, end]])
  //    buffer.fill(string[, offset[, end]][, encoding])
  Buffer.prototype.fill = function fill (val, start, end, encoding) {
    // Handle string cases:
    if (typeof val === 'string') {
      if (typeof start === 'string') {
        encoding = start;
        start = 0;
        end = this.length;
      } else if (typeof end === 'string') {
        encoding = end;
        end = this.length;
      }
      if (val.length === 1) {
        var code = val.charCodeAt(0);
        if (code < 256) {
          val = code;
        }
      }
      if (encoding !== undefined && typeof encoding !== 'string') {
        throw new TypeError('encoding must be a string')
      }
      if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
        throw new TypeError('Unknown encoding: ' + encoding)
      }
    } else if (typeof val === 'number') {
      val = val & 255;
    }

    // Invalid ranges are not set to a default, so can range check early.
    if (start < 0 || this.length < start || this.length < end) {
      throw new RangeError('Out of range index')
    }

    if (end <= start) {
      return this
    }

    start = start >>> 0;
    end = end === undefined ? this.length : end >>> 0;

    if (!val) val = 0;

    var i;
    if (typeof val === 'number') {
      for (i = start; i < end; ++i) {
        this[i] = val;
      }
    } else {
      var bytes = internalIsBuffer(val)
        ? val
        : utf8ToBytes(new Buffer(val, encoding).toString());
      var len = bytes.length;
      for (i = 0; i < end - start; ++i) {
        this[i + start] = bytes[i % len];
      }
    }

    return this
  };

  // HELPER FUNCTIONS
  // ================

  var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g;

  function base64clean (str) {
    // Node strips out invalid characters like \n and \t from the string, base64-js does not
    str = stringtrim(str).replace(INVALID_BASE64_RE, '');
    // Node converts strings with length < 2 to ''
    if (str.length < 2) return ''
    // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
    while (str.length % 4 !== 0) {
      str = str + '=';
    }
    return str
  }

  function stringtrim (str) {
    if (str.trim) return str.trim()
    return str.replace(/^\s+|\s+$/g, '')
  }

  function toHex (n) {
    if (n < 16) return '0' + n.toString(16)
    return n.toString(16)
  }

  function utf8ToBytes (string, units) {
    units = units || Infinity;
    var codePoint;
    var length = string.length;
    var leadSurrogate = null;
    var bytes = [];

    for (var i = 0; i < length; ++i) {
      codePoint = string.charCodeAt(i);

      // is surrogate component
      if (codePoint > 0xD7FF && codePoint < 0xE000) {
        // last char was a lead
        if (!leadSurrogate) {
          // no lead yet
          if (codePoint > 0xDBFF) {
            // unexpected trail
            if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
            continue
          } else if (i + 1 === length) {
            // unpaired lead
            if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
            continue
          }

          // valid lead
          leadSurrogate = codePoint;

          continue
        }

        // 2 leads in a row
        if (codePoint < 0xDC00) {
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
          leadSurrogate = codePoint;
          continue
        }

        // valid surrogate pair
        codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000;
      } else if (leadSurrogate) {
        // valid bmp char, but last char was a lead
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
      }

      leadSurrogate = null;

      // encode utf8
      if (codePoint < 0x80) {
        if ((units -= 1) < 0) break
        bytes.push(codePoint);
      } else if (codePoint < 0x800) {
        if ((units -= 2) < 0) break
        bytes.push(
          codePoint >> 0x6 | 0xC0,
          codePoint & 0x3F | 0x80
        );
      } else if (codePoint < 0x10000) {
        if ((units -= 3) < 0) break
        bytes.push(
          codePoint >> 0xC | 0xE0,
          codePoint >> 0x6 & 0x3F | 0x80,
          codePoint & 0x3F | 0x80
        );
      } else if (codePoint < 0x110000) {
        if ((units -= 4) < 0) break
        bytes.push(
          codePoint >> 0x12 | 0xF0,
          codePoint >> 0xC & 0x3F | 0x80,
          codePoint >> 0x6 & 0x3F | 0x80,
          codePoint & 0x3F | 0x80
        );
      } else {
        throw new Error('Invalid code point')
      }
    }

    return bytes
  }

  function asciiToBytes (str) {
    var byteArray = [];
    for (var i = 0; i < str.length; ++i) {
      // Node's code seems to be doing this and not & 0x7F..
      byteArray.push(str.charCodeAt(i) & 0xFF);
    }
    return byteArray
  }

  function utf16leToBytes (str, units) {
    var c, hi, lo;
    var byteArray = [];
    for (var i = 0; i < str.length; ++i) {
      if ((units -= 2) < 0) break

      c = str.charCodeAt(i);
      hi = c >> 8;
      lo = c % 256;
      byteArray.push(lo);
      byteArray.push(hi);
    }

    return byteArray
  }


  function base64ToBytes (str) {
    return toByteArray(base64clean(str))
  }

  function blitBuffer (src, dst, offset, length) {
    for (var i = 0; i < length; ++i) {
      if ((i + offset >= dst.length) || (i >= src.length)) break
      dst[i + offset] = src[i];
    }
    return i
  }

  function isnan (val) {
    return val !== val // eslint-disable-line no-self-compare
  }


  // the following is from is-buffer, also by Feross Aboukhadijeh and with same lisence
  // The _isBuffer check is for Safari 5-7 support, because it's missing
  // Object.prototype.constructor. Remove this eventually
  function isBuffer(obj) {
    return obj != null && (!!obj._isBuffer || isFastBuffer(obj) || isSlowBuffer(obj))
  }

  function isFastBuffer (obj) {
    return !!obj.constructor && typeof obj.constructor.isBuffer === 'function' && obj.constructor.isBuffer(obj)
  }

  // For Node v0.10 support. Remove this eventually.
  function isSlowBuffer (obj) {
    return typeof obj.readFloatLE === 'function' && typeof obj.slice === 'function' && isFastBuffer(obj.slice(0, 0))
  }

  // Copyright Joyent, Inc. and other Node contributors.
  //
  // Permission is hereby granted, free of charge, to any person obtaining a
  // copy of this software and associated documentation files (the
  // "Software"), to deal in the Software without restriction, including
  // without limitation the rights to use, copy, modify, merge, publish,
  // distribute, sublicense, and/or sell copies of the Software, and to permit
  // persons to whom the Software is furnished to do so, subject to the
  // following conditions:
  //
  // The above copyright notice and this permission notice shall be included
  // in all copies or substantial portions of the Software.
  //
  // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  // OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  // MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
  // NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
  // DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
  // OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
  // USE OR OTHER DEALINGS IN THE SOFTWARE.

  // resolves . and .. elements in a path array with directory names there
  // must be no slashes, empty elements, or device names (c:\) in the array
  // (so also no leading and trailing slashes - it does not distinguish
  // relative and absolute paths)
  function normalizeArray(parts, allowAboveRoot) {
    // if the path tries to go above the root, `up` ends up > 0
    var up = 0;
    for (var i = parts.length - 1; i >= 0; i--) {
      var last = parts[i];
      if (last === '.') {
        parts.splice(i, 1);
      } else if (last === '..') {
        parts.splice(i, 1);
        up++;
      } else if (up) {
        parts.splice(i, 1);
        up--;
      }
    }

    // if the path is allowed to go above the root, restore leading ..s
    if (allowAboveRoot) {
      for (; up--; up) {
        parts.unshift('..');
      }
    }

    return parts;
  }

  // Split a filename into [root, dir, basename, ext], unix version
  // 'root' is just a slash, or nothing.
  var splitPathRe =
      /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
  var splitPath = function(filename) {
    return splitPathRe.exec(filename).slice(1);
  };

  // path.resolve([from ...], to)
  // posix version
  function resolve() {
    var resolvedPath = '',
        resolvedAbsolute = false;

    for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
      var path = (i >= 0) ? arguments[i] : '/';

      // Skip empty and invalid entries
      if (typeof path !== 'string') {
        throw new TypeError('Arguments to path.resolve must be strings');
      } else if (!path) {
        continue;
      }

      resolvedPath = path + '/' + resolvedPath;
      resolvedAbsolute = path.charAt(0) === '/';
    }

    // At this point the path should be resolved to a full absolute path, but
    // handle relative paths to be safe (might happen when process.cwd() fails)

    // Normalize the path
    resolvedPath = normalizeArray(filter(resolvedPath.split('/'), function(p) {
      return !!p;
    }), !resolvedAbsolute).join('/');

    return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
  }
  // path.normalize(path)
  // posix version
  function normalize(path) {
    var isPathAbsolute = isAbsolute(path),
        trailingSlash = substr(path, -1) === '/';

    // Normalize the path
    path = normalizeArray(filter(path.split('/'), function(p) {
      return !!p;
    }), !isPathAbsolute).join('/');

    if (!path && !isPathAbsolute) {
      path = '.';
    }
    if (path && trailingSlash) {
      path += '/';
    }

    return (isPathAbsolute ? '/' : '') + path;
  }
  // posix version
  function isAbsolute(path) {
    return path.charAt(0) === '/';
  }

  // posix version
  function join() {
    var paths = Array.prototype.slice.call(arguments, 0);
    return normalize(filter(paths, function(p, index) {
      if (typeof p !== 'string') {
        throw new TypeError('Arguments to path.join must be strings');
      }
      return p;
    }).join('/'));
  }


  // path.relative(from, to)
  // posix version
  function relative(from, to) {
    from = resolve(from).substr(1);
    to = resolve(to).substr(1);

    function trim(arr) {
      var start = 0;
      for (; start < arr.length; start++) {
        if (arr[start] !== '') break;
      }

      var end = arr.length - 1;
      for (; end >= 0; end--) {
        if (arr[end] !== '') break;
      }

      if (start > end) return [];
      return arr.slice(start, end - start + 1);
    }

    var fromParts = trim(from.split('/'));
    var toParts = trim(to.split('/'));

    var length = Math.min(fromParts.length, toParts.length);
    var samePartsLength = length;
    for (var i = 0; i < length; i++) {
      if (fromParts[i] !== toParts[i]) {
        samePartsLength = i;
        break;
      }
    }

    var outputParts = [];
    for (var i = samePartsLength; i < fromParts.length; i++) {
      outputParts.push('..');
    }

    outputParts = outputParts.concat(toParts.slice(samePartsLength));

    return outputParts.join('/');
  }

  var sep = '/';
  var delimiter = ':';

  function dirname(path) {
    var result = splitPath(path),
        root = result[0],
        dir = result[1];

    if (!root && !dir) {
      // No dirname whatsoever
      return '.';
    }

    if (dir) {
      // It has a dirname, strip trailing slash
      dir = dir.substr(0, dir.length - 1);
    }

    return root + dir;
  }

  function basename(path, ext) {
    var f = splitPath(path)[2];
    // TODO: make this comparison case-insensitive on windows?
    if (ext && f.substr(-1 * ext.length) === ext) {
      f = f.substr(0, f.length - ext.length);
    }
    return f;
  }


  function extname(path) {
    return splitPath(path)[3];
  }
  var path = {
    extname: extname,
    basename: basename,
    dirname: dirname,
    sep: sep,
    delimiter: delimiter,
    relative: relative,
    join: join,
    isAbsolute: isAbsolute,
    normalize: normalize,
    resolve: resolve
  };
  function filter (xs, f) {
      if (xs.filter) return xs.filter(f);
      var res = [];
      for (var i = 0; i < xs.length; i++) {
          if (f(xs[i], i, xs)) res.push(xs[i]);
      }
      return res;
  }

  // String.prototype.substr - negative index don't work in IE8
  var substr = 'ab'.substr(-1) === 'b' ?
      function (str, start, len) { return str.substr(start, len) } :
      function (str, start, len) {
          if (start < 0) start = str.length + start;
          return str.substr(start, len);
      }
  ;

  var path$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    resolve: resolve,
    normalize: normalize,
    isAbsolute: isAbsolute,
    join: join,
    relative: relative,
    sep: sep,
    delimiter: delimiter,
    dirname: dirname,
    basename: basename,
    extname: extname,
    'default': path
  });

  /*! https://mths.be/punycode v1.4.1 by @mathias */


  /** Highest positive signed 32-bit float value */
  var maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1

  /** Bootstring parameters */
  var base = 36;
  var tMin = 1;
  var tMax = 26;
  var skew = 38;
  var damp = 700;
  var initialBias = 72;
  var initialN = 128; // 0x80
  var delimiter$1 = '-'; // '\x2D'
  var regexNonASCII = /[^\x20-\x7E]/; // unprintable ASCII chars + non-ASCII chars
  var regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g; // RFC 3490 separators

  /** Error messages */
  var errors = {
    'overflow': 'Overflow: input needs wider integers to process',
    'not-basic': 'Illegal input >= 0x80 (not a basic code point)',
    'invalid-input': 'Invalid input'
  };

  /** Convenience shortcuts */
  var baseMinusTMin = base - tMin;
  var floor = Math.floor;
  var stringFromCharCode = String.fromCharCode;

  /*--------------------------------------------------------------------------*/

  /**
   * A generic error utility function.
   * @private
   * @param {String} type The error type.
   * @returns {Error} Throws a `RangeError` with the applicable error message.
   */
  function error(type) {
    throw new RangeError(errors[type]);
  }

  /**
   * A generic `Array#map` utility function.
   * @private
   * @param {Array} array The array to iterate over.
   * @param {Function} callback The function that gets called for every array
   * item.
   * @returns {Array} A new array of values returned by the callback function.
   */
  function map(array, fn) {
    var length = array.length;
    var result = [];
    while (length--) {
      result[length] = fn(array[length]);
    }
    return result;
  }

  /**
   * A simple `Array#map`-like wrapper to work with domain name strings or email
   * addresses.
   * @private
   * @param {String} domain The domain name or email address.
   * @param {Function} callback The function that gets called for every
   * character.
   * @returns {Array} A new string of characters returned by the callback
   * function.
   */
  function mapDomain(string, fn) {
    var parts = string.split('@');
    var result = '';
    if (parts.length > 1) {
      // In email addresses, only the domain name should be punycoded. Leave
      // the local part (i.e. everything up to `@`) intact.
      result = parts[0] + '@';
      string = parts[1];
    }
    // Avoid `split(regex)` for IE8 compatibility. See #17.
    string = string.replace(regexSeparators, '\x2E');
    var labels = string.split('.');
    var encoded = map(labels, fn).join('.');
    return result + encoded;
  }

  /**
   * Creates an array containing the numeric code points of each Unicode
   * character in the string. While JavaScript uses UCS-2 internally,
   * this function will convert a pair of surrogate halves (each of which
   * UCS-2 exposes as separate characters) into a single code point,
   * matching UTF-16.
   * @see `punycode.ucs2.encode`
   * @see <https://mathiasbynens.be/notes/javascript-encoding>
   * @memberOf punycode.ucs2
   * @name decode
   * @param {String} string The Unicode input string (UCS-2).
   * @returns {Array} The new array of code points.
   */
  function ucs2decode(string) {
    var output = [],
      counter = 0,
      length = string.length,
      value,
      extra;
    while (counter < length) {
      value = string.charCodeAt(counter++);
      if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
        // high surrogate, and there is a next character
        extra = string.charCodeAt(counter++);
        if ((extra & 0xFC00) == 0xDC00) { // low surrogate
          output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
        } else {
          // unmatched surrogate; only append this code unit, in case the next
          // code unit is the high surrogate of a surrogate pair
          output.push(value);
          counter--;
        }
      } else {
        output.push(value);
      }
    }
    return output;
  }

  /**
   * Converts a digit/integer into a basic code point.
   * @see `basicToDigit()`
   * @private
   * @param {Number} digit The numeric value of a basic code point.
   * @returns {Number} The basic code point whose value (when used for
   * representing integers) is `digit`, which needs to be in the range
   * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is
   * used; else, the lowercase form is used. The behavior is undefined
   * if `flag` is non-zero and `digit` has no uppercase form.
   */
  function digitToBasic(digit, flag) {
    //  0..25 map to ASCII a..z or A..Z
    // 26..35 map to ASCII 0..9
    return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
  }

  /**
   * Bias adaptation function as per section 3.4 of RFC 3492.
   * https://tools.ietf.org/html/rfc3492#section-3.4
   * @private
   */
  function adapt(delta, numPoints, firstTime) {
    var k = 0;
    delta = firstTime ? floor(delta / damp) : delta >> 1;
    delta += floor(delta / numPoints);
    for ( /* no initialization */ ; delta > baseMinusTMin * tMax >> 1; k += base) {
      delta = floor(delta / baseMinusTMin);
    }
    return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
  }

  /**
   * Converts a string of Unicode symbols (e.g. a domain name label) to a
   * Punycode string of ASCII-only symbols.
   * @memberOf punycode
   * @param {String} input The string of Unicode symbols.
   * @returns {String} The resulting Punycode string of ASCII-only symbols.
   */
  function encode(input) {
    var n,
      delta,
      handledCPCount,
      basicLength,
      bias,
      j,
      m,
      q,
      k,
      t,
      currentValue,
      output = [],
      /** `inputLength` will hold the number of code points in `input`. */
      inputLength,
      /** Cached calculation results */
      handledCPCountPlusOne,
      baseMinusT,
      qMinusT;

    // Convert the input in UCS-2 to Unicode
    input = ucs2decode(input);

    // Cache the length
    inputLength = input.length;

    // Initialize the state
    n = initialN;
    delta = 0;
    bias = initialBias;

    // Handle the basic code points
    for (j = 0; j < inputLength; ++j) {
      currentValue = input[j];
      if (currentValue < 0x80) {
        output.push(stringFromCharCode(currentValue));
      }
    }

    handledCPCount = basicLength = output.length;

    // `handledCPCount` is the number of code points that have been handled;
    // `basicLength` is the number of basic code points.

    // Finish the basic string - if it is not empty - with a delimiter
    if (basicLength) {
      output.push(delimiter$1);
    }

    // Main encoding loop:
    while (handledCPCount < inputLength) {

      // All non-basic code points < n have been handled already. Find the next
      // larger one:
      for (m = maxInt, j = 0; j < inputLength; ++j) {
        currentValue = input[j];
        if (currentValue >= n && currentValue < m) {
          m = currentValue;
        }
      }

      // Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
      // but guard against overflow
      handledCPCountPlusOne = handledCPCount + 1;
      if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
        error('overflow');
      }

      delta += (m - n) * handledCPCountPlusOne;
      n = m;

      for (j = 0; j < inputLength; ++j) {
        currentValue = input[j];

        if (currentValue < n && ++delta > maxInt) {
          error('overflow');
        }

        if (currentValue == n) {
          // Represent delta as a generalized variable-length integer
          for (q = delta, k = base; /* no condition */ ; k += base) {
            t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);
            if (q < t) {
              break;
            }
            qMinusT = q - t;
            baseMinusT = base - t;
            output.push(
              stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
            );
            q = floor(qMinusT / baseMinusT);
          }

          output.push(stringFromCharCode(digitToBasic(q, 0)));
          bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
          delta = 0;
          ++handledCPCount;
        }
      }

      ++delta;
      ++n;

    }
    return output.join('');
  }

  /**
   * Converts a Unicode string representing a domain name or an email address to
   * Punycode. Only the non-ASCII parts of the domain name will be converted,
   * i.e. it doesn't matter if you call it with a domain that's already in
   * ASCII.
   * @memberOf punycode
   * @param {String} input The domain name or email address to convert, as a
   * Unicode string.
   * @returns {String} The Punycode representation of the given domain name or
   * email address.
   */
  function toASCII(input) {
    return mapDomain(input, function(string) {
      return regexNonASCII.test(string) ?
        'xn--' + encode(string) :
        string;
    });
  }

  function isNull(arg) {
    return arg === null;
  }

  function isNullOrUndefined(arg) {
    return arg == null;
  }

  function isString(arg) {
    return typeof arg === 'string';
  }

  function isObject(arg) {
    return typeof arg === 'object' && arg !== null;
  }

  // Copyright Joyent, Inc. and other Node contributors.
  //
  // Permission is hereby granted, free of charge, to any person obtaining a
  // copy of this software and associated documentation files (the
  // "Software"), to deal in the Software without restriction, including
  // without limitation the rights to use, copy, modify, merge, publish,
  // distribute, sublicense, and/or sell copies of the Software, and to permit
  // persons to whom the Software is furnished to do so, subject to the
  // following conditions:
  //
  // The above copyright notice and this permission notice shall be included
  // in all copies or substantial portions of the Software.
  //
  // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  // OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  // MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
  // NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
  // DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
  // OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
  // USE OR OTHER DEALINGS IN THE SOFTWARE.


  // If obj.hasOwnProperty has been overridden, then calling
  // obj.hasOwnProperty(prop) will break.
  // See: https://github.com/joyent/node/issues/1707
  function hasOwnProperty(obj, prop) {
    return Object.prototype.hasOwnProperty.call(obj, prop);
  }
  var isArray$1 = Array.isArray || function (xs) {
    return Object.prototype.toString.call(xs) === '[object Array]';
  };
  function stringifyPrimitive(v) {
    switch (typeof v) {
      case 'string':
        return v;

      case 'boolean':
        return v ? 'true' : 'false';

      case 'number':
        return isFinite(v) ? v : '';

      default:
        return '';
    }
  }

  function stringify$1 (obj, sep, eq, name) {
    sep = sep || '&';
    eq = eq || '=';
    if (obj === null) {
      obj = undefined;
    }

    if (typeof obj === 'object') {
      return map$1(objectKeys(obj), function(k) {
        var ks = encodeURIComponent(stringifyPrimitive(k)) + eq;
        if (isArray$1(obj[k])) {
          return map$1(obj[k], function(v) {
            return ks + encodeURIComponent(stringifyPrimitive(v));
          }).join(sep);
        } else {
          return ks + encodeURIComponent(stringifyPrimitive(obj[k]));
        }
      }).join(sep);

    }

    if (!name) return '';
    return encodeURIComponent(stringifyPrimitive(name)) + eq +
           encodeURIComponent(stringifyPrimitive(obj));
  }
  function map$1 (xs, f) {
    if (xs.map) return xs.map(f);
    var res = [];
    for (var i = 0; i < xs.length; i++) {
      res.push(f(xs[i], i));
    }
    return res;
  }

  var objectKeys = Object.keys || function (obj) {
    var res = [];
    for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) res.push(key);
    }
    return res;
  };

  function parse(qs, sep, eq, options) {
    sep = sep || '&';
    eq = eq || '=';
    var obj = {};

    if (typeof qs !== 'string' || qs.length === 0) {
      return obj;
    }

    var regexp = /\+/g;
    qs = qs.split(sep);

    var maxKeys = 1000;
    if (options && typeof options.maxKeys === 'number') {
      maxKeys = options.maxKeys;
    }

    var len = qs.length;
    // maxKeys <= 0 means that we should not limit keys count
    if (maxKeys > 0 && len > maxKeys) {
      len = maxKeys;
    }

    for (var i = 0; i < len; ++i) {
      var x = qs[i].replace(regexp, '%20'),
          idx = x.indexOf(eq),
          kstr, vstr, k, v;

      if (idx >= 0) {
        kstr = x.substr(0, idx);
        vstr = x.substr(idx + 1);
      } else {
        kstr = x;
        vstr = '';
      }

      k = decodeURIComponent(kstr);
      v = decodeURIComponent(vstr);

      if (!hasOwnProperty(obj, k)) {
        obj[k] = v;
      } else if (isArray$1(obj[k])) {
        obj[k].push(v);
      } else {
        obj[k] = [obj[k], v];
      }
    }

    return obj;
  }

  // Copyright Joyent, Inc. and other Node contributors.
  var url = {
    parse: urlParse,
    resolve: urlResolve,
    resolveObject: urlResolveObject,
    format: urlFormat,
    Url: Url
  };
  function Url() {
    this.protocol = null;
    this.slashes = null;
    this.auth = null;
    this.host = null;
    this.port = null;
    this.hostname = null;
    this.hash = null;
    this.search = null;
    this.query = null;
    this.pathname = null;
    this.path = null;
    this.href = null;
  }

  // Reference: RFC 3986, RFC 1808, RFC 2396

  // define these here so at least they only have to be
  // compiled once on the first module load.
  var protocolPattern = /^([a-z0-9.+-]+:)/i,
    portPattern = /:[0-9]*$/,

    // Special case for a simple path URL
    simplePathPattern = /^(\/\/?(?!\/)[^\?\s]*)(\?[^\s]*)?$/,

    // RFC 2396: characters reserved for delimiting URLs.
    // We actually just auto-escape these.
    delims = ['<', '>', '"', '`', ' ', '\r', '\n', '\t'],

    // RFC 2396: characters not allowed for various reasons.
    unwise = ['{', '}', '|', '\\', '^', '`'].concat(delims),

    // Allowed by RFCs, but cause of XSS attacks.  Always escape these.
    autoEscape = ['\''].concat(unwise),
    // Characters that are never ever allowed in a hostname.
    // Note that any invalid chars are also handled, but these
    // are the ones that are *expected* to be seen, so we fast-path
    // them.
    nonHostChars = ['%', '/', '?', ';', '#'].concat(autoEscape),
    hostEndingChars = ['/', '?', '#'],
    hostnameMaxLen = 255,
    hostnamePartPattern = /^[+a-z0-9A-Z_-]{0,63}$/,
    hostnamePartStart = /^([+a-z0-9A-Z_-]{0,63})(.*)$/,
    // protocols that can allow "unsafe" and "unwise" chars.
    unsafeProtocol = {
      'javascript': true,
      'javascript:': true
    },
    // protocols that never have a hostname.
    hostlessProtocol = {
      'javascript': true,
      'javascript:': true
    },
    // protocols that always contain a // bit.
    slashedProtocol = {
      'http': true,
      'https': true,
      'ftp': true,
      'gopher': true,
      'file': true,
      'http:': true,
      'https:': true,
      'ftp:': true,
      'gopher:': true,
      'file:': true
    };

  function urlParse(url, parseQueryString, slashesDenoteHost) {
    if (url && isObject(url) && url instanceof Url) return url;

    var u = new Url;
    u.parse(url, parseQueryString, slashesDenoteHost);
    return u;
  }
  Url.prototype.parse = function(url, parseQueryString, slashesDenoteHost) {
    return parse$1(this, url, parseQueryString, slashesDenoteHost);
  };

  function parse$1(self, url, parseQueryString, slashesDenoteHost) {
    if (!isString(url)) {
      throw new TypeError('Parameter \'url\' must be a string, not ' + typeof url);
    }

    // Copy chrome, IE, opera backslash-handling behavior.
    // Back slashes before the query string get converted to forward slashes
    // See: https://code.google.com/p/chromium/issues/detail?id=25916
    var queryIndex = url.indexOf('?'),
      splitter =
      (queryIndex !== -1 && queryIndex < url.indexOf('#')) ? '?' : '#',
      uSplit = url.split(splitter),
      slashRegex = /\\/g;
    uSplit[0] = uSplit[0].replace(slashRegex, '/');
    url = uSplit.join(splitter);

    var rest = url;

    // trim before proceeding.
    // This is to support parse stuff like "  http://foo.com  \n"
    rest = rest.trim();

    if (!slashesDenoteHost && url.split('#').length === 1) {
      // Try fast path regexp
      var simplePath = simplePathPattern.exec(rest);
      if (simplePath) {
        self.path = rest;
        self.href = rest;
        self.pathname = simplePath[1];
        if (simplePath[2]) {
          self.search = simplePath[2];
          if (parseQueryString) {
            self.query = parse(self.search.substr(1));
          } else {
            self.query = self.search.substr(1);
          }
        } else if (parseQueryString) {
          self.search = '';
          self.query = {};
        }
        return self;
      }
    }

    var proto = protocolPattern.exec(rest);
    if (proto) {
      proto = proto[0];
      var lowerProto = proto.toLowerCase();
      self.protocol = lowerProto;
      rest = rest.substr(proto.length);
    }

    // figure out if it's got a host
    // user@server is *always* interpreted as a hostname, and url
    // resolution will treat //foo/bar as host=foo,path=bar because that's
    // how the browser resolves relative URLs.
    if (slashesDenoteHost || proto || rest.match(/^\/\/[^@\/]+@[^@\/]+/)) {
      var slashes = rest.substr(0, 2) === '//';
      if (slashes && !(proto && hostlessProtocol[proto])) {
        rest = rest.substr(2);
        self.slashes = true;
      }
    }
    var i, hec, l, p;
    if (!hostlessProtocol[proto] &&
      (slashes || (proto && !slashedProtocol[proto]))) {

      // there's a hostname.
      // the first instance of /, ?, ;, or # ends the host.
      //
      // If there is an @ in the hostname, then non-host chars *are* allowed
      // to the left of the last @ sign, unless some host-ending character
      // comes *before* the @-sign.
      // URLs are obnoxious.
      //
      // ex:
      // http://a@b@c/ => user:a@b host:c
      // http://a@b?@c => user:a host:c path:/?@c

      // v0.12 TODO(isaacs): This is not quite how Chrome does things.
      // Review our test case against browsers more comprehensively.

      // find the first instance of any hostEndingChars
      var hostEnd = -1;
      for (i = 0; i < hostEndingChars.length; i++) {
        hec = rest.indexOf(hostEndingChars[i]);
        if (hec !== -1 && (hostEnd === -1 || hec < hostEnd))
          hostEnd = hec;
      }

      // at this point, either we have an explicit point where the
      // auth portion cannot go past, or the last @ char is the decider.
      var auth, atSign;
      if (hostEnd === -1) {
        // atSign can be anywhere.
        atSign = rest.lastIndexOf('@');
      } else {
        // atSign must be in auth portion.
        // http://a@b/c@d => host:b auth:a path:/c@d
        atSign = rest.lastIndexOf('@', hostEnd);
      }

      // Now we have a portion which is definitely the auth.
      // Pull that off.
      if (atSign !== -1) {
        auth = rest.slice(0, atSign);
        rest = rest.slice(atSign + 1);
        self.auth = decodeURIComponent(auth);
      }

      // the host is the remaining to the left of the first non-host char
      hostEnd = -1;
      for (i = 0; i < nonHostChars.length; i++) {
        hec = rest.indexOf(nonHostChars[i]);
        if (hec !== -1 && (hostEnd === -1 || hec < hostEnd))
          hostEnd = hec;
      }
      // if we still have not hit it, then the entire thing is a host.
      if (hostEnd === -1)
        hostEnd = rest.length;

      self.host = rest.slice(0, hostEnd);
      rest = rest.slice(hostEnd);

      // pull out port.
      parseHost(self);

      // we've indicated that there is a hostname,
      // so even if it's empty, it has to be present.
      self.hostname = self.hostname || '';

      // if hostname begins with [ and ends with ]
      // assume that it's an IPv6 address.
      var ipv6Hostname = self.hostname[0] === '[' &&
        self.hostname[self.hostname.length - 1] === ']';

      // validate a little.
      if (!ipv6Hostname) {
        var hostparts = self.hostname.split(/\./);
        for (i = 0, l = hostparts.length; i < l; i++) {
          var part = hostparts[i];
          if (!part) continue;
          if (!part.match(hostnamePartPattern)) {
            var newpart = '';
            for (var j = 0, k = part.length; j < k; j++) {
              if (part.charCodeAt(j) > 127) {
                // we replace non-ASCII char with a temporary placeholder
                // we need this to make sure size of hostname is not
                // broken by replacing non-ASCII by nothing
                newpart += 'x';
              } else {
                newpart += part[j];
              }
            }
            // we test again with ASCII char only
            if (!newpart.match(hostnamePartPattern)) {
              var validParts = hostparts.slice(0, i);
              var notHost = hostparts.slice(i + 1);
              var bit = part.match(hostnamePartStart);
              if (bit) {
                validParts.push(bit[1]);
                notHost.unshift(bit[2]);
              }
              if (notHost.length) {
                rest = '/' + notHost.join('.') + rest;
              }
              self.hostname = validParts.join('.');
              break;
            }
          }
        }
      }

      if (self.hostname.length > hostnameMaxLen) {
        self.hostname = '';
      } else {
        // hostnames are always lower case.
        self.hostname = self.hostname.toLowerCase();
      }

      if (!ipv6Hostname) {
        // IDNA Support: Returns a punycoded representation of "domain".
        // It only converts parts of the domain name that
        // have non-ASCII characters, i.e. it doesn't matter if
        // you call it with a domain that already is ASCII-only.
        self.hostname = toASCII(self.hostname);
      }

      p = self.port ? ':' + self.port : '';
      var h = self.hostname || '';
      self.host = h + p;
      self.href += self.host;

      // strip [ and ] from the hostname
      // the host field still retains them, though
      if (ipv6Hostname) {
        self.hostname = self.hostname.substr(1, self.hostname.length - 2);
        if (rest[0] !== '/') {
          rest = '/' + rest;
        }
      }
    }

    // now rest is set to the post-host stuff.
    // chop off any delim chars.
    if (!unsafeProtocol[lowerProto]) {

      // First, make 100% sure that any "autoEscape" chars get
      // escaped, even if encodeURIComponent doesn't think they
      // need to be.
      for (i = 0, l = autoEscape.length; i < l; i++) {
        var ae = autoEscape[i];
        if (rest.indexOf(ae) === -1)
          continue;
        var esc = encodeURIComponent(ae);
        if (esc === ae) {
          esc = escape(ae);
        }
        rest = rest.split(ae).join(esc);
      }
    }


    // chop off from the tail first.
    var hash = rest.indexOf('#');
    if (hash !== -1) {
      // got a fragment string.
      self.hash = rest.substr(hash);
      rest = rest.slice(0, hash);
    }
    var qm = rest.indexOf('?');
    if (qm !== -1) {
      self.search = rest.substr(qm);
      self.query = rest.substr(qm + 1);
      if (parseQueryString) {
        self.query = parse(self.query);
      }
      rest = rest.slice(0, qm);
    } else if (parseQueryString) {
      // no query string, but parseQueryString still requested
      self.search = '';
      self.query = {};
    }
    if (rest) self.pathname = rest;
    if (slashedProtocol[lowerProto] &&
      self.hostname && !self.pathname) {
      self.pathname = '/';
    }

    //to support http.request
    if (self.pathname || self.search) {
      p = self.pathname || '';
      var s = self.search || '';
      self.path = p + s;
    }

    // finally, reconstruct the href based on what has been validated.
    self.href = format(self);
    return self;
  }

  // format a parsed object into a url string
  function urlFormat(obj) {
    // ensure it's an object, and not a string url.
    // If it's an obj, this is a no-op.
    // this way, you can call url_format() on strings
    // to clean up potentially wonky urls.
    if (isString(obj)) obj = parse$1({}, obj);
    return format(obj);
  }

  function format(self) {
    var auth = self.auth || '';
    if (auth) {
      auth = encodeURIComponent(auth);
      auth = auth.replace(/%3A/i, ':');
      auth += '@';
    }

    var protocol = self.protocol || '',
      pathname = self.pathname || '',
      hash = self.hash || '',
      host = false,
      query = '';

    if (self.host) {
      host = auth + self.host;
    } else if (self.hostname) {
      host = auth + (self.hostname.indexOf(':') === -1 ?
        self.hostname :
        '[' + this.hostname + ']');
      if (self.port) {
        host += ':' + self.port;
      }
    }

    if (self.query &&
      isObject(self.query) &&
      Object.keys(self.query).length) {
      query = stringify$1(self.query);
    }

    var search = self.search || (query && ('?' + query)) || '';

    if (protocol && protocol.substr(-1) !== ':') protocol += ':';

    // only the slashedProtocols get the //.  Not mailto:, xmpp:, etc.
    // unless they had them to begin with.
    if (self.slashes ||
      (!protocol || slashedProtocol[protocol]) && host !== false) {
      host = '//' + (host || '');
      if (pathname && pathname.charAt(0) !== '/') pathname = '/' + pathname;
    } else if (!host) {
      host = '';
    }

    if (hash && hash.charAt(0) !== '#') hash = '#' + hash;
    if (search && search.charAt(0) !== '?') search = '?' + search;

    pathname = pathname.replace(/[?#]/g, function(match) {
      return encodeURIComponent(match);
    });
    search = search.replace('#', '%23');

    return protocol + host + pathname + search + hash;
  }

  Url.prototype.format = function() {
    return format(this);
  };

  function urlResolve(source, relative) {
    return urlParse(source, false, true).resolve(relative);
  }

  Url.prototype.resolve = function(relative) {
    return this.resolveObject(urlParse(relative, false, true)).format();
  };

  function urlResolveObject(source, relative) {
    if (!source) return relative;
    return urlParse(source, false, true).resolveObject(relative);
  }

  Url.prototype.resolveObject = function(relative) {
    if (isString(relative)) {
      var rel = new Url();
      rel.parse(relative, false, true);
      relative = rel;
    }

    var result = new Url();
    var tkeys = Object.keys(this);
    for (var tk = 0; tk < tkeys.length; tk++) {
      var tkey = tkeys[tk];
      result[tkey] = this[tkey];
    }

    // hash is always overridden, no matter what.
    // even href="" will remove it.
    result.hash = relative.hash;

    // if the relative url is empty, then there's nothing left to do here.
    if (relative.href === '') {
      result.href = result.format();
      return result;
    }

    // hrefs like //foo/bar always cut to the protocol.
    if (relative.slashes && !relative.protocol) {
      // take everything except the protocol from relative
      var rkeys = Object.keys(relative);
      for (var rk = 0; rk < rkeys.length; rk++) {
        var rkey = rkeys[rk];
        if (rkey !== 'protocol')
          result[rkey] = relative[rkey];
      }

      //urlParse appends trailing / to urls like http://www.example.com
      if (slashedProtocol[result.protocol] &&
        result.hostname && !result.pathname) {
        result.path = result.pathname = '/';
      }

      result.href = result.format();
      return result;
    }
    var relPath;
    if (relative.protocol && relative.protocol !== result.protocol) {
      // if it's a known url protocol, then changing
      // the protocol does weird things
      // first, if it's not file:, then we MUST have a host,
      // and if there was a path
      // to begin with, then we MUST have a path.
      // if it is file:, then the host is dropped,
      // because that's known to be hostless.
      // anything else is assumed to be absolute.
      if (!slashedProtocol[relative.protocol]) {
        var keys = Object.keys(relative);
        for (var v = 0; v < keys.length; v++) {
          var k = keys[v];
          result[k] = relative[k];
        }
        result.href = result.format();
        return result;
      }

      result.protocol = relative.protocol;
      if (!relative.host && !hostlessProtocol[relative.protocol]) {
        relPath = (relative.pathname || '').split('/');
        while (relPath.length && !(relative.host = relPath.shift()));
        if (!relative.host) relative.host = '';
        if (!relative.hostname) relative.hostname = '';
        if (relPath[0] !== '') relPath.unshift('');
        if (relPath.length < 2) relPath.unshift('');
        result.pathname = relPath.join('/');
      } else {
        result.pathname = relative.pathname;
      }
      result.search = relative.search;
      result.query = relative.query;
      result.host = relative.host || '';
      result.auth = relative.auth;
      result.hostname = relative.hostname || relative.host;
      result.port = relative.port;
      // to support http.request
      if (result.pathname || result.search) {
        var p = result.pathname || '';
        var s = result.search || '';
        result.path = p + s;
      }
      result.slashes = result.slashes || relative.slashes;
      result.href = result.format();
      return result;
    }

    var isSourceAbs = (result.pathname && result.pathname.charAt(0) === '/'),
      isRelAbs = (
        relative.host ||
        relative.pathname && relative.pathname.charAt(0) === '/'
      ),
      mustEndAbs = (isRelAbs || isSourceAbs ||
        (result.host && relative.pathname)),
      removeAllDots = mustEndAbs,
      srcPath = result.pathname && result.pathname.split('/') || [],
      psychotic = result.protocol && !slashedProtocol[result.protocol];
    relPath = relative.pathname && relative.pathname.split('/') || [];
    // if the url is a non-slashed url, then relative
    // links like ../.. should be able
    // to crawl up to the hostname, as well.  This is strange.
    // result.protocol has already been set by now.
    // Later on, put the first path part into the host field.
    if (psychotic) {
      result.hostname = '';
      result.port = null;
      if (result.host) {
        if (srcPath[0] === '') srcPath[0] = result.host;
        else srcPath.unshift(result.host);
      }
      result.host = '';
      if (relative.protocol) {
        relative.hostname = null;
        relative.port = null;
        if (relative.host) {
          if (relPath[0] === '') relPath[0] = relative.host;
          else relPath.unshift(relative.host);
        }
        relative.host = null;
      }
      mustEndAbs = mustEndAbs && (relPath[0] === '' || srcPath[0] === '');
    }
    var authInHost;
    if (isRelAbs) {
      // it's absolute.
      result.host = (relative.host || relative.host === '') ?
        relative.host : result.host;
      result.hostname = (relative.hostname || relative.hostname === '') ?
        relative.hostname : result.hostname;
      result.search = relative.search;
      result.query = relative.query;
      srcPath = relPath;
      // fall through to the dot-handling below.
    } else if (relPath.length) {
      // it's relative
      // throw away the existing file, and take the new path instead.
      if (!srcPath) srcPath = [];
      srcPath.pop();
      srcPath = srcPath.concat(relPath);
      result.search = relative.search;
      result.query = relative.query;
    } else if (!isNullOrUndefined(relative.search)) {
      // just pull out the search.
      // like href='?foo'.
      // Put this after the other two cases because it simplifies the booleans
      if (psychotic) {
        result.hostname = result.host = srcPath.shift();
        //occationaly the auth can get stuck only in host
        //this especially happens in cases like
        //url.resolveObject('mailto:local1@domain1', 'local2@domain2')
        authInHost = result.host && result.host.indexOf('@') > 0 ?
          result.host.split('@') : false;
        if (authInHost) {
          result.auth = authInHost.shift();
          result.host = result.hostname = authInHost.shift();
        }
      }
      result.search = relative.search;
      result.query = relative.query;
      //to support http.request
      if (!isNull(result.pathname) || !isNull(result.search)) {
        result.path = (result.pathname ? result.pathname : '') +
          (result.search ? result.search : '');
      }
      result.href = result.format();
      return result;
    }

    if (!srcPath.length) {
      // no path at all.  easy.
      // we've already handled the other stuff above.
      result.pathname = null;
      //to support http.request
      if (result.search) {
        result.path = '/' + result.search;
      } else {
        result.path = null;
      }
      result.href = result.format();
      return result;
    }

    // if a url ENDs in . or .., then it must get a trailing slash.
    // however, if it ends in anything else non-slashy,
    // then it must NOT get a trailing slash.
    var last = srcPath.slice(-1)[0];
    var hasTrailingSlash = (
      (result.host || relative.host || srcPath.length > 1) &&
      (last === '.' || last === '..') || last === '');

    // strip single dots, resolve double dots to parent dir
    // if the path tries to go above the root, `up` ends up > 0
    var up = 0;
    for (var i = srcPath.length; i >= 0; i--) {
      last = srcPath[i];
      if (last === '.') {
        srcPath.splice(i, 1);
      } else if (last === '..') {
        srcPath.splice(i, 1);
        up++;
      } else if (up) {
        srcPath.splice(i, 1);
        up--;
      }
    }

    // if the path is allowed to go above the root, restore leading ..s
    if (!mustEndAbs && !removeAllDots) {
      for (; up--; up) {
        srcPath.unshift('..');
      }
    }

    if (mustEndAbs && srcPath[0] !== '' &&
      (!srcPath[0] || srcPath[0].charAt(0) !== '/')) {
      srcPath.unshift('');
    }

    if (hasTrailingSlash && (srcPath.join('/').substr(-1) !== '/')) {
      srcPath.push('');
    }

    var isAbsolute = srcPath[0] === '' ||
      (srcPath[0] && srcPath[0].charAt(0) === '/');

    // put the host back
    if (psychotic) {
      result.hostname = result.host = isAbsolute ? '' :
        srcPath.length ? srcPath.shift() : '';
      //occationaly the auth can get stuck only in host
      //this especially happens in cases like
      //url.resolveObject('mailto:local1@domain1', 'local2@domain2')
      authInHost = result.host && result.host.indexOf('@') > 0 ?
        result.host.split('@') : false;
      if (authInHost) {
        result.auth = authInHost.shift();
        result.host = result.hostname = authInHost.shift();
      }
    }

    mustEndAbs = mustEndAbs || (result.host && srcPath.length);

    if (mustEndAbs && !isAbsolute) {
      srcPath.unshift('');
    }

    if (!srcPath.length) {
      result.pathname = null;
      result.path = null;
    } else {
      result.pathname = srcPath.join('/');
    }

    //to support request.http
    if (!isNull(result.pathname) || !isNull(result.search)) {
      result.path = (result.pathname ? result.pathname : '') +
        (result.search ? result.search : '');
    }
    result.auth = relative.auth || result.auth;
    result.slashes = result.slashes || relative.slashes;
    result.href = result.format();
    return result;
  };

  Url.prototype.parseHost = function() {
    return parseHost(this);
  };

  function parseHost(self) {
    var host = self.host;
    var port = portPattern.exec(host);
    if (port) {
      port = port[0];
      if (port !== ':') {
        self.port = port.substr(1);
      }
      host = host.substr(0, host.length - port.length);
    }
    if (host) self.hostname = host;
  }

  var url$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    parse: urlParse,
    resolve: urlResolve,
    resolveObject: urlResolveObject,
    format: urlFormat,
    'default': url,
    Url: Url
  });

  var require$$0 = /*@__PURE__*/getAugmentedNamespace(url$1);

  var url$2 = Object.assign(
    {},
    require$$0,
    {
      pathToFileURL: (path)=> { return `file:///${encodeURIComponent(path)}` },
      fileURLToPath: (fileURL)=> { return decodeURIComponent(fileURL.toString().replace(/^file:\/\/\//, '')) }
    }
  );

  /* -*- Mode: js; js-indent-level: 2; -*- */
  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */

  var intToCharMap = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split('');

  /**
   * Encode an integer in the range of 0 to 63 to a single base 64 digit.
   */
  var encode$1 = function (number) {
    if (0 <= number && number < intToCharMap.length) {
      return intToCharMap[number];
    }
    throw new TypeError("Must be between 0 and 63: " + number);
  };

  /**
   * Decode a single base 64 character code digit to an integer. Returns -1 on
   * failure.
   */
  var decode = function (charCode) {
    var bigA = 65;     // 'A'
    var bigZ = 90;     // 'Z'

    var littleA = 97;  // 'a'
    var littleZ = 122; // 'z'

    var zero = 48;     // '0'
    var nine = 57;     // '9'

    var plus = 43;     // '+'
    var slash = 47;    // '/'

    var littleOffset = 26;
    var numberOffset = 52;

    // 0 - 25: ABCDEFGHIJKLMNOPQRSTUVWXYZ
    if (bigA <= charCode && charCode <= bigZ) {
      return (charCode - bigA);
    }

    // 26 - 51: abcdefghijklmnopqrstuvwxyz
    if (littleA <= charCode && charCode <= littleZ) {
      return (charCode - littleA + littleOffset);
    }

    // 52 - 61: 0123456789
    if (zero <= charCode && charCode <= nine) {
      return (charCode - zero + numberOffset);
    }

    // 62: +
    if (charCode == plus) {
      return 62;
    }

    // 63: /
    if (charCode == slash) {
      return 63;
    }

    // Invalid base64 digit.
    return -1;
  };

  var base64 = {
  	encode: encode$1,
  	decode: decode
  };

  /* -*- Mode: js; js-indent-level: 2; -*- */

  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   *
   * Based on the Base 64 VLQ implementation in Closure Compiler:
   * https://code.google.com/p/closure-compiler/source/browse/trunk/src/com/google/debugging/sourcemap/Base64VLQ.java
   *
   * Copyright 2011 The Closure Compiler Authors. All rights reserved.
   * Redistribution and use in source and binary forms, with or without
   * modification, are permitted provided that the following conditions are
   * met:
   *
   *  * Redistributions of source code must retain the above copyright
   *    notice, this list of conditions and the following disclaimer.
   *  * Redistributions in binary form must reproduce the above
   *    copyright notice, this list of conditions and the following
   *    disclaimer in the documentation and/or other materials provided
   *    with the distribution.
   *  * Neither the name of Google Inc. nor the names of its
   *    contributors may be used to endorse or promote products derived
   *    from this software without specific prior written permission.
   *
   * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
   * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
   * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
   * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
   * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
   * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
   * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
   * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
   */



  // A single base 64 digit can contain 6 bits of data. For the base 64 variable
  // length quantities we use in the source map spec, the first bit is the sign,
  // the next four bits are the actual value, and the 6th bit is the
  // continuation bit. The continuation bit tells us whether there are more
  // digits in this value following this digit.
  //
  //   Continuation
  //   |    Sign
  //   |    |
  //   V    V
  //   101011

  var VLQ_BASE_SHIFT = 5;

  // binary: 100000
  var VLQ_BASE = 1 << VLQ_BASE_SHIFT;

  // binary: 011111
  var VLQ_BASE_MASK = VLQ_BASE - 1;

  // binary: 100000
  var VLQ_CONTINUATION_BIT = VLQ_BASE;

  /**
   * Converts from a two-complement value to a value where the sign bit is
   * placed in the least significant bit.  For example, as decimals:
   *   1 becomes 2 (10 binary), -1 becomes 3 (11 binary)
   *   2 becomes 4 (100 binary), -2 becomes 5 (101 binary)
   */
  function toVLQSigned(aValue) {
    return aValue < 0
      ? ((-aValue) << 1) + 1
      : (aValue << 1) + 0;
  }

  /**
   * Converts to a two-complement value from a value where the sign bit is
   * placed in the least significant bit.  For example, as decimals:
   *   2 (10 binary) becomes 1, 3 (11 binary) becomes -1
   *   4 (100 binary) becomes 2, 5 (101 binary) becomes -2
   */
  function fromVLQSigned(aValue) {
    var isNegative = (aValue & 1) === 1;
    var shifted = aValue >> 1;
    return isNegative
      ? -shifted
      : shifted;
  }

  /**
   * Returns the base 64 VLQ encoded value.
   */
  var encode$2 = function base64VLQ_encode(aValue) {
    var encoded = "";
    var digit;

    var vlq = toVLQSigned(aValue);

    do {
      digit = vlq & VLQ_BASE_MASK;
      vlq >>>= VLQ_BASE_SHIFT;
      if (vlq > 0) {
        // There are still more digits in this value, so we must make sure the
        // continuation bit is marked.
        digit |= VLQ_CONTINUATION_BIT;
      }
      encoded += base64.encode(digit);
    } while (vlq > 0);

    return encoded;
  };

  /**
   * Decodes the next base 64 VLQ value from the given string and returns the
   * value and the rest of the string via the out parameter.
   */
  var decode$1 = function base64VLQ_decode(aStr, aIndex, aOutParam) {
    var strLen = aStr.length;
    var result = 0;
    var shift = 0;
    var continuation, digit;

    do {
      if (aIndex >= strLen) {
        throw new Error("Expected more digits in base 64 VLQ value.");
      }

      digit = base64.decode(aStr.charCodeAt(aIndex++));
      if (digit === -1) {
        throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
      }

      continuation = !!(digit & VLQ_CONTINUATION_BIT);
      digit &= VLQ_BASE_MASK;
      result = result + (digit << shift);
      shift += VLQ_BASE_SHIFT;
    } while (continuation);

    aOutParam.value = fromVLQSigned(result);
    aOutParam.rest = aIndex;
  };

  var base64Vlq = {
  	encode: encode$2,
  	decode: decode$1
  };

  /* -*- Mode: js; js-indent-level: 2; -*- */

  var util = createCommonjsModule(function (module, exports) {
  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */

  /**
   * This is a helper function for getting values from parameter/options
   * objects.
   *
   * @param args The object we are extracting values from
   * @param name The name of the property we are getting.
   * @param defaultValue An optional value to return if the property is missing
   * from the object. If this is not specified and the property is missing, an
   * error will be thrown.
   */
  function getArg(aArgs, aName, aDefaultValue) {
    if (aName in aArgs) {
      return aArgs[aName];
    } else if (arguments.length === 3) {
      return aDefaultValue;
    } else {
      throw new Error('"' + aName + '" is a required argument.');
    }
  }
  exports.getArg = getArg;

  var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/;
  var dataUrlRegexp = /^data:.+\,.+$/;

  function urlParse(aUrl) {
    var match = aUrl.match(urlRegexp);
    if (!match) {
      return null;
    }
    return {
      scheme: match[1],
      auth: match[2],
      host: match[3],
      port: match[4],
      path: match[5]
    };
  }
  exports.urlParse = urlParse;

  function urlGenerate(aParsedUrl) {
    var url = '';
    if (aParsedUrl.scheme) {
      url += aParsedUrl.scheme + ':';
    }
    url += '//';
    if (aParsedUrl.auth) {
      url += aParsedUrl.auth + '@';
    }
    if (aParsedUrl.host) {
      url += aParsedUrl.host;
    }
    if (aParsedUrl.port) {
      url += ":" + aParsedUrl.port;
    }
    if (aParsedUrl.path) {
      url += aParsedUrl.path;
    }
    return url;
  }
  exports.urlGenerate = urlGenerate;

  /**
   * Normalizes a path, or the path portion of a URL:
   *
   * - Replaces consecutive slashes with one slash.
   * - Removes unnecessary '.' parts.
   * - Removes unnecessary '<dir>/..' parts.
   *
   * Based on code in the Node.js 'path' core module.
   *
   * @param aPath The path or url to normalize.
   */
  function normalize(aPath) {
    var path = aPath;
    var url = urlParse(aPath);
    if (url) {
      if (!url.path) {
        return aPath;
      }
      path = url.path;
    }
    var isAbsolute = exports.isAbsolute(path);

    var parts = path.split(/\/+/);
    for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
      part = parts[i];
      if (part === '.') {
        parts.splice(i, 1);
      } else if (part === '..') {
        up++;
      } else if (up > 0) {
        if (part === '') {
          // The first part is blank if the path is absolute. Trying to go
          // above the root is a no-op. Therefore we can remove all '..' parts
          // directly after the root.
          parts.splice(i + 1, up);
          up = 0;
        } else {
          parts.splice(i, 2);
          up--;
        }
      }
    }
    path = parts.join('/');

    if (path === '') {
      path = isAbsolute ? '/' : '.';
    }

    if (url) {
      url.path = path;
      return urlGenerate(url);
    }
    return path;
  }
  exports.normalize = normalize;

  /**
   * Joins two paths/URLs.
   *
   * @param aRoot The root path or URL.
   * @param aPath The path or URL to be joined with the root.
   *
   * - If aPath is a URL or a data URI, aPath is returned, unless aPath is a
   *   scheme-relative URL: Then the scheme of aRoot, if any, is prepended
   *   first.
   * - Otherwise aPath is a path. If aRoot is a URL, then its path portion
   *   is updated with the result and aRoot is returned. Otherwise the result
   *   is returned.
   *   - If aPath is absolute, the result is aPath.
   *   - Otherwise the two paths are joined with a slash.
   * - Joining for example 'http://' and 'www.example.com' is also supported.
   */
  function join(aRoot, aPath) {
    if (aRoot === "") {
      aRoot = ".";
    }
    if (aPath === "") {
      aPath = ".";
    }
    var aPathUrl = urlParse(aPath);
    var aRootUrl = urlParse(aRoot);
    if (aRootUrl) {
      aRoot = aRootUrl.path || '/';
    }

    // `join(foo, '//www.example.org')`
    if (aPathUrl && !aPathUrl.scheme) {
      if (aRootUrl) {
        aPathUrl.scheme = aRootUrl.scheme;
      }
      return urlGenerate(aPathUrl);
    }

    if (aPathUrl || aPath.match(dataUrlRegexp)) {
      return aPath;
    }

    // `join('http://', 'www.example.com')`
    if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
      aRootUrl.host = aPath;
      return urlGenerate(aRootUrl);
    }

    var joined = aPath.charAt(0) === '/'
      ? aPath
      : normalize(aRoot.replace(/\/+$/, '') + '/' + aPath);

    if (aRootUrl) {
      aRootUrl.path = joined;
      return urlGenerate(aRootUrl);
    }
    return joined;
  }
  exports.join = join;

  exports.isAbsolute = function (aPath) {
    return aPath.charAt(0) === '/' || urlRegexp.test(aPath);
  };

  /**
   * Make a path relative to a URL or another path.
   *
   * @param aRoot The root path or URL.
   * @param aPath The path or URL to be made relative to aRoot.
   */
  function relative(aRoot, aPath) {
    if (aRoot === "") {
      aRoot = ".";
    }

    aRoot = aRoot.replace(/\/$/, '');

    // It is possible for the path to be above the root. In this case, simply
    // checking whether the root is a prefix of the path won't work. Instead, we
    // need to remove components from the root one by one, until either we find
    // a prefix that fits, or we run out of components to remove.
    var level = 0;
    while (aPath.indexOf(aRoot + '/') !== 0) {
      var index = aRoot.lastIndexOf("/");
      if (index < 0) {
        return aPath;
      }

      // If the only part of the root that is left is the scheme (i.e. http://,
      // file:///, etc.), one or more slashes (/), or simply nothing at all, we
      // have exhausted all components, so the path is not relative to the root.
      aRoot = aRoot.slice(0, index);
      if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
        return aPath;
      }

      ++level;
    }

    // Make sure we add a "../" for each component we removed from the root.
    return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
  }
  exports.relative = relative;

  var supportsNullProto = (function () {
    var obj = Object.create(null);
    return !('__proto__' in obj);
  }());

  function identity (s) {
    return s;
  }

  /**
   * Because behavior goes wacky when you set `__proto__` on objects, we
   * have to prefix all the strings in our set with an arbitrary character.
   *
   * See https://github.com/mozilla/source-map/pull/31 and
   * https://github.com/mozilla/source-map/issues/30
   *
   * @param String aStr
   */
  function toSetString(aStr) {
    if (isProtoString(aStr)) {
      return '$' + aStr;
    }

    return aStr;
  }
  exports.toSetString = supportsNullProto ? identity : toSetString;

  function fromSetString(aStr) {
    if (isProtoString(aStr)) {
      return aStr.slice(1);
    }

    return aStr;
  }
  exports.fromSetString = supportsNullProto ? identity : fromSetString;

  function isProtoString(s) {
    if (!s) {
      return false;
    }

    var length = s.length;

    if (length < 9 /* "__proto__".length */) {
      return false;
    }

    if (s.charCodeAt(length - 1) !== 95  /* '_' */ ||
        s.charCodeAt(length - 2) !== 95  /* '_' */ ||
        s.charCodeAt(length - 3) !== 111 /* 'o' */ ||
        s.charCodeAt(length - 4) !== 116 /* 't' */ ||
        s.charCodeAt(length - 5) !== 111 /* 'o' */ ||
        s.charCodeAt(length - 6) !== 114 /* 'r' */ ||
        s.charCodeAt(length - 7) !== 112 /* 'p' */ ||
        s.charCodeAt(length - 8) !== 95  /* '_' */ ||
        s.charCodeAt(length - 9) !== 95  /* '_' */) {
      return false;
    }

    for (var i = length - 10; i >= 0; i--) {
      if (s.charCodeAt(i) !== 36 /* '$' */) {
        return false;
      }
    }

    return true;
  }

  /**
   * Comparator between two mappings where the original positions are compared.
   *
   * Optionally pass in `true` as `onlyCompareGenerated` to consider two
   * mappings with the same original source/line/column, but different generated
   * line and column the same. Useful when searching for a mapping with a
   * stubbed out mapping.
   */
  function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
    var cmp = strcmp(mappingA.source, mappingB.source);
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.originalLine - mappingB.originalLine;
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.originalColumn - mappingB.originalColumn;
    if (cmp !== 0 || onlyCompareOriginal) {
      return cmp;
    }

    cmp = mappingA.generatedColumn - mappingB.generatedColumn;
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.generatedLine - mappingB.generatedLine;
    if (cmp !== 0) {
      return cmp;
    }

    return strcmp(mappingA.name, mappingB.name);
  }
  exports.compareByOriginalPositions = compareByOriginalPositions;

  /**
   * Comparator between two mappings with deflated source and name indices where
   * the generated positions are compared.
   *
   * Optionally pass in `true` as `onlyCompareGenerated` to consider two
   * mappings with the same generated line and column, but different
   * source/name/original line and column the same. Useful when searching for a
   * mapping with a stubbed out mapping.
   */
  function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
    var cmp = mappingA.generatedLine - mappingB.generatedLine;
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.generatedColumn - mappingB.generatedColumn;
    if (cmp !== 0 || onlyCompareGenerated) {
      return cmp;
    }

    cmp = strcmp(mappingA.source, mappingB.source);
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.originalLine - mappingB.originalLine;
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.originalColumn - mappingB.originalColumn;
    if (cmp !== 0) {
      return cmp;
    }

    return strcmp(mappingA.name, mappingB.name);
  }
  exports.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;

  function strcmp(aStr1, aStr2) {
    if (aStr1 === aStr2) {
      return 0;
    }

    if (aStr1 === null) {
      return 1; // aStr2 !== null
    }

    if (aStr2 === null) {
      return -1; // aStr1 !== null
    }

    if (aStr1 > aStr2) {
      return 1;
    }

    return -1;
  }

  /**
   * Comparator between two mappings with inflated source and name strings where
   * the generated positions are compared.
   */
  function compareByGeneratedPositionsInflated(mappingA, mappingB) {
    var cmp = mappingA.generatedLine - mappingB.generatedLine;
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.generatedColumn - mappingB.generatedColumn;
    if (cmp !== 0) {
      return cmp;
    }

    cmp = strcmp(mappingA.source, mappingB.source);
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.originalLine - mappingB.originalLine;
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.originalColumn - mappingB.originalColumn;
    if (cmp !== 0) {
      return cmp;
    }

    return strcmp(mappingA.name, mappingB.name);
  }
  exports.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;

  /**
   * Strip any JSON XSSI avoidance prefix from the string (as documented
   * in the source maps specification), and then parse the string as
   * JSON.
   */
  function parseSourceMapInput(str) {
    return JSON.parse(str.replace(/^\)]}'[^\n]*\n/, ''));
  }
  exports.parseSourceMapInput = parseSourceMapInput;

  /**
   * Compute the URL of a source given the the source root, the source's
   * URL, and the source map's URL.
   */
  function computeSourceURL(sourceRoot, sourceURL, sourceMapURL) {
    sourceURL = sourceURL || '';

    if (sourceRoot) {
      // This follows what Chrome does.
      if (sourceRoot[sourceRoot.length - 1] !== '/' && sourceURL[0] !== '/') {
        sourceRoot += '/';
      }
      // The spec says:
      //   Line 4: An optional source root, useful for relocating source
      //   files on a server or removing repeated values in the
      //   “sources” entry.  This value is prepended to the individual
      //   entries in the “source” field.
      sourceURL = sourceRoot + sourceURL;
    }

    // Historically, SourceMapConsumer did not take the sourceMapURL as
    // a parameter.  This mode is still somewhat supported, which is why
    // this code block is conditional.  However, it's preferable to pass
    // the source map URL to SourceMapConsumer, so that this function
    // can implement the source URL resolution algorithm as outlined in
    // the spec.  This block is basically the equivalent of:
    //    new URL(sourceURL, sourceMapURL).toString()
    // ... except it avoids using URL, which wasn't available in the
    // older releases of node still supported by this library.
    //
    // The spec says:
    //   If the sources are not absolute URLs after prepending of the
    //   “sourceRoot”, the sources are resolved relative to the
    //   SourceMap (like resolving script src in a html document).
    if (sourceMapURL) {
      var parsed = urlParse(sourceMapURL);
      if (!parsed) {
        throw new Error("sourceMapURL could not be parsed");
      }
      if (parsed.path) {
        // Strip the last path component, but keep the "/".
        var index = parsed.path.lastIndexOf('/');
        if (index >= 0) {
          parsed.path = parsed.path.substring(0, index + 1);
        }
      }
      sourceURL = join(urlGenerate(parsed), sourceURL);
    }

    return normalize(sourceURL);
  }
  exports.computeSourceURL = computeSourceURL;
  });

  /* -*- Mode: js; js-indent-level: 2; -*- */

  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */


  var has = Object.prototype.hasOwnProperty;
  var hasNativeMap = typeof Map !== "undefined";

  /**
   * A data structure which is a combination of an array and a set. Adding a new
   * member is O(1), testing for membership is O(1), and finding the index of an
   * element is O(1). Removing elements from the set is not supported. Only
   * strings are supported for membership.
   */
  function ArraySet() {
    this._array = [];
    this._set = hasNativeMap ? new Map() : Object.create(null);
  }

  /**
   * Static method for creating ArraySet instances from an existing array.
   */
  ArraySet.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
    var set = new ArraySet();
    for (var i = 0, len = aArray.length; i < len; i++) {
      set.add(aArray[i], aAllowDuplicates);
    }
    return set;
  };

  /**
   * Return how many unique items are in this ArraySet. If duplicates have been
   * added, than those do not count towards the size.
   *
   * @returns Number
   */
  ArraySet.prototype.size = function ArraySet_size() {
    return hasNativeMap ? this._set.size : Object.getOwnPropertyNames(this._set).length;
  };

  /**
   * Add the given string to this set.
   *
   * @param String aStr
   */
  ArraySet.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
    var sStr = hasNativeMap ? aStr : util.toSetString(aStr);
    var isDuplicate = hasNativeMap ? this.has(aStr) : has.call(this._set, sStr);
    var idx = this._array.length;
    if (!isDuplicate || aAllowDuplicates) {
      this._array.push(aStr);
    }
    if (!isDuplicate) {
      if (hasNativeMap) {
        this._set.set(aStr, idx);
      } else {
        this._set[sStr] = idx;
      }
    }
  };

  /**
   * Is the given string a member of this set?
   *
   * @param String aStr
   */
  ArraySet.prototype.has = function ArraySet_has(aStr) {
    if (hasNativeMap) {
      return this._set.has(aStr);
    } else {
      var sStr = util.toSetString(aStr);
      return has.call(this._set, sStr);
    }
  };

  /**
   * What is the index of the given string in the array?
   *
   * @param String aStr
   */
  ArraySet.prototype.indexOf = function ArraySet_indexOf(aStr) {
    if (hasNativeMap) {
      var idx = this._set.get(aStr);
      if (idx >= 0) {
          return idx;
      }
    } else {
      var sStr = util.toSetString(aStr);
      if (has.call(this._set, sStr)) {
        return this._set[sStr];
      }
    }

    throw new Error('"' + aStr + '" is not in the set.');
  };

  /**
   * What is the element at the given index?
   *
   * @param Number aIdx
   */
  ArraySet.prototype.at = function ArraySet_at(aIdx) {
    if (aIdx >= 0 && aIdx < this._array.length) {
      return this._array[aIdx];
    }
    throw new Error('No element indexed by ' + aIdx);
  };

  /**
   * Returns the array representation of this set (which has the proper indices
   * indicated by indexOf). Note that this is a copy of the internal array used
   * for storing the members so that no one can mess with internal state.
   */
  ArraySet.prototype.toArray = function ArraySet_toArray() {
    return this._array.slice();
  };

  var ArraySet_1 = ArraySet;

  var arraySet = {
  	ArraySet: ArraySet_1
  };

  /* -*- Mode: js; js-indent-level: 2; -*- */

  /*
   * Copyright 2014 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */



  /**
   * Determine whether mappingB is after mappingA with respect to generated
   * position.
   */
  function generatedPositionAfter(mappingA, mappingB) {
    // Optimized for most common case
    var lineA = mappingA.generatedLine;
    var lineB = mappingB.generatedLine;
    var columnA = mappingA.generatedColumn;
    var columnB = mappingB.generatedColumn;
    return lineB > lineA || lineB == lineA && columnB >= columnA ||
           util.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
  }

  /**
   * A data structure to provide a sorted view of accumulated mappings in a
   * performance conscious manner. It trades a neglibable overhead in general
   * case for a large speedup in case of mappings being added in order.
   */
  function MappingList() {
    this._array = [];
    this._sorted = true;
    // Serves as infimum
    this._last = {generatedLine: -1, generatedColumn: 0};
  }

  /**
   * Iterate through internal items. This method takes the same arguments that
   * `Array.prototype.forEach` takes.
   *
   * NOTE: The order of the mappings is NOT guaranteed.
   */
  MappingList.prototype.unsortedForEach =
    function MappingList_forEach(aCallback, aThisArg) {
      this._array.forEach(aCallback, aThisArg);
    };

  /**
   * Add the given source mapping.
   *
   * @param Object aMapping
   */
  MappingList.prototype.add = function MappingList_add(aMapping) {
    if (generatedPositionAfter(this._last, aMapping)) {
      this._last = aMapping;
      this._array.push(aMapping);
    } else {
      this._sorted = false;
      this._array.push(aMapping);
    }
  };

  /**
   * Returns the flat, sorted array of mappings. The mappings are sorted by
   * generated position.
   *
   * WARNING: This method returns internal data without copying, for
   * performance. The return value must NOT be mutated, and should be treated as
   * an immutable borrow. If you want to take ownership, you must make your own
   * copy.
   */
  MappingList.prototype.toArray = function MappingList_toArray() {
    if (!this._sorted) {
      this._array.sort(util.compareByGeneratedPositionsInflated);
      this._sorted = true;
    }
    return this._array;
  };

  var MappingList_1 = MappingList;

  var mappingList = {
  	MappingList: MappingList_1
  };

  /* -*- Mode: js; js-indent-level: 2; -*- */

  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */



  var ArraySet$1 = arraySet.ArraySet;
  var MappingList$1 = mappingList.MappingList;

  /**
   * An instance of the SourceMapGenerator represents a source map which is
   * being built incrementally. You may pass an object with the following
   * properties:
   *
   *   - file: The filename of the generated source.
   *   - sourceRoot: A root for all relative URLs in this source map.
   */
  function SourceMapGenerator(aArgs) {
    if (!aArgs) {
      aArgs = {};
    }
    this._file = util.getArg(aArgs, 'file', null);
    this._sourceRoot = util.getArg(aArgs, 'sourceRoot', null);
    this._skipValidation = util.getArg(aArgs, 'skipValidation', false);
    this._sources = new ArraySet$1();
    this._names = new ArraySet$1();
    this._mappings = new MappingList$1();
    this._sourcesContents = null;
  }

  SourceMapGenerator.prototype._version = 3;

  /**
   * Creates a new SourceMapGenerator based on a SourceMapConsumer
   *
   * @param aSourceMapConsumer The SourceMap.
   */
  SourceMapGenerator.fromSourceMap =
    function SourceMapGenerator_fromSourceMap(aSourceMapConsumer) {
      var sourceRoot = aSourceMapConsumer.sourceRoot;
      var generator = new SourceMapGenerator({
        file: aSourceMapConsumer.file,
        sourceRoot: sourceRoot
      });
      aSourceMapConsumer.eachMapping(function (mapping) {
        var newMapping = {
          generated: {
            line: mapping.generatedLine,
            column: mapping.generatedColumn
          }
        };

        if (mapping.source != null) {
          newMapping.source = mapping.source;
          if (sourceRoot != null) {
            newMapping.source = util.relative(sourceRoot, newMapping.source);
          }

          newMapping.original = {
            line: mapping.originalLine,
            column: mapping.originalColumn
          };

          if (mapping.name != null) {
            newMapping.name = mapping.name;
          }
        }

        generator.addMapping(newMapping);
      });
      aSourceMapConsumer.sources.forEach(function (sourceFile) {
        var sourceRelative = sourceFile;
        if (sourceRoot !== null) {
          sourceRelative = util.relative(sourceRoot, sourceFile);
        }

        if (!generator._sources.has(sourceRelative)) {
          generator._sources.add(sourceRelative);
        }

        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          generator.setSourceContent(sourceFile, content);
        }
      });
      return generator;
    };

  /**
   * Add a single mapping from original source line and column to the generated
   * source's line and column for this source map being created. The mapping
   * object should have the following properties:
   *
   *   - generated: An object with the generated line and column positions.
   *   - original: An object with the original line and column positions.
   *   - source: The original source file (relative to the sourceRoot).
   *   - name: An optional original token name for this mapping.
   */
  SourceMapGenerator.prototype.addMapping =
    function SourceMapGenerator_addMapping(aArgs) {
      var generated = util.getArg(aArgs, 'generated');
      var original = util.getArg(aArgs, 'original', null);
      var source = util.getArg(aArgs, 'source', null);
      var name = util.getArg(aArgs, 'name', null);

      if (!this._skipValidation) {
        this._validateMapping(generated, original, source, name);
      }

      if (source != null) {
        source = String(source);
        if (!this._sources.has(source)) {
          this._sources.add(source);
        }
      }

      if (name != null) {
        name = String(name);
        if (!this._names.has(name)) {
          this._names.add(name);
        }
      }

      this._mappings.add({
        generatedLine: generated.line,
        generatedColumn: generated.column,
        originalLine: original != null && original.line,
        originalColumn: original != null && original.column,
        source: source,
        name: name
      });
    };

  /**
   * Set the source content for a source file.
   */
  SourceMapGenerator.prototype.setSourceContent =
    function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
      var source = aSourceFile;
      if (this._sourceRoot != null) {
        source = util.relative(this._sourceRoot, source);
      }

      if (aSourceContent != null) {
        // Add the source content to the _sourcesContents map.
        // Create a new _sourcesContents map if the property is null.
        if (!this._sourcesContents) {
          this._sourcesContents = Object.create(null);
        }
        this._sourcesContents[util.toSetString(source)] = aSourceContent;
      } else if (this._sourcesContents) {
        // Remove the source file from the _sourcesContents map.
        // If the _sourcesContents map is empty, set the property to null.
        delete this._sourcesContents[util.toSetString(source)];
        if (Object.keys(this._sourcesContents).length === 0) {
          this._sourcesContents = null;
        }
      }
    };

  /**
   * Applies the mappings of a sub-source-map for a specific source file to the
   * source map being generated. Each mapping to the supplied source file is
   * rewritten using the supplied source map. Note: The resolution for the
   * resulting mappings is the minimium of this map and the supplied map.
   *
   * @param aSourceMapConsumer The source map to be applied.
   * @param aSourceFile Optional. The filename of the source file.
   *        If omitted, SourceMapConsumer's file property will be used.
   * @param aSourceMapPath Optional. The dirname of the path to the source map
   *        to be applied. If relative, it is relative to the SourceMapConsumer.
   *        This parameter is needed when the two source maps aren't in the same
   *        directory, and the source map to be applied contains relative source
   *        paths. If so, those relative source paths need to be rewritten
   *        relative to the SourceMapGenerator.
   */
  SourceMapGenerator.prototype.applySourceMap =
    function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
      var sourceFile = aSourceFile;
      // If aSourceFile is omitted, we will use the file property of the SourceMap
      if (aSourceFile == null) {
        if (aSourceMapConsumer.file == null) {
          throw new Error(
            'SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, ' +
            'or the source map\'s "file" property. Both were omitted.'
          );
        }
        sourceFile = aSourceMapConsumer.file;
      }
      var sourceRoot = this._sourceRoot;
      // Make "sourceFile" relative if an absolute Url is passed.
      if (sourceRoot != null) {
        sourceFile = util.relative(sourceRoot, sourceFile);
      }
      // Applying the SourceMap can add and remove items from the sources and
      // the names array.
      var newSources = new ArraySet$1();
      var newNames = new ArraySet$1();

      // Find mappings for the "sourceFile"
      this._mappings.unsortedForEach(function (mapping) {
        if (mapping.source === sourceFile && mapping.originalLine != null) {
          // Check if it can be mapped by the source map, then update the mapping.
          var original = aSourceMapConsumer.originalPositionFor({
            line: mapping.originalLine,
            column: mapping.originalColumn
          });
          if (original.source != null) {
            // Copy mapping
            mapping.source = original.source;
            if (aSourceMapPath != null) {
              mapping.source = util.join(aSourceMapPath, mapping.source);
            }
            if (sourceRoot != null) {
              mapping.source = util.relative(sourceRoot, mapping.source);
            }
            mapping.originalLine = original.line;
            mapping.originalColumn = original.column;
            if (original.name != null) {
              mapping.name = original.name;
            }
          }
        }

        var source = mapping.source;
        if (source != null && !newSources.has(source)) {
          newSources.add(source);
        }

        var name = mapping.name;
        if (name != null && !newNames.has(name)) {
          newNames.add(name);
        }

      }, this);
      this._sources = newSources;
      this._names = newNames;

      // Copy sourcesContents of applied map.
      aSourceMapConsumer.sources.forEach(function (sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          if (aSourceMapPath != null) {
            sourceFile = util.join(aSourceMapPath, sourceFile);
          }
          if (sourceRoot != null) {
            sourceFile = util.relative(sourceRoot, sourceFile);
          }
          this.setSourceContent(sourceFile, content);
        }
      }, this);
    };

  /**
   * A mapping can have one of the three levels of data:
   *
   *   1. Just the generated position.
   *   2. The Generated position, original position, and original source.
   *   3. Generated and original position, original source, as well as a name
   *      token.
   *
   * To maintain consistency, we validate that any new mapping being added falls
   * in to one of these categories.
   */
  SourceMapGenerator.prototype._validateMapping =
    function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource,
                                                aName) {
      // When aOriginal is truthy but has empty values for .line and .column,
      // it is most likely a programmer error. In this case we throw a very
      // specific error message to try to guide them the right way.
      // For example: https://github.com/Polymer/polymer-bundler/pull/519
      if (aOriginal && typeof aOriginal.line !== 'number' && typeof aOriginal.column !== 'number') {
          throw new Error(
              'original.line and original.column are not numbers -- you probably meant to omit ' +
              'the original mapping entirely and only map the generated position. If so, pass ' +
              'null for the original mapping instead of an object with empty or null values.'
          );
      }

      if (aGenerated && 'line' in aGenerated && 'column' in aGenerated
          && aGenerated.line > 0 && aGenerated.column >= 0
          && !aOriginal && !aSource && !aName) {
        // Case 1.
        return;
      }
      else if (aGenerated && 'line' in aGenerated && 'column' in aGenerated
               && aOriginal && 'line' in aOriginal && 'column' in aOriginal
               && aGenerated.line > 0 && aGenerated.column >= 0
               && aOriginal.line > 0 && aOriginal.column >= 0
               && aSource) {
        // Cases 2 and 3.
        return;
      }
      else {
        throw new Error('Invalid mapping: ' + JSON.stringify({
          generated: aGenerated,
          source: aSource,
          original: aOriginal,
          name: aName
        }));
      }
    };

  /**
   * Serialize the accumulated mappings in to the stream of base 64 VLQs
   * specified by the source map format.
   */
  SourceMapGenerator.prototype._serializeMappings =
    function SourceMapGenerator_serializeMappings() {
      var previousGeneratedColumn = 0;
      var previousGeneratedLine = 1;
      var previousOriginalColumn = 0;
      var previousOriginalLine = 0;
      var previousName = 0;
      var previousSource = 0;
      var result = '';
      var next;
      var mapping;
      var nameIdx;
      var sourceIdx;

      var mappings = this._mappings.toArray();
      for (var i = 0, len = mappings.length; i < len; i++) {
        mapping = mappings[i];
        next = '';

        if (mapping.generatedLine !== previousGeneratedLine) {
          previousGeneratedColumn = 0;
          while (mapping.generatedLine !== previousGeneratedLine) {
            next += ';';
            previousGeneratedLine++;
          }
        }
        else {
          if (i > 0) {
            if (!util.compareByGeneratedPositionsInflated(mapping, mappings[i - 1])) {
              continue;
            }
            next += ',';
          }
        }

        next += base64Vlq.encode(mapping.generatedColumn
                                   - previousGeneratedColumn);
        previousGeneratedColumn = mapping.generatedColumn;

        if (mapping.source != null) {
          sourceIdx = this._sources.indexOf(mapping.source);
          next += base64Vlq.encode(sourceIdx - previousSource);
          previousSource = sourceIdx;

          // lines are stored 0-based in SourceMap spec version 3
          next += base64Vlq.encode(mapping.originalLine - 1
                                     - previousOriginalLine);
          previousOriginalLine = mapping.originalLine - 1;

          next += base64Vlq.encode(mapping.originalColumn
                                     - previousOriginalColumn);
          previousOriginalColumn = mapping.originalColumn;

          if (mapping.name != null) {
            nameIdx = this._names.indexOf(mapping.name);
            next += base64Vlq.encode(nameIdx - previousName);
            previousName = nameIdx;
          }
        }

        result += next;
      }

      return result;
    };

  SourceMapGenerator.prototype._generateSourcesContent =
    function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
      return aSources.map(function (source) {
        if (!this._sourcesContents) {
          return null;
        }
        if (aSourceRoot != null) {
          source = util.relative(aSourceRoot, source);
        }
        var key = util.toSetString(source);
        return Object.prototype.hasOwnProperty.call(this._sourcesContents, key)
          ? this._sourcesContents[key]
          : null;
      }, this);
    };

  /**
   * Externalize the source map.
   */
  SourceMapGenerator.prototype.toJSON =
    function SourceMapGenerator_toJSON() {
      var map = {
        version: this._version,
        sources: this._sources.toArray(),
        names: this._names.toArray(),
        mappings: this._serializeMappings()
      };
      if (this._file != null) {
        map.file = this._file;
      }
      if (this._sourceRoot != null) {
        map.sourceRoot = this._sourceRoot;
      }
      if (this._sourcesContents) {
        map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
      }

      return map;
    };

  /**
   * Render the source map being generated to a string.
   */
  SourceMapGenerator.prototype.toString =
    function SourceMapGenerator_toString() {
      return JSON.stringify(this.toJSON());
    };

  var SourceMapGenerator_1 = SourceMapGenerator;

  var sourceMapGenerator = {
  	SourceMapGenerator: SourceMapGenerator_1
  };

  /* -*- Mode: js; js-indent-level: 2; -*- */

  var binarySearch = createCommonjsModule(function (module, exports) {
  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */

  exports.GREATEST_LOWER_BOUND = 1;
  exports.LEAST_UPPER_BOUND = 2;

  /**
   * Recursive implementation of binary search.
   *
   * @param aLow Indices here and lower do not contain the needle.
   * @param aHigh Indices here and higher do not contain the needle.
   * @param aNeedle The element being searched for.
   * @param aHaystack The non-empty array being searched.
   * @param aCompare Function which takes two elements and returns -1, 0, or 1.
   * @param aBias Either 'binarySearch.GREATEST_LOWER_BOUND' or
   *     'binarySearch.LEAST_UPPER_BOUND'. Specifies whether to return the
   *     closest element that is smaller than or greater than the one we are
   *     searching for, respectively, if the exact element cannot be found.
   */
  function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare, aBias) {
    // This function terminates when one of the following is true:
    //
    //   1. We find the exact element we are looking for.
    //
    //   2. We did not find the exact element, but we can return the index of
    //      the next-closest element.
    //
    //   3. We did not find the exact element, and there is no next-closest
    //      element than the one we are searching for, so we return -1.
    var mid = Math.floor((aHigh - aLow) / 2) + aLow;
    var cmp = aCompare(aNeedle, aHaystack[mid], true);
    if (cmp === 0) {
      // Found the element we are looking for.
      return mid;
    }
    else if (cmp > 0) {
      // Our needle is greater than aHaystack[mid].
      if (aHigh - mid > 1) {
        // The element is in the upper half.
        return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
      }

      // The exact needle element was not found in this haystack. Determine if
      // we are in termination case (3) or (2) and return the appropriate thing.
      if (aBias == exports.LEAST_UPPER_BOUND) {
        return aHigh < aHaystack.length ? aHigh : -1;
      } else {
        return mid;
      }
    }
    else {
      // Our needle is less than aHaystack[mid].
      if (mid - aLow > 1) {
        // The element is in the lower half.
        return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
      }

      // we are in termination case (3) or (2) and return the appropriate thing.
      if (aBias == exports.LEAST_UPPER_BOUND) {
        return mid;
      } else {
        return aLow < 0 ? -1 : aLow;
      }
    }
  }

  /**
   * This is an implementation of binary search which will always try and return
   * the index of the closest element if there is no exact hit. This is because
   * mappings between original and generated line/col pairs are single points,
   * and there is an implicit region between each of them, so a miss just means
   * that you aren't on the very start of a region.
   *
   * @param aNeedle The element you are looking for.
   * @param aHaystack The array that is being searched.
   * @param aCompare A function which takes the needle and an element in the
   *     array and returns -1, 0, or 1 depending on whether the needle is less
   *     than, equal to, or greater than the element, respectively.
   * @param aBias Either 'binarySearch.GREATEST_LOWER_BOUND' or
   *     'binarySearch.LEAST_UPPER_BOUND'. Specifies whether to return the
   *     closest element that is smaller than or greater than the one we are
   *     searching for, respectively, if the exact element cannot be found.
   *     Defaults to 'binarySearch.GREATEST_LOWER_BOUND'.
   */
  exports.search = function search(aNeedle, aHaystack, aCompare, aBias) {
    if (aHaystack.length === 0) {
      return -1;
    }

    var index = recursiveSearch(-1, aHaystack.length, aNeedle, aHaystack,
                                aCompare, aBias || exports.GREATEST_LOWER_BOUND);
    if (index < 0) {
      return -1;
    }

    // We have found either the exact element, or the next-closest element than
    // the one we are searching for. However, there may be more than one such
    // element. Make sure we always return the smallest of these.
    while (index - 1 >= 0) {
      if (aCompare(aHaystack[index], aHaystack[index - 1], true) !== 0) {
        break;
      }
      --index;
    }

    return index;
  };
  });

  /* -*- Mode: js; js-indent-level: 2; -*- */
  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */

  // It turns out that some (most?) JavaScript engines don't self-host
  // `Array.prototype.sort`. This makes sense because C++ will likely remain
  // faster than JS when doing raw CPU-intensive sorting. However, when using a
  // custom comparator function, calling back and forth between the VM's C++ and
  // JIT'd JS is rather slow *and* loses JIT type information, resulting in
  // worse generated code for the comparator function than would be optimal. In
  // fact, when sorting with a comparator, these costs outweigh the benefits of
  // sorting in C++. By using our own JS-implemented Quick Sort (below), we get
  // a ~3500ms mean speed-up in `bench/bench.html`.

  /**
   * Swap the elements indexed by `x` and `y` in the array `ary`.
   *
   * @param {Array} ary
   *        The array.
   * @param {Number} x
   *        The index of the first item.
   * @param {Number} y
   *        The index of the second item.
   */
  function swap$1(ary, x, y) {
    var temp = ary[x];
    ary[x] = ary[y];
    ary[y] = temp;
  }

  /**
   * Returns a random integer within the range `low .. high` inclusive.
   *
   * @param {Number} low
   *        The lower bound on the range.
   * @param {Number} high
   *        The upper bound on the range.
   */
  function randomIntInRange(low, high) {
    return Math.round(low + (Math.random() * (high - low)));
  }

  /**
   * The Quick Sort algorithm.
   *
   * @param {Array} ary
   *        An array to sort.
   * @param {function} comparator
   *        Function to use to compare two items.
   * @param {Number} p
   *        Start index of the array
   * @param {Number} r
   *        End index of the array
   */
  function doQuickSort(ary, comparator, p, r) {
    // If our lower bound is less than our upper bound, we (1) partition the
    // array into two pieces and (2) recurse on each half. If it is not, this is
    // the empty array and our base case.

    if (p < r) {
      // (1) Partitioning.
      //
      // The partitioning chooses a pivot between `p` and `r` and moves all
      // elements that are less than or equal to the pivot to the before it, and
      // all the elements that are greater than it after it. The effect is that
      // once partition is done, the pivot is in the exact place it will be when
      // the array is put in sorted order, and it will not need to be moved
      // again. This runs in O(n) time.

      // Always choose a random pivot so that an input array which is reverse
      // sorted does not cause O(n^2) running time.
      var pivotIndex = randomIntInRange(p, r);
      var i = p - 1;

      swap$1(ary, pivotIndex, r);
      var pivot = ary[r];

      // Immediately after `j` is incremented in this loop, the following hold
      // true:
      //
      //   * Every element in `ary[p .. i]` is less than or equal to the pivot.
      //
      //   * Every element in `ary[i+1 .. j-1]` is greater than the pivot.
      for (var j = p; j < r; j++) {
        if (comparator(ary[j], pivot) <= 0) {
          i += 1;
          swap$1(ary, i, j);
        }
      }

      swap$1(ary, i + 1, j);
      var q = i + 1;

      // (2) Recurse on each half.

      doQuickSort(ary, comparator, p, q - 1);
      doQuickSort(ary, comparator, q + 1, r);
    }
  }

  /**
   * Sort the given array in-place with the given comparator function.
   *
   * @param {Array} ary
   *        An array to sort.
   * @param {function} comparator
   *        Function to use to compare two items.
   */
  var quickSort_1 = function (ary, comparator) {
    doQuickSort(ary, comparator, 0, ary.length - 1);
  };

  var quickSort = {
  	quickSort: quickSort_1
  };

  /* -*- Mode: js; js-indent-level: 2; -*- */

  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */



  var ArraySet$2 = arraySet.ArraySet;

  var quickSort$1 = quickSort.quickSort;

  function SourceMapConsumer(aSourceMap, aSourceMapURL) {
    var sourceMap = aSourceMap;
    if (typeof aSourceMap === 'string') {
      sourceMap = util.parseSourceMapInput(aSourceMap);
    }

    return sourceMap.sections != null
      ? new IndexedSourceMapConsumer(sourceMap, aSourceMapURL)
      : new BasicSourceMapConsumer(sourceMap, aSourceMapURL);
  }

  SourceMapConsumer.fromSourceMap = function(aSourceMap, aSourceMapURL) {
    return BasicSourceMapConsumer.fromSourceMap(aSourceMap, aSourceMapURL);
  };

  /**
   * The version of the source mapping spec that we are consuming.
   */
  SourceMapConsumer.prototype._version = 3;

  // `__generatedMappings` and `__originalMappings` are arrays that hold the
  // parsed mapping coordinates from the source map's "mappings" attribute. They
  // are lazily instantiated, accessed via the `_generatedMappings` and
  // `_originalMappings` getters respectively, and we only parse the mappings
  // and create these arrays once queried for a source location. We jump through
  // these hoops because there can be many thousands of mappings, and parsing
  // them is expensive, so we only want to do it if we must.
  //
  // Each object in the arrays is of the form:
  //
  //     {
  //       generatedLine: The line number in the generated code,
  //       generatedColumn: The column number in the generated code,
  //       source: The path to the original source file that generated this
  //               chunk of code,
  //       originalLine: The line number in the original source that
  //                     corresponds to this chunk of generated code,
  //       originalColumn: The column number in the original source that
  //                       corresponds to this chunk of generated code,
  //       name: The name of the original symbol which generated this chunk of
  //             code.
  //     }
  //
  // All properties except for `generatedLine` and `generatedColumn` can be
  // `null`.
  //
  // `_generatedMappings` is ordered by the generated positions.
  //
  // `_originalMappings` is ordered by the original positions.

  SourceMapConsumer.prototype.__generatedMappings = null;
  Object.defineProperty(SourceMapConsumer.prototype, '_generatedMappings', {
    configurable: true,
    enumerable: true,
    get: function () {
      if (!this.__generatedMappings) {
        this._parseMappings(this._mappings, this.sourceRoot);
      }

      return this.__generatedMappings;
    }
  });

  SourceMapConsumer.prototype.__originalMappings = null;
  Object.defineProperty(SourceMapConsumer.prototype, '_originalMappings', {
    configurable: true,
    enumerable: true,
    get: function () {
      if (!this.__originalMappings) {
        this._parseMappings(this._mappings, this.sourceRoot);
      }

      return this.__originalMappings;
    }
  });

  SourceMapConsumer.prototype._charIsMappingSeparator =
    function SourceMapConsumer_charIsMappingSeparator(aStr, index) {
      var c = aStr.charAt(index);
      return c === ";" || c === ",";
    };

  /**
   * Parse the mappings in a string in to a data structure which we can easily
   * query (the ordered arrays in the `this.__generatedMappings` and
   * `this.__originalMappings` properties).
   */
  SourceMapConsumer.prototype._parseMappings =
    function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      throw new Error("Subclasses must implement _parseMappings");
    };

  SourceMapConsumer.GENERATED_ORDER = 1;
  SourceMapConsumer.ORIGINAL_ORDER = 2;

  SourceMapConsumer.GREATEST_LOWER_BOUND = 1;
  SourceMapConsumer.LEAST_UPPER_BOUND = 2;

  /**
   * Iterate over each mapping between an original source/line/column and a
   * generated line/column in this source map.
   *
   * @param Function aCallback
   *        The function that is called with each mapping.
   * @param Object aContext
   *        Optional. If specified, this object will be the value of `this` every
   *        time that `aCallback` is called.
   * @param aOrder
   *        Either `SourceMapConsumer.GENERATED_ORDER` or
   *        `SourceMapConsumer.ORIGINAL_ORDER`. Specifies whether you want to
   *        iterate over the mappings sorted by the generated file's line/column
   *        order or the original's source/line/column order, respectively. Defaults to
   *        `SourceMapConsumer.GENERATED_ORDER`.
   */
  SourceMapConsumer.prototype.eachMapping =
    function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
      var context = aContext || null;
      var order = aOrder || SourceMapConsumer.GENERATED_ORDER;

      var mappings;
      switch (order) {
      case SourceMapConsumer.GENERATED_ORDER:
        mappings = this._generatedMappings;
        break;
      case SourceMapConsumer.ORIGINAL_ORDER:
        mappings = this._originalMappings;
        break;
      default:
        throw new Error("Unknown order of iteration.");
      }

      var sourceRoot = this.sourceRoot;
      mappings.map(function (mapping) {
        var source = mapping.source === null ? null : this._sources.at(mapping.source);
        source = util.computeSourceURL(sourceRoot, source, this._sourceMapURL);
        return {
          source: source,
          generatedLine: mapping.generatedLine,
          generatedColumn: mapping.generatedColumn,
          originalLine: mapping.originalLine,
          originalColumn: mapping.originalColumn,
          name: mapping.name === null ? null : this._names.at(mapping.name)
        };
      }, this).forEach(aCallback, context);
    };

  /**
   * Returns all generated line and column information for the original source,
   * line, and column provided. If no column is provided, returns all mappings
   * corresponding to a either the line we are searching for or the next
   * closest line that has any mappings. Otherwise, returns all mappings
   * corresponding to the given line and either the column we are searching for
   * or the next closest column that has any offsets.
   *
   * The only argument is an object with the following properties:
   *
   *   - source: The filename of the original source.
   *   - line: The line number in the original source.  The line number is 1-based.
   *   - column: Optional. the column number in the original source.
   *    The column number is 0-based.
   *
   * and an array of objects is returned, each with the following properties:
   *
   *   - line: The line number in the generated source, or null.  The
   *    line number is 1-based.
   *   - column: The column number in the generated source, or null.
   *    The column number is 0-based.
   */
  SourceMapConsumer.prototype.allGeneratedPositionsFor =
    function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
      var line = util.getArg(aArgs, 'line');

      // When there is no exact match, BasicSourceMapConsumer.prototype._findMapping
      // returns the index of the closest mapping less than the needle. By
      // setting needle.originalColumn to 0, we thus find the last mapping for
      // the given line, provided such a mapping exists.
      var needle = {
        source: util.getArg(aArgs, 'source'),
        originalLine: line,
        originalColumn: util.getArg(aArgs, 'column', 0)
      };

      needle.source = this._findSourceIndex(needle.source);
      if (needle.source < 0) {
        return [];
      }

      var mappings = [];

      var index = this._findMapping(needle,
                                    this._originalMappings,
                                    "originalLine",
                                    "originalColumn",
                                    util.compareByOriginalPositions,
                                    binarySearch.LEAST_UPPER_BOUND);
      if (index >= 0) {
        var mapping = this._originalMappings[index];

        if (aArgs.column === undefined) {
          var originalLine = mapping.originalLine;

          // Iterate until either we run out of mappings, or we run into
          // a mapping for a different line than the one we found. Since
          // mappings are sorted, this is guaranteed to find all mappings for
          // the line we found.
          while (mapping && mapping.originalLine === originalLine) {
            mappings.push({
              line: util.getArg(mapping, 'generatedLine', null),
              column: util.getArg(mapping, 'generatedColumn', null),
              lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
            });

            mapping = this._originalMappings[++index];
          }
        } else {
          var originalColumn = mapping.originalColumn;

          // Iterate until either we run out of mappings, or we run into
          // a mapping for a different line than the one we were searching for.
          // Since mappings are sorted, this is guaranteed to find all mappings for
          // the line we are searching for.
          while (mapping &&
                 mapping.originalLine === line &&
                 mapping.originalColumn == originalColumn) {
            mappings.push({
              line: util.getArg(mapping, 'generatedLine', null),
              column: util.getArg(mapping, 'generatedColumn', null),
              lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
            });

            mapping = this._originalMappings[++index];
          }
        }
      }

      return mappings;
    };

  var SourceMapConsumer_1 = SourceMapConsumer;

  /**
   * A BasicSourceMapConsumer instance represents a parsed source map which we can
   * query for information about the original file positions by giving it a file
   * position in the generated source.
   *
   * The first parameter is the raw source map (either as a JSON string, or
   * already parsed to an object). According to the spec, source maps have the
   * following attributes:
   *
   *   - version: Which version of the source map spec this map is following.
   *   - sources: An array of URLs to the original source files.
   *   - names: An array of identifiers which can be referrenced by individual mappings.
   *   - sourceRoot: Optional. The URL root from which all sources are relative.
   *   - sourcesContent: Optional. An array of contents of the original source files.
   *   - mappings: A string of base64 VLQs which contain the actual mappings.
   *   - file: Optional. The generated file this source map is associated with.
   *
   * Here is an example source map, taken from the source map spec[0]:
   *
   *     {
   *       version : 3,
   *       file: "out.js",
   *       sourceRoot : "",
   *       sources: ["foo.js", "bar.js"],
   *       names: ["src", "maps", "are", "fun"],
   *       mappings: "AA,AB;;ABCDE;"
   *     }
   *
   * The second parameter, if given, is a string whose value is the URL
   * at which the source map was found.  This URL is used to compute the
   * sources array.
   *
   * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit?pli=1#
   */
  function BasicSourceMapConsumer(aSourceMap, aSourceMapURL) {
    var sourceMap = aSourceMap;
    if (typeof aSourceMap === 'string') {
      sourceMap = util.parseSourceMapInput(aSourceMap);
    }

    var version = util.getArg(sourceMap, 'version');
    var sources = util.getArg(sourceMap, 'sources');
    // Sass 3.3 leaves out the 'names' array, so we deviate from the spec (which
    // requires the array) to play nice here.
    var names = util.getArg(sourceMap, 'names', []);
    var sourceRoot = util.getArg(sourceMap, 'sourceRoot', null);
    var sourcesContent = util.getArg(sourceMap, 'sourcesContent', null);
    var mappings = util.getArg(sourceMap, 'mappings');
    var file = util.getArg(sourceMap, 'file', null);

    // Once again, Sass deviates from the spec and supplies the version as a
    // string rather than a number, so we use loose equality checking here.
    if (version != this._version) {
      throw new Error('Unsupported version: ' + version);
    }

    if (sourceRoot) {
      sourceRoot = util.normalize(sourceRoot);
    }

    sources = sources
      .map(String)
      // Some source maps produce relative source paths like "./foo.js" instead of
      // "foo.js".  Normalize these first so that future comparisons will succeed.
      // See bugzil.la/1090768.
      .map(util.normalize)
      // Always ensure that absolute sources are internally stored relative to
      // the source root, if the source root is absolute. Not doing this would
      // be particularly problematic when the source root is a prefix of the
      // source (valid, but why??). See github issue #199 and bugzil.la/1188982.
      .map(function (source) {
        return sourceRoot && util.isAbsolute(sourceRoot) && util.isAbsolute(source)
          ? util.relative(sourceRoot, source)
          : source;
      });

    // Pass `true` below to allow duplicate names and sources. While source maps
    // are intended to be compressed and deduplicated, the TypeScript compiler
    // sometimes generates source maps with duplicates in them. See Github issue
    // #72 and bugzil.la/889492.
    this._names = ArraySet$2.fromArray(names.map(String), true);
    this._sources = ArraySet$2.fromArray(sources, true);

    this._absoluteSources = this._sources.toArray().map(function (s) {
      return util.computeSourceURL(sourceRoot, s, aSourceMapURL);
    });

    this.sourceRoot = sourceRoot;
    this.sourcesContent = sourcesContent;
    this._mappings = mappings;
    this._sourceMapURL = aSourceMapURL;
    this.file = file;
  }

  BasicSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
  BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer;

  /**
   * Utility function to find the index of a source.  Returns -1 if not
   * found.
   */
  BasicSourceMapConsumer.prototype._findSourceIndex = function(aSource) {
    var relativeSource = aSource;
    if (this.sourceRoot != null) {
      relativeSource = util.relative(this.sourceRoot, relativeSource);
    }

    if (this._sources.has(relativeSource)) {
      return this._sources.indexOf(relativeSource);
    }

    // Maybe aSource is an absolute URL as returned by |sources|.  In
    // this case we can't simply undo the transform.
    var i;
    for (i = 0; i < this._absoluteSources.length; ++i) {
      if (this._absoluteSources[i] == aSource) {
        return i;
      }
    }

    return -1;
  };

  /**
   * Create a BasicSourceMapConsumer from a SourceMapGenerator.
   *
   * @param SourceMapGenerator aSourceMap
   *        The source map that will be consumed.
   * @param String aSourceMapURL
   *        The URL at which the source map can be found (optional)
   * @returns BasicSourceMapConsumer
   */
  BasicSourceMapConsumer.fromSourceMap =
    function SourceMapConsumer_fromSourceMap(aSourceMap, aSourceMapURL) {
      var smc = Object.create(BasicSourceMapConsumer.prototype);

      var names = smc._names = ArraySet$2.fromArray(aSourceMap._names.toArray(), true);
      var sources = smc._sources = ArraySet$2.fromArray(aSourceMap._sources.toArray(), true);
      smc.sourceRoot = aSourceMap._sourceRoot;
      smc.sourcesContent = aSourceMap._generateSourcesContent(smc._sources.toArray(),
                                                              smc.sourceRoot);
      smc.file = aSourceMap._file;
      smc._sourceMapURL = aSourceMapURL;
      smc._absoluteSources = smc._sources.toArray().map(function (s) {
        return util.computeSourceURL(smc.sourceRoot, s, aSourceMapURL);
      });

      // Because we are modifying the entries (by converting string sources and
      // names to indices into the sources and names ArraySets), we have to make
      // a copy of the entry or else bad things happen. Shared mutable state
      // strikes again! See github issue #191.

      var generatedMappings = aSourceMap._mappings.toArray().slice();
      var destGeneratedMappings = smc.__generatedMappings = [];
      var destOriginalMappings = smc.__originalMappings = [];

      for (var i = 0, length = generatedMappings.length; i < length; i++) {
        var srcMapping = generatedMappings[i];
        var destMapping = new Mapping;
        destMapping.generatedLine = srcMapping.generatedLine;
        destMapping.generatedColumn = srcMapping.generatedColumn;

        if (srcMapping.source) {
          destMapping.source = sources.indexOf(srcMapping.source);
          destMapping.originalLine = srcMapping.originalLine;
          destMapping.originalColumn = srcMapping.originalColumn;

          if (srcMapping.name) {
            destMapping.name = names.indexOf(srcMapping.name);
          }

          destOriginalMappings.push(destMapping);
        }

        destGeneratedMappings.push(destMapping);
      }

      quickSort$1(smc.__originalMappings, util.compareByOriginalPositions);

      return smc;
    };

  /**
   * The version of the source mapping spec that we are consuming.
   */
  BasicSourceMapConsumer.prototype._version = 3;

  /**
   * The list of original sources.
   */
  Object.defineProperty(BasicSourceMapConsumer.prototype, 'sources', {
    get: function () {
      return this._absoluteSources.slice();
    }
  });

  /**
   * Provide the JIT with a nice shape / hidden class.
   */
  function Mapping() {
    this.generatedLine = 0;
    this.generatedColumn = 0;
    this.source = null;
    this.originalLine = null;
    this.originalColumn = null;
    this.name = null;
  }

  /**
   * Parse the mappings in a string in to a data structure which we can easily
   * query (the ordered arrays in the `this.__generatedMappings` and
   * `this.__originalMappings` properties).
   */
  BasicSourceMapConsumer.prototype._parseMappings =
    function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      var generatedLine = 1;
      var previousGeneratedColumn = 0;
      var previousOriginalLine = 0;
      var previousOriginalColumn = 0;
      var previousSource = 0;
      var previousName = 0;
      var length = aStr.length;
      var index = 0;
      var cachedSegments = {};
      var temp = {};
      var originalMappings = [];
      var generatedMappings = [];
      var mapping, str, segment, end, value;

      while (index < length) {
        if (aStr.charAt(index) === ';') {
          generatedLine++;
          index++;
          previousGeneratedColumn = 0;
        }
        else if (aStr.charAt(index) === ',') {
          index++;
        }
        else {
          mapping = new Mapping();
          mapping.generatedLine = generatedLine;

          // Because each offset is encoded relative to the previous one,
          // many segments often have the same encoding. We can exploit this
          // fact by caching the parsed variable length fields of each segment,
          // allowing us to avoid a second parse if we encounter the same
          // segment again.
          for (end = index; end < length; end++) {
            if (this._charIsMappingSeparator(aStr, end)) {
              break;
            }
          }
          str = aStr.slice(index, end);

          segment = cachedSegments[str];
          if (segment) {
            index += str.length;
          } else {
            segment = [];
            while (index < end) {
              base64Vlq.decode(aStr, index, temp);
              value = temp.value;
              index = temp.rest;
              segment.push(value);
            }

            if (segment.length === 2) {
              throw new Error('Found a source, but no line and column');
            }

            if (segment.length === 3) {
              throw new Error('Found a source and line, but no column');
            }

            cachedSegments[str] = segment;
          }

          // Generated column.
          mapping.generatedColumn = previousGeneratedColumn + segment[0];
          previousGeneratedColumn = mapping.generatedColumn;

          if (segment.length > 1) {
            // Original source.
            mapping.source = previousSource + segment[1];
            previousSource += segment[1];

            // Original line.
            mapping.originalLine = previousOriginalLine + segment[2];
            previousOriginalLine = mapping.originalLine;
            // Lines are stored 0-based
            mapping.originalLine += 1;

            // Original column.
            mapping.originalColumn = previousOriginalColumn + segment[3];
            previousOriginalColumn = mapping.originalColumn;

            if (segment.length > 4) {
              // Original name.
              mapping.name = previousName + segment[4];
              previousName += segment[4];
            }
          }

          generatedMappings.push(mapping);
          if (typeof mapping.originalLine === 'number') {
            originalMappings.push(mapping);
          }
        }
      }

      quickSort$1(generatedMappings, util.compareByGeneratedPositionsDeflated);
      this.__generatedMappings = generatedMappings;

      quickSort$1(originalMappings, util.compareByOriginalPositions);
      this.__originalMappings = originalMappings;
    };

  /**
   * Find the mapping that best matches the hypothetical "needle" mapping that
   * we are searching for in the given "haystack" of mappings.
   */
  BasicSourceMapConsumer.prototype._findMapping =
    function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName,
                                           aColumnName, aComparator, aBias) {
      // To return the position we are searching for, we must first find the
      // mapping for the given position and then return the opposite position it
      // points to. Because the mappings are sorted, we can use binary search to
      // find the best mapping.

      if (aNeedle[aLineName] <= 0) {
        throw new TypeError('Line must be greater than or equal to 1, got '
                            + aNeedle[aLineName]);
      }
      if (aNeedle[aColumnName] < 0) {
        throw new TypeError('Column must be greater than or equal to 0, got '
                            + aNeedle[aColumnName]);
      }

      return binarySearch.search(aNeedle, aMappings, aComparator, aBias);
    };

  /**
   * Compute the last column for each generated mapping. The last column is
   * inclusive.
   */
  BasicSourceMapConsumer.prototype.computeColumnSpans =
    function SourceMapConsumer_computeColumnSpans() {
      for (var index = 0; index < this._generatedMappings.length; ++index) {
        var mapping = this._generatedMappings[index];

        // Mappings do not contain a field for the last generated columnt. We
        // can come up with an optimistic estimate, however, by assuming that
        // mappings are contiguous (i.e. given two consecutive mappings, the
        // first mapping ends where the second one starts).
        if (index + 1 < this._generatedMappings.length) {
          var nextMapping = this._generatedMappings[index + 1];

          if (mapping.generatedLine === nextMapping.generatedLine) {
            mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
            continue;
          }
        }

        // The last mapping for each line spans the entire line.
        mapping.lastGeneratedColumn = Infinity;
      }
    };

  /**
   * Returns the original source, line, and column information for the generated
   * source's line and column positions provided. The only argument is an object
   * with the following properties:
   *
   *   - line: The line number in the generated source.  The line number
   *     is 1-based.
   *   - column: The column number in the generated source.  The column
   *     number is 0-based.
   *   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
   *     'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
   *     closest element that is smaller than or greater than the one we are
   *     searching for, respectively, if the exact element cannot be found.
   *     Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
   *
   * and an object is returned with the following properties:
   *
   *   - source: The original source file, or null.
   *   - line: The line number in the original source, or null.  The
   *     line number is 1-based.
   *   - column: The column number in the original source, or null.  The
   *     column number is 0-based.
   *   - name: The original identifier, or null.
   */
  BasicSourceMapConsumer.prototype.originalPositionFor =
    function SourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, 'line'),
        generatedColumn: util.getArg(aArgs, 'column')
      };

      var index = this._findMapping(
        needle,
        this._generatedMappings,
        "generatedLine",
        "generatedColumn",
        util.compareByGeneratedPositionsDeflated,
        util.getArg(aArgs, 'bias', SourceMapConsumer.GREATEST_LOWER_BOUND)
      );

      if (index >= 0) {
        var mapping = this._generatedMappings[index];

        if (mapping.generatedLine === needle.generatedLine) {
          var source = util.getArg(mapping, 'source', null);
          if (source !== null) {
            source = this._sources.at(source);
            source = util.computeSourceURL(this.sourceRoot, source, this._sourceMapURL);
          }
          var name = util.getArg(mapping, 'name', null);
          if (name !== null) {
            name = this._names.at(name);
          }
          return {
            source: source,
            line: util.getArg(mapping, 'originalLine', null),
            column: util.getArg(mapping, 'originalColumn', null),
            name: name
          };
        }
      }

      return {
        source: null,
        line: null,
        column: null,
        name: null
      };
    };

  /**
   * Return true if we have the source content for every source in the source
   * map, false otherwise.
   */
  BasicSourceMapConsumer.prototype.hasContentsOfAllSources =
    function BasicSourceMapConsumer_hasContentsOfAllSources() {
      if (!this.sourcesContent) {
        return false;
      }
      return this.sourcesContent.length >= this._sources.size() &&
        !this.sourcesContent.some(function (sc) { return sc == null; });
    };

  /**
   * Returns the original source content. The only argument is the url of the
   * original source file. Returns null if no original source content is
   * available.
   */
  BasicSourceMapConsumer.prototype.sourceContentFor =
    function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      if (!this.sourcesContent) {
        return null;
      }

      var index = this._findSourceIndex(aSource);
      if (index >= 0) {
        return this.sourcesContent[index];
      }

      var relativeSource = aSource;
      if (this.sourceRoot != null) {
        relativeSource = util.relative(this.sourceRoot, relativeSource);
      }

      var url;
      if (this.sourceRoot != null
          && (url = util.urlParse(this.sourceRoot))) {
        // XXX: file:// URIs and absolute paths lead to unexpected behavior for
        // many users. We can help them out when they expect file:// URIs to
        // behave like it would if they were running a local HTTP server. See
        // https://bugzilla.mozilla.org/show_bug.cgi?id=885597.
        var fileUriAbsPath = relativeSource.replace(/^file:\/\//, "");
        if (url.scheme == "file"
            && this._sources.has(fileUriAbsPath)) {
          return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)]
        }

        if ((!url.path || url.path == "/")
            && this._sources.has("/" + relativeSource)) {
          return this.sourcesContent[this._sources.indexOf("/" + relativeSource)];
        }
      }

      // This function is used recursively from
      // IndexedSourceMapConsumer.prototype.sourceContentFor. In that case, we
      // don't want to throw if we can't find the source - we just want to
      // return null, so we provide a flag to exit gracefully.
      if (nullOnMissing) {
        return null;
      }
      else {
        throw new Error('"' + relativeSource + '" is not in the SourceMap.');
      }
    };

  /**
   * Returns the generated line and column information for the original source,
   * line, and column positions provided. The only argument is an object with
   * the following properties:
   *
   *   - source: The filename of the original source.
   *   - line: The line number in the original source.  The line number
   *     is 1-based.
   *   - column: The column number in the original source.  The column
   *     number is 0-based.
   *   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
   *     'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
   *     closest element that is smaller than or greater than the one we are
   *     searching for, respectively, if the exact element cannot be found.
   *     Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
   *
   * and an object is returned with the following properties:
   *
   *   - line: The line number in the generated source, or null.  The
   *     line number is 1-based.
   *   - column: The column number in the generated source, or null.
   *     The column number is 0-based.
   */
  BasicSourceMapConsumer.prototype.generatedPositionFor =
    function SourceMapConsumer_generatedPositionFor(aArgs) {
      var source = util.getArg(aArgs, 'source');
      source = this._findSourceIndex(source);
      if (source < 0) {
        return {
          line: null,
          column: null,
          lastColumn: null
        };
      }

      var needle = {
        source: source,
        originalLine: util.getArg(aArgs, 'line'),
        originalColumn: util.getArg(aArgs, 'column')
      };

      var index = this._findMapping(
        needle,
        this._originalMappings,
        "originalLine",
        "originalColumn",
        util.compareByOriginalPositions,
        util.getArg(aArgs, 'bias', SourceMapConsumer.GREATEST_LOWER_BOUND)
      );

      if (index >= 0) {
        var mapping = this._originalMappings[index];

        if (mapping.source === needle.source) {
          return {
            line: util.getArg(mapping, 'generatedLine', null),
            column: util.getArg(mapping, 'generatedColumn', null),
            lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
          };
        }
      }

      return {
        line: null,
        column: null,
        lastColumn: null
      };
    };

  var BasicSourceMapConsumer_1 = BasicSourceMapConsumer;

  /**
   * An IndexedSourceMapConsumer instance represents a parsed source map which
   * we can query for information. It differs from BasicSourceMapConsumer in
   * that it takes "indexed" source maps (i.e. ones with a "sections" field) as
   * input.
   *
   * The first parameter is a raw source map (either as a JSON string, or already
   * parsed to an object). According to the spec for indexed source maps, they
   * have the following attributes:
   *
   *   - version: Which version of the source map spec this map is following.
   *   - file: Optional. The generated file this source map is associated with.
   *   - sections: A list of section definitions.
   *
   * Each value under the "sections" field has two fields:
   *   - offset: The offset into the original specified at which this section
   *       begins to apply, defined as an object with a "line" and "column"
   *       field.
   *   - map: A source map definition. This source map could also be indexed,
   *       but doesn't have to be.
   *
   * Instead of the "map" field, it's also possible to have a "url" field
   * specifying a URL to retrieve a source map from, but that's currently
   * unsupported.
   *
   * Here's an example source map, taken from the source map spec[0], but
   * modified to omit a section which uses the "url" field.
   *
   *  {
   *    version : 3,
   *    file: "app.js",
   *    sections: [{
   *      offset: {line:100, column:10},
   *      map: {
   *        version : 3,
   *        file: "section.js",
   *        sources: ["foo.js", "bar.js"],
   *        names: ["src", "maps", "are", "fun"],
   *        mappings: "AAAA,E;;ABCDE;"
   *      }
   *    }],
   *  }
   *
   * The second parameter, if given, is a string whose value is the URL
   * at which the source map was found.  This URL is used to compute the
   * sources array.
   *
   * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit#heading=h.535es3xeprgt
   */
  function IndexedSourceMapConsumer(aSourceMap, aSourceMapURL) {
    var sourceMap = aSourceMap;
    if (typeof aSourceMap === 'string') {
      sourceMap = util.parseSourceMapInput(aSourceMap);
    }

    var version = util.getArg(sourceMap, 'version');
    var sections = util.getArg(sourceMap, 'sections');

    if (version != this._version) {
      throw new Error('Unsupported version: ' + version);
    }

    this._sources = new ArraySet$2();
    this._names = new ArraySet$2();

    var lastOffset = {
      line: -1,
      column: 0
    };
    this._sections = sections.map(function (s) {
      if (s.url) {
        // The url field will require support for asynchronicity.
        // See https://github.com/mozilla/source-map/issues/16
        throw new Error('Support for url field in sections not implemented.');
      }
      var offset = util.getArg(s, 'offset');
      var offsetLine = util.getArg(offset, 'line');
      var offsetColumn = util.getArg(offset, 'column');

      if (offsetLine < lastOffset.line ||
          (offsetLine === lastOffset.line && offsetColumn < lastOffset.column)) {
        throw new Error('Section offsets must be ordered and non-overlapping.');
      }
      lastOffset = offset;

      return {
        generatedOffset: {
          // The offset fields are 0-based, but we use 1-based indices when
          // encoding/decoding from VLQ.
          generatedLine: offsetLine + 1,
          generatedColumn: offsetColumn + 1
        },
        consumer: new SourceMapConsumer(util.getArg(s, 'map'), aSourceMapURL)
      }
    });
  }

  IndexedSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
  IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer;

  /**
   * The version of the source mapping spec that we are consuming.
   */
  IndexedSourceMapConsumer.prototype._version = 3;

  /**
   * The list of original sources.
   */
  Object.defineProperty(IndexedSourceMapConsumer.prototype, 'sources', {
    get: function () {
      var sources = [];
      for (var i = 0; i < this._sections.length; i++) {
        for (var j = 0; j < this._sections[i].consumer.sources.length; j++) {
          sources.push(this._sections[i].consumer.sources[j]);
        }
      }
      return sources;
    }
  });

  /**
   * Returns the original source, line, and column information for the generated
   * source's line and column positions provided. The only argument is an object
   * with the following properties:
   *
   *   - line: The line number in the generated source.  The line number
   *     is 1-based.
   *   - column: The column number in the generated source.  The column
   *     number is 0-based.
   *
   * and an object is returned with the following properties:
   *
   *   - source: The original source file, or null.
   *   - line: The line number in the original source, or null.  The
   *     line number is 1-based.
   *   - column: The column number in the original source, or null.  The
   *     column number is 0-based.
   *   - name: The original identifier, or null.
   */
  IndexedSourceMapConsumer.prototype.originalPositionFor =
    function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, 'line'),
        generatedColumn: util.getArg(aArgs, 'column')
      };

      // Find the section containing the generated position we're trying to map
      // to an original position.
      var sectionIndex = binarySearch.search(needle, this._sections,
        function(needle, section) {
          var cmp = needle.generatedLine - section.generatedOffset.generatedLine;
          if (cmp) {
            return cmp;
          }

          return (needle.generatedColumn -
                  section.generatedOffset.generatedColumn);
        });
      var section = this._sections[sectionIndex];

      if (!section) {
        return {
          source: null,
          line: null,
          column: null,
          name: null
        };
      }

      return section.consumer.originalPositionFor({
        line: needle.generatedLine -
          (section.generatedOffset.generatedLine - 1),
        column: needle.generatedColumn -
          (section.generatedOffset.generatedLine === needle.generatedLine
           ? section.generatedOffset.generatedColumn - 1
           : 0),
        bias: aArgs.bias
      });
    };

  /**
   * Return true if we have the source content for every source in the source
   * map, false otherwise.
   */
  IndexedSourceMapConsumer.prototype.hasContentsOfAllSources =
    function IndexedSourceMapConsumer_hasContentsOfAllSources() {
      return this._sections.every(function (s) {
        return s.consumer.hasContentsOfAllSources();
      });
    };

  /**
   * Returns the original source content. The only argument is the url of the
   * original source file. Returns null if no original source content is
   * available.
   */
  IndexedSourceMapConsumer.prototype.sourceContentFor =
    function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];

        var content = section.consumer.sourceContentFor(aSource, true);
        if (content) {
          return content;
        }
      }
      if (nullOnMissing) {
        return null;
      }
      else {
        throw new Error('"' + aSource + '" is not in the SourceMap.');
      }
    };

  /**
   * Returns the generated line and column information for the original source,
   * line, and column positions provided. The only argument is an object with
   * the following properties:
   *
   *   - source: The filename of the original source.
   *   - line: The line number in the original source.  The line number
   *     is 1-based.
   *   - column: The column number in the original source.  The column
   *     number is 0-based.
   *
   * and an object is returned with the following properties:
   *
   *   - line: The line number in the generated source, or null.  The
   *     line number is 1-based. 
   *   - column: The column number in the generated source, or null.
   *     The column number is 0-based.
   */
  IndexedSourceMapConsumer.prototype.generatedPositionFor =
    function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];

        // Only consider this section if the requested source is in the list of
        // sources of the consumer.
        if (section.consumer._findSourceIndex(util.getArg(aArgs, 'source')) === -1) {
          continue;
        }
        var generatedPosition = section.consumer.generatedPositionFor(aArgs);
        if (generatedPosition) {
          var ret = {
            line: generatedPosition.line +
              (section.generatedOffset.generatedLine - 1),
            column: generatedPosition.column +
              (section.generatedOffset.generatedLine === generatedPosition.line
               ? section.generatedOffset.generatedColumn - 1
               : 0)
          };
          return ret;
        }
      }

      return {
        line: null,
        column: null
      };
    };

  /**
   * Parse the mappings in a string in to a data structure which we can easily
   * query (the ordered arrays in the `this.__generatedMappings` and
   * `this.__originalMappings` properties).
   */
  IndexedSourceMapConsumer.prototype._parseMappings =
    function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      this.__generatedMappings = [];
      this.__originalMappings = [];
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        var sectionMappings = section.consumer._generatedMappings;
        for (var j = 0; j < sectionMappings.length; j++) {
          var mapping = sectionMappings[j];

          var source = section.consumer._sources.at(mapping.source);
          source = util.computeSourceURL(section.consumer.sourceRoot, source, this._sourceMapURL);
          this._sources.add(source);
          source = this._sources.indexOf(source);

          var name = null;
          if (mapping.name) {
            name = section.consumer._names.at(mapping.name);
            this._names.add(name);
            name = this._names.indexOf(name);
          }

          // The mappings coming from the consumer for the section have
          // generated positions relative to the start of the section, so we
          // need to offset them to be relative to the start of the concatenated
          // generated file.
          var adjustedMapping = {
            source: source,
            generatedLine: mapping.generatedLine +
              (section.generatedOffset.generatedLine - 1),
            generatedColumn: mapping.generatedColumn +
              (section.generatedOffset.generatedLine === mapping.generatedLine
              ? section.generatedOffset.generatedColumn - 1
              : 0),
            originalLine: mapping.originalLine,
            originalColumn: mapping.originalColumn,
            name: name
          };

          this.__generatedMappings.push(adjustedMapping);
          if (typeof adjustedMapping.originalLine === 'number') {
            this.__originalMappings.push(adjustedMapping);
          }
        }
      }

      quickSort$1(this.__generatedMappings, util.compareByGeneratedPositionsDeflated);
      quickSort$1(this.__originalMappings, util.compareByOriginalPositions);
    };

  var IndexedSourceMapConsumer_1 = IndexedSourceMapConsumer;

  var sourceMapConsumer = {
  	SourceMapConsumer: SourceMapConsumer_1,
  	BasicSourceMapConsumer: BasicSourceMapConsumer_1,
  	IndexedSourceMapConsumer: IndexedSourceMapConsumer_1
  };

  /* -*- Mode: js; js-indent-level: 2; -*- */

  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */

  var SourceMapGenerator$1 = sourceMapGenerator.SourceMapGenerator;


  // Matches a Windows-style `\r\n` newline or a `\n` newline used by all other
  // operating systems these days (capturing the result).
  var REGEX_NEWLINE = /(\r?\n)/;

  // Newline character code for charCodeAt() comparisons
  var NEWLINE_CODE = 10;

  // Private symbol for identifying `SourceNode`s when multiple versions of
  // the source-map library are loaded. This MUST NOT CHANGE across
  // versions!
  var isSourceNode = "$$$isSourceNode$$$";

  /**
   * SourceNodes provide a way to abstract over interpolating/concatenating
   * snippets of generated JavaScript source code while maintaining the line and
   * column information associated with the original source code.
   *
   * @param aLine The original line number.
   * @param aColumn The original column number.
   * @param aSource The original source's filename.
   * @param aChunks Optional. An array of strings which are snippets of
   *        generated JS, or other SourceNodes.
   * @param aName The original identifier.
   */
  function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
    this.children = [];
    this.sourceContents = {};
    this.line = aLine == null ? null : aLine;
    this.column = aColumn == null ? null : aColumn;
    this.source = aSource == null ? null : aSource;
    this.name = aName == null ? null : aName;
    this[isSourceNode] = true;
    if (aChunks != null) this.add(aChunks);
  }

  /**
   * Creates a SourceNode from generated code and a SourceMapConsumer.
   *
   * @param aGeneratedCode The generated code
   * @param aSourceMapConsumer The SourceMap for the generated code
   * @param aRelativePath Optional. The path that relative sources in the
   *        SourceMapConsumer should be relative to.
   */
  SourceNode.fromStringWithSourceMap =
    function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
      // The SourceNode we want to fill with the generated code
      // and the SourceMap
      var node = new SourceNode();

      // All even indices of this array are one line of the generated code,
      // while all odd indices are the newlines between two adjacent lines
      // (since `REGEX_NEWLINE` captures its match).
      // Processed fragments are accessed by calling `shiftNextLine`.
      var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
      var remainingLinesIndex = 0;
      var shiftNextLine = function() {
        var lineContents = getNextLine();
        // The last line of a file might not have a newline.
        var newLine = getNextLine() || "";
        return lineContents + newLine;

        function getNextLine() {
          return remainingLinesIndex < remainingLines.length ?
              remainingLines[remainingLinesIndex++] : undefined;
        }
      };

      // We need to remember the position of "remainingLines"
      var lastGeneratedLine = 1, lastGeneratedColumn = 0;

      // The generate SourceNodes we need a code range.
      // To extract it current and last mapping is used.
      // Here we store the last mapping.
      var lastMapping = null;

      aSourceMapConsumer.eachMapping(function (mapping) {
        if (lastMapping !== null) {
          // We add the code from "lastMapping" to "mapping":
          // First check if there is a new line in between.
          if (lastGeneratedLine < mapping.generatedLine) {
            // Associate first line with "lastMapping"
            addMappingWithCode(lastMapping, shiftNextLine());
            lastGeneratedLine++;
            lastGeneratedColumn = 0;
            // The remaining code is added without mapping
          } else {
            // There is no new line in between.
            // Associate the code between "lastGeneratedColumn" and
            // "mapping.generatedColumn" with "lastMapping"
            var nextLine = remainingLines[remainingLinesIndex] || '';
            var code = nextLine.substr(0, mapping.generatedColumn -
                                          lastGeneratedColumn);
            remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn -
                                                lastGeneratedColumn);
            lastGeneratedColumn = mapping.generatedColumn;
            addMappingWithCode(lastMapping, code);
            // No more remaining code, continue
            lastMapping = mapping;
            return;
          }
        }
        // We add the generated code until the first mapping
        // to the SourceNode without any mapping.
        // Each line is added as separate string.
        while (lastGeneratedLine < mapping.generatedLine) {
          node.add(shiftNextLine());
          lastGeneratedLine++;
        }
        if (lastGeneratedColumn < mapping.generatedColumn) {
          var nextLine = remainingLines[remainingLinesIndex] || '';
          node.add(nextLine.substr(0, mapping.generatedColumn));
          remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn);
          lastGeneratedColumn = mapping.generatedColumn;
        }
        lastMapping = mapping;
      }, this);
      // We have processed all mappings.
      if (remainingLinesIndex < remainingLines.length) {
        if (lastMapping) {
          // Associate the remaining code in the current line with "lastMapping"
          addMappingWithCode(lastMapping, shiftNextLine());
        }
        // and add the remaining lines without any mapping
        node.add(remainingLines.splice(remainingLinesIndex).join(""));
      }

      // Copy sourcesContent into SourceNode
      aSourceMapConsumer.sources.forEach(function (sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          if (aRelativePath != null) {
            sourceFile = util.join(aRelativePath, sourceFile);
          }
          node.setSourceContent(sourceFile, content);
        }
      });

      return node;

      function addMappingWithCode(mapping, code) {
        if (mapping === null || mapping.source === undefined) {
          node.add(code);
        } else {
          var source = aRelativePath
            ? util.join(aRelativePath, mapping.source)
            : mapping.source;
          node.add(new SourceNode(mapping.originalLine,
                                  mapping.originalColumn,
                                  source,
                                  code,
                                  mapping.name));
        }
      }
    };

  /**
   * Add a chunk of generated JS to this source node.
   *
   * @param aChunk A string snippet of generated JS code, another instance of
   *        SourceNode, or an array where each member is one of those things.
   */
  SourceNode.prototype.add = function SourceNode_add(aChunk) {
    if (Array.isArray(aChunk)) {
      aChunk.forEach(function (chunk) {
        this.add(chunk);
      }, this);
    }
    else if (aChunk[isSourceNode] || typeof aChunk === "string") {
      if (aChunk) {
        this.children.push(aChunk);
      }
    }
    else {
      throw new TypeError(
        "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
      );
    }
    return this;
  };

  /**
   * Add a chunk of generated JS to the beginning of this source node.
   *
   * @param aChunk A string snippet of generated JS code, another instance of
   *        SourceNode, or an array where each member is one of those things.
   */
  SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
    if (Array.isArray(aChunk)) {
      for (var i = aChunk.length-1; i >= 0; i--) {
        this.prepend(aChunk[i]);
      }
    }
    else if (aChunk[isSourceNode] || typeof aChunk === "string") {
      this.children.unshift(aChunk);
    }
    else {
      throw new TypeError(
        "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
      );
    }
    return this;
  };

  /**
   * Walk over the tree of JS snippets in this node and its children. The
   * walking function is called once for each snippet of JS and is passed that
   * snippet and the its original associated source's line/column location.
   *
   * @param aFn The traversal function.
   */
  SourceNode.prototype.walk = function SourceNode_walk(aFn) {
    var chunk;
    for (var i = 0, len = this.children.length; i < len; i++) {
      chunk = this.children[i];
      if (chunk[isSourceNode]) {
        chunk.walk(aFn);
      }
      else {
        if (chunk !== '') {
          aFn(chunk, { source: this.source,
                       line: this.line,
                       column: this.column,
                       name: this.name });
        }
      }
    }
  };

  /**
   * Like `String.prototype.join` except for SourceNodes. Inserts `aStr` between
   * each of `this.children`.
   *
   * @param aSep The separator.
   */
  SourceNode.prototype.join = function SourceNode_join(aSep) {
    var newChildren;
    var i;
    var len = this.children.length;
    if (len > 0) {
      newChildren = [];
      for (i = 0; i < len-1; i++) {
        newChildren.push(this.children[i]);
        newChildren.push(aSep);
      }
      newChildren.push(this.children[i]);
      this.children = newChildren;
    }
    return this;
  };

  /**
   * Call String.prototype.replace on the very right-most source snippet. Useful
   * for trimming whitespace from the end of a source node, etc.
   *
   * @param aPattern The pattern to replace.
   * @param aReplacement The thing to replace the pattern with.
   */
  SourceNode.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
    var lastChild = this.children[this.children.length - 1];
    if (lastChild[isSourceNode]) {
      lastChild.replaceRight(aPattern, aReplacement);
    }
    else if (typeof lastChild === 'string') {
      this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
    }
    else {
      this.children.push(''.replace(aPattern, aReplacement));
    }
    return this;
  };

  /**
   * Set the source content for a source file. This will be added to the SourceMapGenerator
   * in the sourcesContent field.
   *
   * @param aSourceFile The filename of the source file
   * @param aSourceContent The content of the source file
   */
  SourceNode.prototype.setSourceContent =
    function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
      this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
    };

  /**
   * Walk over the tree of SourceNodes. The walking function is called for each
   * source file content and is passed the filename and source content.
   *
   * @param aFn The traversal function.
   */
  SourceNode.prototype.walkSourceContents =
    function SourceNode_walkSourceContents(aFn) {
      for (var i = 0, len = this.children.length; i < len; i++) {
        if (this.children[i][isSourceNode]) {
          this.children[i].walkSourceContents(aFn);
        }
      }

      var sources = Object.keys(this.sourceContents);
      for (var i = 0, len = sources.length; i < len; i++) {
        aFn(util.fromSetString(sources[i]), this.sourceContents[sources[i]]);
      }
    };

  /**
   * Return the string representation of this source node. Walks over the tree
   * and concatenates all the various snippets together to one string.
   */
  SourceNode.prototype.toString = function SourceNode_toString() {
    var str = "";
    this.walk(function (chunk) {
      str += chunk;
    });
    return str;
  };

  /**
   * Returns the string representation of this source node along with a source
   * map.
   */
  SourceNode.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
    var generated = {
      code: "",
      line: 1,
      column: 0
    };
    var map = new SourceMapGenerator$1(aArgs);
    var sourceMappingActive = false;
    var lastOriginalSource = null;
    var lastOriginalLine = null;
    var lastOriginalColumn = null;
    var lastOriginalName = null;
    this.walk(function (chunk, original) {
      generated.code += chunk;
      if (original.source !== null
          && original.line !== null
          && original.column !== null) {
        if(lastOriginalSource !== original.source
           || lastOriginalLine !== original.line
           || lastOriginalColumn !== original.column
           || lastOriginalName !== original.name) {
          map.addMapping({
            source: original.source,
            original: {
              line: original.line,
              column: original.column
            },
            generated: {
              line: generated.line,
              column: generated.column
            },
            name: original.name
          });
        }
        lastOriginalSource = original.source;
        lastOriginalLine = original.line;
        lastOriginalColumn = original.column;
        lastOriginalName = original.name;
        sourceMappingActive = true;
      } else if (sourceMappingActive) {
        map.addMapping({
          generated: {
            line: generated.line,
            column: generated.column
          }
        });
        lastOriginalSource = null;
        sourceMappingActive = false;
      }
      for (var idx = 0, length = chunk.length; idx < length; idx++) {
        if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
          generated.line++;
          generated.column = 0;
          // Mappings end at eol
          if (idx + 1 === length) {
            lastOriginalSource = null;
            sourceMappingActive = false;
          } else if (sourceMappingActive) {
            map.addMapping({
              source: original.source,
              original: {
                line: original.line,
                column: original.column
              },
              generated: {
                line: generated.line,
                column: generated.column
              },
              name: original.name
            });
          }
        } else {
          generated.column++;
        }
      }
    });
    this.walkSourceContents(function (sourceFile, sourceContent) {
      map.setSourceContent(sourceFile, sourceContent);
    });

    return { code: generated.code, map: map };
  };

  var SourceNode_1 = SourceNode;

  var sourceNode = {
  	SourceNode: SourceNode_1
  };

  /*
   * Copyright 2009-2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE.txt or:
   * http://opensource.org/licenses/BSD-3-Clause
   */

  var SourceMapGenerator$2 = sourceMapGenerator.SourceMapGenerator;
  var SourceMapConsumer$1 = sourceMapConsumer.SourceMapConsumer;
  var SourceNode$1 = sourceNode.SourceNode;

  var sourceMap = {
  	SourceMapGenerator: SourceMapGenerator$2,
  	SourceMapConsumer: SourceMapConsumer$1,
  	SourceNode: SourceNode$1
  };

  var require$$1 = /*@__PURE__*/getAugmentedNamespace(path$1);

  let { dirname: dirname$1, resolve: resolve$1, relative: relative$1, sep: sep$1 } = require$$1;
  let { pathToFileURL } = url$2;


  class MapGenerator {
    constructor (stringify, root, opts) {
      this.stringify = stringify;
      this.mapOpts = opts.map || {};
      this.root = root;
      this.opts = opts;
    }

    isMap () {
      if (typeof this.opts.map !== 'undefined') {
        return !!this.opts.map
      }
      return this.previous().length > 0
    }

    previous () {
      if (!this.previousMaps) {
        this.previousMaps = [];
        this.root.walk(node => {
          if (node.source && node.source.input.map) {
            let map = node.source.input.map;
            if (!this.previousMaps.includes(map)) {
              this.previousMaps.push(map);
            }
          }
        });
      }

      return this.previousMaps
    }

    isInline () {
      if (typeof this.mapOpts.inline !== 'undefined') {
        return this.mapOpts.inline
      }

      let annotation = this.mapOpts.annotation;
      if (typeof annotation !== 'undefined' && annotation !== true) {
        return false
      }

      if (this.previous().length) {
        return this.previous().some(i => i.inline)
      }
      return true
    }

    isSourcesContent () {
      if (typeof this.mapOpts.sourcesContent !== 'undefined') {
        return this.mapOpts.sourcesContent
      }
      if (this.previous().length) {
        return this.previous().some(i => i.withContent())
      }
      return true
    }

    clearAnnotation () {
      if (this.mapOpts.annotation === false) return

      let node;
      for (let i = this.root.nodes.length - 1; i >= 0; i--) {
        node = this.root.nodes[i];
        if (node.type !== 'comment') continue
        if (node.text.indexOf('# sourceMappingURL=') === 0) {
          this.root.removeChild(i);
        }
      }
    }

    setSourcesContent () {
      let already = {};
      this.root.walk(node => {
        if (node.source) {
          let from = node.source.input.from;
          if (from && !already[from]) {
            already[from] = true;
            this.map.setSourceContent(
              this.toUrl(this.path(from)),
              node.source.input.css
            );
          }
        }
      });
    }

    applyPrevMaps () {
      for (let prev of this.previous()) {
        let from = this.toUrl(this.path(prev.file));
        let root = prev.root || dirname$1(prev.file);
        let map;

        if (this.mapOpts.sourcesContent === false) {
          map = new sourceMap.SourceMapConsumer(prev.text);
          if (map.sourcesContent) {
            map.sourcesContent = map.sourcesContent.map(() => null);
          }
        } else {
          map = prev.consumer();
        }

        this.map.applySourceMap(map, from, this.toUrl(this.path(root)));
      }
    }

    isAnnotation () {
      if (this.isInline()) {
        return true
      }
      if (typeof this.mapOpts.annotation !== 'undefined') {
        return this.mapOpts.annotation
      }
      if (this.previous().length) {
        return this.previous().some(i => i.annotation)
      }
      return true
    }

    toBase64 (str) {
      if (Buffer) {
        return Buffer.from(str).toString('base64')
      } else {
        // istanbul ignore next
        return window.btoa(unescape(encodeURIComponent(str)))
      }
    }

    addAnnotation () {
      let content;

      if (this.isInline()) {
        content =
          'data:application/json;base64,' + this.toBase64(this.map.toString());
      } else if (typeof this.mapOpts.annotation === 'string') {
        content = this.mapOpts.annotation;
      } else if (typeof this.mapOpts.annotation === 'function') {
        content = this.mapOpts.annotation(this.opts.to, this.root);
      } else {
        content = this.outputFile() + '.map';
      }

      let eol = '\n';
      if (this.css.includes('\r\n')) eol = '\r\n';

      this.css += eol + '/*# sourceMappingURL=' + content + ' */';
    }

    outputFile () {
      if (this.opts.to) {
        return this.path(this.opts.to)
      }
      if (this.opts.from) {
        return this.path(this.opts.from)
      }
      return 'to.css'
    }

    generateMap () {
      this.generateString();
      if (this.isSourcesContent()) this.setSourcesContent();
      if (this.previous().length > 0) this.applyPrevMaps();
      if (this.isAnnotation()) this.addAnnotation();

      if (this.isInline()) {
        return [this.css]
      }
      return [this.css, this.map]
    }

    path (file) {
      if (file.indexOf('<') === 0) return file
      if (/^\w+:\/\//.test(file)) return file
      if (this.mapOpts.absolute) return file

      let from = this.opts.to ? dirname$1(this.opts.to) : '.';

      if (typeof this.mapOpts.annotation === 'string') {
        from = dirname$1(resolve$1(from, this.mapOpts.annotation));
      }

      file = relative$1(from, file);
      return file
    }

    toUrl (path) {
      if (sep$1 === '\\') {
        // istanbul ignore next
        path = path.replace(/\\/g, '/');
      }
      return encodeURI(path).replace(/[#?]/g, encodeURIComponent)
    }

    sourcePath (node) {
      if (this.mapOpts.from) {
        return this.toUrl(this.mapOpts.from)
      } else if (this.mapOpts.absolute) {
        return pathToFileURL(node.source.input.from).toString()
      } else {
        return this.toUrl(this.path(node.source.input.from))
      }
    }

    generateString () {
      this.css = '';
      this.map = new sourceMap.SourceMapGenerator({ file: this.outputFile() });

      let line = 1;
      let column = 1;

      let lines, last;
      this.stringify(this.root, (str, node, type) => {
        this.css += str;

        if (node && type !== 'end') {
          if (node.source && node.source.start) {
            this.map.addMapping({
              source: this.sourcePath(node),
              generated: { line, column: column - 1 },
              original: {
                line: node.source.start.line,
                column: node.source.start.column - 1
              }
            });
          } else {
            this.map.addMapping({
              source: '<no source>',
              original: { line: 1, column: 0 },
              generated: { line, column: column - 1 }
            });
          }
        }

        lines = str.match(/\n/g);
        if (lines) {
          line += lines.length;
          last = str.lastIndexOf('\n');
          column = str.length - last;
        } else {
          column += str.length;
        }

        if (node && type !== 'start') {
          let p = node.parent || { raws: {} };
          if (node.type !== 'decl' || node !== p.last || p.raws.semicolon) {
            if (node.source && node.source.end) {
              this.map.addMapping({
                source: this.sourcePath(node),
                generated: { line, column: column - 2 },
                original: {
                  line: node.source.end.line,
                  column: node.source.end.column - 1
                }
              });
            } else {
              this.map.addMapping({
                source: '<no source>',
                original: { line: 1, column: 0 },
                generated: { line, column: column - 1 }
              });
            }
          }
        }
      });
    }

    generate () {
      this.clearAnnotation();

      if (this.isMap()) {
        return this.generateMap()
      }

      let result = '';
      this.stringify(this.root, i => {
        result += i;
      });
      return [result]
    }
  }

  var mapGenerator = MapGenerator;

  let printed = {};

  var warnOnce = function warnOnce (message) {
    if (printed[message]) return
    printed[message] = true;

    if (typeof console !== 'undefined' && console.warn) {
      console.warn(message);
    }
  };

  class Warning {
    constructor (text, opts = {}) {
      this.type = 'warning';
      this.text = text;

      if (opts.node && opts.node.source) {
        let pos = opts.node.positionBy(opts);
        this.line = pos.line;
        this.column = pos.column;
      }

      for (let opt in opts) this[opt] = opts[opt];
    }

    toString () {
      if (this.node) {
        return this.node.error(this.text, {
          plugin: this.plugin,
          index: this.index,
          word: this.word
        }).message
      }

      if (this.plugin) {
        return this.plugin + ': ' + this.text
      }

      return this.text
    }
  }

  var warning = Warning;
  Warning.default = Warning;

  class Result {
    constructor (processor, root, opts) {
      this.processor = processor;
      this.messages = [];
      this.root = root;
      this.opts = opts;
      this.css = undefined;
      this.map = undefined;
    }

    toString () {
      return this.css
    }

    warn (text, opts = {}) {
      if (!opts.plugin) {
        if (this.lastPlugin && this.lastPlugin.postcssPlugin) {
          opts.plugin = this.lastPlugin.postcssPlugin;
        }
      }

      let warning$1 = new warning(text, opts);
      this.messages.push(warning$1);

      return warning$1
    }

    warnings () {
      return this.messages.filter(i => i.type === 'warning')
    }

    get content () {
      return this.css
    }
  }

  var result = Result;
  Result.default = Result;

  class Comment extends node_1 {
    constructor (defaults) {
      super(defaults);
      this.type = 'comment';
    }
  }

  var comment = Comment;
  Comment.default = Comment;

  let { isClean: isClean$2 } = symbols;



  let parse$2, Rule, AtRule;

  function cleanSource (nodes) {
    return nodes.map(i => {
      if (i.nodes) i.nodes = cleanSource(i.nodes);
      delete i.source;
      return i
    })
  }

  function markDirtyUp (node) {
    node[isClean$2] = false;
    if (node.proxyOf.nodes) {
      for (let i of node.proxyOf.nodes) {
        markDirtyUp(i);
      }
    }
  }

  // istanbul ignore next
  function rebuild (node) {
    if (node.type === 'atrule') {
      Object.setPrototypeOf(node, AtRule.prototype);
    } else if (node.type === 'rule') {
      Object.setPrototypeOf(node, Rule.prototype);
    } else if (node.type === 'decl') {
      Object.setPrototypeOf(node, declaration.prototype);
    } else if (node.type === 'comment') {
      Object.setPrototypeOf(node, comment.prototype);
    }

    if (node.nodes) {
      node.nodes.forEach(child => {
        rebuild(child);
      });
    }
  }

  class Container extends node_1 {
    push (child) {
      child.parent = this;
      this.proxyOf.nodes.push(child);
      return this
    }

    each (callback) {
      if (!this.proxyOf.nodes) return undefined
      let iterator = this.getIterator();

      let index, result;
      while (this.indexes[iterator] < this.proxyOf.nodes.length) {
        index = this.indexes[iterator];
        result = callback(this.proxyOf.nodes[index], index);
        if (result === false) break

        this.indexes[iterator] += 1;
      }

      delete this.indexes[iterator];
      return result
    }

    walk (callback) {
      return this.each((child, i) => {
        let result;
        try {
          result = callback(child, i);
        } catch (e) {
          throw child.addToError(e)
        }
        if (result !== false && child.walk) {
          result = child.walk(callback);
        }

        return result
      })
    }

    walkDecls (prop, callback) {
      if (!callback) {
        callback = prop;
        return this.walk((child, i) => {
          if (child.type === 'decl') {
            return callback(child, i)
          }
        })
      }
      if (prop instanceof RegExp) {
        return this.walk((child, i) => {
          if (child.type === 'decl' && prop.test(child.prop)) {
            return callback(child, i)
          }
        })
      }
      return this.walk((child, i) => {
        if (child.type === 'decl' && child.prop === prop) {
          return callback(child, i)
        }
      })
    }

    walkRules (selector, callback) {
      if (!callback) {
        callback = selector;

        return this.walk((child, i) => {
          if (child.type === 'rule') {
            return callback(child, i)
          }
        })
      }
      if (selector instanceof RegExp) {
        return this.walk((child, i) => {
          if (child.type === 'rule' && selector.test(child.selector)) {
            return callback(child, i)
          }
        })
      }
      return this.walk((child, i) => {
        if (child.type === 'rule' && child.selector === selector) {
          return callback(child, i)
        }
      })
    }

    walkAtRules (name, callback) {
      if (!callback) {
        callback = name;
        return this.walk((child, i) => {
          if (child.type === 'atrule') {
            return callback(child, i)
          }
        })
      }
      if (name instanceof RegExp) {
        return this.walk((child, i) => {
          if (child.type === 'atrule' && name.test(child.name)) {
            return callback(child, i)
          }
        })
      }
      return this.walk((child, i) => {
        if (child.type === 'atrule' && child.name === name) {
          return callback(child, i)
        }
      })
    }

    walkComments (callback) {
      return this.walk((child, i) => {
        if (child.type === 'comment') {
          return callback(child, i)
        }
      })
    }

    append (...children) {
      for (let child of children) {
        let nodes = this.normalize(child, this.last);
        for (let node of nodes) this.proxyOf.nodes.push(node);
      }

      this.markDirty();

      return this
    }

    prepend (...children) {
      children = children.reverse();
      for (let child of children) {
        let nodes = this.normalize(child, this.first, 'prepend').reverse();
        for (let node of nodes) this.proxyOf.nodes.unshift(node);
        for (let id in this.indexes) {
          this.indexes[id] = this.indexes[id] + nodes.length;
        }
      }

      this.markDirty();

      return this
    }

    cleanRaws (keepBetween) {
      super.cleanRaws(keepBetween);
      if (this.nodes) {
        for (let node of this.nodes) node.cleanRaws(keepBetween);
      }
    }

    insertBefore (exist, add) {
      exist = this.index(exist);

      let type = exist === 0 ? 'prepend' : false;
      let nodes = this.normalize(add, this.proxyOf.nodes[exist], type).reverse();
      for (let node of nodes) this.proxyOf.nodes.splice(exist, 0, node);

      let index;
      for (let id in this.indexes) {
        index = this.indexes[id];
        if (exist <= index) {
          this.indexes[id] = index + nodes.length;
        }
      }

      this.markDirty();

      return this
    }

    insertAfter (exist, add) {
      exist = this.index(exist);

      let nodes = this.normalize(add, this.proxyOf.nodes[exist]).reverse();
      for (let node of nodes) this.proxyOf.nodes.splice(exist + 1, 0, node);

      let index;
      for (let id in this.indexes) {
        index = this.indexes[id];
        if (exist < index) {
          this.indexes[id] = index + nodes.length;
        }
      }

      this.markDirty();

      return this
    }

    removeChild (child) {
      child = this.index(child);
      this.proxyOf.nodes[child].parent = undefined;
      this.proxyOf.nodes.splice(child, 1);

      let index;
      for (let id in this.indexes) {
        index = this.indexes[id];
        if (index >= child) {
          this.indexes[id] = index - 1;
        }
      }

      this.markDirty();

      return this
    }

    removeAll () {
      for (let node of this.proxyOf.nodes) node.parent = undefined;
      this.proxyOf.nodes = [];

      this.markDirty();

      return this
    }

    replaceValues (pattern, opts, callback) {
      if (!callback) {
        callback = opts;
        opts = {};
      }

      this.walkDecls(decl => {
        if (opts.props && !opts.props.includes(decl.prop)) return
        if (opts.fast && !decl.value.includes(opts.fast)) return

        decl.value = decl.value.replace(pattern, callback);
      });

      this.markDirty();

      return this
    }

    every (condition) {
      return this.nodes.every(condition)
    }

    some (condition) {
      return this.nodes.some(condition)
    }

    index (child) {
      if (typeof child === 'number') return child
      if (child.proxyOf) child = child.proxyOf;
      return this.proxyOf.nodes.indexOf(child)
    }

    get first () {
      if (!this.proxyOf.nodes) return undefined
      return this.proxyOf.nodes[0]
    }

    get last () {
      if (!this.proxyOf.nodes) return undefined
      return this.proxyOf.nodes[this.proxyOf.nodes.length - 1]
    }

    normalize (nodes, sample) {
      if (typeof nodes === 'string') {
        nodes = cleanSource(parse$2(nodes).nodes);
      } else if (Array.isArray(nodes)) {
        nodes = nodes.slice(0);
        for (let i of nodes) {
          if (i.parent) i.parent.removeChild(i, 'ignore');
        }
      } else if (nodes.type === 'root') {
        nodes = nodes.nodes.slice(0);
        for (let i of nodes) {
          if (i.parent) i.parent.removeChild(i, 'ignore');
        }
      } else if (nodes.type) {
        nodes = [nodes];
      } else if (nodes.prop) {
        if (typeof nodes.value === 'undefined') {
          throw new Error('Value field is missed in node creation')
        } else if (typeof nodes.value !== 'string') {
          nodes.value = String(nodes.value);
        }
        nodes = [new declaration(nodes)];
      } else if (nodes.selector) {
        nodes = [new Rule(nodes)];
      } else if (nodes.name) {
        nodes = [new AtRule(nodes)];
      } else if (nodes.text) {
        nodes = [new comment(nodes)];
      } else {
        throw new Error('Unknown node type in node creation')
      }

      let processed = nodes.map(i => {
        // istanbul ignore next
        if (typeof i.markDirty !== 'function') rebuild(i);
        i = i.proxyOf;
        if (i.parent) i.parent.removeChild(i);
        if (i[isClean$2]) markDirtyUp(i);
        if (typeof i.raws.before === 'undefined') {
          if (sample && typeof sample.raws.before !== 'undefined') {
            i.raws.before = sample.raws.before.replace(/\S/g, '');
          }
        }
        i.parent = this;
        return i
      });

      return processed
    }

    getProxyProcessor () {
      return {
        set (node, prop, value) {
          if (node[prop] === value) return true
          node[prop] = value;
          if (prop === 'name' || prop === 'params' || prop === 'selector') {
            node.markDirty();
          }
          return true
        },

        get (node, prop) {
          if (prop === 'proxyOf') {
            return node
          } else if (!node[prop]) {
            return node[prop]
          } else if (
            prop === 'each' ||
            (typeof prop === 'string' && prop.startsWith('walk'))
          ) {
            return (...args) => {
              return node[prop](
                ...args.map(i => {
                  if (typeof i === 'function') {
                    return (child, index) => i(child.toProxy(), index)
                  } else {
                    return i
                  }
                })
              )
            }
          } else if (prop === 'every' || prop === 'some') {
            return cb => {
              return node[prop]((child, ...other) =>
                cb(child.toProxy(), ...other)
              )
            }
          } else if (prop === 'root') {
            return () => node.root().toProxy()
          } else if (prop === 'nodes') {
            return node.nodes.map(i => i.toProxy())
          } else if (prop === 'first' || prop === 'last') {
            return node[prop].toProxy()
          } else {
            return node[prop]
          }
        }
      }
    }

    getIterator () {
      if (!this.lastEach) this.lastEach = 0;
      if (!this.indexes) this.indexes = {};

      this.lastEach += 1;
      let iterator = this.lastEach;
      this.indexes[iterator] = 0;

      return iterator
    }
  }

  Container.registerParse = dependant => {
    parse$2 = dependant;
  };

  Container.registerRule = dependant => {
    Rule = dependant;
  };

  Container.registerAtRule = dependant => {
    AtRule = dependant;
  };

  var container = Container;
  Container.default = Container;

  const SINGLE_QUOTE = "'".charCodeAt(0);
  const DOUBLE_QUOTE = '"'.charCodeAt(0);
  const BACKSLASH = '\\'.charCodeAt(0);
  const SLASH = '/'.charCodeAt(0);
  const NEWLINE = '\n'.charCodeAt(0);
  const SPACE = ' '.charCodeAt(0);
  const FEED = '\f'.charCodeAt(0);
  const TAB = '\t'.charCodeAt(0);
  const CR = '\r'.charCodeAt(0);
  const OPEN_SQUARE = '['.charCodeAt(0);
  const CLOSE_SQUARE = ']'.charCodeAt(0);
  const OPEN_PARENTHESES = '('.charCodeAt(0);
  const CLOSE_PARENTHESES = ')'.charCodeAt(0);
  const OPEN_CURLY = '{'.charCodeAt(0);
  const CLOSE_CURLY = '}'.charCodeAt(0);
  const SEMICOLON = ';'.charCodeAt(0);
  const ASTERISK = '*'.charCodeAt(0);
  const COLON = ':'.charCodeAt(0);
  const AT = '@'.charCodeAt(0);

  const RE_AT_END = /[\t\n\f\r "#'()/;[\\\]{}]/g;
  const RE_WORD_END = /[\t\n\f\r !"#'():;@[\\\]{}]|\/(?=\*)/g;
  const RE_BAD_BRACKET = /.[\n"'(/\\]/;
  const RE_HEX_ESCAPE = /[\da-f]/i;

  var tokenize = function tokenizer (input, options = {}) {
    let css = input.css.valueOf();
    let ignore = options.ignoreErrors;

    let code, next, quote, content, escape;
    let escaped, escapePos, prev, n, currentToken;

    let length = css.length;
    let pos = 0;
    let buffer = [];
    let returned = [];

    function position () {
      return pos
    }

    function unclosed (what) {
      throw input.error('Unclosed ' + what, pos)
    }

    function endOfFile () {
      return returned.length === 0 && pos >= length
    }

    function nextToken (opts) {
      if (returned.length) return returned.pop()
      if (pos >= length) return

      let ignoreUnclosed = opts ? opts.ignoreUnclosed : false;

      code = css.charCodeAt(pos);

      switch (code) {
        case NEWLINE:
        case SPACE:
        case TAB:
        case CR:
        case FEED: {
          next = pos;
          do {
            next += 1;
            code = css.charCodeAt(next);
          } while (
            code === SPACE ||
            code === NEWLINE ||
            code === TAB ||
            code === CR ||
            code === FEED
          )

          currentToken = ['space', css.slice(pos, next)];
          pos = next - 1;
          break
        }

        case OPEN_SQUARE:
        case CLOSE_SQUARE:
        case OPEN_CURLY:
        case CLOSE_CURLY:
        case COLON:
        case SEMICOLON:
        case CLOSE_PARENTHESES: {
          let controlChar = String.fromCharCode(code);
          currentToken = [controlChar, controlChar, pos];
          break
        }

        case OPEN_PARENTHESES: {
          prev = buffer.length ? buffer.pop()[1] : '';
          n = css.charCodeAt(pos + 1);
          if (
            prev === 'url' &&
            n !== SINGLE_QUOTE &&
            n !== DOUBLE_QUOTE &&
            n !== SPACE &&
            n !== NEWLINE &&
            n !== TAB &&
            n !== FEED &&
            n !== CR
          ) {
            next = pos;
            do {
              escaped = false;
              next = css.indexOf(')', next + 1);
              if (next === -1) {
                if (ignore || ignoreUnclosed) {
                  next = pos;
                  break
                } else {
                  unclosed('bracket');
                }
              }
              escapePos = next;
              while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
                escapePos -= 1;
                escaped = !escaped;
              }
            } while (escaped)

            currentToken = ['brackets', css.slice(pos, next + 1), pos, next];

            pos = next;
          } else {
            next = css.indexOf(')', pos + 1);
            content = css.slice(pos, next + 1);

            if (next === -1 || RE_BAD_BRACKET.test(content)) {
              currentToken = ['(', '(', pos];
            } else {
              currentToken = ['brackets', content, pos, next];
              pos = next;
            }
          }

          break
        }

        case SINGLE_QUOTE:
        case DOUBLE_QUOTE: {
          quote = code === SINGLE_QUOTE ? "'" : '"';
          next = pos;
          do {
            escaped = false;
            next = css.indexOf(quote, next + 1);
            if (next === -1) {
              if (ignore || ignoreUnclosed) {
                next = pos + 1;
                break
              } else {
                unclosed('string');
              }
            }
            escapePos = next;
            while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
              escapePos -= 1;
              escaped = !escaped;
            }
          } while (escaped)

          currentToken = ['string', css.slice(pos, next + 1), pos, next];
          pos = next;
          break
        }

        case AT: {
          RE_AT_END.lastIndex = pos + 1;
          RE_AT_END.test(css);
          if (RE_AT_END.lastIndex === 0) {
            next = css.length - 1;
          } else {
            next = RE_AT_END.lastIndex - 2;
          }

          currentToken = ['at-word', css.slice(pos, next + 1), pos, next];

          pos = next;
          break
        }

        case BACKSLASH: {
          next = pos;
          escape = true;
          while (css.charCodeAt(next + 1) === BACKSLASH) {
            next += 1;
            escape = !escape;
          }
          code = css.charCodeAt(next + 1);
          if (
            escape &&
            code !== SLASH &&
            code !== SPACE &&
            code !== NEWLINE &&
            code !== TAB &&
            code !== CR &&
            code !== FEED
          ) {
            next += 1;
            if (RE_HEX_ESCAPE.test(css.charAt(next))) {
              while (RE_HEX_ESCAPE.test(css.charAt(next + 1))) {
                next += 1;
              }
              if (css.charCodeAt(next + 1) === SPACE) {
                next += 1;
              }
            }
          }

          currentToken = ['word', css.slice(pos, next + 1), pos, next];

          pos = next;
          break
        }

        default: {
          if (code === SLASH && css.charCodeAt(pos + 1) === ASTERISK) {
            next = css.indexOf('*/', pos + 2) + 1;
            if (next === 0) {
              if (ignore || ignoreUnclosed) {
                next = css.length;
              } else {
                unclosed('comment');
              }
            }

            currentToken = ['comment', css.slice(pos, next + 1), pos, next];
            pos = next;
          } else {
            RE_WORD_END.lastIndex = pos + 1;
            RE_WORD_END.test(css);
            if (RE_WORD_END.lastIndex === 0) {
              next = css.length - 1;
            } else {
              next = RE_WORD_END.lastIndex - 2;
            }

            currentToken = ['word', css.slice(pos, next + 1), pos, next];
            buffer.push(currentToken);
            pos = next;
          }

          break
        }
      }

      pos++;
      return currentToken
    }

    function back (token) {
      returned.push(token);
    }

    return {
      back,
      nextToken,
      endOfFile,
      position
    }
  };

  class AtRule$1 extends container {
    constructor (defaults) {
      super(defaults);
      this.type = 'atrule';
    }

    append (...children) {
      if (!this.proxyOf.nodes) this.nodes = [];
      return super.append(...children)
    }

    prepend (...children) {
      if (!this.proxyOf.nodes) this.nodes = [];
      return super.prepend(...children)
    }
  }

  var atRule = AtRule$1;
  AtRule$1.default = AtRule$1;

  container.registerAtRule(AtRule$1);

  let LazyResult, Processor;

  class Root extends container {
    constructor (defaults) {
      super(defaults);
      this.type = 'root';
      if (!this.nodes) this.nodes = [];
    }

    removeChild (child, ignore) {
      let index = this.index(child);

      if (!ignore && index === 0 && this.nodes.length > 1) {
        this.nodes[1].raws.before = this.nodes[index].raws.before;
      }

      return super.removeChild(child)
    }

    normalize (child, sample, type) {
      let nodes = super.normalize(child);

      if (sample) {
        if (type === 'prepend') {
          if (this.nodes.length > 1) {
            sample.raws.before = this.nodes[1].raws.before;
          } else {
            delete sample.raws.before;
          }
        } else if (this.first !== sample) {
          for (let node of nodes) {
            node.raws.before = sample.raws.before;
          }
        }
      }

      return nodes
    }

    toResult (opts = {}) {
      let lazy = new LazyResult(new Processor(), this, opts);
      return lazy.stringify()
    }
  }

  Root.registerLazyResult = dependant => {
    LazyResult = dependant;
  };

  Root.registerProcessor = dependant => {
    Processor = dependant;
  };

  var root = Root;
  Root.default = Root;

  let list = {
    split (string, separators, last) {
      let array = [];
      let current = '';
      let split = false;

      let func = 0;
      let quote = false;
      let escape = false;

      for (let letter of string) {
        if (quote) {
          if (escape) {
            escape = false;
          } else if (letter === '\\') {
            escape = true;
          } else if (letter === quote) {
            quote = false;
          }
        } else if (letter === '"' || letter === "'") {
          quote = letter;
        } else if (letter === '(') {
          func += 1;
        } else if (letter === ')') {
          if (func > 0) func -= 1;
        } else if (func === 0) {
          if (separators.includes(letter)) split = true;
        }

        if (split) {
          if (current !== '') array.push(current.trim());
          current = '';
          split = false;
        } else {
          current += letter;
        }
      }

      if (last || current !== '') array.push(current.trim());
      return array
    },

    space (string) {
      let spaces = [' ', '\n', '\t'];
      return list.split(string, spaces)
    },

    comma (string) {
      return list.split(string, [','], true)
    }
  };

  var list_1 = list;
  list.default = list;

  class Rule$1 extends container {
    constructor (defaults) {
      super(defaults);
      this.type = 'rule';
      if (!this.nodes) this.nodes = [];
    }

    get selectors () {
      return list_1.comma(this.selector)
    }

    set selectors (values) {
      let match = this.selector ? this.selector.match(/,\s*/) : null;
      let sep = match ? match[0] : ',' + this.raw('between', 'beforeOpen');
      this.selector = values.join(sep);
    }
  }

  var rule = Rule$1;
  Rule$1.default = Rule$1;

  container.registerRule(Rule$1);

  class Parser {
    constructor (input) {
      this.input = input;

      this.root = new root();
      this.current = this.root;
      this.spaces = '';
      this.semicolon = false;
      this.customProperty = false;

      this.createTokenizer();
      this.root.source = { input, start: { offset: 0, line: 1, column: 1 } };
    }

    createTokenizer () {
      this.tokenizer = tokenize(this.input);
    }

    parse () {
      let token;
      while (!this.tokenizer.endOfFile()) {
        token = this.tokenizer.nextToken();

        switch (token[0]) {
          case 'space':
            this.spaces += token[1];
            break

          case ';':
            this.freeSemicolon(token);
            break

          case '}':
            this.end(token);
            break

          case 'comment':
            this.comment(token);
            break

          case 'at-word':
            this.atrule(token);
            break

          case '{':
            this.emptyRule(token);
            break

          default:
            this.other(token);
            break
        }
      }
      this.endFile();
    }

    comment (token) {
      let node = new comment();
      this.init(node, token[2]);
      node.source.end = this.getPosition(token[3] || token[2]);

      let text = token[1].slice(2, -2);
      if (/^\s*$/.test(text)) {
        node.text = '';
        node.raws.left = text;
        node.raws.right = '';
      } else {
        let match = text.match(/^(\s*)([^]*\S)(\s*)$/);
        node.text = match[2];
        node.raws.left = match[1];
        node.raws.right = match[3];
      }
    }

    emptyRule (token) {
      let node = new rule();
      this.init(node, token[2]);
      node.selector = '';
      node.raws.between = '';
      this.current = node;
    }

    other (start) {
      let end = false;
      let type = null;
      let colon = false;
      let bracket = null;
      let brackets = [];
      let customProperty = start[1].startsWith('--');

      let tokens = [];
      let token = start;
      while (token) {
        type = token[0];
        tokens.push(token);

        if (type === '(' || type === '[') {
          if (!bracket) bracket = token;
          brackets.push(type === '(' ? ')' : ']');
        } else if (customProperty && colon && type === '{') {
          if (!bracket) bracket = token;
          brackets.push('}');
        } else if (brackets.length === 0) {
          if (type === ';') {
            if (colon) {
              this.decl(tokens, customProperty);
              return
            } else {
              break
            }
          } else if (type === '{') {
            this.rule(tokens);
            return
          } else if (type === '}') {
            this.tokenizer.back(tokens.pop());
            end = true;
            break
          } else if (type === ':') {
            colon = true;
          }
        } else if (type === brackets[brackets.length - 1]) {
          brackets.pop();
          if (brackets.length === 0) bracket = null;
        }

        token = this.tokenizer.nextToken();
      }

      if (this.tokenizer.endOfFile()) end = true;
      if (brackets.length > 0) this.unclosedBracket(bracket);

      if (end && colon) {
        while (tokens.length) {
          token = tokens[tokens.length - 1][0];
          if (token !== 'space' && token !== 'comment') break
          this.tokenizer.back(tokens.pop());
        }
        this.decl(tokens, customProperty);
      } else {
        this.unknownWord(tokens);
      }
    }

    rule (tokens) {
      tokens.pop();

      let node = new rule();
      this.init(node, tokens[0][2]);

      node.raws.between = this.spacesAndCommentsFromEnd(tokens);
      this.raw(node, 'selector', tokens);
      this.current = node;
    }

    decl (tokens, customProperty) {
      let node = new declaration();
      this.init(node, tokens[0][2]);

      let last = tokens[tokens.length - 1];
      if (last[0] === ';') {
        this.semicolon = true;
        tokens.pop();
      }
      node.source.end = this.getPosition(last[3] || last[2]);

      while (tokens[0][0] !== 'word') {
        if (tokens.length === 1) this.unknownWord(tokens);
        node.raws.before += tokens.shift()[1];
      }
      node.source.start = this.getPosition(tokens[0][2]);

      node.prop = '';
      while (tokens.length) {
        let type = tokens[0][0];
        if (type === ':' || type === 'space' || type === 'comment') {
          break
        }
        node.prop += tokens.shift()[1];
      }

      node.raws.between = '';

      let token;
      while (tokens.length) {
        token = tokens.shift();

        if (token[0] === ':') {
          node.raws.between += token[1];
          break
        } else {
          if (token[0] === 'word' && /\w/.test(token[1])) {
            this.unknownWord([token]);
          }
          node.raws.between += token[1];
        }
      }

      if (node.prop[0] === '_' || node.prop[0] === '*') {
        node.raws.before += node.prop[0];
        node.prop = node.prop.slice(1);
      }
      let firstSpaces = this.spacesAndCommentsFromStart(tokens);
      this.precheckMissedSemicolon(tokens);

      for (let i = tokens.length - 1; i >= 0; i--) {
        token = tokens[i];
        if (token[1].toLowerCase() === '!important') {
          node.important = true;
          let string = this.stringFrom(tokens, i);
          string = this.spacesFromEnd(tokens) + string;
          if (string !== ' !important') node.raws.important = string;
          break
        } else if (token[1].toLowerCase() === 'important') {
          let cache = tokens.slice(0);
          let str = '';
          for (let j = i; j > 0; j--) {
            let type = cache[j][0];
            if (str.trim().indexOf('!') === 0 && type !== 'space') {
              break
            }
            str = cache.pop()[1] + str;
          }
          if (str.trim().indexOf('!') === 0) {
            node.important = true;
            node.raws.important = str;
            tokens = cache;
          }
        }

        if (token[0] !== 'space' && token[0] !== 'comment') {
          break
        }
      }

      let hasWord = tokens.some(i => i[0] !== 'space' && i[0] !== 'comment');
      this.raw(node, 'value', tokens);
      if (hasWord) {
        node.raws.between += firstSpaces;
      } else {
        node.value = firstSpaces + node.value;
      }

      if (node.value.includes(':') && !customProperty) {
        this.checkMissedSemicolon(tokens);
      }
    }

    atrule (token) {
      let node = new atRule();
      node.name = token[1].slice(1);
      if (node.name === '') {
        this.unnamedAtrule(node, token);
      }
      this.init(node, token[2]);

      let type;
      let prev;
      let shift;
      let last = false;
      let open = false;
      let params = [];
      let brackets = [];

      while (!this.tokenizer.endOfFile()) {
        token = this.tokenizer.nextToken();
        type = token[0];

        if (type === '(' || type === '[') {
          brackets.push(type === '(' ? ')' : ']');
        } else if (type === '{' && brackets.length > 0) {
          brackets.push('}');
        } else if (type === brackets[brackets.length - 1]) {
          brackets.pop();
        }

        if (brackets.length === 0) {
          if (type === ';') {
            node.source.end = this.getPosition(token[2]);
            this.semicolon = true;
            break
          } else if (type === '{') {
            open = true;
            break
          } else if (type === '}') {
            if (params.length > 0) {
              shift = params.length - 1;
              prev = params[shift];
              while (prev && prev[0] === 'space') {
                prev = params[--shift];
              }
              if (prev) {
                node.source.end = this.getPosition(prev[3] || prev[2]);
              }
            }
            this.end(token);
            break
          } else {
            params.push(token);
          }
        } else {
          params.push(token);
        }

        if (this.tokenizer.endOfFile()) {
          last = true;
          break
        }
      }

      node.raws.between = this.spacesAndCommentsFromEnd(params);
      if (params.length) {
        node.raws.afterName = this.spacesAndCommentsFromStart(params);
        this.raw(node, 'params', params);
        if (last) {
          token = params[params.length - 1];
          node.source.end = this.getPosition(token[3] || token[2]);
          this.spaces = node.raws.between;
          node.raws.between = '';
        }
      } else {
        node.raws.afterName = '';
        node.params = '';
      }

      if (open) {
        node.nodes = [];
        this.current = node;
      }
    }

    end (token) {
      if (this.current.nodes && this.current.nodes.length) {
        this.current.raws.semicolon = this.semicolon;
      }
      this.semicolon = false;

      this.current.raws.after = (this.current.raws.after || '') + this.spaces;
      this.spaces = '';

      if (this.current.parent) {
        this.current.source.end = this.getPosition(token[2]);
        this.current = this.current.parent;
      } else {
        this.unexpectedClose(token);
      }
    }

    endFile () {
      if (this.current.parent) this.unclosedBlock();
      if (this.current.nodes && this.current.nodes.length) {
        this.current.raws.semicolon = this.semicolon;
      }
      this.current.raws.after = (this.current.raws.after || '') + this.spaces;
    }

    freeSemicolon (token) {
      this.spaces += token[1];
      if (this.current.nodes) {
        let prev = this.current.nodes[this.current.nodes.length - 1];
        if (prev && prev.type === 'rule' && !prev.raws.ownSemicolon) {
          prev.raws.ownSemicolon = this.spaces;
          this.spaces = '';
        }
      }
    }

    // Helpers

    getPosition (offset) {
      let pos = this.input.fromOffset(offset);
      return {
        offset,
        line: pos.line,
        column: pos.col
      }
    }

    init (node, offset) {
      this.current.push(node);
      node.source = {
        start: this.getPosition(offset),
        input: this.input
      };
      node.raws.before = this.spaces;
      this.spaces = '';
      if (node.type !== 'comment') this.semicolon = false;
    }

    raw (node, prop, tokens) {
      let token, type;
      let length = tokens.length;
      let value = '';
      let clean = true;
      let next, prev;
      let pattern = /^([#.|])?(\w)+/i;

      for (let i = 0; i < length; i += 1) {
        token = tokens[i];
        type = token[0];

        if (type === 'comment' && node.type === 'rule') {
          prev = tokens[i - 1];
          next = tokens[i + 1];

          if (
            prev[0] !== 'space' &&
            next[0] !== 'space' &&
            pattern.test(prev[1]) &&
            pattern.test(next[1])
          ) {
            value += token[1];
          } else {
            clean = false;
          }

          continue
        }

        if (type === 'comment' || (type === 'space' && i === length - 1)) {
          clean = false;
        } else {
          value += token[1];
        }
      }
      if (!clean) {
        let raw = tokens.reduce((all, i) => all + i[1], '');
        node.raws[prop] = { value, raw };
      }
      node[prop] = value;
    }

    spacesAndCommentsFromEnd (tokens) {
      let lastTokenType;
      let spaces = '';
      while (tokens.length) {
        lastTokenType = tokens[tokens.length - 1][0];
        if (lastTokenType !== 'space' && lastTokenType !== 'comment') break
        spaces = tokens.pop()[1] + spaces;
      }
      return spaces
    }

    spacesAndCommentsFromStart (tokens) {
      let next;
      let spaces = '';
      while (tokens.length) {
        next = tokens[0][0];
        if (next !== 'space' && next !== 'comment') break
        spaces += tokens.shift()[1];
      }
      return spaces
    }

    spacesFromEnd (tokens) {
      let lastTokenType;
      let spaces = '';
      while (tokens.length) {
        lastTokenType = tokens[tokens.length - 1][0];
        if (lastTokenType !== 'space') break
        spaces = tokens.pop()[1] + spaces;
      }
      return spaces
    }

    stringFrom (tokens, from) {
      let result = '';
      for (let i = from; i < tokens.length; i++) {
        result += tokens[i][1];
      }
      tokens.splice(from, tokens.length - from);
      return result
    }

    colon (tokens) {
      let brackets = 0;
      let token, type, prev;
      for (let [i, element] of tokens.entries()) {
        token = element;
        type = token[0];

        if (type === '(') {
          brackets += 1;
        }
        if (type === ')') {
          brackets -= 1;
        }
        if (brackets === 0 && type === ':') {
          if (!prev) {
            this.doubleColon(token);
          } else if (prev[0] === 'word' && prev[1] === 'progid') {
            continue
          } else {
            return i
          }
        }

        prev = token;
      }
      return false
    }

    // Errors

    unclosedBracket (bracket) {
      throw this.input.error('Unclosed bracket', bracket[2])
    }

    unknownWord (tokens) {
      throw this.input.error('Unknown word', tokens[0][2])
    }

    unexpectedClose (token) {
      throw this.input.error('Unexpected }', token[2])
    }

    unclosedBlock () {
      let pos = this.current.source.start;
      throw this.input.error('Unclosed block', pos.line, pos.column)
    }

    doubleColon (token) {
      throw this.input.error('Double colon', token[2])
    }

    unnamedAtrule (node, token) {
      throw this.input.error('At-rule without name', token[2])
    }

    precheckMissedSemicolon (/* tokens */) {
      // Hook for Safe Parser
    }

    checkMissedSemicolon (tokens) {
      let colon = this.colon(tokens);
      if (colon === false) return

      let founded = 0;
      let token;
      for (let j = colon - 1; j >= 0; j--) {
        token = tokens[j];
        if (token[0] !== 'space') {
          founded += 1;
          if (founded === 2) break
        }
      }
      throw this.input.error('Missed semicolon', token[2])
    }
  }

  var parser = Parser;

  // This alphabet uses `A-Za-z0-9_-` symbols. The genetic algorithm helped
  // optimize the gzip compression for this alphabet.
  let urlAlphabet =
    'ModuleSymbhasOwnPr-0123456789ABCDEFGHNRVfgctiUvz_KqYTJkLxpZXIjQW';

  let customAlphabet = (alphabet, size) => {
    return () => {
      let id = '';
      // A compact alternative for `for (var i = 0; i < step; i++)`.
      let i = size;
      while (i--) {
        // `| 0` is more compact and faster than `Math.floor()`.
        id += alphabet[(Math.random() * alphabet.length) | 0];
      }
      return id
    }
  };

  let nanoid = (size = 21) => {
    let id = '';
    // A compact alternative for `for (var i = 0; i < step; i++)`.
    let i = size;
    while (i--) {
      // `| 0` is more compact and faster than `Math.floor()`.
      id += urlAlphabet[(Math.random() * 64) | 0];
    }
    return id
  };

  var nonSecure = { nanoid, customAlphabet };

  let { existsSync, readFileSync } = colorette;
  let { dirname: dirname$2, join: join$1 } = require$$1;


  function fromBase64 (str) {
    if (Buffer) {
      return Buffer.from(str, 'base64').toString()
    } else {
      // istanbul ignore next
      return window.atob(str)
    }
  }

  class PreviousMap {
    constructor (css, opts) {
      if (opts.map === false) return
      this.loadAnnotation(css);
      this.inline = this.startWith(this.annotation, 'data:');

      let prev = opts.map ? opts.map.prev : undefined;
      let text = this.loadMap(opts.from, prev);
      if (!this.mapFile && opts.from) {
        this.mapFile = opts.from;
      }
      if (this.mapFile) this.root = dirname$2(this.mapFile);
      if (text) this.text = text;
    }

    consumer () {
      if (!this.consumerCache) {
        this.consumerCache = new sourceMap.SourceMapConsumer(this.text);
      }
      return this.consumerCache
    }

    withContent () {
      return !!(
        this.consumer().sourcesContent &&
        this.consumer().sourcesContent.length > 0
      )
    }

    startWith (string, start) {
      if (!string) return false
      return string.substr(0, start.length) === start
    }

    getAnnotationURL (sourceMapString) {
      return sourceMapString
        .match(/\/\*\s*# sourceMappingURL=(.*)\s*\*\//)[1]
        .trim()
    }

    loadAnnotation (css) {
      let annotations = css.match(/\/\*\s*# sourceMappingURL=.*\s*\*\//gm);

      if (annotations && annotations.length > 0) {
        // Locate the last sourceMappingURL to avoid picking up
        // sourceMappingURLs from comments, strings, etc.
        let lastAnnotation = annotations[annotations.length - 1];
        if (lastAnnotation) {
          this.annotation = this.getAnnotationURL(lastAnnotation);
        }
      }
    }

    decodeInline (text) {
      let baseCharsetUri = /^data:application\/json;charset=utf-?8;base64,/;
      let baseUri = /^data:application\/json;base64,/;
      let charsetUri = /^data:application\/json;charset=utf-?8,/;
      let uri = /^data:application\/json,/;

      if (charsetUri.test(text) || uri.test(text)) {
        return decodeURIComponent(text.substr(RegExp.lastMatch.length))
      }

      if (baseCharsetUri.test(text) || baseUri.test(text)) {
        return fromBase64(text.substr(RegExp.lastMatch.length))
      }

      let encoding = text.match(/data:application\/json;([^,]+),/)[1];
      throw new Error('Unsupported source map encoding ' + encoding)
    }

    loadFile (path) {
      this.root = dirname$2(path);
      if (void(path)) {
        this.mapFile = path;
        return readFileSync(path, 'utf-8').toString().trim()
      }
    }

    loadMap (file, prev) {
      if (prev === false) return false

      if (prev) {
        if (typeof prev === 'string') {
          return prev
        } else if (typeof prev === 'function') {
          let prevPath = prev(file);
          if (prevPath) {
            let map = this.loadFile(prevPath);
            if (!map) {
              throw new Error(
                'Unable to load previous source map: ' + prevPath.toString()
              )
            }
            return map
          }
        } else if (prev instanceof sourceMap.SourceMapConsumer) {
          return sourceMap.SourceMapGenerator.fromSourceMap(prev).toString()
        } else if (prev instanceof sourceMap.SourceMapGenerator) {
          return prev.toString()
        } else if (this.isMap(prev)) {
          return JSON.stringify(prev)
        } else {
          throw new Error(
            'Unsupported previous source map format: ' + prev.toString()
          )
        }
      } else if (this.inline) {
        return this.decodeInline(this.annotation)
      } else if (this.annotation) {
        let map = this.annotation;
        if (file) map = join$1(dirname$2(file), map);
        return this.loadFile(map)
      }
    }

    isMap (map) {
      if (typeof map !== 'object') return false
      return (
        typeof map.mappings === 'string' ||
        typeof map._mappings === 'string' ||
        Array.isArray(map.sections)
      )
    }
  }

  var previousMap = PreviousMap;
  PreviousMap.default = PreviousMap;

  let { fileURLToPath, pathToFileURL: pathToFileURL$1 } = url$2;
  let { resolve: resolve$2, isAbsolute: isAbsolute$1 } = require$$1;
  let { nanoid: nanoid$1 } = nonSecure;





  let fromOffsetCache = Symbol('fromOffset cache');

  class Input {
    constructor (css, opts = {}) {
      if (
        css === null ||
        typeof css === 'undefined' ||
        (typeof css === 'object' && !css.toString)
      ) {
        throw new Error(`PostCSS received ${css} instead of CSS string`)
      }

      this.css = css.toString();

      if (this.css[0] === '\uFEFF' || this.css[0] === '\uFFFE') {
        this.hasBOM = true;
        this.css = this.css.slice(1);
      } else {
        this.hasBOM = false;
      }

      if (opts.from) {
        if (/^\w+:\/\//.test(opts.from) || isAbsolute$1(opts.from)) {
          this.file = opts.from;
        } else {
          this.file = resolve$2(opts.from);
        }
      }

      let map = new previousMap(this.css, opts);
      if (map.text) {
        this.map = map;
        let file = map.consumer().file;
        if (!this.file && file) this.file = this.mapResolve(file);
      }

      if (!this.file) {
        this.id = '<input css ' + nanoid$1(6) + '>';
      }
      if (this.map) this.map.file = this.from;
    }

    fromOffset (offset) {
      let lastLine, lineToIndex;
      if (!this[fromOffsetCache]) {
        let lines = this.css.split('\n');
        lineToIndex = new Array(lines.length);
        let prevIndex = 0;

        for (let i = 0, l = lines.length; i < l; i++) {
          lineToIndex[i] = prevIndex;
          prevIndex += lines[i].length + 1;
        }

        this[fromOffsetCache] = lineToIndex;
      } else {
        lineToIndex = this[fromOffsetCache];
      }
      lastLine = lineToIndex[lineToIndex.length - 1];

      let min = 0;
      if (offset >= lastLine) {
        min = lineToIndex.length - 1;
      } else {
        let max = lineToIndex.length - 2;
        let mid;
        while (min < max) {
          mid = min + ((max - min) >> 1);
          if (offset < lineToIndex[mid]) {
            max = mid - 1;
          } else if (offset >= lineToIndex[mid + 1]) {
            min = mid + 1;
          } else {
            min = mid;
            break
          }
        }
      }
      return {
        line: min + 1,
        col: offset - lineToIndex[min] + 1
      }
    }

    error (message, line, column, opts = {}) {
      let result;
      if (!column) {
        let pos = this.fromOffset(line);
        line = pos.line;
        column = pos.col;
      }
      let origin = this.origin(line, column);
      if (origin) {
        result = new cssSyntaxError(
          message,
          origin.line,
          origin.column,
          origin.source,
          origin.file,
          opts.plugin
        );
      } else {
        result = new cssSyntaxError(
          message,
          line,
          column,
          this.css,
          this.file,
          opts.plugin
        );
      }

      result.input = { line, column, source: this.css };
      if (this.file) {
        result.input.url = pathToFileURL$1(this.file).toString();
        result.input.file = this.file;
      }

      return result
    }

    origin (line, column) {
      if (!this.map) return false
      let consumer = this.map.consumer();

      let from = consumer.originalPositionFor({ line, column });
      if (!from.source) return false

      let fromUrl;

      if (isAbsolute$1(from.source)) {
        fromUrl = pathToFileURL$1(from.source);
      } else {
        fromUrl = new URL(
          from.source,
          this.map.consumer().sourceRoot || pathToFileURL$1(this.map.mapFile)
        );
      }

      let result = {
        url: fromUrl.toString(),
        line: from.line,
        column: from.column
      };

      if (fromUrl.protocol === 'file:') {
        result.file = fileURLToPath(fromUrl);
      }

      let source = consumer.sourceContentFor(from.source);
      if (source) result.source = source;

      return result
    }

    mapResolve (file) {
      if (/^\w+:\/\//.test(file)) {
        return file
      }
      return resolve$2(this.map.consumer().sourceRoot || this.map.root || '.', file)
    }

    get from () {
      return this.file || this.id
    }

    toJSON () {
      let json = {};
      for (let name of ['hasBOM', 'css', 'file', 'id']) {
        if (this[name] != null) {
          json[name] = this[name];
        }
      }
      if (this.map) {
        json.map = { ...this.map };
        if (json.map.consumerCache) {
          json.map.consumerCache = undefined;
        }
      }
      return json
    }
  }

  var input = Input;
  Input.default = Input;

  if (colorette && colorette.registerInput) {
    colorette.registerInput(Input);
  }

  function parse$3 (css, opts) {
    let input$1 = new input(css, opts);
    let parser$1 = new parser(input$1);
    try {
      parser$1.parse();
    } catch (e) {
      if (browser$1.env.NODE_ENV !== 'production') {
        if (e.name === 'CssSyntaxError' && opts && opts.from) {
          if (/\.scss$/i.test(opts.from)) {
            e.message +=
              '\nYou tried to parse SCSS with ' +
              'the standard CSS parser; ' +
              'try again with the postcss-scss parser';
          } else if (/\.sass/i.test(opts.from)) {
            e.message +=
              '\nYou tried to parse Sass with ' +
              'the standard CSS parser; ' +
              'try again with the postcss-sass parser';
          } else if (/\.less$/i.test(opts.from)) {
            e.message +=
              '\nYou tried to parse Less with ' +
              'the standard CSS parser; ' +
              'try again with the postcss-less parser';
          }
        }
      }
      throw e
    }

    return parser$1.root
  }

  var parse_1 = parse$3;
  parse$3.default = parse$3;

  container.registerParse(parse$3);

  let { isClean: isClean$3 } = symbols;






  const TYPE_TO_CLASS_NAME = {
    root: 'Root',
    atrule: 'AtRule',
    rule: 'Rule',
    decl: 'Declaration',
    comment: 'Comment'
  };

  const PLUGIN_PROPS = {
    postcssPlugin: true,
    prepare: true,
    Once: true,
    Root: true,
    Declaration: true,
    Rule: true,
    AtRule: true,
    Comment: true,
    DeclarationExit: true,
    RuleExit: true,
    AtRuleExit: true,
    CommentExit: true,
    RootExit: true,
    OnceExit: true
  };

  const NOT_VISITORS = {
    postcssPlugin: true,
    prepare: true,
    Once: true
  };

  const CHILDREN = 0;

  function isPromise (obj) {
    return typeof obj === 'object' && typeof obj.then === 'function'
  }

  function getEvents (node) {
    let key = false;
    let type = TYPE_TO_CLASS_NAME[node.type];
    if (node.type === 'decl') {
      key = node.prop.toLowerCase();
    } else if (node.type === 'atrule') {
      key = node.name.toLowerCase();
    }

    if (key && node.append) {
      return [
        type,
        type + '-' + key,
        CHILDREN,
        type + 'Exit',
        type + 'Exit-' + key
      ]
    } else if (key) {
      return [type, type + '-' + key, type + 'Exit', type + 'Exit-' + key]
    } else if (node.append) {
      return [type, CHILDREN, type + 'Exit']
    } else {
      return [type, type + 'Exit']
    }
  }

  function toStack (node) {
    let events;
    if (node.type === 'root') {
      events = ['Root', CHILDREN, 'RootExit'];
    } else {
      events = getEvents(node);
    }

    return {
      node,
      events,
      eventIndex: 0,
      visitors: [],
      visitorIndex: 0,
      iterator: 0
    }
  }

  function cleanMarks (node) {
    node[isClean$3] = false;
    if (node.nodes) node.nodes.forEach(i => cleanMarks(i));
    return node
  }

  let postcss = {};

  class LazyResult$1 {
    constructor (processor, css, opts) {
      this.stringified = false;
      this.processed = false;

      let root;
      if (typeof css === 'object' && css !== null && css.type === 'root') {
        root = cleanMarks(css);
      } else if (css instanceof LazyResult$1 || css instanceof result) {
        root = cleanMarks(css.root);
        if (css.map) {
          if (typeof opts.map === 'undefined') opts.map = {};
          if (!opts.map.inline) opts.map.inline = false;
          opts.map.prev = css.map;
        }
      } else {
        let parser = parse_1;
        if (opts.syntax) parser = opts.syntax.parse;
        if (opts.parser) parser = opts.parser;
        if (parser.parse) parser = parser.parse;

        try {
          root = parser(css, opts);
        } catch (error) {
          this.processed = true;
          this.error = error;
        }
      }

      this.result = new result(processor, root, opts);
      this.helpers = { ...postcss, result: this.result, postcss };
      this.plugins = this.processor.plugins.map(plugin => {
        if (typeof plugin === 'object' && plugin.prepare) {
          return { ...plugin, ...plugin.prepare(this.result) }
        } else {
          return plugin
        }
      });
    }

    get [Symbol.toStringTag] () {
      return 'LazyResult'
    }

    get processor () {
      return this.result.processor
    }

    get opts () {
      return this.result.opts
    }

    get css () {
      return this.stringify().css
    }

    get content () {
      return this.stringify().content
    }

    get map () {
      return this.stringify().map
    }

    get root () {
      return this.sync().root
    }

    get messages () {
      return this.sync().messages
    }

    warnings () {
      return this.sync().warnings()
    }

    toString () {
      return this.css
    }

    then (onFulfilled, onRejected) {
      if (browser$1.env.NODE_ENV !== 'production') {
        if (!('from' in this.opts)) {
          warnOnce(
            'Without `from` option PostCSS could generate wrong source map ' +
              'and will not find Browserslist config. Set it to CSS file path ' +
              'or to `undefined` to prevent this warning.'
          );
        }
      }
      return this.async().then(onFulfilled, onRejected)
    }

    catch (onRejected) {
      return this.async().catch(onRejected)
    }

    finally (onFinally) {
      return this.async().then(onFinally, onFinally)
    }

    async () {
      if (this.error) return Promise.reject(this.error)
      if (this.processed) return Promise.resolve(this.result)
      if (!this.processing) {
        this.processing = this.runAsync();
      }
      return this.processing
    }

    sync () {
      if (this.error) throw this.error
      if (this.processed) return this.result
      this.processed = true;

      if (this.processing) {
        throw this.getAsyncError()
      }

      for (let plugin of this.plugins) {
        let promise = this.runOnRoot(plugin);
        if (isPromise(promise)) {
          throw this.getAsyncError()
        }
      }

      this.prepareVisitors();
      if (this.hasListener) {
        let root = this.result.root;
        while (!root[isClean$3]) {
          root[isClean$3] = true;
          this.walkSync(root);
        }
        if (this.listeners.OnceExit) {
          this.visitSync(this.listeners.OnceExit, root);
        }
      }

      return this.result
    }

    stringify () {
      if (this.error) throw this.error
      if (this.stringified) return this.result
      this.stringified = true;

      this.sync();

      let opts = this.result.opts;
      let str = stringify_1;
      if (opts.syntax) str = opts.syntax.stringify;
      if (opts.stringifier) str = opts.stringifier;
      if (str.stringify) str = str.stringify;

      let map = new mapGenerator(str, this.result.root, this.result.opts);
      let data = map.generate();
      this.result.css = data[0];
      this.result.map = data[1];

      return this.result
    }

    walkSync (node) {
      node[isClean$3] = true;
      let events = getEvents(node);
      for (let event of events) {
        if (event === CHILDREN) {
          if (node.nodes) {
            node.each(child => {
              if (!child[isClean$3]) this.walkSync(child);
            });
          }
        } else {
          let visitors = this.listeners[event];
          if (visitors) {
            if (this.visitSync(visitors, node.toProxy())) return
          }
        }
      }
    }

    visitSync (visitors, node) {
      for (let [plugin, visitor] of visitors) {
        this.result.lastPlugin = plugin;
        let promise;
        try {
          promise = visitor(node, this.helpers);
        } catch (e) {
          throw this.handleError(e, node.proxyOf)
        }
        if (node.type !== 'root' && !node.parent) return true
        if (isPromise(promise)) {
          throw this.getAsyncError()
        }
      }
    }

    runOnRoot (plugin) {
      this.result.lastPlugin = plugin;
      try {
        if (typeof plugin === 'object' && plugin.Once) {
          return plugin.Once(this.result.root, this.helpers)
        } else if (typeof plugin === 'function') {
          return plugin(this.result.root, this.result)
        }
      } catch (error) {
        throw this.handleError(error)
      }
    }

    getAsyncError () {
      throw new Error('Use process(css).then(cb) to work with async plugins')
    }

    handleError (error, node) {
      let plugin = this.result.lastPlugin;
      try {
        if (node) node.addToError(error);
        this.error = error;
        if (error.name === 'CssSyntaxError' && !error.plugin) {
          error.plugin = plugin.postcssPlugin;
          error.setMessage();
        } else if (plugin.postcssVersion) {
          if (browser$1.env.NODE_ENV !== 'production') {
            let pluginName = plugin.postcssPlugin;
            let pluginVer = plugin.postcssVersion;
            let runtimeVer = this.result.processor.version;
            let a = pluginVer.split('.');
            let b = runtimeVer.split('.');

            if (a[0] !== b[0] || parseInt(a[1]) > parseInt(b[1])) {
              console.error(
                'Unknown error from PostCSS plugin. Your current PostCSS ' +
                  'version is ' +
                  runtimeVer +
                  ', but ' +
                  pluginName +
                  ' uses ' +
                  pluginVer +
                  '. Perhaps this is the source of the error below.'
              );
            }
          }
        }
      } catch (err) {
        // istanbul ignore next
        if (console && console.error) console.error(err);
      }
      return error
    }

    async runAsync () {
      this.plugin = 0;
      for (let i = 0; i < this.plugins.length; i++) {
        let plugin = this.plugins[i];
        let promise = this.runOnRoot(plugin);
        if (isPromise(promise)) {
          try {
            await promise;
          } catch (error) {
            throw this.handleError(error)
          }
        }
      }

      this.prepareVisitors();
      if (this.hasListener) {
        let root = this.result.root;
        while (!root[isClean$3]) {
          root[isClean$3] = true;
          let stack = [toStack(root)];
          while (stack.length > 0) {
            let promise = this.visitTick(stack);
            if (isPromise(promise)) {
              try {
                await promise;
              } catch (e) {
                let node = stack[stack.length - 1].node;
                throw this.handleError(e, node)
              }
            }
          }
        }

        if (this.listeners.OnceExit) {
          for (let [plugin, visitor] of this.listeners.OnceExit) {
            this.result.lastPlugin = plugin;
            try {
              await visitor(root, this.helpers);
            } catch (e) {
              throw this.handleError(e)
            }
          }
        }
      }

      this.processed = true;
      return this.stringify()
    }

    prepareVisitors () {
      this.listeners = {};
      let add = (plugin, type, cb) => {
        if (!this.listeners[type]) this.listeners[type] = [];
        this.listeners[type].push([plugin, cb]);
      };
      for (let plugin of this.plugins) {
        if (typeof plugin === 'object') {
          for (let event in plugin) {
            if (!PLUGIN_PROPS[event] && /^[A-Z]/.test(event)) {
              throw new Error(
                `Unknown event ${event} in ${plugin.postcssPlugin}. ` +
                  `Try to update PostCSS (${this.processor.version} now).`
              )
            }
            if (!NOT_VISITORS[event]) {
              if (typeof plugin[event] === 'object') {
                for (let filter in plugin[event]) {
                  if (filter === '*') {
                    add(plugin, event, plugin[event][filter]);
                  } else {
                    add(
                      plugin,
                      event + '-' + filter.toLowerCase(),
                      plugin[event][filter]
                    );
                  }
                }
              } else if (typeof plugin[event] === 'function') {
                add(plugin, event, plugin[event]);
              }
            }
          }
        }
      }
      this.hasListener = Object.keys(this.listeners).length > 0;
    }

    visitTick (stack) {
      let visit = stack[stack.length - 1];
      let { node, visitors } = visit;

      if (node.type !== 'root' && !node.parent) {
        stack.pop();
        return
      }

      if (visitors.length > 0 && visit.visitorIndex < visitors.length) {
        let [plugin, visitor] = visitors[visit.visitorIndex];
        visit.visitorIndex += 1;
        if (visit.visitorIndex === visitors.length) {
          visit.visitors = [];
          visit.visitorIndex = 0;
        }
        this.result.lastPlugin = plugin;
        try {
          return visitor(node.toProxy(), this.helpers)
        } catch (e) {
          throw this.handleError(e, node)
        }
      }

      if (visit.iterator !== 0) {
        let iterator = visit.iterator;
        let child;
        while ((child = node.nodes[node.indexes[iterator]])) {
          node.indexes[iterator] += 1;
          if (!child[isClean$3]) {
            child[isClean$3] = true;
            stack.push(toStack(child));
            return
          }
        }
        visit.iterator = 0;
        delete node.indexes[iterator];
      }

      let events = visit.events;
      while (visit.eventIndex < events.length) {
        let event = events[visit.eventIndex];
        visit.eventIndex += 1;
        if (event === CHILDREN) {
          if (node.nodes && node.nodes.length) {
            node[isClean$3] = true;
            visit.iterator = node.getIterator();
          }
          return
        } else if (this.listeners[event]) {
          visit.visitors = this.listeners[event];
          return
        }
      }
      stack.pop();
    }
  }

  LazyResult$1.registerPostcss = dependant => {
    postcss = dependant;
  };

  var lazyResult = LazyResult$1;
  LazyResult$1.default = LazyResult$1;

  root.registerLazyResult(LazyResult$1);

  class Processor$1 {
    constructor (plugins = []) {
      this.version = '8.2.4';
      this.plugins = this.normalize(plugins);
    }

    use (plugin) {
      this.plugins = this.plugins.concat(this.normalize([plugin]));
      return this
    }

    process (css, opts = {}) {
      if (
        this.plugins.length === 0 &&
        opts.parser === opts.stringifier &&
        !opts.hideNothingWarning
      ) {
        if (browser$1.env.NODE_ENV !== 'production') {
          if (typeof console !== 'undefined' && console.warn) {
            console.warn(
              'You did not set any plugins, parser, or stringifier. ' +
                'Right now, PostCSS does nothing. Pick plugins for your case ' +
                'on https://www.postcss.parts/ and use them in postcss.config.js.'
            );
          }
        }
      }
      return new lazyResult(this, css, opts)
    }

    normalize (plugins) {
      let normalized = [];
      for (let i of plugins) {
        if (i.postcss === true) {
          i = i();
        } else if (i.postcss) {
          i = i.postcss;
        }

        if (typeof i === 'object' && Array.isArray(i.plugins)) {
          normalized = normalized.concat(i.plugins);
        } else if (typeof i === 'object' && i.postcssPlugin) {
          normalized.push(i);
        } else if (typeof i === 'function') {
          normalized.push(i);
        } else if (typeof i === 'object' && (i.parse || i.stringify)) {
          if (browser$1.env.NODE_ENV !== 'production') {
            throw new Error(
              'PostCSS syntaxes cannot be used as plugins. Instead, please use ' +
                'one of the syntax/parser/stringifier options as outlined ' +
                'in your PostCSS runner documentation.'
            )
          }
        } else {
          throw new Error(i + ' is not a PostCSS plugin')
        }
      }
      return normalized
    }
  }

  var processor = Processor$1;
  Processor$1.default = Processor$1;

  root.registerProcessor(Processor$1);

  function fromJSON (json, inputs) {
    if (Array.isArray(json)) return json.map(n => fromJSON(n))

    let { inputs: ownInputs, ...defaults } = json;
    if (ownInputs) {
      inputs = [];
      for (let input$1 of ownInputs) {
        let inputHydrated = { ...input$1, __proto__: input.prototype };
        if (inputHydrated.map) {
          inputHydrated.map = {
            ...inputHydrated.map,
            __proto__: previousMap.prototype
          };
        }
        inputs.push(inputHydrated);
      }
    }
    if (defaults.nodes) {
      defaults.nodes = json.nodes.map(n => fromJSON(n, inputs));
    }
    if (defaults.source) {
      let { inputId, ...source } = defaults.source;
      defaults.source = source;
      if (inputId != null) {
        defaults.source.input = inputs[inputId];
      }
    }
    if (defaults.type === 'root') {
      return new root(defaults)
    } else if (defaults.type === 'decl') {
      return new declaration(defaults)
    } else if (defaults.type === 'rule') {
      return new rule(defaults)
    } else if (defaults.type === 'comment') {
      return new comment(defaults)
    } else if (defaults.type === 'atrule') {
      return new atRule(defaults)
    } else {
      throw new Error('Unknown node type: ' + json.type)
    }
  }

  var fromJSON_1 = fromJSON;
  fromJSON.default = fromJSON;

  function postcss$1 (...plugins) {
    if (plugins.length === 1 && Array.isArray(plugins[0])) {
      plugins = plugins[0];
    }
    return new processor(plugins)
  }

  postcss$1.plugin = function plugin (name, initializer) {
    if (console && console.warn) {
      console.warn(
        name +
          ': postcss.plugin was deprecated. Migration guide:\n' +
          'https://evilmartians.com/chronicles/postcss-8-plugin-migration'
      );
      if (browser$1.env.LANG && browser$1.env.LANG.startsWith('cn')) {
        // istanbul ignore next
        console.warn(
          name +
            ': 里面 postcss.plugin 被弃用. 迁移指南:\n' +
            'https://www.w3ctech.com/topic/2226'
        );
      }
    }
    function creator (...args) {
      let transformer = initializer(...args);
      transformer.postcssPlugin = name;
      transformer.postcssVersion = new processor().version;
      return transformer
    }

    let cache;
    Object.defineProperty(creator, 'postcss', {
      get () {
        if (!cache) cache = creator();
        return cache
      }
    });

    creator.process = function (css, processOpts, pluginOpts) {
      return postcss$1([creator(pluginOpts)]).process(css, processOpts)
    };

    return creator
  };

  postcss$1.stringify = stringify_1;
  postcss$1.parse = parse_1;
  postcss$1.fromJSON = fromJSON_1;
  postcss$1.list = list_1;

  postcss$1.comment = defaults => new comment(defaults);
  postcss$1.atRule = defaults => new atRule(defaults);
  postcss$1.decl = defaults => new declaration(defaults);
  postcss$1.rule = defaults => new rule(defaults);
  postcss$1.root = defaults => new root(defaults);

  postcss$1.CssSyntaxError = cssSyntaxError;
  postcss$1.Declaration = declaration;
  postcss$1.Container = container;
  postcss$1.Comment = comment;
  postcss$1.Warning = warning;
  postcss$1.AtRule = atRule;
  postcss$1.Result = result;
  postcss$1.Input = input;
  postcss$1.Rule = rule;
  postcss$1.Root = root;
  postcss$1.Node = node_1;

  lazyResult.registerPostcss(postcss$1);

  var postcss_1 = postcss$1;
  postcss$1.default = postcss$1;

  var jsReleases = [
  	{
  		name: "nodejs",
  		version: "0.2.0",
  		date: "2011-08-26",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "0.3.0",
  		date: "2011-08-26",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "0.4.0",
  		date: "2011-08-26",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "0.5.0",
  		date: "2011-08-26",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "0.6.0",
  		date: "2011-11-04",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "0.7.0",
  		date: "2012-01-17",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "0.8.0",
  		date: "2012-06-22",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "0.9.0",
  		date: "2012-07-20",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "0.10.0",
  		date: "2013-03-11",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "0.11.0",
  		date: "2013-03-28",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "0.12.0",
  		date: "2015-02-06",
  		lts: false,
  		security: false
  	},
  	{
  		name: "iojs",
  		version: "1.0.0",
  		date: "2015-01-14"
  	},
  	{
  		name: "iojs",
  		version: "1.1.0",
  		date: "2015-02-03"
  	},
  	{
  		name: "iojs",
  		version: "1.2.0",
  		date: "2015-02-11"
  	},
  	{
  		name: "iojs",
  		version: "1.3.0",
  		date: "2015-02-20"
  	},
  	{
  		name: "iojs",
  		version: "1.5.0",
  		date: "2015-03-06"
  	},
  	{
  		name: "iojs",
  		version: "1.6.0",
  		date: "2015-03-20"
  	},
  	{
  		name: "iojs",
  		version: "2.0.0",
  		date: "2015-05-04"
  	},
  	{
  		name: "iojs",
  		version: "2.1.0",
  		date: "2015-05-24"
  	},
  	{
  		name: "iojs",
  		version: "2.2.0",
  		date: "2015-06-01"
  	},
  	{
  		name: "iojs",
  		version: "2.3.0",
  		date: "2015-06-13"
  	},
  	{
  		name: "iojs",
  		version: "2.4.0",
  		date: "2015-07-17"
  	},
  	{
  		name: "iojs",
  		version: "2.5.0",
  		date: "2015-07-28"
  	},
  	{
  		name: "iojs",
  		version: "3.0.0",
  		date: "2015-08-04"
  	},
  	{
  		name: "iojs",
  		version: "3.1.0",
  		date: "2015-08-19"
  	},
  	{
  		name: "iojs",
  		version: "3.2.0",
  		date: "2015-08-25"
  	},
  	{
  		name: "iojs",
  		version: "3.3.0",
  		date: "2015-09-02"
  	},
  	{
  		name: "nodejs",
  		version: "4.0.0",
  		date: "2015-09-08",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "4.1.0",
  		date: "2015-09-17",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "4.2.0",
  		date: "2015-10-12",
  		lts: "Argon",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "4.3.0",
  		date: "2016-02-09",
  		lts: "Argon",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "4.4.0",
  		date: "2016-03-08",
  		lts: "Argon",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "4.5.0",
  		date: "2016-08-16",
  		lts: "Argon",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "4.6.0",
  		date: "2016-09-27",
  		lts: "Argon",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "4.7.0",
  		date: "2016-12-06",
  		lts: "Argon",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "4.8.0",
  		date: "2017-02-21",
  		lts: "Argon",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "4.9.0",
  		date: "2018-03-28",
  		lts: "Argon",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "5.0.0",
  		date: "2015-10-29",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "5.1.0",
  		date: "2015-11-17",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "5.2.0",
  		date: "2015-12-09",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "5.3.0",
  		date: "2015-12-15",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "5.4.0",
  		date: "2016-01-06",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "5.5.0",
  		date: "2016-01-21",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "5.6.0",
  		date: "2016-02-09",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "5.7.0",
  		date: "2016-02-23",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "5.8.0",
  		date: "2016-03-09",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "5.9.0",
  		date: "2016-03-16",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "5.10.0",
  		date: "2016-04-01",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "5.11.0",
  		date: "2016-04-21",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "5.12.0",
  		date: "2016-06-23",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "6.0.0",
  		date: "2016-04-26",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "6.1.0",
  		date: "2016-05-05",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "6.2.0",
  		date: "2016-05-17",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "6.3.0",
  		date: "2016-07-06",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "6.4.0",
  		date: "2016-08-12",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "6.5.0",
  		date: "2016-08-26",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "6.6.0",
  		date: "2016-09-14",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "6.7.0",
  		date: "2016-09-27",
  		lts: false,
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "6.8.0",
  		date: "2016-10-12",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "6.9.0",
  		date: "2016-10-18",
  		lts: "Boron",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "6.10.0",
  		date: "2017-02-21",
  		lts: "Boron",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "6.11.0",
  		date: "2017-06-06",
  		lts: "Boron",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "6.12.0",
  		date: "2017-11-06",
  		lts: "Boron",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "6.13.0",
  		date: "2018-02-10",
  		lts: "Boron",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "6.14.0",
  		date: "2018-03-28",
  		lts: "Boron",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "6.15.0",
  		date: "2018-11-27",
  		lts: "Boron",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "6.16.0",
  		date: "2018-12-26",
  		lts: "Boron",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "6.17.0",
  		date: "2019-02-28",
  		lts: "Boron",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "7.0.0",
  		date: "2016-10-25",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "7.1.0",
  		date: "2016-11-08",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "7.2.0",
  		date: "2016-11-22",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "7.3.0",
  		date: "2016-12-20",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "7.4.0",
  		date: "2017-01-04",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "7.5.0",
  		date: "2017-01-31",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "7.6.0",
  		date: "2017-02-21",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "7.7.0",
  		date: "2017-02-28",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "7.8.0",
  		date: "2017-03-29",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "7.9.0",
  		date: "2017-04-11",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "7.10.0",
  		date: "2017-05-02",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "8.0.0",
  		date: "2017-05-30",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "8.1.0",
  		date: "2017-06-08",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "8.2.0",
  		date: "2017-07-19",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "8.3.0",
  		date: "2017-08-08",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "8.4.0",
  		date: "2017-08-15",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "8.5.0",
  		date: "2017-09-12",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "8.6.0",
  		date: "2017-09-26",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "8.7.0",
  		date: "2017-10-11",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "8.8.0",
  		date: "2017-10-24",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "8.9.0",
  		date: "2017-10-31",
  		lts: "Carbon",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "8.10.0",
  		date: "2018-03-06",
  		lts: "Carbon",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "8.11.0",
  		date: "2018-03-28",
  		lts: "Carbon",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "8.12.0",
  		date: "2018-09-10",
  		lts: "Carbon",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "8.13.0",
  		date: "2018-11-20",
  		lts: "Carbon",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "8.14.0",
  		date: "2018-11-27",
  		lts: "Carbon",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "8.15.0",
  		date: "2018-12-26",
  		lts: "Carbon",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "8.16.0",
  		date: "2019-04-16",
  		lts: "Carbon",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "8.17.0",
  		date: "2019-12-17",
  		lts: "Carbon",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "9.0.0",
  		date: "2017-10-31",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "9.1.0",
  		date: "2017-11-07",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "9.2.0",
  		date: "2017-11-14",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "9.3.0",
  		date: "2017-12-12",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "9.4.0",
  		date: "2018-01-10",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "9.5.0",
  		date: "2018-01-31",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "9.6.0",
  		date: "2018-02-21",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "9.7.0",
  		date: "2018-03-01",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "9.8.0",
  		date: "2018-03-07",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "9.9.0",
  		date: "2018-03-21",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "9.10.0",
  		date: "2018-03-28",
  		lts: false,
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "9.11.0",
  		date: "2018-04-04",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.0.0",
  		date: "2018-04-24",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.1.0",
  		date: "2018-05-08",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.2.0",
  		date: "2018-05-23",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.3.0",
  		date: "2018-05-29",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.4.0",
  		date: "2018-06-06",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.5.0",
  		date: "2018-06-20",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.6.0",
  		date: "2018-07-04",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.7.0",
  		date: "2018-07-18",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.8.0",
  		date: "2018-08-01",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.9.0",
  		date: "2018-08-15",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.10.0",
  		date: "2018-09-06",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.11.0",
  		date: "2018-09-19",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.12.0",
  		date: "2018-10-10",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.13.0",
  		date: "2018-10-30",
  		lts: "Dubnium",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.14.0",
  		date: "2018-11-27",
  		lts: "Dubnium",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "10.15.0",
  		date: "2018-12-26",
  		lts: "Dubnium",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.16.0",
  		date: "2019-05-28",
  		lts: "Dubnium",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.17.0",
  		date: "2019-10-22",
  		lts: "Dubnium",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.18.0",
  		date: "2019-12-17",
  		lts: "Dubnium",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "10.19.0",
  		date: "2020-02-05",
  		lts: "Dubnium",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "10.20.0",
  		date: "2020-03-26",
  		lts: "Dubnium",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.21.0",
  		date: "2020-06-02",
  		lts: "Dubnium",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "10.22.0",
  		date: "2020-07-21",
  		lts: "Dubnium",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.23.0",
  		date: "2020-10-27",
  		lts: "Dubnium",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "10.24.0",
  		date: "2021-02-23",
  		lts: "Dubnium",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "11.0.0",
  		date: "2018-10-23",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "11.1.0",
  		date: "2018-10-30",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "11.2.0",
  		date: "2018-11-15",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "11.3.0",
  		date: "2018-11-27",
  		lts: false,
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "11.4.0",
  		date: "2018-12-07",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "11.5.0",
  		date: "2018-12-18",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "11.6.0",
  		date: "2018-12-26",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "11.7.0",
  		date: "2019-01-17",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "11.8.0",
  		date: "2019-01-24",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "11.9.0",
  		date: "2019-01-30",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "11.10.0",
  		date: "2019-02-14",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "11.11.0",
  		date: "2019-03-05",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "11.12.0",
  		date: "2019-03-14",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "11.13.0",
  		date: "2019-03-28",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "11.14.0",
  		date: "2019-04-10",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "11.15.0",
  		date: "2019-04-30",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.0.0",
  		date: "2019-04-23",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.1.0",
  		date: "2019-04-29",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.2.0",
  		date: "2019-05-07",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.3.0",
  		date: "2019-05-21",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.4.0",
  		date: "2019-06-04",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.5.0",
  		date: "2019-06-26",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.6.0",
  		date: "2019-07-03",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.7.0",
  		date: "2019-07-23",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.8.0",
  		date: "2019-08-06",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.9.0",
  		date: "2019-08-20",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.10.0",
  		date: "2019-09-04",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.11.0",
  		date: "2019-09-25",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.12.0",
  		date: "2019-10-11",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.13.0",
  		date: "2019-10-21",
  		lts: "Erbium",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.14.0",
  		date: "2019-12-17",
  		lts: "Erbium",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "12.15.0",
  		date: "2020-02-05",
  		lts: "Erbium",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "12.16.0",
  		date: "2020-02-11",
  		lts: "Erbium",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.17.0",
  		date: "2020-05-26",
  		lts: "Erbium",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.18.0",
  		date: "2020-06-02",
  		lts: "Erbium",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "12.19.0",
  		date: "2020-10-06",
  		lts: "Erbium",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.20.0",
  		date: "2020-11-24",
  		lts: "Erbium",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "12.21.0",
  		date: "2021-02-23",
  		lts: "Erbium",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "13.0.0",
  		date: "2019-10-22",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "13.1.0",
  		date: "2019-11-05",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "13.2.0",
  		date: "2019-11-21",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "13.3.0",
  		date: "2019-12-03",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "13.4.0",
  		date: "2019-12-17",
  		lts: false,
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "13.5.0",
  		date: "2019-12-18",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "13.6.0",
  		date: "2020-01-07",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "13.7.0",
  		date: "2020-01-21",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "13.8.0",
  		date: "2020-02-05",
  		lts: false,
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "13.9.0",
  		date: "2020-02-18",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "13.10.0",
  		date: "2020-03-04",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "13.11.0",
  		date: "2020-03-12",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "13.12.0",
  		date: "2020-03-26",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "13.13.0",
  		date: "2020-04-14",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "13.14.0",
  		date: "2020-04-29",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "14.0.0",
  		date: "2020-04-21",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "14.1.0",
  		date: "2020-04-29",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "14.2.0",
  		date: "2020-05-05",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "14.3.0",
  		date: "2020-05-19",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "14.4.0",
  		date: "2020-06-02",
  		lts: false,
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "14.5.0",
  		date: "2020-06-30",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "14.6.0",
  		date: "2020-07-20",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "14.7.0",
  		date: "2020-07-29",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "14.8.0",
  		date: "2020-08-11",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "14.9.0",
  		date: "2020-08-27",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "14.10.0",
  		date: "2020-09-08",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "14.11.0",
  		date: "2020-09-15",
  		lts: false,
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "14.12.0",
  		date: "2020-09-22",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "14.13.0",
  		date: "2020-09-29",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "14.14.0",
  		date: "2020-10-15",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "14.15.0",
  		date: "2020-10-27",
  		lts: "Fermium",
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "14.16.0",
  		date: "2021-02-23",
  		lts: "Fermium",
  		security: true
  	},
  	{
  		name: "nodejs",
  		version: "15.0.0",
  		date: "2020-10-20",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "15.1.0",
  		date: "2020-11-04",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "15.2.0",
  		date: "2020-11-10",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "15.3.0",
  		date: "2020-11-24",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "15.4.0",
  		date: "2020-12-09",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "15.5.0",
  		date: "2020-12-22",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "15.6.0",
  		date: "2021-01-14",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "15.7.0",
  		date: "2021-01-25",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "15.8.0",
  		date: "2021-02-02",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "15.9.0",
  		date: "2021-02-18",
  		lts: false,
  		security: false
  	},
  	{
  		name: "nodejs",
  		version: "15.10.0",
  		date: "2021-02-23",
  		lts: false,
  		security: true
  	}
  ];

  var browsers={A:"ie",B:"edge",C:"firefox",D:"chrome",E:"safari",F:"opera",G:"ios_saf",H:"op_mini",I:"android",J:"bb",K:"op_mob",L:"and_chr",M:"and_ff",N:"ie_mob",O:"and_uc",P:"samsung",Q:"and_qq",R:"baidu",S:"kaios"};

  var browsers_1 = browsers;

  var browsers$1 = {
  	browsers: browsers_1
  };

  var browserVersions={"0":"44","1":"45","2":"46","3":"47","4":"48","5":"49","6":"50","7":"51","8":"52","9":"53",A:"10",B:"11",C:"12",D:"7",E:"8",F:"9",G:"90",H:"4",I:"6",J:"13",K:"14",L:"15",M:"16",N:"17",O:"18",P:"87",Q:"62",R:"79",S:"80",T:"81",U:"83",V:"84",W:"85",X:"86",Y:"88",Z:"89",a:"5",b:"19",c:"20",d:"21",e:"22",f:"23",g:"24",h:"25",i:"26",j:"27",k:"28",l:"29",m:"30",n:"31",o:"32",p:"33",q:"34",r:"35",s:"36",t:"37",u:"38",v:"39",w:"40",x:"41",y:"42",z:"43",AB:"54",BB:"55",CB:"56",DB:"57",EB:"58",FB:"60",GB:"63",HB:"64",IB:"65",JB:"66",KB:"67",LB:"68",MB:"69",NB:"70",OB:"71",PB:"72",QB:"73",RB:"74",SB:"75",TB:"11.1",UB:"12.1",VB:"3",WB:"59",XB:"61",YB:"76",ZB:"77",aB:"78",bB:"3.2",cB:"10.1",dB:"11.5",eB:"4.2-4.3",fB:"5.5",gB:"2",hB:"82",iB:"3.5",jB:"3.6",kB:"91",lB:"92",mB:"93",nB:"3.1",oB:"5.1",pB:"6.1",qB:"7.1",rB:"9.1",sB:"13.1",tB:"14.1",uB:"TP",vB:"9.5-9.6",wB:"10.0-10.1",xB:"10.5",yB:"10.6",zB:"11.6","0B":"4.0-4.1","1B":"5.0-5.1","2B":"6.0-6.1","3B":"7.0-7.1","4B":"8.1-8.4","5B":"9.0-9.2","6B":"9.3","7B":"10.0-10.2","8B":"10.3","9B":"11.0-11.2",AC:"11.3-11.4",BC:"12.0-12.1",CC:"12.2-12.4",DC:"13.0-13.1",EC:"13.2",FC:"13.3",GC:"13.4-13.7",HC:"14.0-14.4",IC:"14.5",JC:"all",KC:"2.1",LC:"2.2",MC:"2.3",NC:"4.1",OC:"4.4",PC:"4.4.3-4.4.4",QC:"12.12",RC:"5.0-5.4",SC:"6.2-6.4",TC:"7.2-7.4",UC:"8.2",VC:"9.2",WC:"11.1-11.2",XC:"12.0",YC:"13.0",ZC:"14.0",aC:"10.4",bC:"7.12",cC:"2.5"};

  var browserVersions_1 = browserVersions;

  var browserVersions$1 = {
  	browserVersions: browserVersions_1
  };

  var agents={A:{A:{I:0.0131217,D:0.00621152,E:0.0262435,F:0.111535,A:0.0328044,B:0.905401,fB:0.009298},B:"ms",C:["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","fB","I","D","E","F","A","B","","",""],E:"IE",F:{fB:962323200,I:998870400,D:1161129600,E:1237420800,F:1300060800,A:1346716800,B:1381968000}},B:{A:{C:0.008542,J:0.004267,K:0.004271,L:0.008542,M:0.008542,N:0.029897,O:0.106775,R:0,S:0.004298,T:0.00944,U:0.00415,V:0.008542,W:0.012813,X:0.012813,P:0.017084,Y:0.025626,Z:2.26363,G:1.03358},B:"webkit",C:["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","C","J","K","L","M","N","O","R","S","T","U","V","W","X","P","Y","Z","G","","",""],E:"Edge",F:{C:1438128000,J:1447286400,K:1470096000,L:1491868800,M:1508198400,N:1525046400,O:1542067200,R:1579046400,S:1581033600,T:1586736000,U:1590019200,V:1594857600,W:1598486400,X:1602201600,P:1605830400,Y:1611360000,Z:1614816000,G:1618358400},D:{C:"ms",J:"ms",K:"ms",L:"ms",M:"ms",N:"ms",O:"ms"}},C:{A:{"0":0.004271,"1":0.004271,"2":0.004525,"3":0.004271,"4":0.008542,"5":0.004538,"6":0.004267,"7":0.008542,"8":0.064065,"9":0.004335,gB:0.012813,VB:0.004271,H:0.021355,a:0.004879,I:0.020136,D:0.005725,E:0.004525,F:0.00533,A:0.004283,B:0.004271,C:0.004471,J:0.004486,K:0.00453,L:0.008542,M:0.004417,N:0.004425,O:0.008542,b:0.004443,c:0.004283,d:0.008542,e:0.013698,f:0.008542,g:0.008786,h:0.017084,i:0.004317,j:0.004393,k:0.004418,l:0.008834,m:0.008542,n:0.008928,o:0.004471,p:0.009284,q:0.004707,r:0.009076,s:0.004425,t:0.004783,u:0.004271,v:0.004783,w:0.00487,x:0.005029,y:0.0047,z:0.051252,AB:0.004271,BB:0.004425,CB:0.012813,DB:0.004425,EB:0.008534,WB:0.004271,FB:0.008542,XB:0.00472,Q:0.004425,GB:0.017084,HB:0.00415,IB:0.004267,JB:0.008542,KB:0.004267,LB:0.012813,MB:0.00415,NB:0.004271,OB:0.004425,PB:0.008542,QB:0.00415,RB:0.00415,SB:0.008542,YB:0.004298,ZB:0.008542,aB:0.153756,R:0.012813,S:0.012813,T:0.012813,hB:0.021355,U:0.012813,V:0.029897,W:0.038439,X:0.08542,P:1.76819,Y:0.708986,Z:0.008542,G:0,iB:0.008786,jB:0.00487},B:"moz",C:["gB","VB","iB","jB","H","a","I","D","E","F","A","B","C","J","K","L","M","N","O","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","0","1","2","3","4","5","6","7","8","9","AB","BB","CB","DB","EB","WB","FB","XB","Q","GB","HB","IB","JB","KB","LB","MB","NB","OB","PB","QB","RB","SB","YB","ZB","aB","R","S","T","hB","U","V","W","X","P","Y","Z","G",""],E:"Firefox",F:{"0":1453852800,"1":1457395200,"2":1461628800,"3":1465257600,"4":1470096000,"5":1474329600,"6":1479168000,"7":1485216000,"8":1488844800,"9":1492560000,gB:1161648000,VB:1213660800,iB:1246320000,jB:1264032000,H:1300752000,a:1308614400,I:1313452800,D:1317081600,E:1317081600,F:1320710400,A:1324339200,B:1327968000,C:1331596800,J:1335225600,K:1338854400,L:1342483200,M:1346112000,N:1349740800,O:1353628800,b:1357603200,c:1361232000,d:1364860800,e:1368489600,f:1372118400,g:1375747200,h:1379376000,i:1386633600,j:1391472000,k:1395100800,l:1398729600,m:1402358400,n:1405987200,o:1409616000,p:1413244800,q:1417392000,r:1421107200,s:1424736000,t:1428278400,u:1431475200,v:1435881600,w:1439251200,x:1442880000,y:1446508800,z:1450137600,AB:1497312000,BB:1502150400,CB:1506556800,DB:1510617600,EB:1516665600,WB:1520985600,FB:1525824000,XB:1529971200,Q:1536105600,GB:1540252800,HB:1544486400,IB:1548720000,JB:1552953600,KB:1558396800,LB:1562630400,MB:1567468800,NB:1571788800,OB:1575331200,PB:1578355200,QB:1581379200,RB:1583798400,SB:1586304000,YB:1588636800,ZB:1591056000,aB:1593475200,R:1595894400,S:1598313600,T:1600732800,hB:1603152000,U:1605571200,V:1607990400,W:1611619200,X:1614038400,P:1616457600,Y:1618790400,Z:null,G:null}},D:{A:{"0":0.004465,"1":0.004642,"2":0.004891,"3":0.008542,"4":0.021355,"5":0.200737,"6":0.004271,"7":0.004271,"8":0.004271,"9":0.055523,H:0.004706,a:0.004879,I:0.004879,D:0.005591,E:0.005591,F:0.005591,A:0.004534,B:0.004464,C:0.010424,J:0.0083,K:0.004706,L:0.015087,M:0.004393,N:0.004393,O:0.008652,b:0.008542,c:0.004393,d:0.004317,e:0.008542,f:0.008786,g:0.025626,h:0.004461,i:0.004298,j:0.004326,k:0.0047,l:0.004538,m:0.008542,n:0.008596,o:0.004566,p:0.012813,q:0.008542,r:0.025626,s:0.004335,t:0.004464,u:0.025626,v:0.004464,w:0.012813,x:0.0236,y:0.004403,z:0.008542,AB:0.012813,BB:0.017084,CB:0.064065,DB:0.008542,EB:0.012813,WB:0.008542,FB:0.012813,XB:0.089691,Q:0.008542,GB:0.021355,HB:0.012813,IB:0.021355,JB:0.021355,KB:0.04271,LB:0.04271,MB:0.068336,NB:0.051252,OB:0.025626,PB:0.046981,QB:0.021355,RB:0.119588,SB:0.093962,YB:0.064065,ZB:0.034168,aB:0.081149,R:0.175111,S:0.102504,T:0.081149,U:0.166569,V:0.136672,W:0.205008,X:0.230634,P:0.431371,Y:0.743154,Z:16.8235,G:6.40223,kB:0.021355,lB:0.012813,mB:0},B:"webkit",C:["","","","H","a","I","D","E","F","A","B","C","J","K","L","M","N","O","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","0","1","2","3","4","5","6","7","8","9","AB","BB","CB","DB","EB","WB","FB","XB","Q","GB","HB","IB","JB","KB","LB","MB","NB","OB","PB","QB","RB","SB","YB","ZB","aB","R","S","T","U","V","W","X","P","Y","Z","G","kB","lB","mB"],E:"Chrome",F:{"0":1437523200,"1":1441152000,"2":1444780800,"3":1449014400,"4":1453248000,"5":1456963200,"6":1460592000,"7":1464134400,"8":1469059200,"9":1472601600,H:1264377600,a:1274745600,I:1283385600,D:1287619200,E:1291248000,F:1296777600,A:1299542400,B:1303862400,C:1307404800,J:1312243200,K:1316131200,L:1316131200,M:1319500800,N:1323734400,O:1328659200,b:1332892800,c:1337040000,d:1340668800,e:1343692800,f:1348531200,g:1352246400,h:1357862400,i:1361404800,j:1364428800,k:1369094400,l:1374105600,m:1376956800,n:1384214400,o:1389657600,p:1392940800,q:1397001600,r:1400544000,s:1405468800,t:1409011200,u:1412640000,v:1416268800,w:1421798400,x:1425513600,y:1429401600,z:1432080000,AB:1476230400,BB:1480550400,CB:1485302400,DB:1489017600,EB:1492560000,WB:1496707200,FB:1500940800,XB:1504569600,Q:1508198400,GB:1512518400,HB:1516752000,IB:1520294400,JB:1523923200,KB:1527552000,LB:1532390400,MB:1536019200,NB:1539648000,OB:1543968000,PB:1548720000,QB:1552348800,RB:1555977600,SB:1559606400,YB:1564444800,ZB:1568073600,aB:1571702400,R:1575936000,S:1580860800,T:1586304000,U:1589846400,V:1594684800,W:1598313600,X:1601942400,P:1605571200,Y:1611014400,Z:1614556800,G:1618272000,kB:null,lB:null,mB:null}},E:{A:{H:0,a:0.008542,I:0.004656,D:0.004465,E:0.234905,F:0.004891,A:0.004425,B:0.008542,C:0.012813,J:0.098233,K:2.95126,nB:0,bB:0.008692,oB:0.106775,pB:0.00456,qB:0.004283,rB:0.034168,cB:0.021355,TB:0.064065,UB:0.098233,sB:0.439913,tB:0.055523,uB:0},B:"webkit",C:["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","nB","bB","H","a","oB","I","pB","D","qB","E","F","rB","A","cB","B","TB","C","UB","J","sB","K","tB","uB","",""],E:"Safari",F:{nB:1205798400,bB:1226534400,H:1244419200,a:1275868800,oB:1311120000,I:1343174400,pB:1382400000,D:1382400000,qB:1410998400,E:1413417600,F:1443657600,rB:1458518400,A:1474329600,cB:1490572800,B:1505779200,TB:1522281600,C:1537142400,UB:1553472000,J:1568851200,sB:1585008000,K:1600214400,tB:1619395200,uB:null}},F:{A:{"0":0.004227,"1":0.004725,"2":0.004271,"3":0.008942,"4":0.004707,"5":0.004827,"6":0.004707,"7":0.004707,"8":0.004326,"9":0.008922,F:0.0082,B:0.016581,C:0.004317,L:0.00685,M:0.00685,N:0.00685,O:0.005014,b:0.006015,c:0.004879,d:0.006597,e:0.006597,f:0.013434,g:0.006702,h:0.006015,i:0.005595,j:0.004393,k:0.008652,l:0.004879,m:0.004879,n:0.004711,o:0.005152,p:0.005014,q:0.009758,r:0.004879,s:0.008542,t:0.004283,u:0.004367,v:0.004534,w:0.004271,x:0.004227,y:0.004418,z:0.008542,AB:0.014349,BB:0.004425,CB:0.00472,DB:0.004425,EB:0.004425,FB:0.00472,Q:0.004532,GB:0.004566,HB:0.02283,IB:0.00867,JB:0.004656,KB:0.004642,LB:0.004298,MB:0.00944,NB:0.00415,OB:0.004271,PB:0.004298,QB:0.324596,RB:0.153756,SB:0.516791,vB:0.00685,wB:0.008542,xB:0.008392,yB:0.004706,TB:0.006229,dB:0.004879,zB:0.008786,UB:0.00472},B:"webkit",C:["","","","","","","","","","","","","","","","","","","","F","vB","wB","xB","yB","B","TB","dB","zB","C","UB","L","M","N","O","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","0","1","2","3","4","5","6","7","8","9","AB","BB","CB","DB","EB","FB","Q","GB","HB","IB","JB","KB","LB","MB","NB","OB","PB","QB","RB","SB","","",""],E:"Opera",F:{"0":1490054400,"1":1494374400,"2":1498003200,"3":1502236800,"4":1506470400,"5":1510099200,"6":1515024000,"7":1517961600,"8":1521676800,"9":1525910400,F:1150761600,vB:1223424000,wB:1251763200,xB:1267488000,yB:1277942400,B:1292457600,TB:1302566400,dB:1309219200,zB:1323129600,C:1323129600,UB:1352073600,L:1372723200,M:1377561600,N:1381104000,O:1386288000,b:1390867200,c:1393891200,d:1399334400,e:1401753600,f:1405987200,g:1409616000,h:1413331200,i:1417132800,j:1422316800,k:1425945600,l:1430179200,m:1433808000,n:1438646400,o:1442448000,p:1445904000,q:1449100800,r:1454371200,s:1457308800,t:1462320000,u:1465344000,v:1470096000,w:1474329600,x:1477267200,y:1481587200,z:1486425600,AB:1530144000,BB:1534982400,CB:1537833600,DB:1543363200,EB:1548201600,FB:1554768000,Q:1561593600,GB:1566259200,HB:1570406400,IB:1573689600,JB:1578441600,KB:1583971200,LB:1587513600,MB:1592956800,NB:1595894400,OB:1600128000,PB:1603238400,QB:1613520000,RB:1612224000,SB:1616544000},D:{F:"o",B:"o",C:"o",vB:"o",wB:"o",xB:"o",yB:"o",TB:"o",dB:"o",zB:"o",UB:"o"}},G:{A:{E:0.0014611,bB:0,"0B":0,eB:0.00292219,"1B":0.00876657,"2B":0.159259,"3B":0.0321441,"4B":0.0204553,"5B":0.0262997,"6B":0.153415,"7B":0.0555216,"8B":0.159259,"9B":0.0905879,AC:0.077438,BC:0.0847435,CC:0.283452,DC:0.0715937,EC:0.0336052,FC:0.189942,GC:0.647265,HC:11.7531,IC:0.150493},B:"webkit",C:["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","bB","0B","eB","1B","2B","3B","E","4B","5B","6B","7B","8B","9B","AC","BC","CC","DC","EC","FC","GC","HC","IC","","",""],E:"Safari on iOS",F:{bB:1270252800,"0B":1283904000,eB:1299628800,"1B":1331078400,"2B":1359331200,"3B":1394409600,E:1410912000,"4B":1413763200,"5B":1442361600,"6B":1458518400,"7B":1473724800,"8B":1490572800,"9B":1505779200,AC:1522281600,BC:1537142400,CC:1553472000,DC:1568851200,EC:1572220800,FC:1580169600,GC:1585008000,HC:1600214400,IC:1619395200}},H:{A:{JC:1.0685},B:"o",C:["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","JC","","",""],E:"Opera Mini",F:{JC:1426464000}},I:{A:{VB:0,H:0.0137496,G:0,KC:0,LC:0,MC:0,NC:0.0120309,eB:0.051561,OC:0,PC:0.214838},B:"webkit",C:["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","KC","LC","MC","VB","H","NC","eB","OC","PC","G","","",""],E:"Android Browser",F:{KC:1256515200,LC:1274313600,MC:1291593600,VB:1298332800,H:1318896000,NC:1341792000,eB:1374624000,OC:1386547200,PC:1401667200,G:1618704000}},J:{A:{D:0,A:0},B:"webkit",C:["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","D","A","","",""],E:"Blackberry Browser",F:{D:1325376000,A:1359504000}},K:{A:{A:0,B:0,C:0,Q:0.0111391,TB:0,dB:0,UB:0},B:"o",C:["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","A","B","TB","dB","C","UB","Q","","",""],E:"Opera Mobile",F:{A:1287100800,B:1300752000,TB:1314835200,dB:1318291200,C:1330300800,UB:1349740800,Q:1613433600},D:{Q:"webkit"}},L:{A:{G:37.9297},B:"webkit",C:["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","G","","",""],E:"Chrome for Android",F:{G:1618704000}},M:{A:{P:0.274992},B:"moz",C:["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","P","","",""],E:"Firefox for Android",F:{P:1616457600}},N:{A:{A:0.0115934,B:0.022664},B:"ms",C:["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","A","B","","",""],E:"IE Mobile",F:{A:1340150400,B:1353456000}},O:{A:{QC:1.30048},B:"webkit",C:["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","QC","","",""],E:"UC Browser for Android",F:{QC:1471392000},D:{QC:"webkit"}},P:{A:{H:0.30804,RC:0.0103543,SC:0.010304,TC:0.071876,UC:0.0103584,VC:0.071876,cB:0.041072,WC:0.174556,XC:0.133484,YC:1.85851,ZC:0.800904},B:"webkit",C:["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","H","RC","SC","TC","UC","VC","cB","WC","XC","YC","ZC","","",""],E:"Samsung Internet",F:{H:1461024000,RC:1481846400,SC:1509408000,TC:1528329600,UC:1546128000,VC:1554163200,cB:1567900800,WC:1582588800,XC:1593475200,YC:1605657600,ZC:1618531200}},Q:{A:{aC:0.177599},B:"webkit",C:["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","aC","","",""],E:"QQ Browser",F:{aC:1589846400}},R:{A:{bC:0},B:"webkit",C:["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","bC","","",""],E:"Baidu Browser",F:{bC:1491004800}},S:{A:{cC:0.097393},B:"moz",C:["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","cC","","",""],E:"KaiOS Browser",F:{cC:1527811200}}};

  const { browsers: browsers$2 } = browsers$1;
  const versions$1 = browserVersions$1.browserVersions;


  function unpackBrowserVersions(versionsData) {
    return Object.keys(versionsData).reduce((usage, version) => {
      usage[versions$1[version]] = versionsData[version];
      return usage
    }, {})
  }

  var agents_1 = Object.keys(agents).reduce((map, key) => {
    let versionsData = agents[key];
    map[browsers$2[key]] = Object.keys(versionsData).reduce((data, entry) => {
      if (entry === 'A') {
        data.usage_global = unpackBrowserVersions(versionsData[entry]);
      } else if (entry === 'C') {
        data.versions = versionsData[entry].reduce((list, version) => {
          if (version === '') {
            list.push(null);
          } else {
            list.push(versions$1[version]);
          }
          return list
        }, []);
      } else if (entry === 'D') {
        data.prefix_exceptions = unpackBrowserVersions(versionsData[entry]);
      } else if (entry === 'E') {
        data.browser = versionsData[entry];
      } else if (entry === 'F') {
        data.release_date = Object.keys(versionsData[entry]).reduce(
          (map2, key2) => {
            map2[versions$1[key2]] = versionsData[entry][key2];
            return map2
          },
          {}
        );
      } else {
        // entry is B
        data.prefix = versionsData[entry];
      }
      return data
    }, {});
    return map
  }, {});

  var agents$1 = {
  	agents: agents_1
  };

  var v4 = {
  	start: "2015-09-08",
  	lts: "2015-10-12",
  	maintenance: "2017-04-01",
  	end: "2018-04-30",
  	codename: "Argon"
  };
  var v5 = {
  	start: "2015-10-29",
  	maintenance: "2016-04-30",
  	end: "2016-06-30"
  };
  var v6 = {
  	start: "2016-04-26",
  	lts: "2016-10-18",
  	maintenance: "2018-04-30",
  	end: "2019-04-30",
  	codename: "Boron"
  };
  var v7 = {
  	start: "2016-10-25",
  	maintenance: "2017-04-30",
  	end: "2017-06-30"
  };
  var v8 = {
  	start: "2017-05-30",
  	lts: "2017-10-31",
  	maintenance: "2019-01-01",
  	end: "2019-12-31",
  	codename: "Carbon"
  };
  var v9 = {
  	start: "2017-10-01",
  	maintenance: "2018-04-01",
  	end: "2018-06-30"
  };
  var v10 = {
  	start: "2018-04-24",
  	lts: "2018-10-30",
  	maintenance: "2020-05-19",
  	end: "2021-04-30",
  	codename: "Dubnium"
  };
  var v11 = {
  	start: "2018-10-23",
  	maintenance: "2019-04-22",
  	end: "2019-06-01"
  };
  var v12 = {
  	start: "2019-04-23",
  	lts: "2019-10-21",
  	maintenance: "2020-11-30",
  	end: "2022-04-30",
  	codename: "Erbium"
  };
  var v13 = {
  	start: "2019-10-22",
  	maintenance: "2020-04-01",
  	end: "2020-06-01"
  };
  var v14 = {
  	start: "2020-04-21",
  	lts: "2020-10-27",
  	maintenance: "2021-10-19",
  	end: "2023-04-30",
  	codename: "Fermium"
  };
  var v15 = {
  	start: "2020-10-20",
  	maintenance: "2021-04-01",
  	end: "2021-06-01"
  };
  var v16 = {
  	start: "2021-04-20",
  	lts: "2021-10-26",
  	maintenance: "2022-10-18",
  	end: "2024-04-30",
  	codename: ""
  };
  var jsEOL = {
  	"v0.8": {
  	start: "2012-06-25",
  	end: "2014-07-31"
  },
  	"v0.10": {
  	start: "2013-03-11",
  	end: "2016-10-31"
  },
  	"v0.12": {
  	start: "2015-02-06",
  	end: "2016-12-31"
  },
  	v4: v4,
  	v5: v5,
  	v6: v6,
  	v7: v7,
  	v8: v8,
  	v9: v9,
  	v10: v10,
  	v11: v11,
  	v12: v12,
  	v13: v13,
  	v14: v14,
  	v15: v15,
  	v16: v16
  };

  var versions$2 = {
  	"0.20": "39",
  	"0.21": "41",
  	"0.22": "41",
  	"0.23": "41",
  	"0.24": "41",
  	"0.25": "42",
  	"0.26": "42",
  	"0.27": "43",
  	"0.28": "43",
  	"0.29": "43",
  	"0.30": "44",
  	"0.31": "45",
  	"0.32": "45",
  	"0.33": "45",
  	"0.34": "45",
  	"0.35": "45",
  	"0.36": "47",
  	"0.37": "49",
  	"1.0": "49",
  	"1.1": "50",
  	"1.2": "51",
  	"1.3": "52",
  	"1.4": "53",
  	"1.5": "54",
  	"1.6": "56",
  	"1.7": "58",
  	"1.8": "59",
  	"2.0": "61",
  	"2.1": "61",
  	"3.0": "66",
  	"3.1": "66",
  	"4.0": "69",
  	"4.1": "69",
  	"4.2": "69",
  	"5.0": "73",
  	"6.0": "76",
  	"6.1": "76",
  	"7.0": "78",
  	"7.1": "78",
  	"7.2": "78",
  	"7.3": "78",
  	"8.0": "80",
  	"8.1": "80",
  	"8.2": "80",
  	"8.3": "80",
  	"8.4": "80",
  	"8.5": "80",
  	"9.0": "83",
  	"9.1": "83",
  	"9.2": "83",
  	"9.3": "83",
  	"9.4": "83",
  	"10.0": "85",
  	"10.1": "85",
  	"10.2": "85",
  	"10.3": "85",
  	"10.4": "85",
  	"11.0": "87",
  	"11.1": "87",
  	"11.2": "87",
  	"11.3": "87",
  	"11.4": "87",
  	"12.0": "89",
  	"13.0": "91"
  };

  function BrowserslistError (message) {
    this.name = 'BrowserslistError';
    this.message = message;
    this.browserslist = true;
    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, BrowserslistError);
    }
  }

  BrowserslistError.prototype = Error.prototype;

  var error$1 = BrowserslistError;

  function noop$1 () { }

  var browser$2 = {
    loadQueries: function loadQueries () {
      throw new error$1(
        'Sharable configs are not supported in client-side build of Browserslist')
    },

    getStat: function getStat (opts) {
      return opts.stats
    },

    loadConfig: function loadConfig (opts) {
      if (opts.config) {
        throw new error$1(
          'Browserslist config are not supported in client-side build')
      }
    },

    loadCountry: function loadCountry () {
      throw new error$1(
        'Country statistics are not supported ' +
        'in client-side build of Browserslist')
    },

    loadFeature: function loadFeature () {
      throw new error$1(
        'Supports queries are not available in client-side build of Browserslist')
    },

    currentNode: function currentNode (resolve, context) {
      return resolve(['maintained node versions'], context)[0]
    },

    parseConfig: noop$1,

    readConfig: noop$1,

    findConfig: noop$1,

    clearCaches: noop$1,

    oldDataWarning: noop$1
  };

  var agents$2 = agents$1.agents;





   // Will load browser.js in webpack

  var YEAR = 365.259641 * 24 * 60 * 60 * 1000;
  var ANDROID_EVERGREEN_FIRST = 37;

  var QUERY_OR = 1;
  var QUERY_AND = 2;

  function isVersionsMatch (versionA, versionB) {
    return (versionA + '.').indexOf(versionB + '.') === 0
  }

  function isEolReleased (name) {
    var version = name.slice(1);
    return jsReleases.some(function (i) {
      return isVersionsMatch(i.version, version)
    })
  }

  function normalize$1 (versions) {
    return versions.filter(function (version) {
      return typeof version === 'string'
    })
  }

  function normalizeElectron (version) {
    var versionToUse = version;
    if (version.split('.').length === 3) {
      versionToUse = version
        .split('.')
        .slice(0, -1)
        .join('.');
    }
    return versionToUse
  }

  function nameMapper (name) {
    return function mapName (version) {
      return name + ' ' + version
    }
  }

  function getMajor (version) {
    return parseInt(version.split('.')[0])
  }

  function getMajorVersions (released, number) {
    if (released.length === 0) return []
    var majorVersions = uniq(released.map(getMajor));
    var minimum = majorVersions[majorVersions.length - number];
    if (!minimum) {
      return released
    }
    var selected = [];
    for (var i = released.length - 1; i >= 0; i--) {
      if (minimum > getMajor(released[i])) break
      selected.unshift(released[i]);
    }
    return selected
  }

  function uniq (array) {
    var filtered = [];
    for (var i = 0; i < array.length; i++) {
      if (filtered.indexOf(array[i]) === -1) filtered.push(array[i]);
    }
    return filtered
  }

  // Helpers

  function fillUsage (result, name, data) {
    for (var i in data) {
      result[name + ' ' + i] = data[i];
    }
  }

  function generateFilter (sign, version) {
    version = parseFloat(version);
    if (sign === '>') {
      return function (v) {
        return parseFloat(v) > version
      }
    } else if (sign === '>=') {
      return function (v) {
        return parseFloat(v) >= version
      }
    } else if (sign === '<') {
      return function (v) {
        return parseFloat(v) < version
      }
    } else {
      return function (v) {
        return parseFloat(v) <= version
      }
    }
  }

  function generateSemverFilter (sign, version) {
    version = version.split('.').map(parseSimpleInt);
    version[1] = version[1] || 0;
    version[2] = version[2] || 0;
    if (sign === '>') {
      return function (v) {
        v = v.split('.').map(parseSimpleInt);
        return compareSemver(v, version) > 0
      }
    } else if (sign === '>=') {
      return function (v) {
        v = v.split('.').map(parseSimpleInt);
        return compareSemver(v, version) >= 0
      }
    } else if (sign === '<') {
      return function (v) {
        v = v.split('.').map(parseSimpleInt);
        return compareSemver(version, v) > 0
      }
    } else {
      return function (v) {
        v = v.split('.').map(parseSimpleInt);
        return compareSemver(version, v) >= 0
      }
    }
  }

  function parseSimpleInt (x) {
    return parseInt(x)
  }

  function compare (a, b) {
    if (a < b) return -1
    if (a > b) return +1
    return 0
  }

  function compareSemver (a, b) {
    return (
      compare(parseInt(a[0]), parseInt(b[0])) ||
      compare(parseInt(a[1] || '0'), parseInt(b[1] || '0')) ||
      compare(parseInt(a[2] || '0'), parseInt(b[2] || '0'))
    )
  }

  // this follows the npm-like semver behavior
  function semverFilterLoose (operator, range) {
    range = range.split('.').map(parseSimpleInt);
    if (typeof range[1] === 'undefined') {
      range[1] = 'x';
    }
    // ignore any patch version because we only return minor versions
    // range[2] = 'x'
    switch (operator) {
      case '<=':
        return function (version) {
          version = version.split('.').map(parseSimpleInt);
          return compareSemverLoose(version, range) <= 0
        }
      default:
      case '>=':
        return function (version) {
          version = version.split('.').map(parseSimpleInt);
          return compareSemverLoose(version, range) >= 0
        }
    }
  }

  // this follows the npm-like semver behavior
  function compareSemverLoose (version, range) {
    if (version[0] !== range[0]) {
      return version[0] < range[0] ? -1 : +1
    }
    if (range[1] === 'x') {
      return 0
    }
    if (version[1] !== range[1]) {
      return version[1] < range[1] ? -1 : +1
    }
    return 0
  }

  function resolveVersion (data, version) {
    if (data.versions.indexOf(version) !== -1) {
      return version
    } else if (browserslist.versionAliases[data.name][version]) {
      return browserslist.versionAliases[data.name][version]
    } else {
      return false
    }
  }

  function normalizeVersion (data, version) {
    var resolved = resolveVersion(data, version);
    if (resolved) {
      return resolved
    } else if (data.versions.length === 1) {
      return data.versions[0]
    } else {
      return false
    }
  }

  function filterByYear (since, context) {
    since = since / 1000;
    return Object.keys(agents$2).reduce(function (selected, name) {
      var data = byName(name, context);
      if (!data) return selected
      var versions = Object.keys(data.releaseDate).filter(function (v) {
        return data.releaseDate[v] >= since
      });
      return selected.concat(versions.map(nameMapper(data.name)))
    }, [])
  }

  function cloneData (data) {
    return {
      name: data.name,
      versions: data.versions,
      released: data.released,
      releaseDate: data.releaseDate
    }
  }

  function mapVersions (data, map) {
    data.versions = data.versions.map(function (i) {
      return map[i] || i
    });
    data.released = data.versions.map(function (i) {
      return map[i] || i
    });
    var fixedDate = { };
    for (var i in data.releaseDate) {
      fixedDate[map[i] || i] = data.releaseDate[i];
    }
    data.releaseDate = fixedDate;
    return data
  }

  function byName (name, context) {
    name = name.toLowerCase();
    name = browserslist.aliases[name] || name;
    if (context.mobileToDesktop && browserslist.desktopNames[name]) {
      var desktop = browserslist.data[browserslist.desktopNames[name]];
      if (name === 'android') {
        return normalizeAndroidData(cloneData(browserslist.data[name]), desktop)
      } else {
        var cloned = cloneData(desktop);
        cloned.name = name;
        if (name === 'op_mob') {
          cloned = mapVersions(cloned, { '10.0-10.1': '10' });
        }
        return cloned
      }
    }
    return browserslist.data[name]
  }

  function normalizeAndroidVersions (androidVersions, chromeVersions) {
    var firstEvergreen = ANDROID_EVERGREEN_FIRST;
    var last = chromeVersions[chromeVersions.length - 1];
    return androidVersions
      .filter(function (version) { return /^(?:[2-4]\.|[34]$)/.test(version) })
      .concat(chromeVersions.slice(firstEvergreen - last - 1))
  }

  function normalizeAndroidData (android, chrome) {
    android.released = normalizeAndroidVersions(android.released, chrome.released);
    android.versions = normalizeAndroidVersions(android.versions, chrome.versions);
    return android
  }

  function checkName (name, context) {
    var data = byName(name, context);
    if (!data) throw new error$1('Unknown browser ' + name)
    return data
  }

  function unknownQuery (query) {
    return new error$1(
      'Unknown browser query `' + query + '`. ' +
      'Maybe you are using old Browserslist or made typo in query.'
    )
  }

  function filterAndroid (list, versions, context) {
    if (context.mobileToDesktop) return list
    var released = browserslist.data.android.released;
    var last = released[released.length - 1];
    var diff = last - ANDROID_EVERGREEN_FIRST - versions;
    if (diff > 0) {
      return list.slice(-1)
    } else {
      return list.slice(diff - 1)
    }
  }

  /**
   * Resolves queries into a browser list.
   * @param {string|string[]} queries Queries to combine.
   * Either an array of queries or a long string of queries.
   * @param {object} [context] Optional arguments to
   * the select function in `queries`.
   * @returns {string[]} A list of browsers
   */
  function resolve$3 (queries, context) {
    if (Array.isArray(queries)) {
      queries = flatten(queries.map(parse$4));
    } else {
      queries = parse$4(queries);
    }

    return queries.reduce(function (result, query, index) {
      var selection = query.queryString;

      var isExclude = selection.indexOf('not ') === 0;
      if (isExclude) {
        if (index === 0) {
          throw new error$1(
            'Write any browsers query (for instance, `defaults`) ' +
            'before `' + selection + '`')
        }
        selection = selection.slice(4);
      }

      for (var i = 0; i < QUERIES.length; i++) {
        var type = QUERIES[i];
        var match = selection.match(type.regexp);
        if (match) {
          var args = [context].concat(match.slice(1));
          var array = type.select.apply(browserslist, args).map(function (j) {
            var parts = j.split(' ');
            if (parts[1] === '0') {
              return parts[0] + ' ' + byName(parts[0], context).versions[0]
            } else {
              return j
            }
          });

          switch (query.type) {
            case QUERY_AND:
              if (isExclude) {
                return result.filter(function (j) {
                  return array.indexOf(j) === -1
                })
              } else {
                return result.filter(function (j) {
                  return array.indexOf(j) !== -1
                })
              }
            case QUERY_OR:
            default:
              if (isExclude) {
                var filter = { };
                array.forEach(function (j) {
                  filter[j] = true;
                });
                return result.filter(function (j) {
                  return !filter[j]
                })
              }
              return result.concat(array)
          }
        }
      }

      throw unknownQuery(selection)
    }, [])
  }

  var cache = { };

  /**
   * Return array of browsers by selection queries.
   *
   * @param {(string|string[])} [queries=browserslist.defaults] Browser queries.
   * @param {object} [opts] Options.
   * @param {string} [opts.path="."] Path to processed file.
   *                                 It will be used to find config files.
   * @param {string} [opts.env="production"] Processing environment.
   *                                         It will be used to take right
   *                                         queries from config file.
   * @param {string} [opts.config] Path to config file with queries.
   * @param {object} [opts.stats] Custom browser usage statistics
   *                              for "> 1% in my stats" query.
   * @param {boolean} [opts.ignoreUnknownVersions=false] Do not throw on unknown
   *                                                     version in direct query.
   * @param {boolean} [opts.dangerousExtend] Disable security checks
   *                                         for extend query.
   * @param {boolean} [opts.mobileToDesktop] Alias mobile browsers to the desktop
   *                                         version when Can I Use doesn't have
   *                                         data about the specified version.
   * @returns {string[]} Array with browser names in Can I Use.
   *
   * @example
   * browserslist('IE >= 10, IE 8') //=> ['ie 11', 'ie 10', 'ie 8']
   */
  function browserslist (queries, opts) {
    if (typeof opts === 'undefined') opts = { };

    if (typeof opts.path === 'undefined') {
      opts.path = colorette.resolve ? colorette.resolve('.') : '.';
    }

    if (typeof queries === 'undefined' || queries === null) {
      var config = browserslist.loadConfig(opts);
      if (config) {
        queries = config;
      } else {
        queries = browserslist.defaults;
      }
    }

    if (!(typeof queries === 'string' || Array.isArray(queries))) {
      throw new error$1(
        'Browser queries must be an array or string. Got ' + typeof queries + '.')
    }

    var context = {
      ignoreUnknownVersions: opts.ignoreUnknownVersions,
      dangerousExtend: opts.dangerousExtend,
      mobileToDesktop: opts.mobileToDesktop,
      path: opts.path,
      env: opts.env
    };

    browser$2.oldDataWarning(browserslist.data);
    var stats = browser$2.getStat(opts, browserslist.data);
    if (stats) {
      context.customUsage = { };
      for (var browser in stats) {
        fillUsage(context.customUsage, browser, stats[browser]);
      }
    }

    var cacheKey = JSON.stringify([queries, context]);
    if (cache[cacheKey]) return cache[cacheKey]

    var result = uniq(resolve$3(queries, context)).sort(function (name1, name2) {
      name1 = name1.split(' ');
      name2 = name2.split(' ');
      if (name1[0] === name2[0]) {
        // assumptions on caniuse data
        // 1) version ranges never overlaps
        // 2) if version is not a range, it never contains `-`
        var version1 = name1[1].split('-')[0];
        var version2 = name2[1].split('-')[0];
        return compareSemver(version2.split('.'), version1.split('.'))
      } else {
        return compare(name1[0], name2[0])
      }
    });
    if (!browser$1.env.BROWSERSLIST_DISABLE_CACHE) {
      cache[cacheKey] = result;
    }
    return result
  }

  function parse$4 (queries) {
    var qs = [];
    do {
      queries = doMatch(queries, qs);
    } while (queries)
    return qs
  }

  function doMatch (string, qs) {
    var or = /^(?:,\s*|\s+or\s+)(.*)/i;
    var and = /^\s+and\s+(.*)/i;

    return find(string, function (parsed, n, max) {
      if (and.test(parsed)) {
        qs.unshift({ type: QUERY_AND, queryString: parsed.match(and)[1] });
        return true
      } else if (or.test(parsed)) {
        qs.unshift({ type: QUERY_OR, queryString: parsed.match(or)[1] });
        return true
      } else if (n === max) {
        qs.unshift({ type: QUERY_OR, queryString: parsed.trim() });
        return true
      }
      return false
    })
  }

  function find (string, predicate) {
    for (var n = 1, max = string.length; n <= max; n++) {
      var parsed = string.substr(-n, n);
      if (predicate(parsed, n, max)) {
        return string.slice(0, -n)
      }
    }
    return ''
  }

  function flatten (array) {
    if (!Array.isArray(array)) return [array]
    return array.reduce(function (a, b) {
      return a.concat(flatten(b))
    }, [])
  }

  // Will be filled by Can I Use data below
  browserslist.cache = { };
  browserslist.data = { };
  browserslist.usage = {
    global: { },
    custom: null
  };

  // Default browsers query
  browserslist.defaults = [
    '> 0.5%',
    'last 2 versions',
    'Firefox ESR',
    'not dead'
  ];

  // Browser names aliases
  browserslist.aliases = {
    fx: 'firefox',
    ff: 'firefox',
    ios: 'ios_saf',
    explorer: 'ie',
    blackberry: 'bb',
    explorermobile: 'ie_mob',
    operamini: 'op_mini',
    operamobile: 'op_mob',
    chromeandroid: 'and_chr',
    firefoxandroid: 'and_ff',
    ucandroid: 'and_uc',
    qqandroid: 'and_qq'
  };

  // Can I Use only provides a few versions for some browsers (e.g. and_chr).
  // Fallback to a similar browser for unknown versions
  browserslist.desktopNames = {
    and_chr: 'chrome',
    and_ff: 'firefox',
    ie_mob: 'ie',
    op_mob: 'opera',
    android: 'chrome' // has extra processing logic
  };

  // Aliases to work with joined versions like `ios_saf 7.0-7.1`
  browserslist.versionAliases = { };

  browserslist.clearCaches = browser$2.clearCaches;
  browserslist.parseConfig = browser$2.parseConfig;
  browserslist.readConfig = browser$2.readConfig;
  browserslist.findConfig = browser$2.findConfig;
  browserslist.loadConfig = browser$2.loadConfig;

  /**
   * Return browsers market coverage.
   *
   * @param {string[]} browsers Browsers names in Can I Use.
   * @param {string|object} [stats="global"] Which statistics should be used.
   *                                         Country code or custom statistics.
   *                                         Pass `"my stats"` to load statistics
   *                                         from Browserslist files.
   *
   * @return {number} Total market coverage for all selected browsers.
   *
   * @example
   * browserslist.coverage(browserslist('> 1% in US'), 'US') //=> 83.1
   */
  browserslist.coverage = function (browsers, stats) {
    var data;
    if (typeof stats === 'undefined') {
      data = browserslist.usage.global;
    } else if (stats === 'my stats') {
      var opts = {};
      opts.path = colorette.resolve ? colorette.resolve('.') : '.';
      var customStats = browser$2.getStat(opts);
      if (!customStats) {
        throw new error$1('Custom usage statistics was not provided')
      }
      data = {};
      for (var browser in customStats) {
        fillUsage(data, browser, customStats[browser]);
      }
    } else if (typeof stats === 'string') {
      if (stats.length > 2) {
        stats = stats.toLowerCase();
      } else {
        stats = stats.toUpperCase();
      }
      browser$2.loadCountry(browserslist.usage, stats, browserslist.data);
      data = browserslist.usage[stats];
    } else {
      if ('dataByBrowser' in stats) {
        stats = stats.dataByBrowser;
      }
      data = { };
      for (var name in stats) {
        for (var version in stats[name]) {
          data[name + ' ' + version] = stats[name][version];
        }
      }
    }

    return browsers.reduce(function (all, i) {
      var usage = data[i];
      if (usage === undefined) {
        usage = data[i.replace(/ \S+$/, ' 0')];
      }
      return all + (usage || 0)
    }, 0)
  };

  function nodeQuery (context, version) {
    var nodeReleases = jsReleases.filter(function (i) {
      return i.name === 'nodejs'
    });
    var matched = nodeReleases.filter(function (i) {
      return isVersionsMatch(i.version, version)
    });
    if (matched.length === 0) {
      if (context.ignoreUnknownVersions) {
        return []
      } else {
        throw new error$1('Unknown version ' + version + ' of Node.js')
      }
    }
    return ['node ' + matched[matched.length - 1].version]
  }

  function sinceQuery (context, year, month, date) {
    year = parseInt(year);
    month = parseInt(month || '01') - 1;
    date = parseInt(date || '01');
    return filterByYear(Date.UTC(year, month, date, 0, 0, 0), context)
  }

  function coverQuery (context, coverage, statMode) {
    coverage = parseFloat(coverage);
    var usage = browserslist.usage.global;
    if (statMode) {
      if (statMode.match(/^my\s+stats$/)) {
        if (!context.customUsage) {
          throw new error$1(
            'Custom usage statistics was not provided'
          )
        }
        usage = context.customUsage;
      } else {
        var place;
        if (statMode.length === 2) {
          place = statMode.toUpperCase();
        } else {
          place = statMode.toLowerCase();
        }
        browser$2.loadCountry(browserslist.usage, place, browserslist.data);
        usage = browserslist.usage[place];
      }
    }
    var versions = Object.keys(usage).sort(function (a, b) {
      return usage[b] - usage[a]
    });
    var coveraged = 0;
    var result = [];
    var version;
    for (var i = 0; i <= versions.length; i++) {
      version = versions[i];
      if (usage[version] === 0) break
      coveraged += usage[version];
      result.push(version);
      if (coveraged >= coverage) break
    }
    return result
  }

  var QUERIES = [
    {
      regexp: /^last\s+(\d+)\s+major\s+versions?$/i,
      select: function (context, versions) {
        return Object.keys(agents$2).reduce(function (selected, name) {
          var data = byName(name, context);
          if (!data) return selected
          var list = getMajorVersions(data.released, versions);
          list = list.map(nameMapper(data.name));
          if (data.name === 'android') {
            list = filterAndroid(list, versions, context);
          }
          return selected.concat(list)
        }, [])
      }
    },
    {
      regexp: /^last\s+(\d+)\s+versions?$/i,
      select: function (context, versions) {
        return Object.keys(agents$2).reduce(function (selected, name) {
          var data = byName(name, context);
          if (!data) return selected
          var list = data.released.slice(-versions);
          list = list.map(nameMapper(data.name));
          if (data.name === 'android') {
            list = filterAndroid(list, versions, context);
          }
          return selected.concat(list)
        }, [])
      }
    },
    {
      regexp: /^last\s+(\d+)\s+electron\s+major\s+versions?$/i,
      select: function (context, versions) {
        var validVersions = getMajorVersions(Object.keys(versions$2), versions);
        return validVersions.map(function (i) {
          return 'chrome ' + versions$2[i]
        })
      }
    },
    {
      regexp: /^last\s+(\d+)\s+(\w+)\s+major\s+versions?$/i,
      select: function (context, versions, name) {
        var data = checkName(name, context);
        var validVersions = getMajorVersions(data.released, versions);
        var list = validVersions.map(nameMapper(data.name));
        if (data.name === 'android') {
          list = filterAndroid(list, versions, context);
        }
        return list
      }
    },
    {
      regexp: /^last\s+(\d+)\s+electron\s+versions?$/i,
      select: function (context, versions) {
        return Object.keys(versions$2)
          .slice(-versions)
          .map(function (i) {
            return 'chrome ' + versions$2[i]
          })
      }
    },
    {
      regexp: /^last\s+(\d+)\s+(\w+)\s+versions?$/i,
      select: function (context, versions, name) {
        var data = checkName(name, context);
        var list = data.released.slice(-versions).map(nameMapper(data.name));
        if (data.name === 'android') {
          list = filterAndroid(list, versions, context);
        }
        return list
      }
    },
    {
      regexp: /^unreleased\s+versions$/i,
      select: function (context) {
        return Object.keys(agents$2).reduce(function (selected, name) {
          var data = byName(name, context);
          if (!data) return selected
          var list = data.versions.filter(function (v) {
            return data.released.indexOf(v) === -1
          });
          list = list.map(nameMapper(data.name));
          return selected.concat(list)
        }, [])
      }
    },
    {
      regexp: /^unreleased\s+electron\s+versions?$/i,
      select: function () {
        return []
      }
    },
    {
      regexp: /^unreleased\s+(\w+)\s+versions?$/i,
      select: function (context, name) {
        var data = checkName(name, context);
        return data.versions
          .filter(function (v) {
            return data.released.indexOf(v) === -1
          })
          .map(nameMapper(data.name))
      }
    },
    {
      regexp: /^last\s+(\d*.?\d+)\s+years?$/i,
      select: function (context, years) {
        return filterByYear(Date.now() - YEAR * years, context)
      }
    },
    {
      regexp: /^since (\d+)$/i,
      select: sinceQuery
    },
    {
      regexp: /^since (\d+)-(\d+)$/i,
      select: sinceQuery
    },
    {
      regexp: /^since (\d+)-(\d+)-(\d+)$/i,
      select: sinceQuery
    },
    {
      regexp: /^(>=?|<=?)\s*(\d+|\d+\.\d+|\.\d+)%$/,
      select: function (context, sign, popularity) {
        popularity = parseFloat(popularity);
        var usage = browserslist.usage.global;
        return Object.keys(usage).reduce(function (result, version) {
          if (sign === '>') {
            if (usage[version] > popularity) {
              result.push(version);
            }
          } else if (sign === '<') {
            if (usage[version] < popularity) {
              result.push(version);
            }
          } else if (sign === '<=') {
            if (usage[version] <= popularity) {
              result.push(version);
            }
          } else if (usage[version] >= popularity) {
            result.push(version);
          }
          return result
        }, [])
      }
    },
    {
      regexp: /^(>=?|<=?)\s*(\d+|\d+\.\d+|\.\d+)%\s+in\s+my\s+stats$/,
      select: function (context, sign, popularity) {
        popularity = parseFloat(popularity);
        if (!context.customUsage) {
          throw new error$1('Custom usage statistics was not provided')
        }
        var usage = context.customUsage;
        return Object.keys(usage).reduce(function (result, version) {
          if (sign === '>') {
            if (usage[version] > popularity) {
              result.push(version);
            }
          } else if (sign === '<') {
            if (usage[version] < popularity) {
              result.push(version);
            }
          } else if (sign === '<=') {
            if (usage[version] <= popularity) {
              result.push(version);
            }
          } else if (usage[version] >= popularity) {
            result.push(version);
          }
          return result
        }, [])
      }
    },
    {
      regexp: /^(>=?|<=?)\s*(\d+|\d+\.\d+|\.\d+)%\s+in\s+(\S+)\s+stats$/,
      select: function (context, sign, popularity, name) {
        popularity = parseFloat(popularity);
        var stats = browser$2.loadStat(context, name, browserslist.data);
        if (stats) {
          context.customUsage = {};
          for (var browser in stats) {
            fillUsage(context.customUsage, browser, stats[browser]);
          }
        }
        if (!context.customUsage) {
          throw new error$1('Custom usage statistics was not provided')
        }
        var usage = context.customUsage;
        return Object.keys(usage).reduce(function (result, version) {
          if (sign === '>') {
            if (usage[version] > popularity) {
              result.push(version);
            }
          } else if (sign === '<') {
            if (usage[version] < popularity) {
              result.push(version);
            }
          } else if (sign === '<=') {
            if (usage[version] <= popularity) {
              result.push(version);
            }
          } else if (usage[version] >= popularity) {
            result.push(version);
          }
          return result
        }, [])
      }
    },
    {
      regexp: /^(>=?|<=?)\s*(\d+|\d+\.\d+|\.\d+)%\s+in\s+((alt-)?\w\w)$/,
      select: function (context, sign, popularity, place) {
        popularity = parseFloat(popularity);
        if (place.length === 2) {
          place = place.toUpperCase();
        } else {
          place = place.toLowerCase();
        }
        browser$2.loadCountry(browserslist.usage, place, browserslist.data);
        var usage = browserslist.usage[place];
        return Object.keys(usage).reduce(function (result, version) {
          if (sign === '>') {
            if (usage[version] > popularity) {
              result.push(version);
            }
          } else if (sign === '<') {
            if (usage[version] < popularity) {
              result.push(version);
            }
          } else if (sign === '<=') {
            if (usage[version] <= popularity) {
              result.push(version);
            }
          } else if (usage[version] >= popularity) {
            result.push(version);
          }
          return result
        }, [])
      }
    },
    {
      regexp: /^cover\s+(\d+|\d+\.\d+|\.\d+)%$/,
      select: coverQuery
    },
    {
      regexp: /^cover\s+(\d+|\d+\.\d+|\.\d+)%\s+in\s+(my\s+stats|(alt-)?\w\w)$/,
      select: coverQuery
    },
    {
      regexp: /^supports\s+([\w-]+)$/,
      select: function (context, feature) {
        browser$2.loadFeature(browserslist.cache, feature);
        var features = browserslist.cache[feature];
        return Object.keys(features).reduce(function (result, version) {
          var flags = features[version];
          if (flags.indexOf('y') >= 0 || flags.indexOf('a') >= 0) {
            result.push(version);
          }
          return result
        }, [])
      }
    },
    {
      regexp: /^electron\s+([\d.]+)\s*-\s*([\d.]+)$/i,
      select: function (context, from, to) {
        var fromToUse = normalizeElectron(from);
        var toToUse = normalizeElectron(to);
        if (!versions$2[fromToUse]) {
          throw new error$1('Unknown version ' + from + ' of electron')
        }
        if (!versions$2[toToUse]) {
          throw new error$1('Unknown version ' + to + ' of electron')
        }
        from = parseFloat(from);
        to = parseFloat(to);
        return Object.keys(versions$2)
          .filter(function (i) {
            var parsed = parseFloat(i);
            return parsed >= from && parsed <= to
          })
          .map(function (i) {
            return 'chrome ' + versions$2[i]
          })
      }
    },
    {
      regexp: /^node\s+([\d.]+)\s*-\s*([\d.]+)$/i,
      select: function (context, from, to) {
        var nodeVersions = jsReleases
          .filter(function (i) {
            return i.name === 'nodejs'
          })
          .map(function (i) {
            return i.version
          });
        return nodeVersions
          .filter(semverFilterLoose('>=', from))
          .filter(semverFilterLoose('<=', to))
          .map(function (v) {
            return 'node ' + v
          })
      }
    },
    {
      regexp: /^(\w+)\s+([\d.]+)\s*-\s*([\d.]+)$/i,
      select: function (context, name, from, to) {
        var data = checkName(name, context);
        from = parseFloat(normalizeVersion(data, from) || from);
        to = parseFloat(normalizeVersion(data, to) || to);
        function filter (v) {
          var parsed = parseFloat(v);
          return parsed >= from && parsed <= to
        }
        return data.released.filter(filter).map(nameMapper(data.name))
      }
    },
    {
      regexp: /^electron\s*(>=?|<=?)\s*([\d.]+)$/i,
      select: function (context, sign, version) {
        var versionToUse = normalizeElectron(version);
        return Object.keys(versions$2)
          .filter(generateFilter(sign, versionToUse))
          .map(function (i) {
            return 'chrome ' + versions$2[i]
          })
      }
    },
    {
      regexp: /^node\s*(>=?|<=?)\s*([\d.]+)$/i,
      select: function (context, sign, version) {
        var nodeVersions = jsReleases
          .filter(function (i) {
            return i.name === 'nodejs'
          })
          .map(function (i) {
            return i.version
          });
        return nodeVersions
          .filter(generateSemverFilter(sign, version))
          .map(function (v) {
            return 'node ' + v
          })
      }
    },
    {
      regexp: /^(\w+)\s*(>=?|<=?)\s*([\d.]+)$/,
      select: function (context, name, sign, version) {
        var data = checkName(name, context);
        var alias = browserslist.versionAliases[data.name][version];
        if (alias) {
          version = alias;
        }
        return data.released
          .filter(generateFilter(sign, version))
          .map(function (v) {
            return data.name + ' ' + v
          })
      }
    },
    {
      regexp: /^(firefox|ff|fx)\s+esr$/i,
      select: function () {
        return ['firefox 78']
      }
    },
    {
      regexp: /(operamini|op_mini)\s+all/i,
      select: function () {
        return ['op_mini all']
      }
    },
    {
      regexp: /^electron\s+([\d.]+)$/i,
      select: function (context, version) {
        var versionToUse = normalizeElectron(version);
        var chrome = versions$2[versionToUse];
        if (!chrome) {
          throw new error$1(
            'Unknown version ' + version + ' of electron'
          )
        }
        return ['chrome ' + chrome]
      }
    },
    {
      regexp: /^node\s+(\d+)$/i,
      select: nodeQuery
    },
    {
      regexp: /^node\s+(\d+\.\d+)$/i,
      select: nodeQuery
    },
    {
      regexp: /^node\s+(\d+\.\d+\.\d+)$/i,
      select: nodeQuery
    },
    {
      regexp: /^current\s+node$/i,
      select: function (context) {
        return [browser$2.currentNode(resolve$3, context)]
      }
    },
    {
      regexp: /^maintained\s+node\s+versions$/i,
      select: function (context) {
        var now = Date.now();
        var queries = Object.keys(jsEOL)
          .filter(function (key) {
            return (
              now < Date.parse(jsEOL[key].end) &&
              now > Date.parse(jsEOL[key].start) &&
              isEolReleased(key)
            )
          })
          .map(function (key) {
            return 'node ' + key.slice(1)
          });
        return resolve$3(queries, context)
      }
    },
    {
      regexp: /^phantomjs\s+1.9$/i,
      select: function () {
        return ['safari 5']
      }
    },
    {
      regexp: /^phantomjs\s+2.1$/i,
      select: function () {
        return ['safari 6']
      }
    },
    {
      regexp: /^(\w+)\s+(tp|[\d.]+)$/i,
      select: function (context, name, version) {
        if (/^tp$/i.test(version)) version = 'TP';
        var data = checkName(name, context);
        var alias = normalizeVersion(data, version);
        if (alias) {
          version = alias;
        } else {
          if (version.indexOf('.') === -1) {
            alias = version + '.0';
          } else {
            alias = version.replace(/\.0$/, '');
          }
          alias = normalizeVersion(data, alias);
          if (alias) {
            version = alias;
          } else if (context.ignoreUnknownVersions) {
            return []
          } else {
            throw new error$1(
              'Unknown version ' + version + ' of ' + name
            )
          }
        }
        return [data.name + ' ' + version]
      }
    },
    {
      regexp: /^browserslist config$/i,
      select: function (context) {
        return browserslist(undefined, context)
      }
    },
    {
      regexp: /^extends (.+)$/i,
      select: function (context, name) {
        return resolve$3(browser$2.loadQueries(context, name), context)
      }
    },
    {
      regexp: /^defaults$/i,
      select: function (context) {
        return resolve$3(browserslist.defaults, context)
      }
    },
    {
      regexp: /^dead$/i,
      select: function (context) {
        var dead = [
          'ie <= 10',
          'ie_mob <= 11',
          'bb <= 10',
          'op_mob <= 12.1',
          'samsung 4'
        ];
        return resolve$3(dead, context)
      }
    },
    {
      regexp: /^(\w+)$/i,
      select: function (context, name) {
        if (byName(name, context)) {
          throw new error$1(
            'Specify versions in Browserslist query for browser ' + name
          )
        } else {
          throw unknownQuery(name)
        }
      }
    }
  ];

  // Get and convert Can I Use data

  (function () {
    for (var name in agents$2) {
      var browser = agents$2[name];
      browserslist.data[name] = {
        name: name,
        versions: normalize$1(agents$2[name].versions),
        released: normalize$1(agents$2[name].versions.slice(0, -3)),
        releaseDate: agents$2[name].release_date
      };
      fillUsage(browserslist.usage.global, name, browser.usage_global);

      browserslist.versionAliases[name] = { };
      for (var i = 0; i < browser.versions.length; i++) {
        var full = browser.versions[i];
        if (!full) continue

        if (full.indexOf('-') !== -1) {
          var interval = full.split('-');
          for (var j = 0; j < interval.length; j++) {
            browserslist.versionAliases[name][interval[j]] = full;
          }
        }
      }
    }

    browserslist.versionAliases.op_mob['59'] = '58';
  }());

  var browserslist_1 = browserslist;

  var statuses = {
    1: 'ls', // WHATWG Living Standard
    2: 'rec', // W3C Recommendation
    3: 'pr', // W3C Proposed Recommendation
    4: 'cr', // W3C Candidate Recommendation
    5: 'wd', // W3C Working Draft
    6: 'other', // Non-W3C, but reputable
    7: 'unoff' // Unofficial, Editor's Draft or W3C "Note"
  };

  var supported = {
    y: 1 << 0,
    n: 1 << 1,
    a: 1 << 2,
    p: 1 << 3,
    u: 1 << 4,
    x: 1 << 5,
    d: 1 << 6
  };

  const { browsers: browsers$3 } = browsers$1;
  const versions$3 = browserVersions$1.browserVersions;

  const MATH2LOG = Math.log(2);

  function unpackSupport(cipher) {
    // bit flags
    let stats = Object.keys(supported).reduce((list, support) => {
      if (cipher & supported[support]) list.push(support);
      return list
    }, []);

    // notes
    let notes = cipher >> 7;
    let notesArray = [];
    while (notes) {
      let note = Math.floor(Math.log(notes) / MATH2LOG) + 1;
      notesArray.unshift(`#${note}`);
      notes -= Math.pow(2, note - 1);
    }

    return stats.concat(notesArray).join(' ')
  }

  function unpackFeature(packed) {
    let unpacked = { status: statuses[packed.B], title: packed.C };
    unpacked.stats = Object.keys(packed.A).reduce((browserStats, key) => {
      let browser = packed.A[key];
      browserStats[browsers$3[key]] = Object.keys(browser).reduce(
        (stats, support) => {
          let packedVersions = browser[support].split(' ');
          let unpacked2 = unpackSupport(support);
          packedVersions.forEach(v => (stats[versions$3[v]] = unpacked2));
          return stats
        },
        {}
      );
      return browserStats
    }, {});
    return unpacked
  }

  var feature = unpackFeature;
  var _default = unpackFeature;
  feature.default = _default;

  var aac={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d iB jB","132":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"0 1 2 3 4 5 6 7 8 9 C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F","16":"A B"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB"},H:{"2":"JC"},I:{"1":"VB H G NC eB OC PC","2":"KC LC MC"},J:{"1":"A","2":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"132":"P"},N:{"1":"A","2":"B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"132":"cC"}},B:6,C:"AAC audio file format"};

  var abortcontroller={A:{A:{"2":"I D E F A B fB"},B:{"1":"M N O R S T U V W X P Y Z G","2":"C J K L"},C:{"1":"DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB iB jB"},D:{"1":"JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB"},E:{"1":"J K UB sB tB uB","2":"H a I D E F A B nB bB oB pB qB rB cB","130":"C TB"},F:{"1":"9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"1":"AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"VC cB WC XC YC ZC","2":"H RC SC TC UC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:1,C:"AbortController & AbortSignal"};

  var ac3Ec3={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O","2":"R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B","132":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D","132":"A"},K:{"2":"A B C Q TB dB","132":"UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"132":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"AC-3 (Dolby Digital) and EC-3 (Dolby Digital Plus) codecs"};

  var accelerometer={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB","194":"EB WB FB XB Q GB HB IB JB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:4,C:"Accelerometer"};

  var addeventlistener={A:{A:{"1":"F A B","130":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","257":"gB VB H a I iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"EventTarget.addEventListener()"};

  var alternateStylesheet={A:{A:{"1":"E F A B","2":"I D fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"F B C vB wB xB yB TB dB zB UB","16":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"16":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"16":"D A"},K:{"16":"A B C Q TB dB UB"},L:{"16":"G"},M:{"16":"P"},N:{"16":"A B"},O:{"16":"QC"},P:{"16":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"16":"bC"},S:{"1":"cC"}},B:1,C:"Alternate stylesheet"};

  var ambientLight={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J","132":"K L M N O","322":"R S T U V W X P Y Z G"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d iB jB","132":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB","194":"FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB","322":"EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB vB wB xB yB TB dB zB UB","322":"QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"132":"cC"}},B:4,C:"Ambient Light Sensor"};

  var apng={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB"},D:{"1":"WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB"},E:{"1":"E F A B C J K rB cB TB UB sB tB uB","2":"H a I D nB bB oB pB qB"},F:{"1":"2 3 4 5 6 7 8 9 B C AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","2":"0 1 F L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},G:{"1":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B 3B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"TC UC VC cB WC XC YC ZC","2":"H RC SC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:7,C:"Animated PNG (APNG)"};

  var arrayFindIndex={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g iB jB"},D:{"1":"1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"E F A B C J K qB rB cB TB UB sB tB uB","2":"H a I D nB bB oB pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n vB wB xB yB TB dB zB UB"},G:{"1":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B 3B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D","16":"A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"Array.prototype.findIndex"};

  var arrayFind={A:{A:{"2":"I D E F A B fB"},B:{"1":"L M N O R S T U V W X P Y Z G","16":"C J K"},C:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g iB jB"},D:{"1":"1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"E F A B C J K qB rB cB TB UB sB tB uB","2":"H a I D nB bB oB pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n vB wB xB yB TB dB zB UB"},G:{"1":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B 3B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D","16":"A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"Array.prototype.find"};

  var arrayFlat={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB iB jB"},D:{"1":"MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB"},E:{"1":"C J K UB sB tB uB","2":"H a I D E F A B nB bB oB pB qB rB cB TB"},F:{"1":"CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB vB wB xB yB TB dB zB UB"},G:{"1":"BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"cB WC XC YC ZC","2":"H RC SC TC UC VC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"flat & flatMap array methods"};

  var arrayIncludes={A:{A:{"2":"I D E F A B fB"},B:{"1":"K L M N O R S T U V W X P Y Z G","2":"C J"},C:{"1":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y iB jB"},D:{"1":"3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"H a I D E nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p vB wB xB yB TB dB zB UB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"Array.prototype.includes"};

  var arrowFunctions={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d iB jB"},D:{"1":"1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n vB wB xB yB TB dB zB UB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"Arrow functions"};

  var asmjs={A:{A:{"2":"I D E F A B fB"},B:{"1":"J K L M N O","132":"R S T U V W X P Y Z G","322":"C"},C:{"1":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d iB jB"},D:{"2":"H a I D E F A B C J K L M N O b c d e f g h i j","132":"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","132":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB OC PC","132":"G"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","132":"Q"},L:{"132":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H","132":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"132":"aC"},R:{"132":"bC"},S:{"1":"cC"}},B:6,C:"asm.js"};

  var asyncClipboard={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q iB jB","132":"GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB","66":"EB WB FB XB"},E:{"1":"K sB tB uB","2":"H a I D E F A B C J nB bB oB pB qB rB cB TB UB"},F:{"1":"5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC","260":"HC IC"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB OC PC","260":"G"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","260":"Q"},L:{"1":"G"},M:{"132":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC","260":"VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"Asynchronous Clipboard API"};

  var asyncFunctions={A:{A:{"2":"I D E F A B fB"},B:{"1":"L M N O R S T U V W X P Y Z G","2":"C J","194":"K"},C:{"1":"8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB"},E:{"1":"B C J K TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB","514":"cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x vB wB xB yB TB dB zB UB"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B","514":"8B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","2":"H RC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"Async functions"};

  var atobBtoa={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB yB TB dB zB UB","2":"F vB wB","16":"xB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","16":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Base64 encoding and decoding"};

  var audioApi={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J","33":"K L M N O b c d e f g h i j k l m n o p"},E:{"1":"tB uB","2":"H a nB bB oB","33":"I D E F A B C J K pB qB rB cB TB UB sB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB","33":"L M N O b c d"},G:{"1":"IC","2":"bB 0B eB 1B","33":"E 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"Web Audio API"};

  var audio={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB","132":"H a I D E F A B C J K L M N O b iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","2":"F","4":"vB wB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB"},H:{"2":"JC"},I:{"1":"VB H G MC NC eB OC PC","2":"KC LC"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Audio element"};

  var audiotracks={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O","322":"R S T U V W X P Y Z G"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o iB jB","194":"0 1 2 3 4 5 6 7 8 9 p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"2":"0 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","322":"1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a I nB bB oB"},F:{"2":"F B C L M N O b c d e f g h i j k l m n vB wB xB yB TB dB zB UB","322":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","322":"Q"},L:{"322":"G"},M:{"2":"P"},N:{"1":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"194":"cC"}},B:1,C:"Audio Tracks"};

  var autofocus={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","2":"F"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H G NC eB OC PC","2":"KC LC MC"},J:{"1":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"2":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:1,C:"Autofocus attribute"};

  var auxclick={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","129":"9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","16":"Q"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:5,C:"Auxclick"};

  var av1={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N","194":"O"},C:{"1":"KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB iB jB","66":"BB CB DB EB WB FB XB Q GB HB","260":"IB","516":"JB"},D:{"1":"NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB","66":"KB LB MB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1090":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"XC YC ZC","2":"H RC SC TC UC VC cB WC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"AV1 video format"};

  var avif={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB iB jB","257":"Z G","450":"ZB aB R S T hB U V W X P Y"},D:{"1":"W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"450":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"ZC","2":"H RC SC TC UC VC cB WC XC YC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"AVIF image format"};

  var backgroundAttachment={A:{A:{"1":"F A B","132":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","132":"gB VB H a I D E F A B C J K L M N O b c d e f g iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","132":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","132":"F vB wB"},G:{"2":"bB 0B eB","772":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC OC PC","132":"NC eB"},J:{"260":"D A"},K:{"1":"B C Q TB dB UB","132":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"2":"H","1028":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1028":"bC"},S:{"1":"cC"}},B:4,C:"CSS background-attachment"};

  var backgroundClipText={A:{A:{"2":"I D E F A B fB"},B:{"1":"L M N O","33":"C J K R S T U V W X P Y Z G"},C:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"33":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"16":"nB bB","33":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","33":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"16":"bB 0B eB 1B","33":"E 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"16":"VB KC LC MC","33":"H G NC eB OC PC"},J:{"33":"D A"},K:{"16":"A B C TB dB UB","33":"Q"},L:{"33":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"33":"QC"},P:{"33":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"33":"aC"},R:{"33":"bC"},S:{"1":"cC"}},B:7,C:"Background-clip: text"};

  var backgroundImgOpts={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB","36":"jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","516":"H a I D E F A B C J K"},E:{"1":"D E F A B C J K qB rB cB TB UB sB tB uB","772":"H a I nB bB oB pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","2":"F vB","36":"wB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","4":"bB 0B eB 2B","516":"1B"},H:{"132":"JC"},I:{"1":"G OC PC","36":"KC","516":"VB H NC eB","548":"LC MC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS3 Background-image options"};

  var backgroundPositionXY={A:{A:{"1":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:7,C:"background-position-x & background-position-y"};

  var backgroundRepeatRoundSpace={A:{A:{"1":"A B","2":"I D E fB","132":"F"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n"},E:{"1":"D E F A B C J K qB rB cB TB UB sB tB uB","2":"H a I nB bB oB pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","2":"F L M N O vB wB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B"},H:{"1":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"A","2":"D"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:4,C:"CSS background-repeat round and space"};

  var backgroundSync={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y iB jB","16":"Z G"},D:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Background Sync API"};

  var batteryStatus={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 z","2":"8 9 gB VB H a I D E F AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","132":"M N O b c d e f g h i j k l m n o p q r s t u v w x y","164":"A B C J K L"},D:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s","66":"t"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"Battery Status API"};

  var beacon={A:{A:{"2":"I D E F A B fB"},B:{"1":"K L M N O R S T U V W X P Y Z G","2":"C J"},C:{"1":"0 1 2 3 4 5 6 7 8 9 n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u"},E:{"1":"C J K TB UB sB tB uB","2":"H a I D E F A B nB bB oB pB qB rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h vB wB xB yB TB dB zB UB"},G:{"1":"AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"Beacon API"};

  var beforeafterprint={A:{A:{"1":"I D E F A B","16":"fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a iB jB"},D:{"1":"GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"1":"DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"16":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"16":"A B"},O:{"16":"QC"},P:{"2":"RC SC TC UC VC cB WC XC YC ZC","16":"H"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:1,C:"Printing Events"};

  var bigint={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB iB jB","194":"IB JB KB"},D:{"1":"KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB"},E:{"1":"K tB uB","2":"H a I D E F A B C J nB bB oB pB qB rB cB TB UB sB"},F:{"1":"AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"1":"HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"VC cB WC XC YC ZC","2":"H RC SC TC UC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"BigInt"};

  var blobbuilder={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a iB jB","36":"I D E F A B C"},D:{"1":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D","36":"E F A B C J K L M N O b"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B C vB wB xB yB TB dB zB"},G:{"1":"E 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B"},H:{"2":"JC"},I:{"1":"G","2":"KC LC MC","36":"VB H NC eB OC PC"},J:{"1":"A","2":"D"},K:{"1":"Q UB","2":"A B C TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"Blob constructing"};

  var bloburls={A:{A:{"2":"I D E F fB","129":"A B"},B:{"1":"L M N O R S T U V W X P Y Z G","129":"C J K"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D","33":"E F A B C J K L M N O b c d e"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB","33":"I"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B","33":"2B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB KC LC MC","33":"H NC eB"},J:{"1":"A","2":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","2":"A"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"Blob URLs"};

  var borderImage={A:{A:{"1":"B","2":"I D E F A fB"},B:{"1":"K L M N O R S T U V W X P Y Z G","129":"C J"},C:{"1":"6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB","260":"0 1 2 3 4 5 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","804":"H a I D E F A B C J K iB jB"},D:{"1":"CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","260":"7 8 9 AB BB","388":"0 1 2 3 4 5 6 m n o p q r s t u v w x y z","1412":"L M N O b c d e f g h i j k l","1956":"H a I D E F A B C J K"},E:{"129":"A B C J K rB cB TB UB sB tB uB","1412":"I D E F pB qB","1956":"H a nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F vB wB","260":"u v w x y","388":"L M N O b c d e f g h i j k l m n o p q r s t","1796":"xB yB","1828":"B C TB dB zB UB"},G:{"129":"6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","1412":"E 2B 3B 4B 5B","1956":"bB 0B eB 1B"},H:{"1828":"JC"},I:{"1":"G","388":"OC PC","1956":"VB H KC LC MC NC eB"},J:{"1412":"A","1924":"D"},K:{"1":"Q","2":"A","1828":"B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","2":"A"},O:{"388":"QC"},P:{"1":"TC UC VC cB WC XC YC ZC","260":"RC SC","388":"H"},Q:{"260":"aC"},R:{"260":"bC"},S:{"260":"cC"}},B:4,C:"CSS3 Border images"};

  var borderRadius={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","257":"0 1 2 3 4 5 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","289":"VB iB jB","292":"gB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","33":"H"},E:{"1":"a D E F A B C J K qB rB cB TB UB sB tB uB","33":"H nB bB","129":"I oB pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","2":"F vB wB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","33":"bB"},H:{"2":"JC"},I:{"1":"VB H G LC MC NC eB OC PC","33":"KC"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"257":"cC"}},B:4,C:"CSS3 Border-radius (rounded corners)"};

  var broadcastchannel={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t iB jB"},D:{"1":"AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"TC UC VC cB WC XC YC ZC","2":"H RC SC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:1,C:"BroadcastChannel"};

  var brotli={A:{A:{"2":"I D E F A B fB"},B:{"1":"L M N O R S T U V W X P Y Z G","2":"C J K"},C:{"1":"0 1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","194":"5","257":"6"},E:{"1":"J K sB tB uB","2":"H a I D E F A nB bB oB pB qB rB cB","513":"B C TB UB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r vB wB xB yB TB dB zB UB","194":"s t"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:6,C:"Brotli Accept-Encoding/Content-Encoding"};

  var calc={A:{A:{"2":"I D E fB","260":"F","516":"A B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB","33":"H a I D E F A B C J K L"},D:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O","33":"b c d e f g h"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB","33":"I"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B","33":"2B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB","132":"OC PC"},J:{"1":"A","2":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"calc() as CSS unit value"};

  var canvasBlending={A:{A:{"2":"I D E F A B fB"},B:{"1":"J K L M N O R S T U V W X P Y Z G","2":"C"},C:{"1":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a I nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M vB wB xB yB TB dB zB UB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"Canvas blend modes"};

  var canvasText={A:{A:{"1":"F A B","2":"fB","8":"I D E"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","8":"gB VB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","8":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","8":"F vB wB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","8":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Text API for Canvas"};

  var canvas={A:{A:{"1":"F A B","2":"fB","8":"I D E"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G jB","132":"gB VB iB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","132":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"260":"JC"},I:{"1":"VB H G NC eB OC PC","132":"KC LC MC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Canvas (basic support)"};

  var chUnit={A:{A:{"2":"I D E fB","132":"F A B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i"},E:{"1":"D E F A B C J K qB rB cB TB UB sB tB uB","2":"H a I nB bB oB pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"A","2":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"ch (character) unit"};

  var chacha20Poly1305={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o","129":"0 1 2 3 4 p q r s t u v w x y z"},E:{"1":"C J K TB UB sB tB uB","2":"H a I D E F A B nB bB oB pB qB rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r vB wB xB yB TB dB zB UB"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC","16":"PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"ChaCha20-Poly1305 cipher suites for TLS"};

  var channelMessaging={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h iB jB","194":"i j k l m n o p q r s t u v w"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB yB TB dB zB UB","2":"F vB wB","16":"xB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Channel messaging"};

  var childnodeRemove={A:{A:{"2":"I D E F A B fB"},B:{"1":"J K L M N O R S T U V W X P Y Z G","16":"C"},C:{"1":"0 1 2 3 4 5 6 7 8 9 f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB","16":"I"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"A","2":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"ChildNode.remove()"};

  var classlist={A:{A:{"8":"I D E F fB","1924":"A B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","8":"gB VB iB","516":"g h","772":"H a I D E F A B C J K L M N O b c d e f jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","8":"H a I D","516":"g h i j","772":"f","900":"E F A B C J K L M N O b c d e"},E:{"1":"D E F A B C J K qB rB cB TB UB sB tB uB","8":"H a nB bB","900":"I oB pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","8":"F B vB wB xB yB TB","900":"C dB zB UB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","8":"bB 0B eB","900":"1B 2B"},H:{"900":"JC"},I:{"1":"G OC PC","8":"KC LC MC","900":"VB H NC eB"},J:{"1":"A","900":"D"},K:{"1":"Q","8":"A B","900":"C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"900":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"classList (DOMTokenList)"};

  var clientHintsDprWidthViewport={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"2":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:6,C:"Client Hints: DPR, Width, Viewport-Width"};

  var clipboard={A:{A:{"2436":"I D E F A B fB"},B:{"260":"N O","2436":"C J K L M","8196":"R S T U V W X P Y Z G"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d iB jB","772":"e f g h i j k l m n o p q r s t u v w","4100":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"2":"H a I D E F A B C","2564":"J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y","8196":"EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","10244":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB"},E:{"1":"C J K UB sB tB uB","16":"nB bB","2308":"A B cB TB","2820":"H a I D E F oB pB qB rB"},F:{"2":"F B vB wB xB yB TB dB zB","16":"C","516":"UB","2564":"L M N O b c d e f g h i j k l","8196":"1 2 3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","10244":"0 m n o p q r s t u v w x y z"},G:{"1":"BC CC DC EC FC GC HC IC","2":"bB 0B eB","2820":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB","260":"G","2308":"OC PC"},J:{"2":"D","2308":"A"},K:{"2":"A B C TB dB","16":"UB","1028":"Q"},L:{"8196":"G"},M:{"1028":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2052":"RC SC","2308":"H","8196":"TC UC VC cB WC XC YC ZC"},Q:{"10244":"aC"},R:{"2052":"bC"},S:{"4100":"cC"}},B:5,C:"Synchronous Clipboard API"};

  var comparedocumentposition={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","16":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K","132":"L M N O b c d e f g h i j k l"},E:{"1":"A B C J K cB TB UB sB tB uB","16":"H a I nB bB","132":"D E F pB qB rB","260":"oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB","16":"F B vB wB xB yB TB dB","132":"L M"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB","132":"E 0B eB 1B 2B 3B 4B 5B 6B"},H:{"1":"JC"},I:{"1":"G OC PC","16":"KC LC","132":"VB H MC NC eB"},J:{"132":"D A"},K:{"1":"C Q UB","16":"A B TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Node.compareDocumentPosition()"};

  var consoleBasic={A:{A:{"1":"A B","2":"I D fB","132":"E F"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB TB dB zB UB","2":"F vB wB xB yB"},G:{"1":"bB 0B eB 1B","513":"E 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"4097":"JC"},I:{"1025":"VB H G KC LC MC NC eB OC PC"},J:{"258":"D A"},K:{"2":"A","258":"B C Q TB dB UB"},L:{"1025":"G"},M:{"2049":"P"},N:{"258":"A B"},O:{"258":"QC"},P:{"1025":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1025":"bC"},S:{"1":"cC"}},B:1,C:"Basic console logging functions"};

  var consoleTime={A:{A:{"1":"B","2":"I D E F A fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB TB dB zB UB","2":"F vB wB xB yB","16":"B"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"Q","16":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","2":"A"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"console.time and console.timeEnd"};

  var _const={A:{A:{"2":"I D E F A fB","2052":"B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","132":"gB VB H a I D E F A B C iB jB","260":"J K L M N O b c d e f g h i j k l m n o p q r"},D:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","260":"H a I D E F A B C J K L M N O b c","772":"d e f g h i j k l m n o p q r s t u v w","1028":"0 1 2 3 4 x y z"},E:{"1":"A B C J K cB TB UB sB tB uB","260":"H a nB bB","772":"I D E F oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F vB","132":"B wB xB yB TB dB","644":"C zB UB","772":"L M N O b c d e f g h i j","1028":"k l m n o p q r"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","260":"bB 0B eB","772":"E 1B 2B 3B 4B 5B 6B"},H:{"644":"JC"},I:{"1":"G","16":"KC LC","260":"MC","772":"VB H NC eB OC PC"},J:{"772":"D A"},K:{"1":"Q","132":"A B TB dB","644":"C UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","2":"A"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","1028":"H"},Q:{"1":"aC"},R:{"1028":"bC"},S:{"1":"cC"}},B:6,C:"const"};

  var constraintValidation={A:{A:{"2":"I D E F fB","900":"A B"},B:{"1":"N O R S T U V W X P Y Z G","388":"K L M","900":"C J"},C:{"1":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB","260":"5 6","388":"0 1 2 3 4 l m n o p q r s t u v w x y z","900":"H a I D E F A B C J K L M N O b c d e f g h i j k"},D:{"1":"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K","388":"h i j k l m n o p q r s t u v","900":"L M N O b c d e f g"},E:{"1":"A B C J K cB TB UB sB tB uB","16":"H a nB bB","388":"E F qB rB","900":"I D oB pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","16":"F B vB wB xB yB TB dB","388":"L M N O b c d e f g h i","900":"C zB UB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB","388":"E 3B 4B 5B 6B","900":"1B 2B"},H:{"2":"JC"},I:{"1":"G","16":"VB KC LC MC","388":"OC PC","900":"H NC eB"},J:{"16":"D","388":"A"},K:{"1":"Q","16":"A B TB dB","900":"C UB"},L:{"1":"G"},M:{"1":"P"},N:{"900":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"388":"cC"}},B:1,C:"Constraint Validation API"};

  var contenteditable={A:{A:{"1":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB","4":"VB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB"},H:{"2":"JC"},I:{"1":"VB H G NC eB OC PC","2":"KC LC MC"},J:{"1":"D A"},K:{"1":"Q UB","2":"A B C TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"contenteditable attribute (basic support)"};

  var contentsecuritypolicy={A:{A:{"2":"I D E F fB","132":"A B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB","129":"H a I D E F A B C J K L M N O b c d e"},D:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J","257":"K L M N O b c d e f g"},E:{"1":"D E F A B C J K qB rB cB TB UB sB tB uB","2":"H a nB bB","257":"I pB","260":"oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB","257":"2B","260":"1B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"2":"D","257":"A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"132":"A B"},O:{"257":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"Content Security Policy 1.0"};

  var contentsecuritypolicy2={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K","32772":"L M N O"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m iB jB","132":"n o p q","260":"r","516":"0 s t u v w x y z","8196":"1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r","1028":"s t u","2052":"v"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e vB wB xB yB TB dB zB UB","1028":"f g h","2052":"i"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"4100":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"8196":"cC"}},B:2,C:"Content Security Policy Level 2"};

  var cookieStoreApi={A:{A:{"2":"I D E F A B fB"},B:{"1":"P Y Z G","2":"C J K L M N O","194":"R S T U V W X"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB","194":"HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"RB SB","2":"0 1 2 3 4 5 6 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB","194":"7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"ZC","2":"H RC SC TC UC VC cB WC XC YC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Cookie Store API"};

  var cors={A:{A:{"1":"B","2":"I D fB","132":"A","260":"E F"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB VB","1025":"XB Q GB HB IB JB KB LB MB NB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","132":"H a I D E F A B C"},E:{"2":"nB bB","513":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","644":"H a oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B vB wB xB yB TB dB zB"},G:{"513":"E 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","644":"bB 0B eB 1B"},H:{"2":"JC"},I:{"1":"G OC PC","132":"VB H KC LC MC NC eB"},J:{"1":"A","132":"D"},K:{"1":"C Q UB","2":"A B TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","132":"A"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Cross-Origin Resource Sharing"};

  var createimagebitmap={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x iB jB","3076":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","132":"6 7","260":"8 9","516":"AB BB CB DB EB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"2 3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s vB wB xB yB TB dB zB UB","132":"t u","260":"v w","516":"0 1 x y z"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"3076":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","16":"H RC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"3076":"cC"}},B:1,C:"createImageBitmap"};

  var credentialManagement={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","66":"4 5 6","129":"7 8 9 AB BB CB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"1 2 3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"1":"HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"TC UC VC cB WC XC YC ZC","2":"H RC SC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"Credential Management API"};

  var cryptography={A:{A:{"2":"fB","8":"I D E F A","164":"B"},B:{"1":"R S T U V W X P Y Z G","513":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","8":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n iB jB","66":"o p"},D:{"1":"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","8":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s"},E:{"1":"B C J K TB UB sB tB uB","8":"H a I D nB bB oB pB","289":"E F A qB rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","8":"F B C L M N O b c d e f vB wB xB yB TB dB zB UB"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","8":"bB 0B eB 1B 2B 3B","289":"E 4B 5B 6B 7B 8B"},H:{"2":"JC"},I:{"1":"G","8":"VB H KC LC MC NC eB OC PC"},J:{"8":"D A"},K:{"1":"Q","8":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"8":"A","164":"B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"Web Cryptography"};

  var cssAll={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s"},E:{"1":"A B C J K rB cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f vB wB xB yB TB dB zB UB"},G:{"1":"6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B"},H:{"2":"JC"},I:{"1":"G PC","2":"VB H KC LC MC NC eB OC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS all property"};

  var cssAnimation={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H iB jB","33":"a I D E F A B C J K L"},D:{"1":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","33":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"nB bB","33":"I D E oB pB qB","292":"H a"},F:{"1":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B vB wB xB yB TB dB zB","33":"C L M N O b c d e f g h i j k l"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","33":"E 2B 3B 4B","164":"bB 0B eB 1B"},H:{"2":"JC"},I:{"1":"G","33":"H NC eB OC PC","164":"VB KC LC MC"},J:{"33":"D A"},K:{"1":"Q UB","2":"A B C TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"33":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"CSS Animation"};

  var cssAnyLink={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","16":"gB","33":"0 1 2 3 4 5 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K","33":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","16":"H a I nB bB oB","33":"D E pB qB"},F:{"1":"8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB","33":"0 1 2 3 4 5 6 7 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB 1B","33":"E 2B 3B 4B"},H:{"2":"JC"},I:{"1":"G","16":"VB H KC LC MC NC eB","33":"OC PC"},J:{"16":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"33":"QC"},P:{"1":"VC cB WC XC YC ZC","16":"H","33":"RC SC TC UC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"33":"cC"}},B:5,C:"CSS :any-link selector"};

  var cssAppearance={A:{A:{"2":"I D E F A B fB"},B:{"1":"V W X P Y Z G","33":"U","164":"R S T","388":"C J K L M N O"},C:{"1":"S T hB U V W X P Y Z G","164":"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R","676":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q iB jB"},D:{"1":"V W X P Y Z G kB lB mB","33":"U","164":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T"},E:{"164":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"QB RB SB","2":"F B C vB wB xB yB TB dB zB UB","33":"NB OB PB","164":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB"},G:{"164":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","164":"VB H KC LC MC NC eB OC PC"},J:{"164":"D A"},K:{"2":"A B C TB dB UB","164":"Q"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A","388":"B"},O:{"164":"QC"},P:{"164":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"164":"aC"},R:{"164":"bC"},S:{"164":"cC"}},B:5,C:"CSS Appearance"};

  var cssApplyRule={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","194":"R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","194":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C L M N O b c d e f g h i j k l m n o p q r s t vB wB xB yB TB dB zB UB","194":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","194":"Q"},L:{"194":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H","194":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"194":"bC"},S:{"2":"cC"}},B:7,C:"CSS @apply rule"};

  var cssAtCounterStyle={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o iB jB","132":"0 1 2 3 4 5 6 7 8 9 p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G","132":"kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"132":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"132":"cC"}},B:4,C:"CSS Counter Styles"};

  var cssBackdropFilter={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M","257":"N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB iB jB","578":"NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","194":"3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},E:{"2":"H a I D E nB bB oB pB qB","33":"F A B C J K rB cB TB UB sB tB uB"},F:{"1":"HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p vB wB xB yB TB dB zB UB","194":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB FB Q GB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B","33":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"578":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"XC YC ZC","2":"H","194":"RC SC TC UC VC cB WC"},Q:{"194":"aC"},R:{"194":"bC"},S:{"2":"cC"}},B:7,C:"CSS Backdrop Filter"};

  var cssBackgroundOffsets={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g"},E:{"1":"D E F A B C J K qB rB cB TB UB sB tB uB","2":"H a I nB bB oB pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","2":"F vB wB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B"},H:{"1":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"A","2":"D"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS background-position edge offsets"};

  var cssBackgroundblendmode={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l iB jB"},D:{"1":"0 1 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q","260":"2"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D nB bB oB pB","132":"E F A qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d vB wB xB yB TB dB zB UB","260":"p"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B 3B","132":"E 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS background-blend-mode"};

  var cssBoxdecorationbreak={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","164":"R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n iB jB"},D:{"2":"H a I D E F A B C J K L M N O b c d","164":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I nB bB oB","164":"D E F A B C J K pB qB rB cB TB UB sB tB uB"},F:{"2":"F vB wB xB yB","129":"B C TB dB zB UB","164":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"bB 0B eB 1B 2B","164":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"132":"JC"},I:{"2":"VB H KC LC MC NC eB","164":"G OC PC"},J:{"2":"D","164":"A"},K:{"2":"A","129":"B C TB dB UB","164":"Q"},L:{"164":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"164":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"164":"aC"},R:{"164":"bC"},S:{"1":"cC"}},B:5,C:"CSS box-decoration-break"};

  var cssBoxshadow={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB","33":"iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","33":"H a I D E F"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","33":"a","164":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","2":"F vB wB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","33":"0B eB","164":"bB"},H:{"2":"JC"},I:{"1":"H G NC eB OC PC","164":"VB KC LC MC"},J:{"1":"A","33":"D"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS3 Box-shadow"};

  var cssCanvas={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","33":"0 1 2 3 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"2":"nB bB","33":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","33":"L M N O b c d e f g h i j k l m n o p q"},G:{"33":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"G","33":"VB H KC LC MC NC eB OC PC"},J:{"33":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"RC SC TC UC VC cB WC XC YC ZC","33":"H"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"CSS Canvas Drawings"};

  var cssCaretColor={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB"},E:{"1":"C J K TB UB sB tB uB","2":"H a I D E F A B nB bB oB pB qB rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"1":"AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"TC UC VC cB WC XC YC ZC","2":"H RC SC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:4,C:"CSS caret-color"};

  var cssCaseInsensitive={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"H a I D E nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r vB wB xB yB TB dB zB UB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:5,C:"Case-insensitive CSS attribute selectors"};

  var cssClipPath={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N","260":"R S T U V W X P Y Z G","3138":"O"},C:{"1":"AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB","132":"0 1 2 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","644":"3 4 5 6 7 8 9"},D:{"2":"H a I D E F A B C J K L M N O b c d e f","260":"BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","292":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB"},E:{"2":"H a I nB bB oB pB","292":"D E F A B C J K qB rB cB TB UB sB tB uB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","260":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","292":"L M N O b c d e f g h i j k l m n o p q r s t u v w x"},G:{"2":"bB 0B eB 1B 2B","292":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB","260":"G","292":"OC PC"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","260":"Q"},L:{"260":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"292":"QC"},P:{"292":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"292":"aC"},R:{"260":"bC"},S:{"644":"cC"}},B:4,C:"CSS clip-path property (for HTML)"};

  var cssColorAdjust={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","33":"R S T U V W X P Y Z G"},C:{"1":"4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"16":"H a I D E F A B C J K L M N O","33":"0 1 2 3 4 5 6 7 8 9 b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a nB bB oB","33":"I D E F A B C J K pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","33":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"16":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"16":"VB H KC LC MC NC eB OC PC","33":"G"},J:{"16":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"16":"G"},M:{"1":"P"},N:{"16":"A B"},O:{"16":"QC"},P:{"16":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"33":"aC"},R:{"16":"bC"},S:{"1":"cC"}},B:5,C:"CSS color-adjust"};

  var cssColorFunction={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"CSS `color()` function"};

  var cssConicGradients={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB iB jB","578":"SB YB ZB aB R S T hB"},D:{"1":"MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB","194":"WB FB XB Q GB HB IB JB KB LB"},E:{"1":"J K UB sB tB uB","2":"H a I D E F A B C nB bB oB pB qB rB cB TB"},F:{"1":"HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB","194":"2 3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB"},G:{"1":"CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"cB WC XC YC ZC","2":"H RC SC TC UC VC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"CSS Conical Gradients"};

  var cssContainerQueries={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB","194":"lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"CSS Container Queries"};

  var cssContainment={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w iB jB","194":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB"},D:{"1":"8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","66":"7"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t vB wB xB yB TB dB zB UB","66":"u v"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","2":"H RC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"194":"cC"}},B:2,C:"CSS Containment"};

  var cssContentVisibility={A:{A:{"2":"I D E F A B fB"},B:{"1":"W X P Y Z G","2":"C J K L M N O R S T U V"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB","16":"uB"},F:{"1":"OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"ZC","2":"H RC SC TC UC VC cB WC XC YC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"CSS content-visibility"};

  var cssCounters={A:{A:{"1":"E F A B","2":"I D fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"CSS Counters"};

  var cssCrispEdges={A:{A:{"2":"I fB","2340":"D E F A B"},B:{"2":"C J K L M N O","1025":"R S T U V W X P Y Z G"},C:{"2":"gB VB iB","513":"IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","545":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB jB"},D:{"2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w","1025":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a nB bB oB","164":"I","4644":"D E F pB qB rB"},F:{"2":"F B L M N O b c d e f g h i j vB wB xB yB TB dB","545":"C zB UB","1025":"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB","4260":"1B 2B","4644":"E 3B 4B 5B 6B"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB OC PC","1025":"G"},J:{"2":"D","4260":"A"},K:{"2":"A B TB dB","545":"C UB","1025":"Q"},L:{"1025":"G"},M:{"545":"P"},N:{"2340":"A B"},O:{"1":"QC"},P:{"1025":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1025":"aC"},R:{"1025":"bC"},S:{"4097":"cC"}},B:7,C:"Crisp edges/pixelated images"};

  var cssCrossFade={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","33":"R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"H a I D E F A B C J K L M","33":"0 1 2 3 4 5 6 7 8 9 N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a nB bB","33":"I D E F oB pB qB rB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","33":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB","33":"E 1B 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB","33":"G OC PC"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","33":"Q"},L:{"33":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"33":"QC"},P:{"33":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"33":"aC"},R:{"33":"bC"},S:{"2":"cC"}},B:4,C:"CSS Cross-Fade Function"};

  var cssDefaultPseudo={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","16":"gB VB iB jB"},D:{"1":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K","132":"0 1 2 3 4 5 6 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"B C J K cB TB UB sB tB uB","16":"H a nB bB","132":"I D E F A oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","16":"F B vB wB xB yB TB dB","132":"L M N O b c d e f g h i j k l m n o p q r s t","260":"C zB UB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB 1B 2B","132":"E 3B 4B 5B 6B 7B"},H:{"260":"JC"},I:{"1":"G","16":"VB KC LC MC","132":"H NC eB OC PC"},J:{"16":"D","132":"A"},K:{"1":"Q","16":"A B C TB dB","260":"UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"132":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","132":"H"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:7,C:":default CSS pseudo-class"};

  var cssDescendantGtgt={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O S T U V W X P Y Z G","16":"R"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G","16":"kB lB mB"},E:{"1":"B","2":"H a I D E F A C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Explicit descendant combinator >>"};

  var cssDeviceadaptation={A:{A:{"2":"I D E F fB","164":"A B"},B:{"66":"R S T U V W X P Y Z G","164":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"H a I D E F A B C J K L M N O b c d e f g h i j k","66":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v vB wB xB yB TB dB zB UB","66":"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"292":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A Q","292":"B C TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"164":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"66":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"CSS Device Adaptation"};

  var cssDirPseudo={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M iB jB","33":"0 1 2 3 4 N O b c d e f g h i j k l m n o p q r s t u v w x y z"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G","194":"kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"33":"cC"}},B:5,C:":dir() CSS pseudo-class"};

  var cssDisplayContents={A:{A:{"2":"I D E F A B fB"},B:{"1":"Z G","2":"C J K L M N O","260":"R S T U V W X P Y"},C:{"1":"Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s iB jB","260":"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB WB FB XB"},D:{"1":"Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB","194":"EB WB FB XB Q GB HB","260":"IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y"},E:{"2":"H a I D E F A B nB bB oB pB qB rB cB","260":"K sB tB uB","772":"C J TB UB"},F:{"2":"0 1 2 3 4 5 6 7 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB","260":"8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B","260":"GC HC IC","772":"AC BC CC DC EC FC"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB OC PC","260":"G"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","260":"Q"},L:{"260":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC","260":"VC cB WC XC YC ZC"},Q:{"260":"aC"},R:{"2":"bC"},S:{"260":"cC"}},B:5,C:"CSS display: contents"};

  var cssElementFunction={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"33":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","164":"gB VB iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"33":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"33":"cC"}},B:5,C:"CSS element() function"};

  var cssEnvFunction={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB iB jB"},D:{"1":"MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB"},E:{"1":"C J K TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB cB","132":"B"},F:{"1":"CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB vB wB xB yB TB dB zB UB"},G:{"1":"AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B","132":"9B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"cB WC XC YC ZC","2":"H RC SC TC UC VC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"CSS Environment Variables env()"};

  var cssExclusions={A:{A:{"2":"I D E F fB","33":"A B"},B:{"2":"R S T U V W X P Y Z G","33":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"33":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"CSS Exclusions Level 1"};

  var cssFeaturequeries={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"H a I D E nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B C vB wB xB yB TB dB zB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B"},H:{"1":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS Feature Queries"};

  var cssFilterFunction={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"A B C J K rB cB TB UB sB tB uB","2":"H a I D E nB bB oB pB qB","33":"F"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B","33":"5B 6B"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"CSS filter() function"};

  var cssFilters={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","1028":"J K L M N O","1346":"C"},C:{"1":"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB","196":"q","516":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p jB"},D:{"1":"9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N","33":"0 1 2 3 4 5 6 7 8 O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"A B C J K rB cB TB UB sB tB uB","2":"H a nB bB oB","33":"I D E F pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB","33":"L M N O b c d e f g h i j k l m n o p q r s t u v"},G:{"1":"6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B","33":"E 2B 3B 4B 5B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB","33":"OC PC"},J:{"2":"D","33":"A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"TC UC VC cB WC XC YC ZC","33":"H RC SC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"CSS Filter Effects"};

  var cssFirstLetter={A:{A:{"1":"F A B","16":"fB","516":"E","1540":"I D"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","132":"VB","260":"gB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"a I D E","132":"H"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","16":"a nB","132":"H bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB","16":"F vB","260":"B wB xB yB TB dB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB"},H:{"1":"JC"},I:{"1":"VB H G NC eB OC PC","16":"KC LC","132":"MC"},J:{"1":"D A"},K:{"1":"C Q UB","260":"A B TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"::first-letter CSS pseudo-element selector"};

  var cssFirstLine={A:{A:{"1":"F A B","132":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"CSS first-line pseudo-element"};

  var cssFixed={A:{A:{"1":"D E F A B","2":"fB","8":"I"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB cB TB UB sB tB uB","1025":"rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB","132":"1B 2B 3B"},H:{"2":"JC"},I:{"1":"VB G OC PC","260":"KC LC MC","513":"H NC eB"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"CSS position:fixed"};

  var cssFocusVisible={A:{A:{"2":"I D E F A B fB"},B:{"1":"X P Y Z G","2":"C J K L M N O","328":"R S T U V W"},C:{"1":"W X P Y Z G","2":"gB VB iB jB","161":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V"},D:{"1":"X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB","328":"KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB","16":"tB uB"},F:{"1":"PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB vB wB xB yB TB dB zB UB","328":"JB KB LB MB NB OB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"ZC","2":"H RC SC TC UC VC cB WC XC YC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"161":"cC"}},B:7,C:":focus-visible CSS pseudo-class"};

  var cssFocusWithin={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB","194":"WB"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB","194":"2"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"UC VC cB WC XC YC ZC","2":"H RC SC TC"},Q:{"1":"aC"},R:{"16":"bC"},S:{"2":"cC"}},B:7,C:":focus-within CSS pseudo-class"};

  var cssFontRenderingControls={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","194":"2 3 4 5 6 7 8 9 AB BB CB DB"},D:{"1":"FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","66":"5 6 7 8 9 AB BB CB DB EB WB"},E:{"1":"C J K TB UB sB tB uB","2":"H a I D E F A B nB bB oB pB qB rB cB"},F:{"1":"3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r vB wB xB yB TB dB zB UB","66":"0 1 2 s t u v w x y z"},G:{"1":"AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"UC VC cB WC XC YC ZC","2":"H","66":"RC SC TC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"194":"cC"}},B:5,C:"CSS font-rendering controls"};

  var cssFontStretch={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E iB jB"},D:{"1":"4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"B C J K TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q vB wB xB yB TB dB zB UB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS font-stretch"};

  var cssGencontent={A:{A:{"1":"F A B","2":"I D fB","132":"E"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"CSS Generated content for pseudo-elements"};

  var cssGradients={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB","260":"M N O b c d e f g h i j k l m n o p q r","292":"H a I D E F A B C J K L jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","33":"A B C J K L M N O b c d e f g h","548":"H a I D E F"},E:{"2":"nB bB","260":"D E F A B C J K pB qB rB cB TB UB sB tB uB","292":"I oB","804":"H a"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B vB wB xB yB","33":"C zB","164":"TB dB"},G:{"260":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","292":"1B 2B","804":"bB 0B eB"},H:{"2":"JC"},I:{"1":"G OC PC","33":"H NC eB","548":"VB KC LC MC"},J:{"1":"A","548":"D"},K:{"1":"Q UB","2":"A B","33":"C","164":"TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS Gradients"};

  var cssGrid={A:{A:{"2":"I D E fB","8":"F","292":"A B"},B:{"1":"M N O R S T U V W X P Y Z G","292":"C J K L"},C:{"1":"AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O iB jB","8":"b c d e f g h i j k l m n o p q r s t u v","584":"0 1 2 3 4 5 6 7 w x y z","1025":"8 9"},D:{"1":"EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g","8":"h i j k","200":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB","1025":"DB"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a nB bB oB","8":"I D E F A pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j vB wB xB yB TB dB zB UB","200":"k l m n o p q r s t u v w x y z"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B","8":"E 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC","8":"eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"292":"A B"},O:{"1":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","2":"RC","8":"H"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:4,C:"CSS Grid Layout (level 1)"};

  var cssHangingPunctuation={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"CSS hanging-punctuation"};

  var cssHas={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:":has() CSS relational pseudo-class"};

  var cssHyphenate={A:{A:{"16":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","16":"C J K L M N O"},C:{"16":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB"},E:{"16":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"16":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"16":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"16":"JC"},I:{"16":"VB H G KC LC MC NC eB OC PC"},J:{"16":"D A"},K:{"16":"A B C Q TB dB UB"},L:{"16":"G"},M:{"16":"P"},N:{"16":"A B"},O:{"16":"QC"},P:{"16":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"16":"aC"},R:{"16":"bC"},S:{"16":"cC"}},B:5,C:"CSS4 Hyphenation"};

  var cssHyphens={A:{A:{"2":"I D E F fB","33":"A B"},B:{"33":"C J K L M N O","132":"R S T U V W X P","260":"Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a iB jB","33":"I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y"},D:{"1":"Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB","132":"BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P"},E:{"2":"H a nB bB","33":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x vB wB xB yB TB dB zB UB","132":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"bB 0B","33":"E eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"4":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","2":"H","132":"RC"},Q:{"2":"aC"},R:{"132":"bC"},S:{"1":"cC"}},B:5,C:"CSS Hyphenation"};

  var cssImageOrientation={A:{A:{"2":"I D E F A B fB"},B:{"1":"Z G","2":"C J K L M N O R S","257":"T U V W X P Y"},C:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h iB jB"},D:{"1":"Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S","257":"T U V W X P Y"},E:{"1":"K sB tB uB","2":"H a I D E F A B C J nB bB oB pB qB rB cB TB UB"},F:{"1":"LB MB NB OB PB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB vB wB xB yB TB dB zB UB","257":"QB RB SB"},G:{"1":"HC IC","132":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"YC ZC","2":"H RC SC TC UC VC cB WC XC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:4,C:"CSS3 image-orientation"};

  var cssImageSet={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","164":"R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W iB jB","66":"X P","260":"Z G","772":"Y"},D:{"2":"H a I D E F A B C J K L M N O b c","164":"0 1 2 3 4 5 6 7 8 9 d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a nB bB oB","132":"A B C J cB TB UB sB","164":"I D E F pB qB rB","516":"K tB uB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","164":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"bB 0B eB 1B","132":"7B 8B 9B AC BC CC DC EC FC GC","164":"E 2B 3B 4B 5B 6B","516":"HC IC"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB","164":"G OC PC"},J:{"2":"D","164":"A"},K:{"2":"A B C TB dB UB","164":"Q"},L:{"164":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"164":"QC"},P:{"164":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"164":"aC"},R:{"164":"bC"},S:{"2":"cC"}},B:5,C:"CSS image-set"};

  var cssInOutOfRange={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C","260":"J K L M N O"},C:{"1":"6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k iB jB","516":"0 1 2 3 4 5 l m n o p q r s t u v w x y z"},D:{"1":"9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H","16":"a I D E F A B C J K","260":"8","772":"0 1 2 3 4 5 6 7 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H nB bB","16":"a","772":"I D E F A oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","16":"F vB","260":"B C v wB xB yB TB dB zB UB","772":"L M N O b c d e f g h i j k l m n o p q r s t u"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB","772":"E 1B 2B 3B 4B 5B 6B 7B"},H:{"132":"JC"},I:{"1":"G","2":"VB KC LC MC","260":"H NC eB OC PC"},J:{"2":"D","260":"A"},K:{"1":"Q","260":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","260":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"516":"cC"}},B:5,C:":in-range and :out-of-range CSS pseudo-classes"};

  var cssIndeterminatePseudo={A:{A:{"2":"I D E fB","132":"A B","388":"F"},B:{"1":"R S T U V W X P Y Z G","132":"C J K L M N O"},C:{"1":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","16":"gB VB iB jB","132":"0 1 2 3 4 5 6 I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","388":"H a"},D:{"1":"0 1 2 3 4 5 6 7 8 9 v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K","132":"L M N O b c d e f g h i j k l m n o p q r s t u"},E:{"1":"B C J K cB TB UB sB tB uB","16":"H a I nB bB","132":"D E F A pB qB rB","388":"oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","16":"F B vB wB xB yB TB dB","132":"L M N O b c d e f g h","516":"C zB UB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB 1B 2B","132":"E 3B 4B 5B 6B 7B"},H:{"516":"JC"},I:{"1":"G","16":"VB KC LC MC PC","132":"OC","388":"H NC eB"},J:{"16":"D","132":"A"},K:{"1":"Q","16":"A B C TB dB","516":"UB"},L:{"1":"G"},M:{"1":"P"},N:{"132":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"132":"cC"}},B:7,C:":indeterminate CSS pseudo-class"};

  var cssInitialLetter={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E nB bB oB pB qB","4":"F","164":"A B C J K rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B","164":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"CSS Initial Letter"};

  var cssInitialValue={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","33":"H a I D E F A B C J K L M N O iB jB","164":"gB VB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K bB oB pB qB rB cB TB UB sB tB uB","16":"nB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB"},H:{"2":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS initial value"};

  var cssLetterSpacing={A:{A:{"1":"F A B","16":"fB","132":"I D E"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","132":"H a I D E F A B C J K L M N O b c d e f g h i j k l"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","16":"nB","132":"H a I bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","16":"F vB","132":"B C L M wB xB yB TB dB zB UB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB"},H:{"2":"JC"},I:{"1":"G OC PC","16":"KC LC","132":"VB H MC NC eB"},J:{"132":"D A"},K:{"1":"Q","132":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"letter-spacing CSS property"};

  var cssLineClamp={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M","33":"R S T U V W X P Y Z G","129":"N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB iB jB","33":"LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"16":"H a I D E F A B C J","33":"0 1 2 3 4 5 6 7 8 9 K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H nB bB","33":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","33":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"bB 0B eB","33":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"16":"KC LC","33":"VB H G MC NC eB OC PC"},J:{"33":"D A"},K:{"2":"A B C TB dB UB","33":"Q"},L:{"33":"G"},M:{"33":"P"},N:{"2":"A B"},O:{"33":"QC"},P:{"33":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"33":"aC"},R:{"33":"bC"},S:{"2":"cC"}},B:5,C:"CSS line-clamp"};

  var cssLogicalProps={A:{A:{"2":"I D E F A B fB"},B:{"1":"Z G","2":"C J K L M N O","2052":"P Y","3588":"R S T U V W X"},C:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB","164":"VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w iB jB"},D:{"1":"Z G kB lB mB","292":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB","2052":"P Y","3588":"MB NB OB PB QB RB SB YB ZB aB R S T U V W X"},E:{"292":"H a I D E F A B C nB bB oB pB qB rB cB TB","2052":"tB uB","3588":"J K UB sB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","292":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB","2052":"RB SB","3588":"CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB"},G:{"292":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC","3588":"CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","292":"VB H KC LC MC NC eB OC PC"},J:{"292":"D A"},K:{"2":"A B C TB dB UB","3588":"Q"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"292":"QC"},P:{"292":"H RC SC TC UC VC","3588":"cB WC XC YC ZC"},Q:{"3588":"aC"},R:{"3588":"bC"},S:{"3588":"cC"}},B:5,C:"CSS Logical Properties"};

  var cssMarkerPseudo={A:{A:{"2":"I D E F A B fB"},B:{"1":"X P Y Z G","2":"C J K L M N O R S T U V W"},C:{"1":"LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB iB jB"},D:{"1":"X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W"},E:{"2":"H a I D E F A B nB bB oB pB qB rB cB","129":"C J K TB UB sB tB uB"},F:{"1":"PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB vB wB xB yB TB dB zB UB"},G:{"1":"AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"ZC","2":"H RC SC TC UC VC cB WC XC YC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"CSS ::marker pseudo-element"};

  var cssMasks={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M","164":"R S T U V W X P Y Z G","3138":"N","12292":"O"},C:{"1":"9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB","260":"0 1 2 3 4 5 6 7 8 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"164":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"nB bB","164":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","164":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"164":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"164":"G OC PC","676":"VB H KC LC MC NC eB"},J:{"164":"D A"},K:{"2":"A B C TB dB UB","164":"Q"},L:{"164":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"164":"QC"},P:{"164":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"164":"aC"},R:{"164":"bC"},S:{"260":"cC"}},B:4,C:"CSS Masks"};

  var cssMatchesPseudo={A:{A:{"2":"I D E F A B fB"},B:{"1":"Y Z G","2":"C J K L M N O","1220":"R S T U V W X P"},C:{"1":"aB R S T hB U V W X P Y Z G","16":"gB VB iB jB","548":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB"},D:{"1":"Y Z G kB lB mB","16":"H a I D E F A B C J K","164":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB","196":"IB JB KB","1220":"LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P"},E:{"1":"K tB uB","2":"H nB bB","16":"a","164":"I D E oB pB qB","260":"F A B C J rB cB TB UB sB"},F:{"1":"SB","2":"F B C vB wB xB yB TB dB zB UB","164":"0 1 2 3 4 5 6 7 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","196":"8 9 AB","1220":"BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB"},G:{"1":"HC IC","16":"bB 0B eB 1B 2B","164":"E 3B 4B","260":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC"},H:{"2":"JC"},I:{"1":"G","16":"VB KC LC MC","164":"H NC eB OC PC"},J:{"16":"D","164":"A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"164":"QC"},P:{"164":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1220":"aC"},R:{"164":"bC"},S:{"548":"cC"}},B:5,C:":is() CSS pseudo-class"};

  var cssMathFunctions={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB iB jB"},D:{"1":"R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB"},E:{"1":"K sB tB uB","2":"H a I D E F A B nB bB oB pB qB rB cB","132":"C J TB UB"},F:{"1":"JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB vB wB xB yB TB dB zB UB"},G:{"1":"GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B","132":"AC BC CC DC EC FC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"XC YC ZC","2":"H RC SC TC UC VC cB WC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"CSS math functions min(), max() and clamp()"};

  var cssMediaInteraction={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"H a I D E nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j vB wB xB yB TB dB zB UB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:5,C:"Media Queries: interaction media features"};

  var cssMediaResolution={A:{A:{"2":"I D E fB","132":"F A B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB","260":"H a I D E F A B C J K L iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","548":"H a I D E F A B C J K L M N O b c d e f g h i j k"},E:{"2":"nB bB","548":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F","548":"B C vB wB xB yB TB dB zB"},G:{"16":"bB","548":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"132":"JC"},I:{"1":"G OC PC","16":"KC LC","548":"VB H MC NC eB"},J:{"548":"D A"},K:{"1":"Q UB","548":"A B C TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"132":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"Media Queries: resolution feature"};

  var cssMediaScripting={A:{A:{"2":"I D E F A B fB"},B:{"16":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","16":"8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G","16":"kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"Media Queries: scripting media feature"};

  var cssMediaqueries={A:{A:{"8":"I D E fB","129":"F A B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB VB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","129":"H a I D E F A B C J K L M N O b c d e f g h"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","129":"H a I oB","388":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","2":"F"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","129":"bB 0B eB 1B 2B"},H:{"1":"JC"},I:{"1":"G OC PC","129":"VB H KC LC MC NC eB"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"129":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"CSS3 Media Queries"};

  var cssMixblendmode={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k","194":"l m n o p q r s t u v w"},E:{"2":"H a I D nB bB oB pB","260":"E F A B C J K qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k vB wB xB yB TB dB zB UB"},G:{"2":"bB 0B eB 1B 2B 3B","260":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"Blending of HTML/SVG elements"};

  var cssMotionPaths={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB iB jB"},D:{"1":"2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y","194":"0 1 z"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l vB wB xB yB TB dB zB UB","194":"m n o"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:5,C:"CSS Motion Path"};

  var cssNamespaces={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","16":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"CSS namespaces"};

  var cssNotSelList={A:{A:{"2":"I D E F A B fB"},B:{"1":"Y Z G","2":"C J K L M N O S T U V W X P","16":"R"},C:{"1":"V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U iB jB"},D:{"1":"Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"H a I D E nB bB oB pB qB"},F:{"1":"SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB vB wB xB yB TB dB zB UB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"selector list argument of :not()"};

  var cssNthChildOf={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"H a I D E nB bB oB pB qB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"selector list argument of :nth-child and :nth-last-child CSS pseudo-classes"};

  var cssOpacity={A:{A:{"1":"F A B","4":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"CSS3 Opacity"};

  var cssOptionalPseudo={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","16":"F vB","132":"B C wB xB yB TB dB zB UB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB"},H:{"132":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"Q","132":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:7,C:":optional CSS pseudo-class"};

  var cssOverflowAnchor={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB iB jB"},D:{"1":"CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"2":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:5,C:"CSS overflow-anchor (Scroll Anchoring)"};

  var cssOverflowOverlay={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K"},E:{"1":"H a I D E F A B oB pB qB rB cB TB","16":"nB bB","130":"C J K UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC","16":"bB","130":"BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"16":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:7,C:"CSS overflow: overlay"};

  var cssOverflow={A:{A:{"388":"I D E F A B fB"},B:{"1":"G","260":"R S T U V W X P Y Z","388":"C J K L M N O"},C:{"1":"T hB U V W X P Y Z G","260":"XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S","388":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB iB jB"},D:{"1":"G kB lB mB","260":"LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z","388":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB"},E:{"260":"K sB tB uB","388":"H a I D E F A B C J nB bB oB pB qB rB cB TB UB"},F:{"260":"BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","388":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB vB wB xB yB TB dB zB UB"},G:{"260":"GC HC IC","388":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC"},H:{"388":"JC"},I:{"1":"G","388":"VB H KC LC MC NC eB OC PC"},J:{"388":"D A"},K:{"388":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"388":"A B"},O:{"388":"QC"},P:{"388":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"388":"aC"},R:{"388":"bC"},S:{"388":"cC"}},B:5,C:"CSS overflow property"};

  var cssOverscrollBehavior={A:{A:{"2":"I D E F fB","132":"A B"},B:{"1":"R S T U V W X P Y Z G","132":"C J K L M N","516":"O"},C:{"1":"WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB iB jB"},D:{"1":"IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q","260":"GB HB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB uB","1090":"tB"},F:{"1":"8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB","260":"6 7"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"132":"A B"},O:{"2":"QC"},P:{"1":"UC VC cB WC XC YC ZC","2":"H RC SC TC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"CSS overscroll-behavior"};

  var cssPageBreak={A:{A:{"388":"A B","900":"I D E F fB"},B:{"388":"C J K L M N O","900":"R S T U V W X P Y Z G"},C:{"772":"IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","900":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB iB jB"},D:{"900":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"772":"A","900":"H a I D E F B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"16":"F vB","129":"B C wB xB yB TB dB zB UB","900":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"900":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"129":"JC"},I:{"900":"VB H G KC LC MC NC eB OC PC"},J:{"900":"D A"},K:{"129":"A B C TB dB UB","900":"Q"},L:{"900":"G"},M:{"900":"P"},N:{"388":"A B"},O:{"900":"QC"},P:{"900":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"900":"aC"},R:{"900":"bC"},S:{"900":"cC"}},B:2,C:"CSS page-break properties"};

  var cssPagedMedia={A:{A:{"2":"I D fB","132":"E F A B"},B:{"1":"R S T U V W X P Y Z G","132":"C J K L M N O"},C:{"2":"gB VB H a I D E F A B C J K L M N O iB jB","132":"0 1 2 3 4 5 6 7 8 9 b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","132":"F B C vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"16":"JC"},I:{"16":"VB H G KC LC MC NC eB OC PC"},J:{"16":"D A"},K:{"16":"A B C TB dB UB","258":"Q"},L:{"1":"G"},M:{"132":"P"},N:{"258":"A B"},O:{"258":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"132":"cC"}},B:5,C:"CSS Paged Media (@page)"};

  var cssPaintApi={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB"},E:{"2":"H a I D E F A B C nB bB oB pB qB rB cB TB","194":"J K UB sB tB uB"},F:{"1":"8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"CSS Paint API"};

  var cssPlaceholderShown={A:{A:{"2":"I D E F fB","292":"A B"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB","164":"0 1 2 3 4 5 6 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},D:{"1":"3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"H a I D E nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p vB wB xB yB TB dB zB UB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"164":"cC"}},B:5,C:":placeholder-shown CSS pseudo-class"};

  var cssPlaceholder={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","36":"C J K L M N O"},C:{"1":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O iB jB","33":"0 1 2 3 4 5 6 b c d e f g h i j k l m n o p q r s t u v w x y z"},D:{"1":"DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","36":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H nB bB","36":"a I D E F A oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB","36":"L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B","36":"E eB 1B 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G","36":"VB H KC LC MC NC eB OC PC"},J:{"36":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"36":"A B"},O:{"1":"QC"},P:{"1":"TC UC VC cB WC XC YC ZC","36":"H RC SC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"33":"cC"}},B:5,C:"::placeholder CSS pseudo-element"};

  var cssReadOnlyWrite={A:{A:{"2":"I D E F A B fB"},B:{"1":"J K L M N O R S T U V W X P Y Z G","2":"C"},C:{"1":"aB R S T hB U V W X P Y Z G","16":"gB","33":"0 1 2 3 4 5 6 7 8 9 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K","132":"L M N O b c d e f g h i j k l m n o p q r"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","16":"nB bB","132":"H a I D E oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","16":"F B vB wB xB yB TB","132":"C L M N O b c d e dB zB UB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B","132":"E eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"1":"G","16":"KC LC","132":"VB H MC NC eB OC PC"},J:{"1":"A","132":"D"},K:{"1":"Q","2":"A B TB","132":"C dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"33":"cC"}},B:1,C:"CSS :read-only and :read-write selectors"};

  var cssRebeccapurple={A:{A:{"2":"I D E F A fB","132":"B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t"},E:{"1":"D E F A B C J K qB rB cB TB UB sB tB uB","2":"H a I nB bB oB","16":"pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g vB wB xB yB TB dB zB UB"},G:{"1":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B 3B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"Rebeccapurple color"};

  var cssReflections={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","33":"R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"33":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"nB bB","33":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","33":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"33":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"33":"VB H G KC LC MC NC eB OC PC"},J:{"33":"D A"},K:{"2":"A B C TB dB UB","33":"Q"},L:{"33":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"33":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"33":"aC"},R:{"33":"bC"},S:{"2":"cC"}},B:7,C:"CSS Reflections"};

  var cssRegions={A:{A:{"2":"I D E F fB","420":"A B"},B:{"2":"R S T U V W X P Y Z G","420":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","36":"L M N O","66":"b c d e f g h i j k l m n o p q"},E:{"2":"H a I C J K nB bB oB TB UB sB tB uB","33":"D E F A B pB qB rB cB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"bB 0B eB 1B 2B AC BC CC DC EC FC GC HC IC","33":"E 3B 4B 5B 6B 7B 8B 9B"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"420":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"CSS Regions"};

  var cssRepeatingGradients={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB","33":"H a I D E F A B C J K L jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F","33":"A B C J K L M N O b c d e f g h"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB","33":"I oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B vB wB xB yB","33":"C zB","36":"TB dB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB","33":"1B 2B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB KC LC MC","33":"H NC eB"},J:{"1":"A","2":"D"},K:{"1":"Q UB","2":"A B","33":"C","36":"TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS Repeating Gradients"};

  var cssResize={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB","33":"H"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB","132":"UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:4,C:"CSS resize property"};

  var cssRevertValue={A:{A:{"2":"I D E F A B fB"},B:{"1":"V W X P Y Z G","2":"C J K L M N O R S T U"},C:{"1":"KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB iB jB"},D:{"1":"V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U"},E:{"1":"A B C J K rB cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB"},F:{"1":"QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB vB wB xB yB TB dB zB UB"},G:{"1":"6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"ZC","2":"H RC SC TC UC VC cB WC XC YC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"CSS revert value"};

  var cssRrggbbaa={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","194":"8 9 AB BB CB DB EB WB FB XB"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB"},F:{"1":"8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u vB wB xB yB TB dB zB UB","194":"0 1 2 3 4 5 6 7 v w x y z"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"UC VC cB WC XC YC ZC","2":"H","194":"RC SC TC"},Q:{"2":"aC"},R:{"194":"bC"},S:{"2":"cC"}},B:7,C:"#rrggbbaa hex color notation"};

  var cssScrollBehavior={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","129":"R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r iB jB"},D:{"2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w","129":"XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","450":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB"},E:{"2":"H a I D E F A B C J nB bB oB pB qB rB cB TB UB sB","578":"K tB uB"},F:{"2":"F B C L M N O b c d e f g h i j vB wB xB yB TB dB zB UB","129":"4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","450":"0 1 2 3 k l m n o p q r s t u v w x y z"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"129":"QC"},P:{"1":"UC VC cB WC XC YC ZC","2":"H RC SC TC"},Q:{"129":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"CSSOM Scroll-behavior"};

  var cssScrollTimeline={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z","194":"G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V","194":"Y Z G kB lB mB","322":"W X P"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB vB wB xB yB TB dB zB UB","194":"SB","322":"QB RB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"CSS @scroll-timeline"};

  var cssScrollbar={A:{A:{"132":"I D E F A B fB"},B:{"2":"C J K L M N O","292":"R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q iB jB","3074":"GB","4100":"HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"292":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"16":"H a nB bB","292":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","292":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"16":"bB 0B eB 1B 2B","292":"3B","804":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"16":"KC LC","292":"VB H G MC NC eB OC PC"},J:{"292":"D A"},K:{"2":"A B C TB dB UB","292":"Q"},L:{"292":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"292":"QC"},P:{"292":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"292":"aC"},R:{"292":"bC"},S:{"2":"cC"}},B:7,C:"CSS scrollbar styling"};

  var cssSel2={A:{A:{"1":"D E F A B","2":"fB","8":"I"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"CSS 2.1 selectors"};

  var cssSel3={A:{A:{"1":"F A B","2":"fB","8":"I","132":"D E"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB VB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K bB oB pB qB rB cB TB UB sB tB uB","2":"nB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","2":"F"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"CSS3 selectors"};

  var cssSelection={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","33":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","2":"F"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"A","2":"D"},K:{"1":"C Q dB UB","16":"A B TB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"33":"cC"}},B:5,C:"::selection CSS pseudo-element"};

  var cssShapes={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","322":"7 8 9 AB BB CB DB EB WB FB XB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p","194":"q r s"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D nB bB oB pB","33":"E F A qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f vB wB xB yB TB dB zB UB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B 3B","33":"E 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:4,C:"CSS Shapes Level 1"};

  var cssSnappoints={A:{A:{"2":"I D E F fB","6308":"A","6436":"B"},B:{"1":"R S T U V W X P Y Z G","6436":"C J K L M N O"},C:{"1":"LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u iB jB","2052":"0 1 2 3 4 5 6 7 8 9 v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB"},D:{"1":"MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB","8258":"JB KB LB"},E:{"1":"B C J K TB UB sB tB uB","2":"H a I D E nB bB oB pB qB","3108":"F A rB cB"},F:{"1":"HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB","8258":"AB BB CB DB EB FB Q GB"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B","3108":"5B 6B 7B 8B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"cB WC XC YC ZC","2":"H RC SC TC UC VC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2052":"cC"}},B:4,C:"CSS Scroll Snap"};

  var cssSticky={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L","1028":"R S T U V W X P Y Z G","4100":"M N O"},C:{"1":"WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h iB jB","194":"i j k l m n","516":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB"},D:{"1":"kB lB mB","2":"0 1 2 3 4 5 6 7 H a I D E F A B C J K L M N O b c d e t u v w x y z","322":"8 9 f g h i j k l m n o p q r s AB BB","1028":"CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G"},E:{"1":"J K sB tB uB","2":"H a I nB bB oB","33":"E F A B C qB rB cB TB UB","2084":"D pB"},F:{"2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u vB wB xB yB TB dB zB UB","322":"v w x","1028":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"1":"DC EC FC GC HC IC","2":"bB 0B eB 1B","33":"E 4B 5B 6B 7B 8B 9B AC BC CC","2084":"2B 3B"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB OC PC","1028":"G"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","1028":"Q"},L:{"1028":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1028":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","2":"H RC"},Q:{"1028":"aC"},R:{"2":"bC"},S:{"516":"cC"}},B:5,C:"CSS position:sticky"};

  var cssSubgrid={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"CSS Subgrid"};

  var cssSupportsApi={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","260":"C J K L M N O"},C:{"1":"BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b iB jB","66":"c d","260":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB"},D:{"1":"XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j","260":"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"H a I D E nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB","132":"UB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B"},H:{"132":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB","132":"UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS.supports() API"};

  var cssTable={A:{A:{"1":"E F A B","2":"I D fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","132":"gB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"CSS Table display"};

  var cssTextAlignLast={A:{A:{"132":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","4":"C J K L M N O"},C:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B iB jB","33":"0 1 2 3 4 C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},D:{"1":"3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q","322":"0 1 2 r s t u v w x y z"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d vB wB xB yB TB dB zB UB","578":"e f g h i j k l m n o p"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"132":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"2":"aC"},R:{"1":"bC"},S:{"33":"cC"}},B:5,C:"CSS3 text-align-last"};

  var cssTextIndent={A:{A:{"132":"I D E F A B fB"},B:{"132":"C J K L M N O","388":"R S T U V W X P Y Z G"},C:{"132":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"132":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t","388":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"132":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"132":"F B C L M N O b c d e f g vB wB xB yB TB dB zB UB","388":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"132":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"132":"JC"},I:{"132":"VB H KC LC MC NC eB OC PC","388":"G"},J:{"132":"D A"},K:{"132":"A B C TB dB UB","388":"Q"},L:{"388":"G"},M:{"132":"P"},N:{"132":"A B"},O:{"132":"QC"},P:{"132":"H","388":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"388":"aC"},R:{"388":"bC"},S:{"132":"cC"}},B:5,C:"CSS text-indent"};

  var cssTextJustify={A:{A:{"16":"I D fB","132":"E F A B"},B:{"132":"C J K L M N O","322":"R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","1025":"BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","1602":"AB"},D:{"2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y","322":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C L M N O b c d e f g h i j k l vB wB xB yB TB dB zB UB","322":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB OC PC","322":"G"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","322":"Q"},L:{"322":"G"},M:{"1025":"P"},N:{"132":"A B"},O:{"2":"QC"},P:{"2":"H","322":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"322":"aC"},R:{"322":"bC"},S:{"2":"cC"}},B:5,C:"CSS text-justify"};

  var cssTextOrientation={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t iB jB","194":"u v w"},D:{"1":"4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"K tB uB","2":"H a I D E F nB bB oB pB qB rB","16":"A","33":"B C J cB TB UB sB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q vB wB xB yB TB dB zB UB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS text-orientation"};

  var cssTextSpacing={A:{A:{"2":"I D fB","161":"E F A B"},B:{"2":"R S T U V W X P Y Z G","161":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"16":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"CSS Text 4 text-spacing"};

  var cssTextshadow={A:{A:{"2":"I D E F fB","129":"A B"},B:{"1":"R S T U V W X P Y Z G","129":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB VB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","260":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","2":"F"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"4":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"A","4":"D"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"129":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS3 Text-shadow"};

  var cssTouchAction2={A:{A:{"2":"I D E F fB","132":"B","164":"A"},B:{"1":"R S T U V W X P Y Z G","132":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB","260":"BB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x vB wB xB yB TB dB zB UB","260":"y"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"132":"B","164":"A"},O:{"2":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","16":"H"},Q:{"2":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:5,C:"CSS touch-action level 2 values"};

  var cssTouchAction={A:{A:{"1":"B","2":"I D E F fB","289":"A"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k iB jB","194":"0 1 2 3 4 5 6 7 l m n o p q r s t u v w x y z","1025":"8 9 AB BB CB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e vB wB xB yB TB dB zB UB"},G:{"1":"DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B","516":"6B 7B 8B 9B AC BC CC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","289":"A"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"194":"cC"}},B:2,C:"CSS touch-action property"};

  var cssTransitions={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB","33":"a I D E F A B C J K L","164":"H"},D:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","33":"H a I D E F A B C J K L M N O b c d e f g h"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","33":"I oB","164":"H a nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F vB wB","33":"C","164":"B xB yB TB dB zB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","33":"2B","164":"bB 0B eB 1B"},H:{"2":"JC"},I:{"1":"G OC PC","33":"VB H KC LC MC NC eB"},J:{"1":"A","33":"D"},K:{"1":"Q UB","33":"C","164":"A B TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"CSS3 Transitions"};

  var cssUnicodeBidi={A:{A:{"132":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","132":"C J K L M N O"},C:{"1":"6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","33":"0 1 2 3 4 5 N O b c d e f g h i j k l m n o p q r s t u v w x y z","132":"gB VB H a I D E F iB jB","292":"A B C J K L M"},D:{"1":"4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","132":"H a I D E F A B C J K L M","548":"0 1 2 3 N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"132":"H a I D E nB bB oB pB qB","548":"F A B C J K rB cB TB UB sB tB uB"},F:{"132":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"132":"E bB 0B eB 1B 2B 3B 4B","548":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"16":"JC"},I:{"1":"G","16":"VB H KC LC MC NC eB OC PC"},J:{"16":"D A"},K:{"16":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"132":"A B"},O:{"16":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","16":"H"},Q:{"16":"aC"},R:{"16":"bC"},S:{"33":"cC"}},B:4,C:"CSS unicode-bidi property"};

  var cssUnsetValue={A:{A:{"2":"I D E F A B fB"},B:{"1":"J K L M N O R S T U V W X P Y Z G","2":"C"},C:{"1":"0 1 2 3 4 5 6 7 8 9 j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w"},E:{"1":"A B C J K rB cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j vB wB xB yB TB dB zB UB"},G:{"1":"6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS unset value"};

  var cssVariables={A:{A:{"2":"I D E F A B fB"},B:{"1":"M N O R S T U V W X P Y Z G","2":"C J K","260":"L"},C:{"1":"0 1 2 3 4 5 6 7 8 9 n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m iB jB"},D:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","194":"4"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB","260":"rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q vB wB xB yB TB dB zB UB","194":"r"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B","260":"6B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"2":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:4,C:"CSS Variables (Custom Properties)"};

  var cssWidowsOrphans={A:{A:{"1":"A B","2":"I D fB","129":"E F"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g"},E:{"1":"D E F A B C J K qB rB cB TB UB sB tB uB","2":"H a I nB bB oB pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","129":"F B vB wB xB yB TB dB zB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B"},H:{"1":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"2":"D A"},K:{"1":"Q UB","2":"A B C TB dB"},L:{"1":"G"},M:{"2":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:2,C:"CSS widows & orphans"};

  var cssWritingMode={A:{A:{"132":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r iB jB","322":"s t u v w"},D:{"1":"4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I","16":"D","33":"0 1 2 3 E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"B C J K TB UB sB tB uB","2":"H nB bB","16":"a","33":"I D E F A oB pB qB rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB","33":"L M N O b c d e f g h i j k l m n o p q"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB","33":"E 1B 2B 3B 4B 5B 6B 7B 8B"},H:{"2":"JC"},I:{"1":"G","2":"KC LC MC","33":"VB H NC eB OC PC"},J:{"33":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"36":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","33":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS writing-mode property"};

  var cssZoom={A:{A:{"1":"I D fB","129":"E F A B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB"},H:{"2":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"129":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:7,C:"CSS zoom"};

  var css3Attr={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:4,C:"CSS3 attr() function for all properties"};

  var css3Boxsizing={A:{A:{"1":"E F A B","8":"I D fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","33":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","33":"H a I D E F"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","33":"H a nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","2":"F"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","33":"bB 0B eB"},H:{"1":"JC"},I:{"1":"H G NC eB OC PC","33":"VB KC LC MC"},J:{"1":"A","33":"D"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"CSS3 Box-sizing"};

  var css3Colors={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","4":"gB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB wB xB yB TB dB zB UB","2":"F","4":"vB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"CSS3 Colors"};

  var css3CursorsGrab={A:{A:{"2":"I D E F A B fB"},B:{"1":"L M N O R S T U V W X P Y Z G","2":"C J K"},C:{"1":"0 1 2 3 4 5 6 7 8 9 j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","33":"gB VB H a I D E F A B C J K L M N O b c d e f g h i iB jB"},D:{"1":"LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","33":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB"},E:{"1":"B C J K TB UB sB tB uB","33":"H a I D E F A nB bB oB pB qB rB cB"},F:{"1":"C BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB","2":"F B vB wB xB yB TB dB","33":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"33":"D A"},K:{"2":"A B C TB dB UB","33":"Q"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"33":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:3,C:"CSS grab & grabbing cursors"};

  var css3CursorsNewer={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","33":"gB VB H a I D E F A B C J K L M N O b c d e f iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","33":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","33":"H a I D E nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB","2":"F B vB wB xB yB TB dB","33":"L M N O b c d e f"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"33":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:4,C:"CSS3 Cursors: zoom-in & zoom-out"};

  var css3Cursors={A:{A:{"1":"F A B","132":"I D E fB"},B:{"1":"K L M N O R S T U V W X P Y Z G","260":"C J"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","4":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","4":"H"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","4":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","260":"F B C vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D","16":"A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:4,C:"CSS3 Cursors (original values)"};

  var css3Tabsize={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"gB VB iB jB","33":"9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","164":"0 1 2 3 4 5 6 7 8 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},D:{"1":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c","132":"d e f g h i j k l m n o p q r s t u v w x"},E:{"1":"K sB tB uB","2":"H a I nB bB oB","132":"D E F A B C J pB qB rB cB TB UB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F vB wB xB","132":"L M N O b c d e f g h i j k","164":"B C yB TB dB zB UB"},G:{"1":"GC HC IC","2":"bB 0B eB 1B 2B","132":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC"},H:{"164":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB","132":"OC PC"},J:{"132":"D A"},K:{"1":"Q","2":"A","164":"B C TB dB UB"},L:{"1":"G"},M:{"33":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"164":"cC"}},B:5,C:"CSS3 tab-size"};

  var currentcolor={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","2":"F"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"CSS currentColor value"};

  var customElements={A:{A:{"2":"I D E F fB","8":"A B"},B:{"1":"R","2":"S T U V W X P Y Z G","8":"C J K L M N O"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","66":"f g h i j k l","72":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R","2":"H a I D E F A B C J K L M N O b c d e f g h i S T U V W X P Y Z G kB lB mB","66":"j k l m n o"},E:{"2":"H a nB bB oB","8":"I D E F A B C J K pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB","2":"F B C KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","66":"L M N O b"},G:{"2":"bB 0B eB 1B 2B","8":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"PC","2":"VB H G KC LC MC NC eB OC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC","2":"YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"72":"cC"}},B:7,C:"Custom Elements (deprecated V0 spec)"};

  var customElementsv1={A:{A:{"2":"I D E F fB","8":"A B"},B:{"1":"R S T U V W X P Y Z G","8":"C J K L M N O"},C:{"1":"GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l iB jB","8":"0 1 2 3 4 5 m n o p q r s t u v w x y z","456":"6 7 8 9 AB BB CB DB EB","712":"WB FB XB Q"},D:{"1":"KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","8":"8 9","132":"AB BB CB DB EB WB FB XB Q GB HB IB JB"},E:{"2":"H a I D nB bB oB pB qB","8":"E F A rB","132":"B C J K cB TB UB sB tB uB"},F:{"1":"HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w vB wB xB yB TB dB zB UB","132":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB FB Q GB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B","132":"8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","2":"H","132":"RC"},Q:{"132":"aC"},R:{"132":"bC"},S:{"8":"cC"}},B:1,C:"Custom Elements (V1)"};

  var customevent={A:{A:{"2":"I D E fB","132":"F A B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a iB jB","132":"I D E F A"},D:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H","16":"a I D E J K","388":"F A B C"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H nB bB","16":"a I","388":"oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB","2":"F vB wB xB yB","132":"B TB dB"},G:{"1":"E 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"0B","16":"bB eB","388":"1B"},H:{"1":"JC"},I:{"1":"G OC PC","2":"KC LC MC","388":"VB H NC eB"},J:{"1":"A","388":"D"},K:{"1":"C Q UB","2":"A","132":"B TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"132":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"CustomEvent"};

  var datalist={A:{A:{"2":"fB","8":"I D E F","260":"A B"},B:{"1":"R S T U V W X P Y Z G","260":"C J K L","1284":"M N O"},C:{"8":"gB VB iB jB","4612":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","8":"H a I D E F A B C J K L M N O b","132":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB"},E:{"1":"J K UB sB tB uB","8":"H a I D E F A B C nB bB oB pB qB rB cB TB"},F:{"1":"F B C HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","132":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB"},G:{"8":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC","2049":"CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G PC","8":"VB H KC LC MC NC eB OC"},J:{"1":"A","8":"D"},K:{"1":"A B C TB dB UB","8":"Q"},L:{"1":"G"},M:{"516":"P"},N:{"8":"A B"},O:{"8":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"132":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:1,C:"Datalist element"};

  var dataset={A:{A:{"1":"B","4":"I D E F A fB"},B:{"1":"C J K L M","129":"N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","4":"gB VB H a iB jB","129":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"1 2 3 4 5 6 7 8 9 AB","4":"H a I","129":"0 D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"4":"H a nB bB","129":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB"},F:{"1":"C o p q r s t u v w x TB dB zB UB","4":"F B vB wB xB yB","129":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"4":"bB 0B eB","129":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"4":"JC"},I:{"4":"KC LC MC","129":"VB H G NC eB OC PC"},J:{"129":"D A"},K:{"1":"C TB dB UB","4":"A B","129":"Q"},L:{"129":"G"},M:{"129":"P"},N:{"1":"B","4":"A"},O:{"129":"QC"},P:{"129":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"129":"bC"},S:{"1":"cC"}},B:1,C:"dataset & data-* attributes"};

  var datauri={A:{A:{"2":"I D fB","132":"E","260":"F A B"},B:{"1":"R S T U V W X P Y Z G","260":"C J L M N O","772":"K"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"260":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"Data URIs"};

  var dateTolocaledatestring={A:{A:{"16":"fB","132":"I D E F A B"},B:{"1":"O R S T U V W X P Y Z G","132":"C J K L M N"},C:{"1":"CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","132":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k iB jB","260":"8 9 AB BB","772":"0 1 2 3 4 5 6 7 l m n o p q r s t u v w x y z"},D:{"1":"NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","132":"H a I D E F A B C J K L M N O b c d e f","260":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB","772":"g h i j k l m n o p q r s t"},E:{"1":"C J K UB sB tB uB","16":"H a nB bB","132":"I D E F A oB pB qB rB","260":"B cB TB"},F:{"1":"DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","16":"F B C vB wB xB yB TB dB zB","132":"UB","260":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB","772":"L M N O b c d e f g"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB 1B","132":"E 2B 3B 4B 5B 6B 7B"},H:{"132":"JC"},I:{"1":"G","16":"VB KC LC MC","132":"H NC eB","772":"OC PC"},J:{"132":"D A"},K:{"1":"Q","16":"A B C TB dB","132":"UB"},L:{"1":"G"},M:{"1":"P"},N:{"132":"A B"},O:{"260":"QC"},P:{"1":"VC cB WC XC YC ZC","260":"H RC SC TC UC"},Q:{"260":"aC"},R:{"132":"bC"},S:{"132":"cC"}},B:6,C:"Date.prototype.toLocaleDateString"};

  var details={A:{A:{"2":"F A B fB","8":"I D E"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB","8":"0 1 2 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","194":"3 4"},D:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","8":"H a I D E F A B","257":"b c d e f g h i j k l m n o p q r","769":"C J K L M N O"},E:{"1":"C J K UB sB tB uB","8":"H a nB bB oB","257":"I D E F A pB qB rB","1025":"B cB TB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"C TB dB zB UB","8":"F B vB wB xB yB"},G:{"1":"E 2B 3B 4B 5B 6B AC BC CC DC EC FC GC HC IC","8":"bB 0B eB 1B","1025":"7B 8B 9B"},H:{"8":"JC"},I:{"1":"H G NC eB OC PC","8":"VB KC LC MC"},J:{"1":"A","8":"D"},K:{"1":"Q","8":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"769":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Details & Summary elements"};

  var deviceorientation={A:{A:{"2":"I D E F A fB","132":"B"},B:{"1":"C J K L M N O","4":"R S T U V W X P Y Z G"},C:{"2":"gB VB iB","4":"0 1 2 3 4 5 6 7 8 9 I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","8":"H a jB"},D:{"2":"H a I","4":"0 1 2 3 4 5 6 7 8 9 D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","4":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"bB 0B","4":"E eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"KC LC MC","4":"VB H G NC eB OC PC"},J:{"2":"D","4":"A"},K:{"1":"C UB","2":"A B TB dB","4":"Q"},L:{"4":"G"},M:{"4":"P"},N:{"1":"B","2":"A"},O:{"4":"QC"},P:{"4":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"4":"aC"},R:{"4":"bC"},S:{"4":"cC"}},B:4,C:"DeviceOrientation & DeviceMotion events"};

  var devicepixelratio={A:{A:{"1":"B","2":"I D E F A fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB","2":"F B vB wB xB yB TB dB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"C Q UB","2":"A B TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","2":"A"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"Window.devicePixelRatio"};

  var dialog={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","194":"9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R","1218":"S T hB U V W X P Y Z G"},D:{"1":"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n","322":"o p q r s"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O vB wB xB yB TB dB zB UB","578":"b c d e f"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"194":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:1,C:"Dialog element"};

  var dispatchevent={A:{A:{"1":"B","16":"fB","129":"F A","130":"I D E"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K bB oB pB qB rB cB TB UB sB tB uB","16":"nB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","16":"F"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB"},H:{"1":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","129":"A"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"EventTarget.dispatchEvent"};

  var dnssec={A:{A:{"132":"I D E F A B fB"},B:{"132":"C J K L M N O R S T U V W X P Y Z G"},C:{"132":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"132":"0 1 2 3 4 5 6 7 8 9 H a n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","388":"I D E F A B C J K L M N O b c d e f g h i j k l m"},E:{"132":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"132":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"132":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"132":"JC"},I:{"132":"VB H G KC LC MC NC eB OC PC"},J:{"132":"D A"},K:{"132":"A B C Q TB dB UB"},L:{"132":"G"},M:{"132":"P"},N:{"132":"A B"},O:{"132":"QC"},P:{"132":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"132":"aC"},R:{"132":"bC"},S:{"132":"cC"}},B:6,C:"DNSSEC and DANE"};

  var doNotTrack={A:{A:{"2":"I D E fB","164":"F A","260":"B"},B:{"1":"N O R S T U V W X P Y Z G","260":"C J K L M"},C:{"1":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E iB jB","516":"F A B C J K L M N O b c d e f g h i j k l m n"},D:{"1":"0 1 2 3 4 5 6 7 8 9 f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e"},E:{"1":"I A B C oB rB cB TB","2":"H a J K nB bB UB sB tB uB","1028":"D E F pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B vB wB xB yB TB dB zB"},G:{"1":"5B 6B 7B 8B 9B AC BC","2":"bB 0B eB 1B 2B CC DC EC FC GC HC IC","1028":"E 3B 4B"},H:{"1":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"16":"D","1028":"A"},K:{"1":"Q UB","16":"A B C TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"164":"A","260":"B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"Do Not Track API"};

  var documentCurrentscript={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k"},E:{"1":"E F A B C J K rB cB TB UB sB tB uB","2":"H a I D nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L vB wB xB yB TB dB zB UB"},G:{"1":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B 3B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"document.currentScript"};

  var documentEvaluateXpath={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","16":"gB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","16":"F"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:7,C:"document.evaluate & XPath"};

  var documentExeccommand={A:{A:{"1":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","16":"H a nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB wB xB yB TB dB zB UB","16":"F vB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B","16":"eB 1B 2B"},H:{"2":"JC"},I:{"1":"G NC eB OC PC","2":"VB H KC LC MC"},J:{"1":"A","2":"D"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","2":"A"},O:{"2":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:7,C:"Document.execCommand()"};

  var documentPolicy={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V","132":"W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V","132":"W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB vB wB xB yB TB dB zB UB","132":"OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB OC PC","132":"G"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"132":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Document Policy"};

  var documentScrollingelement={A:{A:{"2":"I D E F A B fB"},B:{"1":"K L M N O R S T U V W X P Y Z G","16":"C J"},C:{"1":"4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"H a I D E nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m vB wB xB yB TB dB zB UB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"document.scrollingElement"};

  var documenthead={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB","16":"a"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB TB dB zB UB","2":"F vB wB xB yB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB"},H:{"1":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"document.head"};

  var domManipConvenience={A:{A:{"2":"I D E F A B fB"},B:{"1":"N O R S T U V W X P Y Z G","2":"C J K L M"},C:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","194":"8 9"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v vB wB xB yB TB dB zB UB","194":"w"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","2":"H RC"},Q:{"194":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:1,C:"DOM manipulation convenience methods"};

  var domRange={A:{A:{"1":"F A B","2":"fB","8":"I D E"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Document Object Model Range"};

  var domcontentloaded={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"DOMContentLoaded"};

  var domfocusinDomfocusoutEvents={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K L M N O b c d e f g h"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB","16":"a"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB","16":"F B vB wB xB yB TB dB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB 1B 2B"},H:{"16":"JC"},I:{"1":"H G NC eB OC PC","16":"VB KC LC MC"},J:{"16":"D A"},K:{"16":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"16":"A B"},O:{"16":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:5,C:"DOMFocusIn & DOMFocusOut events"};

  var dommatrix={A:{A:{"2":"I D E F fB","132":"A B"},B:{"132":"C J K L M N O","1028":"R S T U V W X P Y Z G"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o iB jB","1028":"MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2564":"0 1 2 3 4 p q r s t u v w x y z","3076":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB"},D:{"16":"H a I D","132":"0 1 2 3 4 5 6 7 8 9 F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB","388":"E","1028":"XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"16":"H nB bB","132":"a I D E F A oB pB qB rB cB","1028":"B C J K TB UB sB tB uB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","132":"0 1 2 3 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","1028":"4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"16":"bB 0B eB","132":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"132":"H NC eB OC PC","292":"VB KC LC MC","1028":"G"},J:{"16":"D","132":"A"},K:{"2":"A B C TB dB UB","132":"Q"},L:{"1028":"G"},M:{"1028":"P"},N:{"132":"A B"},O:{"132":"QC"},P:{"132":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"132":"aC"},R:{"132":"bC"},S:{"2564":"cC"}},B:4,C:"DOMMatrix"};

  var download={A:{A:{"2":"I D E F A B fB"},B:{"1":"J K L M N O R S T U V W X P Y Z G","2":"C"},C:{"1":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"A","2":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Download attribute"};

  var dragndrop={A:{A:{"644":"I D E F fB","772":"A B"},B:{"1":"O R S T U V W X P Y Z G","260":"C J K L M N"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","8":"gB VB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","8":"F B vB wB xB yB TB dB zB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB OC PC","1025":"G"},J:{"2":"D A"},K:{"1":"UB","8":"A B C TB dB","1025":"Q"},L:{"1025":"G"},M:{"2":"P"},N:{"1":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:1,C:"Drag and Drop"};

  var elementClosest={A:{A:{"2":"I D E F A B fB"},B:{"1":"L M N O R S T U V W X P Y Z G","2":"C J K"},C:{"1":"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"H a I D E nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j vB wB xB yB TB dB zB UB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"2":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Element.closest()"};

  var elementFromPoint={A:{A:{"1":"I D E F A B","16":"fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","16":"gB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","16":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB TB dB zB UB","16":"F vB wB xB yB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB"},H:{"1":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"C Q UB","16":"A B TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"document.elementFromPoint()"};

  var elementScrollMethods={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r iB jB"},D:{"1":"XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB"},E:{"1":"K tB uB","2":"H a I D E F nB bB oB pB qB rB","132":"A B C J cB TB UB sB"},F:{"1":"4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"1":"IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B","132":"7B 8B 9B AC BC CC DC EC FC GC HC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"UC VC cB WC XC YC ZC","2":"H RC SC TC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:5,C:"Scroll methods on elements (scroll, scrollTo, scrollBy)"};

  var eme={A:{A:{"2":"I D E F A fB","164":"B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q","132":"r s t u v w x"},E:{"1":"C J K UB sB tB uB","2":"H a I nB bB oB pB","164":"D E F A B qB rB cB TB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d vB wB xB yB TB dB zB UB","132":"e f g h i j k"},G:{"1":"AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"16":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:2,C:"Encrypted Media Extensions"};

  var eot={A:{A:{"1":"I D E F A B","2":"fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"EOT - Embedded OpenType fonts"};

  var es5={A:{A:{"1":"A B","2":"I D fB","260":"F","1026":"E"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","4":"gB VB iB jB","132":"H a I D E F A B C J K L M N O b c"},D:{"1":"0 1 2 3 4 5 6 7 8 9 f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","4":"H a I D E F A B C J K L M N O","132":"b c d e"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","4":"H a nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","4":"F B C vB wB xB yB TB dB zB","132":"UB"},G:{"1":"E 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","4":"bB 0B eB 1B"},H:{"132":"JC"},I:{"1":"G OC PC","4":"VB KC LC MC","132":"NC eB","900":"H"},J:{"1":"A","4":"D"},K:{"1":"Q","4":"A B C TB dB","132":"UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"ECMAScript 5"};

  var es6Class={A:{A:{"2":"I D E F A B fB"},B:{"1":"J K L M N O R S T U V W X P Y Z G","2":"C"},C:{"1":"1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x","132":"0 1 2 3 4 y z"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"H a I D E nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k vB wB xB yB TB dB zB UB","132":"l m n o p q r"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"ES6 classes"};

  var es6Generators={A:{A:{"2":"I D E F A B fB"},B:{"1":"J K L M N O R S T U V W X P Y Z G","2":"C"},C:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h vB wB xB yB TB dB zB UB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"ES6 Generators"};

  var es6ModuleDynamicImport={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB iB jB","194":"JB"},D:{"1":"GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q"},E:{"1":"C J K TB UB sB tB uB","2":"H a I D E F A B nB bB oB pB qB rB cB"},F:{"1":"6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"UC VC cB WC XC YC ZC","2":"H RC SC TC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"JavaScript modules: dynamic import()"};

  var es6Module={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K","4097":"M N O","4290":"L"},C:{"1":"FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","322":"AB BB CB DB EB WB"},D:{"1":"XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB","194":"FB"},E:{"1":"B C J K TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB","3076":"cB"},F:{"1":"4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB","194":"3"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B","3076":"8B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"UC VC cB WC XC YC ZC","2":"H RC SC TC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:1,C:"JavaScript modules via script tag"};

  var es6Number={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L iB jB","132":"M N O b c d e f g","260":"h i j k l m","516":"n"},D:{"1":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O","1028":"b c d e f g h i j k l m n o p"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"H a I D E nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB","1028":"L M N O b c"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC","1028":"NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"ES6 Number"};

  var es6StringIncludes={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"H a I D E nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j vB wB xB yB TB dB zB UB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"String.prototype.includes"};

  var es6={A:{A:{"2":"I D E F A fB","388":"B"},B:{"257":"R S T U V W X P Y Z G","260":"C J K","769":"L M N O"},C:{"2":"gB VB H a iB jB","4":"0 1 2 3 4 5 6 7 8 9 I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","257":"AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"2":"H a I D E F A B C J K L M N O b c","4":"0 1 2 3 4 5 6 d e f g h i j k l m n o p q r s t u v w x y z","257":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D nB bB oB pB","4":"E F qB rB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","4":"L M N O b c d e f g h i j k l m n o p q r s t","257":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B","4":"E 3B 4B 5B 6B"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB","4":"OC PC","257":"G"},J:{"2":"D","4":"A"},K:{"2":"A B C TB dB UB","257":"Q"},L:{"257":"G"},M:{"257":"P"},N:{"2":"A","388":"B"},O:{"257":"QC"},P:{"4":"H","257":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"257":"aC"},R:{"4":"bC"},S:{"4":"cC"}},B:6,C:"ECMAScript 2015 (ES6)"};

  var eventsource={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB TB dB zB UB","4":"F vB wB xB yB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"D A"},K:{"1":"C Q TB dB UB","4":"A B"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Server-sent events"};

  var extendedSystemFonts={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"K sB tB uB","2":"H a I D E F A B C J nB bB oB pB qB rB cB TB UB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"ui-serif, ui-sans-serif, ui-monospace and ui-rounded values for font-family"};

  var featurePolicy={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P","2":"C J K L M N O","1025":"Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB iB jB","260":"RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"RB SB YB ZB aB R S T U V W X P","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB","132":"FB XB Q GB HB IB JB KB LB MB NB OB PB QB","1025":"Y Z G kB lB mB"},E:{"2":"H a I D E F A B nB bB oB pB qB rB cB","772":"C J K TB UB sB tB uB"},F:{"1":"Q GB HB IB JB KB LB MB NB OB PB QB RB","2":"0 1 2 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB","132":"3 4 5 6 7 8 9 AB BB CB DB EB FB","1025":"SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B","772":"AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1025":"G"},M:{"260":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"WC XC YC ZC","2":"H RC SC TC","132":"UC VC cB"},Q:{"132":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"Feature Policy"};

  var fetch={A:{A:{"2":"I D E F A B fB"},B:{"1":"K L M N O R S T U V W X P Y Z G","2":"C J"},C:{"1":"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p iB jB","1025":"v","1218":"q r s t u"},D:{"1":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v","260":"w","772":"x"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i vB wB xB yB TB dB zB UB","260":"j","772":"k"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Fetch"};

  var fieldsetDisabled={A:{A:{"16":"fB","132":"E F","388":"I D A B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L","16":"M N O b"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB wB xB yB TB dB zB UB","16":"F vB"},G:{"1":"E 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B"},H:{"388":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"A","2":"D"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A","260":"B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"disabled attribute of the fieldset element"};

  var fileapi={A:{A:{"2":"I D E F fB","260":"A B"},B:{"1":"R S T U V W X P Y Z G","260":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB","260":"H a I D E F A B C J K L M N O b c d e f g h i j jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a","260":"J K L M N O b c d e f g h i j k l m n o p q r s t","388":"I D E F A B C"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a nB bB","260":"I D E F pB qB rB","388":"oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B vB wB xB yB","260":"C L M N O b c d e f g TB dB zB UB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B","260":"E 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"1":"G PC","2":"KC LC MC","260":"OC","388":"VB H NC eB"},J:{"260":"A","388":"D"},K:{"1":"Q","2":"A B","260":"C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A","260":"B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"File API"};

  var filereader={A:{A:{"2":"I D E F fB","132":"A B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G jB","2":"gB VB iB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB TB dB zB UB","2":"F B vB wB xB yB"},G:{"1":"E 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B"},H:{"2":"JC"},I:{"1":"VB H G NC eB OC PC","2":"KC LC MC"},J:{"1":"A","2":"D"},K:{"1":"C Q TB dB UB","2":"A B"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"FileReader API"};

  var filereadersync={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB","2":"F vB wB","16":"B xB yB TB dB"},G:{"1":"E 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"A","2":"D"},K:{"1":"C Q dB UB","2":"A","16":"B TB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"FileReaderSync"};

  var filesystem={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","33":"R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"H a I D","33":"0 1 2 3 4 5 6 7 8 9 J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","36":"E F A B C"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","33":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D","33":"A"},K:{"2":"A B C TB dB UB","33":"Q"},L:{"33":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H","33":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Filesystem & FileWriter API"};

  var flac={A:{A:{"2":"I D E F A B fB"},B:{"1":"M N O R S T U V W X P Y Z G","2":"C J K L"},C:{"1":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","16":"0 1 2","388":"3 4 5 6 7 8 9 AB BB"},E:{"1":"J K sB tB uB","2":"H a I D E F A nB bB oB pB qB rB cB","516":"B C TB UB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x vB wB xB yB TB dB zB UB"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B"},H:{"2":"JC"},I:{"1":"G","2":"KC LC MC","16":"VB H NC eB OC PC"},J:{"1":"A","2":"D"},K:{"1":"UB","16":"A B C TB dB","129":"Q"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","129":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:6,C:"FLAC audio format"};

  var flexboxGap={A:{A:{"2":"I D E F A B fB"},B:{"1":"V W X P Y Z G","2":"C J K L M N O R S T U"},C:{"1":"GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q iB jB"},D:{"1":"V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U"},E:{"1":"tB uB","2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB"},F:{"1":"QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB vB wB xB yB TB dB zB UB"},G:{"1":"IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"ZC","2":"H RC SC TC UC VC cB WC XC YC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"gap property for Flexbox"};

  var flexbox={A:{A:{"2":"I D E F fB","1028":"B","1316":"A"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","164":"gB VB H a I D E F A B C J K L M N O b c d iB jB","516":"e f g h i j"},D:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","33":"d e f g h i j k","164":"H a I D E F A B C J K L M N O b c"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","33":"D E pB qB","164":"H a I nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B C vB wB xB yB TB dB zB","33":"L M"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","33":"E 3B 4B","164":"bB 0B eB 1B 2B"},H:{"1":"JC"},I:{"1":"G OC PC","164":"VB H KC LC MC NC eB"},J:{"1":"A","164":"D"},K:{"1":"Q UB","2":"A B C TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","292":"A"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS Flexible Box Layout Module"};

  var flowRoot={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB"},E:{"1":"J K sB tB uB","2":"H a I D E F A B C nB bB oB pB qB rB cB TB UB"},F:{"1":"1 2 3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"1":"DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"TC UC VC cB WC XC YC ZC","2":"H RC SC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"display: flow-root"};

  var focusinFocusoutEvents={A:{A:{"1":"I D E F A B","2":"fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","16":"H a nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB","2":"F vB wB xB yB","16":"B TB dB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB"},H:{"2":"JC"},I:{"1":"H G NC eB OC PC","2":"KC LC MC","16":"VB"},J:{"1":"D A"},K:{"1":"C Q UB","2":"A","16":"B TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:5,C:"focusin & focusout events"};

  var focusoptionsPreventscroll={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M","132":"N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:1,C:"preventScroll support in focus"};

  var fontFamilySystemUi={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y iB jB","132":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","260":"9 AB BB"},E:{"1":"B C J K TB UB sB tB uB","2":"H a I D E nB bB oB pB qB","16":"F","132":"A rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y vB wB xB yB TB dB zB UB"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B","132":"5B 6B 7B 8B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","2":"H RC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"132":"cC"}},B:5,C:"system-ui value for font-family"};

  var fontFeature={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB","33":"L M N O b c d e f g h i j k l m n o p","164":"H a I D E F A B C J K"},D:{"1":"4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L","33":"0 1 2 3 d e f g h i j k l m n o p q r s t u v w x y z","292":"M N O b c"},E:{"1":"A B C J K rB cB TB UB sB tB uB","2":"D E F nB bB pB qB","4":"H a I oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB","33":"L M N O b c d e f g h i j k l m n o p q"},G:{"1":"6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E 3B 4B 5B","4":"bB 0B eB 1B 2B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB","33":"OC PC"},J:{"2":"D","33":"A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","33":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS font-feature-settings"};

  var fontKerning={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f iB jB","194":"g h i j k l m n o p"},D:{"1":"0 1 2 3 4 5 6 7 8 9 p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k","33":"l m n o"},E:{"1":"A B C J K rB cB TB UB sB tB uB","2":"H a I nB bB oB pB","33":"D E F qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L vB wB xB yB TB dB zB UB","33":"M N O b"},G:{"1":"BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B 3B","33":"E 4B 5B 6B 7B 8B 9B AC"},H:{"2":"JC"},I:{"1":"G PC","2":"VB H KC LC MC NC eB","33":"OC"},J:{"2":"D","33":"A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS3 font-kerning"};

  var fontLoading={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q iB jB","194":"r s t u v w"},D:{"1":"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d vB wB xB yB TB dB zB UB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"CSS Font Loading"};

  var fontMetricsOverrides={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W","194":"X"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"@font-face metrics overrides"};

  var fontSizeAdjust={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","194":"R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB"},D:{"2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y","194":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C L M N O b c d e f g h i j k l vB wB xB yB TB dB zB UB","194":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"258":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"194":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:4,C:"CSS font-size-adjust"};

  var fontSmooth={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","676":"R S T U V W X P Y Z G"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e f g iB jB","804":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"2":"H","676":"0 1 2 3 4 5 6 7 8 9 a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"nB bB","676":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","676":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"804":"cC"}},B:7,C:"CSS font-smooth"};

  var fontUnicodeRange={A:{A:{"2":"I D E fB","4":"F A B"},B:{"1":"N O R S T U V W X P Y Z G","4":"C J K L M"},C:{"1":"0 1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r iB jB","194":"s t u v w x y z"},D:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","4":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r"},E:{"1":"A B C J K cB TB UB sB tB uB","4":"H a I D E F nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB","4":"L M N O b c d e"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","4":"E bB 0B eB 1B 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"1":"G","4":"VB H KC LC MC NC eB OC PC"},J:{"2":"D","4":"A"},K:{"2":"A B C TB dB UB","4":"Q"},L:{"1":"G"},M:{"1":"P"},N:{"4":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","4":"H"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:4,C:"Font unicode-range subsetting"};

  var fontVariantAlternates={A:{A:{"2":"I D E F fB","130":"A B"},B:{"130":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB","130":"H a I D E F A B C J K L M N O b c d e f","322":"g h i j k l m n o p"},D:{"2":"H a I D E F A B C J K L","130":"0 1 2 3 4 5 6 7 8 9 M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"A B C J K rB cB TB UB sB tB uB","2":"D E F nB bB pB qB","130":"H a I oB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","130":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"1":"6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 3B 4B 5B","130":"0B eB 1B 2B"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB","130":"G OC PC"},J:{"2":"D","130":"A"},K:{"2":"A B C TB dB UB","130":"Q"},L:{"130":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"130":"QC"},P:{"130":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"130":"aC"},R:{"130":"bC"},S:{"1":"cC"}},B:5,C:"CSS font-variant-alternates"};

  var fontVariantEastAsian={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f iB jB","132":"g h i j k l m n o p"},D:{"1":"GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"2":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"132":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:4,C:"CSS font-variant-east-asian "};

  var fontVariantNumeric={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p iB jB"},D:{"1":"8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"A B C J K rB cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u vB wB xB yB TB dB zB UB"},G:{"1":"6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D","16":"A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","2":"H RC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:2,C:"CSS font-variant-numeric"};

  var fontface={A:{A:{"1":"F A B","132":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB VB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K bB oB pB qB rB cB TB UB sB tB uB","2":"nB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB wB xB yB TB dB zB UB","2":"F vB"},G:{"1":"E eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","260":"bB 0B"},H:{"2":"JC"},I:{"1":"H G NC eB OC PC","2":"KC","4":"VB LC MC"},J:{"1":"A","4":"D"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"@font-face Web fonts"};

  var formAttribute={A:{A:{"2":"I D E F A B fB"},B:{"1":"M N O R S T U V W X P Y Z G","2":"C J K L"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB","16":"a"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","2":"F"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB"},H:{"1":"JC"},I:{"1":"VB H G NC eB OC PC","2":"KC LC MC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Form attribute"};

  var formSubmitAttributes={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H a nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB yB TB dB zB UB","2":"F vB","16":"wB xB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB"},H:{"1":"JC"},I:{"1":"H G NC eB OC PC","2":"KC LC MC","16":"VB"},J:{"1":"A","2":"D"},K:{"1":"B C Q TB dB UB","16":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Attributes for form submission"};

  var formValidation={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H nB bB","132":"a I D E F A oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB wB xB yB TB dB zB UB","2":"F vB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"bB","132":"E 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"516":"JC"},I:{"1":"G PC","2":"VB KC LC MC","132":"H NC eB OC"},J:{"1":"A","132":"D"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"260":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"132":"cC"}},B:1,C:"Form validation"};

  var forms={A:{A:{"2":"fB","4":"A B","8":"I D E F"},B:{"1":"M N O R S T U V W X P Y Z G","4":"C J K L"},C:{"4":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","8":"gB VB iB jB"},D:{"1":"XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","4":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB"},E:{"4":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","8":"nB bB"},F:{"1":"8 9 F B C AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","4":"0 1 2 3 4 5 6 7 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},G:{"2":"bB","4":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB","4":"OC PC"},J:{"2":"D","4":"A"},K:{"1":"A B C TB dB UB","4":"Q"},L:{"1":"G"},M:{"4":"P"},N:{"4":"A B"},O:{"1":"QC"},P:{"1":"UC VC cB WC XC YC ZC","4":"H RC SC TC"},Q:{"1":"aC"},R:{"4":"bC"},S:{"4":"cC"}},B:1,C:"HTML5 form features"};

  var fullscreen={A:{A:{"2":"I D E F A fB","548":"B"},B:{"1":"R S T U V W X P Y Z G","516":"C J K L M N O"},C:{"1":"HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F iB jB","676":"0 1 2 A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","1700":"3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB"},D:{"1":"OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K","676":"L M N O b","804":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB"},E:{"2":"H a nB bB","676":"oB","804":"I D E F A B C J K pB qB rB cB TB UB sB tB uB"},F:{"1":"HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B C vB wB xB yB TB dB zB","804":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC","2052":"BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D","292":"A"},K:{"2":"A B C TB dB UB","804":"Q"},L:{"804":"G"},M:{"1":"P"},N:{"2":"A","548":"B"},O:{"804":"QC"},P:{"1":"cB WC XC YC ZC","804":"H RC SC TC UC VC"},Q:{"804":"aC"},R:{"804":"bC"},S:{"1":"cC"}},B:1,C:"Full Screen API"};

  var gamepad={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c","33":"d e f g"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f vB wB xB yB TB dB zB UB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:5,C:"Gamepad API"};

  var geolocation={A:{A:{"1":"F A B","2":"fB","8":"I D E"},B:{"1":"C J K L M N O","129":"R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB iB jB","8":"gB VB","129":"BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"0 1 2 3 4 5 a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","4":"H","129":"6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"a I D E F B C J K oB pB qB rB cB TB UB sB tB uB","8":"H nB bB","129":"A"},F:{"1":"B C M N O b c d e f g h i j k l m n o p q r s t u yB TB dB zB UB","2":"F L vB","8":"wB xB","129":"0 1 2 3 4 5 6 7 8 9 v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B","129":"7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H KC LC MC NC eB OC PC","129":"G"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","8":"A"},L:{"129":"G"},M:{"129":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H","129":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"129":"aC"},R:{"129":"bC"},S:{"1":"cC"}},B:2,C:"Geolocation"};

  var getboundingclientrect={A:{A:{"644":"I D fB","2049":"F A B","2692":"E"},B:{"1":"R S T U V W X P Y Z G","2049":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB","260":"H a I D E F A B","1156":"VB","1284":"iB","1796":"jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","16":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB yB TB dB zB UB","16":"F vB","132":"wB xB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB"},H:{"1":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","132":"A"},L:{"1":"G"},M:{"1":"P"},N:{"2049":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"Element.getBoundingClientRect()"};

  var getcomputedstyle={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB","132":"VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","260":"H a I D E F A"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","260":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB yB TB dB zB UB","260":"F vB wB xB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","260":"bB 0B eB"},H:{"260":"JC"},I:{"1":"H G NC eB OC PC","260":"VB KC LC MC"},J:{"1":"A","260":"D"},K:{"1":"B C Q TB dB UB","260":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"getComputedStyle"};

  var getelementsbyclassname={A:{A:{"1":"F A B","2":"fB","8":"I D E"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","8":"gB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","2":"F"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"getElementsByClassName"};

  var getrandomvalues={A:{A:{"2":"I D E F A fB","33":"B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a I nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"A","2":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A","33":"B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"crypto.getRandomValues()"};

  var gyroscope={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB","194":"EB WB FB XB Q GB HB IB JB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:4,C:"Gyroscope"};

  var hardwareconcurrency={A:{A:{"2":"I D E F A B fB"},B:{"1":"L M N O R S T U V W X P Y Z G","2":"C J K"},C:{"1":"4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s"},E:{"2":"H a I D nB bB oB pB qB","129":"B C J K cB TB UB sB tB uB","194":"E F A rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f vB wB xB yB TB dB zB UB"},G:{"2":"bB 0B eB 1B 2B 3B","129":"8B 9B AC BC CC DC EC FC GC HC IC","194":"E 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"navigator.hardwareConcurrency"};

  var hashchange={A:{A:{"1":"E F A B","8":"I D fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G jB","8":"gB VB iB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","8":"H"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","8":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB yB TB dB zB UB","8":"F vB wB xB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB"},H:{"2":"JC"},I:{"1":"VB H G LC MC NC eB OC PC","2":"KC"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","8":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Hashchange event"};

  var heif={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A nB bB oB pB qB rB cB","130":"B C J K TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B","130":"9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"HEIF/ISO Base Media File Format"};

  var hevc={A:{A:{"2":"I D E F A fB","132":"B"},B:{"2":"R S T U V W X P Y Z G","132":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"J K sB tB uB","2":"H a I D E F A nB bB oB pB qB rB cB","516":"B C TB UB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB OC PC","258":"G"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"258":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H","258":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"HEVC/H.265 video format"};

  var hidden={A:{A:{"1":"B","2":"I D E F A fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H a nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB TB dB zB UB","2":"F B vB wB xB yB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB"},H:{"1":"JC"},I:{"1":"H G NC eB OC PC","2":"VB KC LC MC"},J:{"1":"A","2":"D"},K:{"1":"C Q TB dB UB","2":"A B"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","2":"A"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"hidden attribute"};

  var highResolutionTime={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b","33":"c d e f"},E:{"1":"E F A B C J K rB cB TB UB sB tB uB","2":"H a I D nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"A","2":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"High Resolution Time API"};

  var history={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H nB bB","4":"a oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB dB zB UB","2":"F B vB wB xB yB TB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B","4":"eB"},H:{"2":"JC"},I:{"1":"G LC MC eB OC PC","2":"VB H KC NC"},J:{"1":"D A"},K:{"1":"C Q TB dB UB","2":"A B"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Session history management"};

  var htmlMediaCapture={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"bB 0B eB 1B","129":"E 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H G NC eB OC PC","2":"KC","257":"LC MC"},J:{"1":"A","16":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"516":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"16":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:4,C:"HTML Media Capture"};

  var html5semantic={A:{A:{"2":"fB","8":"I D E","260":"F A B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB","132":"VB iB jB","260":"H a I D E F A B C J K L M N O b c"},D:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","132":"H a","260":"I D E F A B C J K L M N O b c d e f g h"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","132":"H nB bB","260":"a I oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","132":"F B vB wB xB yB","260":"C TB dB zB UB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","132":"bB","260":"0B eB 1B 2B"},H:{"132":"JC"},I:{"1":"G OC PC","132":"KC","260":"VB H LC MC NC eB"},J:{"260":"D A"},K:{"1":"Q","132":"A","260":"B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"260":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"HTML5 semantic elements"};

  var httpLiveStreaming={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O","2":"R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H G NC eB OC PC","2":"KC LC MC"},J:{"1":"A","2":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:7,C:"HTTP Live Streaming (HLS)"};

  var http2={A:{A:{"2":"I D E F A fB","132":"B"},B:{"1":"C J K L M N O","513":"R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 s t u v w x y z","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r iB jB","513":"9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"0 1 2 3 4 5 6 x y z","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w","513":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"B C J K TB UB sB tB uB","2":"H a I D E nB bB oB pB qB","260":"F A rB cB"},F:{"1":"k l m n o p q r s t","2":"F B C L M N O b c d e f g h i j vB wB xB yB TB dB zB UB","513":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB OC PC","513":"G"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"513":"G"},M:{"513":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H","513":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"513":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"HTTP/2 protocol"};

  var http3={A:{A:{"2":"I D E F A B fB"},B:{"1":"P Y Z G","2":"C J K L M N O","322":"R S T U V","578":"W X"},C:{"1":"Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB iB jB","194":"PB QB RB SB YB ZB aB R S T hB U V W X P"},D:{"1":"P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB","322":"R S T U V","578":"W X"},E:{"2":"H a I D E F A B C J nB bB oB pB qB rB cB TB UB sB","1090":"K tB uB"},F:{"1":"RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB vB wB xB yB TB dB zB UB","578":"QB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC","66":"HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"194":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"ZC","2":"H RC SC TC UC VC cB WC XC YC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"HTTP/3 protocol"};

  var iframeSandbox={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M iB jB","4":"N O b c d e f g h i j"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B"},H:{"2":"JC"},I:{"1":"VB H G LC MC NC eB OC PC","2":"KC"},J:{"1":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"sandbox attribute for iframes"};

  var iframeSeamless={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","66":"c d e f g h i"},E:{"2":"H a I E F A B C J K nB bB oB pB rB cB TB UB sB tB uB","130":"D qB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","130":"3B"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"seamless attribute for iframes"};

  var iframeSrcdoc={A:{A:{"2":"fB","8":"I D E F A B"},B:{"1":"R S T U V W X P Y Z G","8":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB","8":"VB H a I D E F A B C J K L M N O b c d e f g iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J","8":"K L M N O b"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"nB bB","8":"H a oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B vB wB xB yB","8":"C TB dB zB UB"},G:{"1":"E 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB","8":"0B eB 1B"},H:{"2":"JC"},I:{"1":"G OC PC","8":"VB H KC LC MC NC eB"},J:{"1":"A","8":"D"},K:{"1":"Q","2":"A B","8":"C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"8":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"srcdoc attribute for iframes"};

  var imagecapture={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","322":"R S T U V W X P Y Z G"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q iB jB","194":"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"2":"0 1 2 3 4 5 6 7 8 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","322":"9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v vB wB xB yB TB dB zB UB","322":"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"322":"aC"},R:{"1":"bC"},S:{"194":"cC"}},B:5,C:"ImageCapture API"};

  var ime={A:{A:{"2":"I D E F A fB","161":"B"},B:{"2":"R S T U V W X P Y Z G","161":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A","161":"B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"Input Method Editor API"};

  var imgNaturalwidthNaturalheight={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"naturalWidth & naturalHeight image properties"};

  var importMaps={A:{A:{"2":"I D E F A B fB"},B:{"1":"Z G","2":"C J K L M N O","194":"R S T U V W X P Y"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB","194":"RB SB YB ZB aB R S T U V W X P Y"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB vB wB xB yB TB dB zB UB","194":"Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Import maps"};

  var imports={A:{A:{"2":"I D E F fB","8":"A B"},B:{"1":"R","2":"S T U V W X P Y Z G","8":"C J K L M N O"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l iB jB","8":"m n CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","72":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l S T U V W X P Y Z G kB lB mB","66":"m n o p q","72":"r"},E:{"2":"H a nB bB oB","8":"I D E F A B C J K pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB","2":"F B C L M KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","66":"N O b c d","72":"e"},G:{"2":"bB 0B eB 1B 2B","8":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"2":"G"},M:{"8":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC","2":"YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"HTML Imports"};

  var indeterminateCheckbox={A:{A:{"1":"I D E F A B","16":"fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G jB","2":"gB VB","16":"iB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB","2":"F B vB wB xB yB TB dB"},G:{"1":"CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"2":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"indeterminate checkbox"};

  var indexeddb={A:{A:{"2":"I D E F fB","132":"A B"},B:{"1":"R S T U V W X P Y Z G","132":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB","33":"A B C J K L","36":"H a I D E F"},D:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"A","8":"H a I D E F","33":"f","36":"B C J K L M N O b c d e"},E:{"1":"A B C J K cB TB UB sB tB uB","8":"H a I D nB bB oB pB","260":"E F qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F vB wB","8":"B C xB yB TB dB zB UB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","8":"bB 0B eB 1B 2B 3B","260":"E 4B 5B 6B"},H:{"2":"JC"},I:{"1":"G OC PC","8":"VB H KC LC MC NC eB"},J:{"1":"A","8":"D"},K:{"1":"Q","2":"A","8":"B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"132":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"IndexedDB"};

  var indexeddb2={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","132":"0 1 2","260":"3 4 5 6"},D:{"1":"EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","132":"4 5 6 7","260":"8 9 AB BB CB DB"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"1 2 3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q vB wB xB yB TB dB zB UB","132":"r s t u","260":"0 v w x y z"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B","16":"7B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"TC UC VC cB WC XC YC ZC","2":"H","260":"RC SC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"260":"cC"}},B:4,C:"IndexedDB 2.0"};

  var inlineBlock={A:{A:{"1":"E F A B","4":"fB","132":"I D"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","36":"gB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"CSS inline-block"};

  var innertext={A:{A:{"1":"I D E F A B","16":"fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K bB oB pB qB rB cB TB UB sB tB uB","16":"nB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","16":"F"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB"},H:{"1":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"HTMLElement.innerText"};

  var inputAutocompleteOnoff={A:{A:{"1":"I D E F A fB","132":"B"},B:{"132":"C J K L M N O","260":"R S T U V W X P Y Z G"},C:{"1":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l iB jB","516":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"N O b c d e f g h i","2":"H a I D E F A B C J K L M","132":"j k l m n o p q r s t u v w","260":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"I oB pB","2":"H a nB bB","2052":"D E F A B C J K qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"bB 0B eB","1025":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1025":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2052":"A B"},O:{"1025":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"260":"aC"},R:{"1":"bC"},S:{"516":"cC"}},B:1,C:"autocomplete attribute: on & off values"};

  var inputColor={A:{A:{"2":"I D E F A B fB"},B:{"1":"K L M N O R S T U V W X P Y Z G","2":"C J"},C:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b"},E:{"1":"J K UB sB tB uB","2":"H a I D E F A B C nB bB oB pB qB rB cB TB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB TB dB zB UB","2":"F L M vB wB xB yB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC","129":"CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:1,C:"Color input type"};

  var inputDatetime={A:{A:{"2":"I D E F A B fB"},B:{"1":"J K L M N O R S T U V W X P Y Z G","132":"C"},C:{"2":"0 1 2 3 4 5 6 7 8 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","1090":"9 AB BB CB","2052":"DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b","2052":"c d e f g"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB","4100":"tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"bB 0B eB","260":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB KC LC MC","514":"H NC eB"},J:{"1":"A","2":"D"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2052":"cC"}},B:1,C:"Date and time input types"};

  var inputEmailTelUrl={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","2":"F"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H G NC eB OC PC","132":"KC LC MC"},J:{"1":"A","132":"D"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Email, telephone & URL input types"};

  var inputEvent={A:{A:{"2":"I D E fB","2561":"A B","2692":"F"},B:{"1":"R S T U V W X P Y Z G","2561":"C J K L M N O"},C:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","16":"gB","1537":"0 1 2 3 4 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z jB","1796":"VB iB"},D:{"1":"JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K","1025":"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB","1537":"L M N O b c d e f g h i j k l m n o p q"},E:{"1":"K sB tB uB","16":"H a I nB bB","1025":"D E F A B C pB qB rB cB TB","1537":"oB","4097":"J UB"},F:{"1":"8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","16":"F B C vB wB xB yB TB dB","260":"zB","1025":"0 1 2 3 4 5 6 7 e f g h i j k l m n o p q r s t u v w x y z","1537":"L M N O b c d"},G:{"16":"bB 0B eB","1025":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","1537":"1B 2B 3B"},H:{"2":"JC"},I:{"16":"KC LC","1025":"G PC","1537":"VB H MC NC eB OC"},J:{"1025":"A","1537":"D"},K:{"1":"A B C TB dB UB","1025":"Q"},L:{"1":"G"},M:{"1537":"P"},N:{"2561":"A B"},O:{"1537":"QC"},P:{"1025":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1025":"aC"},R:{"1025":"bC"},S:{"1537":"cC"}},B:1,C:"input event"};

  var inputFileAccept={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB","132":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s"},D:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H","16":"a I D E d e f g h","132":"F A B C J K L M N O b c"},E:{"1":"C J K TB UB sB tB uB","2":"H a nB bB oB","132":"I D E F A B pB qB rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"2":"2B 3B","132":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","514":"bB 0B eB 1B"},H:{"2":"JC"},I:{"2":"KC LC MC","260":"VB H NC eB","514":"G OC PC"},J:{"132":"A","260":"D"},K:{"2":"A B C TB dB UB","260":"Q"},L:{"260":"G"},M:{"2":"P"},N:{"514":"A","1028":"B"},O:{"2":"QC"},P:{"260":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"260":"aC"},R:{"260":"bC"},S:{"1":"cC"}},B:1,C:"accept attribute for file input"};

  var inputFileDirectory={A:{A:{"2":"I D E F A B fB"},B:{"1":"K L M N O R S T U V W X P Y Z G","2":"C J"},C:{"1":"6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l"},E:{"1":"C J K TB UB sB tB uB","2":"H a I D E F A B nB bB oB pB qB rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Directory selection from file input"};

  var inputFileMultiple={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G jB","2":"gB VB iB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB yB TB dB zB UB","2":"F vB wB xB"},G:{"1":"E 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B"},H:{"130":"JC"},I:{"130":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"130":"A B C Q TB dB UB"},L:{"132":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"130":"QC"},P:{"130":"H","132":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"132":"aC"},R:{"132":"bC"},S:{"2":"cC"}},B:1,C:"Multiple file selection"};

  var inputInputmode={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"gB VB H a I D E F A B C J K L M iB jB","4":"N O b c","194":"0 1 2 3 4 5 6 7 8 9 d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB","66":"CB DB EB WB FB XB Q GB HB IB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y vB wB xB yB TB dB zB UB","66":"0 1 2 3 4 5 6 7 8 z"},G:{"1":"CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"VC cB WC XC YC ZC","2":"H RC SC TC UC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"194":"cC"}},B:1,C:"inputmode attribute"};

  var inputMinlength={A:{A:{"2":"I D E F A B fB"},B:{"1":"N O R S T U V W X P Y Z G","2":"C J K L M"},C:{"1":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i vB wB xB yB TB dB zB UB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:1,C:"Minimum length attribute for input fields"};

  var inputNumber={A:{A:{"2":"I D E F fB","129":"A B"},B:{"1":"R S T U V W X P Y Z G","129":"C J","1025":"K L M N O"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k iB jB","513":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"0 1 2 3 4 5 6 7 8 9 I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"388":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB KC LC MC","388":"H G NC eB OC PC"},J:{"2":"D","388":"A"},K:{"1":"A B C TB dB UB","388":"Q"},L:{"388":"G"},M:{"641":"P"},N:{"388":"A B"},O:{"388":"QC"},P:{"388":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"388":"aC"},R:{"388":"bC"},S:{"513":"cC"}},B:1,C:"Number input type"};

  var inputPattern={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H nB bB","16":"a","388":"I D E F A oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","2":"F"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB","388":"E 1B 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G PC","2":"VB H KC LC MC NC eB OC"},J:{"1":"A","2":"D"},K:{"1":"A B C TB dB UB","132":"Q"},L:{"1":"G"},M:{"1":"P"},N:{"132":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Pattern attribute for input fields"};

  var inputPlaceholder={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","132":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB dB zB UB","2":"F vB wB xB yB","132":"B TB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB G KC LC MC eB OC PC","4":"H NC"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"input placeholder attribute"};

  var inputRange={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB"},H:{"2":"JC"},I:{"1":"G eB OC PC","4":"VB H KC LC MC NC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Range input type"};

  var inputSearch={A:{A:{"2":"I D E F fB","129":"A B"},B:{"1":"R S T U V W X P Y Z G","129":"C J K L M N O"},C:{"2":"gB VB iB jB","129":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K d e f g h","129":"L M N O b c"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","16":"H a nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB","2":"F vB wB xB yB","16":"B TB dB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB"},H:{"129":"JC"},I:{"1":"G OC PC","16":"KC LC","129":"VB H MC NC eB"},J:{"1":"D","129":"A"},K:{"1":"C","2":"A","16":"B TB dB","129":"Q UB"},L:{"1":"G"},M:{"129":"P"},N:{"129":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"129":"cC"}},B:1,C:"Search input type"};

  var inputSelection={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","16":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB yB TB dB zB UB","16":"F vB wB xB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB"},H:{"2":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Selection controls for input & textarea"};

  var insertAdjacent={A:{A:{"1":"I D E F A B","16":"fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","16":"F"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Element.insertAdjacentElement() & Element.insertAdjacentText()"};

  var insertadjacenthtml={A:{A:{"1":"A B","16":"fB","132":"I D E F"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB wB xB yB TB dB zB UB","16":"F vB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB"},H:{"1":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"Element.insertAdjacentHTML()"};

  var internationalization={A:{A:{"1":"B","2":"I D E F A fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","2":"A"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:6,C:"Internationalization API"};

  var intersectionobserverV2={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"WC XC YC ZC","2":"H RC SC TC UC VC cB"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"IntersectionObserver V2"};

  var intersectionobserver={A:{A:{"2":"I D E F A B fB"},B:{"1":"M N O","2":"C J K","516":"L","1025":"R S T U V W X P Y Z G"},C:{"1":"BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","194":"8 9 AB"},D:{"1":"EB WB FB XB Q GB HB","2":"0 1 2 3 4 5 6 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","516":"7 8 9 AB BB CB DB","1025":"IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"J K UB sB tB uB","2":"H a I D E F A B C nB bB oB pB qB rB cB TB"},F:{"1":"1 2 3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t vB wB xB yB TB dB zB UB","516":"0 u v w x y z","1025":"HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"1":"CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB OC PC","1025":"G"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"516":"QC"},P:{"1":"TC UC VC cB WC XC YC ZC","2":"H","516":"RC SC"},Q:{"1025":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"IntersectionObserver"};

  var intlPluralrules={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N","130":"O"},C:{"1":"EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB iB jB"},D:{"1":"GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q"},E:{"1":"J K sB tB uB","2":"H a I D E F A B C nB bB oB pB qB rB cB TB UB"},F:{"1":"6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"1":"DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"UC VC cB WC XC YC ZC","2":"H RC SC TC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"Intl.PluralRules API"};

  var intrinsicWidth={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","1537":"R S T U V W X P Y Z G"},C:{"2":"gB","932":"0 1 2 3 4 5 6 7 8 9 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB iB jB","2308":"JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"2":"H a I D E F A B C J K L M N O b c d","545":"0 1 e f g h i j k l m n o p q r s t u v w x y z","1537":"2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I nB bB oB","516":"B C J K TB UB sB tB uB","548":"F A rB cB","676":"D E pB qB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","513":"q","545":"L M N O b c d e f g h i j k l m n o","1537":"0 1 2 3 4 5 6 7 8 9 p r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"bB 0B eB 1B 2B","516":"HC IC","548":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC","676":"E 3B 4B"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB","545":"OC PC","1537":"G"},J:{"2":"D","545":"A"},K:{"2":"A B C TB dB UB","1537":"Q"},L:{"1537":"G"},M:{"2308":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"545":"H","1537":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"545":"aC"},R:{"1537":"bC"},S:{"932":"cC"}},B:5,C:"Intrinsic & Extrinsic Sizing"};

  var jpeg2000={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H nB bB","129":"a oB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"JPEG 2000 image format"};

  var jpegxl={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z iB jB","322":"G"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G","194":"kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"JPEG XL image format"};

  var jpegxr={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O","2":"R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"1":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"JPEG XR image format"};

  var jsRegexpLookbehind={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB iB jB"},D:{"1":"Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"UC VC cB WC XC YC ZC","2":"H RC SC TC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"Lookbehind in JS regular expressions"};

  var json={A:{A:{"1":"F A B","2":"I D fB","129":"E"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB VB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","2":"F vB wB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"JSON parsing"};

  var justifyContentSpaceEvenly={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L","132":"M N O"},C:{"1":"8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB","132":"DB EB WB"},E:{"1":"B C J K TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB","132":"cB"},F:{"1":"3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB","132":"0 1 2"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B","132":"8B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"132":"QC"},P:{"1":"UC VC cB WC XC YC ZC","2":"H RC SC","132":"TC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"132":"cC"}},B:5,C:"CSS justify-content: space-evenly"};

  var kerningPairsLigatures={A:{A:{"2":"I D E F A B fB"},B:{"1":"O R S T U V W X P Y Z G","2":"C J K L M N"},C:{"1":"0 1 2 3 4 5 6 7 8 9 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"KC LC MC","132":"VB H NC eB"},J:{"1":"A","2":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:7,C:"High-quality kerning pairs & ligatures"};

  var keyboardeventCharcode={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","16":"gB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","16":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B vB wB xB yB TB dB zB","16":"C"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB"},H:{"2":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"UB","2":"A B TB dB","16":"C","130":"Q"},L:{"1":"G"},M:{"130":"P"},N:{"130":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:7,C:"KeyboardEvent.charCode"};

  var keyboardeventCode={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t iB jB"},D:{"1":"4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x","194":"0 1 2 3 y z"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k vB wB xB yB TB dB zB UB","194":"l m n o p q"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","194":"Q"},L:{"194":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H","194":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"194":"bC"},S:{"1":"cC"}},B:5,C:"KeyboardEvent.code"};

  var keyboardeventGetmodifierstate={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B L M vB wB xB yB TB dB zB","16":"C"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"2":"D A"},K:{"1":"Q UB","2":"A B TB dB","16":"C"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"KeyboardEvent.getModifierState()"};

  var keyboardeventKey={A:{A:{"2":"I D E fB","260":"F A B"},B:{"1":"R S T U V W X P Y Z G","260":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e iB jB","132":"f g h i j k"},D:{"1":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B L M N O b c d e f g h i j k l m n o p q r s t vB wB xB yB TB dB zB","16":"C"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"1":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"UB","2":"A B TB dB","16":"C Q"},L:{"1":"G"},M:{"1":"P"},N:{"260":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"2":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:5,C:"KeyboardEvent.key"};

  var keyboardeventLocation={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","132":"H a I D E F A B C J K L M N O b c d e f g h i j k l"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","16":"I nB bB","132":"H a oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B vB wB xB yB TB dB zB","16":"C","132":"L M"},G:{"1":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB","132":"1B 2B 3B"},H:{"2":"JC"},I:{"1":"G OC PC","16":"KC LC","132":"VB H MC NC eB"},J:{"132":"D A"},K:{"1":"Q UB","2":"A B TB dB","16":"C"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"KeyboardEvent.location"};

  var keyboardeventWhich={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB","16":"a"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB wB xB yB TB dB zB UB","16":"F vB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB"},H:{"2":"JC"},I:{"1":"VB H G MC NC eB","16":"KC LC","132":"OC PC"},J:{"1":"D A"},K:{"1":"A B C TB dB UB","132":"Q"},L:{"132":"G"},M:{"132":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"2":"H","132":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"132":"bC"},S:{"1":"cC"}},B:7,C:"KeyboardEvent.which"};

  var lazyload={A:{A:{"1":"B","2":"I D E F A fB"},B:{"1":"C J K L M N O","2":"R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"1":"B","2":"A"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Resource Hints: Lazyload"};

  var _let={A:{A:{"2":"I D E F A fB","2052":"B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","194":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O","322":"b c d e f g h i j k l m n o p q r s t u v w","516":"0 1 2 3 4 x y z"},E:{"1":"B C J K TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB","1028":"A cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB","322":"L M N O b c d e f g h i j","516":"k l m n o p q r"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B","1028":"7B 8B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","2":"A"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","516":"H"},Q:{"1":"aC"},R:{"516":"bC"},S:{"1":"cC"}},B:6,C:"let"};

  var linkIconPng={A:{A:{"1":"B","2":"I D E F A fB"},B:{"1":"C J K L M N O","129":"R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"129":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"257":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"129":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","513":"F B C vB wB xB yB TB dB zB UB"},G:{"1026":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1026":"JC"},I:{"1":"VB H KC LC MC NC eB","513":"G OC PC"},J:{"1":"D","1026":"A"},K:{"1026":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1026":"A B"},O:{"257":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","513":"H"},Q:{"129":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"PNG favicons"};

  var linkIconSvg={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R","3073":"S T U V W X P Y Z G"},C:{"2":"gB VB iB jB","260":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w","1025":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R","3073":"S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E nB bB oB pB qB","516":"F A B C J K rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB vB wB xB yB TB dB zB UB","3073":"KB LB MB NB OB PB QB RB SB"},G:{"130":"E bB 0B eB 1B 2B 3B 4B","516":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"130":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D","130":"A"},K:{"130":"A B C Q TB dB UB"},L:{"3073":"G"},M:{"2":"P"},N:{"130":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"1025":"cC"}},B:1,C:"SVG favicons"};

  var linkRelDnsPrefetch={A:{A:{"1":"A B","2":"I D E fB","132":"F"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"gB VB","260":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"16":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"16":"VB H G KC LC MC NC eB OC PC"},J:{"16":"D A"},K:{"16":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","2":"A"},O:{"16":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","16":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"Resource Hints: dns-prefetch"};

  var linkRelModulepreload={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"VC cB WC XC YC ZC","2":"H RC SC TC UC"},Q:{"16":"aC"},R:{"16":"bC"},S:{"2":"cC"}},B:1,C:"Resource Hints: modulepreload"};

  var linkRelPreconnect={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K","260":"L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","129":"v"},D:{"1":"2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"C J K TB UB sB tB uB","2":"H a I D E F A B nB bB oB pB qB rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o vB wB xB yB TB dB zB UB"},G:{"1":"AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"16":"P"},N:{"2":"A B"},O:{"16":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"Resource Hints: preconnect"};

  var linkRelPrefetch={A:{A:{"1":"B","2":"I D E F A fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D"},E:{"2":"H a I D E F A B C J nB bB oB pB qB rB cB TB UB","194":"K sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC","194":"GC HC IC"},H:{"2":"JC"},I:{"1":"H G OC PC","2":"VB KC LC MC NC eB"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","2":"A"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"Resource Hints: prefetch"};

  var linkRelPreload={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M","1028":"N O"},C:{"1":"W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB iB jB","132":"CB","578":"DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V"},D:{"1":"6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"C J K TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB cB","322":"B"},F:{"1":"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s vB wB xB yB TB dB zB UB"},G:{"1":"AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B","322":"9B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:4,C:"Resource Hints: preload"};

  var linkRelPrerender={A:{A:{"1":"B","2":"I D E F A fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"1":"B","2":"A"},O:{"2":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:5,C:"Resource Hints: prerender"};

  var loadingLazyAttr={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB iB jB","132":"SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB","66":"SB YB"},E:{"2":"H a I D E F A B C J nB bB oB pB qB rB cB TB UB","322":"K sB tB uB"},F:{"1":"HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB vB wB xB yB TB dB zB UB","66":"Q GB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC","322":"GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"132":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"XC YC ZC","2":"H RC SC TC UC VC cB WC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:1,C:"Lazy loading via attribute for images & iframes"};

  var localecompare={A:{A:{"1":"B","16":"fB","132":"I D E F A"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","132":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","132":"H a I D E F A B C J K L M N O b c d e f"},E:{"1":"A B C J K cB TB UB sB tB uB","132":"H a I D E F nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","16":"F B C vB wB xB yB TB dB zB","132":"UB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","132":"E bB 0B eB 1B 2B 3B 4B 5B 6B"},H:{"132":"JC"},I:{"1":"G OC PC","132":"VB H KC LC MC NC eB"},J:{"132":"D A"},K:{"1":"Q","16":"A B C TB dB","132":"UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","132":"A"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","132":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"4":"cC"}},B:6,C:"localeCompare()"};

  var magnetometer={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB","194":"EB WB FB XB Q GB HB IB JB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"194":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:4,C:"Magnetometer"};

  var matchesselector={A:{A:{"2":"I D E fB","36":"F A B"},B:{"1":"L M N O R S T U V W X P Y Z G","36":"C J K"},C:{"1":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB","36":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","36":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p"},E:{"1":"E F A B C J K qB rB cB TB UB sB tB uB","2":"H nB bB","36":"a I D oB pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B vB wB xB yB TB","36":"C L M N O b c dB zB UB"},G:{"1":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB","36":"0B eB 1B 2B 3B"},H:{"2":"JC"},I:{"1":"G","2":"KC","36":"VB H LC MC NC eB OC PC"},J:{"36":"D A"},K:{"1":"Q","2":"A B","36":"C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"36":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","36":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"matches() DOM method"};

  var matchmedia={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H a nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B C vB wB xB yB TB dB zB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB"},H:{"1":"JC"},I:{"1":"VB H G NC eB OC PC","2":"KC LC MC"},J:{"1":"A","2":"D"},K:{"1":"Q UB","2":"A B C TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"matchMedia"};

  var mathml={A:{A:{"2":"F A B fB","8":"I D E"},B:{"2":"C J K L M N O","8":"R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","129":"gB VB iB jB"},D:{"1":"g","8":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"A B C J K cB TB UB sB tB uB","260":"H a I D E F nB bB oB pB qB rB"},F:{"2":"F","4":"B C vB wB xB yB TB dB zB UB","8":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","8":"bB 0B eB"},H:{"8":"JC"},I:{"8":"VB H G KC LC MC NC eB OC PC"},J:{"1":"A","8":"D"},K:{"8":"A B C Q TB dB UB"},L:{"8":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"4":"QC"},P:{"8":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"8":"aC"},R:{"8":"bC"},S:{"1":"cC"}},B:2,C:"MathML"};

  var maxlength={A:{A:{"1":"A B","16":"fB","900":"I D E F"},B:{"1":"R S T U V W X P Y Z G","1025":"C J K L M N O"},C:{"1":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","900":"gB VB iB jB","1025":"0 1 2 3 4 5 6 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","16":"a nB","900":"H bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","16":"F","132":"B C vB wB xB yB TB dB zB UB"},G:{"1":"0B eB 1B 2B 3B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB","2052":"E 4B"},H:{"132":"JC"},I:{"1":"VB H MC NC eB OC PC","16":"KC LC","4097":"G"},J:{"1":"D A"},K:{"132":"A B C TB dB UB","4100":"Q"},L:{"4097":"G"},M:{"4097":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"4097":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1025":"cC"}},B:1,C:"maxlength attribute for input and textarea elements"};

  var mediaAttribute={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O","16":"R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K iB jB"},D:{"1":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p","2":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G","16":"kB lB mB"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H a nB bB"},F:{"1":"B C L M N O b c d e f g wB xB yB TB dB zB UB","2":"0 1 2 3 4 5 6 7 8 9 F h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB"},H:{"16":"JC"},I:{"1":"H G NC eB OC PC","16":"VB KC LC MC"},J:{"16":"D A"},K:{"1":"C Q UB","16":"A B TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"16":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Media attribute"};

  var mediaFragments={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","132":"R S T U V W X P Y Z G"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p iB jB","132":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"2":"H a I D E F A B C J K L M N","132":"0 1 2 3 4 5 6 7 8 9 O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a nB bB oB","132":"I D E F A B C J K pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","132":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"bB 0B eB 1B 2B 3B","132":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB","132":"G OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"132":"G"},M:{"132":"P"},N:{"132":"A B"},O:{"2":"QC"},P:{"2":"H RC","132":"SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"132":"cC"}},B:2,C:"Media Fragments"};

  var mediaSessionApi={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB"},E:{"2":"H a I D E F A B C J nB bB oB pB qB rB cB TB UB","16":"K sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"Media Session API"};

  var mediacaptureFromelement={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y iB jB","260":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","324":"7 8 9 AB BB CB DB EB WB FB XB"},E:{"2":"H a I D E F A nB bB oB pB qB rB cB","132":"B C J K TB UB sB tB uB"},F:{"1":"4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r vB wB xB yB TB dB zB UB","324":"0 1 2 3 s t u v w x y z"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"260":"P"},N:{"2":"A B"},O:{"132":"QC"},P:{"1":"UC VC cB WC XC YC ZC","2":"H","132":"RC SC TC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"260":"cC"}},B:5,C:"Media Capture from DOM Elements API"};

  var mediarecorder={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k iB jB"},D:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","194":"3 4"},E:{"1":"tB uB","2":"H a I D E F A B C nB bB oB pB qB rB cB TB","322":"J K UB sB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p vB wB xB yB TB dB zB UB","194":"q r"},G:{"1":"IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC","578":"BC CC DC EC FC GC HC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:5,C:"MediaRecorder API"};

  var mediasource={A:{A:{"2":"I D E F A fB","132":"B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g iB jB","66":"h i j k l m n o p q r s t u v w x"},D:{"1":"0 1 2 3 4 5 6 7 8 9 n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M","33":"f g h i j k l m","66":"N O b c d e"},E:{"1":"E F A B C J K rB cB TB UB sB tB uB","2":"H a I D nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC","260":"DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G PC","2":"VB H KC LC MC NC eB OC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","2":"A"},O:{"1":"QC"},P:{"1":"VC cB WC XC YC ZC","2":"H RC SC TC UC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"Media Source Extensions"};

  var menu={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"gB VB H a I D iB jB","132":"0 1 2 3 4 5 6 7 8 9 E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V","450":"W X P Y Z G"},D:{"2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","66":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","66":"0 1 2 r s t u v w x y z"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"450":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Context menu item (menuitem element)"};

  var metaThemeColor={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u","132":"QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","258":"0 1 2 3 4 5 6 7 8 9 v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"513":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","2":"H","16":"RC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:1,C:"theme-color Meta Tag"};

  var meter={A:{A:{"2":"I D E F A B fB"},B:{"1":"J K L M N O R S T U V W X P Y Z G","2":"C"},C:{"1":"0 1 2 3 4 5 6 7 8 9 M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB TB dB zB UB","2":"F vB wB xB yB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"1":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"meter element"};

  var midi={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:5,C:"Web MIDI API"};

  var minmaxwh={A:{A:{"1":"F A B","8":"I fB","129":"D","257":"E"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"CSS min/max-width/height"};

  var mp3={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB","132":"H a I D E F A B C J K L M N O b c d iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB"},H:{"2":"JC"},I:{"1":"VB H G MC NC eB OC PC","2":"KC LC"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"MP3 audio format"};

  var mpegDash={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O","2":"R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","386":"d e"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"Dynamic Adaptive Streaming over HTTP (MPEG-DASH)"};

  var mpeg4={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c iB jB","4":"d e f g h i j k l m n o p q"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K bB oB pB qB rB cB TB UB sB tB uB","2":"nB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G OC PC","4":"VB H KC LC NC eB","132":"MC"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"260":"P"},N:{"1":"A B"},O:{"4":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"MPEG-4/H.264 video format"};

  var multibackgrounds={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G jB","2":"gB VB iB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","2":"F vB wB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS3 Multiple backgrounds"};

  var multicolumn={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O","516":"R S T U V W X P Y Z G"},C:{"132":"8 9 AB BB CB DB EB WB FB XB Q GB HB","164":"0 1 2 3 4 5 6 7 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","516":"IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"420":"0 1 2 3 4 5 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","516":"6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"A B C J K cB TB UB sB tB uB","132":"F rB","164":"D E qB","420":"H a I nB bB oB pB"},F:{"1":"C TB dB zB UB","2":"F B vB wB xB yB","420":"L M N O b c d e f g h i j k l m n o p q r s","516":"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","132":"5B 6B","164":"E 3B 4B","420":"bB 0B eB 1B 2B"},H:{"1":"JC"},I:{"420":"VB H KC LC MC NC eB OC PC","516":"G"},J:{"420":"D A"},K:{"1":"C TB dB UB","2":"A B","516":"Q"},L:{"516":"G"},M:{"132":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","420":"H"},Q:{"132":"aC"},R:{"132":"bC"},S:{"164":"cC"}},B:4,C:"CSS3 Multiple column layout"};

  var mutationEvents={A:{A:{"2":"I D E fB","260":"F A B"},B:{"132":"R S T U V W X P Y Z G","260":"C J K L M N O"},C:{"2":"gB VB H a iB jB","260":"0 1 2 3 4 5 6 7 8 9 I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"16":"H a I D E F A B C J K","132":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"16":"nB bB","132":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB"},F:{"1":"C zB UB","2":"F vB wB xB yB","16":"B TB dB","132":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"16":"bB 0B","132":"E eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"16":"KC LC","132":"VB H G MC NC eB OC PC"},J:{"132":"D A"},K:{"1":"C UB","2":"A","16":"B TB dB","132":"Q"},L:{"132":"G"},M:{"260":"P"},N:{"260":"A B"},O:{"132":"QC"},P:{"132":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"132":"aC"},R:{"132":"bC"},S:{"260":"cC"}},B:5,C:"Mutation events"};

  var mutationobserver={A:{A:{"1":"B","2":"I D E fB","8":"F A"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N","33":"O b c d e f g h i"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB","33":"I"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B","33":"2B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB KC LC MC","8":"H NC eB"},J:{"1":"A","2":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","8":"A"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Mutation Observer"};

  var namevalueStorage={A:{A:{"1":"E F A B","2":"fB","8":"I D"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","4":"gB VB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","2":"F vB wB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Web Storage - name/value pairs"};

  var nativeFilesystemApi={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","194":"R S T U V W","260":"X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB","194":"RB SB YB ZB aB R S T U V W","260":"X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB vB wB xB yB TB dB zB UB","194":"Q GB HB IB JB KB LB MB NB OB","260":"PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"File System Access API"};

  var navTiming={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a","33":"I D E F A B C"},E:{"1":"E F A B C J K rB cB TB UB sB tB uB","2":"H a I D nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"1":"H G NC eB OC PC","2":"VB KC LC MC"},J:{"1":"A","2":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"Navigation Timing API"};

  var navigatorLanguage={A:{A:{"2":"I D E F A B fB"},B:{"1":"M N O R S T U V W X P Y Z G","2":"C J K L"},C:{"1":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f vB wB xB yB TB dB zB UB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"16":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"16":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"16":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"16":"aC"},R:{"16":"bC"},S:{"1":"cC"}},B:2,C:"Navigator Language API"};

  var netinfo={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","1028":"R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB","1028":"XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB","1028":"4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"KC OC PC","132":"VB H LC MC NC eB"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","516":"Q"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"UC VC cB WC XC YC ZC","132":"H","516":"RC SC TC"},Q:{"1":"aC"},R:{"516":"bC"},S:{"260":"cC"}},B:7,C:"Network Information API"};

  var notifications={A:{A:{"2":"I D E F A B fB"},B:{"1":"K L M N O R S T U V W X P Y Z G","2":"C J"},C:{"1":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H","36":"a I D E F A B C J K L M N O b c d"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB","36":"G OC PC"},J:{"1":"A","2":"D"},K:{"2":"A B C TB dB UB","36":"Q"},L:{"513":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"36":"H","258":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"258":"bC"},S:{"1":"cC"}},B:1,C:"Web Notifications"};

  var objectEntries={A:{A:{"2":"I D E F A B fB"},B:{"1":"K L M N O R S T U V W X P Y Z G","2":"C J"},C:{"1":"3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w vB wB xB yB TB dB zB UB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D","16":"A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","2":"H RC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:6,C:"Object.entries"};

  var objectFit={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L","260":"M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D nB bB oB pB","132":"E F qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F L M N O vB wB xB","33":"B C yB TB dB zB UB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B 3B","132":"E 4B 5B 6B"},H:{"33":"JC"},I:{"1":"G PC","2":"VB H KC LC MC NC eB OC"},J:{"2":"D A"},K:{"1":"Q","2":"A","33":"B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS3 object-fit/object-position"};

  var objectObserve={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 s t u v w x y z","2":"6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"f g h i j k l m n o p q r s","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"H","2":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:7,C:"Object.observe data binding"};

  var objectValues={A:{A:{"8":"I D E F A B fB"},B:{"1":"K L M N O R S T U V W X P Y Z G","2":"C J"},C:{"1":"3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","8":"0 1 2 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","8":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"B C J K cB TB UB sB tB uB","8":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","8":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w vB wB xB yB TB dB zB UB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","8":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"8":"JC"},I:{"1":"G","8":"VB H KC LC MC NC eB OC PC"},J:{"8":"D A"},K:{"1":"Q","8":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"8":"A B"},O:{"1":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","8":"H RC"},Q:{"1":"aC"},R:{"8":"bC"},S:{"1":"cC"}},B:6,C:"Object.values method"};

  var objectrtc={A:{A:{"2":"I D E F A B fB"},B:{"1":"J K L M N O","2":"C R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D","130":"A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"Object RTC (ORTC) API for WebRTC"};

  var offlineApps={A:{A:{"1":"A B","2":"F fB","8":"I D E"},B:{"1":"C J K L M N O R S T U V","2":"W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U iB jB","2":"V W X P Y Z G","4":"VB","8":"gB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V","2":"W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","8":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB yB TB dB zB UB","2":"F QB RB SB vB","8":"wB xB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H KC LC MC NC eB OC PC","2":"G"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"2":"G"},M:{"2":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:7,C:"Offline web applications"};

  var offscreencanvas={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","194":"0 1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB","322":"EB WB FB XB Q GB HB IB JB KB LB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB","322":"1 2 3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"194":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"cB WC XC YC ZC","2":"H RC SC TC UC VC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"194":"cC"}},B:1,C:"OffscreenCanvas"};

  var oggVorbis={A:{A:{"2":"I D E F A B fB"},B:{"1":"N O R S T U V W X P Y Z G","2":"C J K L M"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB VB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB","132":"tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","2":"F vB wB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"A","2":"D"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"Ogg Vorbis audio format"};

  var ogv={A:{A:{"2":"I D E fB","8":"F A B"},B:{"1":"N O R S T U V W X P Y Z G","8":"C J K L M"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB VB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","2":"F vB wB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"1":"P"},N:{"8":"A B"},O:{"1":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:6,C:"Ogg/Theora video format"};

  var olReversed={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L","16":"M N O b"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB","16":"I"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B vB wB xB yB TB dB zB","16":"C"},G:{"1":"E 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B"},H:{"1":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"A","2":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Reversed attribute of ordered lists"};

  var onceEventListener={A:{A:{"2":"I D E F A B fB"},B:{"1":"M N O R S T U V W X P Y Z G","2":"C J K L"},C:{"1":"6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x vB wB xB yB TB dB zB UB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","2":"H RC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:1,C:"\"once\" event listener option"};

  var onlineStatus={A:{A:{"1":"F A B","2":"I D fB","260":"E"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB VB","516":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w"},D:{"1":"0 1 2 3 4 5 6 7 8 9 K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB","4":"UB"},G:{"1":"E eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B"},H:{"2":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"A","132":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Online/offline status"};

  var opus={A:{A:{"2":"I D E F A B fB"},B:{"1":"K L M N O R S T U V W X P Y Z G","2":"C J"},C:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o"},E:{"2":"H a I D E F A nB bB oB pB qB rB cB","132":"B C J K TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B","132":"9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"Opus"};

  var orientationSensor={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB","194":"EB WB FB XB Q GB HB IB JB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:4,C:"Orientation Sensor"};

  var outline={A:{A:{"2":"I D fB","260":"E","388":"F A B"},B:{"1":"L M N O R S T U V W X P Y Z G","388":"C J K"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB","129":"UB","260":"F B vB wB xB yB TB dB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"C Q UB","260":"A B TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"388":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS outline properties"};

  var padStartEnd={A:{A:{"2":"I D E F A B fB"},B:{"1":"L M N O R S T U V W X P Y Z G","2":"C J K"},C:{"1":"4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"TC UC VC cB WC XC YC ZC","2":"H RC SC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:6,C:"String.prototype.padStart(), String.prototype.padEnd()"};

  var pageTransitionEvents={A:{A:{"1":"B","2":"I D E F A fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB"},H:{"2":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","2":"A"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"PageTransitionEvent"};

  var pagevisibility={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F iB jB","33":"A B C J K L M N"},D:{"1":"0 1 2 3 4 5 6 7 8 9 p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J","33":"K L M N O b c d e f g h i j k l m n o"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a I nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B C vB wB xB yB TB dB zB","33":"L M N O b"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB","33":"OC PC"},J:{"1":"A","2":"D"},K:{"1":"Q UB","2":"A B C TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","33":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"Page Visibility"};

  var passiveEventListener={A:{A:{"2":"I D E F A B fB"},B:{"1":"M N O R S T U V W X P Y Z G","2":"C J K L"},C:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t vB wB xB yB TB dB zB UB"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:1,C:"Passive event listeners"};

  var passwordrules={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","16":"R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y iB jB","16":"Z G"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G","16":"kB lB mB"},E:{"1":"C J UB","2":"H a I D E F A B nB bB oB pB qB rB cB TB","16":"K sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB","16":"9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"16":"JC"},I:{"2":"VB H KC LC MC NC eB OC PC","16":"G"},J:{"2":"D","16":"A"},K:{"2":"A B C TB dB UB","16":"Q"},L:{"16":"G"},M:{"16":"P"},N:{"2":"A","16":"B"},O:{"16":"QC"},P:{"2":"H RC SC","16":"TC UC VC cB WC XC YC ZC"},Q:{"16":"aC"},R:{"16":"bC"},S:{"2":"cC"}},B:1,C:"Password Rules"};

  var path2d={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J","132":"K L M N O"},C:{"1":"4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m iB jB","132":"0 1 2 3 n o p q r s t u v w x y z"},D:{"1":"LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r","132":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB"},E:{"1":"A B C J K rB cB TB UB sB tB uB","2":"H a I D nB bB oB pB","132":"E F qB"},F:{"1":"BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e vB wB xB yB TB dB zB UB","132":"0 1 2 3 4 5 6 7 8 9 f g h i j k l m n o p q r s t u v w x y z AB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B 3B","16":"E","132":"4B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"1":"A","2":"D"},K:{"2":"A B C TB dB UB","132":"Q"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"132":"QC"},P:{"1":"cB WC XC YC ZC","132":"H RC SC TC UC VC"},Q:{"132":"aC"},R:{"132":"bC"},S:{"1":"cC"}},B:1,C:"Path2D"};

  var paymentRequest={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J","322":"K","8196":"L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB iB jB","4162":"BB CB DB EB WB FB XB Q GB HB IB","16452":"JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","194":"9 AB BB CB DB EB","1090":"WB FB","8196":"XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB"},E:{"1":"J K UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB","514":"A B cB","8196":"C TB"},F:{"1":"JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v vB wB xB yB TB dB zB UB","194":"0 1 2 3 w x y z","8196":"4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB"},G:{"1":"CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B","514":"7B 8B 9B","8196":"AC BC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2049":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"XC YC ZC","2":"H","8196":"RC SC TC UC VC cB WC"},Q:{"8196":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:4,C:"Payment Request API"};

  var pdfViewer={A:{A:{"2":"I D E F A fB","132":"B"},B:{"1":"L M N O R S T U V W X P Y Z G","16":"C J K"},C:{"1":"0 1 2 3 4 5 6 7 8 9 b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","16":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B vB wB xB yB TB dB zB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"16":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"16":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"Built-in PDF viewer"};

  var permissionsApi={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:7,C:"Permissions API"};

  var permissionsPolicy={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","258":"R S T U V W","322":"X P","388":"Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB iB jB","258":"RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB","258":"FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W","322":"X P","388":"Y Z G kB lB mB"},E:{"2":"H a I D E F A B nB bB oB pB qB rB cB","258":"C J K TB UB sB tB uB"},F:{"2":"0 1 2 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB","258":"3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB","322":"PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B","258":"AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB OC PC","258":"G"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","258":"Q"},L:{"388":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC","258":"UC VC cB WC XC YC ZC"},Q:{"258":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"Permissions Policy"};

  var pictureInPicture={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB iB jB","132":"PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","1090":"KB","1412":"OB","1668":"LB MB NB"},D:{"1":"NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB","2114":"MB"},E:{"1":"K sB tB uB","2":"H a I D E F nB bB oB pB qB rB","4100":"A B C J cB TB UB"},F:{"1":"QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s vB wB xB yB TB dB zB UB","8196":"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB"},G:{"1":"HC IC","2":"E bB 0B eB 1B 2B 3B 4B","4100":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"16388":"G"},M:{"16388":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Picture-in-Picture"};

  var picture={A:{A:{"2":"I D E F A B fB"},B:{"1":"J K L M N O R S T U V W X P Y Z G","2":"C"},C:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p iB jB","578":"q r s t"},D:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s","194":"t"},E:{"1":"A B C J K rB cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f vB wB xB yB TB dB zB UB","322":"g"},G:{"1":"6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Picture element"};

  var ping={A:{A:{"2":"I D E F A B fB"},B:{"1":"N O R S T U V W X P Y Z G","2":"C J K L M"},C:{"2":"gB","194":"0 1 2 3 4 5 6 7 8 9 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"194":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"194":"cC"}},B:1,C:"Ping attribute"};

  var pngAlpha={A:{A:{"1":"D E F A B","2":"fB","8":"I"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"PNG alpha transparency"};

  var pointerEvents={A:{A:{"1":"B","2":"I D E F A fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G jB","2":"gB VB iB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","2":"A"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:7,C:"CSS pointer-events (for HTML)"};

  var pointer={A:{A:{"1":"B","2":"I D E F fB","164":"A"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a iB jB","8":"I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w","328":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB"},D:{"1":"BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d","8":"0 1 2 3 4 5 6 7 e f g h i j k l m n o p q r s t u v w x y z","584":"8 9 AB"},E:{"1":"J K sB tB uB","2":"H a I nB bB oB","8":"D E F A B C pB qB rB cB TB","1096":"UB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB","8":"L M N O b c d e f g h i j k l m n o p q r s t u","584":"v w x"},G:{"1":"EC FC GC HC IC","8":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC","6148":"DC"},H:{"2":"JC"},I:{"1":"G","8":"VB H KC LC MC NC eB OC PC"},J:{"8":"D A"},K:{"1":"Q","2":"A","8":"B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","36":"A"},O:{"8":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","2":"RC","8":"H"},Q:{"1":"aC"},R:{"2":"bC"},S:{"328":"cC"}},B:2,C:"Pointer events"};

  var pointerlock={A:{A:{"2":"I D E F A B fB"},B:{"1":"J K L M N O R S T U V W X P Y Z G","2":"C"},C:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J iB jB","33":"K L M N O b c d e f g h i j k l m n o p q r s t u v w"},D:{"1":"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L","33":"e f g h i j k l m n o p q r s","66":"M N O b c d"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB","33":"L M N O b c d e f"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:2,C:"Pointer Lock API"};

  var portals={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V","322":"G","450":"W X P Y Z"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB","194":"SB YB ZB aB R S T U V","322":"X P Y Z G kB lB mB","450":"W"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB vB wB xB yB TB dB zB UB","194":"Q GB HB IB JB KB LB MB NB OB PB","322":"QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"450":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Portals"};

  var prefersColorScheme={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB iB jB"},D:{"1":"YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},E:{"1":"J K UB sB tB uB","2":"H a I D E F A B C nB bB oB pB qB rB cB TB"},F:{"1":"Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB vB wB xB yB TB dB zB UB"},G:{"1":"DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"XC YC ZC","2":"H RC SC TC UC VC cB WC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"prefers-color-scheme media query"};

  var prefersReducedMotion={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q iB jB"},D:{"1":"RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB vB wB xB yB TB dB zB UB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"WC XC YC ZC","2":"H RC SC TC UC VC cB"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"prefers-reduced-motion media query"};

  var privateClassFields={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB"},E:{"1":"tB uB","2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB"},F:{"1":"Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB vB wB xB yB TB dB zB UB"},G:{"1":"IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"WC XC YC ZC","2":"H RC SC TC UC VC cB"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Private class fields"};

  var privateMethodsAndAccessors={A:{A:{"2":"I D E F A B fB"},B:{"1":"V W X P Y Z G","2":"C J K L M N O R S T U"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U"},E:{"1":"tB uB","2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB"},F:{"1":"NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB vB wB xB yB TB dB zB UB"},G:{"1":"IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Public class fields"};

  var progress={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB TB dB zB UB","2":"F vB wB xB yB"},G:{"1":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B","132":"3B"},H:{"1":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"progress element"};

  var promiseFinally={A:{A:{"2":"I D E F A B fB"},B:{"1":"O R S T U V W X P Y Z G","2":"C J K L M N"},C:{"1":"EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB iB jB"},D:{"1":"GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q"},E:{"1":"C J K TB UB sB tB uB","2":"H a I D E F A B nB bB oB pB qB rB cB"},F:{"1":"6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"1":"AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"UC VC cB WC XC YC ZC","2":"H RC SC TC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"Promise.prototype.finally"};

  var promises={A:{A:{"8":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","4":"j k","8":"gB VB H a I D E F A B C J K L M N O b c d e f g h i iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","4":"o","8":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n"},E:{"1":"E F A B C J K qB rB cB TB UB sB tB uB","8":"H a I D nB bB oB pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","4":"b","8":"F B C L M N O vB wB xB yB TB dB zB UB"},G:{"1":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","8":"bB 0B eB 1B 2B 3B"},H:{"8":"JC"},I:{"1":"G PC","8":"VB H KC LC MC NC eB OC"},J:{"8":"D A"},K:{"1":"Q","8":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"8":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"Promises"};

  var proximity={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:4,C:"Proximity API"};

  var proxy={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N iB jB"},D:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 H a I D E F A B C J K L M N O u v w x y z","66":"b c d e f g h i j k l m n o p q r s t"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C h i j k l m n o p q r vB wB xB yB TB dB zB UB","66":"L M N O b c d e f g"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:6,C:"Proxy object"};

  var publicClassFields={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB iB jB","4":"NB OB PB QB RB","132":"MB"},D:{"1":"PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB"},E:{"1":"tB uB","2":"H a I D E F A B C J nB bB oB pB qB rB cB TB UB sB","260":"K"},F:{"1":"FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB vB wB xB yB TB dB zB UB"},G:{"1":"HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"WC XC YC ZC","2":"H RC SC TC UC VC cB"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Public class fields"};

  var publickeypinning={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB","2":"F B C L M N O b JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","4":"f","16":"c d e g"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB","2":"WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"HTTP Public Key Pinning"};

  var pushApi={A:{A:{"2":"I D E F A B fB"},B:{"1":"N O","2":"C J K L M","257":"R S T U V W X P Y Z G"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","257":"0 2 3 4 5 6 7 9 AB BB CB DB EB WB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","1281":"1 8 FB"},D:{"2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","257":"6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","388":"0 1 2 3 4 5"},E:{"2":"H a I D E F nB bB oB pB qB","514":"A B C J K rB cB TB UB sB tB uB"},F:{"2":"F B C L M N O b c d e f g h i j k l m n o p q r s vB wB xB yB TB dB zB UB","16":"t u v w x","257":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"257":"cC"}},B:5,C:"Push API"};

  var queryselector={A:{A:{"1":"F A B","2":"fB","8":"I D","132":"E"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","8":"gB VB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB wB xB yB TB dB zB UB","8":"F vB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"querySelector/querySelectorAll"};

  var readonlyAttr={A:{A:{"1":"I D E F A B","16":"fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","16":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K L M N O b c d e f g h"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","16":"H a nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","16":"F vB","132":"B C wB xB yB TB dB zB UB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB 1B 2B"},H:{"1":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"Q","132":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"257":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"readonly attribute of input and textarea elements"};

  var referrerPolicy={A:{A:{"2":"I D E F A fB","132":"B"},B:{"1":"R S T U","132":"C J K L M N O","513":"V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r iB jB"},D:{"1":"XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V","2":"H a I D E F A B C J K L M N O b c","260":"0 1 2 3 4 5 6 7 8 9 d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB","513":"W X P Y Z G kB lB mB"},E:{"1":"C TB UB","2":"H a I D nB bB oB pB","132":"E F A B qB rB cB","1025":"J K sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB","2":"F B C vB wB xB yB TB dB zB UB","513":"QB RB SB"},G:{"1":"BC CC DC EC","2":"bB 0B eB 1B 2B 3B","132":"E 4B 5B 6B 7B 8B 9B AC","1025":"FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"513":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"Referrer Policy"};

  var registerprotocolhandler={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","129":"R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB"},D:{"2":"H a I D E F A B C","129":"0 1 2 3 4 5 6 7 8 9 J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B vB wB xB yB TB dB","129":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D","129":"A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:1,C:"Custom protocol handling"};

  var relNoopener={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB"},D:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r vB wB xB yB TB dB zB UB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:1,C:"rel=noopener"};

  var relNoreferrer={A:{A:{"2":"I D E F A fB","132":"B"},B:{"1":"J K L M N O R S T U V W X P Y Z G","16":"C"},C:{"1":"0 1 2 3 4 5 6 7 8 9 p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K L"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB"},H:{"2":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Link type \"noreferrer\""};

  var rellist={A:{A:{"2":"I D E F A B fB"},B:{"1":"O R S T U V W X P Y Z G","2":"C J K L M","132":"N"},C:{"1":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l iB jB"},D:{"1":"IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","132":"6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"H a I D E nB bB oB pB qB"},F:{"1":"8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s vB wB xB yB TB dB zB UB","132":"0 1 2 3 4 5 6 7 t u v w x y z"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"132":"QC"},P:{"1":"VC cB WC XC YC ZC","2":"H","132":"RC SC TC UC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:1,C:"relList (DOMTokenList)"};

  var rem={A:{A:{"1":"B","2":"I D E fB","132":"F A"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G jB","2":"gB VB iB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB","2":"F B vB wB xB yB TB dB"},G:{"1":"E 0B eB 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB","260":"1B"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"C Q UB","2":"A B TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"rem (root em) units"};

  var requestanimationframe={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB","33":"B C J K L M N O b c d e","164":"H a I D E F A"},D:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F","33":"e f","164":"O b c d","420":"A B C J K L M N"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB","33":"I"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B","33":"2B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"A","2":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"requestAnimationFrame"};

  var requestidlecallback={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","194":"9 AB"},D:{"1":"3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"2":"H a I D E F A B C J nB bB oB pB qB rB cB TB UB","322":"K sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC","322":"GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:5,C:"requestIdleCallback"};

  var resizeobserver={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB iB jB"},D:{"1":"HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","194":"AB BB CB DB EB WB FB XB Q GB"},E:{"1":"K sB tB uB","2":"H a I D E F A B C nB bB oB pB qB rB cB TB UB","66":"J"},F:{"1":"8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v w vB wB xB yB TB dB zB UB","194":"0 1 2 3 4 5 6 7 x y z"},G:{"1":"GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"VC cB WC XC YC ZC","2":"H RC SC TC UC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Resize Observer"};

  var resourceTiming={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m iB jB","194":"n o p q"},D:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g"},E:{"1":"C J K TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB cB","260":"B"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"Resource Timing"};

  var restParameters={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K iB jB"},D:{"1":"3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","194":"0 1 2"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m vB wB xB yB TB dB zB UB","194":"n o p"},G:{"1":"7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"Rest parameters"};

  var rtcpeerconnection={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K","516":"L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d iB jB","33":"e f g h i j k l m n o p q r s t u v w x y z"},D:{"1":"CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e","33":"0 1 2 3 4 5 6 7 8 9 f g h i j k l m n o p q r s t u v w x y z AB BB"},E:{"1":"B C J K TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N vB wB xB yB TB dB zB UB","33":"O b c d e f g h i j k l m n o p q r s t u v w x y"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D","130":"A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"33":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"33":"aC"},R:{"33":"bC"},S:{"1":"cC"}},B:5,C:"WebRTC Peer-to-peer connections"};

  var ruby={A:{A:{"4":"I D E F A B fB"},B:{"4":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","8":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t iB jB"},D:{"4":"0 1 2 3 4 5 6 7 8 9 a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","8":"H"},E:{"4":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","8":"H nB bB"},F:{"4":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","8":"F B C vB wB xB yB TB dB zB UB"},G:{"4":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","8":"bB 0B eB"},H:{"8":"JC"},I:{"4":"VB H G NC eB OC PC","8":"KC LC MC"},J:{"4":"A","8":"D"},K:{"4":"Q","8":"A B C TB dB UB"},L:{"4":"G"},M:{"1":"P"},N:{"4":"A B"},O:{"4":"QC"},P:{"4":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"4":"aC"},R:{"4":"bC"},S:{"1":"cC"}},B:1,C:"Ruby annotation"};

  var runIn={A:{A:{"1":"E F A B","2":"I D fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n","2":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"a I oB","2":"D E F A B C J K qB rB cB TB UB sB tB uB","16":"pB","129":"H nB bB"},F:{"1":"F B C L M N O vB wB xB yB TB dB zB UB","2":"0 1 2 3 4 5 6 7 8 9 b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"1":"0B eB 1B 2B 3B","2":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","129":"bB"},H:{"1":"JC"},I:{"1":"VB H KC LC MC NC eB OC","2":"G PC"},J:{"1":"D A"},K:{"1":"A B C TB dB UB","2":"Q"},L:{"2":"G"},M:{"2":"P"},N:{"1":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"display: run-in"};

  var sameSiteCookieAttribute={A:{A:{"2":"I D E F A fB","388":"B"},B:{"1":"O R S T U V W","2":"C J K L","129":"M N","513":"X P Y Z G"},C:{"1":"FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB iB jB"},D:{"1":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R","2":"0 1 2 3 4 5 6 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","513":"S T U V W X P Y Z G kB lB mB"},E:{"1":"tB uB","2":"H a I D E F A B nB bB oB pB qB rB cB TB","2052":"K","3076":"C J UB sB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u vB wB xB yB TB dB zB UB","513":"OB PB QB RB SB"},G:{"1":"DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC","2052":"BC CC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","513":"Q"},L:{"513":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"16":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:6,C:"'SameSite' cookie attribute"};

  var screenOrientation={A:{A:{"2":"I D E F A fB","164":"B"},B:{"1":"R S T U V W X P Y Z G","36":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N iB jB","36":"O b c d e f g h i j k l m n o p q r s t u v w x y z"},D:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A","36":"B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","16":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"Screen Orientation"};

  var scriptAsync={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G jB","2":"gB VB iB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB","132":"a"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB"},H:{"2":"JC"},I:{"1":"VB H G NC eB OC PC","2":"KC LC MC"},J:{"1":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"async attribute for external scripts"};

  var scriptDefer={A:{A:{"1":"A B","132":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB","257":"H a I D E F A B C J K L M N O b c d e f g h i j k l m iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB"},H:{"2":"JC"},I:{"1":"VB H G NC eB OC PC","2":"KC LC MC"},J:{"1":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"defer attribute for external scripts"};

  var scrollintoview={A:{A:{"2":"I D fB","132":"E F A B"},B:{"1":"R S T U V W X P Y Z G","132":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","132":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r iB jB"},D:{"1":"XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","132":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB"},E:{"2":"H a nB bB","132":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB"},F:{"1":"4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F vB wB xB yB","16":"B TB dB","132":"0 1 2 3 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z zB UB"},G:{"16":"bB 0B eB","132":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","16":"KC LC","132":"VB H MC NC eB OC PC"},J:{"132":"D A"},K:{"132":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"132":"A B"},O:{"132":"QC"},P:{"132":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"132":"bC"},S:{"1":"cC"}},B:5,C:"scrollIntoView"};

  var scrollintoviewifneeded={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","16":"H a nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB"},H:{"2":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:7,C:"Element.scrollIntoViewIfNeeded()"};

  var sdch={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB","2":"WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB","2":"F B C QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"SDCH Accept-Encoding/Content-Encoding"};

  var selectionApi={A:{A:{"1":"F A B","16":"fB","260":"I D E"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","132":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y iB jB","2180":"0 1 2 3 4 5 6 7 z"},D:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","16":"H a nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","132":"F B C vB wB xB yB TB dB zB UB"},G:{"16":"eB","132":"bB 0B","516":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G OC PC","16":"VB H KC LC MC NC","1025":"eB"},J:{"1":"A","16":"D"},K:{"1":"Q","16":"A B C TB dB","132":"UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","16":"A"},O:{"1025":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2180":"cC"}},B:5,C:"Selection API"};

  var serverTiming={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB iB jB"},D:{"1":"IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB","196":"FB XB Q GB","324":"HB"},E:{"2":"H a I D E F A B C nB bB oB pB qB rB cB TB","516":"J K UB sB tB uB"},F:{"1":"8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"Server Timing"};

  var serviceworkers={A:{A:{"2":"I D E F A B fB"},B:{"1":"N O R S T U V W X P Y Z G","2":"C J K","322":"L M"},C:{"1":"0 2 3 4 5 6 7 9 AB BB CB DB EB WB XB Q GB HB IB JB KB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o iB jB","194":"p q r s t u v w x y z","513":"1 8 FB LB"},D:{"1":"1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v","4":"0 w x y z"},E:{"1":"C J K TB UB sB tB uB","2":"H a I D E F A B nB bB oB pB qB rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i vB wB xB yB TB dB zB UB","4":"j k l m n"},G:{"1":"AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB OC PC","4":"G"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","4":"Q"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"4":"bC"},S:{"2":"cC"}},B:4,C:"Service Workers"};

  var setimmediate={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O","2":"R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"1":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Efficient Script Yielding: setImmediate()"};

  var sha2={A:{A:{"1":"I D E F A B","2":"fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","132":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"16":"JC"},I:{"1":"VB H G LC MC NC eB OC PC","260":"KC"},J:{"1":"D A"},K:{"16":"A B C Q TB dB UB"},L:{"1":"G"},M:{"16":"P"},N:{"16":"A B"},O:{"16":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","16":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"SHA-2 SSL certificates"};

  var shadowdom={A:{A:{"2":"I D E F A B fB"},B:{"1":"R","2":"C J K L M N O S T U V W X P Y Z G"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","66":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB WB FB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R","2":"H a I D E F A B C J K L M N O b c d e f g S T U V W X P Y Z G kB lB mB","33":"h i j k l m n o p q"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB","2":"F B C KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","33":"L M N O b c d"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB","33":"OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC","2":"YC ZC","33":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:7,C:"Shadow DOM (deprecated V0 spec)"};

  var shadowdomv1={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB iB jB","322":"EB","578":"WB FB XB Q"},D:{"1":"9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"A B C J K cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B","132":"7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","2":"H","4":"RC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"Shadow DOM (V1)"};

  var sharedarraybuffer={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L","194":"M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB iB jB","194":"DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB","450":"RB SB YB ZB aB","513":"R S T hB U V W X P Y Z G"},D:{"1":"LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB","194":"FB XB Q GB HB IB JB KB","513":"kB lB mB"},E:{"2":"H a I D E F A nB bB oB pB qB rB","194":"B C J K cB TB UB sB tB uB"},F:{"1":"HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB","194":"3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B","194":"8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"513":"G"},M:{"513":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"Shared Array Buffer"};

  var sharedworkers={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"a I oB","2":"H D E F A B C J K nB bB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB yB TB dB zB UB","2":"F vB wB xB"},G:{"1":"1B 2B","2":"E bB 0B eB 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"B C TB dB UB","2":"Q","16":"A"},L:{"2":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"H","2":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:1,C:"Shared Web Workers"};

  var sni={A:{A:{"1":"F A B","2":"I fB","132":"D E"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB"},H:{"1":"JC"},I:{"1":"VB H G NC eB OC PC","2":"KC LC MC"},J:{"1":"A","2":"D"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"Server Name Indication"};

  var spdy={A:{A:{"1":"B","2":"I D E F A fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","2":"7 8 9 gB VB H a I D E F A B C AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","2":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"E F A B C rB cB TB","2":"H a I D nB bB oB pB qB","129":"J K UB sB tB uB"},F:{"1":"0 L M N O b c d e f g h i j k l m n o p q r s t u v y UB","2":"1 2 3 4 5 6 7 8 9 F B C w x z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB"},G:{"1":"E 4B 5B 6B 7B 8B 9B AC BC","2":"bB 0B eB 1B 2B 3B","257":"CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H NC eB OC PC","2":"G KC LC MC"},J:{"2":"D A"},K:{"1":"UB","2":"A B C Q TB dB"},L:{"2":"G"},M:{"2":"P"},N:{"1":"B","2":"A"},O:{"2":"QC"},P:{"1":"H","2":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"16":"bC"},S:{"1":"cC"}},B:7,C:"SPDY protocol"};

  var speechRecognition={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","1026":"R S T U V W X P Y Z G"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d iB jB","322":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"2":"H a I D E F A B C J K L M N O b c d e f g","164":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB","2084":"tB uB"},F:{"2":"F B C L M N O b c d e f g h i vB wB xB yB TB dB zB UB","1026":"0 1 2 3 4 5 6 7 8 9 j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC","2084":"IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"164":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"164":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"164":"aC"},R:{"164":"bC"},S:{"322":"cC"}},B:7,C:"Speech Recognition API"};

  var speechSynthesis={A:{A:{"2":"I D E F A B fB"},B:{"1":"K L M N O","2":"C J","257":"R S T U V W X P Y Z G"},C:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m iB jB","194":"0 1 2 3 4 n o p q r s t u v w x y z"},D:{"1":"0 1 2 3 4 5 6 7 8 9 p q r s t u v w x y z AB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o","257":"BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"D E F A B C J K qB rB cB TB UB sB tB uB","2":"H a I nB bB oB pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB","2":"F B C L M N O b c d e f g h i vB wB xB yB TB dB zB UB","257":"HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:7,C:"Speech Synthesis API"};

  var spellcheckAttribute={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H a nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","2":"F vB wB"},G:{"4":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"4":"JC"},I:{"4":"VB H G KC LC MC NC eB OC PC"},J:{"1":"A","4":"D"},K:{"4":"A B C Q TB dB UB"},L:{"4":"G"},M:{"4":"P"},N:{"4":"A B"},O:{"4":"QC"},P:{"4":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"4":"bC"},S:{"2":"cC"}},B:1,C:"Spellcheck attribute"};

  var sqlStorage={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C nB bB oB pB qB rB cB TB UB","2":"J K sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","2":"F vB wB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC","2":"DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:7,C:"Web SQL Database"};

  var srcset={A:{A:{"2":"I D E F A B fB"},B:{"1":"M N O R S T U V W X P Y Z G","260":"C","514":"J K L"},C:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n iB jB","194":"o p q r s t"},D:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p","260":"q r s t"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"H a I D nB bB oB pB","260":"E qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c vB wB xB yB TB dB zB UB","260":"d e f g"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B 3B","260":"E 4B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Srcset and sizes attributes"};

  var stream={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M iB jB","129":"s t u v w x","420":"N O b c d e f g h i j k l m n o p q r"},D:{"1":"9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c","420":"0 1 2 3 4 5 6 7 8 d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"B C J K TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B L M N vB wB xB yB TB dB zB","420":"C O b c d e f g h i j k l m n o p q r s t u v UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B","513":"GC HC IC","1537":"9B AC BC CC DC EC FC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D","420":"A"},K:{"1":"Q","2":"A B TB dB","420":"C UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","420":"H RC"},Q:{"1":"aC"},R:{"420":"bC"},S:{"2":"cC"}},B:4,C:"getUserMedia/Stream API"};

  var streams={A:{A:{"2":"I D E F A fB","130":"B"},B:{"1":"Z G","16":"C J","260":"K L","1028":"R S T U V W X P Y","5124":"M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB iB jB","6148":"IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","6722":"DB EB WB FB XB Q GB HB"},D:{"1":"Z G kB lB mB","2":"0 1 2 3 4 5 6 7 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","260":"8 9 AB BB CB DB EB","1028":"WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y"},E:{"2":"H a I D E F nB bB oB pB qB rB","1028":"tB uB","3076":"A B C J K cB TB UB sB"},F:{"2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u vB wB xB yB TB dB zB UB","260":"0 1 v w x y z","1028":"2 3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B","16":"7B","1028":"8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","1028":"Q"},L:{"1":"G"},M:{"6148":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC","1028":"TC UC VC cB WC XC YC ZC"},Q:{"1028":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:1,C:"Streams"};

  var stricttransportsecurity={A:{A:{"2":"I D E F A fB","129":"B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"D E F A B C J K qB rB cB TB UB sB tB uB","2":"H a I nB bB oB pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F B vB wB xB yB TB dB zB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"Strict Transport Security"};

  var styleScoped={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 d e f g h i j k l m n o p q r s t u v w x y z AB","2":"gB VB H a I D E F A B C J K L M N O b c XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","322":"BB CB DB EB WB FB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","194":"c d e f g h i j k l m n o p q r s"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"322":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:7,C:"Scoped CSS"};

  var subresourceIntegrity={A:{A:{"2":"I D E F A B fB"},B:{"1":"N O R S T U V W X P Y Z G","2":"C J K L M"},C:{"1":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y iB jB"},D:{"1":"1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"B C J K TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n vB wB xB yB TB dB zB UB"},G:{"1":"AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B","194":"9B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"Subresource Integrity"};

  var svgCss={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"M N O R S T U V W X P Y Z G","516":"C J K L"},C:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB","260":"H a I D E F A B C J K L M N O b c d e f"},D:{"1":"0 1 2 3 4 5 6 7 8 9 a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","4":"H"},E:{"1":"a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"nB","132":"H bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","2":"F"},G:{"1":"E eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","132":"bB 0B"},H:{"260":"JC"},I:{"1":"VB H G NC eB OC PC","2":"KC LC MC"},J:{"1":"D A"},K:{"1":"Q","260":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"SVG in CSS backgrounds"};

  var svgFilters={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H","4":"a I D"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B"},H:{"1":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"A","2":"D"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"SVG filters"};

  var svgFonts={A:{A:{"2":"F A B fB","8":"I D E"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t","2":"7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","130":"0 1 2 3 4 5 6 u v w x y z"},E:{"1":"H a I D E F A B C J K bB oB pB qB rB cB TB UB sB tB uB","2":"nB"},F:{"1":"F B C L M N O b c d e f g vB wB xB yB TB dB zB UB","2":"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","130":"h i j k l m n o p q r s"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"258":"JC"},I:{"1":"VB H NC eB OC PC","2":"G KC LC MC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"130":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"H","130":"RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"130":"bC"},S:{"2":"cC"}},B:2,C:"SVG fonts"};

  var svgFragment={A:{A:{"2":"I D E fB","260":"F A B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K iB jB"},D:{"1":"6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r","132":"0 1 2 3 4 5 s t u v w x y z"},E:{"1":"C J K TB UB sB tB uB","2":"H a I D F A B nB bB oB pB rB cB","132":"E qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"L M N O b c d e","4":"B C wB xB yB TB dB zB","16":"F vB","132":"f g h i j k l m n o p q r s"},G:{"1":"AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B 3B 5B 6B 7B 8B 9B","132":"E 4B"},H:{"1":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D","132":"A"},K:{"1":"Q UB","4":"A B C TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","132":"H"},Q:{"1":"aC"},R:{"132":"bC"},S:{"1":"cC"}},B:4,C:"SVG fragment identifiers"};

  var svgHtml={A:{A:{"2":"I D E fB","388":"F A B"},B:{"4":"R S T U V W X P Y Z G","260":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB","4":"VB"},D:{"4":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"nB bB","4":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB"},F:{"4":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"4":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB","4":"G OC PC"},J:{"1":"A","2":"D"},K:{"4":"A B C Q TB dB UB"},L:{"4":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"4":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"4":"aC"},R:{"4":"bC"},S:{"1":"cC"}},B:2,C:"SVG effects for HTML"};

  var svgHtml5={A:{A:{"2":"fB","8":"I D E","129":"F A B"},B:{"1":"N O R S T U V W X P Y Z G","129":"C J K L M"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","8":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","8":"H a I"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","8":"H a nB bB","129":"I D E oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB","2":"B yB TB dB","8":"F vB wB xB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","8":"bB 0B eB","129":"E 1B 2B 3B 4B"},H:{"1":"JC"},I:{"1":"G OC PC","2":"KC LC MC","129":"VB H NC eB"},J:{"1":"A","129":"D"},K:{"1":"C Q UB","8":"A B TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"129":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Inline SVG in HTML5"};

  var svgImg={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","132":"H a I D E F A B C J K L M N O b c d e f g h i j"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"nB","4":"bB","132":"H a I D E oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","132":"E bB 0B eB 1B 2B 3B 4B"},H:{"1":"JC"},I:{"1":"G OC PC","2":"KC LC MC","132":"VB H NC eB"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"SVG in HTML img element"};

  var svgSmil={A:{A:{"2":"fB","8":"I D E F A B"},B:{"1":"R S T U V W X P Y Z G","8":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","8":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","4":"H"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","8":"nB bB","132":"H a oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","132":"bB 0B eB 1B"},H:{"2":"JC"},I:{"1":"VB H G NC eB OC PC","2":"KC LC MC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"8":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"SVG SMIL animation"};

  var svg={A:{A:{"2":"fB","8":"I D E","772":"F A B"},B:{"1":"R S T U V W X P Y Z G","513":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","4":"gB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K bB oB pB qB rB cB TB UB sB tB uB","4":"nB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"G OC PC","2":"KC LC MC","132":"VB H NC eB"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"257":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"SVG (basic support)"};

  var sxg={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB","132":"OB PB"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"16":"QC"},P:{"1":"WC XC YC ZC","2":"H RC SC TC UC VC cB"},Q:{"16":"aC"},R:{"16":"bC"},S:{"2":"cC"}},B:6,C:"Signed HTTP Exchanges (SXG)"};

  var tabindexAttr={A:{A:{"1":"D E F A B","16":"I fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"16":"gB VB iB jB","129":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K"},E:{"16":"H a nB bB","257":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","16":"F"},G:{"769":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"16":"JC"},I:{"16":"VB H G KC LC MC NC eB OC PC"},J:{"16":"D A"},K:{"16":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"16":"A B"},O:{"16":"QC"},P:{"16":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"16":"bC"},S:{"129":"cC"}},B:1,C:"tabindex global attribute"};

  var templateLiterals={A:{A:{"2":"I D E F A B fB"},B:{"1":"J K L M N O R S T U V W X P Y Z G","16":"C"},C:{"1":"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w"},E:{"1":"A B J K rB cB TB UB sB tB uB","2":"H a I D E F nB bB oB pB qB","129":"C"},F:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k vB wB xB yB TB dB zB UB"},G:{"1":"5B 6B 7B 8B 9B AC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B","129":"BC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"ES6 Template Literals (Template Strings)"};

  var template={A:{A:{"2":"I D E F A B fB"},B:{"1":"L M N O R S T U V W X P Y Z G","2":"C","388":"J K"},C:{"1":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h","132":"i j k l m n o p q"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","2":"H a I D nB bB oB","388":"E qB","514":"pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB","132":"L M N O b c d"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B 3B","388":"E 4B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"HTML templates"};

  var testfeat={A:{A:{"2":"I D E A B fB","16":"F"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","16":"H a"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"B C"},E:{"2":"H I nB bB oB","16":"a D E F A B C J K pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB dB zB UB","16":"TB"},G:{"2":"bB 0B eB 1B 2B","16":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"2":"VB H G KC LC NC eB OC PC","16":"MC"},J:{"2":"A","16":"D"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Test feature - updated"};

  var textDecoration={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","2052":"R S T U V W X P Y Z G"},C:{"2":"gB VB H a iB jB","1028":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","1060":"I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r"},D:{"2":"H a I D E F A B C J K L M N O b c d e f g h","226":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB","2052":"DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D nB bB oB pB","772":"J K UB sB tB uB","804":"E F A B C rB cB TB","1316":"qB"},F:{"2":"F B C L M N O b c d e f g h i j k l m n o p q vB wB xB yB TB dB zB UB","226":"r s t u v w x y z","2052":"0 1 2 3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"bB 0B eB 1B 2B 3B","292":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","2052":"Q"},L:{"2052":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2052":"QC"},P:{"2":"H RC SC","2052":"TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"1":"bC"},S:{"1028":"cC"}},B:4,C:"text-decoration styling"};

  var textEmphasis={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","164":"R S T U V W X P Y Z G"},C:{"1":"2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","322":"1"},D:{"2":"H a I D E F A B C J K L M N O b c d e f g","164":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"E F A B C J K qB rB cB TB UB sB tB uB","2":"H a I nB bB oB","164":"D pB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","164":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B"},H:{"2":"JC"},I:{"2":"VB H KC LC MC NC eB","164":"G OC PC"},J:{"2":"D","164":"A"},K:{"2":"A B C TB dB UB","164":"Q"},L:{"164":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"164":"QC"},P:{"164":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"164":"aC"},R:{"164":"bC"},S:{"1":"cC"}},B:4,C:"text-emphasis styling"};

  var textOverflow={A:{A:{"1":"I D E F A B","2":"fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","8":"gB VB H a I iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB TB dB zB UB","33":"F vB wB xB yB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"1":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"Q UB","33":"A B C TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS3 Text-overflow"};

  var textSizeAdjust={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","33":"C J K L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h j k l m n o p q r s t u v w x y z","258":"i"},E:{"2":"H a I D E F A B C J K nB bB pB qB rB cB TB UB sB tB uB","258":"oB"},F:{"1":"1 2 3 4 5 6 7 8 9 z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y vB wB xB yB TB dB zB UB"},G:{"2":"bB 0B eB","33":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"33":"P"},N:{"161":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"CSS text-size-adjust"};

  var textStroke={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K","33":"R S T U V W X P Y Z G","161":"L M N O"},C:{"2":"0 1 2 3 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","161":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","450":"4"},D:{"33":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"33":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F B C vB wB xB yB TB dB zB UB","33":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"33":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","36":"bB"},H:{"2":"JC"},I:{"2":"VB","33":"H G KC LC MC NC eB OC PC"},J:{"33":"D A"},K:{"2":"A B C TB dB UB","33":"Q"},L:{"33":"G"},M:{"161":"P"},N:{"2":"A B"},O:{"33":"QC"},P:{"33":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"33":"aC"},R:{"33":"bC"},S:{"161":"cC"}},B:7,C:"CSS text-stroke and text-fill"};

  var textUnderlineOffset={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB iB jB","130":"MB"},D:{"2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"J K UB sB tB uB","2":"H a I D E F A B C nB bB oB pB qB rB cB TB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"1":"BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"text-underline-offset"};

  var textcontent={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K bB oB pB qB rB cB TB UB sB tB uB","16":"nB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","16":"F"},G:{"1":"E 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB"},H:{"1":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Node.textContent"};

  var textencoder={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O iB jB","132":"b"},D:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g vB wB xB yB TB dB zB UB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"TextEncoder & TextDecoder"};

  var tls11={A:{A:{"1":"B","2":"I D fB","66":"E F A"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB","2":"gB VB H a I D E F A B C J K L M N O b c d e iB jB","66":"f","129":"LB MB NB OB PB QB RB SB YB ZB","388":"aB R S T hB U V W X P Y Z G"},D:{"1":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V","2":"H a I D E F A B C J K L M N O b c d","1540":"W X P Y Z G kB lB mB"},E:{"1":"D E F A B C J qB rB cB TB UB","2":"H a I nB bB oB pB","513":"K sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB UB","2":"F B C vB wB xB yB TB dB zB","1540":"QB RB SB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB"},H:{"1":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"1":"A","2":"D"},K:{"1":"Q UB","2":"A B C TB dB"},L:{"1":"G"},M:{"129":"P"},N:{"1":"B","66":"A"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"TLS 1.1"};

  var tls12={A:{A:{"1":"B","2":"I D fB","66":"E F A"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f iB jB","66":"g h i"},D:{"1":"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k"},E:{"1":"D E F A B C J K qB rB cB TB UB sB tB uB","2":"H a I nB bB oB pB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F L vB","66":"B C wB xB yB TB dB zB UB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB"},H:{"1":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"1":"A","2":"D"},K:{"1":"Q UB","2":"A B C TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"B","66":"A"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"TLS 1.2"};

  var tls13={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","132":"FB XB Q","450":"7 8 9 AB BB CB DB EB WB"},D:{"1":"NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","706":"AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB"},E:{"1":"K tB uB","2":"H a I D E F A B C nB bB oB pB qB rB cB TB","1028":"J UB sB"},F:{"1":"DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB","706":"AB BB CB"},G:{"1":"CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"cB WC XC YC ZC","2":"H RC SC TC UC VC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:6,C:"TLS 1.3"};

  var tokenBinding={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K","194":"R S T U V W X P Y Z G","257":"L M N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y iB jB","16":"Z G"},D:{"2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u","16":"0 1 2 3 4 5 6 7 8 9 v w x y z AB BB CB DB","194":"EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"H a I D E nB bB oB pB qB","16":"F A B C J K rB cB TB UB sB tB uB"},F:{"2":"F B C L M N O b c d e f g h i j k l vB wB xB yB TB dB zB UB","16":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B","16":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"16":"JC"},I:{"2":"VB H KC LC MC NC eB OC PC","16":"G"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","16":"Q"},L:{"16":"G"},M:{"16":"P"},N:{"2":"A","16":"B"},O:{"16":"QC"},P:{"16":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"16":"aC"},R:{"16":"bC"},S:{"2":"cC"}},B:6,C:"Token Binding"};

  var touch={A:{A:{"2":"I D E F fB","8":"A B"},B:{"1":"R S T U V W X P Y Z G","578":"C J K L M N O"},C:{"1":"8 9 O b c d e f g AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB","4":"H a I D E F A B C J K L M N","194":"0 1 2 3 4 5 6 7 h i j k l m n o p q r s t u v w x y z"},D:{"1":"0 1 2 3 4 5 6 7 8 9 e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H G KC LC MC NC eB OC PC"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"8":"A","260":"B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:2,C:"Touch events"};

  var transforms2d={A:{A:{"2":"fB","8":"I D E","129":"A B","161":"F"},B:{"1":"N O R S T U V W X P Y Z G","129":"C J K L M"},C:{"1":"0 1 2 3 4 5 6 7 8 9 M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB","33":"H a I D E F A B C J K L iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","33":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r"},E:{"1":"F A B C J K rB cB TB UB sB tB uB","33":"H a I D E nB bB oB pB qB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB UB","2":"F vB wB","33":"B C L M N O b c d e xB yB TB dB zB"},G:{"1":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","33":"E bB 0B eB 1B 2B 3B 4B"},H:{"2":"JC"},I:{"1":"G","33":"VB H KC LC MC NC eB OC PC"},J:{"33":"D A"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"CSS3 2D Transforms"};

  var transforms3d={A:{A:{"2":"I D E F fB","132":"A B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F iB jB","33":"A B C J K L"},D:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B","33":"C J K L M N O b c d e f g h i j k l m n o p q r"},E:{"2":"nB bB","33":"H a I D E oB pB qB","257":"F A B C J K rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB","33":"L M N O b c d e"},G:{"33":"E bB 0B eB 1B 2B 3B 4B","257":"5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"KC LC MC","33":"VB H NC eB OC PC"},J:{"33":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"132":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:5,C:"CSS3 3D Transforms"};

  var trustedTypes={A:{A:{"2":"I D E F A B fB"},B:{"1":"U V W X P Y Z G","2":"C J K L M N O R S T"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"YC ZC","2":"H RC SC TC UC VC cB WC XC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"Trusted Types for DOM manipulation"};

  var ttf={A:{A:{"2":"I D E fB","132":"F A B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB VB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB wB xB yB TB dB zB UB","2":"F vB"},G:{"1":"E eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B"},H:{"2":"JC"},I:{"1":"VB H G LC MC NC eB OC PC","2":"KC"},J:{"1":"D A"},K:{"1":"A B C Q TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"132":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"TTF/OTF - TrueType and OpenType font support"};

  var typedarrays={A:{A:{"1":"B","2":"I D E F fB","132":"A"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB","260":"oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB","2":"F B vB wB xB yB TB dB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B","260":"eB"},H:{"1":"JC"},I:{"1":"H G NC eB OC PC","2":"VB KC LC MC"},J:{"1":"A","2":"D"},K:{"1":"C Q UB","2":"A B TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"132":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"Typed Arrays"};

  var u2f={A:{A:{"2":"I D E F A B fB"},B:{"2":"C J K L M N O","513":"R S T U V W X P Y Z G"},C:{"1":"KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","322":"3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB"},D:{"2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t","130":"u v w","513":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"J K sB tB uB","2":"H a I D E F A B C nB bB oB pB qB rB cB TB UB"},F:{"2":"F B C L M N O b c d e f g h i j k l m n o p q r s t u v x vB wB xB yB TB dB zB UB","513":"0 1 2 3 4 5 6 7 8 9 w y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"1":"FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"2":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"322":"cC"}},B:6,C:"FIDO U2F API"};

  var unhandledrejection={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB iB jB"},D:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"B C J K TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r vB wB xB yB TB dB zB UB"},G:{"1":"AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B","16":"9B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:1,C:"unhandledrejection/rejectionhandled events"};

  var upgradeinsecurerequests={A:{A:{"2":"I D E F A B fB"},B:{"1":"N O R S T U V W X P Y Z G","2":"C J K L M"},C:{"1":"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l vB wB xB yB TB dB zB UB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"Upgrade Insecure Requests"};

  var urlScrollToTextFragment={A:{A:{"2":"I D E F A B fB"},B:{"1":"U V W X P Y Z G","2":"C J K L M N O","66":"R S T"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB","66":"RB SB YB ZB aB R S"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB vB wB xB yB TB dB zB UB","66":"JB KB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"YC ZC","2":"H RC SC TC UC VC cB WC XC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:7,C:"URL Scroll-To-Text Fragment"};

  var url$3={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e","130":"f g h i j k l m n"},E:{"1":"E F A B C J K qB rB cB TB UB sB tB uB","2":"H a I nB bB oB pB","130":"D"},F:{"1":"0 1 2 3 4 5 6 7 8 9 b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB","130":"L M N O"},G:{"1":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B","130":"3B"},H:{"2":"JC"},I:{"1":"G PC","2":"VB H KC LC MC NC eB","130":"OC"},J:{"2":"D","130":"A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"URL API"};

  var urlsearchparams={A:{A:{"2":"I D E F A B fB"},B:{"1":"N O R S T U V W X P Y Z G","2":"C J K L M"},C:{"1":"0 1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k iB jB","132":"l m n o p q r s t u v w x y z"},D:{"1":"5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"1":"B C J K cB TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r vB wB xB yB TB dB zB UB"},G:{"1":"8B 9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"RC SC TC UC VC cB WC XC YC ZC","2":"H"},Q:{"1":"aC"},R:{"2":"bC"},S:{"1":"cC"}},B:1,C:"URLSearchParams"};

  var useStrict={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C"},E:{"1":"I D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H nB bB","132":"a oB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB","2":"F B vB wB xB yB TB dB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB"},H:{"1":"JC"},I:{"1":"VB H G NC eB OC PC","2":"KC LC MC"},J:{"1":"D A"},K:{"1":"C Q dB UB","2":"A B TB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"ECMAScript 5 Strict Mode"};

  var userSelectNone={A:{A:{"2":"I D E F fB","33":"A B"},B:{"1":"R S T U V W X P Y Z G","33":"C J K L M N O"},C:{"1":"MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","33":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB iB jB"},D:{"1":"AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","33":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z"},E:{"33":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB","33":"L M N O b c d e f g h i j k l m n o p q r s t u v w"},G:{"33":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","33":"VB H KC LC MC NC eB OC PC"},J:{"33":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"33":"A B"},O:{"2":"QC"},P:{"1":"SC TC UC VC cB WC XC YC ZC","33":"H RC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"33":"cC"}},B:5,C:"CSS user-select: none"};

  var userTiming={A:{A:{"1":"A B","2":"I D E F fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g"},E:{"1":"B C J K TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"User Timing API"};

  var variableFonts={A:{A:{"2":"I D E F A B fB"},B:{"1":"N O R S T U V W X P Y Z G","2":"C J K L M"},C:{"2":"0 1 2 3 4 5 6 7 8 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","4609":"Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","4674":"XB","5698":"FB","7490":"9 AB BB CB DB","7746":"EB WB"},D:{"1":"KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB","4097":"JB","4290":"WB FB XB","6148":"Q GB HB IB"},E:{"2":"H a I D E F A nB bB oB pB qB rB cB","4609":"B C TB UB","8193":"J K sB tB uB"},F:{"1":"AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"0 1 2 3 4 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z vB wB xB yB TB dB zB UB","4097":"9","6148":"5 6 7 8"},G:{"1":"DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B","4097":"9B AC BC CC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"4097":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC","4097":"UC VC cB WC XC YC ZC"},Q:{"4097":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:5,C:"Variable fonts"};

  var vectorEffect={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","16":"H a I D E F A B C J K"},E:{"1":"I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"H a nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB zB UB","2":"F B vB wB xB yB TB dB"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB"},H:{"1":"JC"},I:{"1":"G OC PC","16":"VB H KC LC MC NC eB"},J:{"16":"D A"},K:{"1":"C Q UB","2":"A B TB dB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"SVG vector-effect: non-scaling-stroke"};

  var vibration={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M N O"},C:{"1":"0 1 2 3 4 5 6 7 8 9 M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A iB jB","33":"B C J K L"},D:{"1":"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"A","2":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:2,C:"Vibration API"};

  var video={A:{A:{"1":"F A B","2":"I D E fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB","260":"H a I D E F A B C J K L M N O b iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A oB pB qB rB cB","2":"nB bB","513":"B C J K TB UB sB tB uB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","2":"F vB wB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B","513":"9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H G MC NC eB OC PC","132":"KC LC"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"1":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"Video element"};

  var videotracks={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O","322":"R S T U V W X P Y Z G"},C:{"2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o iB jB","194":"0 1 2 3 4 5 6 7 8 9 p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G"},D:{"2":"0 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","322":"1 2 3 4 5 6 7 8 9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a I nB bB oB"},F:{"2":"F B C L M N O b c d e f g h i j k l m n vB wB xB yB TB dB zB UB","322":"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB"},G:{"1":"E 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B 2B"},H:{"2":"JC"},I:{"2":"VB H G KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C TB dB UB","322":"Q"},L:{"322":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"2":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"194":"cC"}},B:1,C:"Video Tracks"};

  var viewportUnits={A:{A:{"2":"I D E fB","132":"F","260":"A B"},B:{"1":"M N O R S T U V W X P Y Z G","260":"C J K L"},C:{"1":"0 1 2 3 4 5 6 7 8 9 b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b","260":"c d e f g h"},E:{"1":"D E F A B C J K pB qB rB cB TB UB sB tB uB","2":"H a nB bB oB","260":"I"},F:{"1":"0 1 2 3 4 5 6 7 8 9 L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C vB wB xB yB TB dB zB UB"},G:{"1":"E 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","2":"bB 0B eB 1B","516":"3B","772":"2B"},H:{"2":"JC"},I:{"1":"G OC PC","2":"VB H KC LC MC NC eB"},J:{"1":"A","2":"D"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"260":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:4,C:"Viewport units: vw, vh, vmin, vmax"};

  var waiAria={A:{A:{"2":"I D fB","4":"E F A B"},B:{"4":"C J K L M N O R S T U V W X P Y Z G"},C:{"4":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"4":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"2":"nB bB","4":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB"},F:{"2":"F","4":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"4":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"4":"JC"},I:{"2":"VB H KC LC MC NC eB","4":"G OC PC"},J:{"2":"D A"},K:{"4":"A B C Q TB dB UB"},L:{"4":"G"},M:{"4":"P"},N:{"4":"A B"},O:{"2":"QC"},P:{"4":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"4":"aC"},R:{"4":"bC"},S:{"4":"cC"}},B:2,C:"WAI-ARIA Accessibility features"};

  var wakeLock={A:{A:{"2":"I D E F A B fB"},B:{"1":"G","2":"C J K L M N O","194":"R S T U V W X P Y Z"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB","194":"OB PB QB RB SB YB ZB aB R S T U V"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"1":"QB RB SB","2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB vB wB xB yB TB dB zB UB","194":"EB FB Q GB HB IB JB KB LB MB NB OB PB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"2":"A B C Q TB dB UB"},L:{"1":"G"},M:{"2":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"ZC","2":"H RC SC TC UC VC cB WC XC YC"},Q:{"2":"aC"},R:{"2":"bC"},S:{"2":"cC"}},B:4,C:"Screen Wake Lock API"};

  var wasm={A:{A:{"2":"I D E F A B fB"},B:{"1":"M N O R S T U V W X P Y Z G","2":"C J K","578":"L"},C:{"1":"9 AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G","2":"0 1 2 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z iB jB","194":"3 4 5 6 7","1025":"8"},D:{"1":"DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"0 1 2 3 4 5 6 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z","322":"7 8 9 AB BB CB"},E:{"1":"B C J K TB UB sB tB uB","2":"H a I D E F A nB bB oB pB qB rB cB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB","2":"F B C L M N O b c d e f g h i j k l m n o p q r s t vB wB xB yB TB dB zB UB","322":"u v w x y z"},G:{"1":"9B AC BC CC DC EC FC GC HC IC","2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"2":"QC"},P:{"1":"TC UC VC cB WC XC YC ZC","2":"H RC SC"},Q:{"1":"aC"},R:{"2":"bC"},S:{"194":"cC"}},B:6,C:"WebAssembly"};

  var wav={A:{A:{"2":"I D E F A B fB"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB","2":"gB VB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D"},E:{"1":"H a I D E F A B C J K oB pB qB rB cB TB UB sB tB uB","2":"nB bB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB xB yB TB dB zB UB","2":"F vB wB"},G:{"1":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","16":"A"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:6,C:"Wav audio format"};

  var wbrElement={A:{A:{"1":"I D fB","2":"E F A B"},B:{"1":"C J K L M N O R S T U V W X P Y Z G"},C:{"1":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T hB U V W X P Y Z G iB jB"},D:{"1":"0 1 2 3 4 5 6 7 8 9 H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB"},E:{"1":"H a I D E F A B C J K bB oB pB qB rB cB TB UB sB tB uB","16":"nB"},F:{"1":"0 1 2 3 4 5 6 7 8 9 B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB","16":"F"},G:{"1":"E 1B 2B 3B 4B 5B 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC","16":"bB 0B eB"},H:{"1":"JC"},I:{"1":"VB H G MC NC eB OC PC","16":"KC LC"},J:{"1":"D A"},K:{"1":"B C Q TB dB UB","2":"A"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"1":"cC"}},B:1,C:"wbr (word break opportunity) element"};

  var webAnimation={A:{A:{"2":"I D E F A B fB"},B:{"1":"V W X P Y Z G","2":"C J K L M N O","260":"R S T U"},C:{"1":"T hB U V W X P Y Z G","2":"gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o iB jB","260":"WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB","516":"3 4 5 6 7 8 9 AB BB CB DB EB","580":"0 1 2 p q r s t u v w x y z","2049":"SB YB ZB aB R S"},D:{"1":"V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r","132":"s t u","260":"0 1 2 3 4 5 6 7 8 9 v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U"},E:{"1":"uB","2":"H a I D E F A nB bB oB pB qB rB cB","1090":"B C J TB UB","2049":"K sB tB"},F:{"1":"OB PB QB RB SB","2":"F B C L M N O b c d e vB wB xB yB TB dB zB UB","132":"f g h","260":"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B","1090":"9B AC BC CC DC EC FC","2049":"GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"260":"QC"},P:{"260":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"260":"aC"},R:{"260":"bC"},S:{"516":"cC"}},B:5,C:"Web Animations API"};

  var webAppManifest={A:{A:{"2":"I D E F A B fB"},B:{"1":"R S T U V W X P Y Z G","2":"C J K L M","130":"N O"},C:{"2":"0 1 2 3 4 5 6 7 8 9 gB VB H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB X P Y Z G iB jB","578":"YB ZB aB R S T hB U V W"},D:{"1":"0 1 2 3 4 5 6 7 8 9 v w x y z AB BB CB DB EB WB FB XB Q GB HB IB JB KB LB MB NB OB PB QB RB SB YB ZB aB R S T U V W X P Y Z G kB lB mB","2":"H a I D E F A B C J K L M N O b c d e f g h i j k l m n o p q r s t u"},E:{"2":"H a I D E F A B C J K nB bB oB pB qB rB cB TB UB sB tB uB"},F:{"2":"0 1 2 3 4 5 6 7 8 9 F B C L M N O b c d e f g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB Q GB HB IB JB KB LB MB NB OB PB QB RB SB vB wB xB yB TB dB zB UB"},G:{"2":"E bB 0B eB 1B 2B 3B 4B 5B 6B 7B 8B 9B","260":"AC BC CC DC EC FC GC HC IC"},H:{"2":"JC"},I:{"1":"G","2":"VB H KC LC MC NC eB OC PC"},J:{"2":"D A"},K:{"1":"Q","2":"A B C TB dB UB"},L:{"1":"G"},M:{"1":"P"},N:{"2":"A B"},O:{"1":"QC"},P:{"1":"H RC SC TC UC VC cB WC XC YC ZC"},Q:{"1":"aC"},R:{"1":"bC"},S:{"2":"cC"}},B:5,C:"Add to home screen (A2HS)"};

  var webBlu