/*
 * Microsoft Application Insights properties plugin, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 *
 * Microsoft Application Insights Team
 * https://github.com/microsoft/ApplicationInsights-JS#readme
 */

declare namespace ApplicationInsights {
    import { BaseTelemetryPlugin } from '@microsoft/applicationinsights-core-js';
    import { IAppInsightsCore } from '@microsoft/applicationinsights-core-js';
    import { IApplication } from '@microsoft/applicationinsights-common';
    import { IConfig } from '@microsoft/applicationinsights-common';
    import { IConfiguration } from '@microsoft/applicationinsights-core-js';
    import { IDevice } from '@microsoft/applicationinsights-common';
    import { IDiagnosticLogger } from '@microsoft/applicationinsights-core-js';
    import { IDistributedTraceContext } from '@microsoft/applicationinsights-core-js';
    import { IInternal } from '@microsoft/applicationinsights-common';
    import { ILocation } from '@microsoft/applicationinsights-common';
    import { IOperatingSystem } from '@microsoft/applicationinsights-common';
    import { IPlugin } from '@microsoft/applicationinsights-core-js';
    import { IProcessTelemetryContext } from '@microsoft/applicationinsights-core-js';
    import { IPropertiesPlugin } from '@microsoft/applicationinsights-common';
    import { ISession } from '@microsoft/applicationinsights-common';
    import { ITelemetryContext } from '@microsoft/applicationinsights-common';
    import { ITelemetryItem } from '@microsoft/applicationinsights-core-js';
    import { ITelemetryPluginChain } from '@microsoft/applicationinsights-core-js';
    import { ITelemetryTrace } from '@microsoft/applicationinsights-common';
    import { ITraceState } from '@microsoft/applicationinsights-common';
    import { IUserContext } from '@microsoft/applicationinsights-common';
    import { IWeb } from '@microsoft/applicationinsights-common';

    interface IPropTelemetryContext extends ITelemetryContext {
        readonly sessionManager: SessionManager;
        applySessionContext(evt: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        applyOperatingSystemContxt(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        applyApplicationContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        applyDeviceContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        applyInternalContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        applyLocationContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        applyOperationContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        applyWebContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        applyUserContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        cleanUp(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
    }

    interface ISessionConfig {
        sessionRenewalMs?: () => number;
        sessionExpirationMs?: () => number;
        namePrefix?: () => string;
        sessionCookiePostfix?: () => string;
        idLength?: () => number;
        getNewId?: () => (idLength?: number) => string;
        /**
         * @deprecated Avoid using this value to override the cookie manager cookie domain.
         */
        cookieDomain?: () => string;
    }

    interface ITelemetryConfig {
        instrumentationKey: () => string;
        accountId: () => string;
        sessionRenewalMs: () => number;
        samplingPercentage: () => number;
        sessionExpirationMs: () => number;
        cookieDomain: () => null;
        sdkExtension: () => string;
        isBrowserLinkTrackingEnabled: () => boolean;
        appId: () => string;
        getSessionId: () => string;
        namePrefix: () => string;
        sessionCookiePostfix: () => string;
        userCookiePostfix: () => string;
        idLength: () => number;
        getNewId: () => (idLength?: number) => string;
    }

    class PropertiesPlugin extends BaseTelemetryPlugin implements IPropertiesPlugin {
        static getDefaultConfig(): ITelemetryConfig;
        context: IPropTelemetryContext;
        priority: number;
        identifier: string;
        constructor();
        initialize(config: IConfiguration & IConfig, core: IAppInsightsCore, extensions: IPlugin[], pluginChain?: ITelemetryPluginChain): void;
        /**
         * Add Part A fields to the event
         * @param event The event that needs to be processed
         */
        processTelemetry(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
    }

    class Session implements ISession {
        /**
         * The session ID.
         */
        id?: string;
        /**
         * The date at which this guid was generated.
         * Per the spec the ID will be regenerated if more than acquisitionSpan milliseconds elapsed from this time.
         */
        acquisitionDate?: number;
        /**
         * The date at which this session ID was last reported.
         * This value should be updated whenever telemetry is sent using this ID.
         * Per the spec the ID will be regenerated if more than renewalSpan milliseconds elapse from this time with no activity.
         */
        renewalDate?: number;
    }

    class SessionManager {
        static acquisitionSpan: number;
        static renewalSpan: number;
        static cookieUpdateInterval: number;
        automaticSession: Session;
        config: ISessionConfig;
        constructor(config: ISessionConfig, core?: IAppInsightsCore);
        update(): void;
        /**
         *  Record the current state of the automatic session and store it in our cookie string format
         *  into the browser's local storage. This is used to restore the session data when the cookie
         *  expires.
         */
        backup(): void;
    }

    class TelemetryContext implements IPropTelemetryContext {
        application: IApplication;
        device: IDevice;
        location: ILocation;
        telemetryTrace: ITelemetryTrace;
        user: IUserContext;
        internal: IInternal;
        session: ISession;
        sessionManager: SessionManager;
        os: IOperatingSystem;
        web: IWeb;
        appId: () => string;
        getSessionId: () => string;
        constructor(core: IAppInsightsCore, defaultConfig: ITelemetryConfig, previousTraceCtx?: IDistributedTraceContext);
        applySessionContext(evt: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        applyOperatingSystemContxt(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        applyApplicationContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        applyDeviceContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        applyInternalContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        applyLocationContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        applyOperationContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        applyWebContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        applyUserContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        cleanUp(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
    }

    class TelemetryTrace implements ITelemetryTrace {
        traceID: string;
        parentID: string;
        traceState: ITraceState;
        traceFlags: number;
        name: string;
        constructor(id?: string, parentId?: string, name?: string, logger?: IDiagnosticLogger);
    }

    
}