import { IMessageData } from "../Interfaces/Contracts/IMessageData";
import { ISerializable } from "../Interfaces/Telemetry/ISerializable";
import { FieldType } from "../Enums";
import { SeverityLevel } from "../Interfaces/Contracts/SeverityLevel";
import { IDiagnosticLogger } from "@microsoft/applicationinsights-core-js";
export declare class Trace implements IMessageData, ISerializable {
    static envelopeType: string;
    static dataType: string;
    aiDataContract: {
        ver: FieldType;
        message: FieldType;
        severityLevel: FieldType;
        properties: FieldType;
    };
    /**
     * Schema version
     */
    ver: number;
    /**
     * Trace message
     */
    message: string;
    /**
     * Trace severity level.
     */
    severityLevel: SeverityLevel;
    /**
     * Collection of custom properties.
     */
    properties: any;
    /**
     * Collection of custom measurements.
     */
    measurements: any;
    /**
     * Constructs a new instance of the TraceTelemetry object
     */
    constructor(logger: IDiagnosticLogger, message: string, severityLevel?: SeverityLevel, properties?: any, measurements?: {
        [key: string]: number;
    });
}
