import { IPageViewPerfData } from "../Interfaces/Contracts/IPageViewPerfData";
import { FieldType } from "../Enums";
import { ISerializable } from "../Interfaces/Telemetry/ISerializable";
import { IDiagnosticLogger } from "@microsoft/applicationinsights-core-js";
import { IPageViewPerformanceTelemetry } from "../Interfaces/IPageViewPerformanceTelemetry";
export declare class PageViewPerformance implements IPageViewPerfData, ISerializable {
    static envelopeType: string;
    static dataType: string;
    aiDataContract: {
        ver: FieldType;
        name: FieldType;
        url: FieldType;
        duration: FieldType;
        perfTotal: FieldType;
        networkConnect: FieldType;
        sentRequest: FieldType;
        receivedResponse: FieldType;
        domProcessing: FieldType;
        properties: FieldType;
        measurements: FieldType;
    };
    /**
     * Schema version
     */
    ver: number;
    /**
     * Event name. Keep it low cardinality to allow proper grouping and useful metrics.
     */
    name: string;
    /**
     * Collection of custom properties.
     */
    properties: any;
    /**
     * Collection of custom measurements.
     */
    measurements: any;
    /**
     * Request URL with all query string parameters
     */
    url: string;
    /**
     * Request duration in format: DD.HH:MM:SS.MMMMMM. For a page view (PageViewData), this is the duration. For a page view with performance information (PageViewPerfData), this is the page load time. Must be less than 1000 days.
     */
    duration: string;
    /**
     * Identifier of a page view instance. Used for correlation between page view and other telemetry items.
     */
    id: string;
    /**
     * Performance total in TimeSpan 'G' (general long) format: d:hh:mm:ss.fffffff
     */
    perfTotal: string;
    /**
     * Network connection time in TimeSpan 'G' (general long) format: d:hh:mm:ss.fffffff
     */
    networkConnect: string;
    /**
     * Sent request time in TimeSpan 'G' (general long) format: d:hh:mm:ss.fffffff
     */
    sentRequest: string;
    /**
     * Received response time in TimeSpan 'G' (general long) format: d:hh:mm:ss.fffffff
     */
    receivedResponse: string;
    /**
     * DOM processing time in TimeSpan 'G' (general long) format: d:hh:mm:ss.fffffff
     */
    domProcessing: string;
    /**
     * Constructs a new instance of the PageEventTelemetry object
     */
    constructor(logger: IDiagnosticLogger, name: string, url: string, unused: number, properties?: {
        [key: string]: string;
    }, measurements?: {
        [key: string]: number;
    }, cs4BaseData?: IPageViewPerformanceTelemetry);
}
